/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.CustomerEntitlementCollection;
import com.stripe.model.HasId;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.CustomerEntitlementListParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class CustomerEntitlement
extends ApiResource
implements HasId {
    @SerializedName(value="feature")
    String feature;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="lookup_key")
    String lookupKey;
    @SerializedName(value="object")
    String object;

    public static CustomerEntitlementCollection list(String customer, Map<String, Object> params) throws StripeException {
        return CustomerEntitlement.list(customer, params, (RequestOptions)null);
    }

    public static CustomerEntitlementCollection list(String customer, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/entitlements", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (CustomerEntitlementCollection)CustomerEntitlement.getGlobalResponseGetter().request(request, (Type)((Object)CustomerEntitlementCollection.class));
    }

    public static CustomerEntitlementCollection list(String customer, CustomerEntitlementListParams params) throws StripeException {
        return CustomerEntitlement.list(customer, params, (RequestOptions)null);
    }

    public static CustomerEntitlementCollection list(String customer, CustomerEntitlementListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/entitlements", ApiResource.urlEncodeId(customer));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CustomerEntitlementCollection)CustomerEntitlement.getGlobalResponseGetter().request(request, (Type)((Object)CustomerEntitlementCollection.class));
    }

    @Generated
    public String getFeature() {
        return this.feature;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getLookupKey() {
        return this.lookupKey;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setFeature(String feature) {
        this.feature = feature;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerEntitlement)) {
            return false;
        }
        CustomerEntitlement other = (CustomerEntitlement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$feature = this.getFeature();
        String other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !this$feature.equals(other$feature)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lookupKey = this.getLookupKey();
        String other$lookupKey = other.getLookupKey();
        if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomerEntitlement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : $feature.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lookupKey = this.getLookupKey();
        result = result * 59 + ($lookupKey == null ? 43 : $lookupKey.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

