/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.identity;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.identity.VerificationSession;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.identity.VerificationSessionCancelParams;
import com.stripe.param.identity.VerificationSessionCreateParams;
import com.stripe.param.identity.VerificationSessionListParams;
import com.stripe.param.identity.VerificationSessionRedactParams;
import com.stripe.param.identity.VerificationSessionRetrieveParams;
import com.stripe.param.identity.VerificationSessionUpdateParams;
import java.lang.reflect.Type;

public final class VerificationSessionService
extends ApiService {
    public VerificationSessionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<VerificationSession> list(VerificationSessionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<VerificationSession> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<VerificationSession> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<VerificationSession> list(VerificationSessionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/verification_sessions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<VerificationSession>>(){}.getType());
    }

    public VerificationSession create(VerificationSessionCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public VerificationSession create(VerificationSessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/verification_sessions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (VerificationSession)this.request(request, (Type)((Object)VerificationSession.class));
    }

    public VerificationSession retrieve(String session, VerificationSessionRetrieveParams params) throws StripeException {
        return this.retrieve(session, params, null);
    }

    public VerificationSession retrieve(String session, RequestOptions options) throws StripeException {
        return this.retrieve(session, null, options);
    }

    public VerificationSession retrieve(String session) throws StripeException {
        return this.retrieve(session, null, null);
    }

    public VerificationSession retrieve(String session, VerificationSessionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(session));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (VerificationSession)this.request(request, (Type)((Object)VerificationSession.class));
    }

    public VerificationSession update(String session, VerificationSessionUpdateParams params) throws StripeException {
        return this.update(session, params, null);
    }

    public VerificationSession update(String session, RequestOptions options) throws StripeException {
        return this.update(session, null, options);
    }

    public VerificationSession update(String session) throws StripeException {
        return this.update(session, null, null);
    }

    public VerificationSession update(String session, VerificationSessionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(session));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (VerificationSession)this.request(request, (Type)((Object)VerificationSession.class));
    }

    public VerificationSession cancel(String session, VerificationSessionCancelParams params) throws StripeException {
        return this.cancel(session, params, null);
    }

    public VerificationSession cancel(String session, RequestOptions options) throws StripeException {
        return this.cancel(session, null, options);
    }

    public VerificationSession cancel(String session) throws StripeException {
        return this.cancel(session, null, null);
    }

    public VerificationSession cancel(String session, VerificationSessionCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s/cancel", ApiResource.urlEncodeId(session));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (VerificationSession)this.request(request, (Type)((Object)VerificationSession.class));
    }

    public VerificationSession redact(String session, VerificationSessionRedactParams params) throws StripeException {
        return this.redact(session, params, null);
    }

    public VerificationSession redact(String session, RequestOptions options) throws StripeException {
        return this.redact(session, null, options);
    }

    public VerificationSession redact(String session) throws StripeException {
        return this.redact(session, null, null);
    }

    public VerificationSession redact(String session, VerificationSessionRedactParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s/redact", ApiResource.urlEncodeId(session));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (VerificationSession)this.request(request, (Type)((Object)VerificationSession.class));
    }
}

