/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PriceCollection;
import com.stripe.model.PriceSearchResult;
import com.stripe.model.Product;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PriceCreateParams;
import com.stripe.param.PriceListParams;
import com.stripe.param.PriceRetrieveParams;
import com.stripe.param.PriceSearchParams;
import com.stripe.param.PriceUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Price
extends ApiResource
implements HasId,
MetadataStore<Price> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="billing_scheme")
    String billingScheme;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="currency_options")
    Map<String, CurrencyOption> currencyOptions;
    @SerializedName(value="custom_unit_amount")
    CustomUnitAmount customUnitAmount;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="lookup_key")
    String lookupKey;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="migrate_to")
    MigrateTo migrateTo;
    @SerializedName(value="nickname")
    String nickname;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="product")
    ExpandableField<Product> product;
    @SerializedName(value="recurring")
    Recurring recurring;
    @SerializedName(value="tax_behavior")
    String taxBehavior;
    @SerializedName(value="tiers")
    List<Tier> tiers;
    @SerializedName(value="tiers_mode")
    String tiersMode;
    @SerializedName(value="transform_quantity")
    TransformQuantity transformQuantity;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="unit_amount")
    Long unitAmount;
    @SerializedName(value="unit_amount_decimal")
    BigDecimal unitAmountDecimal;

    public String getProduct() {
        return this.product != null ? this.product.getId() : null;
    }

    public void setProduct(String id) {
        this.product = ApiResource.setExpandableFieldId(id, this.product);
    }

    public Product getProductObject() {
        return this.product != null ? this.product.getExpanded() : null;
    }

    public void setProductObject(Product expandableObject) {
        this.product = new ExpandableField<Product>(expandableObject.getId(), expandableObject);
    }

    public static Price create(Map<String, Object> params) throws StripeException {
        return Price.create(params, (RequestOptions)null);
    }

    public static Price create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/prices";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Price)Price.getGlobalResponseGetter().request(request, (Type)((Object)Price.class));
    }

    public static Price create(PriceCreateParams params) throws StripeException {
        return Price.create(params, (RequestOptions)null);
    }

    public static Price create(PriceCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/prices";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Price)Price.getGlobalResponseGetter().request(request, (Type)((Object)Price.class));
    }

    public static PriceCollection list(Map<String, Object> params) throws StripeException {
        return Price.list(params, (RequestOptions)null);
    }

    public static PriceCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/prices";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (PriceCollection)Price.getGlobalResponseGetter().request(request, (Type)((Object)PriceCollection.class));
    }

    public static PriceCollection list(PriceListParams params) throws StripeException {
        return Price.list(params, (RequestOptions)null);
    }

    public static PriceCollection list(PriceListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/prices";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PriceCollection)Price.getGlobalResponseGetter().request(request, (Type)((Object)PriceCollection.class));
    }

    public static Price retrieve(String price) throws StripeException {
        return Price.retrieve(price, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Price retrieve(String price, RequestOptions options) throws StripeException {
        return Price.retrieve(price, (Map<String, Object>)null, options);
    }

    public static Price retrieve(String price, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/prices/%s", ApiResource.urlEncodeId(price));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Price)Price.getGlobalResponseGetter().request(request, (Type)((Object)Price.class));
    }

    public static Price retrieve(String price, PriceRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/prices/%s", ApiResource.urlEncodeId(price));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Price)Price.getGlobalResponseGetter().request(request, (Type)((Object)Price.class));
    }

    public static PriceSearchResult search(Map<String, Object> params) throws StripeException {
        return Price.search(params, (RequestOptions)null);
    }

    public static PriceSearchResult search(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/prices/search";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (PriceSearchResult)Price.getGlobalResponseGetter().request(request, (Type)((Object)PriceSearchResult.class));
    }

    public static PriceSearchResult search(PriceSearchParams params) throws StripeException {
        return Price.search(params, (RequestOptions)null);
    }

    public static PriceSearchResult search(PriceSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/prices/search";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PriceSearchResult)Price.getGlobalResponseGetter().request(request, (Type)((Object)PriceSearchResult.class));
    }

    public Price update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Price update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/prices/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Price)this.getResponseGetter().request(request, (Type)((Object)Price.class));
    }

    public Price update(PriceUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Price update(PriceUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/prices/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Price)this.getResponseGetter().request(request, (Type)((Object)Price.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.customUnitAmount, responseGetter);
        this.trySetResponseGetter(this.migrateTo, responseGetter);
        this.trySetResponseGetter(this.product, responseGetter);
        this.trySetResponseGetter(this.recurring, responseGetter);
        this.trySetResponseGetter(this.transformQuantity, responseGetter);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public String getBillingScheme() {
        return this.billingScheme;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Map<String, CurrencyOption> getCurrencyOptions() {
        return this.currencyOptions;
    }

    @Generated
    public CustomUnitAmount getCustomUnitAmount() {
        return this.customUnitAmount;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getLookupKey() {
        return this.lookupKey;
    }

    @Generated
    public MigrateTo getMigrateTo() {
        return this.migrateTo;
    }

    @Generated
    public String getNickname() {
        return this.nickname;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Recurring getRecurring() {
        return this.recurring;
    }

    @Generated
    public String getTaxBehavior() {
        return this.taxBehavior;
    }

    @Generated
    public List<Tier> getTiers() {
        return this.tiers;
    }

    @Generated
    public String getTiersMode() {
        return this.tiersMode;
    }

    @Generated
    public TransformQuantity getTransformQuantity() {
        return this.transformQuantity;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getUnitAmount() {
        return this.unitAmount;
    }

    @Generated
    public BigDecimal getUnitAmountDecimal() {
        return this.unitAmountDecimal;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setBillingScheme(String billingScheme) {
        this.billingScheme = billingScheme;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCurrencyOptions(Map<String, CurrencyOption> currencyOptions) {
        this.currencyOptions = currencyOptions;
    }

    @Generated
    public void setCustomUnitAmount(CustomUnitAmount customUnitAmount) {
        this.customUnitAmount = customUnitAmount;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setMigrateTo(MigrateTo migrateTo) {
        this.migrateTo = migrateTo;
    }

    @Generated
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    @Generated
    public void setTaxBehavior(String taxBehavior) {
        this.taxBehavior = taxBehavior;
    }

    @Generated
    public void setTiers(List<Tier> tiers) {
        this.tiers = tiers;
    }

    @Generated
    public void setTiersMode(String tiersMode) {
        this.tiersMode = tiersMode;
    }

    @Generated
    public void setTransformQuantity(TransformQuantity transformQuantity) {
        this.transformQuantity = transformQuantity;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUnitAmount(Long unitAmount) {
        this.unitAmount = unitAmount;
    }

    @Generated
    public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
        this.unitAmountDecimal = unitAmountDecimal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Price)) {
            return false;
        }
        Price other = (Price)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$unitAmount = this.getUnitAmount();
        Long other$unitAmount = other.getUnitAmount();
        if (this$unitAmount == null ? other$unitAmount != null : !((Object)this$unitAmount).equals(other$unitAmount)) {
            return false;
        }
        String this$billingScheme = this.getBillingScheme();
        String other$billingScheme = other.getBillingScheme();
        if (this$billingScheme == null ? other$billingScheme != null : !this$billingScheme.equals(other$billingScheme)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Map<String, CurrencyOption> this$currencyOptions = this.getCurrencyOptions();
        Map<String, CurrencyOption> other$currencyOptions = other.getCurrencyOptions();
        if (this$currencyOptions == null ? other$currencyOptions != null : !((Object)this$currencyOptions).equals(other$currencyOptions)) {
            return false;
        }
        CustomUnitAmount this$customUnitAmount = this.getCustomUnitAmount();
        CustomUnitAmount other$customUnitAmount = other.getCustomUnitAmount();
        if (this$customUnitAmount == null ? other$customUnitAmount != null : !((Object)this$customUnitAmount).equals(other$customUnitAmount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lookupKey = this.getLookupKey();
        String other$lookupKey = other.getLookupKey();
        if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        MigrateTo this$migrateTo = this.getMigrateTo();
        MigrateTo other$migrateTo = other.getMigrateTo();
        if (this$migrateTo == null ? other$migrateTo != null : !((Object)this$migrateTo).equals(other$migrateTo)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        Recurring this$recurring = this.getRecurring();
        Recurring other$recurring = other.getRecurring();
        if (this$recurring == null ? other$recurring != null : !((Object)this$recurring).equals(other$recurring)) {
            return false;
        }
        String this$taxBehavior = this.getTaxBehavior();
        String other$taxBehavior = other.getTaxBehavior();
        if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) {
            return false;
        }
        List<Tier> this$tiers = this.getTiers();
        List<Tier> other$tiers = other.getTiers();
        if (this$tiers == null ? other$tiers != null : !((Object)this$tiers).equals(other$tiers)) {
            return false;
        }
        String this$tiersMode = this.getTiersMode();
        String other$tiersMode = other.getTiersMode();
        if (this$tiersMode == null ? other$tiersMode != null : !this$tiersMode.equals(other$tiersMode)) {
            return false;
        }
        TransformQuantity this$transformQuantity = this.getTransformQuantity();
        TransformQuantity other$transformQuantity = other.getTransformQuantity();
        if (this$transformQuantity == null ? other$transformQuantity != null : !((Object)this$transformQuantity).equals(other$transformQuantity)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BigDecimal this$unitAmountDecimal = this.getUnitAmountDecimal();
        BigDecimal other$unitAmountDecimal = other.getUnitAmountDecimal();
        return !(this$unitAmountDecimal == null ? other$unitAmountDecimal != null : !((Object)this$unitAmountDecimal).equals(other$unitAmountDecimal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Price;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $unitAmount = this.getUnitAmount();
        result = result * 59 + ($unitAmount == null ? 43 : ((Object)$unitAmount).hashCode());
        String $billingScheme = this.getBillingScheme();
        result = result * 59 + ($billingScheme == null ? 43 : $billingScheme.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Map<String, CurrencyOption> $currencyOptions = this.getCurrencyOptions();
        result = result * 59 + ($currencyOptions == null ? 43 : ((Object)$currencyOptions).hashCode());
        CustomUnitAmount $customUnitAmount = this.getCustomUnitAmount();
        result = result * 59 + ($customUnitAmount == null ? 43 : ((Object)$customUnitAmount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lookupKey = this.getLookupKey();
        result = result * 59 + ($lookupKey == null ? 43 : $lookupKey.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        MigrateTo $migrateTo = this.getMigrateTo();
        result = result * 59 + ($migrateTo == null ? 43 : ((Object)$migrateTo).hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        Recurring $recurring = this.getRecurring();
        result = result * 59 + ($recurring == null ? 43 : ((Object)$recurring).hashCode());
        String $taxBehavior = this.getTaxBehavior();
        result = result * 59 + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
        List<Tier> $tiers = this.getTiers();
        result = result * 59 + ($tiers == null ? 43 : ((Object)$tiers).hashCode());
        String $tiersMode = this.getTiersMode();
        result = result * 59 + ($tiersMode == null ? 43 : $tiersMode.hashCode());
        TransformQuantity $transformQuantity = this.getTransformQuantity();
        result = result * 59 + ($transformQuantity == null ? 43 : ((Object)$transformQuantity).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BigDecimal $unitAmountDecimal = this.getUnitAmountDecimal();
        result = result * 59 + ($unitAmountDecimal == null ? 43 : ((Object)$unitAmountDecimal).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class CustomUnitAmount
    extends StripeObject {
        @SerializedName(value="maximum")
        Long maximum;
        @SerializedName(value="minimum")
        Long minimum;
        @SerializedName(value="preset")
        Long preset;

        @Generated
        public Long getMaximum() {
            return this.maximum;
        }

        @Generated
        public Long getMinimum() {
            return this.minimum;
        }

        @Generated
        public Long getPreset() {
            return this.preset;
        }

        @Generated
        public void setMaximum(Long maximum) {
            this.maximum = maximum;
        }

        @Generated
        public void setMinimum(Long minimum) {
            this.minimum = minimum;
        }

        @Generated
        public void setPreset(Long preset) {
            this.preset = preset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomUnitAmount)) {
                return false;
            }
            CustomUnitAmount other = (CustomUnitAmount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$maximum = this.getMaximum();
            Long other$maximum = other.getMaximum();
            if (this$maximum == null ? other$maximum != null : !((Object)this$maximum).equals(other$maximum)) {
                return false;
            }
            Long this$minimum = this.getMinimum();
            Long other$minimum = other.getMinimum();
            if (this$minimum == null ? other$minimum != null : !((Object)this$minimum).equals(other$minimum)) {
                return false;
            }
            Long this$preset = this.getPreset();
            Long other$preset = other.getPreset();
            return !(this$preset == null ? other$preset != null : !((Object)this$preset).equals(other$preset));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomUnitAmount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $maximum = this.getMaximum();
            result = result * 59 + ($maximum == null ? 43 : ((Object)$maximum).hashCode());
            Long $minimum = this.getMinimum();
            result = result * 59 + ($minimum == null ? 43 : ((Object)$minimum).hashCode());
            Long $preset = this.getPreset();
            result = result * 59 + ($preset == null ? 43 : ((Object)$preset).hashCode());
            return result;
        }
    }

    public static class MigrateTo
    extends StripeObject {
        @SerializedName(value="behavior")
        String behavior;
        @SerializedName(value="effective_after")
        Long effectiveAfter;
        @SerializedName(value="price")
        String price;

        @Generated
        public String getBehavior() {
            return this.behavior;
        }

        @Generated
        public Long getEffectiveAfter() {
            return this.effectiveAfter;
        }

        @Generated
        public String getPrice() {
            return this.price;
        }

        @Generated
        public void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Generated
        public void setEffectiveAfter(Long effectiveAfter) {
            this.effectiveAfter = effectiveAfter;
        }

        @Generated
        public void setPrice(String price) {
            this.price = price;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MigrateTo)) {
                return false;
            }
            MigrateTo other = (MigrateTo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$effectiveAfter = this.getEffectiveAfter();
            Long other$effectiveAfter = other.getEffectiveAfter();
            if (this$effectiveAfter == null ? other$effectiveAfter != null : !((Object)this$effectiveAfter).equals(other$effectiveAfter)) {
                return false;
            }
            String this$behavior = this.getBehavior();
            String other$behavior = other.getBehavior();
            if (this$behavior == null ? other$behavior != null : !this$behavior.equals(other$behavior)) {
                return false;
            }
            String this$price = this.getPrice();
            String other$price = other.getPrice();
            return !(this$price == null ? other$price != null : !this$price.equals(other$price));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MigrateTo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $effectiveAfter = this.getEffectiveAfter();
            result = result * 59 + ($effectiveAfter == null ? 43 : ((Object)$effectiveAfter).hashCode());
            String $behavior = this.getBehavior();
            result = result * 59 + ($behavior == null ? 43 : $behavior.hashCode());
            String $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : $price.hashCode());
            return result;
        }
    }

    public static class Recurring
    extends StripeObject {
        @SerializedName(value="aggregate_usage")
        String aggregateUsage;
        @SerializedName(value="interval")
        String interval;
        @SerializedName(value="interval_count")
        Long intervalCount;
        @SerializedName(value="meter")
        String meter;
        @SerializedName(value="trial_period_days")
        Long trialPeriodDays;
        @SerializedName(value="usage_type")
        String usageType;

        @Generated
        public String getAggregateUsage() {
            return this.aggregateUsage;
        }

        @Generated
        public String getInterval() {
            return this.interval;
        }

        @Generated
        public Long getIntervalCount() {
            return this.intervalCount;
        }

        @Generated
        public String getMeter() {
            return this.meter;
        }

        @Generated
        public Long getTrialPeriodDays() {
            return this.trialPeriodDays;
        }

        @Generated
        public String getUsageType() {
            return this.usageType;
        }

        @Generated
        public void setAggregateUsage(String aggregateUsage) {
            this.aggregateUsage = aggregateUsage;
        }

        @Generated
        public void setInterval(String interval) {
            this.interval = interval;
        }

        @Generated
        public void setIntervalCount(Long intervalCount) {
            this.intervalCount = intervalCount;
        }

        @Generated
        public void setMeter(String meter) {
            this.meter = meter;
        }

        @Generated
        public void setTrialPeriodDays(Long trialPeriodDays) {
            this.trialPeriodDays = trialPeriodDays;
        }

        @Generated
        public void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Recurring)) {
                return false;
            }
            Recurring other = (Recurring)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$intervalCount = this.getIntervalCount();
            Long other$intervalCount = other.getIntervalCount();
            if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                return false;
            }
            Long this$trialPeriodDays = this.getTrialPeriodDays();
            Long other$trialPeriodDays = other.getTrialPeriodDays();
            if (this$trialPeriodDays == null ? other$trialPeriodDays != null : !((Object)this$trialPeriodDays).equals(other$trialPeriodDays)) {
                return false;
            }
            String this$aggregateUsage = this.getAggregateUsage();
            String other$aggregateUsage = other.getAggregateUsage();
            if (this$aggregateUsage == null ? other$aggregateUsage != null : !this$aggregateUsage.equals(other$aggregateUsage)) {
                return false;
            }
            String this$interval = this.getInterval();
            String other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                return false;
            }
            String this$meter = this.getMeter();
            String other$meter = other.getMeter();
            if (this$meter == null ? other$meter != null : !this$meter.equals(other$meter)) {
                return false;
            }
            String this$usageType = this.getUsageType();
            String other$usageType = other.getUsageType();
            return !(this$usageType == null ? other$usageType != null : !this$usageType.equals(other$usageType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Recurring;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $intervalCount = this.getIntervalCount();
            result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
            Long $trialPeriodDays = this.getTrialPeriodDays();
            result = result * 59 + ($trialPeriodDays == null ? 43 : ((Object)$trialPeriodDays).hashCode());
            String $aggregateUsage = this.getAggregateUsage();
            result = result * 59 + ($aggregateUsage == null ? 43 : $aggregateUsage.hashCode());
            String $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
            String $meter = this.getMeter();
            result = result * 59 + ($meter == null ? 43 : $meter.hashCode());
            String $usageType = this.getUsageType();
            result = result * 59 + ($usageType == null ? 43 : $usageType.hashCode());
            return result;
        }
    }

    public static class TransformQuantity
    extends StripeObject {
        @SerializedName(value="divide_by")
        Long divideBy;
        @SerializedName(value="round")
        String round;

        @Generated
        public Long getDivideBy() {
            return this.divideBy;
        }

        @Generated
        public String getRound() {
            return this.round;
        }

        @Generated
        public void setDivideBy(Long divideBy) {
            this.divideBy = divideBy;
        }

        @Generated
        public void setRound(String round) {
            this.round = round;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransformQuantity)) {
                return false;
            }
            TransformQuantity other = (TransformQuantity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$divideBy = this.getDivideBy();
            Long other$divideBy = other.getDivideBy();
            if (this$divideBy == null ? other$divideBy != null : !((Object)this$divideBy).equals(other$divideBy)) {
                return false;
            }
            String this$round = this.getRound();
            String other$round = other.getRound();
            return !(this$round == null ? other$round != null : !this$round.equals(other$round));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransformQuantity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $divideBy = this.getDivideBy();
            result = result * 59 + ($divideBy == null ? 43 : ((Object)$divideBy).hashCode());
            String $round = this.getRound();
            result = result * 59 + ($round == null ? 43 : $round.hashCode());
            return result;
        }
    }

    public static class Tier
    extends StripeObject {
        @SerializedName(value="flat_amount")
        Long flatAmount;
        @SerializedName(value="flat_amount_decimal")
        BigDecimal flatAmountDecimal;
        @SerializedName(value="unit_amount")
        Long unitAmount;
        @SerializedName(value="unit_amount_decimal")
        BigDecimal unitAmountDecimal;
        @SerializedName(value="up_to")
        Long upTo;

        @Generated
        public Long getFlatAmount() {
            return this.flatAmount;
        }

        @Generated
        public BigDecimal getFlatAmountDecimal() {
            return this.flatAmountDecimal;
        }

        @Generated
        public Long getUnitAmount() {
            return this.unitAmount;
        }

        @Generated
        public BigDecimal getUnitAmountDecimal() {
            return this.unitAmountDecimal;
        }

        @Generated
        public Long getUpTo() {
            return this.upTo;
        }

        @Generated
        public void setFlatAmount(Long flatAmount) {
            this.flatAmount = flatAmount;
        }

        @Generated
        public void setFlatAmountDecimal(BigDecimal flatAmountDecimal) {
            this.flatAmountDecimal = flatAmountDecimal;
        }

        @Generated
        public void setUnitAmount(Long unitAmount) {
            this.unitAmount = unitAmount;
        }

        @Generated
        public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
            this.unitAmountDecimal = unitAmountDecimal;
        }

        @Generated
        public void setUpTo(Long upTo) {
            this.upTo = upTo;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tier)) {
                return false;
            }
            Tier other = (Tier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$flatAmount = this.getFlatAmount();
            Long other$flatAmount = other.getFlatAmount();
            if (this$flatAmount == null ? other$flatAmount != null : !((Object)this$flatAmount).equals(other$flatAmount)) {
                return false;
            }
            Long this$unitAmount = this.getUnitAmount();
            Long other$unitAmount = other.getUnitAmount();
            if (this$unitAmount == null ? other$unitAmount != null : !((Object)this$unitAmount).equals(other$unitAmount)) {
                return false;
            }
            Long this$upTo = this.getUpTo();
            Long other$upTo = other.getUpTo();
            if (this$upTo == null ? other$upTo != null : !((Object)this$upTo).equals(other$upTo)) {
                return false;
            }
            BigDecimal this$flatAmountDecimal = this.getFlatAmountDecimal();
            BigDecimal other$flatAmountDecimal = other.getFlatAmountDecimal();
            if (this$flatAmountDecimal == null ? other$flatAmountDecimal != null : !((Object)this$flatAmountDecimal).equals(other$flatAmountDecimal)) {
                return false;
            }
            BigDecimal this$unitAmountDecimal = this.getUnitAmountDecimal();
            BigDecimal other$unitAmountDecimal = other.getUnitAmountDecimal();
            return !(this$unitAmountDecimal == null ? other$unitAmountDecimal != null : !((Object)this$unitAmountDecimal).equals(other$unitAmountDecimal));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tier;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $flatAmount = this.getFlatAmount();
            result = result * 59 + ($flatAmount == null ? 43 : ((Object)$flatAmount).hashCode());
            Long $unitAmount = this.getUnitAmount();
            result = result * 59 + ($unitAmount == null ? 43 : ((Object)$unitAmount).hashCode());
            Long $upTo = this.getUpTo();
            result = result * 59 + ($upTo == null ? 43 : ((Object)$upTo).hashCode());
            BigDecimal $flatAmountDecimal = this.getFlatAmountDecimal();
            result = result * 59 + ($flatAmountDecimal == null ? 43 : ((Object)$flatAmountDecimal).hashCode());
            BigDecimal $unitAmountDecimal = this.getUnitAmountDecimal();
            result = result * 59 + ($unitAmountDecimal == null ? 43 : ((Object)$unitAmountDecimal).hashCode());
            return result;
        }
    }

    public static class CurrencyOption
    extends StripeObject {
        @SerializedName(value="custom_unit_amount")
        CustomUnitAmount customUnitAmount;
        @SerializedName(value="tax_behavior")
        String taxBehavior;
        @SerializedName(value="tiers")
        List<Tier> tiers;
        @SerializedName(value="unit_amount")
        Long unitAmount;
        @SerializedName(value="unit_amount_decimal")
        BigDecimal unitAmountDecimal;

        @Generated
        public CustomUnitAmount getCustomUnitAmount() {
            return this.customUnitAmount;
        }

        @Generated
        public String getTaxBehavior() {
            return this.taxBehavior;
        }

        @Generated
        public List<Tier> getTiers() {
            return this.tiers;
        }

        @Generated
        public Long getUnitAmount() {
            return this.unitAmount;
        }

        @Generated
        public BigDecimal getUnitAmountDecimal() {
            return this.unitAmountDecimal;
        }

        @Generated
        public void setCustomUnitAmount(CustomUnitAmount customUnitAmount) {
            this.customUnitAmount = customUnitAmount;
        }

        @Generated
        public void setTaxBehavior(String taxBehavior) {
            this.taxBehavior = taxBehavior;
        }

        @Generated
        public void setTiers(List<Tier> tiers) {
            this.tiers = tiers;
        }

        @Generated
        public void setUnitAmount(Long unitAmount) {
            this.unitAmount = unitAmount;
        }

        @Generated
        public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
            this.unitAmountDecimal = unitAmountDecimal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrencyOption)) {
                return false;
            }
            CurrencyOption other = (CurrencyOption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$unitAmount = this.getUnitAmount();
            Long other$unitAmount = other.getUnitAmount();
            if (this$unitAmount == null ? other$unitAmount != null : !((Object)this$unitAmount).equals(other$unitAmount)) {
                return false;
            }
            CustomUnitAmount this$customUnitAmount = this.getCustomUnitAmount();
            CustomUnitAmount other$customUnitAmount = other.getCustomUnitAmount();
            if (this$customUnitAmount == null ? other$customUnitAmount != null : !((Object)this$customUnitAmount).equals(other$customUnitAmount)) {
                return false;
            }
            String this$taxBehavior = this.getTaxBehavior();
            String other$taxBehavior = other.getTaxBehavior();
            if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) {
                return false;
            }
            List<Tier> this$tiers = this.getTiers();
            List<Tier> other$tiers = other.getTiers();
            if (this$tiers == null ? other$tiers != null : !((Object)this$tiers).equals(other$tiers)) {
                return false;
            }
            BigDecimal this$unitAmountDecimal = this.getUnitAmountDecimal();
            BigDecimal other$unitAmountDecimal = other.getUnitAmountDecimal();
            return !(this$unitAmountDecimal == null ? other$unitAmountDecimal != null : !((Object)this$unitAmountDecimal).equals(other$unitAmountDecimal));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CurrencyOption;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $unitAmount = this.getUnitAmount();
            result = result * 59 + ($unitAmount == null ? 43 : ((Object)$unitAmount).hashCode());
            CustomUnitAmount $customUnitAmount = this.getCustomUnitAmount();
            result = result * 59 + ($customUnitAmount == null ? 43 : ((Object)$customUnitAmount).hashCode());
            String $taxBehavior = this.getTaxBehavior();
            result = result * 59 + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
            List<Tier> $tiers = this.getTiers();
            result = result * 59 + ($tiers == null ? 43 : ((Object)$tiers).hashCode());
            BigDecimal $unitAmountDecimal = this.getUnitAmountDecimal();
            result = result * 59 + ($unitAmountDecimal == null ? 43 : ((Object)$unitAmountDecimal).hashCode());
            return result;
        }

        public static class CustomUnitAmount
        extends StripeObject {
            @SerializedName(value="maximum")
            Long maximum;
            @SerializedName(value="minimum")
            Long minimum;
            @SerializedName(value="preset")
            Long preset;

            @Generated
            public Long getMaximum() {
                return this.maximum;
            }

            @Generated
            public Long getMinimum() {
                return this.minimum;
            }

            @Generated
            public Long getPreset() {
                return this.preset;
            }

            @Generated
            public void setMaximum(Long maximum) {
                this.maximum = maximum;
            }

            @Generated
            public void setMinimum(Long minimum) {
                this.minimum = minimum;
            }

            @Generated
            public void setPreset(Long preset) {
                this.preset = preset;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CustomUnitAmount)) {
                    return false;
                }
                CustomUnitAmount other = (CustomUnitAmount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$maximum = this.getMaximum();
                Long other$maximum = other.getMaximum();
                if (this$maximum == null ? other$maximum != null : !((Object)this$maximum).equals(other$maximum)) {
                    return false;
                }
                Long this$minimum = this.getMinimum();
                Long other$minimum = other.getMinimum();
                if (this$minimum == null ? other$minimum != null : !((Object)this$minimum).equals(other$minimum)) {
                    return false;
                }
                Long this$preset = this.getPreset();
                Long other$preset = other.getPreset();
                return !(this$preset == null ? other$preset != null : !((Object)this$preset).equals(other$preset));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CustomUnitAmount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $maximum = this.getMaximum();
                result = result * 59 + ($maximum == null ? 43 : ((Object)$maximum).hashCode());
                Long $minimum = this.getMinimum();
                result = result * 59 + ($minimum == null ? 43 : ((Object)$minimum).hashCode());
                Long $preset = this.getPreset();
                result = result * 59 + ($preset == null ? 43 : ((Object)$preset).hashCode());
                return result;
            }
        }

        public static class Tier
        extends StripeObject {
            @SerializedName(value="flat_amount")
            Long flatAmount;
            @SerializedName(value="flat_amount_decimal")
            BigDecimal flatAmountDecimal;
            @SerializedName(value="unit_amount")
            Long unitAmount;
            @SerializedName(value="unit_amount_decimal")
            BigDecimal unitAmountDecimal;
            @SerializedName(value="up_to")
            Long upTo;

            @Generated
            public Long getFlatAmount() {
                return this.flatAmount;
            }

            @Generated
            public BigDecimal getFlatAmountDecimal() {
                return this.flatAmountDecimal;
            }

            @Generated
            public Long getUnitAmount() {
                return this.unitAmount;
            }

            @Generated
            public BigDecimal getUnitAmountDecimal() {
                return this.unitAmountDecimal;
            }

            @Generated
            public Long getUpTo() {
                return this.upTo;
            }

            @Generated
            public void setFlatAmount(Long flatAmount) {
                this.flatAmount = flatAmount;
            }

            @Generated
            public void setFlatAmountDecimal(BigDecimal flatAmountDecimal) {
                this.flatAmountDecimal = flatAmountDecimal;
            }

            @Generated
            public void setUnitAmount(Long unitAmount) {
                this.unitAmount = unitAmount;
            }

            @Generated
            public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
                this.unitAmountDecimal = unitAmountDecimal;
            }

            @Generated
            public void setUpTo(Long upTo) {
                this.upTo = upTo;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tier)) {
                    return false;
                }
                Tier other = (Tier)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$flatAmount = this.getFlatAmount();
                Long other$flatAmount = other.getFlatAmount();
                if (this$flatAmount == null ? other$flatAmount != null : !((Object)this$flatAmount).equals(other$flatAmount)) {
                    return false;
                }
                Long this$unitAmount = this.getUnitAmount();
                Long other$unitAmount = other.getUnitAmount();
                if (this$unitAmount == null ? other$unitAmount != null : !((Object)this$unitAmount).equals(other$unitAmount)) {
                    return false;
                }
                Long this$upTo = this.getUpTo();
                Long other$upTo = other.getUpTo();
                if (this$upTo == null ? other$upTo != null : !((Object)this$upTo).equals(other$upTo)) {
                    return false;
                }
                BigDecimal this$flatAmountDecimal = this.getFlatAmountDecimal();
                BigDecimal other$flatAmountDecimal = other.getFlatAmountDecimal();
                if (this$flatAmountDecimal == null ? other$flatAmountDecimal != null : !((Object)this$flatAmountDecimal).equals(other$flatAmountDecimal)) {
                    return false;
                }
                BigDecimal this$unitAmountDecimal = this.getUnitAmountDecimal();
                BigDecimal other$unitAmountDecimal = other.getUnitAmountDecimal();
                return !(this$unitAmountDecimal == null ? other$unitAmountDecimal != null : !((Object)this$unitAmountDecimal).equals(other$unitAmountDecimal));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tier;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $flatAmount = this.getFlatAmount();
                result = result * 59 + ($flatAmount == null ? 43 : ((Object)$flatAmount).hashCode());
                Long $unitAmount = this.getUnitAmount();
                result = result * 59 + ($unitAmount == null ? 43 : ((Object)$unitAmount).hashCode());
                Long $upTo = this.getUpTo();
                result = result * 59 + ($upTo == null ? 43 : ((Object)$upTo).hashCode());
                BigDecimal $flatAmountDecimal = this.getFlatAmountDecimal();
                result = result * 59 + ($flatAmountDecimal == null ? 43 : ((Object)$flatAmountDecimal).hashCode());
                BigDecimal $unitAmountDecimal = this.getUnitAmountDecimal();
                result = result * 59 + ($unitAmountDecimal == null ? 43 : ((Object)$unitAmountDecimal).hashCode());
                return result;
            }
        }
    }
}

