/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.treasury.OutboundPaymentCollection;
import com.stripe.model.treasury.Transaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.OutboundPaymentCancelParams;
import com.stripe.param.treasury.OutboundPaymentCreateParams;
import com.stripe.param.treasury.OutboundPaymentFailParams;
import com.stripe.param.treasury.OutboundPaymentListParams;
import com.stripe.param.treasury.OutboundPaymentPostParams;
import com.stripe.param.treasury.OutboundPaymentRetrieveParams;
import com.stripe.param.treasury.OutboundPaymentReturnOutboundPaymentParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class OutboundPayment
extends ApiResource
implements HasId {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="cancelable")
    Boolean cancelable;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="destination_payment_method")
    String destinationPaymentMethod;
    @SerializedName(value="destination_payment_method_details")
    DestinationPaymentMethodDetails destinationPaymentMethodDetails;
    @SerializedName(value="end_user_details")
    EndUserDetails endUserDetails;
    @SerializedName(value="expected_arrival_date")
    Long expectedArrivalDate;
    @SerializedName(value="financial_account")
    String financialAccount;
    @SerializedName(value="hosted_regulatory_receipt_url")
    String hostedRegulatoryReceiptUrl;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="returned_details")
    ReturnedDetails returnedDetails;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="status_transitions")
    StatusTransitions statusTransitions;
    @SerializedName(value="transaction")
    ExpandableField<Transaction> transaction;

    public String getTransaction() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
        this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    public Transaction getTransactionObject() {
        return this.transaction != null ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
        this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    public OutboundPayment cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public OutboundPayment cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public OutboundPayment cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public OutboundPayment cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/outbound_payments/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (OutboundPayment)this.getResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
    }

    public OutboundPayment cancel(OutboundPaymentCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public OutboundPayment cancel(OutboundPaymentCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/outbound_payments/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (OutboundPayment)this.getResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
    }

    public static OutboundPayment create(Map<String, Object> params) throws StripeException {
        return OutboundPayment.create(params, (RequestOptions)null);
    }

    public static OutboundPayment create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/outbound_payments";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (OutboundPayment)OutboundPayment.getGlobalResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
    }

    public static OutboundPayment create(OutboundPaymentCreateParams params) throws StripeException {
        return OutboundPayment.create(params, (RequestOptions)null);
    }

    public static OutboundPayment create(OutboundPaymentCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/outbound_payments";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (OutboundPayment)OutboundPayment.getGlobalResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
    }

    public static OutboundPaymentCollection list(Map<String, Object> params) throws StripeException {
        return OutboundPayment.list(params, (RequestOptions)null);
    }

    public static OutboundPaymentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/outbound_payments";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (OutboundPaymentCollection)OutboundPayment.getGlobalResponseGetter().request(request, (Type)((Object)OutboundPaymentCollection.class));
    }

    public static OutboundPaymentCollection list(OutboundPaymentListParams params) throws StripeException {
        return OutboundPayment.list(params, (RequestOptions)null);
    }

    public static OutboundPaymentCollection list(OutboundPaymentListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/outbound_payments";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (OutboundPaymentCollection)OutboundPayment.getGlobalResponseGetter().request(request, (Type)((Object)OutboundPaymentCollection.class));
    }

    public static OutboundPayment retrieve(String id) throws StripeException {
        return OutboundPayment.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static OutboundPayment retrieve(String id, RequestOptions options) throws StripeException {
        return OutboundPayment.retrieve(id, (Map<String, Object>)null, options);
    }

    public static OutboundPayment retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/outbound_payments/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (OutboundPayment)OutboundPayment.getGlobalResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
    }

    public static OutboundPayment retrieve(String id, OutboundPaymentRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/outbound_payments/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (OutboundPayment)OutboundPayment.getGlobalResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.destinationPaymentMethodDetails, responseGetter);
        this.trySetResponseGetter(this.endUserDetails, responseGetter);
        this.trySetResponseGetter(this.returnedDetails, responseGetter);
        this.trySetResponseGetter(this.statusTransitions, responseGetter);
        this.trySetResponseGetter(this.transaction, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Boolean getCancelable() {
        return this.cancelable;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDestinationPaymentMethod() {
        return this.destinationPaymentMethod;
    }

    @Generated
    public DestinationPaymentMethodDetails getDestinationPaymentMethodDetails() {
        return this.destinationPaymentMethodDetails;
    }

    @Generated
    public EndUserDetails getEndUserDetails() {
        return this.endUserDetails;
    }

    @Generated
    public Long getExpectedArrivalDate() {
        return this.expectedArrivalDate;
    }

    @Generated
    public String getFinancialAccount() {
        return this.financialAccount;
    }

    @Generated
    public String getHostedRegulatoryReceiptUrl() {
        return this.hostedRegulatoryReceiptUrl;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public ReturnedDetails getReturnedDetails() {
        return this.returnedDetails;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusTransitions getStatusTransitions() {
        return this.statusTransitions;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCancelable(Boolean cancelable) {
        this.cancelable = cancelable;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDestinationPaymentMethod(String destinationPaymentMethod) {
        this.destinationPaymentMethod = destinationPaymentMethod;
    }

    @Generated
    public void setDestinationPaymentMethodDetails(DestinationPaymentMethodDetails destinationPaymentMethodDetails) {
        this.destinationPaymentMethodDetails = destinationPaymentMethodDetails;
    }

    @Generated
    public void setEndUserDetails(EndUserDetails endUserDetails) {
        this.endUserDetails = endUserDetails;
    }

    @Generated
    public void setExpectedArrivalDate(Long expectedArrivalDate) {
        this.expectedArrivalDate = expectedArrivalDate;
    }

    @Generated
    public void setFinancialAccount(String financialAccount) {
        this.financialAccount = financialAccount;
    }

    @Generated
    public void setHostedRegulatoryReceiptUrl(String hostedRegulatoryReceiptUrl) {
        this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReturnedDetails(ReturnedDetails returnedDetails) {
        this.returnedDetails = returnedDetails;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusTransitions(StatusTransitions statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutboundPayment)) {
            return false;
        }
        OutboundPayment other = (OutboundPayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$cancelable = this.getCancelable();
        Boolean other$cancelable = other.getCancelable();
        if (this$cancelable == null ? other$cancelable != null : !((Object)this$cancelable).equals(other$cancelable)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expectedArrivalDate = this.getExpectedArrivalDate();
        Long other$expectedArrivalDate = other.getExpectedArrivalDate();
        if (this$expectedArrivalDate == null ? other$expectedArrivalDate != null : !((Object)this$expectedArrivalDate).equals(other$expectedArrivalDate)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$destinationPaymentMethod = this.getDestinationPaymentMethod();
        String other$destinationPaymentMethod = other.getDestinationPaymentMethod();
        if (this$destinationPaymentMethod == null ? other$destinationPaymentMethod != null : !this$destinationPaymentMethod.equals(other$destinationPaymentMethod)) {
            return false;
        }
        DestinationPaymentMethodDetails this$destinationPaymentMethodDetails = this.getDestinationPaymentMethodDetails();
        DestinationPaymentMethodDetails other$destinationPaymentMethodDetails = other.getDestinationPaymentMethodDetails();
        if (this$destinationPaymentMethodDetails == null ? other$destinationPaymentMethodDetails != null : !((Object)this$destinationPaymentMethodDetails).equals(other$destinationPaymentMethodDetails)) {
            return false;
        }
        EndUserDetails this$endUserDetails = this.getEndUserDetails();
        EndUserDetails other$endUserDetails = other.getEndUserDetails();
        if (this$endUserDetails == null ? other$endUserDetails != null : !((Object)this$endUserDetails).equals(other$endUserDetails)) {
            return false;
        }
        String this$financialAccount = this.getFinancialAccount();
        String other$financialAccount = other.getFinancialAccount();
        if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) {
            return false;
        }
        String this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        String other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
        if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        ReturnedDetails this$returnedDetails = this.getReturnedDetails();
        ReturnedDetails other$returnedDetails = other.getReturnedDetails();
        if (this$returnedDetails == null ? other$returnedDetails != null : !((Object)this$returnedDetails).equals(other$returnedDetails)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusTransitions this$statusTransitions = this.getStatusTransitions();
        StatusTransitions other$statusTransitions = other.getStatusTransitions();
        if (this$statusTransitions == null ? other$statusTransitions != null : !((Object)this$statusTransitions).equals(other$statusTransitions)) {
            return false;
        }
        String this$transaction = this.getTransaction();
        String other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutboundPayment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $cancelable = this.getCancelable();
        result = result * 59 + ($cancelable == null ? 43 : ((Object)$cancelable).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expectedArrivalDate = this.getExpectedArrivalDate();
        result = result * 59 + ($expectedArrivalDate == null ? 43 : ((Object)$expectedArrivalDate).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $destinationPaymentMethod = this.getDestinationPaymentMethod();
        result = result * 59 + ($destinationPaymentMethod == null ? 43 : $destinationPaymentMethod.hashCode());
        DestinationPaymentMethodDetails $destinationPaymentMethodDetails = this.getDestinationPaymentMethodDetails();
        result = result * 59 + ($destinationPaymentMethodDetails == null ? 43 : ((Object)$destinationPaymentMethodDetails).hashCode());
        EndUserDetails $endUserDetails = this.getEndUserDetails();
        result = result * 59 + ($endUserDetails == null ? 43 : ((Object)$endUserDetails).hashCode());
        String $financialAccount = this.getFinancialAccount();
        result = result * 59 + ($financialAccount == null ? 43 : $financialAccount.hashCode());
        String $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        result = result * 59 + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        ReturnedDetails $returnedDetails = this.getReturnedDetails();
        result = result * 59 + ($returnedDetails == null ? 43 : ((Object)$returnedDetails).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusTransitions $statusTransitions = this.getStatusTransitions();
        result = result * 59 + ($statusTransitions == null ? 43 : ((Object)$statusTransitions).hashCode());
        String $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class TestHelpers {
        private final OutboundPayment resource;

        private TestHelpers(OutboundPayment resource) {
            this.resource = resource;
        }

        public OutboundPayment fail() throws StripeException {
            return this.fail((Map<String, Object>)null, (RequestOptions)null);
        }

        public OutboundPayment fail(RequestOptions options) throws StripeException {
            return this.fail((Map<String, Object>)null, options);
        }

        public OutboundPayment fail(Map<String, Object> params) throws StripeException {
            return this.fail(params, (RequestOptions)null);
        }

        public OutboundPayment fail(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/treasury/outbound_payments/%s/fail", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
            return (OutboundPayment)this.resource.getResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
        }

        public OutboundPayment fail(OutboundPaymentFailParams params) throws StripeException {
            return this.fail(params, (RequestOptions)null);
        }

        public OutboundPayment fail(OutboundPaymentFailParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/treasury/outbound_payments/%s/fail", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
            return (OutboundPayment)this.resource.getResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
        }

        public OutboundPayment post() throws StripeException {
            return this.post((Map<String, Object>)null, (RequestOptions)null);
        }

        public OutboundPayment post(RequestOptions options) throws StripeException {
            return this.post((Map<String, Object>)null, options);
        }

        public OutboundPayment post(Map<String, Object> params) throws StripeException {
            return this.post(params, (RequestOptions)null);
        }

        public OutboundPayment post(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/treasury/outbound_payments/%s/post", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
            return (OutboundPayment)this.resource.getResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
        }

        public OutboundPayment post(OutboundPaymentPostParams params) throws StripeException {
            return this.post(params, (RequestOptions)null);
        }

        public OutboundPayment post(OutboundPaymentPostParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/treasury/outbound_payments/%s/post", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
            return (OutboundPayment)this.resource.getResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
        }

        public OutboundPayment returnOutboundPayment() throws StripeException {
            return this.returnOutboundPayment((Map<String, Object>)null, (RequestOptions)null);
        }

        public OutboundPayment returnOutboundPayment(RequestOptions options) throws StripeException {
            return this.returnOutboundPayment((Map<String, Object>)null, options);
        }

        public OutboundPayment returnOutboundPayment(Map<String, Object> params) throws StripeException {
            return this.returnOutboundPayment(params, (RequestOptions)null);
        }

        public OutboundPayment returnOutboundPayment(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/treasury/outbound_payments/%s/return", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
            return (OutboundPayment)this.resource.getResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
        }

        public OutboundPayment returnOutboundPayment(OutboundPaymentReturnOutboundPaymentParams params) throws StripeException {
            return this.returnOutboundPayment(params, (RequestOptions)null);
        }

        public OutboundPayment returnOutboundPayment(OutboundPaymentReturnOutboundPaymentParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/treasury/outbound_payments/%s/return", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
            return (OutboundPayment)this.resource.getResponseGetter().request(request, (Type)((Object)OutboundPayment.class));
        }
    }

    public static class DestinationPaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="financial_account")
        FinancialAccount financialAccount;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public FinancialAccount getFinancialAccount() {
            return this.financialAccount;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public void setBillingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
        }

        @Generated
        public void setFinancialAccount(FinancialAccount financialAccount) {
            this.financialAccount = financialAccount;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DestinationPaymentMethodDetails)) {
                return false;
            }
            DestinationPaymentMethodDetails other = (DestinationPaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BillingDetails this$billingDetails = this.getBillingDetails();
            BillingDetails other$billingDetails = other.getBillingDetails();
            if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
                return false;
            }
            FinancialAccount this$financialAccount = this.getFinancialAccount();
            FinancialAccount other$financialAccount = other.getFinancialAccount();
            if (this$financialAccount == null ? other$financialAccount != null : !((Object)this$financialAccount).equals(other$financialAccount)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DestinationPaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BillingDetails $billingDetails = this.getBillingDetails();
            result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
            FinancialAccount $financialAccount = this.getFinancialAccount();
            result = result * 59 + ($financialAccount == null ? 43 : ((Object)$financialAccount).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            return result;
        }

        public static class BillingDetails
        extends StripeObject {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="email")
            String email;
            @SerializedName(value="name")
            String name;

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getEmail() {
                return this.email;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public void setAddress(Address address) {
                this.address = address;
            }

            @Generated
            public void setEmail(String email) {
                this.email = email;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingDetails)) {
                    return false;
                }
                BillingDetails other = (BillingDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                String this$email = this.getEmail();
                String other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                String $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }

        public static class FinancialAccount
        extends StripeObject
        implements HasId {
            @SerializedName(value="id")
            String id;
            @SerializedName(value="network")
            String network;

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public void setId(String id) {
                this.id = id;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FinancialAccount)) {
                    return false;
                }
                FinancialAccount other = (FinancialAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                return !(this$network == null ? other$network != null : !this$network.equals(other$network));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FinancialAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                return result;
            }

            @Override
            @Generated
            public String getId() {
                return this.id;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="account_holder_type")
            String accountHolderType;
            @SerializedName(value="account_type")
            String accountType;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="routing_number")
            String routingNumber;

            @Generated
            public String getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getAccountType() {
                return this.accountType;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public void setAccountHolderType(String accountHolderType) {
                this.accountHolderType = accountHolderType;
            }

            @Generated
            public void setAccountType(String accountType) {
                this.accountType = accountType;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderType = this.getAccountHolderType();
                String other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$accountType = this.getAccountType();
                String other$accountType = other.getAccountType();
                if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $accountType = this.getAccountType();
                result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                return result;
            }
        }
    }

    public static class EndUserDetails
    extends StripeObject {
        @SerializedName(value="ip_address")
        String ipAddress;
        @SerializedName(value="present")
        Boolean present;

        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public Boolean getPresent() {
            return this.present;
        }

        @Generated
        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Generated
        public void setPresent(Boolean present) {
            this.present = present;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EndUserDetails)) {
                return false;
            }
            EndUserDetails other = (EndUserDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$present = this.getPresent();
            Boolean other$present = other.getPresent();
            if (this$present == null ? other$present != null : !((Object)this$present).equals(other$present)) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            return !(this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EndUserDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $present = this.getPresent();
            result = result * 59 + ($present == null ? 43 : ((Object)$present).hashCode());
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            return result;
        }
    }

    public static class ReturnedDetails
    extends StripeObject {
        @SerializedName(value="code")
        String code;
        @SerializedName(value="transaction")
        ExpandableField<Transaction> transaction;

        public String getTransaction() {
            return this.transaction != null ? this.transaction.getId() : null;
        }

        public void setTransaction(String id) {
            this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
        }

        public Transaction getTransactionObject() {
            return this.transaction != null ? this.transaction.getExpanded() : null;
        }

        public void setTransactionObject(Transaction expandableObject) {
            this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public void setCode(String code) {
            this.code = code;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReturnedDetails)) {
                return false;
            }
            ReturnedDetails other = (ReturnedDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$transaction = this.getTransaction();
            String other$transaction = other.getTransaction();
            return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReturnedDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $transaction = this.getTransaction();
            result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
            return result;
        }
    }

    public static class StatusTransitions
    extends StripeObject {
        @SerializedName(value="canceled_at")
        Long canceledAt;
        @SerializedName(value="failed_at")
        Long failedAt;
        @SerializedName(value="posted_at")
        Long postedAt;
        @SerializedName(value="returned_at")
        Long returnedAt;

        @Generated
        public Long getCanceledAt() {
            return this.canceledAt;
        }

        @Generated
        public Long getFailedAt() {
            return this.failedAt;
        }

        @Generated
        public Long getPostedAt() {
            return this.postedAt;
        }

        @Generated
        public Long getReturnedAt() {
            return this.returnedAt;
        }

        @Generated
        public void setCanceledAt(Long canceledAt) {
            this.canceledAt = canceledAt;
        }

        @Generated
        public void setFailedAt(Long failedAt) {
            this.failedAt = failedAt;
        }

        @Generated
        public void setPostedAt(Long postedAt) {
            this.postedAt = postedAt;
        }

        @Generated
        public void setReturnedAt(Long returnedAt) {
            this.returnedAt = returnedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusTransitions)) {
                return false;
            }
            StatusTransitions other = (StatusTransitions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$canceledAt = this.getCanceledAt();
            Long other$canceledAt = other.getCanceledAt();
            if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
                return false;
            }
            Long this$failedAt = this.getFailedAt();
            Long other$failedAt = other.getFailedAt();
            if (this$failedAt == null ? other$failedAt != null : !((Object)this$failedAt).equals(other$failedAt)) {
                return false;
            }
            Long this$postedAt = this.getPostedAt();
            Long other$postedAt = other.getPostedAt();
            if (this$postedAt == null ? other$postedAt != null : !((Object)this$postedAt).equals(other$postedAt)) {
                return false;
            }
            Long this$returnedAt = this.getReturnedAt();
            Long other$returnedAt = other.getReturnedAt();
            return !(this$returnedAt == null ? other$returnedAt != null : !((Object)this$returnedAt).equals(other$returnedAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusTransitions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $canceledAt = this.getCanceledAt();
            result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
            Long $failedAt = this.getFailedAt();
            result = result * 59 + ($failedAt == null ? 43 : ((Object)$failedAt).hashCode());
            Long $postedAt = this.getPostedAt();
            result = result * 59 + ($postedAt == null ? 43 : ((Object)$postedAt).hashCode());
            Long $returnedAt = this.getReturnedAt();
            result = result * 59 + ($returnedAt == null ? 43 : ((Object)$returnedAt).hashCode());
            return result;
        }
    }
}

