/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Order;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.OrderCancelParams;
import com.stripe.param.OrderCreateParams;
import com.stripe.param.OrderListParams;
import com.stripe.param.OrderReopenParams;
import com.stripe.param.OrderRetrieveParams;
import com.stripe.param.OrderSubmitParams;
import com.stripe.param.OrderUpdateParams;
import com.stripe.service.OrderLineItemService;
import java.lang.reflect.Type;

public final class OrderService
extends ApiService {
    public OrderService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Order> list(OrderListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Order> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Order> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Order> list(OrderListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/orders";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Order>>(){}.getType());
    }

    public Order create(OrderCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Order create(OrderCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/orders";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }

    public Order retrieve(String id, OrderRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Order retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Order retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Order retrieve(String id, OrderRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }

    public Order update(String id, OrderUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public Order update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public Order update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public Order update(String id, OrderUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }

    public Order cancel(String id, OrderCancelParams params) throws StripeException {
        return this.cancel(id, params, null);
    }

    public Order cancel(String id, RequestOptions options) throws StripeException {
        return this.cancel(id, null, options);
    }

    public Order cancel(String id) throws StripeException {
        return this.cancel(id, null, null);
    }

    public Order cancel(String id, OrderCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/cancel", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }

    public Order reopen(String id, OrderReopenParams params) throws StripeException {
        return this.reopen(id, params, null);
    }

    public Order reopen(String id, RequestOptions options) throws StripeException {
        return this.reopen(id, null, options);
    }

    public Order reopen(String id) throws StripeException {
        return this.reopen(id, null, null);
    }

    public Order reopen(String id, OrderReopenParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/reopen", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }

    public Order submit(String id, OrderSubmitParams params) throws StripeException {
        return this.submit(id, params, null);
    }

    public Order submit(String id, OrderSubmitParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/submit", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.request(request, (Type)((Object)Order.class));
    }

    public OrderLineItemService lineItems() {
        return new OrderLineItemService(this.getResponseGetter());
    }
}

