/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.ProductFeatureCollection;
import com.stripe.model.entitlements.Feature;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ProductFeatureCreateParams;
import com.stripe.param.ProductFeatureListParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class ProductFeature
extends ApiResource
implements HasId {
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="entitlement_feature")
    Feature entitlementFeature;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;

    public static ProductFeature create(String product, Map<String, Object> params) throws StripeException {
        return ProductFeature.create(product, params, (RequestOptions)null);
    }

    public static ProductFeature create(String product, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s/features", ApiResource.urlEncodeId(product));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (ProductFeature)ProductFeature.getGlobalResponseGetter().request(request, (Type)((Object)ProductFeature.class));
    }

    public static ProductFeature create(String product, ProductFeatureCreateParams params) throws StripeException {
        return ProductFeature.create(product, params, (RequestOptions)null);
    }

    public static ProductFeature create(String product, ProductFeatureCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s/features", ApiResource.urlEncodeId(product));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ProductFeature)ProductFeature.getGlobalResponseGetter().request(request, (Type)((Object)ProductFeature.class));
    }

    public ProductFeature delete(String product) throws StripeException {
        return this.delete(product, null, null);
    }

    public ProductFeature delete(String product, RequestOptions options) throws StripeException {
        return this.delete(product, null, options);
    }

    public ProductFeature delete(String product, Map<String, Object> params) throws StripeException {
        return this.delete(product, params, null);
    }

    public ProductFeature delete(String product, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s/features/%s", ApiResource.urlEncodeId(product), ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options, ApiMode.V1);
        return (ProductFeature)this.getResponseGetter().request(request, (Type)((Object)ProductFeature.class));
    }

    public static ProductFeatureCollection list(String product, Map<String, Object> params) throws StripeException {
        return ProductFeature.list(product, params, (RequestOptions)null);
    }

    public static ProductFeatureCollection list(String product, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s/features", ApiResource.urlEncodeId(product));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (ProductFeatureCollection)ProductFeature.getGlobalResponseGetter().request(request, (Type)((Object)ProductFeatureCollection.class));
    }

    public static ProductFeatureCollection list(String product, ProductFeatureListParams params) throws StripeException {
        return ProductFeature.list(product, params, (RequestOptions)null);
    }

    public static ProductFeatureCollection list(String product, ProductFeatureListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s/features", ApiResource.urlEncodeId(product));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ProductFeatureCollection)ProductFeature.getGlobalResponseGetter().request(request, (Type)((Object)ProductFeatureCollection.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.entitlementFeature, responseGetter);
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Feature getEntitlementFeature() {
        return this.entitlementFeature;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setEntitlementFeature(Feature entitlementFeature) {
        this.entitlementFeature = entitlementFeature;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductFeature)) {
            return false;
        }
        ProductFeature other = (ProductFeature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Feature this$entitlementFeature = this.getEntitlementFeature();
        Feature other$entitlementFeature = other.getEntitlementFeature();
        if (this$entitlementFeature == null ? other$entitlementFeature != null : !((Object)this$entitlementFeature).equals(other$entitlementFeature)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProductFeature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Feature $entitlementFeature = this.getEntitlementFeature();
        result = result * 59 + ($entitlementFeature == null ? 43 : ((Object)$entitlementFeature).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

