/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.ProductFeature;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ProductFeatureCreateParams;
import com.stripe.param.ProductFeatureListParams;
import java.lang.reflect.Type;

public final class ProductFeatureService
extends ApiService {
    public ProductFeatureService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public ProductFeature delete(String product, String id) throws StripeException {
        return this.delete(product, id, null);
    }

    public ProductFeature delete(String product, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s/features/%s", ApiResource.urlEncodeId(product), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (ProductFeature)this.request(request, (Type)((Object)ProductFeature.class));
    }

    public StripeCollection<ProductFeature> list(String product, ProductFeatureListParams params) throws StripeException {
        return this.list(product, params, null);
    }

    public StripeCollection<ProductFeature> list(String product, RequestOptions options) throws StripeException {
        return this.list(product, null, options);
    }

    public StripeCollection<ProductFeature> list(String product) throws StripeException {
        return this.list(product, null, null);
    }

    public StripeCollection<ProductFeature> list(String product, ProductFeatureListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s/features", ApiResource.urlEncodeId(product));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<ProductFeature>>(){}.getType());
    }

    public ProductFeature create(String product, ProductFeatureCreateParams params) throws StripeException {
        return this.create(product, params, null);
    }

    public ProductFeature create(String product, ProductFeatureCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s/features", ApiResource.urlEncodeId(product));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ProductFeature)this.request(request, (Type)((Object)ProductFeature.class));
    }
}

