/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.UntypedMapDeserializer;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Map;

class ApiRequestParamsConverter {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapterFactory((TypeAdapterFactory)new HasEmptyEnumTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new NullValuesInMapsTypeAdapterFactory()).create();
    private static final UntypedMapDeserializer FLATTENING_EXTRA_PARAMS_DESERIALIZER = new UntypedMapDeserializer(new ExtraParamsFlatteningStrategy());

    ApiRequestParamsConverter() {
    }

    private static void validateDuplicateKey(Map<String, Object> outerMap, String paramKey, Object paramValue) {
        if (outerMap.containsKey(paramKey)) {
            throw new IllegalArgumentException(String.format("Found multiple param values for the same param key. This can happen because you passed additional parameters via `putExtraParam` that conflict with the existing params. Found param key `%s` with values `%s` and `%s`. If you wish to pass additional params for nested parameters, you should add extra params at the nested params themselves, not from the top-level param.", paramKey, outerMap.get(paramKey), paramValue));
        }
    }

    Map<String, Object> convert(ApiRequestParams apiRequestParams) {
        JsonObject jsonParams = GSON.toJsonTree((Object)apiRequestParams).getAsJsonObject();
        return FLATTENING_EXTRA_PARAMS_DESERIALIZER.deserialize(jsonParams);
    }

    private static class HasEmptyEnumTypeAdapterFactory
    implements TypeAdapterFactory {
        private HasEmptyEnumTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ApiRequestParams.EnumParam.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            TypeAdapter<ApiRequestParams.EnumParam> paramEnum = new TypeAdapter<ApiRequestParams.EnumParam>(){

                public void write(JsonWriter out, ApiRequestParams.EnumParam value) throws IOException {
                    if (value.getValue().equals("")) {
                        boolean previousSetting = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        out.nullValue();
                        out.setSerializeNulls(previousSetting);
                    } else {
                        out.value(value.getValue());
                    }
                }

                public ApiRequestParams.EnumParam read(JsonReader in) {
                    throw new UnsupportedOperationException("No deserialization is expected from this private type adapter for enum param.");
                }
            };
            return paramEnum.nullSafe();
        }
    }

    private static class NullValuesInMapsTypeAdapterFactory
    implements TypeAdapterFactory {
        private NullValuesInMapsTypeAdapterFactory() {
        }

        TypeAdapter<?> getValueAdapter(Gson gson, TypeToken<?> type) {
            Object valueType;
            if (type.getType() instanceof ParameterizedType) {
                ParameterizedType mapParameterizedType = (ParameterizedType)type.getType();
                valueType = mapParameterizedType.getActualTypeArguments()[1];
            } else {
                valueType = Object.class;
            }
            return gson.getAdapter(TypeToken.get(valueType));
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Map.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            TypeAdapter<?> valueAdapter = this.getValueAdapter(gson, type);
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            MapAdapter typeAdapter = new MapAdapter(valueAdapter, delegate);
            return typeAdapter.nullSafe();
        }
    }

    private static class ExtraParamsFlatteningStrategy
    implements UntypedMapDeserializer.Strategy {
        private ExtraParamsFlatteningStrategy() {
        }

        @Override
        public void deserializeAndTransform(Map<String, Object> outerMap, Map.Entry<String, JsonElement> jsonEntry, UntypedMapDeserializer untypedMapDeserializer) {
            String key = jsonEntry.getKey();
            JsonElement jsonValue = jsonEntry.getValue();
            if ("_stripe_java_extra_param_key".equals(key)) {
                if (!jsonValue.isJsonObject()) {
                    throw new IllegalStateException(String.format("Unexpected schema for extra params. JSON object is expected at key `%s`, but found `%s`. This is likely a problem with this current library version `%s`. Please contact support@stripe.com for assistance.", "_stripe_java_extra_param_key", jsonValue, "24.23.0"));
                }
                Map<String, Object> extraParamsMap = untypedMapDeserializer.deserialize(jsonValue.getAsJsonObject());
                for (Map.Entry<String, Object> entry : extraParamsMap.entrySet()) {
                    ApiRequestParamsConverter.validateDuplicateKey(outerMap, entry.getKey(), entry.getValue());
                    outerMap.put(entry.getKey(), entry.getValue());
                }
            } else {
                Object value = untypedMapDeserializer.deserializeJsonElement(jsonValue);
                ApiRequestParamsConverter.validateDuplicateKey(outerMap, key, value);
                outerMap.put(key, value);
            }
        }
    }

    private static class MapAdapter<V>
    extends TypeAdapter<Map<String, V>> {
        private TypeAdapter<V> valueTypeAdapter;
        private TypeAdapter<Map<String, V>> mapTypeAdapter;

        public MapAdapter(TypeAdapter<V> valueTypeAdapter, TypeAdapter<Map<String, V>> mapTypeAdapter) {
            this.valueTypeAdapter = valueTypeAdapter;
            this.mapTypeAdapter = mapTypeAdapter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(JsonWriter out, Map<String, V> value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            for (Map.Entry<String, V> entry : value.entrySet()) {
                out.name(entry.getKey());
                V entryValue = entry.getValue();
                if (entryValue == null) {
                    boolean oldSerializeNullsValue = out.getSerializeNulls();
                    try {
                        out.setSerializeNulls(true);
                        out.nullValue();
                        continue;
                    }
                    finally {
                        out.setSerializeNulls(oldSerializeNullsValue);
                        continue;
                    }
                }
                this.valueTypeAdapter.write(out, entryValue);
            }
            out.endObject();
        }

        public Map<String, V> read(JsonReader in) throws IOException {
            return (Map)this.mapTypeAdapter.read(in);
        }
    }
}

