/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.AccountNoticeCollection;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.AccountNoticeListParams;
import com.stripe.param.AccountNoticeRetrieveParams;
import com.stripe.param.AccountNoticeUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class AccountNotice
extends ApiResource
implements HasId,
MetadataStore<AccountNotice> {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="deadline")
    Long deadline;
    @SerializedName(value="email")
    Email email;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="linked_objects")
    LinkedObjects linkedObjects;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="reason")
    String reason;
    @SerializedName(value="sent_at")
    Long sentAt;

    public static AccountNoticeCollection list(Map<String, Object> params) throws StripeException {
        return AccountNotice.list(params, (RequestOptions)null);
    }

    public static AccountNoticeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/account_notices";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (AccountNoticeCollection)AccountNotice.getGlobalResponseGetter().request(request, (Type)((Object)AccountNoticeCollection.class));
    }

    public static AccountNoticeCollection list(AccountNoticeListParams params) throws StripeException {
        return AccountNotice.list(params, (RequestOptions)null);
    }

    public static AccountNoticeCollection list(AccountNoticeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/account_notices";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (AccountNoticeCollection)AccountNotice.getGlobalResponseGetter().request(request, (Type)((Object)AccountNoticeCollection.class));
    }

    public static AccountNotice retrieve(String accountNotice) throws StripeException {
        return AccountNotice.retrieve(accountNotice, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static AccountNotice retrieve(String accountNotice, RequestOptions options) throws StripeException {
        return AccountNotice.retrieve(accountNotice, (Map<String, Object>)null, options);
    }

    public static AccountNotice retrieve(String accountNotice, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/account_notices/%s", ApiResource.urlEncodeId(accountNotice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (AccountNotice)AccountNotice.getGlobalResponseGetter().request(request, (Type)((Object)AccountNotice.class));
    }

    public static AccountNotice retrieve(String accountNotice, AccountNoticeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/account_notices/%s", ApiResource.urlEncodeId(accountNotice));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (AccountNotice)AccountNotice.getGlobalResponseGetter().request(request, (Type)((Object)AccountNotice.class));
    }

    public AccountNotice update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public AccountNotice update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/account_notices/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (AccountNotice)this.getResponseGetter().request(request, (Type)((Object)AccountNotice.class));
    }

    public AccountNotice update(AccountNoticeUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public AccountNotice update(AccountNoticeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/account_notices/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (AccountNotice)this.getResponseGetter().request(request, (Type)((Object)AccountNotice.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.email, responseGetter);
        this.trySetResponseGetter(this.linkedObjects, responseGetter);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getDeadline() {
        return this.deadline;
    }

    @Generated
    public Email getEmail() {
        return this.email;
    }

    @Generated
    public LinkedObjects getLinkedObjects() {
        return this.linkedObjects;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public Long getSentAt() {
        return this.sentAt;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    @Generated
    public void setEmail(Email email) {
        this.email = email;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLinkedObjects(LinkedObjects linkedObjects) {
        this.linkedObjects = linkedObjects;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setSentAt(Long sentAt) {
        this.sentAt = sentAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountNotice)) {
            return false;
        }
        AccountNotice other = (AccountNotice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$deadline = this.getDeadline();
        Long other$deadline = other.getDeadline();
        if (this$deadline == null ? other$deadline != null : !((Object)this$deadline).equals(other$deadline)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$sentAt = this.getSentAt();
        Long other$sentAt = other.getSentAt();
        if (this$sentAt == null ? other$sentAt != null : !((Object)this$sentAt).equals(other$sentAt)) {
            return false;
        }
        Email this$email = this.getEmail();
        Email other$email = other.getEmail();
        if (this$email == null ? other$email != null : !((Object)this$email).equals(other$email)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LinkedObjects this$linkedObjects = this.getLinkedObjects();
        LinkedObjects other$linkedObjects = other.getLinkedObjects();
        if (this$linkedObjects == null ? other$linkedObjects != null : !((Object)this$linkedObjects).equals(other$linkedObjects)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountNotice;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $deadline = this.getDeadline();
        result = result * 59 + ($deadline == null ? 43 : ((Object)$deadline).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $sentAt = this.getSentAt();
        result = result * 59 + ($sentAt == null ? 43 : ((Object)$sentAt).hashCode());
        Email $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : ((Object)$email).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LinkedObjects $linkedObjects = this.getLinkedObjects();
        result = result * 59 + ($linkedObjects == null ? 43 : ((Object)$linkedObjects).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Email
    extends StripeObject {
        @SerializedName(value="plain_text")
        String plainText;
        @SerializedName(value="recipient")
        String recipient;
        @SerializedName(value="subject")
        String subject;

        @Generated
        public String getPlainText() {
            return this.plainText;
        }

        @Generated
        public String getRecipient() {
            return this.recipient;
        }

        @Generated
        public String getSubject() {
            return this.subject;
        }

        @Generated
        public void setPlainText(String plainText) {
            this.plainText = plainText;
        }

        @Generated
        public void setRecipient(String recipient) {
            this.recipient = recipient;
        }

        @Generated
        public void setSubject(String subject) {
            this.subject = subject;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Email)) {
                return false;
            }
            Email other = (Email)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$plainText = this.getPlainText();
            String other$plainText = other.getPlainText();
            if (this$plainText == null ? other$plainText != null : !this$plainText.equals(other$plainText)) {
                return false;
            }
            String this$recipient = this.getRecipient();
            String other$recipient = other.getRecipient();
            if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
                return false;
            }
            String this$subject = this.getSubject();
            String other$subject = other.getSubject();
            return !(this$subject == null ? other$subject != null : !this$subject.equals(other$subject));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Email;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $plainText = this.getPlainText();
            result = result * 59 + ($plainText == null ? 43 : $plainText.hashCode());
            String $recipient = this.getRecipient();
            result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
            String $subject = this.getSubject();
            result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
            return result;
        }
    }

    public static class LinkedObjects
    extends StripeObject {
        @SerializedName(value="capability")
        String capability;
        @SerializedName(value="issuing_credit_underwriting_record")
        String issuingCreditUnderwritingRecord;
        @SerializedName(value="issuing_dispute")
        String issuingDispute;

        @Generated
        public String getCapability() {
            return this.capability;
        }

        @Generated
        public String getIssuingCreditUnderwritingRecord() {
            return this.issuingCreditUnderwritingRecord;
        }

        @Generated
        public String getIssuingDispute() {
            return this.issuingDispute;
        }

        @Generated
        public void setCapability(String capability) {
            this.capability = capability;
        }

        @Generated
        public void setIssuingCreditUnderwritingRecord(String issuingCreditUnderwritingRecord) {
            this.issuingCreditUnderwritingRecord = issuingCreditUnderwritingRecord;
        }

        @Generated
        public void setIssuingDispute(String issuingDispute) {
            this.issuingDispute = issuingDispute;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LinkedObjects)) {
                return false;
            }
            LinkedObjects other = (LinkedObjects)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$capability = this.getCapability();
            String other$capability = other.getCapability();
            if (this$capability == null ? other$capability != null : !this$capability.equals(other$capability)) {
                return false;
            }
            String this$issuingCreditUnderwritingRecord = this.getIssuingCreditUnderwritingRecord();
            String other$issuingCreditUnderwritingRecord = other.getIssuingCreditUnderwritingRecord();
            if (this$issuingCreditUnderwritingRecord == null ? other$issuingCreditUnderwritingRecord != null : !this$issuingCreditUnderwritingRecord.equals(other$issuingCreditUnderwritingRecord)) {
                return false;
            }
            String this$issuingDispute = this.getIssuingDispute();
            String other$issuingDispute = other.getIssuingDispute();
            return !(this$issuingDispute == null ? other$issuingDispute != null : !this$issuingDispute.equals(other$issuingDispute));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LinkedObjects;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $capability = this.getCapability();
            result = result * 59 + ($capability == null ? 43 : $capability.hashCode());
            String $issuingCreditUnderwritingRecord = this.getIssuingCreditUnderwritingRecord();
            result = result * 59 + ($issuingCreditUnderwritingRecord == null ? 43 : $issuingCreditUnderwritingRecord.hashCode());
            String $issuingDispute = this.getIssuingDispute();
            result = result * 59 + ($issuingDispute == null ? 43 : $issuingDispute.hashCode());
            return result;
        }
    }
}

