/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.tax;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.tax.Form;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.tax.FormListParams;
import com.stripe.param.tax.FormPdfParams;
import com.stripe.param.tax.FormRetrieveParams;
import java.io.InputStream;
import java.lang.reflect.Type;

public final class FormService
extends ApiService {
    public FormService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Form> list(FormListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Form> list(FormListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/forms";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Form>>(){}.getType());
    }

    public Form retrieve(String id, FormRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Form retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Form retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Form retrieve(String id, FormRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/forms/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Form)this.request(request, (Type)((Object)Form.class));
    }

    public InputStream pdf(String id, FormPdfParams params) throws StripeException {
        return this.pdf(id, params, null);
    }

    public InputStream pdf(String id, RequestOptions options) throws StripeException {
        return this.pdf(id, null, options);
    }

    public InputStream pdf(String id) throws StripeException {
        return this.pdf(id, null, null);
    }

    public InputStream pdf(String id, FormPdfParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/forms/%s/pdf", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.FILES, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return this.requestStream(request);
    }
}

