/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CreditUnderwritingRecordCorrectParams
extends ApiRequestParams {
    @SerializedName(value="application")
    Application application;
    @SerializedName(value="credit_user")
    CreditUser creditUser;
    @SerializedName(value="decided_at")
    Long decidedAt;
    @SerializedName(value="decision")
    Decision decision;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="underwriting_exception")
    UnderwritingException underwritingException;

    private CreditUnderwritingRecordCorrectParams(Application application, CreditUser creditUser, Long decidedAt, Decision decision, List<String> expand, Map<String, Object> extraParams, Map<String, String> metadata, UnderwritingException underwritingException) {
        this.application = application;
        this.creditUser = creditUser;
        this.decidedAt = decidedAt;
        this.decision = decision;
        this.expand = expand;
        this.extraParams = extraParams;
        this.metadata = metadata;
        this.underwritingException = underwritingException;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Application getApplication() {
        return this.application;
    }

    @Generated
    public CreditUser getCreditUser() {
        return this.creditUser;
    }

    @Generated
    public Long getDecidedAt() {
        return this.decidedAt;
    }

    @Generated
    public Decision getDecision() {
        return this.decision;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public UnderwritingException getUnderwritingException() {
        return this.underwritingException;
    }

    public static class Application {
        @SerializedName(value="application_method")
        ApplicationMethod applicationMethod;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="purpose")
        Purpose purpose;
        @SerializedName(value="submitted_at")
        Long submittedAt;

        private Application(ApplicationMethod applicationMethod, Map<String, Object> extraParams, Purpose purpose, Long submittedAt) {
            this.applicationMethod = applicationMethod;
            this.extraParams = extraParams;
            this.purpose = purpose;
            this.submittedAt = submittedAt;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public ApplicationMethod getApplicationMethod() {
            return this.applicationMethod;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Purpose getPurpose() {
            return this.purpose;
        }

        @Generated
        public Long getSubmittedAt() {
            return this.submittedAt;
        }

        public static enum ApplicationMethod implements ApiRequestParams.EnumParam
        {
            IN_PERSON("in_person"),
            MAIL("mail"),
            ONLINE("online"),
            PHONE("phone");

            private final String value;

            private ApplicationMethod(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum Purpose implements ApiRequestParams.EnumParam
        {
            CREDIT_LIMIT_INCREASE("credit_limit_increase"),
            CREDIT_LINE_OPENING("credit_line_opening");

            private final String value;

            private Purpose(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private ApplicationMethod applicationMethod;
            private Map<String, Object> extraParams;
            private Purpose purpose;
            private Long submittedAt;

            public Application build() {
                return new Application(this.applicationMethod, this.extraParams, this.purpose, this.submittedAt);
            }

            public Builder setApplicationMethod(ApplicationMethod applicationMethod) {
                this.applicationMethod = applicationMethod;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setPurpose(Purpose purpose) {
                this.purpose = purpose;
                return this;
            }

            public Builder setSubmittedAt(Long submittedAt) {
                this.submittedAt = submittedAt;
                return this;
            }
        }
    }

    public static class CreditUser {
        @SerializedName(value="email")
        String email;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        String name;

        private CreditUser(String email, Map<String, Object> extraParams, String name) {
            this.email = email;
            this.extraParams = extraParams;
            this.name = name;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        public static class Builder {
            private String email;
            private Map<String, Object> extraParams;
            private String name;

            public CreditUser build() {
                return new CreditUser(this.email, this.extraParams, this.name);
            }

            public Builder setEmail(String email) {
                this.email = email;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }
        }
    }

    public static class Decision {
        @SerializedName(value="application_rejected")
        ApplicationRejected applicationRejected;
        @SerializedName(value="credit_limit_approved")
        CreditLimitApproved creditLimitApproved;
        @SerializedName(value="credit_limit_decreased")
        CreditLimitDecreased creditLimitDecreased;
        @SerializedName(value="credit_line_closed")
        CreditLineClosed creditLineClosed;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="type")
        Type type;

        private Decision(ApplicationRejected applicationRejected, CreditLimitApproved creditLimitApproved, CreditLimitDecreased creditLimitDecreased, CreditLineClosed creditLineClosed, Map<String, Object> extraParams, Type type) {
            this.applicationRejected = applicationRejected;
            this.creditLimitApproved = creditLimitApproved;
            this.creditLimitDecreased = creditLimitDecreased;
            this.creditLineClosed = creditLineClosed;
            this.extraParams = extraParams;
            this.type = type;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public ApplicationRejected getApplicationRejected() {
            return this.applicationRejected;
        }

        @Generated
        public CreditLimitApproved getCreditLimitApproved() {
            return this.creditLimitApproved;
        }

        @Generated
        public CreditLimitDecreased getCreditLimitDecreased() {
            return this.creditLimitDecreased;
        }

        @Generated
        public CreditLineClosed getCreditLineClosed() {
            return this.creditLineClosed;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        public static class ApplicationRejected {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reason_other_explanation")
            String reasonOtherExplanation;
            @SerializedName(value="reasons")
            List<Reason> reasons;

            private ApplicationRejected(Map<String, Object> extraParams, String reasonOtherExplanation, List<Reason> reasons) {
                this.extraParams = extraParams;
                this.reasonOtherExplanation = reasonOtherExplanation;
                this.reasons = reasons;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getReasonOtherExplanation() {
                return this.reasonOtherExplanation;
            }

            @Generated
            public List<Reason> getReasons() {
                return this.reasons;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String reasonOtherExplanation;
                private List<Reason> reasons;

                public ApplicationRejected build() {
                    return new ApplicationRejected(this.extraParams, this.reasonOtherExplanation, this.reasons);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setReasonOtherExplanation(String reasonOtherExplanation) {
                    this.reasonOtherExplanation = reasonOtherExplanation;
                    return this;
                }

                public Builder addReason(Reason element) {
                    if (this.reasons == null) {
                        this.reasons = new ArrayList<Reason>();
                    }
                    this.reasons.add(element);
                    return this;
                }

                public Builder addAllReason(List<Reason> elements) {
                    if (this.reasons == null) {
                        this.reasons = new ArrayList<Reason>();
                    }
                    this.reasons.addAll(elements);
                    return this;
                }
            }

            public static enum Reason implements ApiRequestParams.EnumParam
            {
                APPLICANT_IS_NOT_BENEFICIAL_OWNER("applicant_is_not_beneficial_owner"),
                APPLICANT_TOO_YOUNG("applicant_too_young"),
                APPLICATION_IS_NOT_BENEFICIAL_OWNER("application_is_not_beneficial_owner"),
                BANKRUPTCY("bankruptcy"),
                BUSINESS_SIZE_TOO_SMALL("business_size_too_small"),
                CURRENT_ACCOUNT_TIER_INELIGIBLE("current_account_tier_ineligible"),
                CUSTOMER_ALREADY_EXISTS("customer_already_exists"),
                CUSTOMER_REQUESTED_ACCOUNT_CLOSURE("customer_requested_account_closure"),
                DEBT_TO_CASH_BALANCE_RATIO_TOO_HIGH("debt_to_cash_balance_ratio_too_high"),
                DEBT_TO_EQUITY_RATIO_TOO_HIGH("debt_to_equity_ratio_too_high"),
                DELINQUENT_CREDIT_OBLIGATIONS("delinquent_credit_obligations"),
                DISPUTE_RATE_TOO_HIGH("dispute_rate_too_high"),
                DURATION_OF_RESIDENCE("duration_of_residence"),
                EXCESSIVE_INCOME_OR_REVENUE_OBLIGATIONS("excessive_income_or_revenue_obligations"),
                EXPENSES_TO_CASH_BALANCE_RATIO_TOO_HIGH("expenses_to_cash_balance_ratio_too_high"),
                FORECLOSURE_OR_REPOSSESSION("foreclosure_or_repossession"),
                FROZEN_FILE_AT_CREDIT_BUREAU("frozen_file_at_credit_bureau"),
                GARNISHMENT_OR_ATTACHMENT("garnishment_or_attachment"),
                GOVERNMENT_LOAN_PROGRAM_CRITERIA("government_loan_program_criteria"),
                HIGH_CONCENTRATION_OF_CLIENTS("high_concentration_of_clients"),
                INCOMPLETE_APPLICATION("incomplete_application"),
                INCONSISTENT_MONTHLY_REVENUES("inconsistent_monthly_revenues"),
                INSUFFICIENT_ACCOUNT_HISTORY_WITH_PLATFORM("insufficient_account_history_with_platform"),
                INSUFFICIENT_BANK_ACCOUNT_HISTORY("insufficient_bank_account_history"),
                INSUFFICIENT_CASH_BALANCE("insufficient_cash_balance"),
                INSUFFICIENT_CASH_FLOW("insufficient_cash_flow"),
                INSUFFICIENT_COLLATERAL("insufficient_collateral"),
                INSUFFICIENT_CREDIT_EXPERIENCE("insufficient_credit_experience"),
                INSUFFICIENT_DEPOSITS("insufficient_deposits"),
                INSUFFICIENT_INCOME("insufficient_income"),
                INSUFFICIENT_PERIOD_IN_OPERATION("insufficient_period_in_operation"),
                INSUFFICIENT_REVENUE("insufficient_revenue"),
                INSUFFICIENT_SOCIAL_MEDIA_PERFORMANCE("insufficient_social_media_performance"),
                INSUFFICIENT_TRADE_CREDIT_INSURANCE("insufficient_trade_credit_insurance"),
                INVALID_BUSINESS_LICENSE("invalid_business_license"),
                LATE_PAYMENT_HISTORY_REPORTED_TO_BUREAU("late_payment_history_reported_to_bureau"),
                LIEN_COLLECTION_ACTION_OR_JUDGEMENT("lien_collection_action_or_judgement"),
                NEGATIVE_PUBLIC_INFORMATION("negative_public_information"),
                NO_CREDIT_FILE("no_credit_file"),
                OTHER("other"),
                OUTSIDE_SUPPORTED_COUNTRY("outside_supported_country"),
                OUTSIDE_SUPPORTED_STATE("outside_supported_state"),
                PRIOR_OR_CURRENT_LEGAL_ACTION("prior_or_current_legal_action"),
                PROHIBITED_INDUSTRY("prohibited_industry"),
                RATE_OF_CASH_BALANCE_FLUCTUATION_TOO_HIGH("rate_of_cash_balance_fluctuation_too_high"),
                RECENT_INQUIRIES_ON_BUSINESS_CREDIT_REPORT("recent_inquiries_on_business_credit_report"),
                REMOVAL_OF_BANK_ACCOUNT_CONNECTION("removal_of_bank_account_connection"),
                REVENUE_DISCREPANCY("revenue_discrepancy"),
                RUNWAY_TOO_SHORT("runway_too_short"),
                SUSPECTED_FRAUD("suspected_fraud"),
                TOO_MANY_NON_SUFFICIENT_FUNDS_OR_OVERDRAFTS("too_many_non_sufficient_funds_or_overdrafts"),
                UNABLE_TO_VERIFY_ADDRESS("unable_to_verify_address"),
                UNABLE_TO_VERIFY_IDENTITY("unable_to_verify_identity"),
                UNABLE_TO_VERIFY_INCOME_OR_REVENUE("unable_to_verify_income_or_revenue"),
                UNPROFITABLE("unprofitable"),
                UNSUPPORTABLE_BUSINESS_TYPE("unsupportable_business_type");

                private final String value;

                private Reason(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class CreditLimitApproved {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private CreditLimitApproved(Long amount, String currency, Map<String, Object> extraParams) {
                this.amount = amount;
                this.currency = currency;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Long amount;
                private String currency;
                private Map<String, Object> extraParams;

                public CreditLimitApproved build() {
                    return new CreditLimitApproved(this.amount, this.currency, this.extraParams);
                }

                public Builder setAmount(Long amount) {
                    this.amount = amount;
                    return this;
                }

                public Builder setCurrency(String currency) {
                    this.currency = currency;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class CreditLimitDecreased {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reason_other_explanation")
            String reasonOtherExplanation;
            @SerializedName(value="reasons")
            List<Reason> reasons;

            private CreditLimitDecreased(Long amount, String currency, Map<String, Object> extraParams, String reasonOtherExplanation, List<Reason> reasons) {
                this.amount = amount;
                this.currency = currency;
                this.extraParams = extraParams;
                this.reasonOtherExplanation = reasonOtherExplanation;
                this.reasons = reasons;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getReasonOtherExplanation() {
                return this.reasonOtherExplanation;
            }

            @Generated
            public List<Reason> getReasons() {
                return this.reasons;
            }

            public static class Builder {
                private Long amount;
                private String currency;
                private Map<String, Object> extraParams;
                private String reasonOtherExplanation;
                private List<Reason> reasons;

                public CreditLimitDecreased build() {
                    return new CreditLimitDecreased(this.amount, this.currency, this.extraParams, this.reasonOtherExplanation, this.reasons);
                }

                public Builder setAmount(Long amount) {
                    this.amount = amount;
                    return this;
                }

                public Builder setCurrency(String currency) {
                    this.currency = currency;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setReasonOtherExplanation(String reasonOtherExplanation) {
                    this.reasonOtherExplanation = reasonOtherExplanation;
                    return this;
                }

                public Builder addReason(Reason element) {
                    if (this.reasons == null) {
                        this.reasons = new ArrayList<Reason>();
                    }
                    this.reasons.add(element);
                    return this;
                }

                public Builder addAllReason(List<Reason> elements) {
                    if (this.reasons == null) {
                        this.reasons = new ArrayList<Reason>();
                    }
                    this.reasons.addAll(elements);
                    return this;
                }
            }

            public static enum Reason implements ApiRequestParams.EnumParam
            {
                APPLICANT_IS_NOT_BENEFICIAL_OWNER("applicant_is_not_beneficial_owner"),
                APPLICANT_TOO_YOUNG("applicant_too_young"),
                APPLICATION_IS_NOT_BENEFICIAL_OWNER("application_is_not_beneficial_owner"),
                BANKRUPTCY("bankruptcy"),
                BUSINESS_SIZE_TOO_SMALL("business_size_too_small"),
                CHANGE_IN_FINANCIAL_STATE("change_in_financial_state"),
                CHANGE_IN_UTILIZATION_OF_CREDIT_LINE("change_in_utilization_of_credit_line"),
                CURRENT_ACCOUNT_TIER_INELIGIBLE("current_account_tier_ineligible"),
                CUSTOMER_ALREADY_EXISTS("customer_already_exists"),
                CUSTOMER_REQUESTED_ACCOUNT_CLOSURE("customer_requested_account_closure"),
                DEBT_TO_CASH_BALANCE_RATIO_TOO_HIGH("debt_to_cash_balance_ratio_too_high"),
                DEBT_TO_EQUITY_RATIO_TOO_HIGH("debt_to_equity_ratio_too_high"),
                DECREASE_IN_INCOME_TO_EXPENSE_RATIO("decrease_in_income_to_expense_ratio"),
                DECREASE_IN_SOCIAL_MEDIA_PERFORMANCE("decrease_in_social_media_performance"),
                DELINQUENT_CREDIT_OBLIGATIONS("delinquent_credit_obligations"),
                DISPUTE_RATE_TOO_HIGH("dispute_rate_too_high"),
                DURATION_OF_RESIDENCE("duration_of_residence"),
                EXCEEDS_ACCEPTABLE_PLATFORM_EXPOSURE("exceeds_acceptable_platform_exposure"),
                EXCESSIVE_INCOME_OR_REVENUE_OBLIGATIONS("excessive_income_or_revenue_obligations"),
                EXPENSES_TO_CASH_BALANCE_RATIO_TOO_HIGH("expenses_to_cash_balance_ratio_too_high"),
                FORECLOSURE_OR_REPOSSESSION("foreclosure_or_repossession"),
                FROZEN_FILE_AT_CREDIT_BUREAU("frozen_file_at_credit_bureau"),
                GARNISHMENT_OR_ATTACHMENT("garnishment_or_attachment"),
                GOVERNMENT_LOAN_PROGRAM_CRITERIA("government_loan_program_criteria"),
                HAS_RECENT_CREDIT_LIMIT_INCREASE("has_recent_credit_limit_increase"),
                HIGH_CONCENTRATION_OF_CLIENTS("high_concentration_of_clients"),
                INCOMPLETE_APPLICATION("incomplete_application"),
                INCONSISTENT_MONTHLY_REVENUES("inconsistent_monthly_revenues"),
                INSUFFICIENT_ACCOUNT_HISTORY_WITH_PLATFORM("insufficient_account_history_with_platform"),
                INSUFFICIENT_BANK_ACCOUNT_HISTORY("insufficient_bank_account_history"),
                INSUFFICIENT_CASH_BALANCE("insufficient_cash_balance"),
                INSUFFICIENT_CASH_FLOW("insufficient_cash_flow"),
                INSUFFICIENT_COLLATERAL("insufficient_collateral"),
                INSUFFICIENT_CREDIT_EXPERIENCE("insufficient_credit_experience"),
                INSUFFICIENT_CREDIT_UTILIZATION("insufficient_credit_utilization"),
                INSUFFICIENT_DEPOSITS("insufficient_deposits"),
                INSUFFICIENT_INCOME("insufficient_income"),
                INSUFFICIENT_PERIOD_IN_OPERATION("insufficient_period_in_operation"),
                INSUFFICIENT_REVENUE("insufficient_revenue"),
                INSUFFICIENT_SOCIAL_MEDIA_PERFORMANCE("insufficient_social_media_performance"),
                INSUFFICIENT_TRADE_CREDIT_INSURANCE("insufficient_trade_credit_insurance"),
                INSUFFICIENT_USAGE_AS_QUALIFIED_EXPENSES("insufficient_usage_as_qualified_expenses"),
                INVALID_BUSINESS_LICENSE("invalid_business_license"),
                LATE_PAYMENT_HISTORY_REPORTED_TO_BUREAU("late_payment_history_reported_to_bureau"),
                LIEN_COLLECTION_ACTION_OR_JUDGEMENT("lien_collection_action_or_judgement"),
                NEGATIVE_PUBLIC_INFORMATION("negative_public_information"),
                NO_CREDIT_FILE("no_credit_file"),
                OTHER("other"),
                OUTSIDE_SUPPORTED_COUNTRY("outside_supported_country"),
                OUTSIDE_SUPPORTED_STATE("outside_supported_state"),
                POOR_PAYMENT_HISTORY_WITH_PLATFORM("poor_payment_history_with_platform"),
                PRIOR_OR_CURRENT_LEGAL_ACTION("prior_or_current_legal_action"),
                PROHIBITED_INDUSTRY("prohibited_industry"),
                RATE_OF_CASH_BALANCE_FLUCTUATION_TOO_HIGH("rate_of_cash_balance_fluctuation_too_high"),
                RECENT_INQUIRIES_ON_BUSINESS_CREDIT_REPORT("recent_inquiries_on_business_credit_report"),
                REMOVAL_OF_BANK_ACCOUNT_CONNECTION("removal_of_bank_account_connection"),
                REVENUE_DISCREPANCY("revenue_discrepancy"),
                RUNWAY_TOO_SHORT("runway_too_short"),
                SUSPECTED_FRAUD("suspected_fraud"),
                TOO_MANY_NON_SUFFICIENT_FUNDS_OR_OVERDRAFTS("too_many_non_sufficient_funds_or_overdrafts"),
                UNABLE_TO_VERIFY_ADDRESS("unable_to_verify_address"),
                UNABLE_TO_VERIFY_IDENTITY("unable_to_verify_identity"),
                UNABLE_TO_VERIFY_INCOME_OR_REVENUE("unable_to_verify_income_or_revenue"),
                UNPROFITABLE("unprofitable"),
                UNSUPPORTABLE_BUSINESS_TYPE("unsupportable_business_type");

                private final String value;

                private Reason(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class CreditLineClosed {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reason_other_explanation")
            String reasonOtherExplanation;
            @SerializedName(value="reasons")
            List<Reason> reasons;

            private CreditLineClosed(Map<String, Object> extraParams, String reasonOtherExplanation, List<Reason> reasons) {
                this.extraParams = extraParams;
                this.reasonOtherExplanation = reasonOtherExplanation;
                this.reasons = reasons;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getReasonOtherExplanation() {
                return this.reasonOtherExplanation;
            }

            @Generated
            public List<Reason> getReasons() {
                return this.reasons;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String reasonOtherExplanation;
                private List<Reason> reasons;

                public CreditLineClosed build() {
                    return new CreditLineClosed(this.extraParams, this.reasonOtherExplanation, this.reasons);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setReasonOtherExplanation(String reasonOtherExplanation) {
                    this.reasonOtherExplanation = reasonOtherExplanation;
                    return this;
                }

                public Builder addReason(Reason element) {
                    if (this.reasons == null) {
                        this.reasons = new ArrayList<Reason>();
                    }
                    this.reasons.add(element);
                    return this;
                }

                public Builder addAllReason(List<Reason> elements) {
                    if (this.reasons == null) {
                        this.reasons = new ArrayList<Reason>();
                    }
                    this.reasons.addAll(elements);
                    return this;
                }
            }

            public static enum Reason implements ApiRequestParams.EnumParam
            {
                APPLICANT_IS_NOT_BENEFICIAL_OWNER("applicant_is_not_beneficial_owner"),
                APPLICANT_TOO_YOUNG("applicant_too_young"),
                APPLICATION_IS_NOT_BENEFICIAL_OWNER("application_is_not_beneficial_owner"),
                BANKRUPTCY("bankruptcy"),
                BUSINESS_SIZE_TOO_SMALL("business_size_too_small"),
                CHANGE_IN_FINANCIAL_STATE("change_in_financial_state"),
                CHANGE_IN_UTILIZATION_OF_CREDIT_LINE("change_in_utilization_of_credit_line"),
                CURRENT_ACCOUNT_TIER_INELIGIBLE("current_account_tier_ineligible"),
                CUSTOMER_ALREADY_EXISTS("customer_already_exists"),
                CUSTOMER_REQUESTED_ACCOUNT_CLOSURE("customer_requested_account_closure"),
                DEBT_TO_CASH_BALANCE_RATIO_TOO_HIGH("debt_to_cash_balance_ratio_too_high"),
                DEBT_TO_EQUITY_RATIO_TOO_HIGH("debt_to_equity_ratio_too_high"),
                DECREASE_IN_INCOME_TO_EXPENSE_RATIO("decrease_in_income_to_expense_ratio"),
                DECREASE_IN_SOCIAL_MEDIA_PERFORMANCE("decrease_in_social_media_performance"),
                DELINQUENT_CREDIT_OBLIGATIONS("delinquent_credit_obligations"),
                DISPUTE_RATE_TOO_HIGH("dispute_rate_too_high"),
                DURATION_OF_RESIDENCE("duration_of_residence"),
                EXCEEDS_ACCEPTABLE_PLATFORM_EXPOSURE("exceeds_acceptable_platform_exposure"),
                EXCESSIVE_INCOME_OR_REVENUE_OBLIGATIONS("excessive_income_or_revenue_obligations"),
                EXPENSES_TO_CASH_BALANCE_RATIO_TOO_HIGH("expenses_to_cash_balance_ratio_too_high"),
                FORECLOSURE_OR_REPOSSESSION("foreclosure_or_repossession"),
                FROZEN_FILE_AT_CREDIT_BUREAU("frozen_file_at_credit_bureau"),
                GARNISHMENT_OR_ATTACHMENT("garnishment_or_attachment"),
                GOVERNMENT_LOAN_PROGRAM_CRITERIA("government_loan_program_criteria"),
                HAS_RECENT_CREDIT_LIMIT_INCREASE("has_recent_credit_limit_increase"),
                HIGH_CONCENTRATION_OF_CLIENTS("high_concentration_of_clients"),
                INCOMPLETE_APPLICATION("incomplete_application"),
                INCONSISTENT_MONTHLY_REVENUES("inconsistent_monthly_revenues"),
                INSUFFICIENT_ACCOUNT_HISTORY_WITH_PLATFORM("insufficient_account_history_with_platform"),
                INSUFFICIENT_BANK_ACCOUNT_HISTORY("insufficient_bank_account_history"),
                INSUFFICIENT_CASH_BALANCE("insufficient_cash_balance"),
                INSUFFICIENT_CASH_FLOW("insufficient_cash_flow"),
                INSUFFICIENT_COLLATERAL("insufficient_collateral"),
                INSUFFICIENT_CREDIT_EXPERIENCE("insufficient_credit_experience"),
                INSUFFICIENT_CREDIT_UTILIZATION("insufficient_credit_utilization"),
                INSUFFICIENT_DEPOSITS("insufficient_deposits"),
                INSUFFICIENT_INCOME("insufficient_income"),
                INSUFFICIENT_PERIOD_IN_OPERATION("insufficient_period_in_operation"),
                INSUFFICIENT_REVENUE("insufficient_revenue"),
                INSUFFICIENT_SOCIAL_MEDIA_PERFORMANCE("insufficient_social_media_performance"),
                INSUFFICIENT_TRADE_CREDIT_INSURANCE("insufficient_trade_credit_insurance"),
                INSUFFICIENT_USAGE_AS_QUALIFIED_EXPENSES("insufficient_usage_as_qualified_expenses"),
                INVALID_BUSINESS_LICENSE("invalid_business_license"),
                LATE_PAYMENT_HISTORY_REPORTED_TO_BUREAU("late_payment_history_reported_to_bureau"),
                LIEN_COLLECTION_ACTION_OR_JUDGEMENT("lien_collection_action_or_judgement"),
                NEGATIVE_PUBLIC_INFORMATION("negative_public_information"),
                NO_CREDIT_FILE("no_credit_file"),
                OTHER("other"),
                OUTSIDE_SUPPORTED_COUNTRY("outside_supported_country"),
                OUTSIDE_SUPPORTED_STATE("outside_supported_state"),
                POOR_PAYMENT_HISTORY_WITH_PLATFORM("poor_payment_history_with_platform"),
                PRIOR_OR_CURRENT_LEGAL_ACTION("prior_or_current_legal_action"),
                PROHIBITED_INDUSTRY("prohibited_industry"),
                RATE_OF_CASH_BALANCE_FLUCTUATION_TOO_HIGH("rate_of_cash_balance_fluctuation_too_high"),
                RECENT_INQUIRIES_ON_BUSINESS_CREDIT_REPORT("recent_inquiries_on_business_credit_report"),
                REMOVAL_OF_BANK_ACCOUNT_CONNECTION("removal_of_bank_account_connection"),
                REVENUE_DISCREPANCY("revenue_discrepancy"),
                RUNWAY_TOO_SHORT("runway_too_short"),
                SUSPECTED_FRAUD("suspected_fraud"),
                TOO_MANY_NON_SUFFICIENT_FUNDS_OR_OVERDRAFTS("too_many_non_sufficient_funds_or_overdrafts"),
                UNABLE_TO_VERIFY_ADDRESS("unable_to_verify_address"),
                UNABLE_TO_VERIFY_IDENTITY("unable_to_verify_identity"),
                UNABLE_TO_VERIFY_INCOME_OR_REVENUE("unable_to_verify_income_or_revenue"),
                UNPROFITABLE("unprofitable"),
                UNSUPPORTABLE_BUSINESS_TYPE("unsupportable_business_type");

                private final String value;

                private Reason(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            ADDITIONAL_INFORMATION_REQUESTED("additional_information_requested"),
            APPLICATION_REJECTED("application_rejected"),
            CREDIT_LIMIT_APPROVED("credit_limit_approved"),
            CREDIT_LIMIT_DECREASED("credit_limit_decreased"),
            CREDIT_LINE_CLOSED("credit_line_closed"),
            NO_CHANGES("no_changes"),
            WITHDRAWN_BY_APPLICANT("withdrawn_by_applicant");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private ApplicationRejected applicationRejected;
            private CreditLimitApproved creditLimitApproved;
            private CreditLimitDecreased creditLimitDecreased;
            private CreditLineClosed creditLineClosed;
            private Map<String, Object> extraParams;
            private Type type;

            public Decision build() {
                return new Decision(this.applicationRejected, this.creditLimitApproved, this.creditLimitDecreased, this.creditLineClosed, this.extraParams, this.type);
            }

            public Builder setApplicationRejected(ApplicationRejected applicationRejected) {
                this.applicationRejected = applicationRejected;
                return this;
            }

            public Builder setCreditLimitApproved(CreditLimitApproved creditLimitApproved) {
                this.creditLimitApproved = creditLimitApproved;
                return this;
            }

            public Builder setCreditLimitDecreased(CreditLimitDecreased creditLimitDecreased) {
                this.creditLimitDecreased = creditLimitDecreased;
                return this;
            }

            public Builder setCreditLineClosed(CreditLineClosed creditLineClosed) {
                this.creditLineClosed = creditLineClosed;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }
        }
    }

    public static class UnderwritingException {
        @SerializedName(value="explanation")
        String explanation;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="original_decision_type")
        OriginalDecisionType originalDecisionType;

        private UnderwritingException(String explanation, Map<String, Object> extraParams, OriginalDecisionType originalDecisionType) {
            this.explanation = explanation;
            this.extraParams = extraParams;
            this.originalDecisionType = originalDecisionType;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getExplanation() {
            return this.explanation;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public OriginalDecisionType getOriginalDecisionType() {
            return this.originalDecisionType;
        }

        public static enum OriginalDecisionType implements ApiRequestParams.EnumParam
        {
            ADDITIONAL_INFORMATION_REQUESTED("additional_information_requested"),
            APPLICATION_REJECTED("application_rejected"),
            CREDIT_LIMIT_APPROVED("credit_limit_approved"),
            CREDIT_LIMIT_DECREASED("credit_limit_decreased"),
            CREDIT_LINE_CLOSED("credit_line_closed"),
            NO_CHANGES("no_changes"),
            WITHDRAWN_BY_APPLICANT("withdrawn_by_applicant");

            private final String value;

            private OriginalDecisionType(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private String explanation;
            private Map<String, Object> extraParams;
            private OriginalDecisionType originalDecisionType;

            public UnderwritingException build() {
                return new UnderwritingException(this.explanation, this.extraParams, this.originalDecisionType);
            }

            public Builder setExplanation(String explanation) {
                this.explanation = explanation;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setOriginalDecisionType(OriginalDecisionType originalDecisionType) {
                this.originalDecisionType = originalDecisionType;
                return this;
            }
        }
    }

    public static class Builder {
        private Application application;
        private CreditUser creditUser;
        private Long decidedAt;
        private Decision decision;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Map<String, String> metadata;
        private UnderwritingException underwritingException;

        public CreditUnderwritingRecordCorrectParams build() {
            return new CreditUnderwritingRecordCorrectParams(this.application, this.creditUser, this.decidedAt, this.decision, this.expand, this.extraParams, this.metadata, this.underwritingException);
        }

        public Builder setApplication(Application application) {
            this.application = application;
            return this;
        }

        public Builder setCreditUser(CreditUser creditUser) {
            this.creditUser = creditUser;
            return this;
        }

        public Builder setDecidedAt(Long decidedAt) {
            this.decidedAt = decidedAt;
            return this;
        }

        public Builder setDecision(Decision decision) {
            this.decision = decision;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setUnderwritingException(UnderwritingException underwritingException) {
            this.underwritingException = underwritingException;
            return this;
        }
    }
}

