// File generated from our OpenAPI spec
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.QuotePreviewSubscriptionSchedule;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.QuotePreviewSubscriptionScheduleListParams;

public final class QuotePreviewSubscriptionScheduleService extends ApiService {
  public QuotePreviewSubscriptionScheduleService(StripeResponseGetter responseGetter) {
    super(responseGetter);
  }

  /** Preview the schedules that would be generated by accepting the quote. */
  public StripeCollection<QuotePreviewSubscriptionSchedule> list(
      String quote, QuotePreviewSubscriptionScheduleListParams params) throws StripeException {
    return list(quote, params, (RequestOptions) null);
  }
  /** Preview the schedules that would be generated by accepting the quote. */
  public StripeCollection<QuotePreviewSubscriptionSchedule> list(
      String quote, RequestOptions options) throws StripeException {
    return list(quote, (QuotePreviewSubscriptionScheduleListParams) null, options);
  }
  /** Preview the schedules that would be generated by accepting the quote. */
  public StripeCollection<QuotePreviewSubscriptionSchedule> list(String quote)
      throws StripeException {
    return list(quote, (QuotePreviewSubscriptionScheduleListParams) null, (RequestOptions) null);
  }
  /** Preview the schedules that would be generated by accepting the quote. */
  public StripeCollection<QuotePreviewSubscriptionSchedule> list(
      String quote, QuotePreviewSubscriptionScheduleListParams params, RequestOptions options)
      throws StripeException {
    String path =
        String.format(
            "/v1/quotes/%s/preview_subscription_schedules", ApiResource.urlEncodeId(quote));
    return getResponseGetter()
        .request(
            BaseAddress.API,
            ApiResource.RequestMethod.GET,
            path,
            ApiRequestParams.paramsToMap(params),
            new TypeToken<StripeCollection<QuotePreviewSubscriptionSchedule>>() {}.getType(),
            options,
            ApiMode.V1);
  }
}
