/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.AccountCollection;
import com.stripe.model.Address;
import com.stripe.model.CapabilityCollection;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.File;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentSource;
import com.stripe.model.Person;
import com.stripe.model.PersonCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.AccountCapabilitiesParams;
import com.stripe.param.AccountCreateParams;
import com.stripe.param.AccountListParams;
import com.stripe.param.AccountPersonsParams;
import com.stripe.param.AccountRejectParams;
import com.stripe.param.AccountRetrieveParams;
import com.stripe.param.AccountUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Account
extends ApiResource
implements MetadataStore<Account>,
PaymentSource {
    @SerializedName(value="business_profile")
    BusinessProfile businessProfile;
    @SerializedName(value="business_type")
    String businessType;
    @SerializedName(value="capabilities")
    Capabilities capabilities;
    @SerializedName(value="charges_enabled")
    Boolean chargesEnabled;
    @SerializedName(value="company")
    Company company;
    @SerializedName(value="controller")
    Controller controller;
    @SerializedName(value="country")
    String country;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="default_currency")
    String defaultCurrency;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="details_submitted")
    Boolean detailsSubmitted;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="external_accounts")
    ExternalAccountCollection externalAccounts;
    @SerializedName(value="future_requirements")
    FutureRequirements futureRequirements;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="individual")
    Person individual;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payouts_enabled")
    Boolean payoutsEnabled;
    @SerializedName(value="requirements")
    Requirements requirements;
    @SerializedName(value="settings")
    Settings settings;
    @SerializedName(value="tos_acceptance")
    TosAcceptance tosAcceptance;
    @SerializedName(value="type")
    String type;

    public CapabilityCollection capabilities() throws StripeException {
        return this.capabilities((Map<String, Object>)null, (RequestOptions)null);
    }

    public CapabilityCollection capabilities(Map<String, Object> params) throws StripeException {
        return this.capabilities(params, (RequestOptions)null);
    }

    public CapabilityCollection capabilities(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/capabilities", ApiResource.urlEncodeId(this.getId()));
        return (CapabilityCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)CapabilityCollection.class), options, ApiMode.V1);
    }

    public CapabilityCollection capabilities(AccountCapabilitiesParams params) throws StripeException {
        return this.capabilities(params, (RequestOptions)null);
    }

    public CapabilityCollection capabilities(AccountCapabilitiesParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/capabilities", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (CapabilityCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CapabilityCollection.class), options, ApiMode.V1);
    }

    public static Account create(Map<String, Object> params) throws StripeException {
        return Account.create(params, (RequestOptions)null);
    }

    public static Account create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/accounts";
        return (Account)Account.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public static Account create(AccountCreateParams params) throws StripeException {
        return Account.create(params, (RequestOptions)null);
    }

    public static Account create(AccountCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/accounts";
        ApiResource.checkNullTypedParams(path, params);
        return (Account)Account.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public Account delete() throws StripeException {
        return this.delete(null, null);
    }

    public Account delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Account delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Account delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s", ApiResource.urlEncodeId(this.getId()));
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public static AccountCollection list(Map<String, Object> params) throws StripeException {
        return Account.list(params, (RequestOptions)null);
    }

    public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/accounts";
        return (AccountCollection)Account.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)AccountCollection.class), options, ApiMode.V1);
    }

    public static AccountCollection list(AccountListParams params) throws StripeException {
        return Account.list(params, (RequestOptions)null);
    }

    public static AccountCollection list(AccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/accounts";
        ApiResource.checkNullTypedParams(path, params);
        return (AccountCollection)Account.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)AccountCollection.class), options, ApiMode.V1);
    }

    public PersonCollection persons() throws StripeException {
        return this.persons((Map<String, Object>)null, (RequestOptions)null);
    }

    public PersonCollection persons(Map<String, Object> params) throws StripeException {
        return this.persons(params, (RequestOptions)null);
    }

    public PersonCollection persons(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(this.getId()));
        return (PersonCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)PersonCollection.class), options, ApiMode.V1);
    }

    public PersonCollection persons(AccountPersonsParams params) throws StripeException {
        return this.persons(params, (RequestOptions)null);
    }

    public PersonCollection persons(AccountPersonsParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (PersonCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PersonCollection.class), options, ApiMode.V1);
    }

    public Account reject(Map<String, Object> params) throws StripeException {
        return this.reject(params, (RequestOptions)null);
    }

    public Account reject(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/reject", ApiResource.urlEncodeId(this.getId()));
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public Account reject(AccountRejectParams params) throws StripeException {
        return this.reject(params, (RequestOptions)null);
    }

    public Account reject(AccountRejectParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/reject", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public static Account retrieve() throws StripeException {
        return Account.retrieve((Map<String, Object>)null, (RequestOptions)null);
    }

    public static Account retrieve(RequestOptions options) throws StripeException {
        return Account.retrieve((Map<String, Object>)null, options);
    }

    public static Account retrieve(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/account";
        return (Account)Account.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public static Account retrieve(AccountRetrieveParams params, RequestOptions options) throws StripeException {
        String path = "/v1/account";
        ApiResource.checkNullTypedParams(path, params);
        return (Account)Account.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public static Account retrieve(String account) throws StripeException {
        return Account.retrieve(account, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Account retrieve(String account, RequestOptions options) throws StripeException {
        return Account.retrieve(account, (Map<String, Object>)null, options);
    }

    public static Account retrieve(String account, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s", ApiResource.urlEncodeId(account));
        return (Account)Account.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public static Account retrieve(String account, AccountRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s", ApiResource.urlEncodeId(account));
        ApiResource.checkNullTypedParams(path, params);
        return (Account)Account.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public Account update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Account update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s", ApiResource.urlEncodeId(this.getId()));
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public Account update(AccountUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Account update(AccountUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.businessProfile, responseGetter);
        this.trySetResponseGetter(this.capabilities, responseGetter);
        this.trySetResponseGetter(this.company, responseGetter);
        this.trySetResponseGetter(this.controller, responseGetter);
        this.trySetResponseGetter(this.externalAccounts, responseGetter);
        this.trySetResponseGetter(this.futureRequirements, responseGetter);
        this.trySetResponseGetter(this.individual, responseGetter);
        this.trySetResponseGetter(this.requirements, responseGetter);
        this.trySetResponseGetter(this.settings, responseGetter);
        this.trySetResponseGetter(this.tosAcceptance, responseGetter);
    }

    @Generated
    public BusinessProfile getBusinessProfile() {
        return this.businessProfile;
    }

    @Generated
    public String getBusinessType() {
        return this.businessType;
    }

    @Generated
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Generated
    public Boolean getChargesEnabled() {
        return this.chargesEnabled;
    }

    @Generated
    public Company getCompany() {
        return this.company;
    }

    @Generated
    public Controller getController() {
        return this.controller;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getDetailsSubmitted() {
        return this.detailsSubmitted;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public ExternalAccountCollection getExternalAccounts() {
        return this.externalAccounts;
    }

    @Generated
    public FutureRequirements getFutureRequirements() {
        return this.futureRequirements;
    }

    @Generated
    public Person getIndividual() {
        return this.individual;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Boolean getPayoutsEnabled() {
        return this.payoutsEnabled;
    }

    @Generated
    public Requirements getRequirements() {
        return this.requirements;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public TosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setBusinessProfile(BusinessProfile businessProfile) {
        this.businessProfile = businessProfile;
    }

    @Generated
    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Generated
    public void setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Generated
    public void setChargesEnabled(Boolean chargesEnabled) {
        this.chargesEnabled = chargesEnabled;
    }

    @Generated
    public void setCompany(Company company) {
        this.company = company;
    }

    @Generated
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDetailsSubmitted(Boolean detailsSubmitted) {
        this.detailsSubmitted = detailsSubmitted;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setExternalAccounts(ExternalAccountCollection externalAccounts) {
        this.externalAccounts = externalAccounts;
    }

    @Generated
    public void setFutureRequirements(FutureRequirements futureRequirements) {
        this.futureRequirements = futureRequirements;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIndividual(Person individual) {
        this.individual = individual;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPayoutsEnabled(Boolean payoutsEnabled) {
        this.payoutsEnabled = payoutsEnabled;
    }

    @Generated
    public void setRequirements(Requirements requirements) {
        this.requirements = requirements;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public void setTosAcceptance(TosAcceptance tosAcceptance) {
        this.tosAcceptance = tosAcceptance;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$chargesEnabled = this.getChargesEnabled();
        Boolean other$chargesEnabled = other.getChargesEnabled();
        if (this$chargesEnabled == null ? other$chargesEnabled != null : !((Object)this$chargesEnabled).equals(other$chargesEnabled)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$detailsSubmitted = this.getDetailsSubmitted();
        Boolean other$detailsSubmitted = other.getDetailsSubmitted();
        if (this$detailsSubmitted == null ? other$detailsSubmitted != null : !((Object)this$detailsSubmitted).equals(other$detailsSubmitted)) {
            return false;
        }
        Boolean this$payoutsEnabled = this.getPayoutsEnabled();
        Boolean other$payoutsEnabled = other.getPayoutsEnabled();
        if (this$payoutsEnabled == null ? other$payoutsEnabled != null : !((Object)this$payoutsEnabled).equals(other$payoutsEnabled)) {
            return false;
        }
        BusinessProfile this$businessProfile = this.getBusinessProfile();
        BusinessProfile other$businessProfile = other.getBusinessProfile();
        if (this$businessProfile == null ? other$businessProfile != null : !((Object)this$businessProfile).equals(other$businessProfile)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        Capabilities this$capabilities = this.getCapabilities();
        Capabilities other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        Company this$company = this.getCompany();
        Company other$company = other.getCompany();
        if (this$company == null ? other$company != null : !((Object)this$company).equals(other$company)) {
            return false;
        }
        Controller this$controller = this.getController();
        Controller other$controller = other.getController();
        if (this$controller == null ? other$controller != null : !((Object)this$controller).equals(other$controller)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$defaultCurrency = this.getDefaultCurrency();
        String other$defaultCurrency = other.getDefaultCurrency();
        if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        ExternalAccountCollection this$externalAccounts = this.getExternalAccounts();
        ExternalAccountCollection other$externalAccounts = other.getExternalAccounts();
        if (this$externalAccounts == null ? other$externalAccounts != null : !((Object)this$externalAccounts).equals(other$externalAccounts)) {
            return false;
        }
        FutureRequirements this$futureRequirements = this.getFutureRequirements();
        FutureRequirements other$futureRequirements = other.getFutureRequirements();
        if (this$futureRequirements == null ? other$futureRequirements != null : !((Object)this$futureRequirements).equals(other$futureRequirements)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Person this$individual = this.getIndividual();
        Person other$individual = other.getIndividual();
        if (this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Requirements this$requirements = this.getRequirements();
        Requirements other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        TosAcceptance this$tosAcceptance = this.getTosAcceptance();
        TosAcceptance other$tosAcceptance = other.getTosAcceptance();
        if (this$tosAcceptance == null ? other$tosAcceptance != null : !((Object)this$tosAcceptance).equals(other$tosAcceptance)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $chargesEnabled = this.getChargesEnabled();
        result = result * 59 + ($chargesEnabled == null ? 43 : ((Object)$chargesEnabled).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $detailsSubmitted = this.getDetailsSubmitted();
        result = result * 59 + ($detailsSubmitted == null ? 43 : ((Object)$detailsSubmitted).hashCode());
        Boolean $payoutsEnabled = this.getPayoutsEnabled();
        result = result * 59 + ($payoutsEnabled == null ? 43 : ((Object)$payoutsEnabled).hashCode());
        BusinessProfile $businessProfile = this.getBusinessProfile();
        result = result * 59 + ($businessProfile == null ? 43 : ((Object)$businessProfile).hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        Capabilities $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        Company $company = this.getCompany();
        result = result * 59 + ($company == null ? 43 : ((Object)$company).hashCode());
        Controller $controller = this.getController();
        result = result * 59 + ($controller == null ? 43 : ((Object)$controller).hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $defaultCurrency = this.getDefaultCurrency();
        result = result * 59 + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        ExternalAccountCollection $externalAccounts = this.getExternalAccounts();
        result = result * 59 + ($externalAccounts == null ? 43 : ((Object)$externalAccounts).hashCode());
        FutureRequirements $futureRequirements = this.getFutureRequirements();
        result = result * 59 + ($futureRequirements == null ? 43 : ((Object)$futureRequirements).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Person $individual = this.getIndividual();
        result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Requirements $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        TosAcceptance $tosAcceptance = this.getTosAcceptance();
        result = result * 59 + ($tosAcceptance == null ? 43 : ((Object)$tosAcceptance).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class BusinessProfile
    extends StripeObject {
        @SerializedName(value="mcc")
        String mcc;
        @SerializedName(value="monthly_estimated_revenue")
        MonthlyEstimatedRevenue monthlyEstimatedRevenue;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="product_description")
        String productDescription;
        @SerializedName(value="support_address")
        Address supportAddress;
        @SerializedName(value="support_email")
        String supportEmail;
        @SerializedName(value="support_phone")
        String supportPhone;
        @SerializedName(value="support_url")
        String supportUrl;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getMcc() {
            return this.mcc;
        }

        @Generated
        public MonthlyEstimatedRevenue getMonthlyEstimatedRevenue() {
            return this.monthlyEstimatedRevenue;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getProductDescription() {
            return this.productDescription;
        }

        @Generated
        public Address getSupportAddress() {
            return this.supportAddress;
        }

        @Generated
        public String getSupportEmail() {
            return this.supportEmail;
        }

        @Generated
        public String getSupportPhone() {
            return this.supportPhone;
        }

        @Generated
        public String getSupportUrl() {
            return this.supportUrl;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setMcc(String mcc) {
            this.mcc = mcc;
        }

        @Generated
        public void setMonthlyEstimatedRevenue(MonthlyEstimatedRevenue monthlyEstimatedRevenue) {
            this.monthlyEstimatedRevenue = monthlyEstimatedRevenue;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Generated
        public void setSupportAddress(Address supportAddress) {
            this.supportAddress = supportAddress;
        }

        @Generated
        public void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Generated
        public void setSupportPhone(String supportPhone) {
            this.supportPhone = supportPhone;
        }

        @Generated
        public void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BusinessProfile)) {
                return false;
            }
            BusinessProfile other = (BusinessProfile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mcc = this.getMcc();
            String other$mcc = other.getMcc();
            if (this$mcc == null ? other$mcc != null : !this$mcc.equals(other$mcc)) {
                return false;
            }
            MonthlyEstimatedRevenue this$monthlyEstimatedRevenue = this.getMonthlyEstimatedRevenue();
            MonthlyEstimatedRevenue other$monthlyEstimatedRevenue = other.getMonthlyEstimatedRevenue();
            if (this$monthlyEstimatedRevenue == null ? other$monthlyEstimatedRevenue != null : !((Object)this$monthlyEstimatedRevenue).equals(other$monthlyEstimatedRevenue)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$productDescription = this.getProductDescription();
            String other$productDescription = other.getProductDescription();
            if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                return false;
            }
            Address this$supportAddress = this.getSupportAddress();
            Address other$supportAddress = other.getSupportAddress();
            if (this$supportAddress == null ? other$supportAddress != null : !((Object)this$supportAddress).equals(other$supportAddress)) {
                return false;
            }
            String this$supportEmail = this.getSupportEmail();
            String other$supportEmail = other.getSupportEmail();
            if (this$supportEmail == null ? other$supportEmail != null : !this$supportEmail.equals(other$supportEmail)) {
                return false;
            }
            String this$supportPhone = this.getSupportPhone();
            String other$supportPhone = other.getSupportPhone();
            if (this$supportPhone == null ? other$supportPhone != null : !this$supportPhone.equals(other$supportPhone)) {
                return false;
            }
            String this$supportUrl = this.getSupportUrl();
            String other$supportUrl = other.getSupportUrl();
            if (this$supportUrl == null ? other$supportUrl != null : !this$supportUrl.equals(other$supportUrl)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BusinessProfile;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mcc = this.getMcc();
            result = result * 59 + ($mcc == null ? 43 : $mcc.hashCode());
            MonthlyEstimatedRevenue $monthlyEstimatedRevenue = this.getMonthlyEstimatedRevenue();
            result = result * 59 + ($monthlyEstimatedRevenue == null ? 43 : ((Object)$monthlyEstimatedRevenue).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $productDescription = this.getProductDescription();
            result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
            Address $supportAddress = this.getSupportAddress();
            result = result * 59 + ($supportAddress == null ? 43 : ((Object)$supportAddress).hashCode());
            String $supportEmail = this.getSupportEmail();
            result = result * 59 + ($supportEmail == null ? 43 : $supportEmail.hashCode());
            String $supportPhone = this.getSupportPhone();
            result = result * 59 + ($supportPhone == null ? 43 : $supportPhone.hashCode());
            String $supportUrl = this.getSupportUrl();
            result = result * 59 + ($supportUrl == null ? 43 : $supportUrl.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public static class MonthlyEstimatedRevenue
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MonthlyEstimatedRevenue)) {
                    return false;
                }
                MonthlyEstimatedRevenue other = (MonthlyEstimatedRevenue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof MonthlyEstimatedRevenue;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                return result;
            }
        }
    }

    public static class Capabilities
    extends StripeObject {
        @SerializedName(value="acss_debit_payments")
        String acssDebitPayments;
        @SerializedName(value="affirm_payments")
        String affirmPayments;
        @SerializedName(value="afterpay_clearpay_payments")
        String afterpayClearpayPayments;
        @SerializedName(value="au_becs_debit_payments")
        String auBecsDebitPayments;
        @SerializedName(value="bacs_debit_payments")
        String bacsDebitPayments;
        @SerializedName(value="bancontact_payments")
        String bancontactPayments;
        @SerializedName(value="bank_transfer_payments")
        String bankTransferPayments;
        @SerializedName(value="blik_payments")
        String blikPayments;
        @SerializedName(value="boleto_payments")
        String boletoPayments;
        @SerializedName(value="card_issuing")
        String cardIssuing;
        @SerializedName(value="card_payments")
        String cardPayments;
        @SerializedName(value="cartes_bancaires_payments")
        String cartesBancairesPayments;
        @SerializedName(value="cashapp_payments")
        String cashappPayments;
        @SerializedName(value="eps_payments")
        String epsPayments;
        @SerializedName(value="fpx_payments")
        String fpxPayments;
        @SerializedName(value="giropay_payments")
        String giropayPayments;
        @SerializedName(value="grabpay_payments")
        String grabpayPayments;
        @SerializedName(value="ideal_payments")
        String idealPayments;
        @SerializedName(value="india_international_payments")
        String indiaInternationalPayments;
        @SerializedName(value="jcb_payments")
        String jcbPayments;
        @SerializedName(value="klarna_payments")
        String klarnaPayments;
        @SerializedName(value="konbini_payments")
        String konbiniPayments;
        @SerializedName(value="legacy_payments")
        String legacyPayments;
        @SerializedName(value="link_payments")
        String linkPayments;
        @SerializedName(value="oxxo_payments")
        String oxxoPayments;
        @SerializedName(value="p24_payments")
        String p24Payments;
        @SerializedName(value="paynow_payments")
        String paynowPayments;
        @SerializedName(value="paypal_payments")
        String paypalPayments;
        @SerializedName(value="promptpay_payments")
        String promptpayPayments;
        @SerializedName(value="revolut_pay_payments")
        String revolutPayPayments;
        @SerializedName(value="sepa_debit_payments")
        String sepaDebitPayments;
        @SerializedName(value="sofort_payments")
        String sofortPayments;
        @SerializedName(value="tax_reporting_us_1099_k")
        String taxReportingUs1099K;
        @SerializedName(value="tax_reporting_us_1099_misc")
        String taxReportingUs1099Misc;
        @SerializedName(value="transfers")
        String transfers;
        @SerializedName(value="treasury")
        String treasury;
        @SerializedName(value="us_bank_account_ach_payments")
        String usBankAccountAchPayments;
        @SerializedName(value="zip_payments")
        String zipPayments;

        @Generated
        public String getAcssDebitPayments() {
            return this.acssDebitPayments;
        }

        @Generated
        public String getAffirmPayments() {
            return this.affirmPayments;
        }

        @Generated
        public String getAfterpayClearpayPayments() {
            return this.afterpayClearpayPayments;
        }

        @Generated
        public String getAuBecsDebitPayments() {
            return this.auBecsDebitPayments;
        }

        @Generated
        public String getBacsDebitPayments() {
            return this.bacsDebitPayments;
        }

        @Generated
        public String getBancontactPayments() {
            return this.bancontactPayments;
        }

        @Generated
        public String getBankTransferPayments() {
            return this.bankTransferPayments;
        }

        @Generated
        public String getBlikPayments() {
            return this.blikPayments;
        }

        @Generated
        public String getBoletoPayments() {
            return this.boletoPayments;
        }

        @Generated
        public String getCardIssuing() {
            return this.cardIssuing;
        }

        @Generated
        public String getCardPayments() {
            return this.cardPayments;
        }

        @Generated
        public String getCartesBancairesPayments() {
            return this.cartesBancairesPayments;
        }

        @Generated
        public String getCashappPayments() {
            return this.cashappPayments;
        }

        @Generated
        public String getEpsPayments() {
            return this.epsPayments;
        }

        @Generated
        public String getFpxPayments() {
            return this.fpxPayments;
        }

        @Generated
        public String getGiropayPayments() {
            return this.giropayPayments;
        }

        @Generated
        public String getGrabpayPayments() {
            return this.grabpayPayments;
        }

        @Generated
        public String getIdealPayments() {
            return this.idealPayments;
        }

        @Generated
        public String getIndiaInternationalPayments() {
            return this.indiaInternationalPayments;
        }

        @Generated
        public String getJcbPayments() {
            return this.jcbPayments;
        }

        @Generated
        public String getKlarnaPayments() {
            return this.klarnaPayments;
        }

        @Generated
        public String getKonbiniPayments() {
            return this.konbiniPayments;
        }

        @Generated
        public String getLegacyPayments() {
            return this.legacyPayments;
        }

        @Generated
        public String getLinkPayments() {
            return this.linkPayments;
        }

        @Generated
        public String getOxxoPayments() {
            return this.oxxoPayments;
        }

        @Generated
        public String getP24Payments() {
            return this.p24Payments;
        }

        @Generated
        public String getPaynowPayments() {
            return this.paynowPayments;
        }

        @Generated
        public String getPaypalPayments() {
            return this.paypalPayments;
        }

        @Generated
        public String getPromptpayPayments() {
            return this.promptpayPayments;
        }

        @Generated
        public String getRevolutPayPayments() {
            return this.revolutPayPayments;
        }

        @Generated
        public String getSepaDebitPayments() {
            return this.sepaDebitPayments;
        }

        @Generated
        public String getSofortPayments() {
            return this.sofortPayments;
        }

        @Generated
        public String getTaxReportingUs1099K() {
            return this.taxReportingUs1099K;
        }

        @Generated
        public String getTaxReportingUs1099Misc() {
            return this.taxReportingUs1099Misc;
        }

        @Generated
        public String getTransfers() {
            return this.transfers;
        }

        @Generated
        public String getTreasury() {
            return this.treasury;
        }

        @Generated
        public String getUsBankAccountAchPayments() {
            return this.usBankAccountAchPayments;
        }

        @Generated
        public String getZipPayments() {
            return this.zipPayments;
        }

        @Generated
        public void setAcssDebitPayments(String acssDebitPayments) {
            this.acssDebitPayments = acssDebitPayments;
        }

        @Generated
        public void setAffirmPayments(String affirmPayments) {
            this.affirmPayments = affirmPayments;
        }

        @Generated
        public void setAfterpayClearpayPayments(String afterpayClearpayPayments) {
            this.afterpayClearpayPayments = afterpayClearpayPayments;
        }

        @Generated
        public void setAuBecsDebitPayments(String auBecsDebitPayments) {
            this.auBecsDebitPayments = auBecsDebitPayments;
        }

        @Generated
        public void setBacsDebitPayments(String bacsDebitPayments) {
            this.bacsDebitPayments = bacsDebitPayments;
        }

        @Generated
        public void setBancontactPayments(String bancontactPayments) {
            this.bancontactPayments = bancontactPayments;
        }

        @Generated
        public void setBankTransferPayments(String bankTransferPayments) {
            this.bankTransferPayments = bankTransferPayments;
        }

        @Generated
        public void setBlikPayments(String blikPayments) {
            this.blikPayments = blikPayments;
        }

        @Generated
        public void setBoletoPayments(String boletoPayments) {
            this.boletoPayments = boletoPayments;
        }

        @Generated
        public void setCardIssuing(String cardIssuing) {
            this.cardIssuing = cardIssuing;
        }

        @Generated
        public void setCardPayments(String cardPayments) {
            this.cardPayments = cardPayments;
        }

        @Generated
        public void setCartesBancairesPayments(String cartesBancairesPayments) {
            this.cartesBancairesPayments = cartesBancairesPayments;
        }

        @Generated
        public void setCashappPayments(String cashappPayments) {
            this.cashappPayments = cashappPayments;
        }

        @Generated
        public void setEpsPayments(String epsPayments) {
            this.epsPayments = epsPayments;
        }

        @Generated
        public void setFpxPayments(String fpxPayments) {
            this.fpxPayments = fpxPayments;
        }

        @Generated
        public void setGiropayPayments(String giropayPayments) {
            this.giropayPayments = giropayPayments;
        }

        @Generated
        public void setGrabpayPayments(String grabpayPayments) {
            this.grabpayPayments = grabpayPayments;
        }

        @Generated
        public void setIdealPayments(String idealPayments) {
            this.idealPayments = idealPayments;
        }

        @Generated
        public void setIndiaInternationalPayments(String indiaInternationalPayments) {
            this.indiaInternationalPayments = indiaInternationalPayments;
        }

        @Generated
        public void setJcbPayments(String jcbPayments) {
            this.jcbPayments = jcbPayments;
        }

        @Generated
        public void setKlarnaPayments(String klarnaPayments) {
            this.klarnaPayments = klarnaPayments;
        }

        @Generated
        public void setKonbiniPayments(String konbiniPayments) {
            this.konbiniPayments = konbiniPayments;
        }

        @Generated
        public void setLegacyPayments(String legacyPayments) {
            this.legacyPayments = legacyPayments;
        }

        @Generated
        public void setLinkPayments(String linkPayments) {
            this.linkPayments = linkPayments;
        }

        @Generated
        public void setOxxoPayments(String oxxoPayments) {
            this.oxxoPayments = oxxoPayments;
        }

        @Generated
        public void setP24Payments(String p24Payments) {
            this.p24Payments = p24Payments;
        }

        @Generated
        public void setPaynowPayments(String paynowPayments) {
            this.paynowPayments = paynowPayments;
        }

        @Generated
        public void setPaypalPayments(String paypalPayments) {
            this.paypalPayments = paypalPayments;
        }

        @Generated
        public void setPromptpayPayments(String promptpayPayments) {
            this.promptpayPayments = promptpayPayments;
        }

        @Generated
        public void setRevolutPayPayments(String revolutPayPayments) {
            this.revolutPayPayments = revolutPayPayments;
        }

        @Generated
        public void setSepaDebitPayments(String sepaDebitPayments) {
            this.sepaDebitPayments = sepaDebitPayments;
        }

        @Generated
        public void setSofortPayments(String sofortPayments) {
            this.sofortPayments = sofortPayments;
        }

        @Generated
        public void setTaxReportingUs1099K(String taxReportingUs1099K) {
            this.taxReportingUs1099K = taxReportingUs1099K;
        }

        @Generated
        public void setTaxReportingUs1099Misc(String taxReportingUs1099Misc) {
            this.taxReportingUs1099Misc = taxReportingUs1099Misc;
        }

        @Generated
        public void setTransfers(String transfers) {
            this.transfers = transfers;
        }

        @Generated
        public void setTreasury(String treasury) {
            this.treasury = treasury;
        }

        @Generated
        public void setUsBankAccountAchPayments(String usBankAccountAchPayments) {
            this.usBankAccountAchPayments = usBankAccountAchPayments;
        }

        @Generated
        public void setZipPayments(String zipPayments) {
            this.zipPayments = zipPayments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Capabilities)) {
                return false;
            }
            Capabilities other = (Capabilities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$acssDebitPayments = this.getAcssDebitPayments();
            String other$acssDebitPayments = other.getAcssDebitPayments();
            if (this$acssDebitPayments == null ? other$acssDebitPayments != null : !this$acssDebitPayments.equals(other$acssDebitPayments)) {
                return false;
            }
            String this$affirmPayments = this.getAffirmPayments();
            String other$affirmPayments = other.getAffirmPayments();
            if (this$affirmPayments == null ? other$affirmPayments != null : !this$affirmPayments.equals(other$affirmPayments)) {
                return false;
            }
            String this$afterpayClearpayPayments = this.getAfterpayClearpayPayments();
            String other$afterpayClearpayPayments = other.getAfterpayClearpayPayments();
            if (this$afterpayClearpayPayments == null ? other$afterpayClearpayPayments != null : !this$afterpayClearpayPayments.equals(other$afterpayClearpayPayments)) {
                return false;
            }
            String this$auBecsDebitPayments = this.getAuBecsDebitPayments();
            String other$auBecsDebitPayments = other.getAuBecsDebitPayments();
            if (this$auBecsDebitPayments == null ? other$auBecsDebitPayments != null : !this$auBecsDebitPayments.equals(other$auBecsDebitPayments)) {
                return false;
            }
            String this$bacsDebitPayments = this.getBacsDebitPayments();
            String other$bacsDebitPayments = other.getBacsDebitPayments();
            if (this$bacsDebitPayments == null ? other$bacsDebitPayments != null : !this$bacsDebitPayments.equals(other$bacsDebitPayments)) {
                return false;
            }
            String this$bancontactPayments = this.getBancontactPayments();
            String other$bancontactPayments = other.getBancontactPayments();
            if (this$bancontactPayments == null ? other$bancontactPayments != null : !this$bancontactPayments.equals(other$bancontactPayments)) {
                return false;
            }
            String this$bankTransferPayments = this.getBankTransferPayments();
            String other$bankTransferPayments = other.getBankTransferPayments();
            if (this$bankTransferPayments == null ? other$bankTransferPayments != null : !this$bankTransferPayments.equals(other$bankTransferPayments)) {
                return false;
            }
            String this$blikPayments = this.getBlikPayments();
            String other$blikPayments = other.getBlikPayments();
            if (this$blikPayments == null ? other$blikPayments != null : !this$blikPayments.equals(other$blikPayments)) {
                return false;
            }
            String this$boletoPayments = this.getBoletoPayments();
            String other$boletoPayments = other.getBoletoPayments();
            if (this$boletoPayments == null ? other$boletoPayments != null : !this$boletoPayments.equals(other$boletoPayments)) {
                return false;
            }
            String this$cardIssuing = this.getCardIssuing();
            String other$cardIssuing = other.getCardIssuing();
            if (this$cardIssuing == null ? other$cardIssuing != null : !this$cardIssuing.equals(other$cardIssuing)) {
                return false;
            }
            String this$cardPayments = this.getCardPayments();
            String other$cardPayments = other.getCardPayments();
            if (this$cardPayments == null ? other$cardPayments != null : !this$cardPayments.equals(other$cardPayments)) {
                return false;
            }
            String this$cartesBancairesPayments = this.getCartesBancairesPayments();
            String other$cartesBancairesPayments = other.getCartesBancairesPayments();
            if (this$cartesBancairesPayments == null ? other$cartesBancairesPayments != null : !this$cartesBancairesPayments.equals(other$cartesBancairesPayments)) {
                return false;
            }
            String this$cashappPayments = this.getCashappPayments();
            String other$cashappPayments = other.getCashappPayments();
            if (this$cashappPayments == null ? other$cashappPayments != null : !this$cashappPayments.equals(other$cashappPayments)) {
                return false;
            }
            String this$epsPayments = this.getEpsPayments();
            String other$epsPayments = other.getEpsPayments();
            if (this$epsPayments == null ? other$epsPayments != null : !this$epsPayments.equals(other$epsPayments)) {
                return false;
            }
            String this$fpxPayments = this.getFpxPayments();
            String other$fpxPayments = other.getFpxPayments();
            if (this$fpxPayments == null ? other$fpxPayments != null : !this$fpxPayments.equals(other$fpxPayments)) {
                return false;
            }
            String this$giropayPayments = this.getGiropayPayments();
            String other$giropayPayments = other.getGiropayPayments();
            if (this$giropayPayments == null ? other$giropayPayments != null : !this$giropayPayments.equals(other$giropayPayments)) {
                return false;
            }
            String this$grabpayPayments = this.getGrabpayPayments();
            String other$grabpayPayments = other.getGrabpayPayments();
            if (this$grabpayPayments == null ? other$grabpayPayments != null : !this$grabpayPayments.equals(other$grabpayPayments)) {
                return false;
            }
            String this$idealPayments = this.getIdealPayments();
            String other$idealPayments = other.getIdealPayments();
            if (this$idealPayments == null ? other$idealPayments != null : !this$idealPayments.equals(other$idealPayments)) {
                return false;
            }
            String this$indiaInternationalPayments = this.getIndiaInternationalPayments();
            String other$indiaInternationalPayments = other.getIndiaInternationalPayments();
            if (this$indiaInternationalPayments == null ? other$indiaInternationalPayments != null : !this$indiaInternationalPayments.equals(other$indiaInternationalPayments)) {
                return false;
            }
            String this$jcbPayments = this.getJcbPayments();
            String other$jcbPayments = other.getJcbPayments();
            if (this$jcbPayments == null ? other$jcbPayments != null : !this$jcbPayments.equals(other$jcbPayments)) {
                return false;
            }
            String this$klarnaPayments = this.getKlarnaPayments();
            String other$klarnaPayments = other.getKlarnaPayments();
            if (this$klarnaPayments == null ? other$klarnaPayments != null : !this$klarnaPayments.equals(other$klarnaPayments)) {
                return false;
            }
            String this$konbiniPayments = this.getKonbiniPayments();
            String other$konbiniPayments = other.getKonbiniPayments();
            if (this$konbiniPayments == null ? other$konbiniPayments != null : !this$konbiniPayments.equals(other$konbiniPayments)) {
                return false;
            }
            String this$legacyPayments = this.getLegacyPayments();
            String other$legacyPayments = other.getLegacyPayments();
            if (this$legacyPayments == null ? other$legacyPayments != null : !this$legacyPayments.equals(other$legacyPayments)) {
                return false;
            }
            String this$linkPayments = this.getLinkPayments();
            String other$linkPayments = other.getLinkPayments();
            if (this$linkPayments == null ? other$linkPayments != null : !this$linkPayments.equals(other$linkPayments)) {
                return false;
            }
            String this$oxxoPayments = this.getOxxoPayments();
            String other$oxxoPayments = other.getOxxoPayments();
            if (this$oxxoPayments == null ? other$oxxoPayments != null : !this$oxxoPayments.equals(other$oxxoPayments)) {
                return false;
            }
            String this$p24Payments = this.getP24Payments();
            String other$p24Payments = other.getP24Payments();
            if (this$p24Payments == null ? other$p24Payments != null : !this$p24Payments.equals(other$p24Payments)) {
                return false;
            }
            String this$paynowPayments = this.getPaynowPayments();
            String other$paynowPayments = other.getPaynowPayments();
            if (this$paynowPayments == null ? other$paynowPayments != null : !this$paynowPayments.equals(other$paynowPayments)) {
                return false;
            }
            String this$paypalPayments = this.getPaypalPayments();
            String other$paypalPayments = other.getPaypalPayments();
            if (this$paypalPayments == null ? other$paypalPayments != null : !this$paypalPayments.equals(other$paypalPayments)) {
                return false;
            }
            String this$promptpayPayments = this.getPromptpayPayments();
            String other$promptpayPayments = other.getPromptpayPayments();
            if (this$promptpayPayments == null ? other$promptpayPayments != null : !this$promptpayPayments.equals(other$promptpayPayments)) {
                return false;
            }
            String this$revolutPayPayments = this.getRevolutPayPayments();
            String other$revolutPayPayments = other.getRevolutPayPayments();
            if (this$revolutPayPayments == null ? other$revolutPayPayments != null : !this$revolutPayPayments.equals(other$revolutPayPayments)) {
                return false;
            }
            String this$sepaDebitPayments = this.getSepaDebitPayments();
            String other$sepaDebitPayments = other.getSepaDebitPayments();
            if (this$sepaDebitPayments == null ? other$sepaDebitPayments != null : !this$sepaDebitPayments.equals(other$sepaDebitPayments)) {
                return false;
            }
            String this$sofortPayments = this.getSofortPayments();
            String other$sofortPayments = other.getSofortPayments();
            if (this$sofortPayments == null ? other$sofortPayments != null : !this$sofortPayments.equals(other$sofortPayments)) {
                return false;
            }
            String this$taxReportingUs1099K = this.getTaxReportingUs1099K();
            String other$taxReportingUs1099K = other.getTaxReportingUs1099K();
            if (this$taxReportingUs1099K == null ? other$taxReportingUs1099K != null : !this$taxReportingUs1099K.equals(other$taxReportingUs1099K)) {
                return false;
            }
            String this$taxReportingUs1099Misc = this.getTaxReportingUs1099Misc();
            String other$taxReportingUs1099Misc = other.getTaxReportingUs1099Misc();
            if (this$taxReportingUs1099Misc == null ? other$taxReportingUs1099Misc != null : !this$taxReportingUs1099Misc.equals(other$taxReportingUs1099Misc)) {
                return false;
            }
            String this$transfers = this.getTransfers();
            String other$transfers = other.getTransfers();
            if (this$transfers == null ? other$transfers != null : !this$transfers.equals(other$transfers)) {
                return false;
            }
            String this$treasury = this.getTreasury();
            String other$treasury = other.getTreasury();
            if (this$treasury == null ? other$treasury != null : !this$treasury.equals(other$treasury)) {
                return false;
            }
            String this$usBankAccountAchPayments = this.getUsBankAccountAchPayments();
            String other$usBankAccountAchPayments = other.getUsBankAccountAchPayments();
            if (this$usBankAccountAchPayments == null ? other$usBankAccountAchPayments != null : !this$usBankAccountAchPayments.equals(other$usBankAccountAchPayments)) {
                return false;
            }
            String this$zipPayments = this.getZipPayments();
            String other$zipPayments = other.getZipPayments();
            return !(this$zipPayments == null ? other$zipPayments != null : !this$zipPayments.equals(other$zipPayments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Capabilities;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $acssDebitPayments = this.getAcssDebitPayments();
            result = result * 59 + ($acssDebitPayments == null ? 43 : $acssDebitPayments.hashCode());
            String $affirmPayments = this.getAffirmPayments();
            result = result * 59 + ($affirmPayments == null ? 43 : $affirmPayments.hashCode());
            String $afterpayClearpayPayments = this.getAfterpayClearpayPayments();
            result = result * 59 + ($afterpayClearpayPayments == null ? 43 : $afterpayClearpayPayments.hashCode());
            String $auBecsDebitPayments = this.getAuBecsDebitPayments();
            result = result * 59 + ($auBecsDebitPayments == null ? 43 : $auBecsDebitPayments.hashCode());
            String $bacsDebitPayments = this.getBacsDebitPayments();
            result = result * 59 + ($bacsDebitPayments == null ? 43 : $bacsDebitPayments.hashCode());
            String $bancontactPayments = this.getBancontactPayments();
            result = result * 59 + ($bancontactPayments == null ? 43 : $bancontactPayments.hashCode());
            String $bankTransferPayments = this.getBankTransferPayments();
            result = result * 59 + ($bankTransferPayments == null ? 43 : $bankTransferPayments.hashCode());
            String $blikPayments = this.getBlikPayments();
            result = result * 59 + ($blikPayments == null ? 43 : $blikPayments.hashCode());
            String $boletoPayments = this.getBoletoPayments();
            result = result * 59 + ($boletoPayments == null ? 43 : $boletoPayments.hashCode());
            String $cardIssuing = this.getCardIssuing();
            result = result * 59 + ($cardIssuing == null ? 43 : $cardIssuing.hashCode());
            String $cardPayments = this.getCardPayments();
            result = result * 59 + ($cardPayments == null ? 43 : $cardPayments.hashCode());
            String $cartesBancairesPayments = this.getCartesBancairesPayments();
            result = result * 59 + ($cartesBancairesPayments == null ? 43 : $cartesBancairesPayments.hashCode());
            String $cashappPayments = this.getCashappPayments();
            result = result * 59 + ($cashappPayments == null ? 43 : $cashappPayments.hashCode());
            String $epsPayments = this.getEpsPayments();
            result = result * 59 + ($epsPayments == null ? 43 : $epsPayments.hashCode());
            String $fpxPayments = this.getFpxPayments();
            result = result * 59 + ($fpxPayments == null ? 43 : $fpxPayments.hashCode());
            String $giropayPayments = this.getGiropayPayments();
            result = result * 59 + ($giropayPayments == null ? 43 : $giropayPayments.hashCode());
            String $grabpayPayments = this.getGrabpayPayments();
            result = result * 59 + ($grabpayPayments == null ? 43 : $grabpayPayments.hashCode());
            String $idealPayments = this.getIdealPayments();
            result = result * 59 + ($idealPayments == null ? 43 : $idealPayments.hashCode());
            String $indiaInternationalPayments = this.getIndiaInternationalPayments();
            result = result * 59 + ($indiaInternationalPayments == null ? 43 : $indiaInternationalPayments.hashCode());
            String $jcbPayments = this.getJcbPayments();
            result = result * 59 + ($jcbPayments == null ? 43 : $jcbPayments.hashCode());
            String $klarnaPayments = this.getKlarnaPayments();
            result = result * 59 + ($klarnaPayments == null ? 43 : $klarnaPayments.hashCode());
            String $konbiniPayments = this.getKonbiniPayments();
            result = result * 59 + ($konbiniPayments == null ? 43 : $konbiniPayments.hashCode());
            String $legacyPayments = this.getLegacyPayments();
            result = result * 59 + ($legacyPayments == null ? 43 : $legacyPayments.hashCode());
            String $linkPayments = this.getLinkPayments();
            result = result * 59 + ($linkPayments == null ? 43 : $linkPayments.hashCode());
            String $oxxoPayments = this.getOxxoPayments();
            result = result * 59 + ($oxxoPayments == null ? 43 : $oxxoPayments.hashCode());
            String $p24Payments = this.getP24Payments();
            result = result * 59 + ($p24Payments == null ? 43 : $p24Payments.hashCode());
            String $paynowPayments = this.getPaynowPayments();
            result = result * 59 + ($paynowPayments == null ? 43 : $paynowPayments.hashCode());
            String $paypalPayments = this.getPaypalPayments();
            result = result * 59 + ($paypalPayments == null ? 43 : $paypalPayments.hashCode());
            String $promptpayPayments = this.getPromptpayPayments();
            result = result * 59 + ($promptpayPayments == null ? 43 : $promptpayPayments.hashCode());
            String $revolutPayPayments = this.getRevolutPayPayments();
            result = result * 59 + ($revolutPayPayments == null ? 43 : $revolutPayPayments.hashCode());
            String $sepaDebitPayments = this.getSepaDebitPayments();
            result = result * 59 + ($sepaDebitPayments == null ? 43 : $sepaDebitPayments.hashCode());
            String $sofortPayments = this.getSofortPayments();
            result = result * 59 + ($sofortPayments == null ? 43 : $sofortPayments.hashCode());
            String $taxReportingUs1099K = this.getTaxReportingUs1099K();
            result = result * 59 + ($taxReportingUs1099K == null ? 43 : $taxReportingUs1099K.hashCode());
            String $taxReportingUs1099Misc = this.getTaxReportingUs1099Misc();
            result = result * 59 + ($taxReportingUs1099Misc == null ? 43 : $taxReportingUs1099Misc.hashCode());
            String $transfers = this.getTransfers();
            result = result * 59 + ($transfers == null ? 43 : $transfers.hashCode());
            String $treasury = this.getTreasury();
            result = result * 59 + ($treasury == null ? 43 : $treasury.hashCode());
            String $usBankAccountAchPayments = this.getUsBankAccountAchPayments();
            result = result * 59 + ($usBankAccountAchPayments == null ? 43 : $usBankAccountAchPayments.hashCode());
            String $zipPayments = this.getZipPayments();
            result = result * 59 + ($zipPayments == null ? 43 : $zipPayments.hashCode());
            return result;
        }
    }

    public static class Company
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_kana")
        AddressKana addressKana;
        @SerializedName(value="address_kanji")
        AddressKanji addressKanji;
        @SerializedName(value="directors_provided")
        Boolean directorsProvided;
        @SerializedName(value="executives_provided")
        Boolean executivesProvided;
        @SerializedName(value="export_license_id")
        String exportLicenseId;
        @SerializedName(value="export_purpose_code")
        String exportPurposeCode;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="name_kana")
        String nameKana;
        @SerializedName(value="name_kanji")
        String nameKanji;
        @SerializedName(value="owners_provided")
        Boolean ownersProvided;
        @SerializedName(value="ownership_declaration")
        OwnershipDeclaration ownershipDeclaration;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="structure")
        String structure;
        @SerializedName(value="tax_id_provided")
        Boolean taxIdProvided;
        @SerializedName(value="tax_id_registrar")
        String taxIdRegistrar;
        @SerializedName(value="vat_id_provided")
        Boolean vatIdProvided;
        @SerializedName(value="verification")
        Verification verification;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public AddressKana getAddressKana() {
            return this.addressKana;
        }

        @Generated
        public AddressKanji getAddressKanji() {
            return this.addressKanji;
        }

        @Generated
        public Boolean getDirectorsProvided() {
            return this.directorsProvided;
        }

        @Generated
        public Boolean getExecutivesProvided() {
            return this.executivesProvided;
        }

        @Generated
        public String getExportLicenseId() {
            return this.exportLicenseId;
        }

        @Generated
        public String getExportPurposeCode() {
            return this.exportPurposeCode;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getNameKana() {
            return this.nameKana;
        }

        @Generated
        public String getNameKanji() {
            return this.nameKanji;
        }

        @Generated
        public Boolean getOwnersProvided() {
            return this.ownersProvided;
        }

        @Generated
        public OwnershipDeclaration getOwnershipDeclaration() {
            return this.ownershipDeclaration;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getStructure() {
            return this.structure;
        }

        @Generated
        public Boolean getTaxIdProvided() {
            return this.taxIdProvided;
        }

        @Generated
        public String getTaxIdRegistrar() {
            return this.taxIdRegistrar;
        }

        @Generated
        public Boolean getVatIdProvided() {
            return this.vatIdProvided;
        }

        @Generated
        public Verification getVerification() {
            return this.verification;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setAddressKana(AddressKana addressKana) {
            this.addressKana = addressKana;
        }

        @Generated
        public void setAddressKanji(AddressKanji addressKanji) {
            this.addressKanji = addressKanji;
        }

        @Generated
        public void setDirectorsProvided(Boolean directorsProvided) {
            this.directorsProvided = directorsProvided;
        }

        @Generated
        public void setExecutivesProvided(Boolean executivesProvided) {
            this.executivesProvided = executivesProvided;
        }

        @Generated
        public void setExportLicenseId(String exportLicenseId) {
            this.exportLicenseId = exportLicenseId;
        }

        @Generated
        public void setExportPurposeCode(String exportPurposeCode) {
            this.exportPurposeCode = exportPurposeCode;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setNameKana(String nameKana) {
            this.nameKana = nameKana;
        }

        @Generated
        public void setNameKanji(String nameKanji) {
            this.nameKanji = nameKanji;
        }

        @Generated
        public void setOwnersProvided(Boolean ownersProvided) {
            this.ownersProvided = ownersProvided;
        }

        @Generated
        public void setOwnershipDeclaration(OwnershipDeclaration ownershipDeclaration) {
            this.ownershipDeclaration = ownershipDeclaration;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setStructure(String structure) {
            this.structure = structure;
        }

        @Generated
        public void setTaxIdProvided(Boolean taxIdProvided) {
            this.taxIdProvided = taxIdProvided;
        }

        @Generated
        public void setTaxIdRegistrar(String taxIdRegistrar) {
            this.taxIdRegistrar = taxIdRegistrar;
        }

        @Generated
        public void setVatIdProvided(Boolean vatIdProvided) {
            this.vatIdProvided = vatIdProvided;
        }

        @Generated
        public void setVerification(Verification verification) {
            this.verification = verification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Company)) {
                return false;
            }
            Company other = (Company)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$directorsProvided = this.getDirectorsProvided();
            Boolean other$directorsProvided = other.getDirectorsProvided();
            if (this$directorsProvided == null ? other$directorsProvided != null : !((Object)this$directorsProvided).equals(other$directorsProvided)) {
                return false;
            }
            Boolean this$executivesProvided = this.getExecutivesProvided();
            Boolean other$executivesProvided = other.getExecutivesProvided();
            if (this$executivesProvided == null ? other$executivesProvided != null : !((Object)this$executivesProvided).equals(other$executivesProvided)) {
                return false;
            }
            Boolean this$ownersProvided = this.getOwnersProvided();
            Boolean other$ownersProvided = other.getOwnersProvided();
            if (this$ownersProvided == null ? other$ownersProvided != null : !((Object)this$ownersProvided).equals(other$ownersProvided)) {
                return false;
            }
            Boolean this$taxIdProvided = this.getTaxIdProvided();
            Boolean other$taxIdProvided = other.getTaxIdProvided();
            if (this$taxIdProvided == null ? other$taxIdProvided != null : !((Object)this$taxIdProvided).equals(other$taxIdProvided)) {
                return false;
            }
            Boolean this$vatIdProvided = this.getVatIdProvided();
            Boolean other$vatIdProvided = other.getVatIdProvided();
            if (this$vatIdProvided == null ? other$vatIdProvided != null : !((Object)this$vatIdProvided).equals(other$vatIdProvided)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            AddressKana this$addressKana = this.getAddressKana();
            AddressKana other$addressKana = other.getAddressKana();
            if (this$addressKana == null ? other$addressKana != null : !((Object)this$addressKana).equals(other$addressKana)) {
                return false;
            }
            AddressKanji this$addressKanji = this.getAddressKanji();
            AddressKanji other$addressKanji = other.getAddressKanji();
            if (this$addressKanji == null ? other$addressKanji != null : !((Object)this$addressKanji).equals(other$addressKanji)) {
                return false;
            }
            String this$exportLicenseId = this.getExportLicenseId();
            String other$exportLicenseId = other.getExportLicenseId();
            if (this$exportLicenseId == null ? other$exportLicenseId != null : !this$exportLicenseId.equals(other$exportLicenseId)) {
                return false;
            }
            String this$exportPurposeCode = this.getExportPurposeCode();
            String other$exportPurposeCode = other.getExportPurposeCode();
            if (this$exportPurposeCode == null ? other$exportPurposeCode != null : !this$exportPurposeCode.equals(other$exportPurposeCode)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$nameKana = this.getNameKana();
            String other$nameKana = other.getNameKana();
            if (this$nameKana == null ? other$nameKana != null : !this$nameKana.equals(other$nameKana)) {
                return false;
            }
            String this$nameKanji = this.getNameKanji();
            String other$nameKanji = other.getNameKanji();
            if (this$nameKanji == null ? other$nameKanji != null : !this$nameKanji.equals(other$nameKanji)) {
                return false;
            }
            OwnershipDeclaration this$ownershipDeclaration = this.getOwnershipDeclaration();
            OwnershipDeclaration other$ownershipDeclaration = other.getOwnershipDeclaration();
            if (this$ownershipDeclaration == null ? other$ownershipDeclaration != null : !((Object)this$ownershipDeclaration).equals(other$ownershipDeclaration)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            String this$structure = this.getStructure();
            String other$structure = other.getStructure();
            if (this$structure == null ? other$structure != null : !this$structure.equals(other$structure)) {
                return false;
            }
            String this$taxIdRegistrar = this.getTaxIdRegistrar();
            String other$taxIdRegistrar = other.getTaxIdRegistrar();
            if (this$taxIdRegistrar == null ? other$taxIdRegistrar != null : !this$taxIdRegistrar.equals(other$taxIdRegistrar)) {
                return false;
            }
            Verification this$verification = this.getVerification();
            Verification other$verification = other.getVerification();
            return !(this$verification == null ? other$verification != null : !((Object)this$verification).equals(other$verification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Company;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $directorsProvided = this.getDirectorsProvided();
            result = result * 59 + ($directorsProvided == null ? 43 : ((Object)$directorsProvided).hashCode());
            Boolean $executivesProvided = this.getExecutivesProvided();
            result = result * 59 + ($executivesProvided == null ? 43 : ((Object)$executivesProvided).hashCode());
            Boolean $ownersProvided = this.getOwnersProvided();
            result = result * 59 + ($ownersProvided == null ? 43 : ((Object)$ownersProvided).hashCode());
            Boolean $taxIdProvided = this.getTaxIdProvided();
            result = result * 59 + ($taxIdProvided == null ? 43 : ((Object)$taxIdProvided).hashCode());
            Boolean $vatIdProvided = this.getVatIdProvided();
            result = result * 59 + ($vatIdProvided == null ? 43 : ((Object)$vatIdProvided).hashCode());
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            AddressKana $addressKana = this.getAddressKana();
            result = result * 59 + ($addressKana == null ? 43 : ((Object)$addressKana).hashCode());
            AddressKanji $addressKanji = this.getAddressKanji();
            result = result * 59 + ($addressKanji == null ? 43 : ((Object)$addressKanji).hashCode());
            String $exportLicenseId = this.getExportLicenseId();
            result = result * 59 + ($exportLicenseId == null ? 43 : $exportLicenseId.hashCode());
            String $exportPurposeCode = this.getExportPurposeCode();
            result = result * 59 + ($exportPurposeCode == null ? 43 : $exportPurposeCode.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $nameKana = this.getNameKana();
            result = result * 59 + ($nameKana == null ? 43 : $nameKana.hashCode());
            String $nameKanji = this.getNameKanji();
            result = result * 59 + ($nameKanji == null ? 43 : $nameKanji.hashCode());
            OwnershipDeclaration $ownershipDeclaration = this.getOwnershipDeclaration();
            result = result * 59 + ($ownershipDeclaration == null ? 43 : ((Object)$ownershipDeclaration).hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            String $structure = this.getStructure();
            result = result * 59 + ($structure == null ? 43 : $structure.hashCode());
            String $taxIdRegistrar = this.getTaxIdRegistrar();
            result = result * 59 + ($taxIdRegistrar == null ? 43 : $taxIdRegistrar.hashCode());
            Verification $verification = this.getVerification();
            result = result * 59 + ($verification == null ? 43 : ((Object)$verification).hashCode());
            return result;
        }

        public static class AddressKana
        extends StripeObject {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public String getTown() {
                return this.town;
            }

            @Generated
            public void setCity(String city) {
                this.city = city;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setLine1(String line1) {
                this.line1 = line1;
            }

            @Generated
            public void setLine2(String line2) {
                this.line2 = line2;
            }

            @Generated
            public void setPostalCode(String postalCode) {
                this.postalCode = postalCode;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public void setTown(String town) {
                this.town = town;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AddressKana)) {
                    return false;
                }
                AddressKana other = (AddressKana)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$city = this.getCity();
                String other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$line1 = this.getLine1();
                String other$line1 = other.getLine1();
                if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                    return false;
                }
                String this$line2 = this.getLine2();
                String other$line2 = other.getLine2();
                if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                    return false;
                }
                String this$postalCode = this.getPostalCode();
                String other$postalCode = other.getPostalCode();
                if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                    return false;
                }
                String this$town = this.getTown();
                String other$town = other.getTown();
                return !(this$town == null ? other$town != null : !this$town.equals(other$town));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AddressKana;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $line1 = this.getLine1();
                result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                String $line2 = this.getLine2();
                result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                String $postalCode = this.getPostalCode();
                result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                String $town = this.getTown();
                result = result * 59 + ($town == null ? 43 : $town.hashCode());
                return result;
            }
        }

        public static class AddressKanji
        extends StripeObject {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public String getTown() {
                return this.town;
            }

            @Generated
            public void setCity(String city) {
                this.city = city;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setLine1(String line1) {
                this.line1 = line1;
            }

            @Generated
            public void setLine2(String line2) {
                this.line2 = line2;
            }

            @Generated
            public void setPostalCode(String postalCode) {
                this.postalCode = postalCode;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public void setTown(String town) {
                this.town = town;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AddressKanji)) {
                    return false;
                }
                AddressKanji other = (AddressKanji)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$city = this.getCity();
                String other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$line1 = this.getLine1();
                String other$line1 = other.getLine1();
                if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                    return false;
                }
                String this$line2 = this.getLine2();
                String other$line2 = other.getLine2();
                if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                    return false;
                }
                String this$postalCode = this.getPostalCode();
                String other$postalCode = other.getPostalCode();
                if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                    return false;
                }
                String this$town = this.getTown();
                String other$town = other.getTown();
                return !(this$town == null ? other$town != null : !this$town.equals(other$town));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AddressKanji;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $line1 = this.getLine1();
                result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                String $line2 = this.getLine2();
                result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                String $postalCode = this.getPostalCode();
                result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                String $town = this.getTown();
                result = result * 59 + ($town == null ? 43 : $town.hashCode());
                return result;
            }
        }

        public static class OwnershipDeclaration
        extends StripeObject {
            @SerializedName(value="date")
            Long date;
            @SerializedName(value="ip")
            String ip;
            @SerializedName(value="user_agent")
            String userAgent;

            @Generated
            public Long getDate() {
                return this.date;
            }

            @Generated
            public String getIp() {
                return this.ip;
            }

            @Generated
            public String getUserAgent() {
                return this.userAgent;
            }

            @Generated
            public void setDate(Long date) {
                this.date = date;
            }

            @Generated
            public void setIp(String ip) {
                this.ip = ip;
            }

            @Generated
            public void setUserAgent(String userAgent) {
                this.userAgent = userAgent;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OwnershipDeclaration)) {
                    return false;
                }
                OwnershipDeclaration other = (OwnershipDeclaration)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$date = this.getDate();
                Long other$date = other.getDate();
                if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                    return false;
                }
                String this$ip = this.getIp();
                String other$ip = other.getIp();
                if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                    return false;
                }
                String this$userAgent = this.getUserAgent();
                String other$userAgent = other.getUserAgent();
                return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof OwnershipDeclaration;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $date = this.getDate();
                result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
                String $ip = this.getIp();
                result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
                String $userAgent = this.getUserAgent();
                result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
                return result;
            }
        }

        public static class Verification
        extends StripeObject {
            @SerializedName(value="document")
            Document document;

            @Generated
            public Document getDocument() {
                return this.document;
            }

            @Generated
            public void setDocument(Document document) {
                this.document = document;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Verification)) {
                    return false;
                }
                Verification other = (Verification)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Document this$document = this.getDocument();
                Document other$document = other.getDocument();
                return !(this$document == null ? other$document != null : !((Object)this$document).equals(other$document));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Verification;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Document $document = this.getDocument();
                result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
                return result;
            }

            public static class Document
            extends StripeObject {
                @SerializedName(value="back")
                ExpandableField<File> back;
                @SerializedName(value="details")
                String details;
                @SerializedName(value="details_code")
                String detailsCode;
                @SerializedName(value="front")
                ExpandableField<File> front;

                public String getBack() {
                    return this.back != null ? this.back.getId() : null;
                }

                public void setBack(String id) {
                    this.back = ApiResource.setExpandableFieldId(id, this.back);
                }

                public File getBackObject() {
                    return this.back != null ? this.back.getExpanded() : null;
                }

                public void setBackObject(File expandableObject) {
                    this.back = new ExpandableField<File>(expandableObject.getId(), expandableObject);
                }

                public String getFront() {
                    return this.front != null ? this.front.getId() : null;
                }

                public void setFront(String id) {
                    this.front = ApiResource.setExpandableFieldId(id, this.front);
                }

                public File getFrontObject() {
                    return this.front != null ? this.front.getExpanded() : null;
                }

                public void setFrontObject(File expandableObject) {
                    this.front = new ExpandableField<File>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public String getDetails() {
                    return this.details;
                }

                @Generated
                public String getDetailsCode() {
                    return this.detailsCode;
                }

                @Generated
                public void setDetails(String details) {
                    this.details = details;
                }

                @Generated
                public void setDetailsCode(String detailsCode) {
                    this.detailsCode = detailsCode;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Document)) {
                        return false;
                    }
                    Document other = (Document)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$back = this.getBack();
                    String other$back = other.getBack();
                    if (this$back == null ? other$back != null : !this$back.equals(other$back)) {
                        return false;
                    }
                    String this$details = this.getDetails();
                    String other$details = other.getDetails();
                    if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
                        return false;
                    }
                    String this$detailsCode = this.getDetailsCode();
                    String other$detailsCode = other.getDetailsCode();
                    if (this$detailsCode == null ? other$detailsCode != null : !this$detailsCode.equals(other$detailsCode)) {
                        return false;
                    }
                    String this$front = this.getFront();
                    String other$front = other.getFront();
                    return !(this$front == null ? other$front != null : !this$front.equals(other$front));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Document;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $back = this.getBack();
                    result = result * 59 + ($back == null ? 43 : $back.hashCode());
                    String $details = this.getDetails();
                    result = result * 59 + ($details == null ? 43 : $details.hashCode());
                    String $detailsCode = this.getDetailsCode();
                    result = result * 59 + ($detailsCode == null ? 43 : $detailsCode.hashCode());
                    String $front = this.getFront();
                    result = result * 59 + ($front == null ? 43 : $front.hashCode());
                    return result;
                }
            }
        }
    }

    public static class Controller
    extends StripeObject {
        @SerializedName(value="application")
        Application application;
        @SerializedName(value="dashboard")
        Dashboard dashboard;
        @SerializedName(value="is_controller")
        Boolean isController;
        @SerializedName(value="type")
        String type;

        @Generated
        public Application getApplication() {
            return this.application;
        }

        @Generated
        public Dashboard getDashboard() {
            return this.dashboard;
        }

        @Generated
        public Boolean getIsController() {
            return this.isController;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setApplication(Application application) {
            this.application = application;
        }

        @Generated
        public void setDashboard(Dashboard dashboard) {
            this.dashboard = dashboard;
        }

        @Generated
        public void setIsController(Boolean isController) {
            this.isController = isController;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Controller)) {
                return false;
            }
            Controller other = (Controller)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isController = this.getIsController();
            Boolean other$isController = other.getIsController();
            if (this$isController == null ? other$isController != null : !((Object)this$isController).equals(other$isController)) {
                return false;
            }
            Application this$application = this.getApplication();
            Application other$application = other.getApplication();
            if (this$application == null ? other$application != null : !((Object)this$application).equals(other$application)) {
                return false;
            }
            Dashboard this$dashboard = this.getDashboard();
            Dashboard other$dashboard = other.getDashboard();
            if (this$dashboard == null ? other$dashboard != null : !((Object)this$dashboard).equals(other$dashboard)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Controller;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isController = this.getIsController();
            result = result * 59 + ($isController == null ? 43 : ((Object)$isController).hashCode());
            Application $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : ((Object)$application).hashCode());
            Dashboard $dashboard = this.getDashboard();
            result = result * 59 + ($dashboard == null ? 43 : ((Object)$dashboard).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Application
        extends StripeObject {
            @SerializedName(value="loss_liable")
            Boolean lossLiable;
            @SerializedName(value="onboarding_owner")
            Boolean onboardingOwner;
            @SerializedName(value="pricing_controls")
            Boolean pricingControls;

            @Generated
            public Boolean getLossLiable() {
                return this.lossLiable;
            }

            @Generated
            public Boolean getOnboardingOwner() {
                return this.onboardingOwner;
            }

            @Generated
            public Boolean getPricingControls() {
                return this.pricingControls;
            }

            @Generated
            public void setLossLiable(Boolean lossLiable) {
                this.lossLiable = lossLiable;
            }

            @Generated
            public void setOnboardingOwner(Boolean onboardingOwner) {
                this.onboardingOwner = onboardingOwner;
            }

            @Generated
            public void setPricingControls(Boolean pricingControls) {
                this.pricingControls = pricingControls;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Application)) {
                    return false;
                }
                Application other = (Application)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$lossLiable = this.getLossLiable();
                Boolean other$lossLiable = other.getLossLiable();
                if (this$lossLiable == null ? other$lossLiable != null : !((Object)this$lossLiable).equals(other$lossLiable)) {
                    return false;
                }
                Boolean this$onboardingOwner = this.getOnboardingOwner();
                Boolean other$onboardingOwner = other.getOnboardingOwner();
                if (this$onboardingOwner == null ? other$onboardingOwner != null : !((Object)this$onboardingOwner).equals(other$onboardingOwner)) {
                    return false;
                }
                Boolean this$pricingControls = this.getPricingControls();
                Boolean other$pricingControls = other.getPricingControls();
                return !(this$pricingControls == null ? other$pricingControls != null : !((Object)this$pricingControls).equals(other$pricingControls));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Application;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $lossLiable = this.getLossLiable();
                result = result * 59 + ($lossLiable == null ? 43 : ((Object)$lossLiable).hashCode());
                Boolean $onboardingOwner = this.getOnboardingOwner();
                result = result * 59 + ($onboardingOwner == null ? 43 : ((Object)$onboardingOwner).hashCode());
                Boolean $pricingControls = this.getPricingControls();
                result = result * 59 + ($pricingControls == null ? 43 : ((Object)$pricingControls).hashCode());
                return result;
            }
        }

        public static class Dashboard
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dashboard)) {
                    return false;
                }
                Dashboard other = (Dashboard)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dashboard;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }
    }

    public static class FutureRequirements
    extends StripeObject {
        @SerializedName(value="alternatives")
        List<Alternative> alternatives;
        @SerializedName(value="current_deadline")
        Long currentDeadline;
        @SerializedName(value="currently_due")
        List<String> currentlyDue;
        @SerializedName(value="disabled_reason")
        String disabledReason;
        @SerializedName(value="errors")
        List<Errors> errors;
        @SerializedName(value="eventually_due")
        List<String> eventuallyDue;
        @SerializedName(value="past_due")
        List<String> pastDue;
        @SerializedName(value="pending_verification")
        List<String> pendingVerification;

        @Generated
        public List<Alternative> getAlternatives() {
            return this.alternatives;
        }

        @Generated
        public Long getCurrentDeadline() {
            return this.currentDeadline;
        }

        @Generated
        public List<String> getCurrentlyDue() {
            return this.currentlyDue;
        }

        @Generated
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Generated
        public List<Errors> getErrors() {
            return this.errors;
        }

        @Generated
        public List<String> getEventuallyDue() {
            return this.eventuallyDue;
        }

        @Generated
        public List<String> getPastDue() {
            return this.pastDue;
        }

        @Generated
        public List<String> getPendingVerification() {
            return this.pendingVerification;
        }

        @Generated
        public void setAlternatives(List<Alternative> alternatives) {
            this.alternatives = alternatives;
        }

        @Generated
        public void setCurrentDeadline(Long currentDeadline) {
            this.currentDeadline = currentDeadline;
        }

        @Generated
        public void setCurrentlyDue(List<String> currentlyDue) {
            this.currentlyDue = currentlyDue;
        }

        @Generated
        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Generated
        public void setErrors(List<Errors> errors) {
            this.errors = errors;
        }

        @Generated
        public void setEventuallyDue(List<String> eventuallyDue) {
            this.eventuallyDue = eventuallyDue;
        }

        @Generated
        public void setPastDue(List<String> pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public void setPendingVerification(List<String> pendingVerification) {
            this.pendingVerification = pendingVerification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FutureRequirements)) {
                return false;
            }
            FutureRequirements other = (FutureRequirements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$currentDeadline = this.getCurrentDeadline();
            Long other$currentDeadline = other.getCurrentDeadline();
            if (this$currentDeadline == null ? other$currentDeadline != null : !((Object)this$currentDeadline).equals(other$currentDeadline)) {
                return false;
            }
            List<Alternative> this$alternatives = this.getAlternatives();
            List<Alternative> other$alternatives = other.getAlternatives();
            if (this$alternatives == null ? other$alternatives != null : !((Object)this$alternatives).equals(other$alternatives)) {
                return false;
            }
            List<String> this$currentlyDue = this.getCurrentlyDue();
            List<String> other$currentlyDue = other.getCurrentlyDue();
            if (this$currentlyDue == null ? other$currentlyDue != null : !((Object)this$currentlyDue).equals(other$currentlyDue)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            List<Errors> this$errors = this.getErrors();
            List<Errors> other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            List<String> this$eventuallyDue = this.getEventuallyDue();
            List<String> other$eventuallyDue = other.getEventuallyDue();
            if (this$eventuallyDue == null ? other$eventuallyDue != null : !((Object)this$eventuallyDue).equals(other$eventuallyDue)) {
                return false;
            }
            List<String> this$pastDue = this.getPastDue();
            List<String> other$pastDue = other.getPastDue();
            if (this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue)) {
                return false;
            }
            List<String> this$pendingVerification = this.getPendingVerification();
            List<String> other$pendingVerification = other.getPendingVerification();
            return !(this$pendingVerification == null ? other$pendingVerification != null : !((Object)this$pendingVerification).equals(other$pendingVerification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FutureRequirements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $currentDeadline = this.getCurrentDeadline();
            result = result * 59 + ($currentDeadline == null ? 43 : ((Object)$currentDeadline).hashCode());
            List<Alternative> $alternatives = this.getAlternatives();
            result = result * 59 + ($alternatives == null ? 43 : ((Object)$alternatives).hashCode());
            List<String> $currentlyDue = this.getCurrentlyDue();
            result = result * 59 + ($currentlyDue == null ? 43 : ((Object)$currentlyDue).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            List<Errors> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            List<String> $eventuallyDue = this.getEventuallyDue();
            result = result * 59 + ($eventuallyDue == null ? 43 : ((Object)$eventuallyDue).hashCode());
            List<String> $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            List<String> $pendingVerification = this.getPendingVerification();
            result = result * 59 + ($pendingVerification == null ? 43 : ((Object)$pendingVerification).hashCode());
            return result;
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;
            @SerializedName(value="requirement")
            String requirement;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public String getRequirement() {
                return this.requirement;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public void setRequirement(String requirement) {
                this.requirement = requirement;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                    return false;
                }
                String this$requirement = this.getRequirement();
                String other$requirement = other.getRequirement();
                return !(this$requirement == null ? other$requirement != null : !this$requirement.equals(other$requirement));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                String $requirement = this.getRequirement();
                result = result * 59 + ($requirement == null ? 43 : $requirement.hashCode());
                return result;
            }
        }

        public static class Alternative
        extends StripeObject {
            @SerializedName(value="alternative_fields_due")
            List<String> alternativeFieldsDue;
            @SerializedName(value="original_fields_due")
            List<String> originalFieldsDue;

            @Generated
            public List<String> getAlternativeFieldsDue() {
                return this.alternativeFieldsDue;
            }

            @Generated
            public List<String> getOriginalFieldsDue() {
                return this.originalFieldsDue;
            }

            @Generated
            public void setAlternativeFieldsDue(List<String> alternativeFieldsDue) {
                this.alternativeFieldsDue = alternativeFieldsDue;
            }

            @Generated
            public void setOriginalFieldsDue(List<String> originalFieldsDue) {
                this.originalFieldsDue = originalFieldsDue;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alternative)) {
                    return false;
                }
                Alternative other = (Alternative)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$alternativeFieldsDue = this.getAlternativeFieldsDue();
                List<String> other$alternativeFieldsDue = other.getAlternativeFieldsDue();
                if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !((Object)this$alternativeFieldsDue).equals(other$alternativeFieldsDue)) {
                    return false;
                }
                List<String> this$originalFieldsDue = this.getOriginalFieldsDue();
                List<String> other$originalFieldsDue = other.getOriginalFieldsDue();
                return !(this$originalFieldsDue == null ? other$originalFieldsDue != null : !((Object)this$originalFieldsDue).equals(other$originalFieldsDue));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alternative;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $alternativeFieldsDue = this.getAlternativeFieldsDue();
                result = result * 59 + ($alternativeFieldsDue == null ? 43 : ((Object)$alternativeFieldsDue).hashCode());
                List<String> $originalFieldsDue = this.getOriginalFieldsDue();
                result = result * 59 + ($originalFieldsDue == null ? 43 : ((Object)$originalFieldsDue).hashCode());
                return result;
            }
        }
    }

    public static class Requirements
    extends StripeObject {
        @SerializedName(value="alternatives")
        List<Alternative> alternatives;
        @SerializedName(value="current_deadline")
        Long currentDeadline;
        @SerializedName(value="currently_due")
        List<String> currentlyDue;
        @SerializedName(value="disabled_reason")
        String disabledReason;
        @SerializedName(value="errors")
        List<Errors> errors;
        @SerializedName(value="eventually_due")
        List<String> eventuallyDue;
        @SerializedName(value="past_due")
        List<String> pastDue;
        @SerializedName(value="pending_verification")
        List<String> pendingVerification;

        @Generated
        public List<Alternative> getAlternatives() {
            return this.alternatives;
        }

        @Generated
        public Long getCurrentDeadline() {
            return this.currentDeadline;
        }

        @Generated
        public List<String> getCurrentlyDue() {
            return this.currentlyDue;
        }

        @Generated
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Generated
        public List<Errors> getErrors() {
            return this.errors;
        }

        @Generated
        public List<String> getEventuallyDue() {
            return this.eventuallyDue;
        }

        @Generated
        public List<String> getPastDue() {
            return this.pastDue;
        }

        @Generated
        public List<String> getPendingVerification() {
            return this.pendingVerification;
        }

        @Generated
        public void setAlternatives(List<Alternative> alternatives) {
            this.alternatives = alternatives;
        }

        @Generated
        public void setCurrentDeadline(Long currentDeadline) {
            this.currentDeadline = currentDeadline;
        }

        @Generated
        public void setCurrentlyDue(List<String> currentlyDue) {
            this.currentlyDue = currentlyDue;
        }

        @Generated
        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Generated
        public void setErrors(List<Errors> errors) {
            this.errors = errors;
        }

        @Generated
        public void setEventuallyDue(List<String> eventuallyDue) {
            this.eventuallyDue = eventuallyDue;
        }

        @Generated
        public void setPastDue(List<String> pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public void setPendingVerification(List<String> pendingVerification) {
            this.pendingVerification = pendingVerification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Requirements)) {
                return false;
            }
            Requirements other = (Requirements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$currentDeadline = this.getCurrentDeadline();
            Long other$currentDeadline = other.getCurrentDeadline();
            if (this$currentDeadline == null ? other$currentDeadline != null : !((Object)this$currentDeadline).equals(other$currentDeadline)) {
                return false;
            }
            List<Alternative> this$alternatives = this.getAlternatives();
            List<Alternative> other$alternatives = other.getAlternatives();
            if (this$alternatives == null ? other$alternatives != null : !((Object)this$alternatives).equals(other$alternatives)) {
                return false;
            }
            List<String> this$currentlyDue = this.getCurrentlyDue();
            List<String> other$currentlyDue = other.getCurrentlyDue();
            if (this$currentlyDue == null ? other$currentlyDue != null : !((Object)this$currentlyDue).equals(other$currentlyDue)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            List<Errors> this$errors = this.getErrors();
            List<Errors> other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            List<String> this$eventuallyDue = this.getEventuallyDue();
            List<String> other$eventuallyDue = other.getEventuallyDue();
            if (this$eventuallyDue == null ? other$eventuallyDue != null : !((Object)this$eventuallyDue).equals(other$eventuallyDue)) {
                return false;
            }
            List<String> this$pastDue = this.getPastDue();
            List<String> other$pastDue = other.getPastDue();
            if (this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue)) {
                return false;
            }
            List<String> this$pendingVerification = this.getPendingVerification();
            List<String> other$pendingVerification = other.getPendingVerification();
            return !(this$pendingVerification == null ? other$pendingVerification != null : !((Object)this$pendingVerification).equals(other$pendingVerification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Requirements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $currentDeadline = this.getCurrentDeadline();
            result = result * 59 + ($currentDeadline == null ? 43 : ((Object)$currentDeadline).hashCode());
            List<Alternative> $alternatives = this.getAlternatives();
            result = result * 59 + ($alternatives == null ? 43 : ((Object)$alternatives).hashCode());
            List<String> $currentlyDue = this.getCurrentlyDue();
            result = result * 59 + ($currentlyDue == null ? 43 : ((Object)$currentlyDue).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            List<Errors> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            List<String> $eventuallyDue = this.getEventuallyDue();
            result = result * 59 + ($eventuallyDue == null ? 43 : ((Object)$eventuallyDue).hashCode());
            List<String> $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            List<String> $pendingVerification = this.getPendingVerification();
            result = result * 59 + ($pendingVerification == null ? 43 : ((Object)$pendingVerification).hashCode());
            return result;
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;
            @SerializedName(value="requirement")
            String requirement;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public String getRequirement() {
                return this.requirement;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public void setRequirement(String requirement) {
                this.requirement = requirement;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                    return false;
                }
                String this$requirement = this.getRequirement();
                String other$requirement = other.getRequirement();
                return !(this$requirement == null ? other$requirement != null : !this$requirement.equals(other$requirement));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                String $requirement = this.getRequirement();
                result = result * 59 + ($requirement == null ? 43 : $requirement.hashCode());
                return result;
            }
        }

        public static class Alternative
        extends StripeObject {
            @SerializedName(value="alternative_fields_due")
            List<String> alternativeFieldsDue;
            @SerializedName(value="original_fields_due")
            List<String> originalFieldsDue;

            @Generated
            public List<String> getAlternativeFieldsDue() {
                return this.alternativeFieldsDue;
            }

            @Generated
            public List<String> getOriginalFieldsDue() {
                return this.originalFieldsDue;
            }

            @Generated
            public void setAlternativeFieldsDue(List<String> alternativeFieldsDue) {
                this.alternativeFieldsDue = alternativeFieldsDue;
            }

            @Generated
            public void setOriginalFieldsDue(List<String> originalFieldsDue) {
                this.originalFieldsDue = originalFieldsDue;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alternative)) {
                    return false;
                }
                Alternative other = (Alternative)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$alternativeFieldsDue = this.getAlternativeFieldsDue();
                List<String> other$alternativeFieldsDue = other.getAlternativeFieldsDue();
                if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !((Object)this$alternativeFieldsDue).equals(other$alternativeFieldsDue)) {
                    return false;
                }
                List<String> this$originalFieldsDue = this.getOriginalFieldsDue();
                List<String> other$originalFieldsDue = other.getOriginalFieldsDue();
                return !(this$originalFieldsDue == null ? other$originalFieldsDue != null : !((Object)this$originalFieldsDue).equals(other$originalFieldsDue));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alternative;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $alternativeFieldsDue = this.getAlternativeFieldsDue();
                result = result * 59 + ($alternativeFieldsDue == null ? 43 : ((Object)$alternativeFieldsDue).hashCode());
                List<String> $originalFieldsDue = this.getOriginalFieldsDue();
                result = result * 59 + ($originalFieldsDue == null ? 43 : ((Object)$originalFieldsDue).hashCode());
                return result;
            }
        }
    }

    public static class Settings
    extends StripeObject {
        @SerializedName(value="bacs_debit_payments")
        BacsDebitPayments bacsDebitPayments;
        @SerializedName(value="branding")
        Branding branding;
        @SerializedName(value="card_issuing")
        CardIssuing cardIssuing;
        @SerializedName(value="card_payments")
        CardPayments cardPayments;
        @SerializedName(value="dashboard")
        Dashboard dashboard;
        @SerializedName(value="payments")
        Payments payments;
        @SerializedName(value="payouts")
        Payouts payouts;
        @SerializedName(value="sepa_debit_payments")
        SepaDebitPayments sepaDebitPayments;
        @SerializedName(value="tax_forms")
        TaxForms taxForms;
        @SerializedName(value="treasury")
        Treasury treasury;

        @Generated
        public BacsDebitPayments getBacsDebitPayments() {
            return this.bacsDebitPayments;
        }

        @Generated
        public Branding getBranding() {
            return this.branding;
        }

        @Generated
        public CardIssuing getCardIssuing() {
            return this.cardIssuing;
        }

        @Generated
        public CardPayments getCardPayments() {
            return this.cardPayments;
        }

        @Generated
        public Dashboard getDashboard() {
            return this.dashboard;
        }

        @Generated
        public Payments getPayments() {
            return this.payments;
        }

        @Generated
        public Payouts getPayouts() {
            return this.payouts;
        }

        @Generated
        public SepaDebitPayments getSepaDebitPayments() {
            return this.sepaDebitPayments;
        }

        @Generated
        public TaxForms getTaxForms() {
            return this.taxForms;
        }

        @Generated
        public Treasury getTreasury() {
            return this.treasury;
        }

        @Generated
        public void setBacsDebitPayments(BacsDebitPayments bacsDebitPayments) {
            this.bacsDebitPayments = bacsDebitPayments;
        }

        @Generated
        public void setBranding(Branding branding) {
            this.branding = branding;
        }

        @Generated
        public void setCardIssuing(CardIssuing cardIssuing) {
            this.cardIssuing = cardIssuing;
        }

        @Generated
        public void setCardPayments(CardPayments cardPayments) {
            this.cardPayments = cardPayments;
        }

        @Generated
        public void setDashboard(Dashboard dashboard) {
            this.dashboard = dashboard;
        }

        @Generated
        public void setPayments(Payments payments) {
            this.payments = payments;
        }

        @Generated
        public void setPayouts(Payouts payouts) {
            this.payouts = payouts;
        }

        @Generated
        public void setSepaDebitPayments(SepaDebitPayments sepaDebitPayments) {
            this.sepaDebitPayments = sepaDebitPayments;
        }

        @Generated
        public void setTaxForms(TaxForms taxForms) {
            this.taxForms = taxForms;
        }

        @Generated
        public void setTreasury(Treasury treasury) {
            this.treasury = treasury;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Settings)) {
                return false;
            }
            Settings other = (Settings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BacsDebitPayments this$bacsDebitPayments = this.getBacsDebitPayments();
            BacsDebitPayments other$bacsDebitPayments = other.getBacsDebitPayments();
            if (this$bacsDebitPayments == null ? other$bacsDebitPayments != null : !((Object)this$bacsDebitPayments).equals(other$bacsDebitPayments)) {
                return false;
            }
            Branding this$branding = this.getBranding();
            Branding other$branding = other.getBranding();
            if (this$branding == null ? other$branding != null : !((Object)this$branding).equals(other$branding)) {
                return false;
            }
            CardIssuing this$cardIssuing = this.getCardIssuing();
            CardIssuing other$cardIssuing = other.getCardIssuing();
            if (this$cardIssuing == null ? other$cardIssuing != null : !((Object)this$cardIssuing).equals(other$cardIssuing)) {
                return false;
            }
            CardPayments this$cardPayments = this.getCardPayments();
            CardPayments other$cardPayments = other.getCardPayments();
            if (this$cardPayments == null ? other$cardPayments != null : !((Object)this$cardPayments).equals(other$cardPayments)) {
                return false;
            }
            Dashboard this$dashboard = this.getDashboard();
            Dashboard other$dashboard = other.getDashboard();
            if (this$dashboard == null ? other$dashboard != null : !((Object)this$dashboard).equals(other$dashboard)) {
                return false;
            }
            Payments this$payments = this.getPayments();
            Payments other$payments = other.getPayments();
            if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
                return false;
            }
            Payouts this$payouts = this.getPayouts();
            Payouts other$payouts = other.getPayouts();
            if (this$payouts == null ? other$payouts != null : !((Object)this$payouts).equals(other$payouts)) {
                return false;
            }
            SepaDebitPayments this$sepaDebitPayments = this.getSepaDebitPayments();
            SepaDebitPayments other$sepaDebitPayments = other.getSepaDebitPayments();
            if (this$sepaDebitPayments == null ? other$sepaDebitPayments != null : !((Object)this$sepaDebitPayments).equals(other$sepaDebitPayments)) {
                return false;
            }
            TaxForms this$taxForms = this.getTaxForms();
            TaxForms other$taxForms = other.getTaxForms();
            if (this$taxForms == null ? other$taxForms != null : !((Object)this$taxForms).equals(other$taxForms)) {
                return false;
            }
            Treasury this$treasury = this.getTreasury();
            Treasury other$treasury = other.getTreasury();
            return !(this$treasury == null ? other$treasury != null : !((Object)this$treasury).equals(other$treasury));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Settings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BacsDebitPayments $bacsDebitPayments = this.getBacsDebitPayments();
            result = result * 59 + ($bacsDebitPayments == null ? 43 : ((Object)$bacsDebitPayments).hashCode());
            Branding $branding = this.getBranding();
            result = result * 59 + ($branding == null ? 43 : ((Object)$branding).hashCode());
            CardIssuing $cardIssuing = this.getCardIssuing();
            result = result * 59 + ($cardIssuing == null ? 43 : ((Object)$cardIssuing).hashCode());
            CardPayments $cardPayments = this.getCardPayments();
            result = result * 59 + ($cardPayments == null ? 43 : ((Object)$cardPayments).hashCode());
            Dashboard $dashboard = this.getDashboard();
            result = result * 59 + ($dashboard == null ? 43 : ((Object)$dashboard).hashCode());
            Payments $payments = this.getPayments();
            result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
            Payouts $payouts = this.getPayouts();
            result = result * 59 + ($payouts == null ? 43 : ((Object)$payouts).hashCode());
            SepaDebitPayments $sepaDebitPayments = this.getSepaDebitPayments();
            result = result * 59 + ($sepaDebitPayments == null ? 43 : ((Object)$sepaDebitPayments).hashCode());
            TaxForms $taxForms = this.getTaxForms();
            result = result * 59 + ($taxForms == null ? 43 : ((Object)$taxForms).hashCode());
            Treasury $treasury = this.getTreasury();
            result = result * 59 + ($treasury == null ? 43 : ((Object)$treasury).hashCode());
            return result;
        }

        public static class BacsDebitPayments
        extends StripeObject {
            @SerializedName(value="display_name")
            String displayName;
            @SerializedName(value="service_user_number")
            String serviceUserNumber;

            @Generated
            public String getDisplayName() {
                return this.displayName;
            }

            @Generated
            public String getServiceUserNumber() {
                return this.serviceUserNumber;
            }

            @Generated
            public void setDisplayName(String displayName) {
                this.displayName = displayName;
            }

            @Generated
            public void setServiceUserNumber(String serviceUserNumber) {
                this.serviceUserNumber = serviceUserNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebitPayments)) {
                    return false;
                }
                BacsDebitPayments other = (BacsDebitPayments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$displayName = this.getDisplayName();
                String other$displayName = other.getDisplayName();
                if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                    return false;
                }
                String this$serviceUserNumber = this.getServiceUserNumber();
                String other$serviceUserNumber = other.getServiceUserNumber();
                return !(this$serviceUserNumber == null ? other$serviceUserNumber != null : !this$serviceUserNumber.equals(other$serviceUserNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebitPayments;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $displayName = this.getDisplayName();
                result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                String $serviceUserNumber = this.getServiceUserNumber();
                result = result * 59 + ($serviceUserNumber == null ? 43 : $serviceUserNumber.hashCode());
                return result;
            }
        }

        public static class Branding
        extends StripeObject {
            @SerializedName(value="icon")
            ExpandableField<File> icon;
            @SerializedName(value="logo")
            ExpandableField<File> logo;
            @SerializedName(value="primary_color")
            String primaryColor;
            @SerializedName(value="secondary_color")
            String secondaryColor;

            public String getIcon() {
                return this.icon != null ? this.icon.getId() : null;
            }

            public void setIcon(String id) {
                this.icon = ApiResource.setExpandableFieldId(id, this.icon);
            }

            public File getIconObject() {
                return this.icon != null ? this.icon.getExpanded() : null;
            }

            public void setIconObject(File expandableObject) {
                this.icon = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            public String getLogo() {
                return this.logo != null ? this.logo.getId() : null;
            }

            public void setLogo(String id) {
                this.logo = ApiResource.setExpandableFieldId(id, this.logo);
            }

            public File getLogoObject() {
                return this.logo != null ? this.logo.getExpanded() : null;
            }

            public void setLogoObject(File expandableObject) {
                this.logo = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getPrimaryColor() {
                return this.primaryColor;
            }

            @Generated
            public String getSecondaryColor() {
                return this.secondaryColor;
            }

            @Generated
            public void setPrimaryColor(String primaryColor) {
                this.primaryColor = primaryColor;
            }

            @Generated
            public void setSecondaryColor(String secondaryColor) {
                this.secondaryColor = secondaryColor;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Branding)) {
                    return false;
                }
                Branding other = (Branding)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$icon = this.getIcon();
                String other$icon = other.getIcon();
                if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                    return false;
                }
                String this$logo = this.getLogo();
                String other$logo = other.getLogo();
                if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
                    return false;
                }
                String this$primaryColor = this.getPrimaryColor();
                String other$primaryColor = other.getPrimaryColor();
                if (this$primaryColor == null ? other$primaryColor != null : !this$primaryColor.equals(other$primaryColor)) {
                    return false;
                }
                String this$secondaryColor = this.getSecondaryColor();
                String other$secondaryColor = other.getSecondaryColor();
                return !(this$secondaryColor == null ? other$secondaryColor != null : !this$secondaryColor.equals(other$secondaryColor));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Branding;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $icon = this.getIcon();
                result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
                String $logo = this.getLogo();
                result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
                String $primaryColor = this.getPrimaryColor();
                result = result * 59 + ($primaryColor == null ? 43 : $primaryColor.hashCode());
                String $secondaryColor = this.getSecondaryColor();
                result = result * 59 + ($secondaryColor == null ? 43 : $secondaryColor.hashCode());
                return result;
            }
        }

        public static class CardIssuing
        extends StripeObject {
            @SerializedName(value="tos_acceptance")
            TosAcceptance tosAcceptance;

            @Generated
            public TosAcceptance getTosAcceptance() {
                return this.tosAcceptance;
            }

            @Generated
            public void setTosAcceptance(TosAcceptance tosAcceptance) {
                this.tosAcceptance = tosAcceptance;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardIssuing)) {
                    return false;
                }
                CardIssuing other = (CardIssuing)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TosAcceptance this$tosAcceptance = this.getTosAcceptance();
                TosAcceptance other$tosAcceptance = other.getTosAcceptance();
                return !(this$tosAcceptance == null ? other$tosAcceptance != null : !((Object)this$tosAcceptance).equals(other$tosAcceptance));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardIssuing;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TosAcceptance $tosAcceptance = this.getTosAcceptance();
                result = result * 59 + ($tosAcceptance == null ? 43 : ((Object)$tosAcceptance).hashCode());
                return result;
            }

            public static class TosAcceptance
            extends StripeObject {
                @SerializedName(value="date")
                Long date;
                @SerializedName(value="ip")
                String ip;
                @SerializedName(value="user_agent")
                String userAgent;

                @Generated
                public Long getDate() {
                    return this.date;
                }

                @Generated
                public String getIp() {
                    return this.ip;
                }

                @Generated
                public String getUserAgent() {
                    return this.userAgent;
                }

                @Generated
                public void setDate(Long date) {
                    this.date = date;
                }

                @Generated
                public void setIp(String ip) {
                    this.ip = ip;
                }

                @Generated
                public void setUserAgent(String userAgent) {
                    this.userAgent = userAgent;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TosAcceptance)) {
                        return false;
                    }
                    TosAcceptance other = (TosAcceptance)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$date = this.getDate();
                    Long other$date = other.getDate();
                    if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                        return false;
                    }
                    String this$ip = this.getIp();
                    String other$ip = other.getIp();
                    if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                        return false;
                    }
                    String this$userAgent = this.getUserAgent();
                    String other$userAgent = other.getUserAgent();
                    return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TosAcceptance;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $date = this.getDate();
                    result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
                    String $ip = this.getIp();
                    result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
                    String $userAgent = this.getUserAgent();
                    result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
                    return result;
                }
            }
        }

        public static class CardPayments
        extends StripeObject {
            @SerializedName(value="decline_on")
            DeclineOn declineOn;
            @SerializedName(value="statement_descriptor_prefix")
            String statementDescriptorPrefix;
            @SerializedName(value="statement_descriptor_prefix_kana")
            String statementDescriptorPrefixKana;
            @SerializedName(value="statement_descriptor_prefix_kanji")
            String statementDescriptorPrefixKanji;

            @Generated
            public DeclineOn getDeclineOn() {
                return this.declineOn;
            }

            @Generated
            public String getStatementDescriptorPrefix() {
                return this.statementDescriptorPrefix;
            }

            @Generated
            public String getStatementDescriptorPrefixKana() {
                return this.statementDescriptorPrefixKana;
            }

            @Generated
            public String getStatementDescriptorPrefixKanji() {
                return this.statementDescriptorPrefixKanji;
            }

            @Generated
            public void setDeclineOn(DeclineOn declineOn) {
                this.declineOn = declineOn;
            }

            @Generated
            public void setStatementDescriptorPrefix(String statementDescriptorPrefix) {
                this.statementDescriptorPrefix = statementDescriptorPrefix;
            }

            @Generated
            public void setStatementDescriptorPrefixKana(String statementDescriptorPrefixKana) {
                this.statementDescriptorPrefixKana = statementDescriptorPrefixKana;
            }

            @Generated
            public void setStatementDescriptorPrefixKanji(String statementDescriptorPrefixKanji) {
                this.statementDescriptorPrefixKanji = statementDescriptorPrefixKanji;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardPayments)) {
                    return false;
                }
                CardPayments other = (CardPayments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                DeclineOn this$declineOn = this.getDeclineOn();
                DeclineOn other$declineOn = other.getDeclineOn();
                if (this$declineOn == null ? other$declineOn != null : !((Object)this$declineOn).equals(other$declineOn)) {
                    return false;
                }
                String this$statementDescriptorPrefix = this.getStatementDescriptorPrefix();
                String other$statementDescriptorPrefix = other.getStatementDescriptorPrefix();
                if (this$statementDescriptorPrefix == null ? other$statementDescriptorPrefix != null : !this$statementDescriptorPrefix.equals(other$statementDescriptorPrefix)) {
                    return false;
                }
                String this$statementDescriptorPrefixKana = this.getStatementDescriptorPrefixKana();
                String other$statementDescriptorPrefixKana = other.getStatementDescriptorPrefixKana();
                if (this$statementDescriptorPrefixKana == null ? other$statementDescriptorPrefixKana != null : !this$statementDescriptorPrefixKana.equals(other$statementDescriptorPrefixKana)) {
                    return false;
                }
                String this$statementDescriptorPrefixKanji = this.getStatementDescriptorPrefixKanji();
                String other$statementDescriptorPrefixKanji = other.getStatementDescriptorPrefixKanji();
                return !(this$statementDescriptorPrefixKanji == null ? other$statementDescriptorPrefixKanji != null : !this$statementDescriptorPrefixKanji.equals(other$statementDescriptorPrefixKanji));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardPayments;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                DeclineOn $declineOn = this.getDeclineOn();
                result = result * 59 + ($declineOn == null ? 43 : ((Object)$declineOn).hashCode());
                String $statementDescriptorPrefix = this.getStatementDescriptorPrefix();
                result = result * 59 + ($statementDescriptorPrefix == null ? 43 : $statementDescriptorPrefix.hashCode());
                String $statementDescriptorPrefixKana = this.getStatementDescriptorPrefixKana();
                result = result * 59 + ($statementDescriptorPrefixKana == null ? 43 : $statementDescriptorPrefixKana.hashCode());
                String $statementDescriptorPrefixKanji = this.getStatementDescriptorPrefixKanji();
                result = result * 59 + ($statementDescriptorPrefixKanji == null ? 43 : $statementDescriptorPrefixKanji.hashCode());
                return result;
            }

            public static class DeclineOn
            extends StripeObject {
                @SerializedName(value="avs_failure")
                Boolean avsFailure;
                @SerializedName(value="cvc_failure")
                Boolean cvcFailure;

                @Generated
                public Boolean getAvsFailure() {
                    return this.avsFailure;
                }

                @Generated
                public Boolean getCvcFailure() {
                    return this.cvcFailure;
                }

                @Generated
                public void setAvsFailure(Boolean avsFailure) {
                    this.avsFailure = avsFailure;
                }

                @Generated
                public void setCvcFailure(Boolean cvcFailure) {
                    this.cvcFailure = cvcFailure;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof DeclineOn)) {
                        return false;
                    }
                    DeclineOn other = (DeclineOn)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$avsFailure = this.getAvsFailure();
                    Boolean other$avsFailure = other.getAvsFailure();
                    if (this$avsFailure == null ? other$avsFailure != null : !((Object)this$avsFailure).equals(other$avsFailure)) {
                        return false;
                    }
                    Boolean this$cvcFailure = this.getCvcFailure();
                    Boolean other$cvcFailure = other.getCvcFailure();
                    return !(this$cvcFailure == null ? other$cvcFailure != null : !((Object)this$cvcFailure).equals(other$cvcFailure));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof DeclineOn;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $avsFailure = this.getAvsFailure();
                    result = result * 59 + ($avsFailure == null ? 43 : ((Object)$avsFailure).hashCode());
                    Boolean $cvcFailure = this.getCvcFailure();
                    result = result * 59 + ($cvcFailure == null ? 43 : ((Object)$cvcFailure).hashCode());
                    return result;
                }
            }
        }

        public static class Dashboard
        extends StripeObject {
            @SerializedName(value="display_name")
            String displayName;
            @SerializedName(value="timezone")
            String timezone;

            @Generated
            public String getDisplayName() {
                return this.displayName;
            }

            @Generated
            public String getTimezone() {
                return this.timezone;
            }

            @Generated
            public void setDisplayName(String displayName) {
                this.displayName = displayName;
            }

            @Generated
            public void setTimezone(String timezone) {
                this.timezone = timezone;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dashboard)) {
                    return false;
                }
                Dashboard other = (Dashboard)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$displayName = this.getDisplayName();
                String other$displayName = other.getDisplayName();
                if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                    return false;
                }
                String this$timezone = this.getTimezone();
                String other$timezone = other.getTimezone();
                return !(this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dashboard;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $displayName = this.getDisplayName();
                result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                String $timezone = this.getTimezone();
                result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
                return result;
            }
        }

        public static class Payments
        extends StripeObject {
            @SerializedName(value="statement_descriptor")
            String statementDescriptor;
            @SerializedName(value="statement_descriptor_kana")
            String statementDescriptorKana;
            @SerializedName(value="statement_descriptor_kanji")
            String statementDescriptorKanji;
            @SerializedName(value="statement_descriptor_prefix_kana")
            String statementDescriptorPrefixKana;
            @SerializedName(value="statement_descriptor_prefix_kanji")
            String statementDescriptorPrefixKanji;

            @Generated
            public String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            @Generated
            public String getStatementDescriptorKana() {
                return this.statementDescriptorKana;
            }

            @Generated
            public String getStatementDescriptorKanji() {
                return this.statementDescriptorKanji;
            }

            @Generated
            public String getStatementDescriptorPrefixKana() {
                return this.statementDescriptorPrefixKana;
            }

            @Generated
            public String getStatementDescriptorPrefixKanji() {
                return this.statementDescriptorPrefixKanji;
            }

            @Generated
            public void setStatementDescriptor(String statementDescriptor) {
                this.statementDescriptor = statementDescriptor;
            }

            @Generated
            public void setStatementDescriptorKana(String statementDescriptorKana) {
                this.statementDescriptorKana = statementDescriptorKana;
            }

            @Generated
            public void setStatementDescriptorKanji(String statementDescriptorKanji) {
                this.statementDescriptorKanji = statementDescriptorKanji;
            }

            @Generated
            public void setStatementDescriptorPrefixKana(String statementDescriptorPrefixKana) {
                this.statementDescriptorPrefixKana = statementDescriptorPrefixKana;
            }

            @Generated
            public void setStatementDescriptorPrefixKanji(String statementDescriptorPrefixKanji) {
                this.statementDescriptorPrefixKanji = statementDescriptorPrefixKanji;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payments)) {
                    return false;
                }
                Payments other = (Payments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$statementDescriptor = this.getStatementDescriptor();
                String other$statementDescriptor = other.getStatementDescriptor();
                if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
                    return false;
                }
                String this$statementDescriptorKana = this.getStatementDescriptorKana();
                String other$statementDescriptorKana = other.getStatementDescriptorKana();
                if (this$statementDescriptorKana == null ? other$statementDescriptorKana != null : !this$statementDescriptorKana.equals(other$statementDescriptorKana)) {
                    return false;
                }
                String this$statementDescriptorKanji = this.getStatementDescriptorKanji();
                String other$statementDescriptorKanji = other.getStatementDescriptorKanji();
                if (this$statementDescriptorKanji == null ? other$statementDescriptorKanji != null : !this$statementDescriptorKanji.equals(other$statementDescriptorKanji)) {
                    return false;
                }
                String this$statementDescriptorPrefixKana = this.getStatementDescriptorPrefixKana();
                String other$statementDescriptorPrefixKana = other.getStatementDescriptorPrefixKana();
                if (this$statementDescriptorPrefixKana == null ? other$statementDescriptorPrefixKana != null : !this$statementDescriptorPrefixKana.equals(other$statementDescriptorPrefixKana)) {
                    return false;
                }
                String this$statementDescriptorPrefixKanji = this.getStatementDescriptorPrefixKanji();
                String other$statementDescriptorPrefixKanji = other.getStatementDescriptorPrefixKanji();
                return !(this$statementDescriptorPrefixKanji == null ? other$statementDescriptorPrefixKanji != null : !this$statementDescriptorPrefixKanji.equals(other$statementDescriptorPrefixKanji));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payments;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $statementDescriptor = this.getStatementDescriptor();
                result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
                String $statementDescriptorKana = this.getStatementDescriptorKana();
                result = result * 59 + ($statementDescriptorKana == null ? 43 : $statementDescriptorKana.hashCode());
                String $statementDescriptorKanji = this.getStatementDescriptorKanji();
                result = result * 59 + ($statementDescriptorKanji == null ? 43 : $statementDescriptorKanji.hashCode());
                String $statementDescriptorPrefixKana = this.getStatementDescriptorPrefixKana();
                result = result * 59 + ($statementDescriptorPrefixKana == null ? 43 : $statementDescriptorPrefixKana.hashCode());
                String $statementDescriptorPrefixKanji = this.getStatementDescriptorPrefixKanji();
                result = result * 59 + ($statementDescriptorPrefixKanji == null ? 43 : $statementDescriptorPrefixKanji.hashCode());
                return result;
            }
        }

        public static class Payouts
        extends StripeObject {
            @SerializedName(value="debit_negative_balances")
            Boolean debitNegativeBalances;
            @SerializedName(value="schedule")
            Schedule schedule;
            @SerializedName(value="statement_descriptor")
            String statementDescriptor;

            @Generated
            public Boolean getDebitNegativeBalances() {
                return this.debitNegativeBalances;
            }

            @Generated
            public Schedule getSchedule() {
                return this.schedule;
            }

            @Generated
            public String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            @Generated
            public void setDebitNegativeBalances(Boolean debitNegativeBalances) {
                this.debitNegativeBalances = debitNegativeBalances;
            }

            @Generated
            public void setSchedule(Schedule schedule) {
                this.schedule = schedule;
            }

            @Generated
            public void setStatementDescriptor(String statementDescriptor) {
                this.statementDescriptor = statementDescriptor;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payouts)) {
                    return false;
                }
                Payouts other = (Payouts)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$debitNegativeBalances = this.getDebitNegativeBalances();
                Boolean other$debitNegativeBalances = other.getDebitNegativeBalances();
                if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !((Object)this$debitNegativeBalances).equals(other$debitNegativeBalances)) {
                    return false;
                }
                Schedule this$schedule = this.getSchedule();
                Schedule other$schedule = other.getSchedule();
                if (this$schedule == null ? other$schedule != null : !((Object)this$schedule).equals(other$schedule)) {
                    return false;
                }
                String this$statementDescriptor = this.getStatementDescriptor();
                String other$statementDescriptor = other.getStatementDescriptor();
                return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payouts;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $debitNegativeBalances = this.getDebitNegativeBalances();
                result = result * 59 + ($debitNegativeBalances == null ? 43 : ((Object)$debitNegativeBalances).hashCode());
                Schedule $schedule = this.getSchedule();
                result = result * 59 + ($schedule == null ? 43 : ((Object)$schedule).hashCode());
                String $statementDescriptor = this.getStatementDescriptor();
                result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
                return result;
            }

            public static class Schedule
            extends StripeObject {
                @SerializedName(value="delay_days")
                Long delayDays;
                @SerializedName(value="interval")
                String interval;
                @SerializedName(value="monthly_anchor")
                Long monthlyAnchor;
                @SerializedName(value="weekly_anchor")
                String weeklyAnchor;

                @Generated
                public Long getDelayDays() {
                    return this.delayDays;
                }

                @Generated
                public String getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getMonthlyAnchor() {
                    return this.monthlyAnchor;
                }

                @Generated
                public String getWeeklyAnchor() {
                    return this.weeklyAnchor;
                }

                @Generated
                public void setDelayDays(Long delayDays) {
                    this.delayDays = delayDays;
                }

                @Generated
                public void setInterval(String interval) {
                    this.interval = interval;
                }

                @Generated
                public void setMonthlyAnchor(Long monthlyAnchor) {
                    this.monthlyAnchor = monthlyAnchor;
                }

                @Generated
                public void setWeeklyAnchor(String weeklyAnchor) {
                    this.weeklyAnchor = weeklyAnchor;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Schedule)) {
                        return false;
                    }
                    Schedule other = (Schedule)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$delayDays = this.getDelayDays();
                    Long other$delayDays = other.getDelayDays();
                    if (this$delayDays == null ? other$delayDays != null : !((Object)this$delayDays).equals(other$delayDays)) {
                        return false;
                    }
                    Long this$monthlyAnchor = this.getMonthlyAnchor();
                    Long other$monthlyAnchor = other.getMonthlyAnchor();
                    if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !((Object)this$monthlyAnchor).equals(other$monthlyAnchor)) {
                        return false;
                    }
                    String this$interval = this.getInterval();
                    String other$interval = other.getInterval();
                    if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                        return false;
                    }
                    String this$weeklyAnchor = this.getWeeklyAnchor();
                    String other$weeklyAnchor = other.getWeeklyAnchor();
                    return !(this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Schedule;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $delayDays = this.getDelayDays();
                    result = result * 59 + ($delayDays == null ? 43 : ((Object)$delayDays).hashCode());
                    Long $monthlyAnchor = this.getMonthlyAnchor();
                    result = result * 59 + ($monthlyAnchor == null ? 43 : ((Object)$monthlyAnchor).hashCode());
                    String $interval = this.getInterval();
                    result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                    String $weeklyAnchor = this.getWeeklyAnchor();
                    result = result * 59 + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
                    return result;
                }
            }
        }

        public static class SepaDebitPayments
        extends StripeObject {
            @SerializedName(value="creditor_id")
            String creditorId;

            @Generated
            public String getCreditorId() {
                return this.creditorId;
            }

            @Generated
            public void setCreditorId(String creditorId) {
                this.creditorId = creditorId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebitPayments)) {
                    return false;
                }
                SepaDebitPayments other = (SepaDebitPayments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$creditorId = this.getCreditorId();
                String other$creditorId = other.getCreditorId();
                return !(this$creditorId == null ? other$creditorId != null : !this$creditorId.equals(other$creditorId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebitPayments;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $creditorId = this.getCreditorId();
                result = result * 59 + ($creditorId == null ? 43 : $creditorId.hashCode());
                return result;
            }
        }

        public static class TaxForms
        extends StripeObject {
            @SerializedName(value="consented_to_paperless_delivery")
            Boolean consentedToPaperlessDelivery;

            @Generated
            public Boolean getConsentedToPaperlessDelivery() {
                return this.consentedToPaperlessDelivery;
            }

            @Generated
            public void setConsentedToPaperlessDelivery(Boolean consentedToPaperlessDelivery) {
                this.consentedToPaperlessDelivery = consentedToPaperlessDelivery;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxForms)) {
                    return false;
                }
                TaxForms other = (TaxForms)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$consentedToPaperlessDelivery = this.getConsentedToPaperlessDelivery();
                Boolean other$consentedToPaperlessDelivery = other.getConsentedToPaperlessDelivery();
                return !(this$consentedToPaperlessDelivery == null ? other$consentedToPaperlessDelivery != null : !((Object)this$consentedToPaperlessDelivery).equals(other$consentedToPaperlessDelivery));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxForms;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $consentedToPaperlessDelivery = this.getConsentedToPaperlessDelivery();
                result = result * 59 + ($consentedToPaperlessDelivery == null ? 43 : ((Object)$consentedToPaperlessDelivery).hashCode());
                return result;
            }
        }

        public static class Treasury
        extends StripeObject {
            @SerializedName(value="tos_acceptance")
            TosAcceptance tosAcceptance;

            @Generated
            public TosAcceptance getTosAcceptance() {
                return this.tosAcceptance;
            }

            @Generated
            public void setTosAcceptance(TosAcceptance tosAcceptance) {
                this.tosAcceptance = tosAcceptance;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Treasury)) {
                    return false;
                }
                Treasury other = (Treasury)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TosAcceptance this$tosAcceptance = this.getTosAcceptance();
                TosAcceptance other$tosAcceptance = other.getTosAcceptance();
                return !(this$tosAcceptance == null ? other$tosAcceptance != null : !((Object)this$tosAcceptance).equals(other$tosAcceptance));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Treasury;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TosAcceptance $tosAcceptance = this.getTosAcceptance();
                result = result * 59 + ($tosAcceptance == null ? 43 : ((Object)$tosAcceptance).hashCode());
                return result;
            }

            public static class TosAcceptance
            extends StripeObject {
                @SerializedName(value="date")
                Long date;
                @SerializedName(value="ip")
                String ip;
                @SerializedName(value="user_agent")
                String userAgent;

                @Generated
                public Long getDate() {
                    return this.date;
                }

                @Generated
                public String getIp() {
                    return this.ip;
                }

                @Generated
                public String getUserAgent() {
                    return this.userAgent;
                }

                @Generated
                public void setDate(Long date) {
                    this.date = date;
                }

                @Generated
                public void setIp(String ip) {
                    this.ip = ip;
                }

                @Generated
                public void setUserAgent(String userAgent) {
                    this.userAgent = userAgent;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TosAcceptance)) {
                        return false;
                    }
                    TosAcceptance other = (TosAcceptance)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$date = this.getDate();
                    Long other$date = other.getDate();
                    if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                        return false;
                    }
                    String this$ip = this.getIp();
                    String other$ip = other.getIp();
                    if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                        return false;
                    }
                    String this$userAgent = this.getUserAgent();
                    String other$userAgent = other.getUserAgent();
                    return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TosAcceptance;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $date = this.getDate();
                    result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
                    String $ip = this.getIp();
                    result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
                    String $userAgent = this.getUserAgent();
                    result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
                    return result;
                }
            }
        }
    }

    public static class TosAcceptance
    extends StripeObject {
        @SerializedName(value="date")
        Long date;
        @SerializedName(value="ip")
        String ip;
        @SerializedName(value="service_agreement")
        String serviceAgreement;
        @SerializedName(value="user_agent")
        String userAgent;

        @Generated
        public Long getDate() {
            return this.date;
        }

        @Generated
        public String getIp() {
            return this.ip;
        }

        @Generated
        public String getServiceAgreement() {
            return this.serviceAgreement;
        }

        @Generated
        public String getUserAgent() {
            return this.userAgent;
        }

        @Generated
        public void setDate(Long date) {
            this.date = date;
        }

        @Generated
        public void setIp(String ip) {
            this.ip = ip;
        }

        @Generated
        public void setServiceAgreement(String serviceAgreement) {
            this.serviceAgreement = serviceAgreement;
        }

        @Generated
        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TosAcceptance)) {
                return false;
            }
            TosAcceptance other = (TosAcceptance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$date = this.getDate();
            Long other$date = other.getDate();
            if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$serviceAgreement = this.getServiceAgreement();
            String other$serviceAgreement = other.getServiceAgreement();
            if (this$serviceAgreement == null ? other$serviceAgreement != null : !this$serviceAgreement.equals(other$serviceAgreement)) {
                return false;
            }
            String this$userAgent = this.getUserAgent();
            String other$userAgent = other.getUserAgent();
            return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TosAcceptance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $serviceAgreement = this.getServiceAgreement();
            result = result * 59 + ($serviceAgreement == null ? 43 : $serviceAgreement.hashCode());
            String $userAgent = this.getUserAgent();
            result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
            return result;
        }
    }
}

