/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerSessionCreateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class CustomerSession
extends ApiResource {
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="components")
    Components components;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public static CustomerSession create(Map<String, Object> params) throws StripeException {
        return CustomerSession.create(params, (RequestOptions)null);
    }

    public static CustomerSession create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/customer_sessions";
        return (CustomerSession)CustomerSession.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)CustomerSession.class), options, ApiMode.V1);
    }

    public static CustomerSession create(CustomerSessionCreateParams params) throws StripeException {
        return CustomerSession.create(params, (RequestOptions)null);
    }

    public static CustomerSession create(CustomerSessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/customer_sessions";
        ApiResource.checkNullTypedParams(path, params);
        return (CustomerSession)CustomerSession.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CustomerSession.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.components, responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Components getComponents() {
        return this.components;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setComponents(Components components) {
        this.components = components;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerSession)) {
            return false;
        }
        CustomerSession other = (CustomerSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        Components this$components = this.getComponents();
        Components other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomerSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        Components $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public static class Components
    extends StripeObject {
        @SerializedName(value="payment_element")
        PaymentElement paymentElement;
        @SerializedName(value="pricing_table")
        PricingTable pricingTable;

        @Generated
        public PaymentElement getPaymentElement() {
            return this.paymentElement;
        }

        @Generated
        public PricingTable getPricingTable() {
            return this.pricingTable;
        }

        @Generated
        public void setPaymentElement(PaymentElement paymentElement) {
            this.paymentElement = paymentElement;
        }

        @Generated
        public void setPricingTable(PricingTable pricingTable) {
            this.pricingTable = pricingTable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Components)) {
                return false;
            }
            Components other = (Components)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PaymentElement this$paymentElement = this.getPaymentElement();
            PaymentElement other$paymentElement = other.getPaymentElement();
            if (this$paymentElement == null ? other$paymentElement != null : !((Object)this$paymentElement).equals(other$paymentElement)) {
                return false;
            }
            PricingTable this$pricingTable = this.getPricingTable();
            PricingTable other$pricingTable = other.getPricingTable();
            return !(this$pricingTable == null ? other$pricingTable != null : !((Object)this$pricingTable).equals(other$pricingTable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Components;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PaymentElement $paymentElement = this.getPaymentElement();
            result = result * 59 + ($paymentElement == null ? 43 : ((Object)$paymentElement).hashCode());
            PricingTable $pricingTable = this.getPricingTable();
            result = result * 59 + ($pricingTable == null ? 43 : ((Object)$pricingTable).hashCode());
            return result;
        }

        public static class PaymentElement
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaymentElement)) {
                    return false;
                }
                PaymentElement other = (PaymentElement)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaymentElement;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="payment_method_detach")
                String paymentMethodDetach;
                @SerializedName(value="payment_method_set_as_customer_default")
                String paymentMethodSetAsCustomerDefault;
                @SerializedName(value="payment_method_update")
                String paymentMethodUpdate;

                @Generated
                public String getPaymentMethodDetach() {
                    return this.paymentMethodDetach;
                }

                @Generated
                public String getPaymentMethodSetAsCustomerDefault() {
                    return this.paymentMethodSetAsCustomerDefault;
                }

                @Generated
                public String getPaymentMethodUpdate() {
                    return this.paymentMethodUpdate;
                }

                @Generated
                public void setPaymentMethodDetach(String paymentMethodDetach) {
                    this.paymentMethodDetach = paymentMethodDetach;
                }

                @Generated
                public void setPaymentMethodSetAsCustomerDefault(String paymentMethodSetAsCustomerDefault) {
                    this.paymentMethodSetAsCustomerDefault = paymentMethodSetAsCustomerDefault;
                }

                @Generated
                public void setPaymentMethodUpdate(String paymentMethodUpdate) {
                    this.paymentMethodUpdate = paymentMethodUpdate;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$paymentMethodDetach = this.getPaymentMethodDetach();
                    String other$paymentMethodDetach = other.getPaymentMethodDetach();
                    if (this$paymentMethodDetach == null ? other$paymentMethodDetach != null : !this$paymentMethodDetach.equals(other$paymentMethodDetach)) {
                        return false;
                    }
                    String this$paymentMethodSetAsCustomerDefault = this.getPaymentMethodSetAsCustomerDefault();
                    String other$paymentMethodSetAsCustomerDefault = other.getPaymentMethodSetAsCustomerDefault();
                    if (this$paymentMethodSetAsCustomerDefault == null ? other$paymentMethodSetAsCustomerDefault != null : !this$paymentMethodSetAsCustomerDefault.equals(other$paymentMethodSetAsCustomerDefault)) {
                        return false;
                    }
                    String this$paymentMethodUpdate = this.getPaymentMethodUpdate();
                    String other$paymentMethodUpdate = other.getPaymentMethodUpdate();
                    return !(this$paymentMethodUpdate == null ? other$paymentMethodUpdate != null : !this$paymentMethodUpdate.equals(other$paymentMethodUpdate));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $paymentMethodDetach = this.getPaymentMethodDetach();
                    result = result * 59 + ($paymentMethodDetach == null ? 43 : $paymentMethodDetach.hashCode());
                    String $paymentMethodSetAsCustomerDefault = this.getPaymentMethodSetAsCustomerDefault();
                    result = result * 59 + ($paymentMethodSetAsCustomerDefault == null ? 43 : $paymentMethodSetAsCustomerDefault.hashCode());
                    String $paymentMethodUpdate = this.getPaymentMethodUpdate();
                    result = result * 59 + ($paymentMethodUpdate == null ? 43 : $paymentMethodUpdate.hashCode());
                    return result;
                }
            }
        }

        public static class PricingTable
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PricingTable)) {
                    return false;
                }
                PricingTable other = (PricingTable)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PricingTable;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }
    }
}

