/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.PaymentMethod;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentMethodAttachParams;
import com.stripe.param.PaymentMethodCreateParams;
import com.stripe.param.PaymentMethodDetachParams;
import com.stripe.param.PaymentMethodListParams;
import com.stripe.param.PaymentMethodRetrieveParams;
import com.stripe.param.PaymentMethodUpdateParams;
import java.lang.reflect.Type;

public final class PaymentMethodService
extends ApiService {
    public PaymentMethodService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public PaymentMethod create(PaymentMethodCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public PaymentMethod create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public PaymentMethod create() throws StripeException {
        return this.create(null, null);
    }

    public PaymentMethod create(PaymentMethodCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_methods";
        return (PaymentMethod)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentMethod.class), options, ApiMode.V1);
    }

    public StripeCollection<PaymentMethod> list(PaymentMethodListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PaymentMethod> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PaymentMethod> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PaymentMethod> list(PaymentMethodListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_methods";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<PaymentMethod>>(){}.getType(), options, ApiMode.V1);
    }

    public PaymentMethod retrieve(String paymentMethod, PaymentMethodRetrieveParams params) throws StripeException {
        return this.retrieve(paymentMethod, params, null);
    }

    public PaymentMethod retrieve(String paymentMethod, RequestOptions options) throws StripeException {
        return this.retrieve(paymentMethod, null, options);
    }

    public PaymentMethod retrieve(String paymentMethod) throws StripeException {
        return this.retrieve(paymentMethod, null, null);
    }

    public PaymentMethod retrieve(String paymentMethod, PaymentMethodRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(paymentMethod));
        return (PaymentMethod)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentMethod.class), options, ApiMode.V1);
    }

    public PaymentMethod update(String paymentMethod, PaymentMethodUpdateParams params) throws StripeException {
        return this.update(paymentMethod, params, null);
    }

    public PaymentMethod update(String paymentMethod, RequestOptions options) throws StripeException {
        return this.update(paymentMethod, null, options);
    }

    public PaymentMethod update(String paymentMethod) throws StripeException {
        return this.update(paymentMethod, null, null);
    }

    public PaymentMethod update(String paymentMethod, PaymentMethodUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(paymentMethod));
        return (PaymentMethod)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentMethod.class), options, ApiMode.V1);
    }

    public PaymentMethod attach(String paymentMethod, PaymentMethodAttachParams params) throws StripeException {
        return this.attach(paymentMethod, params, null);
    }

    public PaymentMethod attach(String paymentMethod, PaymentMethodAttachParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_methods/%s/attach", ApiResource.urlEncodeId(paymentMethod));
        return (PaymentMethod)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentMethod.class), options, ApiMode.V1);
    }

    public PaymentMethod detach(String paymentMethod, PaymentMethodDetachParams params) throws StripeException {
        return this.detach(paymentMethod, params, null);
    }

    public PaymentMethod detach(String paymentMethod, RequestOptions options) throws StripeException {
        return this.detach(paymentMethod, null, options);
    }

    public PaymentMethod detach(String paymentMethod) throws StripeException {
        return this.detach(paymentMethod, null, null);
    }

    public PaymentMethod detach(String paymentMethod, PaymentMethodDetachParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_methods/%s/detach", ApiResource.urlEncodeId(paymentMethod));
        return (PaymentMethod)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentMethod.class), options, ApiMode.V1);
    }
}

