/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.LineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentLinkCollection;
import com.stripe.model.ShippingRate;
import com.stripe.model.StripeObject;
import com.stripe.model.TaxId;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentLinkCreateParams;
import com.stripe.param.PaymentLinkListLineItemsParams;
import com.stripe.param.PaymentLinkListParams;
import com.stripe.param.PaymentLinkRetrieveParams;
import com.stripe.param.PaymentLinkUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class PaymentLink
extends ApiResource
implements HasId,
MetadataStore<PaymentLink> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="after_completion")
    AfterCompletion afterCompletion;
    @SerializedName(value="allow_promotion_codes")
    Boolean allowPromotionCodes;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="billing_address_collection")
    String billingAddressCollection;
    @SerializedName(value="consent_collection")
    ConsentCollection consentCollection;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="custom_fields")
    List<CustomField> customFields;
    @SerializedName(value="custom_text")
    CustomText customText;
    @SerializedName(value="customer_creation")
    String customerCreation;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="inactive_message")
    String inactiveMessage;
    @SerializedName(value="invoice_creation")
    InvoiceCreation invoiceCreation;
    @SerializedName(value="line_items")
    LineItemCollection lineItems;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="payment_intent_data")
    PaymentIntentData paymentIntentData;
    @SerializedName(value="payment_method_collection")
    String paymentMethodCollection;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="phone_number_collection")
    PhoneNumberCollection phoneNumberCollection;
    @SerializedName(value="restrictions")
    Restrictions restrictions;
    @SerializedName(value="shipping_address_collection")
    ShippingAddressCollection shippingAddressCollection;
    @SerializedName(value="shipping_options")
    List<ShippingOption> shippingOptions;
    @SerializedName(value="submit_type")
    String submitType;
    @SerializedName(value="subscription_data")
    SubscriptionData subscriptionData;
    @SerializedName(value="tax_id_collection")
    TaxIdCollection taxIdCollection;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="url")
    String url;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public static PaymentLink create(Map<String, Object> params) throws StripeException {
        return PaymentLink.create(params, (RequestOptions)null);
    }

    public static PaymentLink create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_links";
        return (PaymentLink)PaymentLink.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)PaymentLink.class), options, ApiMode.V1);
    }

    public static PaymentLink create(PaymentLinkCreateParams params) throws StripeException {
        return PaymentLink.create(params, (RequestOptions)null);
    }

    public static PaymentLink create(PaymentLinkCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_links";
        ApiResource.checkNullTypedParams(path, params);
        return (PaymentLink)PaymentLink.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentLink.class), options, ApiMode.V1);
    }

    public static PaymentLinkCollection list(Map<String, Object> params) throws StripeException {
        return PaymentLink.list(params, (RequestOptions)null);
    }

    public static PaymentLinkCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_links";
        return (PaymentLinkCollection)PaymentLink.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)PaymentLinkCollection.class), options, ApiMode.V1);
    }

    public static PaymentLinkCollection list(PaymentLinkListParams params) throws StripeException {
        return PaymentLink.list(params, (RequestOptions)null);
    }

    public static PaymentLinkCollection list(PaymentLinkListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_links";
        ApiResource.checkNullTypedParams(path, params);
        return (PaymentLinkCollection)PaymentLink.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentLinkCollection.class), options, ApiMode.V1);
    }

    public LineItemCollection listLineItems() throws StripeException {
        return this.listLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_links/%s/line_items", ApiResource.urlEncodeId(this.getId()));
        return (LineItemCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)LineItemCollection.class), options, ApiMode.V1);
    }

    public LineItemCollection listLineItems(PaymentLinkListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(PaymentLinkListLineItemsParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_links/%s/line_items", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (LineItemCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)LineItemCollection.class), options, ApiMode.V1);
    }

    public static PaymentLink retrieve(String paymentLink) throws StripeException {
        return PaymentLink.retrieve(paymentLink, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentLink retrieve(String paymentLink, RequestOptions options) throws StripeException {
        return PaymentLink.retrieve(paymentLink, (Map<String, Object>)null, options);
    }

    public static PaymentLink retrieve(String paymentLink, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink));
        return (PaymentLink)PaymentLink.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)PaymentLink.class), options, ApiMode.V1);
    }

    public static PaymentLink retrieve(String paymentLink, PaymentLinkRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink));
        ApiResource.checkNullTypedParams(path, params);
        return (PaymentLink)PaymentLink.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentLink.class), options, ApiMode.V1);
    }

    public PaymentLink update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PaymentLink update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(this.getId()));
        return (PaymentLink)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)PaymentLink.class), options, ApiMode.V1);
    }

    public PaymentLink update(PaymentLinkUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentLink update(PaymentLinkUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (PaymentLink)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentLink.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.afterCompletion, responseGetter);
        this.trySetResponseGetter(this.application, responseGetter);
        this.trySetResponseGetter(this.automaticTax, responseGetter);
        this.trySetResponseGetter(this.consentCollection, responseGetter);
        this.trySetResponseGetter(this.customText, responseGetter);
        this.trySetResponseGetter(this.invoiceCreation, responseGetter);
        this.trySetResponseGetter(this.lineItems, responseGetter);
        this.trySetResponseGetter(this.onBehalfOf, responseGetter);
        this.trySetResponseGetter(this.paymentIntentData, responseGetter);
        this.trySetResponseGetter(this.phoneNumberCollection, responseGetter);
        this.trySetResponseGetter(this.restrictions, responseGetter);
        this.trySetResponseGetter(this.shippingAddressCollection, responseGetter);
        this.trySetResponseGetter(this.subscriptionData, responseGetter);
        this.trySetResponseGetter(this.taxIdCollection, responseGetter);
        this.trySetResponseGetter(this.transferData, responseGetter);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public AfterCompletion getAfterCompletion() {
        return this.afterCompletion;
    }

    @Generated
    public Boolean getAllowPromotionCodes() {
        return this.allowPromotionCodes;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public BigDecimal getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public String getBillingAddressCollection() {
        return this.billingAddressCollection;
    }

    @Generated
    public ConsentCollection getConsentCollection() {
        return this.consentCollection;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    @Generated
    public CustomText getCustomText() {
        return this.customText;
    }

    @Generated
    public String getCustomerCreation() {
        return this.customerCreation;
    }

    @Generated
    public String getInactiveMessage() {
        return this.inactiveMessage;
    }

    @Generated
    public InvoiceCreation getInvoiceCreation() {
        return this.invoiceCreation;
    }

    @Generated
    public LineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentIntentData getPaymentIntentData() {
        return this.paymentIntentData;
    }

    @Generated
    public String getPaymentMethodCollection() {
        return this.paymentMethodCollection;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public PhoneNumberCollection getPhoneNumberCollection() {
        return this.phoneNumberCollection;
    }

    @Generated
    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    @Generated
    public ShippingAddressCollection getShippingAddressCollection() {
        return this.shippingAddressCollection;
    }

    @Generated
    public List<ShippingOption> getShippingOptions() {
        return this.shippingOptions;
    }

    @Generated
    public String getSubmitType() {
        return this.submitType;
    }

    @Generated
    public SubscriptionData getSubscriptionData() {
        return this.subscriptionData;
    }

    @Generated
    public TaxIdCollection getTaxIdCollection() {
        return this.taxIdCollection;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAfterCompletion(AfterCompletion afterCompletion) {
        this.afterCompletion = afterCompletion;
    }

    @Generated
    public void setAllowPromotionCodes(Boolean allowPromotionCodes) {
        this.allowPromotionCodes = allowPromotionCodes;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    @Generated
    public void setAutomaticTax(AutomaticTax automaticTax) {
        this.automaticTax = automaticTax;
    }

    @Generated
    public void setBillingAddressCollection(String billingAddressCollection) {
        this.billingAddressCollection = billingAddressCollection;
    }

    @Generated
    public void setConsentCollection(ConsentCollection consentCollection) {
        this.consentCollection = consentCollection;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    @Generated
    public void setCustomText(CustomText customText) {
        this.customText = customText;
    }

    @Generated
    public void setCustomerCreation(String customerCreation) {
        this.customerCreation = customerCreation;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInactiveMessage(String inactiveMessage) {
        this.inactiveMessage = inactiveMessage;
    }

    @Generated
    public void setInvoiceCreation(InvoiceCreation invoiceCreation) {
        this.invoiceCreation = invoiceCreation;
    }

    @Generated
    public void setLineItems(LineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentIntentData(PaymentIntentData paymentIntentData) {
        this.paymentIntentData = paymentIntentData;
    }

    @Generated
    public void setPaymentMethodCollection(String paymentMethodCollection) {
        this.paymentMethodCollection = paymentMethodCollection;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setPhoneNumberCollection(PhoneNumberCollection phoneNumberCollection) {
        this.phoneNumberCollection = phoneNumberCollection;
    }

    @Generated
    public void setRestrictions(Restrictions restrictions) {
        this.restrictions = restrictions;
    }

    @Generated
    public void setShippingAddressCollection(ShippingAddressCollection shippingAddressCollection) {
        this.shippingAddressCollection = shippingAddressCollection;
    }

    @Generated
    public void setShippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    @Generated
    public void setSubmitType(String submitType) {
        this.submitType = submitType;
    }

    @Generated
    public void setSubscriptionData(SubscriptionData subscriptionData) {
        this.subscriptionData = subscriptionData;
    }

    @Generated
    public void setTaxIdCollection(TaxIdCollection taxIdCollection) {
        this.taxIdCollection = taxIdCollection;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentLink)) {
            return false;
        }
        PaymentLink other = (PaymentLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$allowPromotionCodes = this.getAllowPromotionCodes();
        Boolean other$allowPromotionCodes = other.getAllowPromotionCodes();
        if (this$allowPromotionCodes == null ? other$allowPromotionCodes != null : !((Object)this$allowPromotionCodes).equals(other$allowPromotionCodes)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AfterCompletion this$afterCompletion = this.getAfterCompletion();
        AfterCompletion other$afterCompletion = other.getAfterCompletion();
        if (this$afterCompletion == null ? other$afterCompletion != null : !((Object)this$afterCompletion).equals(other$afterCompletion)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
        BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
        if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
            return false;
        }
        AutomaticTax this$automaticTax = this.getAutomaticTax();
        AutomaticTax other$automaticTax = other.getAutomaticTax();
        if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
            return false;
        }
        String this$billingAddressCollection = this.getBillingAddressCollection();
        String other$billingAddressCollection = other.getBillingAddressCollection();
        if (this$billingAddressCollection == null ? other$billingAddressCollection != null : !this$billingAddressCollection.equals(other$billingAddressCollection)) {
            return false;
        }
        ConsentCollection this$consentCollection = this.getConsentCollection();
        ConsentCollection other$consentCollection = other.getConsentCollection();
        if (this$consentCollection == null ? other$consentCollection != null : !((Object)this$consentCollection).equals(other$consentCollection)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        List<CustomField> this$customFields = this.getCustomFields();
        List<CustomField> other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        CustomText this$customText = this.getCustomText();
        CustomText other$customText = other.getCustomText();
        if (this$customText == null ? other$customText != null : !((Object)this$customText).equals(other$customText)) {
            return false;
        }
        String this$customerCreation = this.getCustomerCreation();
        String other$customerCreation = other.getCustomerCreation();
        if (this$customerCreation == null ? other$customerCreation != null : !this$customerCreation.equals(other$customerCreation)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$inactiveMessage = this.getInactiveMessage();
        String other$inactiveMessage = other.getInactiveMessage();
        if (this$inactiveMessage == null ? other$inactiveMessage != null : !this$inactiveMessage.equals(other$inactiveMessage)) {
            return false;
        }
        InvoiceCreation this$invoiceCreation = this.getInvoiceCreation();
        InvoiceCreation other$invoiceCreation = other.getInvoiceCreation();
        if (this$invoiceCreation == null ? other$invoiceCreation != null : !((Object)this$invoiceCreation).equals(other$invoiceCreation)) {
            return false;
        }
        LineItemCollection this$lineItems = this.getLineItems();
        LineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        PaymentIntentData this$paymentIntentData = this.getPaymentIntentData();
        PaymentIntentData other$paymentIntentData = other.getPaymentIntentData();
        if (this$paymentIntentData == null ? other$paymentIntentData != null : !((Object)this$paymentIntentData).equals(other$paymentIntentData)) {
            return false;
        }
        String this$paymentMethodCollection = this.getPaymentMethodCollection();
        String other$paymentMethodCollection = other.getPaymentMethodCollection();
        if (this$paymentMethodCollection == null ? other$paymentMethodCollection != null : !this$paymentMethodCollection.equals(other$paymentMethodCollection)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        PhoneNumberCollection this$phoneNumberCollection = this.getPhoneNumberCollection();
        PhoneNumberCollection other$phoneNumberCollection = other.getPhoneNumberCollection();
        if (this$phoneNumberCollection == null ? other$phoneNumberCollection != null : !((Object)this$phoneNumberCollection).equals(other$phoneNumberCollection)) {
            return false;
        }
        Restrictions this$restrictions = this.getRestrictions();
        Restrictions other$restrictions = other.getRestrictions();
        if (this$restrictions == null ? other$restrictions != null : !((Object)this$restrictions).equals(other$restrictions)) {
            return false;
        }
        ShippingAddressCollection this$shippingAddressCollection = this.getShippingAddressCollection();
        ShippingAddressCollection other$shippingAddressCollection = other.getShippingAddressCollection();
        if (this$shippingAddressCollection == null ? other$shippingAddressCollection != null : !((Object)this$shippingAddressCollection).equals(other$shippingAddressCollection)) {
            return false;
        }
        List<ShippingOption> this$shippingOptions = this.getShippingOptions();
        List<ShippingOption> other$shippingOptions = other.getShippingOptions();
        if (this$shippingOptions == null ? other$shippingOptions != null : !((Object)this$shippingOptions).equals(other$shippingOptions)) {
            return false;
        }
        String this$submitType = this.getSubmitType();
        String other$submitType = other.getSubmitType();
        if (this$submitType == null ? other$submitType != null : !this$submitType.equals(other$submitType)) {
            return false;
        }
        SubscriptionData this$subscriptionData = this.getSubscriptionData();
        SubscriptionData other$subscriptionData = other.getSubscriptionData();
        if (this$subscriptionData == null ? other$subscriptionData != null : !((Object)this$subscriptionData).equals(other$subscriptionData)) {
            return false;
        }
        TaxIdCollection this$taxIdCollection = this.getTaxIdCollection();
        TaxIdCollection other$taxIdCollection = other.getTaxIdCollection();
        if (this$taxIdCollection == null ? other$taxIdCollection != null : !((Object)this$taxIdCollection).equals(other$taxIdCollection)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentLink;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $allowPromotionCodes = this.getAllowPromotionCodes();
        result = result * 59 + ($allowPromotionCodes == null ? 43 : ((Object)$allowPromotionCodes).hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AfterCompletion $afterCompletion = this.getAfterCompletion();
        result = result * 59 + ($afterCompletion == null ? 43 : ((Object)$afterCompletion).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
        result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
        AutomaticTax $automaticTax = this.getAutomaticTax();
        result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
        String $billingAddressCollection = this.getBillingAddressCollection();
        result = result * 59 + ($billingAddressCollection == null ? 43 : $billingAddressCollection.hashCode());
        ConsentCollection $consentCollection = this.getConsentCollection();
        result = result * 59 + ($consentCollection == null ? 43 : ((Object)$consentCollection).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        List<CustomField> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        CustomText $customText = this.getCustomText();
        result = result * 59 + ($customText == null ? 43 : ((Object)$customText).hashCode());
        String $customerCreation = this.getCustomerCreation();
        result = result * 59 + ($customerCreation == null ? 43 : $customerCreation.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $inactiveMessage = this.getInactiveMessage();
        result = result * 59 + ($inactiveMessage == null ? 43 : $inactiveMessage.hashCode());
        InvoiceCreation $invoiceCreation = this.getInvoiceCreation();
        result = result * 59 + ($invoiceCreation == null ? 43 : ((Object)$invoiceCreation).hashCode());
        LineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        PaymentIntentData $paymentIntentData = this.getPaymentIntentData();
        result = result * 59 + ($paymentIntentData == null ? 43 : ((Object)$paymentIntentData).hashCode());
        String $paymentMethodCollection = this.getPaymentMethodCollection();
        result = result * 59 + ($paymentMethodCollection == null ? 43 : $paymentMethodCollection.hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        PhoneNumberCollection $phoneNumberCollection = this.getPhoneNumberCollection();
        result = result * 59 + ($phoneNumberCollection == null ? 43 : ((Object)$phoneNumberCollection).hashCode());
        Restrictions $restrictions = this.getRestrictions();
        result = result * 59 + ($restrictions == null ? 43 : ((Object)$restrictions).hashCode());
        ShippingAddressCollection $shippingAddressCollection = this.getShippingAddressCollection();
        result = result * 59 + ($shippingAddressCollection == null ? 43 : ((Object)$shippingAddressCollection).hashCode());
        List<ShippingOption> $shippingOptions = this.getShippingOptions();
        result = result * 59 + ($shippingOptions == null ? 43 : ((Object)$shippingOptions).hashCode());
        String $submitType = this.getSubmitType();
        result = result * 59 + ($submitType == null ? 43 : $submitType.hashCode());
        SubscriptionData $subscriptionData = this.getSubscriptionData();
        result = result * 59 + ($subscriptionData == null ? 43 : ((Object)$subscriptionData).hashCode());
        TaxIdCollection $taxIdCollection = this.getTaxIdCollection();
        result = result * 59 + ($taxIdCollection == null ? 43 : ((Object)$taxIdCollection).hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AfterCompletion
    extends StripeObject {
        @SerializedName(value="hosted_confirmation")
        HostedConfirmation hostedConfirmation;
        @SerializedName(value="redirect")
        Redirect redirect;
        @SerializedName(value="type")
        String type;

        @Generated
        public HostedConfirmation getHostedConfirmation() {
            return this.hostedConfirmation;
        }

        @Generated
        public Redirect getRedirect() {
            return this.redirect;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setHostedConfirmation(HostedConfirmation hostedConfirmation) {
            this.hostedConfirmation = hostedConfirmation;
        }

        @Generated
        public void setRedirect(Redirect redirect) {
            this.redirect = redirect;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AfterCompletion)) {
                return false;
            }
            AfterCompletion other = (AfterCompletion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            HostedConfirmation this$hostedConfirmation = this.getHostedConfirmation();
            HostedConfirmation other$hostedConfirmation = other.getHostedConfirmation();
            if (this$hostedConfirmation == null ? other$hostedConfirmation != null : !((Object)this$hostedConfirmation).equals(other$hostedConfirmation)) {
                return false;
            }
            Redirect this$redirect = this.getRedirect();
            Redirect other$redirect = other.getRedirect();
            if (this$redirect == null ? other$redirect != null : !((Object)this$redirect).equals(other$redirect)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AfterCompletion;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HostedConfirmation $hostedConfirmation = this.getHostedConfirmation();
            result = result * 59 + ($hostedConfirmation == null ? 43 : ((Object)$hostedConfirmation).hashCode());
            Redirect $redirect = this.getRedirect();
            result = result * 59 + ($redirect == null ? 43 : ((Object)$redirect).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class HostedConfirmation
        extends StripeObject {
            @SerializedName(value="custom_message")
            String customMessage;

            @Generated
            public String getCustomMessage() {
                return this.customMessage;
            }

            @Generated
            public void setCustomMessage(String customMessage) {
                this.customMessage = customMessage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HostedConfirmation)) {
                    return false;
                }
                HostedConfirmation other = (HostedConfirmation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$customMessage = this.getCustomMessage();
                String other$customMessage = other.getCustomMessage();
                return !(this$customMessage == null ? other$customMessage != null : !this$customMessage.equals(other$customMessage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof HostedConfirmation;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $customMessage = this.getCustomMessage();
                result = result * 59 + ($customMessage == null ? 43 : $customMessage.hashCode());
                return result;
            }
        }

        public static class Redirect
        extends StripeObject {
            @SerializedName(value="url")
            String url;

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Redirect)) {
                    return false;
                }
                Redirect other = (Redirect)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Redirect;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }
    }

    public static class AutomaticTax
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="liability")
        Liability liability;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Liability getLiability() {
            return this.liability;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setLiability(Liability liability) {
            this.liability = liability;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticTax)) {
                return false;
            }
            AutomaticTax other = (AutomaticTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            Liability this$liability = this.getLiability();
            Liability other$liability = other.getLiability();
            return !(this$liability == null ? other$liability != null : !((Object)this$liability).equals(other$liability));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticTax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            Liability $liability = this.getLiability();
            result = result * 59 + ($liability == null ? 43 : ((Object)$liability).hashCode());
            return result;
        }

        public static class Liability
        extends StripeObject {
            @SerializedName(value="account")
            ExpandableField<Account> account;
            @SerializedName(value="type")
            String type;

            public String getAccount() {
                return this.account != null ? this.account.getId() : null;
            }

            public void setAccount(String id) {
                this.account = ApiResource.setExpandableFieldId(id, this.account);
            }

            public Account getAccountObject() {
                return this.account != null ? this.account.getExpanded() : null;
            }

            public void setAccountObject(Account expandableObject) {
                this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Liability)) {
                    return false;
                }
                Liability other = (Liability)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$account = this.getAccount();
                String other$account = other.getAccount();
                if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Liability;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $account = this.getAccount();
                result = result * 59 + ($account == null ? 43 : $account.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }
    }

    public static class ConsentCollection
    extends StripeObject {
        @SerializedName(value="payment_method_reuse_agreement")
        PaymentMethodReuseAgreement paymentMethodReuseAgreement;
        @SerializedName(value="promotions")
        String promotions;
        @SerializedName(value="terms_of_service")
        String termsOfService;

        @Generated
        public PaymentMethodReuseAgreement getPaymentMethodReuseAgreement() {
            return this.paymentMethodReuseAgreement;
        }

        @Generated
        public String getPromotions() {
            return this.promotions;
        }

        @Generated
        public String getTermsOfService() {
            return this.termsOfService;
        }

        @Generated
        public void setPaymentMethodReuseAgreement(PaymentMethodReuseAgreement paymentMethodReuseAgreement) {
            this.paymentMethodReuseAgreement = paymentMethodReuseAgreement;
        }

        @Generated
        public void setPromotions(String promotions) {
            this.promotions = promotions;
        }

        @Generated
        public void setTermsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsentCollection)) {
                return false;
            }
            ConsentCollection other = (ConsentCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PaymentMethodReuseAgreement this$paymentMethodReuseAgreement = this.getPaymentMethodReuseAgreement();
            PaymentMethodReuseAgreement other$paymentMethodReuseAgreement = other.getPaymentMethodReuseAgreement();
            if (this$paymentMethodReuseAgreement == null ? other$paymentMethodReuseAgreement != null : !((Object)this$paymentMethodReuseAgreement).equals(other$paymentMethodReuseAgreement)) {
                return false;
            }
            String this$promotions = this.getPromotions();
            String other$promotions = other.getPromotions();
            if (this$promotions == null ? other$promotions != null : !this$promotions.equals(other$promotions)) {
                return false;
            }
            String this$termsOfService = this.getTermsOfService();
            String other$termsOfService = other.getTermsOfService();
            return !(this$termsOfService == null ? other$termsOfService != null : !this$termsOfService.equals(other$termsOfService));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConsentCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PaymentMethodReuseAgreement $paymentMethodReuseAgreement = this.getPaymentMethodReuseAgreement();
            result = result * 59 + ($paymentMethodReuseAgreement == null ? 43 : ((Object)$paymentMethodReuseAgreement).hashCode());
            String $promotions = this.getPromotions();
            result = result * 59 + ($promotions == null ? 43 : $promotions.hashCode());
            String $termsOfService = this.getTermsOfService();
            result = result * 59 + ($termsOfService == null ? 43 : $termsOfService.hashCode());
            return result;
        }

        public static class PaymentMethodReuseAgreement
        extends StripeObject {
            @SerializedName(value="position")
            String position;

            @Generated
            public String getPosition() {
                return this.position;
            }

            @Generated
            public void setPosition(String position) {
                this.position = position;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaymentMethodReuseAgreement)) {
                    return false;
                }
                PaymentMethodReuseAgreement other = (PaymentMethodReuseAgreement)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$position = this.getPosition();
                String other$position = other.getPosition();
                return !(this$position == null ? other$position != null : !this$position.equals(other$position));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaymentMethodReuseAgreement;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $position = this.getPosition();
                result = result * 59 + ($position == null ? 43 : $position.hashCode());
                return result;
            }
        }
    }

    public static class CustomText
    extends StripeObject {
        @SerializedName(value="after_submit")
        AfterSubmit afterSubmit;
        @SerializedName(value="shipping_address")
        ShippingAddress shippingAddress;
        @SerializedName(value="submit")
        Submit submit;
        @SerializedName(value="terms_of_service_acceptance")
        TermsOfServiceAcceptance termsOfServiceAcceptance;

        @Generated
        public AfterSubmit getAfterSubmit() {
            return this.afterSubmit;
        }

        @Generated
        public ShippingAddress getShippingAddress() {
            return this.shippingAddress;
        }

        @Generated
        public Submit getSubmit() {
            return this.submit;
        }

        @Generated
        public TermsOfServiceAcceptance getTermsOfServiceAcceptance() {
            return this.termsOfServiceAcceptance;
        }

        @Generated
        public void setAfterSubmit(AfterSubmit afterSubmit) {
            this.afterSubmit = afterSubmit;
        }

        @Generated
        public void setShippingAddress(ShippingAddress shippingAddress) {
            this.shippingAddress = shippingAddress;
        }

        @Generated
        public void setSubmit(Submit submit) {
            this.submit = submit;
        }

        @Generated
        public void setTermsOfServiceAcceptance(TermsOfServiceAcceptance termsOfServiceAcceptance) {
            this.termsOfServiceAcceptance = termsOfServiceAcceptance;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomText)) {
                return false;
            }
            CustomText other = (CustomText)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AfterSubmit this$afterSubmit = this.getAfterSubmit();
            AfterSubmit other$afterSubmit = other.getAfterSubmit();
            if (this$afterSubmit == null ? other$afterSubmit != null : !((Object)this$afterSubmit).equals(other$afterSubmit)) {
                return false;
            }
            ShippingAddress this$shippingAddress = this.getShippingAddress();
            ShippingAddress other$shippingAddress = other.getShippingAddress();
            if (this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress)) {
                return false;
            }
            Submit this$submit = this.getSubmit();
            Submit other$submit = other.getSubmit();
            if (this$submit == null ? other$submit != null : !((Object)this$submit).equals(other$submit)) {
                return false;
            }
            TermsOfServiceAcceptance this$termsOfServiceAcceptance = this.getTermsOfServiceAcceptance();
            TermsOfServiceAcceptance other$termsOfServiceAcceptance = other.getTermsOfServiceAcceptance();
            return !(this$termsOfServiceAcceptance == null ? other$termsOfServiceAcceptance != null : !((Object)this$termsOfServiceAcceptance).equals(other$termsOfServiceAcceptance));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomText;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AfterSubmit $afterSubmit = this.getAfterSubmit();
            result = result * 59 + ($afterSubmit == null ? 43 : ((Object)$afterSubmit).hashCode());
            ShippingAddress $shippingAddress = this.getShippingAddress();
            result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
            Submit $submit = this.getSubmit();
            result = result * 59 + ($submit == null ? 43 : ((Object)$submit).hashCode());
            TermsOfServiceAcceptance $termsOfServiceAcceptance = this.getTermsOfServiceAcceptance();
            result = result * 59 + ($termsOfServiceAcceptance == null ? 43 : ((Object)$termsOfServiceAcceptance).hashCode());
            return result;
        }

        public static class AfterSubmit
        extends StripeObject {
            @SerializedName(value="message")
            String message;

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public void setMessage(String message) {
                this.message = message;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AfterSubmit)) {
                    return false;
                }
                AfterSubmit other = (AfterSubmit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AfterSubmit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }
        }

        public static class ShippingAddress
        extends StripeObject {
            @SerializedName(value="message")
            String message;

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public void setMessage(String message) {
                this.message = message;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ShippingAddress)) {
                    return false;
                }
                ShippingAddress other = (ShippingAddress)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ShippingAddress;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }
        }

        public static class Submit
        extends StripeObject {
            @SerializedName(value="message")
            String message;

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public void setMessage(String message) {
                this.message = message;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Submit)) {
                    return false;
                }
                Submit other = (Submit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Submit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }
        }

        public static class TermsOfServiceAcceptance
        extends StripeObject {
            @SerializedName(value="message")
            String message;

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public void setMessage(String message) {
                this.message = message;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TermsOfServiceAcceptance)) {
                    return false;
                }
                TermsOfServiceAcceptance other = (TermsOfServiceAcceptance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TermsOfServiceAcceptance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }
        }
    }

    public static class InvoiceCreation
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="invoice_data")
        InvoiceData invoiceData;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public InvoiceData getInvoiceData() {
            return this.invoiceData;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setInvoiceData(InvoiceData invoiceData) {
            this.invoiceData = invoiceData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceCreation)) {
                return false;
            }
            InvoiceCreation other = (InvoiceCreation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            InvoiceData this$invoiceData = this.getInvoiceData();
            InvoiceData other$invoiceData = other.getInvoiceData();
            return !(this$invoiceData == null ? other$invoiceData != null : !((Object)this$invoiceData).equals(other$invoiceData));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InvoiceCreation;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            InvoiceData $invoiceData = this.getInvoiceData();
            result = result * 59 + ($invoiceData == null ? 43 : ((Object)$invoiceData).hashCode());
            return result;
        }

        public static class InvoiceData
        extends StripeObject {
            @SerializedName(value="account_tax_ids")
            List<ExpandableField<TaxId>> accountTaxIds;
            @SerializedName(value="custom_fields")
            List<CustomField> customFields;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="footer")
            String footer;
            @SerializedName(value="issuer")
            Issuer issuer;
            @SerializedName(value="metadata")
            Map<String, String> metadata;
            @SerializedName(value="rendering_options")
            RenderingOptions renderingOptions;

            public List<String> getAccountTaxIds() {
                return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
            }

            public void setAccountTaxIds(List<String> ids) {
                if (ids == null) {
                    this.accountTaxIds = null;
                    return;
                }
                if (this.accountTaxIds != null && this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
                    return;
                }
                this.accountTaxIds = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
            }

            public List<TaxId> getAccountTaxIdObjects() {
                return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> (TaxId)x.getExpanded()).collect(Collectors.toList()) : null;
            }

            public void setAccountTaxIdObjects(List<TaxId> objs) {
                this.accountTaxIds = objs != null ? objs.stream().map(x -> new ExpandableField<TaxId>(x.getId(), (TaxId)x)).collect(Collectors.toList()) : null;
            }

            @Generated
            public List<CustomField> getCustomFields() {
                return this.customFields;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public String getFooter() {
                return this.footer;
            }

            @Generated
            public Issuer getIssuer() {
                return this.issuer;
            }

            @Generated
            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            @Generated
            public RenderingOptions getRenderingOptions() {
                return this.renderingOptions;
            }

            @Generated
            public void setCustomFields(List<CustomField> customFields) {
                this.customFields = customFields;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setFooter(String footer) {
                this.footer = footer;
            }

            @Generated
            public void setIssuer(Issuer issuer) {
                this.issuer = issuer;
            }

            @Generated
            public void setMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
            }

            @Generated
            public void setRenderingOptions(RenderingOptions renderingOptions) {
                this.renderingOptions = renderingOptions;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvoiceData)) {
                    return false;
                }
                InvoiceData other = (InvoiceData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$accountTaxIds = this.getAccountTaxIds();
                List<String> other$accountTaxIds = other.getAccountTaxIds();
                if (this$accountTaxIds == null ? other$accountTaxIds != null : !((Object)this$accountTaxIds).equals(other$accountTaxIds)) {
                    return false;
                }
                List<CustomField> this$customFields = this.getCustomFields();
                List<CustomField> other$customFields = other.getCustomFields();
                if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$footer = this.getFooter();
                String other$footer = other.getFooter();
                if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
                    return false;
                }
                Issuer this$issuer = this.getIssuer();
                Issuer other$issuer = other.getIssuer();
                if (this$issuer == null ? other$issuer != null : !((Object)this$issuer).equals(other$issuer)) {
                    return false;
                }
                Map<String, String> this$metadata = this.getMetadata();
                Map<String, String> other$metadata = other.getMetadata();
                if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                    return false;
                }
                RenderingOptions this$renderingOptions = this.getRenderingOptions();
                RenderingOptions other$renderingOptions = other.getRenderingOptions();
                return !(this$renderingOptions == null ? other$renderingOptions != null : !((Object)this$renderingOptions).equals(other$renderingOptions));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InvoiceData;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $accountTaxIds = this.getAccountTaxIds();
                result = result * 59 + ($accountTaxIds == null ? 43 : ((Object)$accountTaxIds).hashCode());
                List<CustomField> $customFields = this.getCustomFields();
                result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $footer = this.getFooter();
                result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
                Issuer $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : ((Object)$issuer).hashCode());
                Map<String, String> $metadata = this.getMetadata();
                result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
                RenderingOptions $renderingOptions = this.getRenderingOptions();
                result = result * 59 + ($renderingOptions == null ? 43 : ((Object)$renderingOptions).hashCode());
                return result;
            }

            public static class Issuer
            extends StripeObject {
                @SerializedName(value="account")
                ExpandableField<Account> account;
                @SerializedName(value="type")
                String type;

                public String getAccount() {
                    return this.account != null ? this.account.getId() : null;
                }

                public void setAccount(String id) {
                    this.account = ApiResource.setExpandableFieldId(id, this.account);
                }

                public Account getAccountObject() {
                    return this.account != null ? this.account.getExpanded() : null;
                }

                public void setAccountObject(Account expandableObject) {
                    this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Issuer)) {
                        return false;
                    }
                    Issuer other = (Issuer)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$account = this.getAccount();
                    String other$account = other.getAccount();
                    if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Issuer;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $account = this.getAccount();
                    result = result * 59 + ($account == null ? 43 : $account.hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }

            public static class RenderingOptions
            extends StripeObject {
                @SerializedName(value="amount_tax_display")
                String amountTaxDisplay;

                @Generated
                public String getAmountTaxDisplay() {
                    return this.amountTaxDisplay;
                }

                @Generated
                public void setAmountTaxDisplay(String amountTaxDisplay) {
                    this.amountTaxDisplay = amountTaxDisplay;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RenderingOptions)) {
                        return false;
                    }
                    RenderingOptions other = (RenderingOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$amountTaxDisplay = this.getAmountTaxDisplay();
                    String other$amountTaxDisplay = other.getAmountTaxDisplay();
                    return !(this$amountTaxDisplay == null ? other$amountTaxDisplay != null : !this$amountTaxDisplay.equals(other$amountTaxDisplay));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof RenderingOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $amountTaxDisplay = this.getAmountTaxDisplay();
                    result = result * 59 + ($amountTaxDisplay == null ? 43 : $amountTaxDisplay.hashCode());
                    return result;
                }
            }

            public static class CustomField
            extends StripeObject {
                @SerializedName(value="name")
                String name;
                @SerializedName(value="value")
                String value;

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public String getValue() {
                    return this.value;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setValue(String value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CustomField)) {
                        return false;
                    }
                    CustomField other = (CustomField)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    String this$value = this.getValue();
                    String other$value = other.getValue();
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CustomField;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    String $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }
            }
        }
    }

    public static class PaymentIntentData
    extends StripeObject {
        @SerializedName(value="capture_method")
        String captureMethod;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="setup_future_usage")
        String setupFutureUsage;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;
        @SerializedName(value="statement_descriptor_suffix")
        String statementDescriptorSuffix;
        @SerializedName(value="transfer_group")
        String transferGroup;

        @Generated
        public String getCaptureMethod() {
            return this.captureMethod;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getSetupFutureUsage() {
            return this.setupFutureUsage;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public String getStatementDescriptorSuffix() {
            return this.statementDescriptorSuffix;
        }

        @Generated
        public String getTransferGroup() {
            return this.transferGroup;
        }

        @Generated
        public void setCaptureMethod(String captureMethod) {
            this.captureMethod = captureMethod;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        @Generated
        public void setSetupFutureUsage(String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public void setStatementDescriptorSuffix(String statementDescriptorSuffix) {
            this.statementDescriptorSuffix = statementDescriptorSuffix;
        }

        @Generated
        public void setTransferGroup(String transferGroup) {
            this.transferGroup = transferGroup;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentIntentData)) {
                return false;
            }
            PaymentIntentData other = (PaymentIntentData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$captureMethod = this.getCaptureMethod();
            String other$captureMethod = other.getCaptureMethod();
            if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            String this$setupFutureUsage = this.getSetupFutureUsage();
            String other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
                return false;
            }
            String this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
            String other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
            if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) {
                return false;
            }
            String this$transferGroup = this.getTransferGroup();
            String other$transferGroup = other.getTransferGroup();
            return !(this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentIntentData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $captureMethod = this.getCaptureMethod();
            result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            String $setupFutureUsage = this.getSetupFutureUsage();
            result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            String $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
            result = result * 59 + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
            String $transferGroup = this.getTransferGroup();
            result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
            return result;
        }
    }

    public static class PhoneNumberCollection
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhoneNumberCollection)) {
                return false;
            }
            PhoneNumberCollection other = (PhoneNumberCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PhoneNumberCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class Restrictions
    extends StripeObject {
        @SerializedName(value="completed_sessions")
        CompletedSessions completedSessions;

        @Generated
        public CompletedSessions getCompletedSessions() {
            return this.completedSessions;
        }

        @Generated
        public void setCompletedSessions(CompletedSessions completedSessions) {
            this.completedSessions = completedSessions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Restrictions)) {
                return false;
            }
            Restrictions other = (Restrictions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CompletedSessions this$completedSessions = this.getCompletedSessions();
            CompletedSessions other$completedSessions = other.getCompletedSessions();
            return !(this$completedSessions == null ? other$completedSessions != null : !((Object)this$completedSessions).equals(other$completedSessions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Restrictions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompletedSessions $completedSessions = this.getCompletedSessions();
            result = result * 59 + ($completedSessions == null ? 43 : ((Object)$completedSessions).hashCode());
            return result;
        }

        public static class CompletedSessions
        extends StripeObject {
            @SerializedName(value="count")
            Long count;
            @SerializedName(value="limit")
            Long limit;

            @Generated
            public Long getCount() {
                return this.count;
            }

            @Generated
            public Long getLimit() {
                return this.limit;
            }

            @Generated
            public void setCount(Long count) {
                this.count = count;
            }

            @Generated
            public void setLimit(Long limit) {
                this.limit = limit;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CompletedSessions)) {
                    return false;
                }
                CompletedSessions other = (CompletedSessions)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$count = this.getCount();
                Long other$count = other.getCount();
                if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                    return false;
                }
                Long this$limit = this.getLimit();
                Long other$limit = other.getLimit();
                return !(this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CompletedSessions;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $count = this.getCount();
                result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
                Long $limit = this.getLimit();
                result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
                return result;
            }
        }
    }

    public static class ShippingAddressCollection
    extends StripeObject {
        @SerializedName(value="allowed_countries")
        List<String> allowedCountries;

        @Generated
        public List<String> getAllowedCountries() {
            return this.allowedCountries;
        }

        @Generated
        public void setAllowedCountries(List<String> allowedCountries) {
            this.allowedCountries = allowedCountries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingAddressCollection)) {
                return false;
            }
            ShippingAddressCollection other = (ShippingAddressCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allowedCountries = this.getAllowedCountries();
            List<String> other$allowedCountries = other.getAllowedCountries();
            return !(this$allowedCountries == null ? other$allowedCountries != null : !((Object)this$allowedCountries).equals(other$allowedCountries));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingAddressCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allowedCountries = this.getAllowedCountries();
            result = result * 59 + ($allowedCountries == null ? 43 : ((Object)$allowedCountries).hashCode());
            return result;
        }
    }

    public static class SubscriptionData
    extends StripeObject {
        @SerializedName(value="description")
        String description;
        @SerializedName(value="invoice_settings")
        InvoiceSettings invoiceSettings;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="trial_period_days")
        Long trialPeriodDays;
        @SerializedName(value="trial_settings")
        TrialSettings trialSettings;

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public InvoiceSettings getInvoiceSettings() {
            return this.invoiceSettings;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public Long getTrialPeriodDays() {
            return this.trialPeriodDays;
        }

        @Generated
        public TrialSettings getTrialSettings() {
            return this.trialSettings;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
            this.invoiceSettings = invoiceSettings;
        }

        @Generated
        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        @Generated
        public void setTrialPeriodDays(Long trialPeriodDays) {
            this.trialPeriodDays = trialPeriodDays;
        }

        @Generated
        public void setTrialSettings(TrialSettings trialSettings) {
            this.trialSettings = trialSettings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionData)) {
                return false;
            }
            SubscriptionData other = (SubscriptionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$trialPeriodDays = this.getTrialPeriodDays();
            Long other$trialPeriodDays = other.getTrialPeriodDays();
            if (this$trialPeriodDays == null ? other$trialPeriodDays != null : !((Object)this$trialPeriodDays).equals(other$trialPeriodDays)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
            InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
            if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            TrialSettings this$trialSettings = this.getTrialSettings();
            TrialSettings other$trialSettings = other.getTrialSettings();
            return !(this$trialSettings == null ? other$trialSettings != null : !((Object)this$trialSettings).equals(other$trialSettings));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubscriptionData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $trialPeriodDays = this.getTrialPeriodDays();
            result = result * 59 + ($trialPeriodDays == null ? 43 : ((Object)$trialPeriodDays).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
            result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            TrialSettings $trialSettings = this.getTrialSettings();
            result = result * 59 + ($trialSettings == null ? 43 : ((Object)$trialSettings).hashCode());
            return result;
        }

        public static class InvoiceSettings
        extends StripeObject {
            @SerializedName(value="issuer")
            Issuer issuer;

            @Generated
            public Issuer getIssuer() {
                return this.issuer;
            }

            @Generated
            public void setIssuer(Issuer issuer) {
                this.issuer = issuer;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvoiceSettings)) {
                    return false;
                }
                InvoiceSettings other = (InvoiceSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Issuer this$issuer = this.getIssuer();
                Issuer other$issuer = other.getIssuer();
                return !(this$issuer == null ? other$issuer != null : !((Object)this$issuer).equals(other$issuer));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InvoiceSettings;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Issuer $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : ((Object)$issuer).hashCode());
                return result;
            }

            public static class Issuer
            extends StripeObject {
                @SerializedName(value="account")
                ExpandableField<Account> account;
                @SerializedName(value="type")
                String type;

                public String getAccount() {
                    return this.account != null ? this.account.getId() : null;
                }

                public void setAccount(String id) {
                    this.account = ApiResource.setExpandableFieldId(id, this.account);
                }

                public Account getAccountObject() {
                    return this.account != null ? this.account.getExpanded() : null;
                }

                public void setAccountObject(Account expandableObject) {
                    this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Issuer)) {
                        return false;
                    }
                    Issuer other = (Issuer)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$account = this.getAccount();
                    String other$account = other.getAccount();
                    if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Issuer;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $account = this.getAccount();
                    result = result * 59 + ($account == null ? 43 : $account.hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class TrialSettings
        extends StripeObject {
            @SerializedName(value="end_behavior")
            EndBehavior endBehavior;

            @Generated
            public EndBehavior getEndBehavior() {
                return this.endBehavior;
            }

            @Generated
            public void setEndBehavior(EndBehavior endBehavior) {
                this.endBehavior = endBehavior;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TrialSettings)) {
                    return false;
                }
                TrialSettings other = (TrialSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                EndBehavior this$endBehavior = this.getEndBehavior();
                EndBehavior other$endBehavior = other.getEndBehavior();
                return !(this$endBehavior == null ? other$endBehavior != null : !((Object)this$endBehavior).equals(other$endBehavior));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TrialSettings;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                EndBehavior $endBehavior = this.getEndBehavior();
                result = result * 59 + ($endBehavior == null ? 43 : ((Object)$endBehavior).hashCode());
                return result;
            }

            public static class EndBehavior
            extends StripeObject {
                @SerializedName(value="missing_payment_method")
                String missingPaymentMethod;

                @Generated
                public String getMissingPaymentMethod() {
                    return this.missingPaymentMethod;
                }

                @Generated
                public void setMissingPaymentMethod(String missingPaymentMethod) {
                    this.missingPaymentMethod = missingPaymentMethod;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof EndBehavior)) {
                        return false;
                    }
                    EndBehavior other = (EndBehavior)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$missingPaymentMethod = this.getMissingPaymentMethod();
                    String other$missingPaymentMethod = other.getMissingPaymentMethod();
                    return !(this$missingPaymentMethod == null ? other$missingPaymentMethod != null : !this$missingPaymentMethod.equals(other$missingPaymentMethod));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof EndBehavior;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $missingPaymentMethod = this.getMissingPaymentMethod();
                    result = result * 59 + ($missingPaymentMethod == null ? 43 : $missingPaymentMethod.hashCode());
                    return result;
                }
            }
        }
    }

    public static class TaxIdCollection
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxIdCollection)) {
                return false;
            }
            TaxIdCollection other = (TaxIdCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxIdCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }

    public static class ShippingOption
    extends StripeObject {
        @SerializedName(value="shipping_amount")
        Long shippingAmount;
        @SerializedName(value="shipping_rate")
        ExpandableField<ShippingRate> shippingRate;

        public String getShippingRate() {
            return this.shippingRate != null ? this.shippingRate.getId() : null;
        }

        public void setShippingRate(String id) {
            this.shippingRate = ApiResource.setExpandableFieldId(id, this.shippingRate);
        }

        public ShippingRate getShippingRateObject() {
            return this.shippingRate != null ? this.shippingRate.getExpanded() : null;
        }

        public void setShippingRateObject(ShippingRate expandableObject) {
            this.shippingRate = new ExpandableField<ShippingRate>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getShippingAmount() {
            return this.shippingAmount;
        }

        @Generated
        public void setShippingAmount(Long shippingAmount) {
            this.shippingAmount = shippingAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingOption)) {
                return false;
            }
            ShippingOption other = (ShippingOption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$shippingAmount = this.getShippingAmount();
            Long other$shippingAmount = other.getShippingAmount();
            if (this$shippingAmount == null ? other$shippingAmount != null : !((Object)this$shippingAmount).equals(other$shippingAmount)) {
                return false;
            }
            String this$shippingRate = this.getShippingRate();
            String other$shippingRate = other.getShippingRate();
            return !(this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingOption;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $shippingAmount = this.getShippingAmount();
            result = result * 59 + ($shippingAmount == null ? 43 : ((Object)$shippingAmount).hashCode());
            String $shippingRate = this.getShippingRate();
            result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
            return result;
        }
    }

    public static class CustomField
    extends StripeObject {
        @SerializedName(value="dropdown")
        Dropdown dropdown;
        @SerializedName(value="key")
        String key;
        @SerializedName(value="label")
        Label label;
        @SerializedName(value="numeric")
        Numeric numeric;
        @SerializedName(value="optional")
        Boolean optional;
        @SerializedName(value="text")
        Text text;
        @SerializedName(value="type")
        String type;

        @Generated
        public Dropdown getDropdown() {
            return this.dropdown;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public Label getLabel() {
            return this.label;
        }

        @Generated
        public Numeric getNumeric() {
            return this.numeric;
        }

        @Generated
        public Boolean getOptional() {
            return this.optional;
        }

        @Generated
        public Text getText() {
            return this.text;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setDropdown(Dropdown dropdown) {
            this.dropdown = dropdown;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setLabel(Label label) {
            this.label = label;
        }

        @Generated
        public void setNumeric(Numeric numeric) {
            this.numeric = numeric;
        }

        @Generated
        public void setOptional(Boolean optional) {
            this.optional = optional;
        }

        @Generated
        public void setText(Text text) {
            this.text = text;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomField)) {
                return false;
            }
            CustomField other = (CustomField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$optional = this.getOptional();
            Boolean other$optional = other.getOptional();
            if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
                return false;
            }
            Dropdown this$dropdown = this.getDropdown();
            Dropdown other$dropdown = other.getDropdown();
            if (this$dropdown == null ? other$dropdown != null : !((Object)this$dropdown).equals(other$dropdown)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Label this$label = this.getLabel();
            Label other$label = other.getLabel();
            if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
                return false;
            }
            Numeric this$numeric = this.getNumeric();
            Numeric other$numeric = other.getNumeric();
            if (this$numeric == null ? other$numeric != null : !((Object)this$numeric).equals(other$numeric)) {
                return false;
            }
            Text this$text = this.getText();
            Text other$text = other.getText();
            if (this$text == null ? other$text != null : !((Object)this$text).equals(other$text)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomField;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $optional = this.getOptional();
            result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
            Dropdown $dropdown = this.getDropdown();
            result = result * 59 + ($dropdown == null ? 43 : ((Object)$dropdown).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Label $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
            Numeric $numeric = this.getNumeric();
            result = result * 59 + ($numeric == null ? 43 : ((Object)$numeric).hashCode());
            Text $text = this.getText();
            result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Dropdown
        extends StripeObject {
            @SerializedName(value="options")
            List<Option> options;

            @Generated
            public List<Option> getOptions() {
                return this.options;
            }

            @Generated
            public void setOptions(List<Option> options) {
                this.options = options;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dropdown)) {
                    return false;
                }
                Dropdown other = (Dropdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Option> this$options = this.getOptions();
                List<Option> other$options = other.getOptions();
                return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dropdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Option> $options = this.getOptions();
                result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
                return result;
            }

            public static class Option
            extends StripeObject {
                @SerializedName(value="label")
                String label;
                @SerializedName(value="value")
                String value;

                @Generated
                public String getLabel() {
                    return this.label;
                }

                @Generated
                public String getValue() {
                    return this.value;
                }

                @Generated
                public void setLabel(String label) {
                    this.label = label;
                }

                @Generated
                public void setValue(String value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Option)) {
                        return false;
                    }
                    Option other = (Option)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$label = this.getLabel();
                    String other$label = other.getLabel();
                    if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                        return false;
                    }
                    String this$value = this.getValue();
                    String other$value = other.getValue();
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Option;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $label = this.getLabel();
                    result = result * 59 + ($label == null ? 43 : $label.hashCode());
                    String $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }
            }
        }

        public static class Label
        extends StripeObject {
            @SerializedName(value="custom")
            String custom;
            @SerializedName(value="type")
            String type;

            @Generated
            public String getCustom() {
                return this.custom;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setCustom(String custom) {
                this.custom = custom;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Label)) {
                    return false;
                }
                Label other = (Label)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$custom = this.getCustom();
                String other$custom = other.getCustom();
                if (this$custom == null ? other$custom != null : !this$custom.equals(other$custom)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Label;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $custom = this.getCustom();
                result = result * 59 + ($custom == null ? 43 : $custom.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Numeric
        extends StripeObject {
            @SerializedName(value="maximum_length")
            Long maximumLength;
            @SerializedName(value="minimum_length")
            Long minimumLength;

            @Generated
            public Long getMaximumLength() {
                return this.maximumLength;
            }

            @Generated
            public Long getMinimumLength() {
                return this.minimumLength;
            }

            @Generated
            public void setMaximumLength(Long maximumLength) {
                this.maximumLength = maximumLength;
            }

            @Generated
            public void setMinimumLength(Long minimumLength) {
                this.minimumLength = minimumLength;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Numeric)) {
                    return false;
                }
                Numeric other = (Numeric)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$maximumLength = this.getMaximumLength();
                Long other$maximumLength = other.getMaximumLength();
                if (this$maximumLength == null ? other$maximumLength != null : !((Object)this$maximumLength).equals(other$maximumLength)) {
                    return false;
                }
                Long this$minimumLength = this.getMinimumLength();
                Long other$minimumLength = other.getMinimumLength();
                return !(this$minimumLength == null ? other$minimumLength != null : !((Object)this$minimumLength).equals(other$minimumLength));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Numeric;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $maximumLength = this.getMaximumLength();
                result = result * 59 + ($maximumLength == null ? 43 : ((Object)$maximumLength).hashCode());
                Long $minimumLength = this.getMinimumLength();
                result = result * 59 + ($minimumLength == null ? 43 : ((Object)$minimumLength).hashCode());
                return result;
            }
        }

        public static class Text
        extends StripeObject {
            @SerializedName(value="maximum_length")
            Long maximumLength;
            @SerializedName(value="minimum_length")
            Long minimumLength;

            @Generated
            public Long getMaximumLength() {
                return this.maximumLength;
            }

            @Generated
            public Long getMinimumLength() {
                return this.minimumLength;
            }

            @Generated
            public void setMaximumLength(Long maximumLength) {
                this.maximumLength = maximumLength;
            }

            @Generated
            public void setMinimumLength(Long minimumLength) {
                this.minimumLength = minimumLength;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Text)) {
                    return false;
                }
                Text other = (Text)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$maximumLength = this.getMaximumLength();
                Long other$maximumLength = other.getMaximumLength();
                if (this$maximumLength == null ? other$maximumLength != null : !((Object)this$maximumLength).equals(other$maximumLength)) {
                    return false;
                }
                Long this$minimumLength = this.getMinimumLength();
                Long other$minimumLength = other.getMinimumLength();
                return !(this$minimumLength == null ? other$minimumLength != null : !((Object)this$minimumLength).equals(other$minimumLength));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Text;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $maximumLength = this.getMaximumLength();
                result = result * 59 + ($maximumLength == null ? 43 : ((Object)$maximumLength).hashCode());
                Long $minimumLength = this.getMinimumLength();
                result = result * 59 + ($minimumLength == null ? 43 : ((Object)$minimumLength).hashCode());
                return result;
            }
        }
    }
}

