/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Charge;
import com.stripe.model.StripeCollection;
import com.stripe.model.StripeSearchResult;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ChargeCaptureParams;
import com.stripe.param.ChargeCreateParams;
import com.stripe.param.ChargeListParams;
import com.stripe.param.ChargeRetrieveParams;
import com.stripe.param.ChargeSearchParams;
import com.stripe.param.ChargeUpdateParams;
import java.lang.reflect.Type;

public final class ChargeService
extends ApiService {
    public ChargeService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeSearchResult<Charge> search(ChargeSearchParams params) throws StripeException {
        return this.search(params, null);
    }

    public StripeSearchResult<Charge> search(ChargeSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/charges/search";
        return (StripeSearchResult)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeSearchResult<Charge>>(){}.getType(), options, ApiMode.V1);
    }

    public StripeCollection<Charge> list(ChargeListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Charge> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Charge> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Charge> list(ChargeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/charges";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Charge>>(){}.getType(), options, ApiMode.V1);
    }

    public Charge create(ChargeCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Charge create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Charge create() throws StripeException {
        return this.create(null, null);
    }

    public Charge create(ChargeCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/charges";
        return (Charge)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Charge.class), options, ApiMode.V1);
    }

    public Charge retrieve(String charge, ChargeRetrieveParams params) throws StripeException {
        return this.retrieve(charge, params, null);
    }

    public Charge retrieve(String charge, RequestOptions options) throws StripeException {
        return this.retrieve(charge, null, options);
    }

    public Charge retrieve(String charge) throws StripeException {
        return this.retrieve(charge, null, null);
    }

    public Charge retrieve(String charge, ChargeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/charges/%s", ApiResource.urlEncodeId(charge));
        return (Charge)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Charge.class), options, ApiMode.V1);
    }

    public Charge update(String charge, ChargeUpdateParams params) throws StripeException {
        return this.update(charge, params, null);
    }

    public Charge update(String charge, RequestOptions options) throws StripeException {
        return this.update(charge, null, options);
    }

    public Charge update(String charge) throws StripeException {
        return this.update(charge, null, null);
    }

    public Charge update(String charge, ChargeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/charges/%s", ApiResource.urlEncodeId(charge));
        return (Charge)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Charge.class), options, ApiMode.V1);
    }

    public Charge capture(String charge, ChargeCaptureParams params) throws StripeException {
        return this.capture(charge, params, null);
    }

    public Charge capture(String charge, RequestOptions options) throws StripeException {
        return this.capture(charge, null, options);
    }

    public Charge capture(String charge) throws StripeException {
        return this.capture(charge, null, null);
    }

    public Charge capture(String charge, ChargeCaptureParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/charges/%s/capture", ApiResource.urlEncodeId(charge));
        return (Charge)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Charge.class), options, ApiMode.V1);
    }
}

