/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.Charge;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntentCollection;
import com.stripe.model.PaymentIntentSearchResult;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentSource;
import com.stripe.model.Review;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeError;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentIntentApplyCustomerBalanceParams;
import com.stripe.param.PaymentIntentCancelParams;
import com.stripe.param.PaymentIntentCaptureParams;
import com.stripe.param.PaymentIntentConfirmParams;
import com.stripe.param.PaymentIntentCreateParams;
import com.stripe.param.PaymentIntentIncrementAuthorizationParams;
import com.stripe.param.PaymentIntentListParams;
import com.stripe.param.PaymentIntentRetrieveParams;
import com.stripe.param.PaymentIntentSearchParams;
import com.stripe.param.PaymentIntentUpdateParams;
import com.stripe.param.PaymentIntentVerifyMicrodepositsParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntent
extends ApiResource
implements HasId,
MetadataStore<PaymentIntent> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_capturable")
    Long amountCapturable;
    @SerializedName(value="amount_details")
    AmountDetails amountDetails;
    @SerializedName(value="amount_received")
    Long amountReceived;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="automatic_payment_methods")
    AutomaticPaymentMethods automaticPaymentMethods;
    @SerializedName(value="canceled_at")
    Long canceledAt;
    @SerializedName(value="cancellation_reason")
    String cancellationReason;
    @SerializedName(value="capture_method")
    String captureMethod;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="confirmation_method")
    String confirmationMethod;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="last_payment_error")
    StripeError lastPaymentError;
    @SerializedName(value="latest_charge")
    ExpandableField<Charge> latestCharge;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_action")
    NextAction nextAction;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="payment_method")
    ExpandableField<PaymentMethod> paymentMethod;
    @SerializedName(value="payment_method_configuration_details")
    PaymentMethodConfigurationDetails paymentMethodConfigurationDetails;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="processing")
    Processing processing;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="review")
    ExpandableField<Review> review;
    @SerializedName(value="setup_future_usage")
    String setupFutureUsage;
    @SerializedName(value="shipping")
    ShippingDetails shipping;
    @SerializedName(value="source")
    ExpandableField<PaymentSource> source;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    String statementDescriptorSuffix;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    String transferGroup;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getLatestCharge() {
        return this.latestCharge != null ? this.latestCharge.getId() : null;
    }

    public void setLatestCharge(String id) {
        this.latestCharge = ApiResource.setExpandableFieldId(id, this.latestCharge);
    }

    public Charge getLatestChargeObject() {
        return this.latestCharge != null ? this.latestCharge.getExpanded() : null;
    }

    public void setLatestChargeObject(Charge expandableObject) {
        this.latestCharge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentMethod() {
        return this.paymentMethod != null ? this.paymentMethod.getId() : null;
    }

    public void setPaymentMethod(String id) {
        this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
    }

    public PaymentMethod getPaymentMethodObject() {
        return this.paymentMethod != null ? this.paymentMethod.getExpanded() : null;
    }

    public void setPaymentMethodObject(PaymentMethod expandableObject) {
        this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getReview() {
        return this.review != null ? this.review.getId() : null;
    }

    public void setReview(String id) {
        this.review = ApiResource.setExpandableFieldId(id, this.review);
    }

    public Review getReviewObject() {
        return this.review != null ? this.review.getExpanded() : null;
    }

    public void setReviewObject(Review expandableObject) {
        this.review = new ExpandableField<Review>(expandableObject.getId(), expandableObject);
    }

    public String getSource() {
        return this.source != null ? this.source.getId() : null;
    }

    public void setSource(String id) {
        this.source = ApiResource.setExpandableFieldId(id, this.source);
    }

    public PaymentSource getSourceObject() {
        return this.source != null ? this.source.getExpanded() : null;
    }

    public void setSourceObject(PaymentSource expandableObject) {
        this.source = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
    }

    public PaymentIntent applyCustomerBalance() throws StripeException {
        return this.applyCustomerBalance((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent applyCustomerBalance(RequestOptions options) throws StripeException {
        return this.applyCustomerBalance((Map<String, Object>)null, options);
    }

    public PaymentIntent applyCustomerBalance(Map<String, Object> params) throws StripeException {
        return this.applyCustomerBalance(params, (RequestOptions)null);
    }

    public PaymentIntent applyCustomerBalance(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/apply_customer_balance", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent applyCustomerBalance(PaymentIntentApplyCustomerBalanceParams params) throws StripeException {
        return this.applyCustomerBalance(params, (RequestOptions)null);
    }

    public PaymentIntent applyCustomerBalance(PaymentIntentApplyCustomerBalanceParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/apply_customer_balance", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public PaymentIntent cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public PaymentIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent cancel(PaymentIntentCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public PaymentIntent cancel(PaymentIntentCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent capture() throws StripeException {
        return this.capture((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent capture(RequestOptions options) throws StripeException {
        return this.capture((Map<String, Object>)null, options);
    }

    public PaymentIntent capture(Map<String, Object> params) throws StripeException {
        return this.capture(params, (RequestOptions)null);
    }

    public PaymentIntent capture(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent capture(PaymentIntentCaptureParams params) throws StripeException {
        return this.capture(params, (RequestOptions)null);
    }

    public PaymentIntent capture(PaymentIntentCaptureParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent confirm() throws StripeException {
        return this.confirm((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent confirm(RequestOptions options) throws StripeException {
        return this.confirm((Map<String, Object>)null, options);
    }

    public PaymentIntent confirm(Map<String, Object> params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public PaymentIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent confirm(PaymentIntentConfirmParams params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public PaymentIntent confirm(PaymentIntentConfirmParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public static PaymentIntent create(Map<String, Object> params) throws StripeException {
        return PaymentIntent.create(params, (RequestOptions)null);
    }

    public static PaymentIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (PaymentIntent)PaymentIntent.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public static PaymentIntent create(PaymentIntentCreateParams params) throws StripeException {
        return PaymentIntent.create(params, (RequestOptions)null);
    }

    public static PaymentIntent create(PaymentIntentCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_intents";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntent)PaymentIntent.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent incrementAuthorization(Map<String, Object> params) throws StripeException {
        return this.incrementAuthorization(params, (RequestOptions)null);
    }

    public PaymentIntent incrementAuthorization(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/increment_authorization", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent incrementAuthorization(PaymentIntentIncrementAuthorizationParams params) throws StripeException {
        return this.incrementAuthorization(params, (RequestOptions)null);
    }

    public PaymentIntent incrementAuthorization(PaymentIntentIncrementAuthorizationParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/increment_authorization", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public static PaymentIntentCollection list(Map<String, Object> params) throws StripeException {
        return PaymentIntent.list(params, (RequestOptions)null);
    }

    public static PaymentIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (PaymentIntentCollection)PaymentIntent.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntentCollection.class));
    }

    public static PaymentIntentCollection list(PaymentIntentListParams params) throws StripeException {
        return PaymentIntent.list(params, (RequestOptions)null);
    }

    public static PaymentIntentCollection list(PaymentIntentListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_intents";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntentCollection)PaymentIntent.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntentCollection.class));
    }

    public static PaymentIntent retrieve(String intent) throws StripeException {
        return PaymentIntent.retrieve(intent, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentIntent retrieve(String intent, RequestOptions options) throws StripeException {
        return PaymentIntent.retrieve(intent, (Map<String, Object>)null, options);
    }

    public static PaymentIntent retrieve(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (PaymentIntent)PaymentIntent.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public static PaymentIntent retrieve(String intent, PaymentIntentRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntent)PaymentIntent.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public static PaymentIntentSearchResult search(Map<String, Object> params) throws StripeException {
        return PaymentIntent.search(params, (RequestOptions)null);
    }

    public static PaymentIntentSearchResult search(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_intents/search";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (PaymentIntentSearchResult)PaymentIntent.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntentSearchResult.class));
    }

    public static PaymentIntentSearchResult search(PaymentIntentSearchParams params) throws StripeException {
        return PaymentIntent.search(params, (RequestOptions)null);
    }

    public static PaymentIntentSearchResult search(PaymentIntentSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_intents/search";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntentSearchResult)PaymentIntent.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntentSearchResult.class));
    }

    public PaymentIntent update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PaymentIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent update(PaymentIntentUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentIntent update(PaymentIntentUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent verifyMicrodeposits() throws StripeException {
        return this.verifyMicrodeposits((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentIntent verifyMicrodeposits(RequestOptions options) throws StripeException {
        return this.verifyMicrodeposits((Map<String, Object>)null, options);
    }

    public PaymentIntent verifyMicrodeposits(Map<String, Object> params) throws StripeException {
        return this.verifyMicrodeposits(params, (RequestOptions)null);
    }

    public PaymentIntent verifyMicrodeposits(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent verifyMicrodeposits(PaymentIntentVerifyMicrodepositsParams params) throws StripeException {
        return this.verifyMicrodeposits(params, (RequestOptions)null);
    }

    public PaymentIntent verifyMicrodeposits(PaymentIntentVerifyMicrodepositsParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentIntent)this.getResponseGetter().request(request, (Type)((Object)PaymentIntent.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.amountDetails, responseGetter);
        this.trySetResponseGetter(this.application, responseGetter);
        this.trySetResponseGetter(this.automaticPaymentMethods, responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
        this.trySetResponseGetter(this.invoice, responseGetter);
        this.trySetResponseGetter(this.lastPaymentError, responseGetter);
        this.trySetResponseGetter(this.latestCharge, responseGetter);
        this.trySetResponseGetter(this.nextAction, responseGetter);
        this.trySetResponseGetter(this.onBehalfOf, responseGetter);
        this.trySetResponseGetter(this.paymentMethod, responseGetter);
        this.trySetResponseGetter(this.paymentMethodConfigurationDetails, responseGetter);
        this.trySetResponseGetter(this.paymentMethodOptions, responseGetter);
        this.trySetResponseGetter(this.processing, responseGetter);
        this.trySetResponseGetter(this.review, responseGetter);
        this.trySetResponseGetter(this.shipping, responseGetter);
        this.trySetResponseGetter(this.source, responseGetter);
        this.trySetResponseGetter(this.transferData, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountCapturable() {
        return this.amountCapturable;
    }

    @Generated
    public AmountDetails getAmountDetails() {
        return this.amountDetails;
    }

    @Generated
    public Long getAmountReceived() {
        return this.amountReceived;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public AutomaticPaymentMethods getAutomaticPaymentMethods() {
        return this.automaticPaymentMethods;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Generated
    public String getCaptureMethod() {
        return this.captureMethod;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getConfirmationMethod() {
        return this.confirmationMethod;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public StripeError getLastPaymentError() {
        return this.lastPaymentError;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public NextAction getNextAction() {
        return this.nextAction;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodConfigurationDetails getPaymentMethodConfigurationDetails() {
        return this.paymentMethodConfigurationDetails;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public Processing getProcessing() {
        return this.processing;
    }

    @Generated
    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public String getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountCapturable(Long amountCapturable) {
        this.amountCapturable = amountCapturable;
    }

    @Generated
    public void setAmountDetails(AmountDetails amountDetails) {
        this.amountDetails = amountDetails;
    }

    @Generated
    public void setAmountReceived(Long amountReceived) {
        this.amountReceived = amountReceived;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setAutomaticPaymentMethods(AutomaticPaymentMethods automaticPaymentMethods) {
        this.automaticPaymentMethods = automaticPaymentMethods;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    @Generated
    public void setCaptureMethod(String captureMethod) {
        this.captureMethod = captureMethod;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setConfirmationMethod(String confirmationMethod) {
        this.confirmationMethod = confirmationMethod;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastPaymentError(StripeError lastPaymentError) {
        this.lastPaymentError = lastPaymentError;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextAction(NextAction nextAction) {
        this.nextAction = nextAction;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodConfigurationDetails(PaymentMethodConfigurationDetails paymentMethodConfigurationDetails) {
        this.paymentMethodConfigurationDetails = paymentMethodConfigurationDetails;
    }

    @Generated
    public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setProcessing(Processing processing) {
        this.processing = processing;
    }

    @Generated
    public void setReceiptEmail(String receiptEmail) {
        this.receiptEmail = receiptEmail;
    }

    @Generated
    public void setSetupFutureUsage(String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatementDescriptorSuffix(String statementDescriptorSuffix) {
        this.statementDescriptorSuffix = statementDescriptorSuffix;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentIntent)) {
            return false;
        }
        PaymentIntent other = (PaymentIntent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountCapturable = this.getAmountCapturable();
        Long other$amountCapturable = other.getAmountCapturable();
        if (this$amountCapturable == null ? other$amountCapturable != null : !((Object)this$amountCapturable).equals(other$amountCapturable)) {
            return false;
        }
        Long this$amountReceived = this.getAmountReceived();
        Long other$amountReceived = other.getAmountReceived();
        if (this$amountReceived == null ? other$amountReceived != null : !((Object)this$amountReceived).equals(other$amountReceived)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AmountDetails this$amountDetails = this.getAmountDetails();
        AmountDetails other$amountDetails = other.getAmountDetails();
        if (this$amountDetails == null ? other$amountDetails != null : !((Object)this$amountDetails).equals(other$amountDetails)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        AutomaticPaymentMethods this$automaticPaymentMethods = this.getAutomaticPaymentMethods();
        AutomaticPaymentMethods other$automaticPaymentMethods = other.getAutomaticPaymentMethods();
        if (this$automaticPaymentMethods == null ? other$automaticPaymentMethods != null : !((Object)this$automaticPaymentMethods).equals(other$automaticPaymentMethods)) {
            return false;
        }
        String this$cancellationReason = this.getCancellationReason();
        String other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
            return false;
        }
        String this$captureMethod = this.getCaptureMethod();
        String other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$confirmationMethod = this.getConfirmationMethod();
        String other$confirmationMethod = other.getConfirmationMethod();
        if (this$confirmationMethod == null ? other$confirmationMethod != null : !this$confirmationMethod.equals(other$confirmationMethod)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        StripeError this$lastPaymentError = this.getLastPaymentError();
        StripeError other$lastPaymentError = other.getLastPaymentError();
        if (this$lastPaymentError == null ? other$lastPaymentError != null : !((Object)this$lastPaymentError).equals(other$lastPaymentError)) {
            return false;
        }
        String this$latestCharge = this.getLatestCharge();
        String other$latestCharge = other.getLatestCharge();
        if (this$latestCharge == null ? other$latestCharge != null : !this$latestCharge.equals(other$latestCharge)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        NextAction this$nextAction = this.getNextAction();
        NextAction other$nextAction = other.getNextAction();
        if (this$nextAction == null ? other$nextAction != null : !((Object)this$nextAction).equals(other$nextAction)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodConfigurationDetails this$paymentMethodConfigurationDetails = this.getPaymentMethodConfigurationDetails();
        PaymentMethodConfigurationDetails other$paymentMethodConfigurationDetails = other.getPaymentMethodConfigurationDetails();
        if (this$paymentMethodConfigurationDetails == null ? other$paymentMethodConfigurationDetails != null : !((Object)this$paymentMethodConfigurationDetails).equals(other$paymentMethodConfigurationDetails)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        Processing this$processing = this.getProcessing();
        Processing other$processing = other.getProcessing();
        if (this$processing == null ? other$processing != null : !((Object)this$processing).equals(other$processing)) {
            return false;
        }
        String this$receiptEmail = this.getReceiptEmail();
        String other$receiptEmail = other.getReceiptEmail();
        if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) {
            return false;
        }
        String this$review = this.getReview();
        String other$review = other.getReview();
        if (this$review == null ? other$review != null : !this$review.equals(other$review)) {
            return false;
        }
        String this$setupFutureUsage = this.getSetupFutureUsage();
        String other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        String other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
        if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        return !(this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentIntent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountCapturable = this.getAmountCapturable();
        result = result * 59 + ($amountCapturable == null ? 43 : ((Object)$amountCapturable).hashCode());
        Long $amountReceived = this.getAmountReceived();
        result = result * 59 + ($amountReceived == null ? 43 : ((Object)$amountReceived).hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AmountDetails $amountDetails = this.getAmountDetails();
        result = result * 59 + ($amountDetails == null ? 43 : ((Object)$amountDetails).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        AutomaticPaymentMethods $automaticPaymentMethods = this.getAutomaticPaymentMethods();
        result = result * 59 + ($automaticPaymentMethods == null ? 43 : ((Object)$automaticPaymentMethods).hashCode());
        String $cancellationReason = this.getCancellationReason();
        result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        String $captureMethod = this.getCaptureMethod();
        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $confirmationMethod = this.getConfirmationMethod();
        result = result * 59 + ($confirmationMethod == null ? 43 : $confirmationMethod.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        StripeError $lastPaymentError = this.getLastPaymentError();
        result = result * 59 + ($lastPaymentError == null ? 43 : ((Object)$lastPaymentError).hashCode());
        String $latestCharge = this.getLatestCharge();
        result = result * 59 + ($latestCharge == null ? 43 : $latestCharge.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        NextAction $nextAction = this.getNextAction();
        result = result * 59 + ($nextAction == null ? 43 : ((Object)$nextAction).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodConfigurationDetails $paymentMethodConfigurationDetails = this.getPaymentMethodConfigurationDetails();
        result = result * 59 + ($paymentMethodConfigurationDetails == null ? 43 : ((Object)$paymentMethodConfigurationDetails).hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        Processing $processing = this.getProcessing();
        result = result * 59 + ($processing == null ? 43 : ((Object)$processing).hashCode());
        String $receiptEmail = this.getReceiptEmail();
        result = result * 59 + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
        String $review = this.getReview();
        result = result * 59 + ($review == null ? 43 : $review.hashCode());
        String $setupFutureUsage = this.getSetupFutureUsage();
        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        result = result * 59 + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AmountDetails
    extends StripeObject {
        @SerializedName(value="tip")
        Tip tip;

        @Generated
        public Tip getTip() {
            return this.tip;
        }

        @Generated
        public void setTip(Tip tip) {
            this.tip = tip;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountDetails)) {
                return false;
            }
            AmountDetails other = (AmountDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Tip this$tip = this.getTip();
            Tip other$tip = other.getTip();
            return !(this$tip == null ? other$tip != null : !((Object)this$tip).equals(other$tip));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Tip $tip = this.getTip();
            result = result * 59 + ($tip == null ? 43 : ((Object)$tip).hashCode());
            return result;
        }

        public static class Tip
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tip)) {
                    return false;
                }
                Tip other = (Tip)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tip;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                return result;
            }
        }
    }

    public static class AutomaticPaymentMethods
    extends StripeObject {
        @SerializedName(value="allow_redirects")
        String allowRedirects;
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public String getAllowRedirects() {
            return this.allowRedirects;
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setAllowRedirects(String allowRedirects) {
            this.allowRedirects = allowRedirects;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticPaymentMethods)) {
                return false;
            }
            AutomaticPaymentMethods other = (AutomaticPaymentMethods)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$allowRedirects = this.getAllowRedirects();
            String other$allowRedirects = other.getAllowRedirects();
            return !(this$allowRedirects == null ? other$allowRedirects != null : !this$allowRedirects.equals(other$allowRedirects));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticPaymentMethods;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $allowRedirects = this.getAllowRedirects();
            result = result * 59 + ($allowRedirects == null ? 43 : $allowRedirects.hashCode());
            return result;
        }
    }

    public static class NextAction
    extends StripeObject {
        @SerializedName(value="alipay_handle_redirect")
        AlipayHandleRedirect alipayHandleRedirect;
        @SerializedName(value="boleto_display_details")
        BoletoDisplayDetails boletoDisplayDetails;
        @SerializedName(value="card_await_notification")
        CardAwaitNotification cardAwaitNotification;
        @SerializedName(value="cashapp_handle_redirect_or_display_qr_code")
        CashappHandleRedirectOrDisplayQrCode cashappHandleRedirectOrDisplayQrCode;
        @SerializedName(value="display_bank_transfer_instructions")
        DisplayBankTransferInstructions displayBankTransferInstructions;
        @SerializedName(value="konbini_display_details")
        KonbiniDisplayDetails konbiniDisplayDetails;
        @SerializedName(value="oxxo_display_details")
        OxxoDisplayDetails oxxoDisplayDetails;
        @SerializedName(value="paynow_display_qr_code")
        PaynowDisplayQrCode paynowDisplayQrCode;
        @SerializedName(value="pix_display_qr_code")
        PixDisplayQrCode pixDisplayQrCode;
        @SerializedName(value="promptpay_display_qr_code")
        PromptpayDisplayQrCode promptpayDisplayQrCode;
        @SerializedName(value="redirect_to_url")
        RedirectToUrl redirectToUrl;
        @SerializedName(value="swish_handle_redirect_or_display_qr_code")
        SwishHandleRedirectOrDisplayQrCode swishHandleRedirectOrDisplayQrCode;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="use_stripe_sdk")
        Map<String, Object> useStripeSdk;
        @SerializedName(value="verify_with_microdeposits")
        VerifyWithMicrodeposits verifyWithMicrodeposits;
        @SerializedName(value="wechat_pay_display_qr_code")
        WechatPayDisplayQrCode wechatPayDisplayQrCode;
        @SerializedName(value="wechat_pay_redirect_to_android_app")
        WechatPayRedirectToAndroidApp wechatPayRedirectToAndroidApp;
        @SerializedName(value="wechat_pay_redirect_to_ios_app")
        WechatPayRedirectToIosApp wechatPayRedirectToIosApp;

        @Generated
        public AlipayHandleRedirect getAlipayHandleRedirect() {
            return this.alipayHandleRedirect;
        }

        @Generated
        public BoletoDisplayDetails getBoletoDisplayDetails() {
            return this.boletoDisplayDetails;
        }

        @Generated
        public CardAwaitNotification getCardAwaitNotification() {
            return this.cardAwaitNotification;
        }

        @Generated
        public CashappHandleRedirectOrDisplayQrCode getCashappHandleRedirectOrDisplayQrCode() {
            return this.cashappHandleRedirectOrDisplayQrCode;
        }

        @Generated
        public DisplayBankTransferInstructions getDisplayBankTransferInstructions() {
            return this.displayBankTransferInstructions;
        }

        @Generated
        public KonbiniDisplayDetails getKonbiniDisplayDetails() {
            return this.konbiniDisplayDetails;
        }

        @Generated
        public OxxoDisplayDetails getOxxoDisplayDetails() {
            return this.oxxoDisplayDetails;
        }

        @Generated
        public PaynowDisplayQrCode getPaynowDisplayQrCode() {
            return this.paynowDisplayQrCode;
        }

        @Generated
        public PixDisplayQrCode getPixDisplayQrCode() {
            return this.pixDisplayQrCode;
        }

        @Generated
        public PromptpayDisplayQrCode getPromptpayDisplayQrCode() {
            return this.promptpayDisplayQrCode;
        }

        @Generated
        public RedirectToUrl getRedirectToUrl() {
            return this.redirectToUrl;
        }

        @Generated
        public SwishHandleRedirectOrDisplayQrCode getSwishHandleRedirectOrDisplayQrCode() {
            return this.swishHandleRedirectOrDisplayQrCode;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Map<String, Object> getUseStripeSdk() {
            return this.useStripeSdk;
        }

        @Generated
        public VerifyWithMicrodeposits getVerifyWithMicrodeposits() {
            return this.verifyWithMicrodeposits;
        }

        @Generated
        public WechatPayDisplayQrCode getWechatPayDisplayQrCode() {
            return this.wechatPayDisplayQrCode;
        }

        @Generated
        public WechatPayRedirectToAndroidApp getWechatPayRedirectToAndroidApp() {
            return this.wechatPayRedirectToAndroidApp;
        }

        @Generated
        public WechatPayRedirectToIosApp getWechatPayRedirectToIosApp() {
            return this.wechatPayRedirectToIosApp;
        }

        @Generated
        public void setAlipayHandleRedirect(AlipayHandleRedirect alipayHandleRedirect) {
            this.alipayHandleRedirect = alipayHandleRedirect;
        }

        @Generated
        public void setBoletoDisplayDetails(BoletoDisplayDetails boletoDisplayDetails) {
            this.boletoDisplayDetails = boletoDisplayDetails;
        }

        @Generated
        public void setCardAwaitNotification(CardAwaitNotification cardAwaitNotification) {
            this.cardAwaitNotification = cardAwaitNotification;
        }

        @Generated
        public void setCashappHandleRedirectOrDisplayQrCode(CashappHandleRedirectOrDisplayQrCode cashappHandleRedirectOrDisplayQrCode) {
            this.cashappHandleRedirectOrDisplayQrCode = cashappHandleRedirectOrDisplayQrCode;
        }

        @Generated
        public void setDisplayBankTransferInstructions(DisplayBankTransferInstructions displayBankTransferInstructions) {
            this.displayBankTransferInstructions = displayBankTransferInstructions;
        }

        @Generated
        public void setKonbiniDisplayDetails(KonbiniDisplayDetails konbiniDisplayDetails) {
            this.konbiniDisplayDetails = konbiniDisplayDetails;
        }

        @Generated
        public void setOxxoDisplayDetails(OxxoDisplayDetails oxxoDisplayDetails) {
            this.oxxoDisplayDetails = oxxoDisplayDetails;
        }

        @Generated
        public void setPaynowDisplayQrCode(PaynowDisplayQrCode paynowDisplayQrCode) {
            this.paynowDisplayQrCode = paynowDisplayQrCode;
        }

        @Generated
        public void setPixDisplayQrCode(PixDisplayQrCode pixDisplayQrCode) {
            this.pixDisplayQrCode = pixDisplayQrCode;
        }

        @Generated
        public void setPromptpayDisplayQrCode(PromptpayDisplayQrCode promptpayDisplayQrCode) {
            this.promptpayDisplayQrCode = promptpayDisplayQrCode;
        }

        @Generated
        public void setRedirectToUrl(RedirectToUrl redirectToUrl) {
            this.redirectToUrl = redirectToUrl;
        }

        @Generated
        public void setSwishHandleRedirectOrDisplayQrCode(SwishHandleRedirectOrDisplayQrCode swishHandleRedirectOrDisplayQrCode) {
            this.swishHandleRedirectOrDisplayQrCode = swishHandleRedirectOrDisplayQrCode;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUseStripeSdk(Map<String, Object> useStripeSdk) {
            this.useStripeSdk = useStripeSdk;
        }

        @Generated
        public void setVerifyWithMicrodeposits(VerifyWithMicrodeposits verifyWithMicrodeposits) {
            this.verifyWithMicrodeposits = verifyWithMicrodeposits;
        }

        @Generated
        public void setWechatPayDisplayQrCode(WechatPayDisplayQrCode wechatPayDisplayQrCode) {
            this.wechatPayDisplayQrCode = wechatPayDisplayQrCode;
        }

        @Generated
        public void setWechatPayRedirectToAndroidApp(WechatPayRedirectToAndroidApp wechatPayRedirectToAndroidApp) {
            this.wechatPayRedirectToAndroidApp = wechatPayRedirectToAndroidApp;
        }

        @Generated
        public void setWechatPayRedirectToIosApp(WechatPayRedirectToIosApp wechatPayRedirectToIosApp) {
            this.wechatPayRedirectToIosApp = wechatPayRedirectToIosApp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextAction)) {
                return false;
            }
            NextAction other = (NextAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AlipayHandleRedirect this$alipayHandleRedirect = this.getAlipayHandleRedirect();
            AlipayHandleRedirect other$alipayHandleRedirect = other.getAlipayHandleRedirect();
            if (this$alipayHandleRedirect == null ? other$alipayHandleRedirect != null : !((Object)this$alipayHandleRedirect).equals(other$alipayHandleRedirect)) {
                return false;
            }
            BoletoDisplayDetails this$boletoDisplayDetails = this.getBoletoDisplayDetails();
            BoletoDisplayDetails other$boletoDisplayDetails = other.getBoletoDisplayDetails();
            if (this$boletoDisplayDetails == null ? other$boletoDisplayDetails != null : !((Object)this$boletoDisplayDetails).equals(other$boletoDisplayDetails)) {
                return false;
            }
            CardAwaitNotification this$cardAwaitNotification = this.getCardAwaitNotification();
            CardAwaitNotification other$cardAwaitNotification = other.getCardAwaitNotification();
            if (this$cardAwaitNotification == null ? other$cardAwaitNotification != null : !((Object)this$cardAwaitNotification).equals(other$cardAwaitNotification)) {
                return false;
            }
            CashappHandleRedirectOrDisplayQrCode this$cashappHandleRedirectOrDisplayQrCode = this.getCashappHandleRedirectOrDisplayQrCode();
            CashappHandleRedirectOrDisplayQrCode other$cashappHandleRedirectOrDisplayQrCode = other.getCashappHandleRedirectOrDisplayQrCode();
            if (this$cashappHandleRedirectOrDisplayQrCode == null ? other$cashappHandleRedirectOrDisplayQrCode != null : !((Object)this$cashappHandleRedirectOrDisplayQrCode).equals(other$cashappHandleRedirectOrDisplayQrCode)) {
                return false;
            }
            DisplayBankTransferInstructions this$displayBankTransferInstructions = this.getDisplayBankTransferInstructions();
            DisplayBankTransferInstructions other$displayBankTransferInstructions = other.getDisplayBankTransferInstructions();
            if (this$displayBankTransferInstructions == null ? other$displayBankTransferInstructions != null : !((Object)this$displayBankTransferInstructions).equals(other$displayBankTransferInstructions)) {
                return false;
            }
            KonbiniDisplayDetails this$konbiniDisplayDetails = this.getKonbiniDisplayDetails();
            KonbiniDisplayDetails other$konbiniDisplayDetails = other.getKonbiniDisplayDetails();
            if (this$konbiniDisplayDetails == null ? other$konbiniDisplayDetails != null : !((Object)this$konbiniDisplayDetails).equals(other$konbiniDisplayDetails)) {
                return false;
            }
            OxxoDisplayDetails this$oxxoDisplayDetails = this.getOxxoDisplayDetails();
            OxxoDisplayDetails other$oxxoDisplayDetails = other.getOxxoDisplayDetails();
            if (this$oxxoDisplayDetails == null ? other$oxxoDisplayDetails != null : !((Object)this$oxxoDisplayDetails).equals(other$oxxoDisplayDetails)) {
                return false;
            }
            PaynowDisplayQrCode this$paynowDisplayQrCode = this.getPaynowDisplayQrCode();
            PaynowDisplayQrCode other$paynowDisplayQrCode = other.getPaynowDisplayQrCode();
            if (this$paynowDisplayQrCode == null ? other$paynowDisplayQrCode != null : !((Object)this$paynowDisplayQrCode).equals(other$paynowDisplayQrCode)) {
                return false;
            }
            PixDisplayQrCode this$pixDisplayQrCode = this.getPixDisplayQrCode();
            PixDisplayQrCode other$pixDisplayQrCode = other.getPixDisplayQrCode();
            if (this$pixDisplayQrCode == null ? other$pixDisplayQrCode != null : !((Object)this$pixDisplayQrCode).equals(other$pixDisplayQrCode)) {
                return false;
            }
            PromptpayDisplayQrCode this$promptpayDisplayQrCode = this.getPromptpayDisplayQrCode();
            PromptpayDisplayQrCode other$promptpayDisplayQrCode = other.getPromptpayDisplayQrCode();
            if (this$promptpayDisplayQrCode == null ? other$promptpayDisplayQrCode != null : !((Object)this$promptpayDisplayQrCode).equals(other$promptpayDisplayQrCode)) {
                return false;
            }
            RedirectToUrl this$redirectToUrl = this.getRedirectToUrl();
            RedirectToUrl other$redirectToUrl = other.getRedirectToUrl();
            if (this$redirectToUrl == null ? other$redirectToUrl != null : !((Object)this$redirectToUrl).equals(other$redirectToUrl)) {
                return false;
            }
            SwishHandleRedirectOrDisplayQrCode this$swishHandleRedirectOrDisplayQrCode = this.getSwishHandleRedirectOrDisplayQrCode();
            SwishHandleRedirectOrDisplayQrCode other$swishHandleRedirectOrDisplayQrCode = other.getSwishHandleRedirectOrDisplayQrCode();
            if (this$swishHandleRedirectOrDisplayQrCode == null ? other$swishHandleRedirectOrDisplayQrCode != null : !((Object)this$swishHandleRedirectOrDisplayQrCode).equals(other$swishHandleRedirectOrDisplayQrCode)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<String, Object> this$useStripeSdk = this.getUseStripeSdk();
            Map<String, Object> other$useStripeSdk = other.getUseStripeSdk();
            if (this$useStripeSdk == null ? other$useStripeSdk != null : !((Object)this$useStripeSdk).equals(other$useStripeSdk)) {
                return false;
            }
            VerifyWithMicrodeposits this$verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
            VerifyWithMicrodeposits other$verifyWithMicrodeposits = other.getVerifyWithMicrodeposits();
            if (this$verifyWithMicrodeposits == null ? other$verifyWithMicrodeposits != null : !((Object)this$verifyWithMicrodeposits).equals(other$verifyWithMicrodeposits)) {
                return false;
            }
            WechatPayDisplayQrCode this$wechatPayDisplayQrCode = this.getWechatPayDisplayQrCode();
            WechatPayDisplayQrCode other$wechatPayDisplayQrCode = other.getWechatPayDisplayQrCode();
            if (this$wechatPayDisplayQrCode == null ? other$wechatPayDisplayQrCode != null : !((Object)this$wechatPayDisplayQrCode).equals(other$wechatPayDisplayQrCode)) {
                return false;
            }
            WechatPayRedirectToAndroidApp this$wechatPayRedirectToAndroidApp = this.getWechatPayRedirectToAndroidApp();
            WechatPayRedirectToAndroidApp other$wechatPayRedirectToAndroidApp = other.getWechatPayRedirectToAndroidApp();
            if (this$wechatPayRedirectToAndroidApp == null ? other$wechatPayRedirectToAndroidApp != null : !((Object)this$wechatPayRedirectToAndroidApp).equals(other$wechatPayRedirectToAndroidApp)) {
                return false;
            }
            WechatPayRedirectToIosApp this$wechatPayRedirectToIosApp = this.getWechatPayRedirectToIosApp();
            WechatPayRedirectToIosApp other$wechatPayRedirectToIosApp = other.getWechatPayRedirectToIosApp();
            return !(this$wechatPayRedirectToIosApp == null ? other$wechatPayRedirectToIosApp != null : !((Object)this$wechatPayRedirectToIosApp).equals(other$wechatPayRedirectToIosApp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AlipayHandleRedirect $alipayHandleRedirect = this.getAlipayHandleRedirect();
            result = result * 59 + ($alipayHandleRedirect == null ? 43 : ((Object)$alipayHandleRedirect).hashCode());
            BoletoDisplayDetails $boletoDisplayDetails = this.getBoletoDisplayDetails();
            result = result * 59 + ($boletoDisplayDetails == null ? 43 : ((Object)$boletoDisplayDetails).hashCode());
            CardAwaitNotification $cardAwaitNotification = this.getCardAwaitNotification();
            result = result * 59 + ($cardAwaitNotification == null ? 43 : ((Object)$cardAwaitNotification).hashCode());
            CashappHandleRedirectOrDisplayQrCode $cashappHandleRedirectOrDisplayQrCode = this.getCashappHandleRedirectOrDisplayQrCode();
            result = result * 59 + ($cashappHandleRedirectOrDisplayQrCode == null ? 43 : ((Object)$cashappHandleRedirectOrDisplayQrCode).hashCode());
            DisplayBankTransferInstructions $displayBankTransferInstructions = this.getDisplayBankTransferInstructions();
            result = result * 59 + ($displayBankTransferInstructions == null ? 43 : ((Object)$displayBankTransferInstructions).hashCode());
            KonbiniDisplayDetails $konbiniDisplayDetails = this.getKonbiniDisplayDetails();
            result = result * 59 + ($konbiniDisplayDetails == null ? 43 : ((Object)$konbiniDisplayDetails).hashCode());
            OxxoDisplayDetails $oxxoDisplayDetails = this.getOxxoDisplayDetails();
            result = result * 59 + ($oxxoDisplayDetails == null ? 43 : ((Object)$oxxoDisplayDetails).hashCode());
            PaynowDisplayQrCode $paynowDisplayQrCode = this.getPaynowDisplayQrCode();
            result = result * 59 + ($paynowDisplayQrCode == null ? 43 : ((Object)$paynowDisplayQrCode).hashCode());
            PixDisplayQrCode $pixDisplayQrCode = this.getPixDisplayQrCode();
            result = result * 59 + ($pixDisplayQrCode == null ? 43 : ((Object)$pixDisplayQrCode).hashCode());
            PromptpayDisplayQrCode $promptpayDisplayQrCode = this.getPromptpayDisplayQrCode();
            result = result * 59 + ($promptpayDisplayQrCode == null ? 43 : ((Object)$promptpayDisplayQrCode).hashCode());
            RedirectToUrl $redirectToUrl = this.getRedirectToUrl();
            result = result * 59 + ($redirectToUrl == null ? 43 : ((Object)$redirectToUrl).hashCode());
            SwishHandleRedirectOrDisplayQrCode $swishHandleRedirectOrDisplayQrCode = this.getSwishHandleRedirectOrDisplayQrCode();
            result = result * 59 + ($swishHandleRedirectOrDisplayQrCode == null ? 43 : ((Object)$swishHandleRedirectOrDisplayQrCode).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<String, Object> $useStripeSdk = this.getUseStripeSdk();
            result = result * 59 + ($useStripeSdk == null ? 43 : ((Object)$useStripeSdk).hashCode());
            VerifyWithMicrodeposits $verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
            result = result * 59 + ($verifyWithMicrodeposits == null ? 43 : ((Object)$verifyWithMicrodeposits).hashCode());
            WechatPayDisplayQrCode $wechatPayDisplayQrCode = this.getWechatPayDisplayQrCode();
            result = result * 59 + ($wechatPayDisplayQrCode == null ? 43 : ((Object)$wechatPayDisplayQrCode).hashCode());
            WechatPayRedirectToAndroidApp $wechatPayRedirectToAndroidApp = this.getWechatPayRedirectToAndroidApp();
            result = result * 59 + ($wechatPayRedirectToAndroidApp == null ? 43 : ((Object)$wechatPayRedirectToAndroidApp).hashCode());
            WechatPayRedirectToIosApp $wechatPayRedirectToIosApp = this.getWechatPayRedirectToIosApp();
            result = result * 59 + ($wechatPayRedirectToIosApp == null ? 43 : ((Object)$wechatPayRedirectToIosApp).hashCode());
            return result;
        }

        public static class AlipayHandleRedirect
        extends StripeObject {
            @SerializedName(value="native_data")
            String nativeData;
            @SerializedName(value="native_url")
            String nativeUrl;
            @SerializedName(value="return_url")
            String returnUrl;
            @SerializedName(value="url")
            String url;

            @Generated
            public String getNativeData() {
                return this.nativeData;
            }

            @Generated
            public String getNativeUrl() {
                return this.nativeUrl;
            }

            @Generated
            public String getReturnUrl() {
                return this.returnUrl;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setNativeData(String nativeData) {
                this.nativeData = nativeData;
            }

            @Generated
            public void setNativeUrl(String nativeUrl) {
                this.nativeUrl = nativeUrl;
            }

            @Generated
            public void setReturnUrl(String returnUrl) {
                this.returnUrl = returnUrl;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AlipayHandleRedirect)) {
                    return false;
                }
                AlipayHandleRedirect other = (AlipayHandleRedirect)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$nativeData = this.getNativeData();
                String other$nativeData = other.getNativeData();
                if (this$nativeData == null ? other$nativeData != null : !this$nativeData.equals(other$nativeData)) {
                    return false;
                }
                String this$nativeUrl = this.getNativeUrl();
                String other$nativeUrl = other.getNativeUrl();
                if (this$nativeUrl == null ? other$nativeUrl != null : !this$nativeUrl.equals(other$nativeUrl)) {
                    return false;
                }
                String this$returnUrl = this.getReturnUrl();
                String other$returnUrl = other.getReturnUrl();
                if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AlipayHandleRedirect;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $nativeData = this.getNativeData();
                result = result * 59 + ($nativeData == null ? 43 : $nativeData.hashCode());
                String $nativeUrl = this.getNativeUrl();
                result = result * 59 + ($nativeUrl == null ? 43 : $nativeUrl.hashCode());
                String $returnUrl = this.getReturnUrl();
                result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }

        public static class BoletoDisplayDetails
        extends StripeObject {
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="hosted_voucher_url")
            String hostedVoucherUrl;
            @SerializedName(value="number")
            String number;
            @SerializedName(value="pdf")
            String pdf;

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public String getHostedVoucherUrl() {
                return this.hostedVoucherUrl;
            }

            @Generated
            public String getNumber() {
                return this.number;
            }

            @Generated
            public String getPdf() {
                return this.pdf;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public void setHostedVoucherUrl(String hostedVoucherUrl) {
                this.hostedVoucherUrl = hostedVoucherUrl;
            }

            @Generated
            public void setNumber(String number) {
                this.number = number;
            }

            @Generated
            public void setPdf(String pdf) {
                this.pdf = pdf;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BoletoDisplayDetails)) {
                    return false;
                }
                BoletoDisplayDetails other = (BoletoDisplayDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                String this$hostedVoucherUrl = this.getHostedVoucherUrl();
                String other$hostedVoucherUrl = other.getHostedVoucherUrl();
                if (this$hostedVoucherUrl == null ? other$hostedVoucherUrl != null : !this$hostedVoucherUrl.equals(other$hostedVoucherUrl)) {
                    return false;
                }
                String this$number = this.getNumber();
                String other$number = other.getNumber();
                if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
                    return false;
                }
                String this$pdf = this.getPdf();
                String other$pdf = other.getPdf();
                return !(this$pdf == null ? other$pdf != null : !this$pdf.equals(other$pdf));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BoletoDisplayDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                String $hostedVoucherUrl = this.getHostedVoucherUrl();
                result = result * 59 + ($hostedVoucherUrl == null ? 43 : $hostedVoucherUrl.hashCode());
                String $number = this.getNumber();
                result = result * 59 + ($number == null ? 43 : $number.hashCode());
                String $pdf = this.getPdf();
                result = result * 59 + ($pdf == null ? 43 : $pdf.hashCode());
                return result;
            }
        }

        public static class CardAwaitNotification
        extends StripeObject {
            @SerializedName(value="charge_attempt_at")
            Long chargeAttemptAt;
            @SerializedName(value="customer_approval_required")
            Boolean customerApprovalRequired;

            @Generated
            public Long getChargeAttemptAt() {
                return this.chargeAttemptAt;
            }

            @Generated
            public Boolean getCustomerApprovalRequired() {
                return this.customerApprovalRequired;
            }

            @Generated
            public void setChargeAttemptAt(Long chargeAttemptAt) {
                this.chargeAttemptAt = chargeAttemptAt;
            }

            @Generated
            public void setCustomerApprovalRequired(Boolean customerApprovalRequired) {
                this.customerApprovalRequired = customerApprovalRequired;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardAwaitNotification)) {
                    return false;
                }
                CardAwaitNotification other = (CardAwaitNotification)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$chargeAttemptAt = this.getChargeAttemptAt();
                Long other$chargeAttemptAt = other.getChargeAttemptAt();
                if (this$chargeAttemptAt == null ? other$chargeAttemptAt != null : !((Object)this$chargeAttemptAt).equals(other$chargeAttemptAt)) {
                    return false;
                }
                Boolean this$customerApprovalRequired = this.getCustomerApprovalRequired();
                Boolean other$customerApprovalRequired = other.getCustomerApprovalRequired();
                return !(this$customerApprovalRequired == null ? other$customerApprovalRequired != null : !((Object)this$customerApprovalRequired).equals(other$customerApprovalRequired));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardAwaitNotification;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $chargeAttemptAt = this.getChargeAttemptAt();
                result = result * 59 + ($chargeAttemptAt == null ? 43 : ((Object)$chargeAttemptAt).hashCode());
                Boolean $customerApprovalRequired = this.getCustomerApprovalRequired();
                result = result * 59 + ($customerApprovalRequired == null ? 43 : ((Object)$customerApprovalRequired).hashCode());
                return result;
            }
        }

        public static class CashappHandleRedirectOrDisplayQrCode
        extends StripeObject {
            @SerializedName(value="hosted_instructions_url")
            String hostedInstructionsUrl;
            @SerializedName(value="mobile_auth_url")
            String mobileAuthUrl;
            @SerializedName(value="qr_code")
            QrCode qrCode;

            @Generated
            public String getHostedInstructionsUrl() {
                return this.hostedInstructionsUrl;
            }

            @Generated
            public String getMobileAuthUrl() {
                return this.mobileAuthUrl;
            }

            @Generated
            public QrCode getQrCode() {
                return this.qrCode;
            }

            @Generated
            public void setHostedInstructionsUrl(String hostedInstructionsUrl) {
                this.hostedInstructionsUrl = hostedInstructionsUrl;
            }

            @Generated
            public void setMobileAuthUrl(String mobileAuthUrl) {
                this.mobileAuthUrl = mobileAuthUrl;
            }

            @Generated
            public void setQrCode(QrCode qrCode) {
                this.qrCode = qrCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CashappHandleRedirectOrDisplayQrCode)) {
                    return false;
                }
                CashappHandleRedirectOrDisplayQrCode other = (CashappHandleRedirectOrDisplayQrCode)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
                String other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
                if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) {
                    return false;
                }
                String this$mobileAuthUrl = this.getMobileAuthUrl();
                String other$mobileAuthUrl = other.getMobileAuthUrl();
                if (this$mobileAuthUrl == null ? other$mobileAuthUrl != null : !this$mobileAuthUrl.equals(other$mobileAuthUrl)) {
                    return false;
                }
                QrCode this$qrCode = this.getQrCode();
                QrCode other$qrCode = other.getQrCode();
                return !(this$qrCode == null ? other$qrCode != null : !((Object)this$qrCode).equals(other$qrCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CashappHandleRedirectOrDisplayQrCode;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $hostedInstructionsUrl = this.getHostedInstructionsUrl();
                result = result * 59 + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
                String $mobileAuthUrl = this.getMobileAuthUrl();
                result = result * 59 + ($mobileAuthUrl == null ? 43 : $mobileAuthUrl.hashCode());
                QrCode $qrCode = this.getQrCode();
                result = result * 59 + ($qrCode == null ? 43 : ((Object)$qrCode).hashCode());
                return result;
            }

            public static class QrCode
            extends StripeObject {
                @SerializedName(value="expires_at")
                Long expiresAt;
                @SerializedName(value="image_url_png")
                String imageUrlPng;
                @SerializedName(value="image_url_svg")
                String imageUrlSvg;

                @Generated
                public Long getExpiresAt() {
                    return this.expiresAt;
                }

                @Generated
                public String getImageUrlPng() {
                    return this.imageUrlPng;
                }

                @Generated
                public String getImageUrlSvg() {
                    return this.imageUrlSvg;
                }

                @Generated
                public void setExpiresAt(Long expiresAt) {
                    this.expiresAt = expiresAt;
                }

                @Generated
                public void setImageUrlPng(String imageUrlPng) {
                    this.imageUrlPng = imageUrlPng;
                }

                @Generated
                public void setImageUrlSvg(String imageUrlSvg) {
                    this.imageUrlSvg = imageUrlSvg;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof QrCode)) {
                        return false;
                    }
                    QrCode other = (QrCode)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$expiresAt = this.getExpiresAt();
                    Long other$expiresAt = other.getExpiresAt();
                    if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                        return false;
                    }
                    String this$imageUrlPng = this.getImageUrlPng();
                    String other$imageUrlPng = other.getImageUrlPng();
                    if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) {
                        return false;
                    }
                    String this$imageUrlSvg = this.getImageUrlSvg();
                    String other$imageUrlSvg = other.getImageUrlSvg();
                    return !(this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof QrCode;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $expiresAt = this.getExpiresAt();
                    result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                    String $imageUrlPng = this.getImageUrlPng();
                    result = result * 59 + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
                    String $imageUrlSvg = this.getImageUrlSvg();
                    result = result * 59 + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
                    return result;
                }
            }
        }

        public static class DisplayBankTransferInstructions
        extends StripeObject {
            @SerializedName(value="amount_remaining")
            Long amountRemaining;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="financial_addresses")
            List<FinancialAddress> financialAddresses;
            @SerializedName(value="hosted_instructions_url")
            String hostedInstructionsUrl;
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="type")
            String type;

            @Generated
            public Long getAmountRemaining() {
                return this.amountRemaining;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public List<FinancialAddress> getFinancialAddresses() {
                return this.financialAddresses;
            }

            @Generated
            public String getHostedInstructionsUrl() {
                return this.hostedInstructionsUrl;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setAmountRemaining(Long amountRemaining) {
                this.amountRemaining = amountRemaining;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setFinancialAddresses(List<FinancialAddress> financialAddresses) {
                this.financialAddresses = financialAddresses;
            }

            @Generated
            public void setHostedInstructionsUrl(String hostedInstructionsUrl) {
                this.hostedInstructionsUrl = hostedInstructionsUrl;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayBankTransferInstructions)) {
                    return false;
                }
                DisplayBankTransferInstructions other = (DisplayBankTransferInstructions)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amountRemaining = this.getAmountRemaining();
                Long other$amountRemaining = other.getAmountRemaining();
                if (this$amountRemaining == null ? other$amountRemaining != null : !((Object)this$amountRemaining).equals(other$amountRemaining)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                List<FinancialAddress> this$financialAddresses = this.getFinancialAddresses();
                List<FinancialAddress> other$financialAddresses = other.getFinancialAddresses();
                if (this$financialAddresses == null ? other$financialAddresses != null : !((Object)this$financialAddresses).equals(other$financialAddresses)) {
                    return false;
                }
                String this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
                String other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
                if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayBankTransferInstructions;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amountRemaining = this.getAmountRemaining();
                result = result * 59 + ($amountRemaining == null ? 43 : ((Object)$amountRemaining).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                List<FinancialAddress> $financialAddresses = this.getFinancialAddresses();
                result = result * 59 + ($financialAddresses == null ? 43 : ((Object)$financialAddresses).hashCode());
                String $hostedInstructionsUrl = this.getHostedInstructionsUrl();
                result = result * 59 + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class FinancialAddress
            extends StripeObject {
                @SerializedName(value="aba")
                Aba aba;
                @SerializedName(value="iban")
                Iban iban;
                @SerializedName(value="sort_code")
                SortCode sortCode;
                @SerializedName(value="spei")
                Spei spei;
                @SerializedName(value="supported_networks")
                List<String> supportedNetworks;
                @SerializedName(value="swift")
                Swift swift;
                @SerializedName(value="type")
                String type;
                @SerializedName(value="zengin")
                Zengin zengin;

                @Generated
                public Aba getAba() {
                    return this.aba;
                }

                @Generated
                public Iban getIban() {
                    return this.iban;
                }

                @Generated
                public SortCode getSortCode() {
                    return this.sortCode;
                }

                @Generated
                public Spei getSpei() {
                    return this.spei;
                }

                @Generated
                public List<String> getSupportedNetworks() {
                    return this.supportedNetworks;
                }

                @Generated
                public Swift getSwift() {
                    return this.swift;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public Zengin getZengin() {
                    return this.zengin;
                }

                @Generated
                public void setAba(Aba aba) {
                    this.aba = aba;
                }

                @Generated
                public void setIban(Iban iban) {
                    this.iban = iban;
                }

                @Generated
                public void setSortCode(SortCode sortCode) {
                    this.sortCode = sortCode;
                }

                @Generated
                public void setSpei(Spei spei) {
                    this.spei = spei;
                }

                @Generated
                public void setSupportedNetworks(List<String> supportedNetworks) {
                    this.supportedNetworks = supportedNetworks;
                }

                @Generated
                public void setSwift(Swift swift) {
                    this.swift = swift;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public void setZengin(Zengin zengin) {
                    this.zengin = zengin;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof FinancialAddress)) {
                        return false;
                    }
                    FinancialAddress other = (FinancialAddress)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Aba this$aba = this.getAba();
                    Aba other$aba = other.getAba();
                    if (this$aba == null ? other$aba != null : !((Object)this$aba).equals(other$aba)) {
                        return false;
                    }
                    Iban this$iban = this.getIban();
                    Iban other$iban = other.getIban();
                    if (this$iban == null ? other$iban != null : !((Object)this$iban).equals(other$iban)) {
                        return false;
                    }
                    SortCode this$sortCode = this.getSortCode();
                    SortCode other$sortCode = other.getSortCode();
                    if (this$sortCode == null ? other$sortCode != null : !((Object)this$sortCode).equals(other$sortCode)) {
                        return false;
                    }
                    Spei this$spei = this.getSpei();
                    Spei other$spei = other.getSpei();
                    if (this$spei == null ? other$spei != null : !((Object)this$spei).equals(other$spei)) {
                        return false;
                    }
                    List<String> this$supportedNetworks = this.getSupportedNetworks();
                    List<String> other$supportedNetworks = other.getSupportedNetworks();
                    if (this$supportedNetworks == null ? other$supportedNetworks != null : !((Object)this$supportedNetworks).equals(other$supportedNetworks)) {
                        return false;
                    }
                    Swift this$swift = this.getSwift();
                    Swift other$swift = other.getSwift();
                    if (this$swift == null ? other$swift != null : !((Object)this$swift).equals(other$swift)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                        return false;
                    }
                    Zengin this$zengin = this.getZengin();
                    Zengin other$zengin = other.getZengin();
                    return !(this$zengin == null ? other$zengin != null : !((Object)this$zengin).equals(other$zengin));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof FinancialAddress;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Aba $aba = this.getAba();
                    result = result * 59 + ($aba == null ? 43 : ((Object)$aba).hashCode());
                    Iban $iban = this.getIban();
                    result = result * 59 + ($iban == null ? 43 : ((Object)$iban).hashCode());
                    SortCode $sortCode = this.getSortCode();
                    result = result * 59 + ($sortCode == null ? 43 : ((Object)$sortCode).hashCode());
                    Spei $spei = this.getSpei();
                    result = result * 59 + ($spei == null ? 43 : ((Object)$spei).hashCode());
                    List<String> $supportedNetworks = this.getSupportedNetworks();
                    result = result * 59 + ($supportedNetworks == null ? 43 : ((Object)$supportedNetworks).hashCode());
                    Swift $swift = this.getSwift();
                    result = result * 59 + ($swift == null ? 43 : ((Object)$swift).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    Zengin $zengin = this.getZengin();
                    result = result * 59 + ($zengin == null ? 43 : ((Object)$zengin).hashCode());
                    return result;
                }

                public static class Aba
                extends StripeObject {
                    @SerializedName(value="account_number")
                    String accountNumber;
                    @SerializedName(value="bank_name")
                    String bankName;
                    @SerializedName(value="routing_number")
                    String routingNumber;

                    @Generated
                    public String getAccountNumber() {
                        return this.accountNumber;
                    }

                    @Generated
                    public String getBankName() {
                        return this.bankName;
                    }

                    @Generated
                    public String getRoutingNumber() {
                        return this.routingNumber;
                    }

                    @Generated
                    public void setAccountNumber(String accountNumber) {
                        this.accountNumber = accountNumber;
                    }

                    @Generated
                    public void setBankName(String bankName) {
                        this.bankName = bankName;
                    }

                    @Generated
                    public void setRoutingNumber(String routingNumber) {
                        this.routingNumber = routingNumber;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Aba)) {
                            return false;
                        }
                        Aba other = (Aba)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$accountNumber = this.getAccountNumber();
                        String other$accountNumber = other.getAccountNumber();
                        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                            return false;
                        }
                        String this$bankName = this.getBankName();
                        String other$bankName = other.getBankName();
                        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                            return false;
                        }
                        String this$routingNumber = this.getRoutingNumber();
                        String other$routingNumber = other.getRoutingNumber();
                        return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Aba;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $accountNumber = this.getAccountNumber();
                        result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                        String $bankName = this.getBankName();
                        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                        String $routingNumber = this.getRoutingNumber();
                        result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                        return result;
                    }
                }

                public static class Iban
                extends StripeObject {
                    @SerializedName(value="account_holder_name")
                    String accountHolderName;
                    @SerializedName(value="bic")
                    String bic;
                    @SerializedName(value="country")
                    String country;
                    @SerializedName(value="iban")
                    String iban;

                    @Generated
                    public String getAccountHolderName() {
                        return this.accountHolderName;
                    }

                    @Generated
                    public String getBic() {
                        return this.bic;
                    }

                    @Generated
                    public String getCountry() {
                        return this.country;
                    }

                    @Generated
                    public String getIban() {
                        return this.iban;
                    }

                    @Generated
                    public void setAccountHolderName(String accountHolderName) {
                        this.accountHolderName = accountHolderName;
                    }

                    @Generated
                    public void setBic(String bic) {
                        this.bic = bic;
                    }

                    @Generated
                    public void setCountry(String country) {
                        this.country = country;
                    }

                    @Generated
                    public void setIban(String iban) {
                        this.iban = iban;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Iban)) {
                            return false;
                        }
                        Iban other = (Iban)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$accountHolderName = this.getAccountHolderName();
                        String other$accountHolderName = other.getAccountHolderName();
                        if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) {
                            return false;
                        }
                        String this$bic = this.getBic();
                        String other$bic = other.getBic();
                        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                            return false;
                        }
                        String this$country = this.getCountry();
                        String other$country = other.getCountry();
                        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                            return false;
                        }
                        String this$iban = this.getIban();
                        String other$iban = other.getIban();
                        return !(this$iban == null ? other$iban != null : !this$iban.equals(other$iban));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Iban;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $accountHolderName = this.getAccountHolderName();
                        result = result * 59 + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
                        String $bic = this.getBic();
                        result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                        String $country = this.getCountry();
                        result = result * 59 + ($country == null ? 43 : $country.hashCode());
                        String $iban = this.getIban();
                        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
                        return result;
                    }
                }

                public static class SortCode
                extends StripeObject {
                    @SerializedName(value="account_holder_name")
                    String accountHolderName;
                    @SerializedName(value="account_number")
                    String accountNumber;
                    @SerializedName(value="sort_code")
                    String sortCode;

                    @Generated
                    public String getAccountHolderName() {
                        return this.accountHolderName;
                    }

                    @Generated
                    public String getAccountNumber() {
                        return this.accountNumber;
                    }

                    @Generated
                    public String getSortCode() {
                        return this.sortCode;
                    }

                    @Generated
                    public void setAccountHolderName(String accountHolderName) {
                        this.accountHolderName = accountHolderName;
                    }

                    @Generated
                    public void setAccountNumber(String accountNumber) {
                        this.accountNumber = accountNumber;
                    }

                    @Generated
                    public void setSortCode(String sortCode) {
                        this.sortCode = sortCode;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof SortCode)) {
                            return false;
                        }
                        SortCode other = (SortCode)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$accountHolderName = this.getAccountHolderName();
                        String other$accountHolderName = other.getAccountHolderName();
                        if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) {
                            return false;
                        }
                        String this$accountNumber = this.getAccountNumber();
                        String other$accountNumber = other.getAccountNumber();
                        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                            return false;
                        }
                        String this$sortCode = this.getSortCode();
                        String other$sortCode = other.getSortCode();
                        return !(this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof SortCode;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $accountHolderName = this.getAccountHolderName();
                        result = result * 59 + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
                        String $accountNumber = this.getAccountNumber();
                        result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                        String $sortCode = this.getSortCode();
                        result = result * 59 + ($sortCode == null ? 43 : $sortCode.hashCode());
                        return result;
                    }
                }

                public static class Spei
                extends StripeObject {
                    @SerializedName(value="bank_code")
                    String bankCode;
                    @SerializedName(value="bank_name")
                    String bankName;
                    @SerializedName(value="clabe")
                    String clabe;

                    @Generated
                    public String getBankCode() {
                        return this.bankCode;
                    }

                    @Generated
                    public String getBankName() {
                        return this.bankName;
                    }

                    @Generated
                    public String getClabe() {
                        return this.clabe;
                    }

                    @Generated
                    public void setBankCode(String bankCode) {
                        this.bankCode = bankCode;
                    }

                    @Generated
                    public void setBankName(String bankName) {
                        this.bankName = bankName;
                    }

                    @Generated
                    public void setClabe(String clabe) {
                        this.clabe = clabe;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Spei)) {
                            return false;
                        }
                        Spei other = (Spei)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$bankCode = this.getBankCode();
                        String other$bankCode = other.getBankCode();
                        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                            return false;
                        }
                        String this$bankName = this.getBankName();
                        String other$bankName = other.getBankName();
                        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                            return false;
                        }
                        String this$clabe = this.getClabe();
                        String other$clabe = other.getClabe();
                        return !(this$clabe == null ? other$clabe != null : !this$clabe.equals(other$clabe));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Spei;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $bankCode = this.getBankCode();
                        result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                        String $bankName = this.getBankName();
                        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                        String $clabe = this.getClabe();
                        result = result * 59 + ($clabe == null ? 43 : $clabe.hashCode());
                        return result;
                    }
                }

                public static class Swift
                extends StripeObject {
                    @SerializedName(value="account_number")
                    String accountNumber;
                    @SerializedName(value="bank_name")
                    String bankName;
                    @SerializedName(value="swift_code")
                    String swiftCode;

                    @Generated
                    public String getAccountNumber() {
                        return this.accountNumber;
                    }

                    @Generated
                    public String getBankName() {
                        return this.bankName;
                    }

                    @Generated
                    public String getSwiftCode() {
                        return this.swiftCode;
                    }

                    @Generated
                    public void setAccountNumber(String accountNumber) {
                        this.accountNumber = accountNumber;
                    }

                    @Generated
                    public void setBankName(String bankName) {
                        this.bankName = bankName;
                    }

                    @Generated
                    public void setSwiftCode(String swiftCode) {
                        this.swiftCode = swiftCode;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Swift)) {
                            return false;
                        }
                        Swift other = (Swift)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$accountNumber = this.getAccountNumber();
                        String other$accountNumber = other.getAccountNumber();
                        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                            return false;
                        }
                        String this$bankName = this.getBankName();
                        String other$bankName = other.getBankName();
                        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                            return false;
                        }
                        String this$swiftCode = this.getSwiftCode();
                        String other$swiftCode = other.getSwiftCode();
                        return !(this$swiftCode == null ? other$swiftCode != null : !this$swiftCode.equals(other$swiftCode));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Swift;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $accountNumber = this.getAccountNumber();
                        result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                        String $bankName = this.getBankName();
                        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                        String $swiftCode = this.getSwiftCode();
                        result = result * 59 + ($swiftCode == null ? 43 : $swiftCode.hashCode());
                        return result;
                    }
                }

                public static class Zengin
                extends StripeObject {
                    @SerializedName(value="account_holder_name")
                    String accountHolderName;
                    @SerializedName(value="account_number")
                    String accountNumber;
                    @SerializedName(value="account_type")
                    String accountType;
                    @SerializedName(value="bank_code")
                    String bankCode;
                    @SerializedName(value="bank_name")
                    String bankName;
                    @SerializedName(value="branch_code")
                    String branchCode;
                    @SerializedName(value="branch_name")
                    String branchName;

                    @Generated
                    public String getAccountHolderName() {
                        return this.accountHolderName;
                    }

                    @Generated
                    public String getAccountNumber() {
                        return this.accountNumber;
                    }

                    @Generated
                    public String getAccountType() {
                        return this.accountType;
                    }

                    @Generated
                    public String getBankCode() {
                        return this.bankCode;
                    }

                    @Generated
                    public String getBankName() {
                        return this.bankName;
                    }

                    @Generated
                    public String getBranchCode() {
                        return this.branchCode;
                    }

                    @Generated
                    public String getBranchName() {
                        return this.branchName;
                    }

                    @Generated
                    public void setAccountHolderName(String accountHolderName) {
                        this.accountHolderName = accountHolderName;
                    }

                    @Generated
                    public void setAccountNumber(String accountNumber) {
                        this.accountNumber = accountNumber;
                    }

                    @Generated
                    public void setAccountType(String accountType) {
                        this.accountType = accountType;
                    }

                    @Generated
                    public void setBankCode(String bankCode) {
                        this.bankCode = bankCode;
                    }

                    @Generated
                    public void setBankName(String bankName) {
                        this.bankName = bankName;
                    }

                    @Generated
                    public void setBranchCode(String branchCode) {
                        this.branchCode = branchCode;
                    }

                    @Generated
                    public void setBranchName(String branchName) {
                        this.branchName = branchName;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Zengin)) {
                            return false;
                        }
                        Zengin other = (Zengin)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$accountHolderName = this.getAccountHolderName();
                        String other$accountHolderName = other.getAccountHolderName();
                        if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) {
                            return false;
                        }
                        String this$accountNumber = this.getAccountNumber();
                        String other$accountNumber = other.getAccountNumber();
                        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                            return false;
                        }
                        String this$accountType = this.getAccountType();
                        String other$accountType = other.getAccountType();
                        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                            return false;
                        }
                        String this$bankCode = this.getBankCode();
                        String other$bankCode = other.getBankCode();
                        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                            return false;
                        }
                        String this$bankName = this.getBankName();
                        String other$bankName = other.getBankName();
                        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                            return false;
                        }
                        String this$branchCode = this.getBranchCode();
                        String other$branchCode = other.getBranchCode();
                        if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) {
                            return false;
                        }
                        String this$branchName = this.getBranchName();
                        String other$branchName = other.getBranchName();
                        return !(this$branchName == null ? other$branchName != null : !this$branchName.equals(other$branchName));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Zengin;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $accountHolderName = this.getAccountHolderName();
                        result = result * 59 + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
                        String $accountNumber = this.getAccountNumber();
                        result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                        String $accountType = this.getAccountType();
                        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                        String $bankCode = this.getBankCode();
                        result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                        String $bankName = this.getBankName();
                        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                        String $branchCode = this.getBranchCode();
                        result = result * 59 + ($branchCode == null ? 43 : $branchCode.hashCode());
                        String $branchName = this.getBranchName();
                        result = result * 59 + ($branchName == null ? 43 : $branchName.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class KonbiniDisplayDetails
        extends StripeObject {
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="hosted_voucher_url")
            String hostedVoucherUrl;
            @SerializedName(value="stores")
            Stores stores;

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public String getHostedVoucherUrl() {
                return this.hostedVoucherUrl;
            }

            @Generated
            public Stores getStores() {
                return this.stores;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public void setHostedVoucherUrl(String hostedVoucherUrl) {
                this.hostedVoucherUrl = hostedVoucherUrl;
            }

            @Generated
            public void setStores(Stores stores) {
                this.stores = stores;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KonbiniDisplayDetails)) {
                    return false;
                }
                KonbiniDisplayDetails other = (KonbiniDisplayDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                String this$hostedVoucherUrl = this.getHostedVoucherUrl();
                String other$hostedVoucherUrl = other.getHostedVoucherUrl();
                if (this$hostedVoucherUrl == null ? other$hostedVoucherUrl != null : !this$hostedVoucherUrl.equals(other$hostedVoucherUrl)) {
                    return false;
                }
                Stores this$stores = this.getStores();
                Stores other$stores = other.getStores();
                return !(this$stores == null ? other$stores != null : !((Object)this$stores).equals(other$stores));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KonbiniDisplayDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                String $hostedVoucherUrl = this.getHostedVoucherUrl();
                result = result * 59 + ($hostedVoucherUrl == null ? 43 : $hostedVoucherUrl.hashCode());
                Stores $stores = this.getStores();
                result = result * 59 + ($stores == null ? 43 : ((Object)$stores).hashCode());
                return result;
            }

            public static class Stores
            extends StripeObject {
                @SerializedName(value="familymart")
                Familymart familymart;
                @SerializedName(value="lawson")
                Lawson lawson;
                @SerializedName(value="ministop")
                Ministop ministop;
                @SerializedName(value="seicomart")
                Seicomart seicomart;

                @Generated
                public Familymart getFamilymart() {
                    return this.familymart;
                }

                @Generated
                public Lawson getLawson() {
                    return this.lawson;
                }

                @Generated
                public Ministop getMinistop() {
                    return this.ministop;
                }

                @Generated
                public Seicomart getSeicomart() {
                    return this.seicomart;
                }

                @Generated
                public void setFamilymart(Familymart familymart) {
                    this.familymart = familymart;
                }

                @Generated
                public void setLawson(Lawson lawson) {
                    this.lawson = lawson;
                }

                @Generated
                public void setMinistop(Ministop ministop) {
                    this.ministop = ministop;
                }

                @Generated
                public void setSeicomart(Seicomart seicomart) {
                    this.seicomart = seicomart;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Stores)) {
                        return false;
                    }
                    Stores other = (Stores)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Familymart this$familymart = this.getFamilymart();
                    Familymart other$familymart = other.getFamilymart();
                    if (this$familymart == null ? other$familymart != null : !((Object)this$familymart).equals(other$familymart)) {
                        return false;
                    }
                    Lawson this$lawson = this.getLawson();
                    Lawson other$lawson = other.getLawson();
                    if (this$lawson == null ? other$lawson != null : !((Object)this$lawson).equals(other$lawson)) {
                        return false;
                    }
                    Ministop this$ministop = this.getMinistop();
                    Ministop other$ministop = other.getMinistop();
                    if (this$ministop == null ? other$ministop != null : !((Object)this$ministop).equals(other$ministop)) {
                        return false;
                    }
                    Seicomart this$seicomart = this.getSeicomart();
                    Seicomart other$seicomart = other.getSeicomart();
                    return !(this$seicomart == null ? other$seicomart != null : !((Object)this$seicomart).equals(other$seicomart));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Stores;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Familymart $familymart = this.getFamilymart();
                    result = result * 59 + ($familymart == null ? 43 : ((Object)$familymart).hashCode());
                    Lawson $lawson = this.getLawson();
                    result = result * 59 + ($lawson == null ? 43 : ((Object)$lawson).hashCode());
                    Ministop $ministop = this.getMinistop();
                    result = result * 59 + ($ministop == null ? 43 : ((Object)$ministop).hashCode());
                    Seicomart $seicomart = this.getSeicomart();
                    result = result * 59 + ($seicomart == null ? 43 : ((Object)$seicomart).hashCode());
                    return result;
                }

                public static class Familymart
                extends StripeObject {
                    @SerializedName(value="confirmation_number")
                    String confirmationNumber;
                    @SerializedName(value="payment_code")
                    String paymentCode;

                    @Generated
                    public String getConfirmationNumber() {
                        return this.confirmationNumber;
                    }

                    @Generated
                    public String getPaymentCode() {
                        return this.paymentCode;
                    }

                    @Generated
                    public void setConfirmationNumber(String confirmationNumber) {
                        this.confirmationNumber = confirmationNumber;
                    }

                    @Generated
                    public void setPaymentCode(String paymentCode) {
                        this.paymentCode = paymentCode;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Familymart)) {
                            return false;
                        }
                        Familymart other = (Familymart)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$confirmationNumber = this.getConfirmationNumber();
                        String other$confirmationNumber = other.getConfirmationNumber();
                        if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) {
                            return false;
                        }
                        String this$paymentCode = this.getPaymentCode();
                        String other$paymentCode = other.getPaymentCode();
                        return !(this$paymentCode == null ? other$paymentCode != null : !this$paymentCode.equals(other$paymentCode));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Familymart;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $confirmationNumber = this.getConfirmationNumber();
                        result = result * 59 + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
                        String $paymentCode = this.getPaymentCode();
                        result = result * 59 + ($paymentCode == null ? 43 : $paymentCode.hashCode());
                        return result;
                    }
                }

                public static class Lawson
                extends StripeObject {
                    @SerializedName(value="confirmation_number")
                    String confirmationNumber;
                    @SerializedName(value="payment_code")
                    String paymentCode;

                    @Generated
                    public String getConfirmationNumber() {
                        return this.confirmationNumber;
                    }

                    @Generated
                    public String getPaymentCode() {
                        return this.paymentCode;
                    }

                    @Generated
                    public void setConfirmationNumber(String confirmationNumber) {
                        this.confirmationNumber = confirmationNumber;
                    }

                    @Generated
                    public void setPaymentCode(String paymentCode) {
                        this.paymentCode = paymentCode;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Lawson)) {
                            return false;
                        }
                        Lawson other = (Lawson)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$confirmationNumber = this.getConfirmationNumber();
                        String other$confirmationNumber = other.getConfirmationNumber();
                        if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) {
                            return false;
                        }
                        String this$paymentCode = this.getPaymentCode();
                        String other$paymentCode = other.getPaymentCode();
                        return !(this$paymentCode == null ? other$paymentCode != null : !this$paymentCode.equals(other$paymentCode));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Lawson;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $confirmationNumber = this.getConfirmationNumber();
                        result = result * 59 + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
                        String $paymentCode = this.getPaymentCode();
                        result = result * 59 + ($paymentCode == null ? 43 : $paymentCode.hashCode());
                        return result;
                    }
                }

                public static class Ministop
                extends StripeObject {
                    @SerializedName(value="confirmation_number")
                    String confirmationNumber;
                    @SerializedName(value="payment_code")
                    String paymentCode;

                    @Generated
                    public String getConfirmationNumber() {
                        return this.confirmationNumber;
                    }

                    @Generated
                    public String getPaymentCode() {
                        return this.paymentCode;
                    }

                    @Generated
                    public void setConfirmationNumber(String confirmationNumber) {
                        this.confirmationNumber = confirmationNumber;
                    }

                    @Generated
                    public void setPaymentCode(String paymentCode) {
                        this.paymentCode = paymentCode;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Ministop)) {
                            return false;
                        }
                        Ministop other = (Ministop)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$confirmationNumber = this.getConfirmationNumber();
                        String other$confirmationNumber = other.getConfirmationNumber();
                        if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) {
                            return false;
                        }
                        String this$paymentCode = this.getPaymentCode();
                        String other$paymentCode = other.getPaymentCode();
                        return !(this$paymentCode == null ? other$paymentCode != null : !this$paymentCode.equals(other$paymentCode));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Ministop;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $confirmationNumber = this.getConfirmationNumber();
                        result = result * 59 + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
                        String $paymentCode = this.getPaymentCode();
                        result = result * 59 + ($paymentCode == null ? 43 : $paymentCode.hashCode());
                        return result;
                    }
                }

                public static class Seicomart
                extends StripeObject {
                    @SerializedName(value="confirmation_number")
                    String confirmationNumber;
                    @SerializedName(value="payment_code")
                    String paymentCode;

                    @Generated
                    public String getConfirmationNumber() {
                        return this.confirmationNumber;
                    }

                    @Generated
                    public String getPaymentCode() {
                        return this.paymentCode;
                    }

                    @Generated
                    public void setConfirmationNumber(String confirmationNumber) {
                        this.confirmationNumber = confirmationNumber;
                    }

                    @Generated
                    public void setPaymentCode(String paymentCode) {
                        this.paymentCode = paymentCode;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Seicomart)) {
                            return false;
                        }
                        Seicomart other = (Seicomart)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$confirmationNumber = this.getConfirmationNumber();
                        String other$confirmationNumber = other.getConfirmationNumber();
                        if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) {
                            return false;
                        }
                        String this$paymentCode = this.getPaymentCode();
                        String other$paymentCode = other.getPaymentCode();
                        return !(this$paymentCode == null ? other$paymentCode != null : !this$paymentCode.equals(other$paymentCode));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Seicomart;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $confirmationNumber = this.getConfirmationNumber();
                        result = result * 59 + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
                        String $paymentCode = this.getPaymentCode();
                        result = result * 59 + ($paymentCode == null ? 43 : $paymentCode.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class OxxoDisplayDetails
        extends StripeObject {
            @SerializedName(value="expires_after")
            Long expiresAfter;
            @SerializedName(value="hosted_voucher_url")
            String hostedVoucherUrl;
            @SerializedName(value="number")
            String number;

            @Generated
            public Long getExpiresAfter() {
                return this.expiresAfter;
            }

            @Generated
            public String getHostedVoucherUrl() {
                return this.hostedVoucherUrl;
            }

            @Generated
            public String getNumber() {
                return this.number;
            }

            @Generated
            public void setExpiresAfter(Long expiresAfter) {
                this.expiresAfter = expiresAfter;
            }

            @Generated
            public void setHostedVoucherUrl(String hostedVoucherUrl) {
                this.hostedVoucherUrl = hostedVoucherUrl;
            }

            @Generated
            public void setNumber(String number) {
                this.number = number;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OxxoDisplayDetails)) {
                    return false;
                }
                OxxoDisplayDetails other = (OxxoDisplayDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfter = this.getExpiresAfter();
                Long other$expiresAfter = other.getExpiresAfter();
                if (this$expiresAfter == null ? other$expiresAfter != null : !((Object)this$expiresAfter).equals(other$expiresAfter)) {
                    return false;
                }
                String this$hostedVoucherUrl = this.getHostedVoucherUrl();
                String other$hostedVoucherUrl = other.getHostedVoucherUrl();
                if (this$hostedVoucherUrl == null ? other$hostedVoucherUrl != null : !this$hostedVoucherUrl.equals(other$hostedVoucherUrl)) {
                    return false;
                }
                String this$number = this.getNumber();
                String other$number = other.getNumber();
                return !(this$number == null ? other$number != null : !this$number.equals(other$number));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof OxxoDisplayDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfter = this.getExpiresAfter();
                result = result * 59 + ($expiresAfter == null ? 43 : ((Object)$expiresAfter).hashCode());
                String $hostedVoucherUrl = this.getHostedVoucherUrl();
                result = result * 59 + ($hostedVoucherUrl == null ? 43 : $hostedVoucherUrl.hashCode());
                String $number = this.getNumber();
                result = result * 59 + ($number == null ? 43 : $number.hashCode());
                return result;
            }
        }

        public static class PaynowDisplayQrCode
        extends StripeObject {
            @SerializedName(value="data")
            String data;
            @SerializedName(value="hosted_instructions_url")
            String hostedInstructionsUrl;
            @SerializedName(value="image_url_png")
            String imageUrlPng;
            @SerializedName(value="image_url_svg")
            String imageUrlSvg;

            @Generated
            public String getData() {
                return this.data;
            }

            @Generated
            public String getHostedInstructionsUrl() {
                return this.hostedInstructionsUrl;
            }

            @Generated
            public String getImageUrlPng() {
                return this.imageUrlPng;
            }

            @Generated
            public String getImageUrlSvg() {
                return this.imageUrlSvg;
            }

            @Generated
            public void setData(String data) {
                this.data = data;
            }

            @Generated
            public void setHostedInstructionsUrl(String hostedInstructionsUrl) {
                this.hostedInstructionsUrl = hostedInstructionsUrl;
            }

            @Generated
            public void setImageUrlPng(String imageUrlPng) {
                this.imageUrlPng = imageUrlPng;
            }

            @Generated
            public void setImageUrlSvg(String imageUrlSvg) {
                this.imageUrlSvg = imageUrlSvg;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaynowDisplayQrCode)) {
                    return false;
                }
                PaynowDisplayQrCode other = (PaynowDisplayQrCode)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$data = this.getData();
                String other$data = other.getData();
                if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                    return false;
                }
                String this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
                String other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
                if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) {
                    return false;
                }
                String this$imageUrlPng = this.getImageUrlPng();
                String other$imageUrlPng = other.getImageUrlPng();
                if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) {
                    return false;
                }
                String this$imageUrlSvg = this.getImageUrlSvg();
                String other$imageUrlSvg = other.getImageUrlSvg();
                return !(this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaynowDisplayQrCode;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $data = this.getData();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                String $hostedInstructionsUrl = this.getHostedInstructionsUrl();
                result = result * 59 + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
                String $imageUrlPng = this.getImageUrlPng();
                result = result * 59 + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
                String $imageUrlSvg = this.getImageUrlSvg();
                result = result * 59 + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
                return result;
            }
        }

        public static class PixDisplayQrCode
        extends StripeObject {
            @SerializedName(value="data")
            String data;
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="hosted_instructions_url")
            String hostedInstructionsUrl;
            @SerializedName(value="image_url_png")
            String imageUrlPng;
            @SerializedName(value="image_url_svg")
            String imageUrlSvg;

            @Generated
            public String getData() {
                return this.data;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public String getHostedInstructionsUrl() {
                return this.hostedInstructionsUrl;
            }

            @Generated
            public String getImageUrlPng() {
                return this.imageUrlPng;
            }

            @Generated
            public String getImageUrlSvg() {
                return this.imageUrlSvg;
            }

            @Generated
            public void setData(String data) {
                this.data = data;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public void setHostedInstructionsUrl(String hostedInstructionsUrl) {
                this.hostedInstructionsUrl = hostedInstructionsUrl;
            }

            @Generated
            public void setImageUrlPng(String imageUrlPng) {
                this.imageUrlPng = imageUrlPng;
            }

            @Generated
            public void setImageUrlSvg(String imageUrlSvg) {
                this.imageUrlSvg = imageUrlSvg;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PixDisplayQrCode)) {
                    return false;
                }
                PixDisplayQrCode other = (PixDisplayQrCode)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                String this$data = this.getData();
                String other$data = other.getData();
                if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                    return false;
                }
                String this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
                String other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
                if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) {
                    return false;
                }
                String this$imageUrlPng = this.getImageUrlPng();
                String other$imageUrlPng = other.getImageUrlPng();
                if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) {
                    return false;
                }
                String this$imageUrlSvg = this.getImageUrlSvg();
                String other$imageUrlSvg = other.getImageUrlSvg();
                return !(this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PixDisplayQrCode;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                String $data = this.getData();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                String $hostedInstructionsUrl = this.getHostedInstructionsUrl();
                result = result * 59 + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
                String $imageUrlPng = this.getImageUrlPng();
                result = result * 59 + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
                String $imageUrlSvg = this.getImageUrlSvg();
                result = result * 59 + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
                return result;
            }
        }

        public static class PromptpayDisplayQrCode
        extends StripeObject {
            @SerializedName(value="data")
            String data;
            @SerializedName(value="hosted_instructions_url")
            String hostedInstructionsUrl;
            @SerializedName(value="image_url_png")
            String imageUrlPng;
            @SerializedName(value="image_url_svg")
            String imageUrlSvg;

            @Generated
            public String getData() {
                return this.data;
            }

            @Generated
            public String getHostedInstructionsUrl() {
                return this.hostedInstructionsUrl;
            }

            @Generated
            public String getImageUrlPng() {
                return this.imageUrlPng;
            }

            @Generated
            public String getImageUrlSvg() {
                return this.imageUrlSvg;
            }

            @Generated
            public void setData(String data) {
                this.data = data;
            }

            @Generated
            public void setHostedInstructionsUrl(String hostedInstructionsUrl) {
                this.hostedInstructionsUrl = hostedInstructionsUrl;
            }

            @Generated
            public void setImageUrlPng(String imageUrlPng) {
                this.imageUrlPng = imageUrlPng;
            }

            @Generated
            public void setImageUrlSvg(String imageUrlSvg) {
                this.imageUrlSvg = imageUrlSvg;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PromptpayDisplayQrCode)) {
                    return false;
                }
                PromptpayDisplayQrCode other = (PromptpayDisplayQrCode)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$data = this.getData();
                String other$data = other.getData();
                if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                    return false;
                }
                String this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
                String other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
                if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) {
                    return false;
                }
                String this$imageUrlPng = this.getImageUrlPng();
                String other$imageUrlPng = other.getImageUrlPng();
                if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) {
                    return false;
                }
                String this$imageUrlSvg = this.getImageUrlSvg();
                String other$imageUrlSvg = other.getImageUrlSvg();
                return !(this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PromptpayDisplayQrCode;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $data = this.getData();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                String $hostedInstructionsUrl = this.getHostedInstructionsUrl();
                result = result * 59 + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
                String $imageUrlPng = this.getImageUrlPng();
                result = result * 59 + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
                String $imageUrlSvg = this.getImageUrlSvg();
                result = result * 59 + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
                return result;
            }
        }

        public static class RedirectToUrl
        extends StripeObject {
            @SerializedName(value="return_url")
            String returnUrl;
            @SerializedName(value="url")
            String url;

            @Generated
            public String getReturnUrl() {
                return this.returnUrl;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setReturnUrl(String returnUrl) {
                this.returnUrl = returnUrl;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RedirectToUrl)) {
                    return false;
                }
                RedirectToUrl other = (RedirectToUrl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$returnUrl = this.getReturnUrl();
                String other$returnUrl = other.getReturnUrl();
                if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RedirectToUrl;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $returnUrl = this.getReturnUrl();
                result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }

        public static class SwishHandleRedirectOrDisplayQrCode
        extends StripeObject {
            @SerializedName(value="hosted_instructions_url")
            String hostedInstructionsUrl;
            @SerializedName(value="mobile_auth_url")
            String mobileAuthUrl;
            @SerializedName(value="qr_code")
            QrCode qrCode;

            @Generated
            public String getHostedInstructionsUrl() {
                return this.hostedInstructionsUrl;
            }

            @Generated
            public String getMobileAuthUrl() {
                return this.mobileAuthUrl;
            }

            @Generated
            public QrCode getQrCode() {
                return this.qrCode;
            }

            @Generated
            public void setHostedInstructionsUrl(String hostedInstructionsUrl) {
                this.hostedInstructionsUrl = hostedInstructionsUrl;
            }

            @Generated
            public void setMobileAuthUrl(String mobileAuthUrl) {
                this.mobileAuthUrl = mobileAuthUrl;
            }

            @Generated
            public void setQrCode(QrCode qrCode) {
                this.qrCode = qrCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SwishHandleRedirectOrDisplayQrCode)) {
                    return false;
                }
                SwishHandleRedirectOrDisplayQrCode other = (SwishHandleRedirectOrDisplayQrCode)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
                String other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
                if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) {
                    return false;
                }
                String this$mobileAuthUrl = this.getMobileAuthUrl();
                String other$mobileAuthUrl = other.getMobileAuthUrl();
                if (this$mobileAuthUrl == null ? other$mobileAuthUrl != null : !this$mobileAuthUrl.equals(other$mobileAuthUrl)) {
                    return false;
                }
                QrCode this$qrCode = this.getQrCode();
                QrCode other$qrCode = other.getQrCode();
                return !(this$qrCode == null ? other$qrCode != null : !((Object)this$qrCode).equals(other$qrCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SwishHandleRedirectOrDisplayQrCode;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $hostedInstructionsUrl = this.getHostedInstructionsUrl();
                result = result * 59 + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
                String $mobileAuthUrl = this.getMobileAuthUrl();
                result = result * 59 + ($mobileAuthUrl == null ? 43 : $mobileAuthUrl.hashCode());
                QrCode $qrCode = this.getQrCode();
                result = result * 59 + ($qrCode == null ? 43 : ((Object)$qrCode).hashCode());
                return result;
            }

            public static class QrCode
            extends StripeObject {
                @SerializedName(value="data")
                String data;
                @SerializedName(value="image_url_png")
                String imageUrlPng;
                @SerializedName(value="image_url_svg")
                String imageUrlSvg;

                @Generated
                public String getData() {
                    return this.data;
                }

                @Generated
                public String getImageUrlPng() {
                    return this.imageUrlPng;
                }

                @Generated
                public String getImageUrlSvg() {
                    return this.imageUrlSvg;
                }

                @Generated
                public void setData(String data) {
                    this.data = data;
                }

                @Generated
                public void setImageUrlPng(String imageUrlPng) {
                    this.imageUrlPng = imageUrlPng;
                }

                @Generated
                public void setImageUrlSvg(String imageUrlSvg) {
                    this.imageUrlSvg = imageUrlSvg;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof QrCode)) {
                        return false;
                    }
                    QrCode other = (QrCode)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$data = this.getData();
                    String other$data = other.getData();
                    if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                        return false;
                    }
                    String this$imageUrlPng = this.getImageUrlPng();
                    String other$imageUrlPng = other.getImageUrlPng();
                    if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) {
                        return false;
                    }
                    String this$imageUrlSvg = this.getImageUrlSvg();
                    String other$imageUrlSvg = other.getImageUrlSvg();
                    return !(this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof QrCode;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $data = this.getData();
                    result = result * 59 + ($data == null ? 43 : $data.hashCode());
                    String $imageUrlPng = this.getImageUrlPng();
                    result = result * 59 + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
                    String $imageUrlSvg = this.getImageUrlSvg();
                    result = result * 59 + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
                    return result;
                }
            }
        }

        public static class VerifyWithMicrodeposits
        extends StripeObject {
            @SerializedName(value="arrival_date")
            Long arrivalDate;
            @SerializedName(value="hosted_verification_url")
            String hostedVerificationUrl;
            @SerializedName(value="microdeposit_type")
            String microdepositType;

            @Generated
            public Long getArrivalDate() {
                return this.arrivalDate;
            }

            @Generated
            public String getHostedVerificationUrl() {
                return this.hostedVerificationUrl;
            }

            @Generated
            public String getMicrodepositType() {
                return this.microdepositType;
            }

            @Generated
            public void setArrivalDate(Long arrivalDate) {
                this.arrivalDate = arrivalDate;
            }

            @Generated
            public void setHostedVerificationUrl(String hostedVerificationUrl) {
                this.hostedVerificationUrl = hostedVerificationUrl;
            }

            @Generated
            public void setMicrodepositType(String microdepositType) {
                this.microdepositType = microdepositType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof VerifyWithMicrodeposits)) {
                    return false;
                }
                VerifyWithMicrodeposits other = (VerifyWithMicrodeposits)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$arrivalDate = this.getArrivalDate();
                Long other$arrivalDate = other.getArrivalDate();
                if (this$arrivalDate == null ? other$arrivalDate != null : !((Object)this$arrivalDate).equals(other$arrivalDate)) {
                    return false;
                }
                String this$hostedVerificationUrl = this.getHostedVerificationUrl();
                String other$hostedVerificationUrl = other.getHostedVerificationUrl();
                if (this$hostedVerificationUrl == null ? other$hostedVerificationUrl != null : !this$hostedVerificationUrl.equals(other$hostedVerificationUrl)) {
                    return false;
                }
                String this$microdepositType = this.getMicrodepositType();
                String other$microdepositType = other.getMicrodepositType();
                return !(this$microdepositType == null ? other$microdepositType != null : !this$microdepositType.equals(other$microdepositType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof VerifyWithMicrodeposits;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $arrivalDate = this.getArrivalDate();
                result = result * 59 + ($arrivalDate == null ? 43 : ((Object)$arrivalDate).hashCode());
                String $hostedVerificationUrl = this.getHostedVerificationUrl();
                result = result * 59 + ($hostedVerificationUrl == null ? 43 : $hostedVerificationUrl.hashCode());
                String $microdepositType = this.getMicrodepositType();
                result = result * 59 + ($microdepositType == null ? 43 : $microdepositType.hashCode());
                return result;
            }
        }

        public static class WechatPayDisplayQrCode
        extends StripeObject {
            @SerializedName(value="data")
            String data;
            @SerializedName(value="hosted_instructions_url")
            String hostedInstructionsUrl;
            @SerializedName(value="image_data_url")
            String imageDataUrl;
            @SerializedName(value="image_url_png")
            String imageUrlPng;
            @SerializedName(value="image_url_svg")
            String imageUrlSvg;

            @Generated
            public String getData() {
                return this.data;
            }

            @Generated
            public String getHostedInstructionsUrl() {
                return this.hostedInstructionsUrl;
            }

            @Generated
            public String getImageDataUrl() {
                return this.imageDataUrl;
            }

            @Generated
            public String getImageUrlPng() {
                return this.imageUrlPng;
            }

            @Generated
            public String getImageUrlSvg() {
                return this.imageUrlSvg;
            }

            @Generated
            public void setData(String data) {
                this.data = data;
            }

            @Generated
            public void setHostedInstructionsUrl(String hostedInstructionsUrl) {
                this.hostedInstructionsUrl = hostedInstructionsUrl;
            }

            @Generated
            public void setImageDataUrl(String imageDataUrl) {
                this.imageDataUrl = imageDataUrl;
            }

            @Generated
            public void setImageUrlPng(String imageUrlPng) {
                this.imageUrlPng = imageUrlPng;
            }

            @Generated
            public void setImageUrlSvg(String imageUrlSvg) {
                this.imageUrlSvg = imageUrlSvg;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPayDisplayQrCode)) {
                    return false;
                }
                WechatPayDisplayQrCode other = (WechatPayDisplayQrCode)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$data = this.getData();
                String other$data = other.getData();
                if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                    return false;
                }
                String this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
                String other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
                if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) {
                    return false;
                }
                String this$imageDataUrl = this.getImageDataUrl();
                String other$imageDataUrl = other.getImageDataUrl();
                if (this$imageDataUrl == null ? other$imageDataUrl != null : !this$imageDataUrl.equals(other$imageDataUrl)) {
                    return false;
                }
                String this$imageUrlPng = this.getImageUrlPng();
                String other$imageUrlPng = other.getImageUrlPng();
                if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) {
                    return false;
                }
                String this$imageUrlSvg = this.getImageUrlSvg();
                String other$imageUrlSvg = other.getImageUrlSvg();
                return !(this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPayDisplayQrCode;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $data = this.getData();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                String $hostedInstructionsUrl = this.getHostedInstructionsUrl();
                result = result * 59 + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
                String $imageDataUrl = this.getImageDataUrl();
                result = result * 59 + ($imageDataUrl == null ? 43 : $imageDataUrl.hashCode());
                String $imageUrlPng = this.getImageUrlPng();
                result = result * 59 + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
                String $imageUrlSvg = this.getImageUrlSvg();
                result = result * 59 + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
                return result;
            }
        }

        public static class WechatPayRedirectToAndroidApp
        extends StripeObject {
            @SerializedName(value="app_id")
            String appId;
            @SerializedName(value="nonce_str")
            String nonceStr;
            @SerializedName(value="partner_id")
            String partnerId;
            @SerializedName(value="prepay_id")
            String prepayId;
            @SerializedName(value="sign")
            String sign;
            @SerializedName(value="timestamp")
            String timestamp;
            @SerializedName(value="package")
            String package_;

            public String getPackage() {
                return this.package_;
            }

            public void setPackage(String package_) {
                this.package_ = package_;
            }

            @Generated
            public String getAppId() {
                return this.appId;
            }

            @Generated
            public String getNonceStr() {
                return this.nonceStr;
            }

            @Generated
            public String getPartnerId() {
                return this.partnerId;
            }

            @Generated
            public String getPrepayId() {
                return this.prepayId;
            }

            @Generated
            public String getSign() {
                return this.sign;
            }

            @Generated
            public String getTimestamp() {
                return this.timestamp;
            }

            @Generated
            public String getPackage_() {
                return this.package_;
            }

            @Generated
            public void setAppId(String appId) {
                this.appId = appId;
            }

            @Generated
            public void setNonceStr(String nonceStr) {
                this.nonceStr = nonceStr;
            }

            @Generated
            public void setPartnerId(String partnerId) {
                this.partnerId = partnerId;
            }

            @Generated
            public void setPrepayId(String prepayId) {
                this.prepayId = prepayId;
            }

            @Generated
            public void setSign(String sign) {
                this.sign = sign;
            }

            @Generated
            public void setTimestamp(String timestamp) {
                this.timestamp = timestamp;
            }

            @Generated
            public void setPackage_(String package_) {
                this.package_ = package_;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPayRedirectToAndroidApp)) {
                    return false;
                }
                WechatPayRedirectToAndroidApp other = (WechatPayRedirectToAndroidApp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$appId = this.getAppId();
                String other$appId = other.getAppId();
                if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                    return false;
                }
                String this$nonceStr = this.getNonceStr();
                String other$nonceStr = other.getNonceStr();
                if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
                    return false;
                }
                String this$partnerId = this.getPartnerId();
                String other$partnerId = other.getPartnerId();
                if (this$partnerId == null ? other$partnerId != null : !this$partnerId.equals(other$partnerId)) {
                    return false;
                }
                String this$prepayId = this.getPrepayId();
                String other$prepayId = other.getPrepayId();
                if (this$prepayId == null ? other$prepayId != null : !this$prepayId.equals(other$prepayId)) {
                    return false;
                }
                String this$sign = this.getSign();
                String other$sign = other.getSign();
                if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
                    return false;
                }
                String this$timestamp = this.getTimestamp();
                String other$timestamp = other.getTimestamp();
                if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                    return false;
                }
                String this$package_ = this.getPackage_();
                String other$package_ = other.getPackage_();
                return !(this$package_ == null ? other$package_ != null : !this$package_.equals(other$package_));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPayRedirectToAndroidApp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $appId = this.getAppId();
                result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
                String $nonceStr = this.getNonceStr();
                result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
                String $partnerId = this.getPartnerId();
                result = result * 59 + ($partnerId == null ? 43 : $partnerId.hashCode());
                String $prepayId = this.getPrepayId();
                result = result * 59 + ($prepayId == null ? 43 : $prepayId.hashCode());
                String $sign = this.getSign();
                result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
                String $timestamp = this.getTimestamp();
                result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
                String $package_ = this.getPackage_();
                result = result * 59 + ($package_ == null ? 43 : $package_.hashCode());
                return result;
            }
        }

        public static class WechatPayRedirectToIosApp
        extends StripeObject {
            @SerializedName(value="native_url")
            String nativeUrl;

            @Generated
            public String getNativeUrl() {
                return this.nativeUrl;
            }

            @Generated
            public void setNativeUrl(String nativeUrl) {
                this.nativeUrl = nativeUrl;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPayRedirectToIosApp)) {
                    return false;
                }
                WechatPayRedirectToIosApp other = (WechatPayRedirectToIosApp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$nativeUrl = this.getNativeUrl();
                String other$nativeUrl = other.getNativeUrl();
                return !(this$nativeUrl == null ? other$nativeUrl != null : !this$nativeUrl.equals(other$nativeUrl));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPayRedirectToIosApp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $nativeUrl = this.getNativeUrl();
                result = result * 59 + ($nativeUrl == null ? 43 : $nativeUrl.hashCode());
                return result;
            }
        }
    }

    public static class PaymentMethodConfigurationDetails
    extends StripeObject
    implements HasId {
        @SerializedName(value="id")
        String id;
        @SerializedName(value="parent")
        String parent;

        @Generated
        public String getParent() {
            return this.parent;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setParent(String parent) {
            this.parent = parent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodConfigurationDetails)) {
                return false;
            }
            PaymentMethodConfigurationDetails other = (PaymentMethodConfigurationDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$parent = this.getParent();
            String other$parent = other.getParent();
            return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodConfigurationDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }
    }

    public static class PaymentMethodOptions
    extends StripeObject {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="affirm")
        Affirm affirm;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="amazon_pay")
        AmazonPay amazonPay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="blik")
        Blik blik;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="card_present")
        CardPresent cardPresent;
        @SerializedName(value="cashapp")
        Cashapp cashapp;
        @SerializedName(value="customer_balance")
        CustomerBalance customerBalance;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="interac_present")
        InteracPresent interacPresent;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="konbini")
        Konbini konbini;
        @SerializedName(value="link")
        Link link;
        @SerializedName(value="mobilepay")
        Mobilepay mobilepay;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="paynow")
        Paynow paynow;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="pix")
        Pix pix;
        @SerializedName(value="promptpay")
        Promptpay promptpay;
        @SerializedName(value="revolut_pay")
        RevolutPay revolutPay;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="swish")
        Swish swish;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;
        @SerializedName(value="wechat_pay")
        WechatPay wechatPay;
        @SerializedName(value="zip")
        Zip zip;

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Affirm getAffirm() {
            return this.affirm;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AmazonPay getAmazonPay() {
            return this.amazonPay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Blik getBlik() {
            return this.blik;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public CardPresent getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Cashapp getCashapp() {
            return this.cashapp;
        }

        @Generated
        public CustomerBalance getCustomerBalance() {
            return this.customerBalance;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public InteracPresent getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Konbini getKonbini() {
            return this.konbini;
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public Mobilepay getMobilepay() {
            return this.mobilepay;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public Paynow getPaynow() {
            return this.paynow;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public Pix getPix() {
            return this.pix;
        }

        @Generated
        public Promptpay getPromptpay() {
            return this.promptpay;
        }

        @Generated
        public RevolutPay getRevolutPay() {
            return this.revolutPay;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public Swish getSwish() {
            return this.swish;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public WechatPay getWechatPay() {
            return this.wechatPay;
        }

        @Generated
        public Zip getZip() {
            return this.zip;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setAffirm(Affirm affirm) {
            this.affirm = affirm;
        }

        @Generated
        public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
            this.afterpayClearpay = afterpayClearpay;
        }

        @Generated
        public void setAlipay(Alipay alipay) {
            this.alipay = alipay;
        }

        @Generated
        public void setAmazonPay(AmazonPay amazonPay) {
            this.amazonPay = amazonPay;
        }

        @Generated
        public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
            this.auBecsDebit = auBecsDebit;
        }

        @Generated
        public void setBacsDebit(BacsDebit bacsDebit) {
            this.bacsDebit = bacsDebit;
        }

        @Generated
        public void setBancontact(Bancontact bancontact) {
            this.bancontact = bancontact;
        }

        @Generated
        public void setBlik(Blik blik) {
            this.blik = blik;
        }

        @Generated
        public void setBoleto(Boleto boleto) {
            this.boleto = boleto;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCardPresent(CardPresent cardPresent) {
            this.cardPresent = cardPresent;
        }

        @Generated
        public void setCashapp(Cashapp cashapp) {
            this.cashapp = cashapp;
        }

        @Generated
        public void setCustomerBalance(CustomerBalance customerBalance) {
            this.customerBalance = customerBalance;
        }

        @Generated
        public void setEps(Eps eps) {
            this.eps = eps;
        }

        @Generated
        public void setFpx(Fpx fpx) {
            this.fpx = fpx;
        }

        @Generated
        public void setGiropay(Giropay giropay) {
            this.giropay = giropay;
        }

        @Generated
        public void setGrabpay(Grabpay grabpay) {
            this.grabpay = grabpay;
        }

        @Generated
        public void setIdeal(Ideal ideal) {
            this.ideal = ideal;
        }

        @Generated
        public void setInteracPresent(InteracPresent interacPresent) {
            this.interacPresent = interacPresent;
        }

        @Generated
        public void setKlarna(Klarna klarna) {
            this.klarna = klarna;
        }

        @Generated
        public void setKonbini(Konbini konbini) {
            this.konbini = konbini;
        }

        @Generated
        public void setLink(Link link) {
            this.link = link;
        }

        @Generated
        public void setMobilepay(Mobilepay mobilepay) {
            this.mobilepay = mobilepay;
        }

        @Generated
        public void setOxxo(Oxxo oxxo) {
            this.oxxo = oxxo;
        }

        @Generated
        public void setP24(P24 p24) {
            this.p24 = p24;
        }

        @Generated
        public void setPaynow(Paynow paynow) {
            this.paynow = paynow;
        }

        @Generated
        public void setPaypal(Paypal paypal) {
            this.paypal = paypal;
        }

        @Generated
        public void setPix(Pix pix) {
            this.pix = pix;
        }

        @Generated
        public void setPromptpay(Promptpay promptpay) {
            this.promptpay = promptpay;
        }

        @Generated
        public void setRevolutPay(RevolutPay revolutPay) {
            this.revolutPay = revolutPay;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setSofort(Sofort sofort) {
            this.sofort = sofort;
        }

        @Generated
        public void setSwish(Swish swish) {
            this.swish = swish;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public void setWechatPay(WechatPay wechatPay) {
            this.wechatPay = wechatPay;
        }

        @Generated
        public void setZip(Zip zip) {
            this.zip = zip;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            Affirm this$affirm = this.getAffirm();
            Affirm other$affirm = other.getAffirm();
            if (this$affirm == null ? other$affirm != null : !((Object)this$affirm).equals(other$affirm)) {
                return false;
            }
            AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
            AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
            if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
                return false;
            }
            Alipay this$alipay = this.getAlipay();
            Alipay other$alipay = other.getAlipay();
            if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
                return false;
            }
            AmazonPay this$amazonPay = this.getAmazonPay();
            AmazonPay other$amazonPay = other.getAmazonPay();
            if (this$amazonPay == null ? other$amazonPay != null : !((Object)this$amazonPay).equals(other$amazonPay)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Bancontact this$bancontact = this.getBancontact();
            Bancontact other$bancontact = other.getBancontact();
            if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                return false;
            }
            Blik this$blik = this.getBlik();
            Blik other$blik = other.getBlik();
            if (this$blik == null ? other$blik != null : !((Object)this$blik).equals(other$blik)) {
                return false;
            }
            Boleto this$boleto = this.getBoleto();
            Boleto other$boleto = other.getBoleto();
            if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            CardPresent this$cardPresent = this.getCardPresent();
            CardPresent other$cardPresent = other.getCardPresent();
            if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
                return false;
            }
            Cashapp this$cashapp = this.getCashapp();
            Cashapp other$cashapp = other.getCashapp();
            if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
                return false;
            }
            CustomerBalance this$customerBalance = this.getCustomerBalance();
            CustomerBalance other$customerBalance = other.getCustomerBalance();
            if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
                return false;
            }
            Eps this$eps = this.getEps();
            Eps other$eps = other.getEps();
            if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
                return false;
            }
            Fpx this$fpx = this.getFpx();
            Fpx other$fpx = other.getFpx();
            if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
                return false;
            }
            Giropay this$giropay = this.getGiropay();
            Giropay other$giropay = other.getGiropay();
            if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
                return false;
            }
            Grabpay this$grabpay = this.getGrabpay();
            Grabpay other$grabpay = other.getGrabpay();
            if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
                return false;
            }
            Ideal this$ideal = this.getIdeal();
            Ideal other$ideal = other.getIdeal();
            if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
                return false;
            }
            InteracPresent this$interacPresent = this.getInteracPresent();
            InteracPresent other$interacPresent = other.getInteracPresent();
            if (this$interacPresent == null ? other$interacPresent != null : !((Object)this$interacPresent).equals(other$interacPresent)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            Konbini this$konbini = this.getKonbini();
            Konbini other$konbini = other.getKonbini();
            if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
                return false;
            }
            Link this$link = this.getLink();
            Link other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            Mobilepay this$mobilepay = this.getMobilepay();
            Mobilepay other$mobilepay = other.getMobilepay();
            if (this$mobilepay == null ? other$mobilepay != null : !((Object)this$mobilepay).equals(other$mobilepay)) {
                return false;
            }
            Oxxo this$oxxo = this.getOxxo();
            Oxxo other$oxxo = other.getOxxo();
            if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
                return false;
            }
            P24 this$p24 = this.getP24();
            P24 other$p24 = other.getP24();
            if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
                return false;
            }
            Paynow this$paynow = this.getPaynow();
            Paynow other$paynow = other.getPaynow();
            if (this$paynow == null ? other$paynow != null : !((Object)this$paynow).equals(other$paynow)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                return false;
            }
            Pix this$pix = this.getPix();
            Pix other$pix = other.getPix();
            if (this$pix == null ? other$pix != null : !((Object)this$pix).equals(other$pix)) {
                return false;
            }
            Promptpay this$promptpay = this.getPromptpay();
            Promptpay other$promptpay = other.getPromptpay();
            if (this$promptpay == null ? other$promptpay != null : !((Object)this$promptpay).equals(other$promptpay)) {
                return false;
            }
            RevolutPay this$revolutPay = this.getRevolutPay();
            RevolutPay other$revolutPay = other.getRevolutPay();
            if (this$revolutPay == null ? other$revolutPay != null : !((Object)this$revolutPay).equals(other$revolutPay)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            Sofort this$sofort = this.getSofort();
            Sofort other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                return false;
            }
            Swish this$swish = this.getSwish();
            Swish other$swish = other.getSwish();
            if (this$swish == null ? other$swish != null : !((Object)this$swish).equals(other$swish)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            if (this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount)) {
                return false;
            }
            WechatPay this$wechatPay = this.getWechatPay();
            WechatPay other$wechatPay = other.getWechatPay();
            if (this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay)) {
                return false;
            }
            Zip this$zip = this.getZip();
            Zip other$zip = other.getZip();
            return !(this$zip == null ? other$zip != null : !((Object)this$zip).equals(other$zip));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            Affirm $affirm = this.getAffirm();
            result = result * 59 + ($affirm == null ? 43 : ((Object)$affirm).hashCode());
            AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
            result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
            Alipay $alipay = this.getAlipay();
            result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
            AmazonPay $amazonPay = this.getAmazonPay();
            result = result * 59 + ($amazonPay == null ? 43 : ((Object)$amazonPay).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Bancontact $bancontact = this.getBancontact();
            result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
            Blik $blik = this.getBlik();
            result = result * 59 + ($blik == null ? 43 : ((Object)$blik).hashCode());
            Boleto $boleto = this.getBoleto();
            result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            CardPresent $cardPresent = this.getCardPresent();
            result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
            Cashapp $cashapp = this.getCashapp();
            result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
            CustomerBalance $customerBalance = this.getCustomerBalance();
            result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
            Eps $eps = this.getEps();
            result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
            Fpx $fpx = this.getFpx();
            result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
            Giropay $giropay = this.getGiropay();
            result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
            Grabpay $grabpay = this.getGrabpay();
            result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
            Ideal $ideal = this.getIdeal();
            result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
            InteracPresent $interacPresent = this.getInteracPresent();
            result = result * 59 + ($interacPresent == null ? 43 : ((Object)$interacPresent).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            Konbini $konbini = this.getKonbini();
            result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
            Link $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            Mobilepay $mobilepay = this.getMobilepay();
            result = result * 59 + ($mobilepay == null ? 43 : ((Object)$mobilepay).hashCode());
            Oxxo $oxxo = this.getOxxo();
            result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
            P24 $p24 = this.getP24();
            result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
            Paynow $paynow = this.getPaynow();
            result = result * 59 + ($paynow == null ? 43 : ((Object)$paynow).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            Pix $pix = this.getPix();
            result = result * 59 + ($pix == null ? 43 : ((Object)$pix).hashCode());
            Promptpay $promptpay = this.getPromptpay();
            result = result * 59 + ($promptpay == null ? 43 : ((Object)$promptpay).hashCode());
            RevolutPay $revolutPay = this.getRevolutPay();
            result = result * 59 + ($revolutPay == null ? 43 : ((Object)$revolutPay).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            Sofort $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
            Swish $swish = this.getSwish();
            result = result * 59 + ($swish == null ? 43 : ((Object)$swish).hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            WechatPay $wechatPay = this.getWechatPay();
            result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
            Zip $zip = this.getZip();
            result = result * 59 + ($zip == null ? 43 : ((Object)$zip).hashCode());
            return result;
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;
            @SerializedName(value="verification_method")
            String verificationMethod;

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public void setVerificationMethod(String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }

            public static class MandateOptions
            extends StripeObject {
                @SerializedName(value="custom_mandate_url")
                String customMandateUrl;
                @SerializedName(value="interval_description")
                String intervalDescription;
                @SerializedName(value="payment_schedule")
                String paymentSchedule;
                @SerializedName(value="transaction_type")
                String transactionType;

                @Generated
                public String getCustomMandateUrl() {
                    return this.customMandateUrl;
                }

                @Generated
                public String getIntervalDescription() {
                    return this.intervalDescription;
                }

                @Generated
                public String getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public String getTransactionType() {
                    return this.transactionType;
                }

                @Generated
                public void setCustomMandateUrl(String customMandateUrl) {
                    this.customMandateUrl = customMandateUrl;
                }

                @Generated
                public void setIntervalDescription(String intervalDescription) {
                    this.intervalDescription = intervalDescription;
                }

                @Generated
                public void setPaymentSchedule(String paymentSchedule) {
                    this.paymentSchedule = paymentSchedule;
                }

                @Generated
                public void setTransactionType(String transactionType) {
                    this.transactionType = transactionType;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$customMandateUrl = this.getCustomMandateUrl();
                    String other$customMandateUrl = other.getCustomMandateUrl();
                    if (this$customMandateUrl == null ? other$customMandateUrl != null : !this$customMandateUrl.equals(other$customMandateUrl)) {
                        return false;
                    }
                    String this$intervalDescription = this.getIntervalDescription();
                    String other$intervalDescription = other.getIntervalDescription();
                    if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) {
                        return false;
                    }
                    String this$paymentSchedule = this.getPaymentSchedule();
                    String other$paymentSchedule = other.getPaymentSchedule();
                    if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                        return false;
                    }
                    String this$transactionType = this.getTransactionType();
                    String other$transactionType = other.getTransactionType();
                    return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $customMandateUrl = this.getCustomMandateUrl();
                    result = result * 59 + ($customMandateUrl == null ? 43 : $customMandateUrl.hashCode());
                    String $intervalDescription = this.getIntervalDescription();
                    result = result * 59 + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
                    String $paymentSchedule = this.getPaymentSchedule();
                    result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                    String $transactionType = this.getTransactionType();
                    result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                    return result;
                }
            }
        }

        public static class Affirm
        extends StripeObject {
            @SerializedName(value="capture_method")
            String captureMethod;
            @SerializedName(value="preferred_locale")
            String preferredLocale;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public String getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setCaptureMethod(String captureMethod) {
                this.captureMethod = captureMethod;
            }

            @Generated
            public void setPreferredLocale(String preferredLocale) {
                this.preferredLocale = preferredLocale;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Affirm)) {
                    return false;
                }
                Affirm other = (Affirm)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$captureMethod = this.getCaptureMethod();
                String other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                String this$preferredLocale = this.getPreferredLocale();
                String other$preferredLocale = other.getPreferredLocale();
                if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Affirm;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                String $preferredLocale = this.getPreferredLocale();
                result = result * 59 + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class AfterpayClearpay
        extends StripeObject {
            @SerializedName(value="capture_method")
            String captureMethod;
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setCaptureMethod(String captureMethod) {
                this.captureMethod = captureMethod;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AfterpayClearpay)) {
                    return false;
                }
                AfterpayClearpay other = (AfterpayClearpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$captureMethod = this.getCaptureMethod();
                String other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AfterpayClearpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Alipay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alipay)) {
                    return false;
                }
                Alipay other = (Alipay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alipay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class AmazonPay
        extends StripeObject {
            @SerializedName(value="capture_method")
            String captureMethod;

            @Generated
            public String getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public void setCaptureMethod(String captureMethod) {
                this.captureMethod = captureMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AmazonPay)) {
                    return false;
                }
                AmazonPay other = (AmazonPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$captureMethod = this.getCaptureMethod();
                String other$captureMethod = other.getCaptureMethod();
                return !(this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AmazonPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                return result;
            }
        }

        public static class AuBecsDebit
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBecsDebit)) {
                    return false;
                }
                AuBecsDebit other = (AuBecsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBecsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class BacsDebit
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebit)) {
                    return false;
                }
                BacsDebit other = (BacsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Bancontact
        extends StripeObject {
            @SerializedName(value="preferred_language")
            String preferredLanguage;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setPreferredLanguage(String preferredLanguage) {
                this.preferredLanguage = preferredLanguage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bancontact)) {
                    return false;
                }
                Bancontact other = (Bancontact)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$preferredLanguage = this.getPreferredLanguage();
                String other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bancontact;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Blik
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Blik)) {
                    return false;
                }
                Blik other = (Blik)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Blik;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Boleto
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Boleto)) {
                    return false;
                }
                Boleto other = (Boleto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Boleto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="capture_method")
            String captureMethod;
            @SerializedName(value="installments")
            Installments installments;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="request_extended_authorization")
            String requestExtendedAuthorization;
            @SerializedName(value="request_incremental_authorization")
            String requestIncrementalAuthorization;
            @SerializedName(value="request_multicapture")
            String requestMulticapture;
            @SerializedName(value="request_overcapture")
            String requestOvercapture;
            @SerializedName(value="request_three_d_secure")
            String requestThreeDSecure;
            @SerializedName(value="require_cvc_recollection")
            Boolean requireCvcRecollection;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;
            @SerializedName(value="statement_descriptor_suffix_kana")
            String statementDescriptorSuffixKana;
            @SerializedName(value="statement_descriptor_suffix_kanji")
            String statementDescriptorSuffixKanji;

            @Generated
            public String getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Installments getInstallments() {
                return this.installments;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public String getRequestExtendedAuthorization() {
                return this.requestExtendedAuthorization;
            }

            @Generated
            public String getRequestIncrementalAuthorization() {
                return this.requestIncrementalAuthorization;
            }

            @Generated
            public String getRequestMulticapture() {
                return this.requestMulticapture;
            }

            @Generated
            public String getRequestOvercapture() {
                return this.requestOvercapture;
            }

            @Generated
            public String getRequestThreeDSecure() {
                return this.requestThreeDSecure;
            }

            @Generated
            public Boolean getRequireCvcRecollection() {
                return this.requireCvcRecollection;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getStatementDescriptorSuffixKana() {
                return this.statementDescriptorSuffixKana;
            }

            @Generated
            public String getStatementDescriptorSuffixKanji() {
                return this.statementDescriptorSuffixKanji;
            }

            @Generated
            public void setCaptureMethod(String captureMethod) {
                this.captureMethod = captureMethod;
            }

            @Generated
            public void setInstallments(Installments installments) {
                this.installments = installments;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setRequestExtendedAuthorization(String requestExtendedAuthorization) {
                this.requestExtendedAuthorization = requestExtendedAuthorization;
            }

            @Generated
            public void setRequestIncrementalAuthorization(String requestIncrementalAuthorization) {
                this.requestIncrementalAuthorization = requestIncrementalAuthorization;
            }

            @Generated
            public void setRequestMulticapture(String requestMulticapture) {
                this.requestMulticapture = requestMulticapture;
            }

            @Generated
            public void setRequestOvercapture(String requestOvercapture) {
                this.requestOvercapture = requestOvercapture;
            }

            @Generated
            public void setRequestThreeDSecure(String requestThreeDSecure) {
                this.requestThreeDSecure = requestThreeDSecure;
            }

            @Generated
            public void setRequireCvcRecollection(Boolean requireCvcRecollection) {
                this.requireCvcRecollection = requireCvcRecollection;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public void setStatementDescriptorSuffixKana(String statementDescriptorSuffixKana) {
                this.statementDescriptorSuffixKana = statementDescriptorSuffixKana;
            }

            @Generated
            public void setStatementDescriptorSuffixKanji(String statementDescriptorSuffixKanji) {
                this.statementDescriptorSuffixKanji = statementDescriptorSuffixKanji;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$requireCvcRecollection = this.getRequireCvcRecollection();
                Boolean other$requireCvcRecollection = other.getRequireCvcRecollection();
                if (this$requireCvcRecollection == null ? other$requireCvcRecollection != null : !((Object)this$requireCvcRecollection).equals(other$requireCvcRecollection)) {
                    return false;
                }
                String this$captureMethod = this.getCaptureMethod();
                String other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Installments this$installments = this.getInstallments();
                Installments other$installments = other.getInstallments();
                if (this$installments == null ? other$installments != null : !((Object)this$installments).equals(other$installments)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                String this$requestExtendedAuthorization = this.getRequestExtendedAuthorization();
                String other$requestExtendedAuthorization = other.getRequestExtendedAuthorization();
                if (this$requestExtendedAuthorization == null ? other$requestExtendedAuthorization != null : !this$requestExtendedAuthorization.equals(other$requestExtendedAuthorization)) {
                    return false;
                }
                String this$requestIncrementalAuthorization = this.getRequestIncrementalAuthorization();
                String other$requestIncrementalAuthorization = other.getRequestIncrementalAuthorization();
                if (this$requestIncrementalAuthorization == null ? other$requestIncrementalAuthorization != null : !this$requestIncrementalAuthorization.equals(other$requestIncrementalAuthorization)) {
                    return false;
                }
                String this$requestMulticapture = this.getRequestMulticapture();
                String other$requestMulticapture = other.getRequestMulticapture();
                if (this$requestMulticapture == null ? other$requestMulticapture != null : !this$requestMulticapture.equals(other$requestMulticapture)) {
                    return false;
                }
                String this$requestOvercapture = this.getRequestOvercapture();
                String other$requestOvercapture = other.getRequestOvercapture();
                if (this$requestOvercapture == null ? other$requestOvercapture != null : !this$requestOvercapture.equals(other$requestOvercapture)) {
                    return false;
                }
                String this$requestThreeDSecure = this.getRequestThreeDSecure();
                String other$requestThreeDSecure = other.getRequestThreeDSecure();
                if (this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$statementDescriptorSuffixKana = this.getStatementDescriptorSuffixKana();
                String other$statementDescriptorSuffixKana = other.getStatementDescriptorSuffixKana();
                if (this$statementDescriptorSuffixKana == null ? other$statementDescriptorSuffixKana != null : !this$statementDescriptorSuffixKana.equals(other$statementDescriptorSuffixKana)) {
                    return false;
                }
                String this$statementDescriptorSuffixKanji = this.getStatementDescriptorSuffixKanji();
                String other$statementDescriptorSuffixKanji = other.getStatementDescriptorSuffixKanji();
                return !(this$statementDescriptorSuffixKanji == null ? other$statementDescriptorSuffixKanji != null : !this$statementDescriptorSuffixKanji.equals(other$statementDescriptorSuffixKanji));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $requireCvcRecollection = this.getRequireCvcRecollection();
                result = result * 59 + ($requireCvcRecollection == null ? 43 : ((Object)$requireCvcRecollection).hashCode());
                String $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Installments $installments = this.getInstallments();
                result = result * 59 + ($installments == null ? 43 : ((Object)$installments).hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                String $requestExtendedAuthorization = this.getRequestExtendedAuthorization();
                result = result * 59 + ($requestExtendedAuthorization == null ? 43 : $requestExtendedAuthorization.hashCode());
                String $requestIncrementalAuthorization = this.getRequestIncrementalAuthorization();
                result = result * 59 + ($requestIncrementalAuthorization == null ? 43 : $requestIncrementalAuthorization.hashCode());
                String $requestMulticapture = this.getRequestMulticapture();
                result = result * 59 + ($requestMulticapture == null ? 43 : $requestMulticapture.hashCode());
                String $requestOvercapture = this.getRequestOvercapture();
                result = result * 59 + ($requestOvercapture == null ? 43 : $requestOvercapture.hashCode());
                String $requestThreeDSecure = this.getRequestThreeDSecure();
                result = result * 59 + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $statementDescriptorSuffixKana = this.getStatementDescriptorSuffixKana();
                result = result * 59 + ($statementDescriptorSuffixKana == null ? 43 : $statementDescriptorSuffixKana.hashCode());
                String $statementDescriptorSuffixKanji = this.getStatementDescriptorSuffixKanji();
                result = result * 59 + ($statementDescriptorSuffixKanji == null ? 43 : $statementDescriptorSuffixKanji.hashCode());
                return result;
            }

            public static class Installments
            extends StripeObject {
                @SerializedName(value="available_plans")
                List<AvailablePlan> availablePlans;
                @SerializedName(value="enabled")
                Boolean enabled;
                @SerializedName(value="plan")
                Plan plan;

                @Generated
                public List<AvailablePlan> getAvailablePlans() {
                    return this.availablePlans;
                }

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public Plan getPlan() {
                    return this.plan;
                }

                @Generated
                public void setAvailablePlans(List<AvailablePlan> availablePlans) {
                    this.availablePlans = availablePlans;
                }

                @Generated
                public void setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                }

                @Generated
                public void setPlan(Plan plan) {
                    this.plan = plan;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Installments)) {
                        return false;
                    }
                    Installments other = (Installments)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$enabled = this.getEnabled();
                    Boolean other$enabled = other.getEnabled();
                    if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                        return false;
                    }
                    List<AvailablePlan> this$availablePlans = this.getAvailablePlans();
                    List<AvailablePlan> other$availablePlans = other.getAvailablePlans();
                    if (this$availablePlans == null ? other$availablePlans != null : !((Object)this$availablePlans).equals(other$availablePlans)) {
                        return false;
                    }
                    Plan this$plan = this.getPlan();
                    Plan other$plan = other.getPlan();
                    return !(this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Installments;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $enabled = this.getEnabled();
                    result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                    List<AvailablePlan> $availablePlans = this.getAvailablePlans();
                    result = result * 59 + ($availablePlans == null ? 43 : ((Object)$availablePlans).hashCode());
                    Plan $plan = this.getPlan();
                    result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
                    return result;
                }

                public static class Plan
                extends StripeObject {
                    @SerializedName(value="count")
                    Long count;
                    @SerializedName(value="interval")
                    String interval;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public Long getCount() {
                        return this.count;
                    }

                    @Generated
                    public String getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setCount(Long count) {
                        this.count = count;
                    }

                    @Generated
                    public void setInterval(String interval) {
                        this.interval = interval;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Plan)) {
                            return false;
                        }
                        Plan other = (Plan)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$count = this.getCount();
                        Long other$count = other.getCount();
                        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                            return false;
                        }
                        String this$interval = this.getInterval();
                        String other$interval = other.getInterval();
                        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Plan;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $count = this.getCount();
                        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
                        String $interval = this.getInterval();
                        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }
                }

                public static class AvailablePlan
                extends StripeObject {
                    @SerializedName(value="count")
                    Long count;
                    @SerializedName(value="interval")
                    String interval;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public Long getCount() {
                        return this.count;
                    }

                    @Generated
                    public String getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setCount(Long count) {
                        this.count = count;
                    }

                    @Generated
                    public void setInterval(String interval) {
                        this.interval = interval;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof AvailablePlan)) {
                            return false;
                        }
                        AvailablePlan other = (AvailablePlan)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$count = this.getCount();
                        Long other$count = other.getCount();
                        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                            return false;
                        }
                        String this$interval = this.getInterval();
                        String other$interval = other.getInterval();
                        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof AvailablePlan;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $count = this.getCount();
                        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
                        String $interval = this.getInterval();
                        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }
                }
            }

            public static class MandateOptions
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="amount_type")
                String amountType;
                @SerializedName(value="description")
                String description;
                @SerializedName(value="end_date")
                Long endDate;
                @SerializedName(value="interval")
                String interval;
                @SerializedName(value="interval_count")
                Long intervalCount;
                @SerializedName(value="reference")
                String reference;
                @SerializedName(value="start_date")
                Long startDate;
                @SerializedName(value="supported_types")
                List<String> supportedTypes;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public String getAmountType() {
                    return this.amountType;
                }

                @Generated
                public String getDescription() {
                    return this.description;
                }

                @Generated
                public Long getEndDate() {
                    return this.endDate;
                }

                @Generated
                public String getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                @Generated
                public String getReference() {
                    return this.reference;
                }

                @Generated
                public Long getStartDate() {
                    return this.startDate;
                }

                @Generated
                public List<String> getSupportedTypes() {
                    return this.supportedTypes;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setAmountType(String amountType) {
                    this.amountType = amountType;
                }

                @Generated
                public void setDescription(String description) {
                    this.description = description;
                }

                @Generated
                public void setEndDate(Long endDate) {
                    this.endDate = endDate;
                }

                @Generated
                public void setInterval(String interval) {
                    this.interval = interval;
                }

                @Generated
                public void setIntervalCount(Long intervalCount) {
                    this.intervalCount = intervalCount;
                }

                @Generated
                public void setReference(String reference) {
                    this.reference = reference;
                }

                @Generated
                public void setStartDate(Long startDate) {
                    this.startDate = startDate;
                }

                @Generated
                public void setSupportedTypes(List<String> supportedTypes) {
                    this.supportedTypes = supportedTypes;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Long this$endDate = this.getEndDate();
                    Long other$endDate = other.getEndDate();
                    if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
                        return false;
                    }
                    Long this$intervalCount = this.getIntervalCount();
                    Long other$intervalCount = other.getIntervalCount();
                    if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                        return false;
                    }
                    Long this$startDate = this.getStartDate();
                    Long other$startDate = other.getStartDate();
                    if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
                        return false;
                    }
                    String this$amountType = this.getAmountType();
                    String other$amountType = other.getAmountType();
                    if (this$amountType == null ? other$amountType != null : !this$amountType.equals(other$amountType)) {
                        return false;
                    }
                    String this$description = this.getDescription();
                    String other$description = other.getDescription();
                    if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                        return false;
                    }
                    String this$interval = this.getInterval();
                    String other$interval = other.getInterval();
                    if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                        return false;
                    }
                    String this$reference = this.getReference();
                    String other$reference = other.getReference();
                    if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                        return false;
                    }
                    List<String> this$supportedTypes = this.getSupportedTypes();
                    List<String> other$supportedTypes = other.getSupportedTypes();
                    return !(this$supportedTypes == null ? other$supportedTypes != null : !((Object)this$supportedTypes).equals(other$supportedTypes));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Long $endDate = this.getEndDate();
                    result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
                    Long $intervalCount = this.getIntervalCount();
                    result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
                    Long $startDate = this.getStartDate();
                    result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
                    String $amountType = this.getAmountType();
                    result = result * 59 + ($amountType == null ? 43 : $amountType.hashCode());
                    String $description = this.getDescription();
                    result = result * 59 + ($description == null ? 43 : $description.hashCode());
                    String $interval = this.getInterval();
                    result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                    String $reference = this.getReference();
                    result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                    List<String> $supportedTypes = this.getSupportedTypes();
                    result = result * 59 + ($supportedTypes == null ? 43 : ((Object)$supportedTypes).hashCode());
                    return result;
                }
            }
        }

        public static class CardPresent
        extends StripeObject {
            @SerializedName(value="request_extended_authorization")
            Boolean requestExtendedAuthorization;
            @SerializedName(value="request_incremental_authorization_support")
            Boolean requestIncrementalAuthorizationSupport;

            @Generated
            public Boolean getRequestExtendedAuthorization() {
                return this.requestExtendedAuthorization;
            }

            @Generated
            public Boolean getRequestIncrementalAuthorizationSupport() {
                return this.requestIncrementalAuthorizationSupport;
            }

            @Generated
            public void setRequestExtendedAuthorization(Boolean requestExtendedAuthorization) {
                this.requestExtendedAuthorization = requestExtendedAuthorization;
            }

            @Generated
            public void setRequestIncrementalAuthorizationSupport(Boolean requestIncrementalAuthorizationSupport) {
                this.requestIncrementalAuthorizationSupport = requestIncrementalAuthorizationSupport;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardPresent)) {
                    return false;
                }
                CardPresent other = (CardPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$requestExtendedAuthorization = this.getRequestExtendedAuthorization();
                Boolean other$requestExtendedAuthorization = other.getRequestExtendedAuthorization();
                if (this$requestExtendedAuthorization == null ? other$requestExtendedAuthorization != null : !((Object)this$requestExtendedAuthorization).equals(other$requestExtendedAuthorization)) {
                    return false;
                }
                Boolean this$requestIncrementalAuthorizationSupport = this.getRequestIncrementalAuthorizationSupport();
                Boolean other$requestIncrementalAuthorizationSupport = other.getRequestIncrementalAuthorizationSupport();
                return !(this$requestIncrementalAuthorizationSupport == null ? other$requestIncrementalAuthorizationSupport != null : !((Object)this$requestIncrementalAuthorizationSupport).equals(other$requestIncrementalAuthorizationSupport));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $requestExtendedAuthorization = this.getRequestExtendedAuthorization();
                result = result * 59 + ($requestExtendedAuthorization == null ? 43 : ((Object)$requestExtendedAuthorization).hashCode());
                Boolean $requestIncrementalAuthorizationSupport = this.getRequestIncrementalAuthorizationSupport();
                result = result * 59 + ($requestIncrementalAuthorizationSupport == null ? 43 : ((Object)$requestIncrementalAuthorizationSupport).hashCode());
                return result;
            }
        }

        public static class Cashapp
        extends StripeObject {
            @SerializedName(value="capture_method")
            String captureMethod;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setCaptureMethod(String captureMethod) {
                this.captureMethod = captureMethod;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cashapp)) {
                    return false;
                }
                Cashapp other = (Cashapp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$captureMethod = this.getCaptureMethod();
                String other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cashapp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class CustomerBalance
        extends StripeObject {
            @SerializedName(value="bank_transfer")
            BankTransfer bankTransfer;
            @SerializedName(value="funding_type")
            String fundingType;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public BankTransfer getBankTransfer() {
                return this.bankTransfer;
            }

            @Generated
            public String getFundingType() {
                return this.fundingType;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setBankTransfer(BankTransfer bankTransfer) {
                this.bankTransfer = bankTransfer;
            }

            @Generated
            public void setFundingType(String fundingType) {
                this.fundingType = fundingType;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CustomerBalance)) {
                    return false;
                }
                CustomerBalance other = (CustomerBalance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BankTransfer this$bankTransfer = this.getBankTransfer();
                BankTransfer other$bankTransfer = other.getBankTransfer();
                if (this$bankTransfer == null ? other$bankTransfer != null : !((Object)this$bankTransfer).equals(other$bankTransfer)) {
                    return false;
                }
                String this$fundingType = this.getFundingType();
                String other$fundingType = other.getFundingType();
                if (this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CustomerBalance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BankTransfer $bankTransfer = this.getBankTransfer();
                result = result * 59 + ($bankTransfer == null ? 43 : ((Object)$bankTransfer).hashCode());
                String $fundingType = this.getFundingType();
                result = result * 59 + ($fundingType == null ? 43 : $fundingType.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class BankTransfer
            extends StripeObject {
                @SerializedName(value="eu_bank_transfer")
                EuBankTransfer euBankTransfer;
                @SerializedName(value="requested_address_types")
                List<String> requestedAddressTypes;
                @SerializedName(value="type")
                String type;

                @Generated
                public EuBankTransfer getEuBankTransfer() {
                    return this.euBankTransfer;
                }

                @Generated
                public List<String> getRequestedAddressTypes() {
                    return this.requestedAddressTypes;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setEuBankTransfer(EuBankTransfer euBankTransfer) {
                    this.euBankTransfer = euBankTransfer;
                }

                @Generated
                public void setRequestedAddressTypes(List<String> requestedAddressTypes) {
                    this.requestedAddressTypes = requestedAddressTypes;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BankTransfer)) {
                        return false;
                    }
                    BankTransfer other = (BankTransfer)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    EuBankTransfer this$euBankTransfer = this.getEuBankTransfer();
                    EuBankTransfer other$euBankTransfer = other.getEuBankTransfer();
                    if (this$euBankTransfer == null ? other$euBankTransfer != null : !((Object)this$euBankTransfer).equals(other$euBankTransfer)) {
                        return false;
                    }
                    List<String> this$requestedAddressTypes = this.getRequestedAddressTypes();
                    List<String> other$requestedAddressTypes = other.getRequestedAddressTypes();
                    if (this$requestedAddressTypes == null ? other$requestedAddressTypes != null : !((Object)this$requestedAddressTypes).equals(other$requestedAddressTypes)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof BankTransfer;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    EuBankTransfer $euBankTransfer = this.getEuBankTransfer();
                    result = result * 59 + ($euBankTransfer == null ? 43 : ((Object)$euBankTransfer).hashCode());
                    List<String> $requestedAddressTypes = this.getRequestedAddressTypes();
                    result = result * 59 + ($requestedAddressTypes == null ? 43 : ((Object)$requestedAddressTypes).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class EuBankTransfer
                extends StripeObject {
                    @SerializedName(value="country")
                    String country;

                    @Generated
                    public String getCountry() {
                        return this.country;
                    }

                    @Generated
                    public void setCountry(String country) {
                        this.country = country;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof EuBankTransfer)) {
                            return false;
                        }
                        EuBankTransfer other = (EuBankTransfer)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$country = this.getCountry();
                        String other$country = other.getCountry();
                        return !(this$country == null ? other$country != null : !this$country.equals(other$country));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof EuBankTransfer;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $country = this.getCountry();
                        result = result * 59 + ($country == null ? 43 : $country.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class Eps
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eps)) {
                    return false;
                }
                Eps other = (Eps)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eps;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Fpx
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fpx)) {
                    return false;
                }
                Fpx other = (Fpx)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fpx;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Giropay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Giropay)) {
                    return false;
                }
                Giropay other = (Giropay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Giropay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Grabpay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Grabpay)) {
                    return false;
                }
                Grabpay other = (Grabpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Grabpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Ideal
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ideal)) {
                    return false;
                }
                Ideal other = (Ideal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ideal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class InteracPresent
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InteracPresent)) {
                    return false;
                }
                InteracPresent other = (InteracPresent)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InteracPresent;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Klarna
        extends StripeObject {
            @SerializedName(value="capture_method")
            String captureMethod;
            @SerializedName(value="preferred_locale")
            String preferredLocale;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public String getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setCaptureMethod(String captureMethod) {
                this.captureMethod = captureMethod;
            }

            @Generated
            public void setPreferredLocale(String preferredLocale) {
                this.preferredLocale = preferredLocale;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$captureMethod = this.getCaptureMethod();
                String other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                String this$preferredLocale = this.getPreferredLocale();
                String other$preferredLocale = other.getPreferredLocale();
                if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                String $preferredLocale = this.getPreferredLocale();
                result = result * 59 + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Konbini
        extends StripeObject {
            @SerializedName(value="confirmation_number")
            String confirmationNumber;
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="product_description")
            String productDescription;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getConfirmationNumber() {
                return this.confirmationNumber;
            }

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public String getProductDescription() {
                return this.productDescription;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setConfirmationNumber(String confirmationNumber) {
                this.confirmationNumber = confirmationNumber;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public void setProductDescription(String productDescription) {
                this.productDescription = productDescription;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Konbini)) {
                    return false;
                }
                Konbini other = (Konbini)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                String this$confirmationNumber = this.getConfirmationNumber();
                String other$confirmationNumber = other.getConfirmationNumber();
                if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) {
                    return false;
                }
                String this$productDescription = this.getProductDescription();
                String other$productDescription = other.getProductDescription();
                if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Konbini;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                String $confirmationNumber = this.getConfirmationNumber();
                result = result * 59 + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
                String $productDescription = this.getProductDescription();
                result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Link
        extends StripeObject {
            @SerializedName(value="capture_method")
            String captureMethod;
            @SerializedName(value="persistent_token")
            String persistentToken;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public String getPersistentToken() {
                return this.persistentToken;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setCaptureMethod(String captureMethod) {
                this.captureMethod = captureMethod;
            }

            @Generated
            public void setPersistentToken(String persistentToken) {
                this.persistentToken = persistentToken;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Link)) {
                    return false;
                }
                Link other = (Link)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$captureMethod = this.getCaptureMethod();
                String other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                String this$persistentToken = this.getPersistentToken();
                String other$persistentToken = other.getPersistentToken();
                if (this$persistentToken == null ? other$persistentToken != null : !this$persistentToken.equals(other$persistentToken)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Link;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                String $persistentToken = this.getPersistentToken();
                result = result * 59 + ($persistentToken == null ? 43 : $persistentToken.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Mobilepay
        extends StripeObject {
            @SerializedName(value="capture_method")
            String captureMethod;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setCaptureMethod(String captureMethod) {
                this.captureMethod = captureMethod;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mobilepay)) {
                    return false;
                }
                Mobilepay other = (Mobilepay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$captureMethod = this.getCaptureMethod();
                String other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mobilepay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Oxxo
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Oxxo)) {
                    return false;
                }
                Oxxo other = (Oxxo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Oxxo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class P24
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof P24)) {
                    return false;
                }
                P24 other = (P24)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof P24;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Paynow
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paynow)) {
                    return false;
                }
                Paynow other = (Paynow)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paynow;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Paypal
        extends StripeObject {
            @SerializedName(value="capture_method")
            String captureMethod;
            @SerializedName(value="preferred_locale")
            String preferredLocale;
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public String getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setCaptureMethod(String captureMethod) {
                this.captureMethod = captureMethod;
            }

            @Generated
            public void setPreferredLocale(String preferredLocale) {
                this.preferredLocale = preferredLocale;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$captureMethod = this.getCaptureMethod();
                String other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                String this$preferredLocale = this.getPreferredLocale();
                String other$preferredLocale = other.getPreferredLocale();
                if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                String $preferredLocale = this.getPreferredLocale();
                result = result * 59 + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Pix
        extends StripeObject {
            @SerializedName(value="expires_after_seconds")
            Long expiresAfterSeconds;
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterSeconds() {
                return this.expiresAfterSeconds;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterSeconds(Long expiresAfterSeconds) {
                this.expiresAfterSeconds = expiresAfterSeconds;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pix)) {
                    return false;
                }
                Pix other = (Pix)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterSeconds = this.getExpiresAfterSeconds();
                Long other$expiresAfterSeconds = other.getExpiresAfterSeconds();
                if (this$expiresAfterSeconds == null ? other$expiresAfterSeconds != null : !((Object)this$expiresAfterSeconds).equals(other$expiresAfterSeconds)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pix;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterSeconds = this.getExpiresAfterSeconds();
                result = result * 59 + ($expiresAfterSeconds == null ? 43 : ((Object)$expiresAfterSeconds).hashCode());
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Promptpay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Promptpay)) {
                    return false;
                }
                Promptpay other = (Promptpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Promptpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class RevolutPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RevolutPay)) {
                    return false;
                }
                RevolutPay other = (RevolutPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RevolutPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class MandateOptions
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }
        }

        public static class Sofort
        extends StripeObject {
            @SerializedName(value="preferred_language")
            String preferredLanguage;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setPreferredLanguage(String preferredLanguage) {
                this.preferredLanguage = preferredLanguage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$preferredLanguage = this.getPreferredLanguage();
                String other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Swish
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Swish)) {
                    return false;
                }
                Swish other = (Swish)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Swish;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="financial_connections")
            FinancialConnections financialConnections;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="preferred_settlement_speed")
            String preferredSettlementSpeed;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;
            @SerializedName(value="verification_method")
            String verificationMethod;

            @Generated
            public FinancialConnections getFinancialConnections() {
                return this.financialConnections;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getPreferredSettlementSpeed() {
                return this.preferredSettlementSpeed;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public void setFinancialConnections(FinancialConnections financialConnections) {
                this.financialConnections = financialConnections;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setPreferredSettlementSpeed(String preferredSettlementSpeed) {
                this.preferredSettlementSpeed = preferredSettlementSpeed;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public void setVerificationMethod(String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FinancialConnections this$financialConnections = this.getFinancialConnections();
                FinancialConnections other$financialConnections = other.getFinancialConnections();
                if (this$financialConnections == null ? other$financialConnections != null : !((Object)this$financialConnections).equals(other$financialConnections)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$preferredSettlementSpeed = this.getPreferredSettlementSpeed();
                String other$preferredSettlementSpeed = other.getPreferredSettlementSpeed();
                if (this$preferredSettlementSpeed == null ? other$preferredSettlementSpeed != null : !this$preferredSettlementSpeed.equals(other$preferredSettlementSpeed)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FinancialConnections $financialConnections = this.getFinancialConnections();
                result = result * 59 + ($financialConnections == null ? 43 : ((Object)$financialConnections).hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $preferredSettlementSpeed = this.getPreferredSettlementSpeed();
                result = result * 59 + ($preferredSettlementSpeed == null ? 43 : $preferredSettlementSpeed.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }

            public static class FinancialConnections
            extends StripeObject {
                @SerializedName(value="permissions")
                List<String> permissions;
                @SerializedName(value="prefetch")
                List<String> prefetch;
                @SerializedName(value="return_url")
                String returnUrl;

                @Generated
                public List<String> getPermissions() {
                    return this.permissions;
                }

                @Generated
                public List<String> getPrefetch() {
                    return this.prefetch;
                }

                @Generated
                public String getReturnUrl() {
                    return this.returnUrl;
                }

                @Generated
                public void setPermissions(List<String> permissions) {
                    this.permissions = permissions;
                }

                @Generated
                public void setPrefetch(List<String> prefetch) {
                    this.prefetch = prefetch;
                }

                @Generated
                public void setReturnUrl(String returnUrl) {
                    this.returnUrl = returnUrl;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof FinancialConnections)) {
                        return false;
                    }
                    FinancialConnections other = (FinancialConnections)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<String> this$permissions = this.getPermissions();
                    List<String> other$permissions = other.getPermissions();
                    if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
                        return false;
                    }
                    List<String> this$prefetch = this.getPrefetch();
                    List<String> other$prefetch = other.getPrefetch();
                    if (this$prefetch == null ? other$prefetch != null : !((Object)this$prefetch).equals(other$prefetch)) {
                        return false;
                    }
                    String this$returnUrl = this.getReturnUrl();
                    String other$returnUrl = other.getReturnUrl();
                    return !(this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof FinancialConnections;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<String> $permissions = this.getPermissions();
                    result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
                    List<String> $prefetch = this.getPrefetch();
                    result = result * 59 + ($prefetch == null ? 43 : ((Object)$prefetch).hashCode());
                    String $returnUrl = this.getReturnUrl();
                    result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
                    return result;
                }
            }

            public static class MandateOptions
            extends StripeObject {
                @SerializedName(value="collection_method")
                String collectionMethod;

                @Generated
                public String getCollectionMethod() {
                    return this.collectionMethod;
                }

                @Generated
                public void setCollectionMethod(String collectionMethod) {
                    this.collectionMethod = collectionMethod;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$collectionMethod = this.getCollectionMethod();
                    String other$collectionMethod = other.getCollectionMethod();
                    return !(this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $collectionMethod = this.getCollectionMethod();
                    result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
                    return result;
                }
            }
        }

        public static class WechatPay
        extends StripeObject {
            @SerializedName(value="app_id")
            String appId;
            @SerializedName(value="client")
            String client;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getAppId() {
                return this.appId;
            }

            @Generated
            public String getClient() {
                return this.client;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setAppId(String appId) {
                this.appId = appId;
            }

            @Generated
            public void setClient(String client) {
                this.client = client;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPay)) {
                    return false;
                }
                WechatPay other = (WechatPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$appId = this.getAppId();
                String other$appId = other.getAppId();
                if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                    return false;
                }
                String this$client = this.getClient();
                String other$client = other.getClient();
                if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $appId = this.getAppId();
                result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
                String $client = this.getClient();
                result = result * 59 + ($client == null ? 43 : $client.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Zip
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Zip)) {
                    return false;
                }
                Zip other = (Zip)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Zip;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }
    }

    public static class Processing
    extends StripeObject {
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="type")
        String type;

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Processing)) {
                return false;
            }
            Processing other = (Processing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Processing;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="customer_notification")
            CustomerNotification customerNotification;

            @Generated
            public CustomerNotification getCustomerNotification() {
                return this.customerNotification;
            }

            @Generated
            public void setCustomerNotification(CustomerNotification customerNotification) {
                this.customerNotification = customerNotification;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                CustomerNotification this$customerNotification = this.getCustomerNotification();
                CustomerNotification other$customerNotification = other.getCustomerNotification();
                return !(this$customerNotification == null ? other$customerNotification != null : !((Object)this$customerNotification).equals(other$customerNotification));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                CustomerNotification $customerNotification = this.getCustomerNotification();
                result = result * 59 + ($customerNotification == null ? 43 : ((Object)$customerNotification).hashCode());
                return result;
            }

            public static class CustomerNotification
            extends StripeObject {
                @SerializedName(value="approval_requested")
                Boolean approvalRequested;
                @SerializedName(value="completes_at")
                Long completesAt;

                @Generated
                public Boolean getApprovalRequested() {
                    return this.approvalRequested;
                }

                @Generated
                public Long getCompletesAt() {
                    return this.completesAt;
                }

                @Generated
                public void setApprovalRequested(Boolean approvalRequested) {
                    this.approvalRequested = approvalRequested;
                }

                @Generated
                public void setCompletesAt(Long completesAt) {
                    this.completesAt = completesAt;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CustomerNotification)) {
                        return false;
                    }
                    CustomerNotification other = (CustomerNotification)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$approvalRequested = this.getApprovalRequested();
                    Boolean other$approvalRequested = other.getApprovalRequested();
                    if (this$approvalRequested == null ? other$approvalRequested != null : !((Object)this$approvalRequested).equals(other$approvalRequested)) {
                        return false;
                    }
                    Long this$completesAt = this.getCompletesAt();
                    Long other$completesAt = other.getCompletesAt();
                    return !(this$completesAt == null ? other$completesAt != null : !((Object)this$completesAt).equals(other$completesAt));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CustomerNotification;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $approvalRequested = this.getApprovalRequested();
                    result = result * 59 + ($approvalRequested == null ? 43 : ((Object)$approvalRequested).hashCode());
                    Long $completesAt = this.getCompletesAt();
                    result = result * 59 + ($completesAt == null ? 43 : ((Object)$completesAt).hashCode());
                    return result;
                }
            }
        }
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }
}

