// File generated from our OpenAPI spec
package com.stripe.model.financialconnections;

import com.google.gson.annotations.SerializedName;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/** Describes a snapshot of the owners of an account at a particular point in time. */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class AccountOwnership extends StripeObject implements HasId {
  /** Time at which the object was created. Measured in seconds since the Unix epoch. */
  @SerializedName("created")
  Long created;

  /** Unique identifier for the object. */
  @Getter(onMethod_ = {@Override})
  @SerializedName("id")
  String id;

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code financial_connections.account_ownership}.
   */
  @SerializedName("object")
  String object;

  /** A paginated list of owners for this account. */
  @SerializedName("owners")
  AccountOwnerCollection owners;
}
