/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.ApplicationFeeCollection;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.FeeRefundCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ApplicationFeeListParams;
import com.stripe.param.ApplicationFeeRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class ApplicationFee
extends ApiResource
implements BalanceTransactionSource {
    @SerializedName(value="account")
    ExpandableField<Account> account;
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_refunded")
    Long amountRefunded;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="charge")
    ExpandableField<Charge> charge;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="fee_source")
    FeeSource feeSource;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="originating_transaction")
    ExpandableField<Charge> originatingTransaction;
    @SerializedName(value="refunded")
    Boolean refunded;
    @SerializedName(value="refunds")
    FeeRefundCollection refunds;

    public String getAccount() {
        return this.account != null ? this.account.getId() : null;
    }

    public void setAccount(String id) {
        this.account = ApiResource.setExpandableFieldId(id, this.account);
    }

    public Account getAccountObject() {
        return this.account != null ? this.account.getExpanded() : null;
    }

    public void setAccountObject(Account expandableObject) {
        this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String id) {
        this.charge = ApiResource.setExpandableFieldId(id, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge expandableObject) {
        this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getOriginatingTransaction() {
        return this.originatingTransaction != null ? this.originatingTransaction.getId() : null;
    }

    public void setOriginatingTransaction(String id) {
        this.originatingTransaction = ApiResource.setExpandableFieldId(id, this.originatingTransaction);
    }

    public Charge getOriginatingTransactionObject() {
        return this.originatingTransaction != null ? this.originatingTransaction.getExpanded() : null;
    }

    public void setOriginatingTransactionObject(Charge expandableObject) {
        this.originatingTransaction = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public static ApplicationFeeCollection list(Map<String, Object> params) throws StripeException {
        return ApplicationFee.list(params, (RequestOptions)null);
    }

    public static ApplicationFeeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/application_fees";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (ApplicationFeeCollection)ApplicationFee.getGlobalResponseGetter().request(request, (Type)((Object)ApplicationFeeCollection.class));
    }

    public static ApplicationFeeCollection list(ApplicationFeeListParams params) throws StripeException {
        return ApplicationFee.list(params, (RequestOptions)null);
    }

    public static ApplicationFeeCollection list(ApplicationFeeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/application_fees";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ApplicationFeeCollection)ApplicationFee.getGlobalResponseGetter().request(request, (Type)((Object)ApplicationFeeCollection.class));
    }

    public static ApplicationFee retrieve(String id) throws StripeException {
        return ApplicationFee.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ApplicationFee retrieve(String id, RequestOptions options) throws StripeException {
        return ApplicationFee.retrieve(id, (Map<String, Object>)null, options);
    }

    public static ApplicationFee retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/application_fees/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (ApplicationFee)ApplicationFee.getGlobalResponseGetter().request(request, (Type)((Object)ApplicationFee.class));
    }

    public static ApplicationFee retrieve(String id, ApplicationFeeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/application_fees/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ApplicationFee)ApplicationFee.getGlobalResponseGetter().request(request, (Type)((Object)ApplicationFee.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.account, responseGetter);
        this.trySetResponseGetter(this.application, responseGetter);
        this.trySetResponseGetter(this.balanceTransaction, responseGetter);
        this.trySetResponseGetter(this.charge, responseGetter);
        this.trySetResponseGetter(this.feeSource, responseGetter);
        this.trySetResponseGetter(this.originatingTransaction, responseGetter);
        this.trySetResponseGetter(this.refunds, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountRefunded() {
        return this.amountRefunded;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public FeeSource getFeeSource() {
        return this.feeSource;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Boolean getRefunded() {
        return this.refunded;
    }

    @Generated
    public FeeRefundCollection getRefunds() {
        return this.refunds;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountRefunded(Long amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setFeeSource(FeeSource feeSource) {
        this.feeSource = feeSource;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    @Generated
    public void setRefunds(FeeRefundCollection refunds) {
        this.refunds = refunds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationFee)) {
            return false;
        }
        ApplicationFee other = (ApplicationFee)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountRefunded = this.getAmountRefunded();
        Long other$amountRefunded = other.getAmountRefunded();
        if (this$amountRefunded == null ? other$amountRefunded != null : !((Object)this$amountRefunded).equals(other$amountRefunded)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Boolean this$refunded = this.getRefunded();
        Boolean other$refunded = other.getRefunded();
        if (this$refunded == null ? other$refunded != null : !((Object)this$refunded).equals(other$refunded)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        FeeSource this$feeSource = this.getFeeSource();
        FeeSource other$feeSource = other.getFeeSource();
        if (this$feeSource == null ? other$feeSource != null : !((Object)this$feeSource).equals(other$feeSource)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$originatingTransaction = this.getOriginatingTransaction();
        String other$originatingTransaction = other.getOriginatingTransaction();
        if (this$originatingTransaction == null ? other$originatingTransaction != null : !this$originatingTransaction.equals(other$originatingTransaction)) {
            return false;
        }
        FeeRefundCollection this$refunds = this.getRefunds();
        FeeRefundCollection other$refunds = other.getRefunds();
        return !(this$refunds == null ? other$refunds != null : !((Object)this$refunds).equals(other$refunds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApplicationFee;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountRefunded = this.getAmountRefunded();
        result = result * 59 + ($amountRefunded == null ? 43 : ((Object)$amountRefunded).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Boolean $refunded = this.getRefunded();
        result = result * 59 + ($refunded == null ? 43 : ((Object)$refunded).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        FeeSource $feeSource = this.getFeeSource();
        result = result * 59 + ($feeSource == null ? 43 : ((Object)$feeSource).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $originatingTransaction = this.getOriginatingTransaction();
        result = result * 59 + ($originatingTransaction == null ? 43 : $originatingTransaction.hashCode());
        FeeRefundCollection $refunds = this.getRefunds();
        result = result * 59 + ($refunds == null ? 43 : ((Object)$refunds).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class FeeSource
    extends StripeObject {
        @SerializedName(value="charge")
        String charge;
        @SerializedName(value="payout")
        String payout;
        @SerializedName(value="type")
        String type;

        @Generated
        public String getCharge() {
            return this.charge;
        }

        @Generated
        public String getPayout() {
            return this.payout;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setCharge(String charge) {
            this.charge = charge;
        }

        @Generated
        public void setPayout(String payout) {
            this.payout = payout;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeeSource)) {
                return false;
            }
            FeeSource other = (FeeSource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$charge = this.getCharge();
            String other$charge = other.getCharge();
            if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
                return false;
            }
            String this$payout = this.getPayout();
            String other$payout = other.getPayout();
            if (this$payout == null ? other$payout != null : !this$payout.equals(other$payout)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FeeSource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $charge = this.getCharge();
            result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
            String $payout = this.getPayout();
            result = result * 59 + ($payout == null ? 43 : $payout.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }
}

