/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.stripe.Stripe;
import com.stripe.exception.ApiConnectionException;
import com.stripe.exception.ApiException;
import com.stripe.exception.ApiKeyMissingException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.IdempotencyException;
import com.stripe.exception.PermissionException;
import com.stripe.exception.RateLimitException;
import com.stripe.exception.StripeException;
import com.stripe.exception.oauth.InvalidClientException;
import com.stripe.exception.oauth.InvalidGrantException;
import com.stripe.exception.oauth.InvalidRequestException;
import com.stripe.exception.oauth.InvalidScopeException;
import com.stripe.exception.oauth.OAuthException;
import com.stripe.exception.oauth.UnsupportedGrantTypeException;
import com.stripe.exception.oauth.UnsupportedResponseTypeException;
import com.stripe.model.StripeCollectionInterface;
import com.stripe.model.StripeError;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeObjectInterface;
import com.stripe.model.oauth.OAuthError;
import com.stripe.net.AbstractStripeResponse;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.BaseApiRequest;
import com.stripe.net.GlobalStripeResponseGetterOptions;
import com.stripe.net.HttpClient;
import com.stripe.net.HttpURLConnectionClient;
import com.stripe.net.RawApiRequest;
import com.stripe.net.RequestOptions;
import com.stripe.net.RequestTelemetry;
import com.stripe.net.StripeRequest;
import com.stripe.net.StripeResponse;
import com.stripe.net.StripeResponseGetter;
import com.stripe.net.StripeResponseGetterOptions;
import com.stripe.net.StripeResponseStream;
import com.stripe.util.Stopwatch;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LiveStripeResponseGetter
implements StripeResponseGetter {
    private final HttpClient httpClient;
    private final StripeResponseGetterOptions options;
    private final RequestTelemetry requestTelemetry = new RequestTelemetry();

    private <T extends AbstractStripeResponse<?>> T sendWithTelemetry(StripeRequest request, List<String> usage, RequestSendFunction<T> send) throws StripeException {
        Stopwatch stopwatch = Stopwatch.startNew();
        AbstractStripeResponse response = (AbstractStripeResponse)send.apply(request);
        stopwatch.stop();
        this.requestTelemetry.maybeEnqueueMetrics(response, stopwatch.getElapsed(), usage);
        return (T)response;
    }

    public LiveStripeResponseGetter() {
        this(null, null);
    }

    public LiveStripeResponseGetter(HttpClient httpClient) {
        this(null, httpClient);
    }

    public LiveStripeResponseGetter(StripeResponseGetterOptions options, HttpClient httpClient) {
        this.options = options != null ? options : GlobalStripeResponseGetterOptions.INSTANCE;
        this.httpClient = httpClient != null ? httpClient : LiveStripeResponseGetter.buildDefaultHttpClient();
    }

    private StripeRequest toStripeRequest(ApiRequest apiRequest, RequestOptions mergedOptions) throws StripeException {
        String fullUrl = this.fullUrl(apiRequest);
        Optional<String> telemetryHeaderValue = this.requestTelemetry.pollPayload();
        StripeRequest request = new StripeRequest(apiRequest.getMethod(), fullUrl, apiRequest.getParams(), mergedOptions);
        if (telemetryHeaderValue.isPresent()) {
            request = request.withAdditionalHeader("X-Stripe-Client-Telemetry", telemetryHeaderValue.get());
        }
        return request;
    }

    private StripeRequest toRawStripeRequest(RawApiRequest apiRequest, RequestOptions mergedOptions) throws StripeException {
        String fullUrl = this.fullUrl(apiRequest);
        Optional<String> telemetryHeaderValue = this.requestTelemetry.pollPayload();
        StripeRequest request = StripeRequest.createWithStringContent(apiRequest.getMethod(), fullUrl, apiRequest.getRawContent(), mergedOptions, apiRequest.getApiMode() == ApiMode.PREVIEW);
        if (apiRequest.getApiMode() == ApiMode.PREVIEW) {
            request = request.withAdditionalHeader("Stripe-Version", "2024-04-11.preview-v2");
        }
        if (telemetryHeaderValue.isPresent()) {
            request = request.withAdditionalHeader("X-Stripe-Client-Telemetry", telemetryHeaderValue.get());
        }
        return request;
    }

    @Override
    public <T extends StripeObjectInterface> T request(ApiRequest apiRequest, Type typeToken) throws StripeException {
        RequestOptions mergedOptions = RequestOptions.merge(this.options, apiRequest.getOptions());
        if (RequestOptions.unsafeGetStripeVersionOverride(mergedOptions) != null) {
            apiRequest = apiRequest.addUsage("unsafe_stripe_version_override");
        }
        StripeRequest request = this.toStripeRequest(apiRequest, mergedOptions);
        StripeResponse response = this.sendWithTelemetry(request, apiRequest.getUsage(), r -> this.httpClient.requestWithRetries(r));
        int responseCode = response.code();
        String responseBody = (String)response.body();
        String requestId = response.requestId();
        if (responseCode < 200 || responseCode >= 300) {
            this.handleError(response, apiRequest.getApiMode());
        }
        StripeObject resource = null;
        try {
            resource = ApiResource.deserializeStripeObject(responseBody, typeToken, (StripeResponseGetter)this);
        }
        catch (JsonSyntaxException e) {
            LiveStripeResponseGetter.raiseMalformedJsonError(responseBody, responseCode, requestId, e);
        }
        if (resource instanceof StripeCollectionInterface) {
            ((StripeCollectionInterface)((Object)resource)).setRequestOptions(apiRequest.getOptions());
            ((StripeCollectionInterface)((Object)resource)).setRequestParams(apiRequest.getParams());
        }
        resource.setLastResponse(response);
        return (T)resource;
    }

    @Override
    public InputStream requestStream(ApiRequest apiRequest) throws StripeException {
        StripeRequest request;
        StripeResponseStream responseStream;
        int responseCode;
        RequestOptions mergedOptions = RequestOptions.merge(this.options, apiRequest.getOptions());
        if (RequestOptions.unsafeGetStripeVersionOverride(mergedOptions) != null) {
            apiRequest = apiRequest.addUsage("unsafe_stripe_version_override");
        }
        if ((responseCode = (responseStream = this.sendWithTelemetry(request = this.toStripeRequest(apiRequest, mergedOptions), apiRequest.getUsage(), r -> this.httpClient.requestStreamWithRetries(r))).code()) < 200 || responseCode >= 300) {
            StripeResponse response;
            try {
                response = responseStream.unstream();
            }
            catch (IOException e) {
                throw new ApiConnectionException(String.format("IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists,you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", Stripe.getApiBase(), e.getMessage()), e);
            }
            this.handleError(response, apiRequest.getApiMode());
        }
        return (InputStream)responseStream.body();
    }

    @Override
    public StripeResponse rawRequest(RawApiRequest apiRequest) throws StripeException {
        StripeResponse response;
        int responseCode;
        RequestOptions mergedOptions = RequestOptions.merge(this.options, apiRequest.getOptions());
        if (RequestOptions.unsafeGetStripeVersionOverride(mergedOptions) != null) {
            apiRequest = apiRequest.addUsage("unsafe_stripe_version_override");
        }
        StripeRequest request = this.toRawStripeRequest(apiRequest, mergedOptions);
        Map<String, String> additionalHeaders = apiRequest.getOptions().getAdditionalHeaders();
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                request = request.withAdditionalHeader(key, value);
            }
        }
        if ((responseCode = (response = this.sendWithTelemetry(request, apiRequest.getUsage(), r -> this.httpClient.requestWithRetries(r))).code()) < 200 || responseCode >= 300) {
            this.handleApiError(response);
        }
        return response;
    }

    @Override
    public <T extends StripeObjectInterface> T request(BaseAddress baseAddress, ApiResource.RequestMethod method, String path, Map<String, Object> params, Type typeToken, RequestOptions options, ApiMode apiMode) throws StripeException {
        return this.request(new ApiRequest(baseAddress, method, path, params, options, apiMode), typeToken);
    }

    @Override
    public InputStream requestStream(BaseAddress baseAddress, ApiResource.RequestMethod method, String path, Map<String, Object> params, RequestOptions options, ApiMode apiMode) throws StripeException {
        return this.requestStream(new ApiRequest(baseAddress, method, path, params, options, apiMode));
    }

    private static HttpClient buildDefaultHttpClient() {
        return new HttpURLConnectionClient();
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode, String requestId, Throwable e) throws ApiException {
        String details = e == null ? "none" : e.getMessage();
        throw new ApiException(String.format("Invalid response object from API: %s. (HTTP response code was %d). Additional details: %s.", responseBody, responseCode, details), requestId, null, responseCode, e);
    }

    private void handleError(StripeResponse response, ApiMode apiMode) throws StripeException {
        if (apiMode == ApiMode.V1) {
            this.handleApiError(response);
        } else if (apiMode == ApiMode.OAuth) {
            this.handleOAuthError(response);
        }
    }

    private void handleApiError(StripeResponse response) throws StripeException {
        StripeObject error = null;
        StripeException exception = null;
        try {
            JsonObject jsonObject = ((JsonObject)ApiResource.INTERNAL_GSON.fromJson((String)response.body(), JsonObject.class)).getAsJsonObject("error");
            error = ApiResource.deserializeStripeObject(jsonObject.toString(), StripeError.class, (StripeResponseGetter)this);
        }
        catch (JsonSyntaxException e) {
            LiveStripeResponseGetter.raiseMalformedJsonError((String)response.body(), response.code(), response.requestId(), e);
        }
        if (error == null) {
            LiveStripeResponseGetter.raiseMalformedJsonError((String)response.body(), response.code(), response.requestId(), null);
        }
        error.setLastResponse(response);
        switch (response.code()) {
            case 400: 
            case 404: {
                if ("idempotency_error".equals(((StripeError)error).getType())) {
                    exception = new IdempotencyException(((StripeError)error).getMessage(), response.requestId(), ((StripeError)error).getCode(), response.code());
                    break;
                }
                exception = new com.stripe.exception.InvalidRequestException(((StripeError)error).getMessage(), ((StripeError)error).getParam(), response.requestId(), ((StripeError)error).getCode(), response.code(), null);
                break;
            }
            case 401: {
                exception = new AuthenticationException(((StripeError)error).getMessage(), response.requestId(), ((StripeError)error).getCode(), response.code());
                break;
            }
            case 402: {
                exception = new CardException(((StripeError)error).getMessage(), response.requestId(), ((StripeError)error).getCode(), ((StripeError)error).getParam(), ((StripeError)error).getDeclineCode(), ((StripeError)error).getCharge(), response.code(), null);
                break;
            }
            case 403: {
                exception = new PermissionException(((StripeError)error).getMessage(), response.requestId(), ((StripeError)error).getCode(), response.code());
                break;
            }
            case 429: {
                exception = new RateLimitException(((StripeError)error).getMessage(), ((StripeError)error).getParam(), response.requestId(), ((StripeError)error).getCode(), response.code(), null);
                break;
            }
            default: {
                exception = new ApiException(((StripeError)error).getMessage(), response.requestId(), ((StripeError)error).getCode(), response.code(), null);
            }
        }
        exception.setStripeError((StripeError)error);
        throw exception;
    }

    private void handleOAuthError(StripeResponse response) throws StripeException {
        OAuthError error = null;
        StripeException exception = null;
        try {
            error = ApiResource.deserializeStripeObject((String)response.body(), OAuthError.class, (StripeResponseGetter)this);
        }
        catch (JsonSyntaxException e) {
            LiveStripeResponseGetter.raiseMalformedJsonError((String)response.body(), response.code(), response.requestId(), e);
        }
        if (error == null) {
            LiveStripeResponseGetter.raiseMalformedJsonError((String)response.body(), response.code(), response.requestId(), null);
        }
        error.setLastResponse(response);
        String code = error.getError();
        String description = error.getErrorDescription() != null ? error.getErrorDescription() : code;
        switch (code) {
            case "invalid_client": {
                exception = new InvalidClientException(code, description, response.requestId(), response.code(), null);
                break;
            }
            case "invalid_grant": {
                exception = new InvalidGrantException(code, description, response.requestId(), response.code(), null);
                break;
            }
            case "invalid_request": {
                exception = new InvalidRequestException(code, description, response.requestId(), response.code(), null);
                break;
            }
            case "invalid_scope": {
                exception = new InvalidScopeException(code, description, response.requestId(), response.code(), null);
                break;
            }
            case "unsupported_grant_type": {
                exception = new UnsupportedGrantTypeException(code, description, response.requestId(), response.code(), null);
                break;
            }
            case "unsupported_response_type": {
                exception = new UnsupportedResponseTypeException(code, description, response.requestId(), response.code(), null);
                break;
            }
            default: {
                exception = new ApiException(code, response.requestId(), null, response.code(), null);
            }
        }
        if (exception instanceof OAuthException) {
            ((OAuthException)exception).setOauthError(error);
        }
        throw exception;
    }

    @Override
    public void validateRequestOptions(RequestOptions options) {
        if ((options == null || options.getApiKey() == null) && this.options.getApiKey() == null) {
            throw new ApiKeyMissingException("API key is not set. You can set the API key globally using Stripe.ApiKey, or by passing RequestOptions");
        }
    }

    private String fullUrl(BaseApiRequest apiRequest) {
        String baseUrl;
        BaseAddress baseAddress = apiRequest.getBaseAddress();
        RequestOptions options = apiRequest.getOptions();
        String relativeUrl = apiRequest.getPath();
        switch (baseAddress) {
            case API: {
                baseUrl = this.options.getApiBase();
                break;
            }
            case CONNECT: {
                baseUrl = this.options.getConnectBase();
                break;
            }
            case FILES: {
                baseUrl = this.options.getFilesBase();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown base address " + (Object)((Object)baseAddress));
            }
        }
        if (options != null && options.getBaseUrl() != null) {
            baseUrl = options.getBaseUrl();
        }
        return String.format("%s%s", baseUrl, relativeUrl);
    }

    @FunctionalInterface
    private static interface RequestSendFunction<R> {
        public R apply(StripeRequest var1) throws StripeException;
    }
}

