/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.CreditUnderwritingRecordCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CreditUnderwritingRecordCorrectParams;
import com.stripe.param.issuing.CreditUnderwritingRecordCreateFromApplicationParams;
import com.stripe.param.issuing.CreditUnderwritingRecordCreateFromProactiveReviewParams;
import com.stripe.param.issuing.CreditUnderwritingRecordListParams;
import com.stripe.param.issuing.CreditUnderwritingRecordReportDecisionParams;
import com.stripe.param.issuing.CreditUnderwritingRecordRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CreditUnderwritingRecord
extends ApiResource
implements HasId {
    @SerializedName(value="application")
    Application application;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="created_from")
    String createdFrom;
    @SerializedName(value="credit_user")
    CreditUser creditUser;
    @SerializedName(value="decided_at")
    Long decidedAt;
    @SerializedName(value="decision")
    Decision decision;
    @SerializedName(value="decision_deadline")
    Long decisionDeadline;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="underwriting_exception")
    UnderwritingException underwritingException;

    public CreditUnderwritingRecord correct() throws StripeException {
        return this.correct((Map<String, Object>)null, (RequestOptions)null);
    }

    public CreditUnderwritingRecord correct(RequestOptions options) throws StripeException {
        return this.correct((Map<String, Object>)null, options);
    }

    public CreditUnderwritingRecord correct(Map<String, Object> params) throws StripeException {
        return this.correct(params, (RequestOptions)null);
    }

    public CreditUnderwritingRecord correct(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/credit_underwriting_records/%s/correct", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (CreditUnderwritingRecord)this.getResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public CreditUnderwritingRecord correct(CreditUnderwritingRecordCorrectParams params) throws StripeException {
        return this.correct(params, (RequestOptions)null);
    }

    public CreditUnderwritingRecord correct(CreditUnderwritingRecordCorrectParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/credit_underwriting_records/%s/correct", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)this.getResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public static CreditUnderwritingRecord createFromApplication(Map<String, Object> params) throws StripeException {
        return CreditUnderwritingRecord.createFromApplication(params, (RequestOptions)null);
    }

    public static CreditUnderwritingRecord createFromApplication(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/credit_underwriting_records/create_from_application";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (CreditUnderwritingRecord)CreditUnderwritingRecord.getGlobalResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public static CreditUnderwritingRecord createFromApplication(CreditUnderwritingRecordCreateFromApplicationParams params) throws StripeException {
        return CreditUnderwritingRecord.createFromApplication(params, (RequestOptions)null);
    }

    public static CreditUnderwritingRecord createFromApplication(CreditUnderwritingRecordCreateFromApplicationParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/credit_underwriting_records/create_from_application";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)CreditUnderwritingRecord.getGlobalResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public static CreditUnderwritingRecord createFromProactiveReview(Map<String, Object> params) throws StripeException {
        return CreditUnderwritingRecord.createFromProactiveReview(params, (RequestOptions)null);
    }

    public static CreditUnderwritingRecord createFromProactiveReview(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/credit_underwriting_records/create_from_proactive_review";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (CreditUnderwritingRecord)CreditUnderwritingRecord.getGlobalResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public static CreditUnderwritingRecord createFromProactiveReview(CreditUnderwritingRecordCreateFromProactiveReviewParams params) throws StripeException {
        return CreditUnderwritingRecord.createFromProactiveReview(params, (RequestOptions)null);
    }

    public static CreditUnderwritingRecord createFromProactiveReview(CreditUnderwritingRecordCreateFromProactiveReviewParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/credit_underwriting_records/create_from_proactive_review";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)CreditUnderwritingRecord.getGlobalResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public static CreditUnderwritingRecordCollection list(Map<String, Object> params) throws StripeException {
        return CreditUnderwritingRecord.list(params, (RequestOptions)null);
    }

    public static CreditUnderwritingRecordCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/credit_underwriting_records";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (CreditUnderwritingRecordCollection)CreditUnderwritingRecord.getGlobalResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecordCollection.class));
    }

    public static CreditUnderwritingRecordCollection list(CreditUnderwritingRecordListParams params) throws StripeException {
        return CreditUnderwritingRecord.list(params, (RequestOptions)null);
    }

    public static CreditUnderwritingRecordCollection list(CreditUnderwritingRecordListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/credit_underwriting_records";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecordCollection)CreditUnderwritingRecord.getGlobalResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecordCollection.class));
    }

    public CreditUnderwritingRecord reportDecision(Map<String, Object> params) throws StripeException {
        return this.reportDecision(params, (RequestOptions)null);
    }

    public CreditUnderwritingRecord reportDecision(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/credit_underwriting_records/%s/report_decision", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (CreditUnderwritingRecord)this.getResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public CreditUnderwritingRecord reportDecision(CreditUnderwritingRecordReportDecisionParams params) throws StripeException {
        return this.reportDecision(params, (RequestOptions)null);
    }

    public CreditUnderwritingRecord reportDecision(CreditUnderwritingRecordReportDecisionParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/credit_underwriting_records/%s/report_decision", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)this.getResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public static CreditUnderwritingRecord retrieve(String creditUnderwritingRecord) throws StripeException {
        return CreditUnderwritingRecord.retrieve(creditUnderwritingRecord, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CreditUnderwritingRecord retrieve(String creditUnderwritingRecord, RequestOptions options) throws StripeException {
        return CreditUnderwritingRecord.retrieve(creditUnderwritingRecord, (Map<String, Object>)null, options);
    }

    public static CreditUnderwritingRecord retrieve(String creditUnderwritingRecord, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/credit_underwriting_records/%s", ApiResource.urlEncodeId(creditUnderwritingRecord));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (CreditUnderwritingRecord)CreditUnderwritingRecord.getGlobalResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public static CreditUnderwritingRecord retrieve(String creditUnderwritingRecord, CreditUnderwritingRecordRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/credit_underwriting_records/%s", ApiResource.urlEncodeId(creditUnderwritingRecord));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)CreditUnderwritingRecord.getGlobalResponseGetter().request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.application, responseGetter);
        this.trySetResponseGetter(this.creditUser, responseGetter);
        this.trySetResponseGetter(this.decision, responseGetter);
        this.trySetResponseGetter(this.underwritingException, responseGetter);
    }

    @Generated
    public Application getApplication() {
        return this.application;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCreatedFrom() {
        return this.createdFrom;
    }

    @Generated
    public CreditUser getCreditUser() {
        return this.creditUser;
    }

    @Generated
    public Long getDecidedAt() {
        return this.decidedAt;
    }

    @Generated
    public Decision getDecision() {
        return this.decision;
    }

    @Generated
    public Long getDecisionDeadline() {
        return this.decisionDeadline;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public UnderwritingException getUnderwritingException() {
        return this.underwritingException;
    }

    @Generated
    public void setApplication(Application application) {
        this.application = application;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCreatedFrom(String createdFrom) {
        this.createdFrom = createdFrom;
    }

    @Generated
    public void setCreditUser(CreditUser creditUser) {
        this.creditUser = creditUser;
    }

    @Generated
    public void setDecidedAt(Long decidedAt) {
        this.decidedAt = decidedAt;
    }

    @Generated
    public void setDecision(Decision decision) {
        this.decision = decision;
    }

    @Generated
    public void setDecisionDeadline(Long decisionDeadline) {
        this.decisionDeadline = decisionDeadline;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setUnderwritingException(UnderwritingException underwritingException) {
        this.underwritingException = underwritingException;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreditUnderwritingRecord)) {
            return false;
        }
        CreditUnderwritingRecord other = (CreditUnderwritingRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$decidedAt = this.getDecidedAt();
        Long other$decidedAt = other.getDecidedAt();
        if (this$decidedAt == null ? other$decidedAt != null : !((Object)this$decidedAt).equals(other$decidedAt)) {
            return false;
        }
        Long this$decisionDeadline = this.getDecisionDeadline();
        Long other$decisionDeadline = other.getDecisionDeadline();
        if (this$decisionDeadline == null ? other$decisionDeadline != null : !((Object)this$decisionDeadline).equals(other$decisionDeadline)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Application this$application = this.getApplication();
        Application other$application = other.getApplication();
        if (this$application == null ? other$application != null : !((Object)this$application).equals(other$application)) {
            return false;
        }
        String this$createdFrom = this.getCreatedFrom();
        String other$createdFrom = other.getCreatedFrom();
        if (this$createdFrom == null ? other$createdFrom != null : !this$createdFrom.equals(other$createdFrom)) {
            return false;
        }
        CreditUser this$creditUser = this.getCreditUser();
        CreditUser other$creditUser = other.getCreditUser();
        if (this$creditUser == null ? other$creditUser != null : !((Object)this$creditUser).equals(other$creditUser)) {
            return false;
        }
        Decision this$decision = this.getDecision();
        Decision other$decision = other.getDecision();
        if (this$decision == null ? other$decision != null : !((Object)this$decision).equals(other$decision)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        UnderwritingException this$underwritingException = this.getUnderwritingException();
        UnderwritingException other$underwritingException = other.getUnderwritingException();
        return !(this$underwritingException == null ? other$underwritingException != null : !((Object)this$underwritingException).equals(other$underwritingException));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreditUnderwritingRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $decidedAt = this.getDecidedAt();
        result = result * 59 + ($decidedAt == null ? 43 : ((Object)$decidedAt).hashCode());
        Long $decisionDeadline = this.getDecisionDeadline();
        result = result * 59 + ($decisionDeadline == null ? 43 : ((Object)$decisionDeadline).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Application $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : ((Object)$application).hashCode());
        String $createdFrom = this.getCreatedFrom();
        result = result * 59 + ($createdFrom == null ? 43 : $createdFrom.hashCode());
        CreditUser $creditUser = this.getCreditUser();
        result = result * 59 + ($creditUser == null ? 43 : ((Object)$creditUser).hashCode());
        Decision $decision = this.getDecision();
        result = result * 59 + ($decision == null ? 43 : ((Object)$decision).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        UnderwritingException $underwritingException = this.getUnderwritingException();
        result = result * 59 + ($underwritingException == null ? 43 : ((Object)$underwritingException).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Application
    extends StripeObject {
        @SerializedName(value="application_method")
        String applicationMethod;
        @SerializedName(value="purpose")
        String purpose;
        @SerializedName(value="submitted_at")
        Long submittedAt;

        @Generated
        public String getApplicationMethod() {
            return this.applicationMethod;
        }

        @Generated
        public String getPurpose() {
            return this.purpose;
        }

        @Generated
        public Long getSubmittedAt() {
            return this.submittedAt;
        }

        @Generated
        public void setApplicationMethod(String applicationMethod) {
            this.applicationMethod = applicationMethod;
        }

        @Generated
        public void setPurpose(String purpose) {
            this.purpose = purpose;
        }

        @Generated
        public void setSubmittedAt(Long submittedAt) {
            this.submittedAt = submittedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Application)) {
                return false;
            }
            Application other = (Application)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$submittedAt = this.getSubmittedAt();
            Long other$submittedAt = other.getSubmittedAt();
            if (this$submittedAt == null ? other$submittedAt != null : !((Object)this$submittedAt).equals(other$submittedAt)) {
                return false;
            }
            String this$applicationMethod = this.getApplicationMethod();
            String other$applicationMethod = other.getApplicationMethod();
            if (this$applicationMethod == null ? other$applicationMethod != null : !this$applicationMethod.equals(other$applicationMethod)) {
                return false;
            }
            String this$purpose = this.getPurpose();
            String other$purpose = other.getPurpose();
            return !(this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Application;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $submittedAt = this.getSubmittedAt();
            result = result * 59 + ($submittedAt == null ? 43 : ((Object)$submittedAt).hashCode());
            String $applicationMethod = this.getApplicationMethod();
            result = result * 59 + ($applicationMethod == null ? 43 : $applicationMethod.hashCode());
            String $purpose = this.getPurpose();
            result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
            return result;
        }
    }

    public static class CreditUser
    extends StripeObject {
        @SerializedName(value="email")
        String email;
        @SerializedName(value="name")
        String name;

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreditUser)) {
                return false;
            }
            CreditUser other = (CreditUser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreditUser;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }

    public static class Decision
    extends StripeObject {
        @SerializedName(value="application_rejected")
        ApplicationRejected applicationRejected;
        @SerializedName(value="credit_limit_approved")
        CreditLimitApproved creditLimitApproved;
        @SerializedName(value="credit_limit_decreased")
        CreditLimitDecreased creditLimitDecreased;
        @SerializedName(value="credit_line_closed")
        CreditLineClosed creditLineClosed;
        @SerializedName(value="type")
        String type;

        @Generated
        public ApplicationRejected getApplicationRejected() {
            return this.applicationRejected;
        }

        @Generated
        public CreditLimitApproved getCreditLimitApproved() {
            return this.creditLimitApproved;
        }

        @Generated
        public CreditLimitDecreased getCreditLimitDecreased() {
            return this.creditLimitDecreased;
        }

        @Generated
        public CreditLineClosed getCreditLineClosed() {
            return this.creditLineClosed;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setApplicationRejected(ApplicationRejected applicationRejected) {
            this.applicationRejected = applicationRejected;
        }

        @Generated
        public void setCreditLimitApproved(CreditLimitApproved creditLimitApproved) {
            this.creditLimitApproved = creditLimitApproved;
        }

        @Generated
        public void setCreditLimitDecreased(CreditLimitDecreased creditLimitDecreased) {
            this.creditLimitDecreased = creditLimitDecreased;
        }

        @Generated
        public void setCreditLineClosed(CreditLineClosed creditLineClosed) {
            this.creditLineClosed = creditLineClosed;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Decision)) {
                return false;
            }
            Decision other = (Decision)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ApplicationRejected this$applicationRejected = this.getApplicationRejected();
            ApplicationRejected other$applicationRejected = other.getApplicationRejected();
            if (this$applicationRejected == null ? other$applicationRejected != null : !((Object)this$applicationRejected).equals(other$applicationRejected)) {
                return false;
            }
            CreditLimitApproved this$creditLimitApproved = this.getCreditLimitApproved();
            CreditLimitApproved other$creditLimitApproved = other.getCreditLimitApproved();
            if (this$creditLimitApproved == null ? other$creditLimitApproved != null : !((Object)this$creditLimitApproved).equals(other$creditLimitApproved)) {
                return false;
            }
            CreditLimitDecreased this$creditLimitDecreased = this.getCreditLimitDecreased();
            CreditLimitDecreased other$creditLimitDecreased = other.getCreditLimitDecreased();
            if (this$creditLimitDecreased == null ? other$creditLimitDecreased != null : !((Object)this$creditLimitDecreased).equals(other$creditLimitDecreased)) {
                return false;
            }
            CreditLineClosed this$creditLineClosed = this.getCreditLineClosed();
            CreditLineClosed other$creditLineClosed = other.getCreditLineClosed();
            if (this$creditLineClosed == null ? other$creditLineClosed != null : !((Object)this$creditLineClosed).equals(other$creditLineClosed)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Decision;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ApplicationRejected $applicationRejected = this.getApplicationRejected();
            result = result * 59 + ($applicationRejected == null ? 43 : ((Object)$applicationRejected).hashCode());
            CreditLimitApproved $creditLimitApproved = this.getCreditLimitApproved();
            result = result * 59 + ($creditLimitApproved == null ? 43 : ((Object)$creditLimitApproved).hashCode());
            CreditLimitDecreased $creditLimitDecreased = this.getCreditLimitDecreased();
            result = result * 59 + ($creditLimitDecreased == null ? 43 : ((Object)$creditLimitDecreased).hashCode());
            CreditLineClosed $creditLineClosed = this.getCreditLineClosed();
            result = result * 59 + ($creditLineClosed == null ? 43 : ((Object)$creditLineClosed).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class ApplicationRejected
        extends StripeObject {
            @SerializedName(value="reason_other_explanation")
            String reasonOtherExplanation;
            @SerializedName(value="reasons")
            List<String> reasons;

            @Generated
            public String getReasonOtherExplanation() {
                return this.reasonOtherExplanation;
            }

            @Generated
            public List<String> getReasons() {
                return this.reasons;
            }

            @Generated
            public void setReasonOtherExplanation(String reasonOtherExplanation) {
                this.reasonOtherExplanation = reasonOtherExplanation;
            }

            @Generated
            public void setReasons(List<String> reasons) {
                this.reasons = reasons;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ApplicationRejected)) {
                    return false;
                }
                ApplicationRejected other = (ApplicationRejected)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reasonOtherExplanation = this.getReasonOtherExplanation();
                String other$reasonOtherExplanation = other.getReasonOtherExplanation();
                if (this$reasonOtherExplanation == null ? other$reasonOtherExplanation != null : !this$reasonOtherExplanation.equals(other$reasonOtherExplanation)) {
                    return false;
                }
                List<String> this$reasons = this.getReasons();
                List<String> other$reasons = other.getReasons();
                return !(this$reasons == null ? other$reasons != null : !((Object)this$reasons).equals(other$reasons));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ApplicationRejected;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reasonOtherExplanation = this.getReasonOtherExplanation();
                result = result * 59 + ($reasonOtherExplanation == null ? 43 : $reasonOtherExplanation.hashCode());
                List<String> $reasons = this.getReasons();
                result = result * 59 + ($reasons == null ? 43 : ((Object)$reasons).hashCode());
                return result;
            }
        }

        public static class CreditLimitApproved
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CreditLimitApproved)) {
                    return false;
                }
                CreditLimitApproved other = (CreditLimitApproved)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CreditLimitApproved;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                return result;
            }
        }

        public static class CreditLimitDecreased
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="reason_other_explanation")
            String reasonOtherExplanation;
            @SerializedName(value="reasons")
            List<String> reasons;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public String getReasonOtherExplanation() {
                return this.reasonOtherExplanation;
            }

            @Generated
            public List<String> getReasons() {
                return this.reasons;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setReasonOtherExplanation(String reasonOtherExplanation) {
                this.reasonOtherExplanation = reasonOtherExplanation;
            }

            @Generated
            public void setReasons(List<String> reasons) {
                this.reasons = reasons;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CreditLimitDecreased)) {
                    return false;
                }
                CreditLimitDecreased other = (CreditLimitDecreased)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                String this$reasonOtherExplanation = this.getReasonOtherExplanation();
                String other$reasonOtherExplanation = other.getReasonOtherExplanation();
                if (this$reasonOtherExplanation == null ? other$reasonOtherExplanation != null : !this$reasonOtherExplanation.equals(other$reasonOtherExplanation)) {
                    return false;
                }
                List<String> this$reasons = this.getReasons();
                List<String> other$reasons = other.getReasons();
                return !(this$reasons == null ? other$reasons != null : !((Object)this$reasons).equals(other$reasons));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CreditLimitDecreased;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                String $reasonOtherExplanation = this.getReasonOtherExplanation();
                result = result * 59 + ($reasonOtherExplanation == null ? 43 : $reasonOtherExplanation.hashCode());
                List<String> $reasons = this.getReasons();
                result = result * 59 + ($reasons == null ? 43 : ((Object)$reasons).hashCode());
                return result;
            }
        }

        public static class CreditLineClosed
        extends StripeObject {
            @SerializedName(value="reason_other_explanation")
            String reasonOtherExplanation;
            @SerializedName(value="reasons")
            List<String> reasons;

            @Generated
            public String getReasonOtherExplanation() {
                return this.reasonOtherExplanation;
            }

            @Generated
            public List<String> getReasons() {
                return this.reasons;
            }

            @Generated
            public void setReasonOtherExplanation(String reasonOtherExplanation) {
                this.reasonOtherExplanation = reasonOtherExplanation;
            }

            @Generated
            public void setReasons(List<String> reasons) {
                this.reasons = reasons;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CreditLineClosed)) {
                    return false;
                }
                CreditLineClosed other = (CreditLineClosed)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reasonOtherExplanation = this.getReasonOtherExplanation();
                String other$reasonOtherExplanation = other.getReasonOtherExplanation();
                if (this$reasonOtherExplanation == null ? other$reasonOtherExplanation != null : !this$reasonOtherExplanation.equals(other$reasonOtherExplanation)) {
                    return false;
                }
                List<String> this$reasons = this.getReasons();
                List<String> other$reasons = other.getReasons();
                return !(this$reasons == null ? other$reasons != null : !((Object)this$reasons).equals(other$reasons));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CreditLineClosed;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reasonOtherExplanation = this.getReasonOtherExplanation();
                result = result * 59 + ($reasonOtherExplanation == null ? 43 : $reasonOtherExplanation.hashCode());
                List<String> $reasons = this.getReasons();
                result = result * 59 + ($reasons == null ? 43 : ((Object)$reasons).hashCode());
                return result;
            }
        }
    }

    public static class UnderwritingException
    extends StripeObject {
        @SerializedName(value="explanation")
        String explanation;
        @SerializedName(value="original_decision_type")
        String originalDecisionType;

        @Generated
        public String getExplanation() {
            return this.explanation;
        }

        @Generated
        public String getOriginalDecisionType() {
            return this.originalDecisionType;
        }

        @Generated
        public void setExplanation(String explanation) {
            this.explanation = explanation;
        }

        @Generated
        public void setOriginalDecisionType(String originalDecisionType) {
            this.originalDecisionType = originalDecisionType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnderwritingException)) {
                return false;
            }
            UnderwritingException other = (UnderwritingException)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$explanation = this.getExplanation();
            String other$explanation = other.getExplanation();
            if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) {
                return false;
            }
            String this$originalDecisionType = this.getOriginalDecisionType();
            String other$originalDecisionType = other.getOriginalDecisionType();
            return !(this$originalDecisionType == null ? other$originalDecisionType != null : !this$originalDecisionType.equals(other$originalDecisionType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UnderwritingException;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $explanation = this.getExplanation();
            result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
            String $originalDecisionType = this.getOriginalDecisionType();
            result = result * 59 + ($originalDecisionType == null ? 43 : $originalDecisionType.hashCode());
            return result;
        }
    }
}

