/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.AccountNotice;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.AccountNoticeListParams;
import com.stripe.param.AccountNoticeRetrieveParams;
import com.stripe.param.AccountNoticeUpdateParams;
import java.lang.reflect.Type;

public final class AccountNoticeService
extends ApiService {
    public AccountNoticeService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<AccountNotice> list(AccountNoticeListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<AccountNotice> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<AccountNotice> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<AccountNotice> list(AccountNoticeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/account_notices";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<AccountNotice>>(){}.getType());
    }

    public AccountNotice retrieve(String accountNotice, AccountNoticeRetrieveParams params) throws StripeException {
        return this.retrieve(accountNotice, params, null);
    }

    public AccountNotice retrieve(String accountNotice, RequestOptions options) throws StripeException {
        return this.retrieve(accountNotice, null, options);
    }

    public AccountNotice retrieve(String accountNotice) throws StripeException {
        return this.retrieve(accountNotice, null, null);
    }

    public AccountNotice retrieve(String accountNotice, AccountNoticeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/account_notices/%s", ApiResource.urlEncodeId(accountNotice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (AccountNotice)this.request(request, (Type)((Object)AccountNotice.class));
    }

    public AccountNotice update(String accountNotice, AccountNoticeUpdateParams params) throws StripeException {
        return this.update(accountNotice, params, null);
    }

    public AccountNotice update(String accountNotice, AccountNoticeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/account_notices/%s", ApiResource.urlEncodeId(accountNotice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (AccountNotice)this.request(request, (Type)((Object)AccountNotice.class));
    }
}

