/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.forwarding;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.forwarding.RequestCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.forwarding.RequestCreateParams;
import com.stripe.param.forwarding.RequestListParams;
import com.stripe.param.forwarding.RequestRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Request
extends ApiResource
implements HasId {
    @SerializedName(value="config")
    String config;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="replacements")
    List<String> replacements;
    @SerializedName(value="request_context")
    RequestContext requestContext;
    @SerializedName(value="request_details")
    RequestDetails requestDetails;
    @SerializedName(value="response_details")
    ResponseDetails responseDetails;
    @SerializedName(value="url")
    String url;

    public static Request create(Map<String, Object> params) throws StripeException {
        return Request.create(params, (RequestOptions)null);
    }

    public static Request create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/forwarding/requests";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Request)Request.getGlobalResponseGetter().request(request, (Type)((Object)Request.class));
    }

    public static Request create(RequestCreateParams params) throws StripeException {
        return Request.create(params, (RequestOptions)null);
    }

    public static Request create(RequestCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/forwarding/requests";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Request)Request.getGlobalResponseGetter().request(request, (Type)((Object)Request.class));
    }

    public static RequestCollection list(Map<String, Object> params) throws StripeException {
        return Request.list(params, (RequestOptions)null);
    }

    public static RequestCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/forwarding/requests";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (RequestCollection)Request.getGlobalResponseGetter().request(request, (Type)((Object)RequestCollection.class));
    }

    public static RequestCollection list(RequestListParams params) throws StripeException {
        return Request.list(params, (RequestOptions)null);
    }

    public static RequestCollection list(RequestListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/forwarding/requests";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (RequestCollection)Request.getGlobalResponseGetter().request(request, (Type)((Object)RequestCollection.class));
    }

    public static Request retrieve(String id) throws StripeException {
        return Request.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Request retrieve(String id, RequestOptions options) throws StripeException {
        return Request.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Request retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/forwarding/requests/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Request)Request.getGlobalResponseGetter().request(request, (Type)((Object)Request.class));
    }

    public static Request retrieve(String id, RequestRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/forwarding/requests/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Request)Request.getGlobalResponseGetter().request(request, (Type)((Object)Request.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.requestContext, responseGetter);
        this.trySetResponseGetter(this.requestDetails, responseGetter);
        this.trySetResponseGetter(this.responseDetails, responseGetter);
    }

    @Generated
    public String getConfig() {
        return this.config;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public List<String> getReplacements() {
        return this.replacements;
    }

    @Generated
    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    @Generated
    public RequestDetails getRequestDetails() {
        return this.requestDetails;
    }

    @Generated
    public ResponseDetails getResponseDetails() {
        return this.responseDetails;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setConfig(String config) {
        this.config = config;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Generated
    public void setReplacements(List<String> replacements) {
        this.replacements = replacements;
    }

    @Generated
    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Generated
    public void setRequestDetails(RequestDetails requestDetails) {
        this.requestDetails = requestDetails;
    }

    @Generated
    public void setResponseDetails(ResponseDetails responseDetails) {
        this.responseDetails = responseDetails;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$config = this.getConfig();
        String other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        List<String> this$replacements = this.getReplacements();
        List<String> other$replacements = other.getReplacements();
        if (this$replacements == null ? other$replacements != null : !((Object)this$replacements).equals(other$replacements)) {
            return false;
        }
        RequestContext this$requestContext = this.getRequestContext();
        RequestContext other$requestContext = other.getRequestContext();
        if (this$requestContext == null ? other$requestContext != null : !((Object)this$requestContext).equals(other$requestContext)) {
            return false;
        }
        RequestDetails this$requestDetails = this.getRequestDetails();
        RequestDetails other$requestDetails = other.getRequestDetails();
        if (this$requestDetails == null ? other$requestDetails != null : !((Object)this$requestDetails).equals(other$requestDetails)) {
            return false;
        }
        ResponseDetails this$responseDetails = this.getResponseDetails();
        ResponseDetails other$responseDetails = other.getResponseDetails();
        if (this$responseDetails == null ? other$responseDetails != null : !((Object)this$responseDetails).equals(other$responseDetails)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        List<String> $replacements = this.getReplacements();
        result = result * 59 + ($replacements == null ? 43 : ((Object)$replacements).hashCode());
        RequestContext $requestContext = this.getRequestContext();
        result = result * 59 + ($requestContext == null ? 43 : ((Object)$requestContext).hashCode());
        RequestDetails $requestDetails = this.getRequestDetails();
        result = result * 59 + ($requestDetails == null ? 43 : ((Object)$requestDetails).hashCode());
        ResponseDetails $responseDetails = this.getResponseDetails();
        result = result * 59 + ($responseDetails == null ? 43 : ((Object)$responseDetails).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class RequestContext
    extends StripeObject {
        @SerializedName(value="destination_duration")
        Long destinationDuration;
        @SerializedName(value="destination_ip_address")
        String destinationIpAddress;

        @Generated
        public Long getDestinationDuration() {
            return this.destinationDuration;
        }

        @Generated
        public String getDestinationIpAddress() {
            return this.destinationIpAddress;
        }

        @Generated
        public void setDestinationDuration(Long destinationDuration) {
            this.destinationDuration = destinationDuration;
        }

        @Generated
        public void setDestinationIpAddress(String destinationIpAddress) {
            this.destinationIpAddress = destinationIpAddress;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestContext)) {
                return false;
            }
            RequestContext other = (RequestContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$destinationDuration = this.getDestinationDuration();
            Long other$destinationDuration = other.getDestinationDuration();
            if (this$destinationDuration == null ? other$destinationDuration != null : !((Object)this$destinationDuration).equals(other$destinationDuration)) {
                return false;
            }
            String this$destinationIpAddress = this.getDestinationIpAddress();
            String other$destinationIpAddress = other.getDestinationIpAddress();
            return !(this$destinationIpAddress == null ? other$destinationIpAddress != null : !this$destinationIpAddress.equals(other$destinationIpAddress));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $destinationDuration = this.getDestinationDuration();
            result = result * 59 + ($destinationDuration == null ? 43 : ((Object)$destinationDuration).hashCode());
            String $destinationIpAddress = this.getDestinationIpAddress();
            result = result * 59 + ($destinationIpAddress == null ? 43 : $destinationIpAddress.hashCode());
            return result;
        }
    }

    public static class RequestDetails
    extends StripeObject {
        @SerializedName(value="body")
        String body;
        @SerializedName(value="headers")
        List<Header> headers;
        @SerializedName(value="http_method")
        String httpMethod;

        @Generated
        public String getBody() {
            return this.body;
        }

        @Generated
        public List<Header> getHeaders() {
            return this.headers;
        }

        @Generated
        public String getHttpMethod() {
            return this.httpMethod;
        }

        @Generated
        public void setBody(String body) {
            this.body = body;
        }

        @Generated
        public void setHeaders(List<Header> headers) {
            this.headers = headers;
        }

        @Generated
        public void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestDetails)) {
                return false;
            }
            RequestDetails other = (RequestDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            List<Header> this$headers = this.getHeaders();
            List<Header> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$httpMethod = this.getHttpMethod();
            String other$httpMethod = other.getHttpMethod();
            return !(this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            List<Header> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $httpMethod = this.getHttpMethod();
            result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
            return result;
        }

        public static class Header
        extends StripeObject {
            @SerializedName(value="name")
            String name;
            @SerializedName(value="value")
            String value;

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Header)) {
                    return false;
                }
                Header other = (Header)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Header;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class ResponseDetails
    extends StripeObject {
        @SerializedName(value="body")
        String body;
        @SerializedName(value="headers")
        List<Header> headers;
        @SerializedName(value="status")
        Long status;

        @Generated
        public String getBody() {
            return this.body;
        }

        @Generated
        public List<Header> getHeaders() {
            return this.headers;
        }

        @Generated
        public Long getStatus() {
            return this.status;
        }

        @Generated
        public void setBody(String body) {
            this.body = body;
        }

        @Generated
        public void setHeaders(List<Header> headers) {
            this.headers = headers;
        }

        @Generated
        public void setStatus(Long status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseDetails)) {
                return false;
            }
            ResponseDetails other = (ResponseDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$status = this.getStatus();
            Long other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            List<Header> this$headers = this.getHeaders();
            List<Header> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResponseDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            List<Header> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        public static class Header
        extends StripeObject {
            @SerializedName(value="name")
            String name;
            @SerializedName(value="value")
            String value;

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Header)) {
                    return false;
                }
                Header other = (Header)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Header;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }
}

