/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Address;
import com.stripe.model.Application;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.LineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.OrderCollection;
import com.stripe.model.PaymentIntent;
import com.stripe.model.ShippingRate;
import com.stripe.model.StripeObject;
import com.stripe.model.TaxRate;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.OrderCancelParams;
import com.stripe.param.OrderCreateParams;
import com.stripe.param.OrderListLineItemsParams;
import com.stripe.param.OrderListParams;
import com.stripe.param.OrderReopenParams;
import com.stripe.param.OrderRetrieveParams;
import com.stripe.param.OrderSubmitParams;
import com.stripe.param.OrderUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Order
extends ApiResource
implements HasId,
MetadataStore<Order> {
    @SerializedName(value="amount_remaining")
    Long amountRemaining;
    @SerializedName(value="amount_subtotal")
    Long amountSubtotal;
    @SerializedName(value="amount_total")
    Long amountTotal;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="billing_details")
    BillingDetails billingDetails;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="credits")
    List<Credit> credits;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="ip_address")
    String ipAddress;
    @SerializedName(value="line_items")
    LineItemCollection lineItems;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment")
    Payment payment;
    @SerializedName(value="shipping_cost")
    ShippingCost shippingCost;
    @SerializedName(value="shipping_details")
    ShippingDetails shippingDetails;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="tax_details")
    TaxDetails taxDetails;
    @SerializedName(value="total_details")
    TotalDetails totalDetails;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public Order cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Order cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public Order cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Order cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Order)this.getResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public Order cancel(OrderCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Order cancel(OrderCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.getResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public static Order create(Map<String, Object> params) throws StripeException {
        return Order.create(params, (RequestOptions)null);
    }

    public static Order create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/orders";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Order)Order.getGlobalResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public static Order create(OrderCreateParams params) throws StripeException {
        return Order.create(params, (RequestOptions)null);
    }

    public static Order create(OrderCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/orders";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)Order.getGlobalResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public static OrderCollection list(Map<String, Object> params) throws StripeException {
        return Order.list(params, (RequestOptions)null);
    }

    public static OrderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/orders";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (OrderCollection)Order.getGlobalResponseGetter().request(request, (Type)((Object)OrderCollection.class));
    }

    public static OrderCollection list(OrderListParams params) throws StripeException {
        return Order.list(params, (RequestOptions)null);
    }

    public static OrderCollection list(OrderListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/orders";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (OrderCollection)Order.getGlobalResponseGetter().request(request, (Type)((Object)OrderCollection.class));
    }

    public LineItemCollection listLineItems() throws StripeException {
        return this.listLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/line_items", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (LineItemCollection)this.getResponseGetter().request(request, (Type)((Object)LineItemCollection.class));
    }

    public LineItemCollection listLineItems(OrderListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(OrderListLineItemsParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/line_items", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (LineItemCollection)this.getResponseGetter().request(request, (Type)((Object)LineItemCollection.class));
    }

    public Order reopen() throws StripeException {
        return this.reopen((Map<String, Object>)null, (RequestOptions)null);
    }

    public Order reopen(RequestOptions options) throws StripeException {
        return this.reopen((Map<String, Object>)null, options);
    }

    public Order reopen(Map<String, Object> params) throws StripeException {
        return this.reopen(params, (RequestOptions)null);
    }

    public Order reopen(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/reopen", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Order)this.getResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public Order reopen(OrderReopenParams params) throws StripeException {
        return this.reopen(params, (RequestOptions)null);
    }

    public Order reopen(OrderReopenParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/reopen", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.getResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public static Order retrieve(String id) throws StripeException {
        return Order.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Order retrieve(String id, RequestOptions options) throws StripeException {
        return Order.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Order retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Order)Order.getGlobalResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public static Order retrieve(String id, OrderRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)Order.getGlobalResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public Order submit(Map<String, Object> params) throws StripeException {
        return this.submit(params, (RequestOptions)null);
    }

    public Order submit(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/submit", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Order)this.getResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public Order submit(OrderSubmitParams params) throws StripeException {
        return this.submit(params, (RequestOptions)null);
    }

    public Order submit(OrderSubmitParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s/submit", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.getResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public Order update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Order update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Order)this.getResponseGetter().request(request, (Type)((Object)Order.class));
    }

    public Order update(OrderUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Order update(OrderUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/orders/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Order)this.getResponseGetter().request(request, (Type)((Object)Order.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.application, responseGetter);
        this.trySetResponseGetter(this.automaticTax, responseGetter);
        this.trySetResponseGetter(this.billingDetails, responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
        this.trySetResponseGetter(this.lineItems, responseGetter);
        this.trySetResponseGetter(this.payment, responseGetter);
        this.trySetResponseGetter(this.shippingCost, responseGetter);
        this.trySetResponseGetter(this.shippingDetails, responseGetter);
        this.trySetResponseGetter(this.taxDetails, responseGetter);
        this.trySetResponseGetter(this.totalDetails, responseGetter);
    }

    @Generated
    public Long getAmountRemaining() {
        return this.amountRemaining;
    }

    @Generated
    public Long getAmountSubtotal() {
        return this.amountSubtotal;
    }

    @Generated
    public Long getAmountTotal() {
        return this.amountTotal;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public BillingDetails getBillingDetails() {
        return this.billingDetails;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public List<Credit> getCredits() {
        return this.credits;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public LineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Payment getPayment() {
        return this.payment;
    }

    @Generated
    public ShippingCost getShippingCost() {
        return this.shippingCost;
    }

    @Generated
    public ShippingDetails getShippingDetails() {
        return this.shippingDetails;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public TaxDetails getTaxDetails() {
        return this.taxDetails;
    }

    @Generated
    public TotalDetails getTotalDetails() {
        return this.totalDetails;
    }

    @Generated
    public void setAmountRemaining(Long amountRemaining) {
        this.amountRemaining = amountRemaining;
    }

    @Generated
    public void setAmountSubtotal(Long amountSubtotal) {
        this.amountSubtotal = amountSubtotal;
    }

    @Generated
    public void setAmountTotal(Long amountTotal) {
        this.amountTotal = amountTotal;
    }

    @Generated
    public void setAutomaticTax(AutomaticTax automaticTax) {
        this.automaticTax = automaticTax;
    }

    @Generated
    public void setBillingDetails(BillingDetails billingDetails) {
        this.billingDetails = billingDetails;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCredits(List<Credit> credits) {
        this.credits = credits;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setLineItems(LineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    @Generated
    public void setShippingCost(ShippingCost shippingCost) {
        this.shippingCost = shippingCost;
    }

    @Generated
    public void setShippingDetails(ShippingDetails shippingDetails) {
        this.shippingDetails = shippingDetails;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTaxDetails(TaxDetails taxDetails) {
        this.taxDetails = taxDetails;
    }

    @Generated
    public void setTotalDetails(TotalDetails totalDetails) {
        this.totalDetails = totalDetails;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amountRemaining = this.getAmountRemaining();
        Long other$amountRemaining = other.getAmountRemaining();
        if (this$amountRemaining == null ? other$amountRemaining != null : !((Object)this$amountRemaining).equals(other$amountRemaining)) {
            return false;
        }
        Long this$amountSubtotal = this.getAmountSubtotal();
        Long other$amountSubtotal = other.getAmountSubtotal();
        if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
            return false;
        }
        Long this$amountTotal = this.getAmountTotal();
        Long other$amountTotal = other.getAmountTotal();
        if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        AutomaticTax this$automaticTax = this.getAutomaticTax();
        AutomaticTax other$automaticTax = other.getAutomaticTax();
        if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
            return false;
        }
        BillingDetails this$billingDetails = this.getBillingDetails();
        BillingDetails other$billingDetails = other.getBillingDetails();
        if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        List<Credit> this$credits = this.getCredits();
        List<Credit> other$credits = other.getCredits();
        if (this$credits == null ? other$credits != null : !((Object)this$credits).equals(other$credits)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        LineItemCollection this$lineItems = this.getLineItems();
        LineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Payment this$payment = this.getPayment();
        Payment other$payment = other.getPayment();
        if (this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment)) {
            return false;
        }
        ShippingCost this$shippingCost = this.getShippingCost();
        ShippingCost other$shippingCost = other.getShippingCost();
        if (this$shippingCost == null ? other$shippingCost != null : !((Object)this$shippingCost).equals(other$shippingCost)) {
            return false;
        }
        ShippingDetails this$shippingDetails = this.getShippingDetails();
        ShippingDetails other$shippingDetails = other.getShippingDetails();
        if (this$shippingDetails == null ? other$shippingDetails != null : !((Object)this$shippingDetails).equals(other$shippingDetails)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        TaxDetails this$taxDetails = this.getTaxDetails();
        TaxDetails other$taxDetails = other.getTaxDetails();
        if (this$taxDetails == null ? other$taxDetails != null : !((Object)this$taxDetails).equals(other$taxDetails)) {
            return false;
        }
        TotalDetails this$totalDetails = this.getTotalDetails();
        TotalDetails other$totalDetails = other.getTotalDetails();
        return !(this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Order;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amountRemaining = this.getAmountRemaining();
        result = result * 59 + ($amountRemaining == null ? 43 : ((Object)$amountRemaining).hashCode());
        Long $amountSubtotal = this.getAmountSubtotal();
        result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
        Long $amountTotal = this.getAmountTotal();
        result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        AutomaticTax $automaticTax = this.getAutomaticTax();
        result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
        BillingDetails $billingDetails = this.getBillingDetails();
        result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        List<Credit> $credits = this.getCredits();
        result = result * 59 + ($credits == null ? 43 : ((Object)$credits).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        LineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Payment $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
        ShippingCost $shippingCost = this.getShippingCost();
        result = result * 59 + ($shippingCost == null ? 43 : ((Object)$shippingCost).hashCode());
        ShippingDetails $shippingDetails = this.getShippingDetails();
        result = result * 59 + ($shippingDetails == null ? 43 : ((Object)$shippingDetails).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        TaxDetails $taxDetails = this.getTaxDetails();
        result = result * 59 + ($taxDetails == null ? 43 : ((Object)$taxDetails).hashCode());
        TotalDetails $totalDetails = this.getTotalDetails();
        result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AutomaticTax
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="status")
        String status;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticTax)) {
                return false;
            }
            AutomaticTax other = (AutomaticTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticTax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class BillingDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BillingDetails)) {
                return false;
            }
            BillingDetails other = (BillingDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BillingDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }
    }

    public static class Payment
    extends StripeObject {
        @SerializedName(value="payment_intent")
        ExpandableField<PaymentIntent> paymentIntent;
        @SerializedName(value="settings")
        Settings settings;
        @SerializedName(value="status")
        String status;

        public String getPaymentIntent() {
            return this.paymentIntent != null ? this.paymentIntent.getId() : null;
        }

        public void setPaymentIntent(String id) {
            this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
        }

        public PaymentIntent getPaymentIntentObject() {
            return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
        }

        public void setPaymentIntentObject(PaymentIntent expandableObject) {
            this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Settings getSettings() {
            return this.settings;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setSettings(Settings settings) {
            this.settings = settings;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payment)) {
                return false;
            }
            Payment other = (Payment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$paymentIntent = this.getPaymentIntent();
            String other$paymentIntent = other.getPaymentIntent();
            if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
                return false;
            }
            Settings this$settings = this.getSettings();
            Settings other$settings = other.getSettings();
            if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Payment;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $paymentIntent = this.getPaymentIntent();
            result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
            Settings $settings = this.getSettings();
            result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public static class Settings
        extends StripeObject {
            @SerializedName(value="application_fee_amount")
            Long applicationFeeAmount;
            @SerializedName(value="automatic_payment_methods")
            AutomaticPaymentMethods automaticPaymentMethods;
            @SerializedName(value="payment_method_options")
            PaymentMethodOptions paymentMethodOptions;
            @SerializedName(value="payment_method_types")
            List<String> paymentMethodTypes;
            @SerializedName(value="return_url")
            String returnUrl;
            @SerializedName(value="statement_descriptor")
            String statementDescriptor;
            @SerializedName(value="statement_descriptor_suffix")
            String statementDescriptorSuffix;
            @SerializedName(value="transfer_data")
            TransferData transferData;

            @Generated
            public Long getApplicationFeeAmount() {
                return this.applicationFeeAmount;
            }

            @Generated
            public AutomaticPaymentMethods getAutomaticPaymentMethods() {
                return this.automaticPaymentMethods;
            }

            @Generated
            public PaymentMethodOptions getPaymentMethodOptions() {
                return this.paymentMethodOptions;
            }

            @Generated
            public List<String> getPaymentMethodTypes() {
                return this.paymentMethodTypes;
            }

            @Generated
            public String getReturnUrl() {
                return this.returnUrl;
            }

            @Generated
            public String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            @Generated
            public String getStatementDescriptorSuffix() {
                return this.statementDescriptorSuffix;
            }

            @Generated
            public TransferData getTransferData() {
                return this.transferData;
            }

            @Generated
            public void setApplicationFeeAmount(Long applicationFeeAmount) {
                this.applicationFeeAmount = applicationFeeAmount;
            }

            @Generated
            public void setAutomaticPaymentMethods(AutomaticPaymentMethods automaticPaymentMethods) {
                this.automaticPaymentMethods = automaticPaymentMethods;
            }

            @Generated
            public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
                this.paymentMethodOptions = paymentMethodOptions;
            }

            @Generated
            public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
                this.paymentMethodTypes = paymentMethodTypes;
            }

            @Generated
            public void setReturnUrl(String returnUrl) {
                this.returnUrl = returnUrl;
            }

            @Generated
            public void setStatementDescriptor(String statementDescriptor) {
                this.statementDescriptor = statementDescriptor;
            }

            @Generated
            public void setStatementDescriptorSuffix(String statementDescriptorSuffix) {
                this.statementDescriptorSuffix = statementDescriptorSuffix;
            }

            @Generated
            public void setTransferData(TransferData transferData) {
                this.transferData = transferData;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Settings)) {
                    return false;
                }
                Settings other = (Settings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$applicationFeeAmount = this.getApplicationFeeAmount();
                Long other$applicationFeeAmount = other.getApplicationFeeAmount();
                if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
                    return false;
                }
                AutomaticPaymentMethods this$automaticPaymentMethods = this.getAutomaticPaymentMethods();
                AutomaticPaymentMethods other$automaticPaymentMethods = other.getAutomaticPaymentMethods();
                if (this$automaticPaymentMethods == null ? other$automaticPaymentMethods != null : !((Object)this$automaticPaymentMethods).equals(other$automaticPaymentMethods)) {
                    return false;
                }
                PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
                PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
                if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
                    return false;
                }
                List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
                List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
                if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
                    return false;
                }
                String this$returnUrl = this.getReturnUrl();
                String other$returnUrl = other.getReturnUrl();
                if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                    return false;
                }
                String this$statementDescriptor = this.getStatementDescriptor();
                String other$statementDescriptor = other.getStatementDescriptor();
                if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
                    return false;
                }
                String this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
                String other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
                if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) {
                    return false;
                }
                TransferData this$transferData = this.getTransferData();
                TransferData other$transferData = other.getTransferData();
                return !(this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Settings;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $applicationFeeAmount = this.getApplicationFeeAmount();
                result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
                AutomaticPaymentMethods $automaticPaymentMethods = this.getAutomaticPaymentMethods();
                result = result * 59 + ($automaticPaymentMethods == null ? 43 : ((Object)$automaticPaymentMethods).hashCode());
                PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
                result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
                List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
                result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
                String $returnUrl = this.getReturnUrl();
                result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
                String $statementDescriptor = this.getStatementDescriptor();
                result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
                String $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
                result = result * 59 + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
                TransferData $transferData = this.getTransferData();
                result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
                return result;
            }

            public static class AutomaticPaymentMethods
            extends StripeObject {
                @SerializedName(value="enabled")
                Boolean enabled;

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public void setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AutomaticPaymentMethods)) {
                        return false;
                    }
                    AutomaticPaymentMethods other = (AutomaticPaymentMethods)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$enabled = this.getEnabled();
                    Boolean other$enabled = other.getEnabled();
                    return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof AutomaticPaymentMethods;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $enabled = this.getEnabled();
                    result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                    return result;
                }
            }

            public static class PaymentMethodOptions
            extends StripeObject {
                @SerializedName(value="acss_debit")
                AcssDebit acssDebit;
                @SerializedName(value="afterpay_clearpay")
                AfterpayClearpay afterpayClearpay;
                @SerializedName(value="alipay")
                Alipay alipay;
                @SerializedName(value="bancontact")
                Bancontact bancontact;
                @SerializedName(value="card")
                Card card;
                @SerializedName(value="customer_balance")
                CustomerBalance customerBalance;
                @SerializedName(value="ideal")
                Ideal ideal;
                @SerializedName(value="klarna")
                Klarna klarna;
                @SerializedName(value="link")
                Link link;
                @SerializedName(value="oxxo")
                Oxxo oxxo;
                @SerializedName(value="p24")
                P24 p24;
                @SerializedName(value="paypal")
                Paypal paypal;
                @SerializedName(value="sepa_debit")
                SepaDebit sepaDebit;
                @SerializedName(value="sofort")
                Sofort sofort;
                @SerializedName(value="wechat_pay")
                WechatPay wechatPay;

                @Generated
                public AcssDebit getAcssDebit() {
                    return this.acssDebit;
                }

                @Generated
                public AfterpayClearpay getAfterpayClearpay() {
                    return this.afterpayClearpay;
                }

                @Generated
                public Alipay getAlipay() {
                    return this.alipay;
                }

                @Generated
                public Bancontact getBancontact() {
                    return this.bancontact;
                }

                @Generated
                public Card getCard() {
                    return this.card;
                }

                @Generated
                public CustomerBalance getCustomerBalance() {
                    return this.customerBalance;
                }

                @Generated
                public Ideal getIdeal() {
                    return this.ideal;
                }

                @Generated
                public Klarna getKlarna() {
                    return this.klarna;
                }

                @Generated
                public Link getLink() {
                    return this.link;
                }

                @Generated
                public Oxxo getOxxo() {
                    return this.oxxo;
                }

                @Generated
                public P24 getP24() {
                    return this.p24;
                }

                @Generated
                public Paypal getPaypal() {
                    return this.paypal;
                }

                @Generated
                public SepaDebit getSepaDebit() {
                    return this.sepaDebit;
                }

                @Generated
                public Sofort getSofort() {
                    return this.sofort;
                }

                @Generated
                public WechatPay getWechatPay() {
                    return this.wechatPay;
                }

                @Generated
                public void setAcssDebit(AcssDebit acssDebit) {
                    this.acssDebit = acssDebit;
                }

                @Generated
                public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
                    this.afterpayClearpay = afterpayClearpay;
                }

                @Generated
                public void setAlipay(Alipay alipay) {
                    this.alipay = alipay;
                }

                @Generated
                public void setBancontact(Bancontact bancontact) {
                    this.bancontact = bancontact;
                }

                @Generated
                public void setCard(Card card) {
                    this.card = card;
                }

                @Generated
                public void setCustomerBalance(CustomerBalance customerBalance) {
                    this.customerBalance = customerBalance;
                }

                @Generated
                public void setIdeal(Ideal ideal) {
                    this.ideal = ideal;
                }

                @Generated
                public void setKlarna(Klarna klarna) {
                    this.klarna = klarna;
                }

                @Generated
                public void setLink(Link link) {
                    this.link = link;
                }

                @Generated
                public void setOxxo(Oxxo oxxo) {
                    this.oxxo = oxxo;
                }

                @Generated
                public void setP24(P24 p24) {
                    this.p24 = p24;
                }

                @Generated
                public void setPaypal(Paypal paypal) {
                    this.paypal = paypal;
                }

                @Generated
                public void setSepaDebit(SepaDebit sepaDebit) {
                    this.sepaDebit = sepaDebit;
                }

                @Generated
                public void setSofort(Sofort sofort) {
                    this.sofort = sofort;
                }

                @Generated
                public void setWechatPay(WechatPay wechatPay) {
                    this.wechatPay = wechatPay;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PaymentMethodOptions)) {
                        return false;
                    }
                    PaymentMethodOptions other = (PaymentMethodOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    AcssDebit this$acssDebit = this.getAcssDebit();
                    AcssDebit other$acssDebit = other.getAcssDebit();
                    if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                        return false;
                    }
                    AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
                    AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
                    if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
                        return false;
                    }
                    Alipay this$alipay = this.getAlipay();
                    Alipay other$alipay = other.getAlipay();
                    if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
                        return false;
                    }
                    Bancontact this$bancontact = this.getBancontact();
                    Bancontact other$bancontact = other.getBancontact();
                    if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                        return false;
                    }
                    Card this$card = this.getCard();
                    Card other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    CustomerBalance this$customerBalance = this.getCustomerBalance();
                    CustomerBalance other$customerBalance = other.getCustomerBalance();
                    if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
                        return false;
                    }
                    Ideal this$ideal = this.getIdeal();
                    Ideal other$ideal = other.getIdeal();
                    if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
                        return false;
                    }
                    Klarna this$klarna = this.getKlarna();
                    Klarna other$klarna = other.getKlarna();
                    if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                        return false;
                    }
                    Link this$link = this.getLink();
                    Link other$link = other.getLink();
                    if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                        return false;
                    }
                    Oxxo this$oxxo = this.getOxxo();
                    Oxxo other$oxxo = other.getOxxo();
                    if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
                        return false;
                    }
                    P24 this$p24 = this.getP24();
                    P24 other$p24 = other.getP24();
                    if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
                        return false;
                    }
                    Paypal this$paypal = this.getPaypal();
                    Paypal other$paypal = other.getPaypal();
                    if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                        return false;
                    }
                    SepaDebit this$sepaDebit = this.getSepaDebit();
                    SepaDebit other$sepaDebit = other.getSepaDebit();
                    if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                        return false;
                    }
                    Sofort this$sofort = this.getSofort();
                    Sofort other$sofort = other.getSofort();
                    if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                        return false;
                    }
                    WechatPay this$wechatPay = this.getWechatPay();
                    WechatPay other$wechatPay = other.getWechatPay();
                    return !(this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof PaymentMethodOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    AcssDebit $acssDebit = this.getAcssDebit();
                    result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
                    AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
                    result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
                    Alipay $alipay = this.getAlipay();
                    result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
                    Bancontact $bancontact = this.getBancontact();
                    result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
                    Card $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    CustomerBalance $customerBalance = this.getCustomerBalance();
                    result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
                    Ideal $ideal = this.getIdeal();
                    result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
                    Klarna $klarna = this.getKlarna();
                    result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
                    Link $link = this.getLink();
                    result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
                    Oxxo $oxxo = this.getOxxo();
                    result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
                    P24 $p24 = this.getP24();
                    result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
                    Paypal $paypal = this.getPaypal();
                    result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
                    SepaDebit $sepaDebit = this.getSepaDebit();
                    result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
                    Sofort $sofort = this.getSofort();
                    result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
                    WechatPay $wechatPay = this.getWechatPay();
                    result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
                    return result;
                }

                public static class AcssDebit
                extends StripeObject {
                    @SerializedName(value="mandate_options")
                    MandateOptions mandateOptions;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;
                    @SerializedName(value="verification_method")
                    String verificationMethod;

                    @Generated
                    public MandateOptions getMandateOptions() {
                        return this.mandateOptions;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public String getVerificationMethod() {
                        return this.verificationMethod;
                    }

                    @Generated
                    public void setMandateOptions(MandateOptions mandateOptions) {
                        this.mandateOptions = mandateOptions;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public void setVerificationMethod(String verificationMethod) {
                        this.verificationMethod = verificationMethod;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof AcssDebit)) {
                            return false;
                        }
                        AcssDebit other = (AcssDebit)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        MandateOptions this$mandateOptions = this.getMandateOptions();
                        MandateOptions other$mandateOptions = other.getMandateOptions();
                        if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                            return false;
                        }
                        String this$verificationMethod = this.getVerificationMethod();
                        String other$verificationMethod = other.getVerificationMethod();
                        return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof AcssDebit;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        MandateOptions $mandateOptions = this.getMandateOptions();
                        result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        String $verificationMethod = this.getVerificationMethod();
                        result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                        return result;
                    }

                    public static class MandateOptions
                    extends StripeObject {
                        @SerializedName(value="custom_mandate_url")
                        String customMandateUrl;
                        @SerializedName(value="interval_description")
                        String intervalDescription;
                        @SerializedName(value="payment_schedule")
                        String paymentSchedule;
                        @SerializedName(value="transaction_type")
                        String transactionType;

                        @Generated
                        public String getCustomMandateUrl() {
                            return this.customMandateUrl;
                        }

                        @Generated
                        public String getIntervalDescription() {
                            return this.intervalDescription;
                        }

                        @Generated
                        public String getPaymentSchedule() {
                            return this.paymentSchedule;
                        }

                        @Generated
                        public String getTransactionType() {
                            return this.transactionType;
                        }

                        @Generated
                        public void setCustomMandateUrl(String customMandateUrl) {
                            this.customMandateUrl = customMandateUrl;
                        }

                        @Generated
                        public void setIntervalDescription(String intervalDescription) {
                            this.intervalDescription = intervalDescription;
                        }

                        @Generated
                        public void setPaymentSchedule(String paymentSchedule) {
                            this.paymentSchedule = paymentSchedule;
                        }

                        @Generated
                        public void setTransactionType(String transactionType) {
                            this.transactionType = transactionType;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof MandateOptions)) {
                                return false;
                            }
                            MandateOptions other = (MandateOptions)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            String this$customMandateUrl = this.getCustomMandateUrl();
                            String other$customMandateUrl = other.getCustomMandateUrl();
                            if (this$customMandateUrl == null ? other$customMandateUrl != null : !this$customMandateUrl.equals(other$customMandateUrl)) {
                                return false;
                            }
                            String this$intervalDescription = this.getIntervalDescription();
                            String other$intervalDescription = other.getIntervalDescription();
                            if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) {
                                return false;
                            }
                            String this$paymentSchedule = this.getPaymentSchedule();
                            String other$paymentSchedule = other.getPaymentSchedule();
                            if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                                return false;
                            }
                            String this$transactionType = this.getTransactionType();
                            String other$transactionType = other.getTransactionType();
                            return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof MandateOptions;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            String $customMandateUrl = this.getCustomMandateUrl();
                            result = result * 59 + ($customMandateUrl == null ? 43 : $customMandateUrl.hashCode());
                            String $intervalDescription = this.getIntervalDescription();
                            result = result * 59 + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
                            String $paymentSchedule = this.getPaymentSchedule();
                            result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                            String $transactionType = this.getTransactionType();
                            result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                            return result;
                        }
                    }
                }

                public static class AfterpayClearpay
                extends StripeObject {
                    @SerializedName(value="capture_method")
                    String captureMethod;
                    @SerializedName(value="reference")
                    String reference;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getCaptureMethod() {
                        return this.captureMethod;
                    }

                    @Generated
                    public String getReference() {
                        return this.reference;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setCaptureMethod(String captureMethod) {
                        this.captureMethod = captureMethod;
                    }

                    @Generated
                    public void setReference(String reference) {
                        this.reference = reference;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof AfterpayClearpay)) {
                            return false;
                        }
                        AfterpayClearpay other = (AfterpayClearpay)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$captureMethod = this.getCaptureMethod();
                        String other$captureMethod = other.getCaptureMethod();
                        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                            return false;
                        }
                        String this$reference = this.getReference();
                        String other$reference = other.getReference();
                        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof AfterpayClearpay;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $captureMethod = this.getCaptureMethod();
                        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                        String $reference = this.getReference();
                        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class Alipay
                extends StripeObject {
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Alipay)) {
                            return false;
                        }
                        Alipay other = (Alipay)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Alipay;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class Bancontact
                extends StripeObject {
                    @SerializedName(value="preferred_language")
                    String preferredLanguage;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getPreferredLanguage() {
                        return this.preferredLanguage;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setPreferredLanguage(String preferredLanguage) {
                        this.preferredLanguage = preferredLanguage;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Bancontact)) {
                            return false;
                        }
                        Bancontact other = (Bancontact)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$preferredLanguage = this.getPreferredLanguage();
                        String other$preferredLanguage = other.getPreferredLanguage();
                        if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Bancontact;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $preferredLanguage = this.getPreferredLanguage();
                        result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class Card
                extends StripeObject {
                    @SerializedName(value="capture_method")
                    String captureMethod;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getCaptureMethod() {
                        return this.captureMethod;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setCaptureMethod(String captureMethod) {
                        this.captureMethod = captureMethod;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Card)) {
                            return false;
                        }
                        Card other = (Card)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$captureMethod = this.getCaptureMethod();
                        String other$captureMethod = other.getCaptureMethod();
                        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Card;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $captureMethod = this.getCaptureMethod();
                        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class CustomerBalance
                extends StripeObject {
                    @SerializedName(value="bank_transfer")
                    BankTransfer bankTransfer;
                    @SerializedName(value="funding_type")
                    String fundingType;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public BankTransfer getBankTransfer() {
                        return this.bankTransfer;
                    }

                    @Generated
                    public String getFundingType() {
                        return this.fundingType;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setBankTransfer(BankTransfer bankTransfer) {
                        this.bankTransfer = bankTransfer;
                    }

                    @Generated
                    public void setFundingType(String fundingType) {
                        this.fundingType = fundingType;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof CustomerBalance)) {
                            return false;
                        }
                        CustomerBalance other = (CustomerBalance)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        BankTransfer this$bankTransfer = this.getBankTransfer();
                        BankTransfer other$bankTransfer = other.getBankTransfer();
                        if (this$bankTransfer == null ? other$bankTransfer != null : !((Object)this$bankTransfer).equals(other$bankTransfer)) {
                            return false;
                        }
                        String this$fundingType = this.getFundingType();
                        String other$fundingType = other.getFundingType();
                        if (this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof CustomerBalance;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        BankTransfer $bankTransfer = this.getBankTransfer();
                        result = result * 59 + ($bankTransfer == null ? 43 : ((Object)$bankTransfer).hashCode());
                        String $fundingType = this.getFundingType();
                        result = result * 59 + ($fundingType == null ? 43 : $fundingType.hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }

                    public static class BankTransfer
                    extends StripeObject {
                        @SerializedName(value="eu_bank_transfer")
                        EuBankTransfer euBankTransfer;
                        @SerializedName(value="requested_address_types")
                        List<String> requestedAddressTypes;
                        @SerializedName(value="type")
                        String type;

                        @Generated
                        public EuBankTransfer getEuBankTransfer() {
                            return this.euBankTransfer;
                        }

                        @Generated
                        public List<String> getRequestedAddressTypes() {
                            return this.requestedAddressTypes;
                        }

                        @Generated
                        public String getType() {
                            return this.type;
                        }

                        @Generated
                        public void setEuBankTransfer(EuBankTransfer euBankTransfer) {
                            this.euBankTransfer = euBankTransfer;
                        }

                        @Generated
                        public void setRequestedAddressTypes(List<String> requestedAddressTypes) {
                            this.requestedAddressTypes = requestedAddressTypes;
                        }

                        @Generated
                        public void setType(String type) {
                            this.type = type;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof BankTransfer)) {
                                return false;
                            }
                            BankTransfer other = (BankTransfer)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            EuBankTransfer this$euBankTransfer = this.getEuBankTransfer();
                            EuBankTransfer other$euBankTransfer = other.getEuBankTransfer();
                            if (this$euBankTransfer == null ? other$euBankTransfer != null : !((Object)this$euBankTransfer).equals(other$euBankTransfer)) {
                                return false;
                            }
                            List<String> this$requestedAddressTypes = this.getRequestedAddressTypes();
                            List<String> other$requestedAddressTypes = other.getRequestedAddressTypes();
                            if (this$requestedAddressTypes == null ? other$requestedAddressTypes != null : !((Object)this$requestedAddressTypes).equals(other$requestedAddressTypes)) {
                                return false;
                            }
                            String this$type = this.getType();
                            String other$type = other.getType();
                            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof BankTransfer;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            EuBankTransfer $euBankTransfer = this.getEuBankTransfer();
                            result = result * 59 + ($euBankTransfer == null ? 43 : ((Object)$euBankTransfer).hashCode());
                            List<String> $requestedAddressTypes = this.getRequestedAddressTypes();
                            result = result * 59 + ($requestedAddressTypes == null ? 43 : ((Object)$requestedAddressTypes).hashCode());
                            String $type = this.getType();
                            result = result * 59 + ($type == null ? 43 : $type.hashCode());
                            return result;
                        }

                        public static class EuBankTransfer
                        extends StripeObject {
                            @SerializedName(value="country")
                            String country;

                            @Generated
                            public String getCountry() {
                                return this.country;
                            }

                            @Generated
                            public void setCountry(String country) {
                                this.country = country;
                            }

                            @Generated
                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof EuBankTransfer)) {
                                    return false;
                                }
                                EuBankTransfer other = (EuBankTransfer)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                String this$country = this.getCountry();
                                String other$country = other.getCountry();
                                return !(this$country == null ? other$country != null : !this$country.equals(other$country));
                            }

                            @Generated
                            protected boolean canEqual(Object other) {
                                return other instanceof EuBankTransfer;
                            }

                            @Generated
                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                String $country = this.getCountry();
                                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                                return result;
                            }
                        }
                    }
                }

                public static class Ideal
                extends StripeObject {
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Ideal)) {
                            return false;
                        }
                        Ideal other = (Ideal)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Ideal;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class Klarna
                extends StripeObject {
                    @SerializedName(value="capture_method")
                    String captureMethod;
                    @SerializedName(value="preferred_locale")
                    String preferredLocale;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getCaptureMethod() {
                        return this.captureMethod;
                    }

                    @Generated
                    public String getPreferredLocale() {
                        return this.preferredLocale;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setCaptureMethod(String captureMethod) {
                        this.captureMethod = captureMethod;
                    }

                    @Generated
                    public void setPreferredLocale(String preferredLocale) {
                        this.preferredLocale = preferredLocale;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Klarna)) {
                            return false;
                        }
                        Klarna other = (Klarna)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$captureMethod = this.getCaptureMethod();
                        String other$captureMethod = other.getCaptureMethod();
                        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                            return false;
                        }
                        String this$preferredLocale = this.getPreferredLocale();
                        String other$preferredLocale = other.getPreferredLocale();
                        if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Klarna;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $captureMethod = this.getCaptureMethod();
                        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                        String $preferredLocale = this.getPreferredLocale();
                        result = result * 59 + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class Link
                extends StripeObject {
                    @SerializedName(value="capture_method")
                    String captureMethod;
                    @SerializedName(value="persistent_token")
                    String persistentToken;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getCaptureMethod() {
                        return this.captureMethod;
                    }

                    @Generated
                    public String getPersistentToken() {
                        return this.persistentToken;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setCaptureMethod(String captureMethod) {
                        this.captureMethod = captureMethod;
                    }

                    @Generated
                    public void setPersistentToken(String persistentToken) {
                        this.persistentToken = persistentToken;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Link)) {
                            return false;
                        }
                        Link other = (Link)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$captureMethod = this.getCaptureMethod();
                        String other$captureMethod = other.getCaptureMethod();
                        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                            return false;
                        }
                        String this$persistentToken = this.getPersistentToken();
                        String other$persistentToken = other.getPersistentToken();
                        if (this$persistentToken == null ? other$persistentToken != null : !this$persistentToken.equals(other$persistentToken)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Link;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $captureMethod = this.getCaptureMethod();
                        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                        String $persistentToken = this.getPersistentToken();
                        result = result * 59 + ($persistentToken == null ? 43 : $persistentToken.hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class Oxxo
                extends StripeObject {
                    @SerializedName(value="expires_after_days")
                    Long expiresAfterDays;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public Long getExpiresAfterDays() {
                        return this.expiresAfterDays;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setExpiresAfterDays(Long expiresAfterDays) {
                        this.expiresAfterDays = expiresAfterDays;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Oxxo)) {
                            return false;
                        }
                        Oxxo other = (Oxxo)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$expiresAfterDays = this.getExpiresAfterDays();
                        Long other$expiresAfterDays = other.getExpiresAfterDays();
                        if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Oxxo;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $expiresAfterDays = this.getExpiresAfterDays();
                        result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class P24
                extends StripeObject {
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof P24)) {
                            return false;
                        }
                        P24 other = (P24)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof P24;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class Paypal
                extends StripeObject {
                    @SerializedName(value="capture_method")
                    String captureMethod;
                    @SerializedName(value="preferred_locale")
                    String preferredLocale;
                    @SerializedName(value="reference")
                    String reference;
                    @SerializedName(value="reference_id")
                    String referenceId;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;
                    @SerializedName(value="subsellers")
                    List<String> subsellers;

                    @Generated
                    public String getCaptureMethod() {
                        return this.captureMethod;
                    }

                    @Generated
                    public String getPreferredLocale() {
                        return this.preferredLocale;
                    }

                    @Generated
                    public String getReference() {
                        return this.reference;
                    }

                    @Generated
                    public String getReferenceId() {
                        return this.referenceId;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public List<String> getSubsellers() {
                        return this.subsellers;
                    }

                    @Generated
                    public void setCaptureMethod(String captureMethod) {
                        this.captureMethod = captureMethod;
                    }

                    @Generated
                    public void setPreferredLocale(String preferredLocale) {
                        this.preferredLocale = preferredLocale;
                    }

                    @Generated
                    public void setReference(String reference) {
                        this.reference = reference;
                    }

                    @Generated
                    public void setReferenceId(String referenceId) {
                        this.referenceId = referenceId;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public void setSubsellers(List<String> subsellers) {
                        this.subsellers = subsellers;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Paypal)) {
                            return false;
                        }
                        Paypal other = (Paypal)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$captureMethod = this.getCaptureMethod();
                        String other$captureMethod = other.getCaptureMethod();
                        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                            return false;
                        }
                        String this$preferredLocale = this.getPreferredLocale();
                        String other$preferredLocale = other.getPreferredLocale();
                        if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) {
                            return false;
                        }
                        String this$reference = this.getReference();
                        String other$reference = other.getReference();
                        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                            return false;
                        }
                        String this$referenceId = this.getReferenceId();
                        String other$referenceId = other.getReferenceId();
                        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                            return false;
                        }
                        List<String> this$subsellers = this.getSubsellers();
                        List<String> other$subsellers = other.getSubsellers();
                        return !(this$subsellers == null ? other$subsellers != null : !((Object)this$subsellers).equals(other$subsellers));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Paypal;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $captureMethod = this.getCaptureMethod();
                        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                        String $preferredLocale = this.getPreferredLocale();
                        result = result * 59 + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
                        String $reference = this.getReference();
                        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                        String $referenceId = this.getReferenceId();
                        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        List<String> $subsellers = this.getSubsellers();
                        result = result * 59 + ($subsellers == null ? 43 : ((Object)$subsellers).hashCode());
                        return result;
                    }
                }

                public static class SepaDebit
                extends StripeObject {
                    @SerializedName(value="mandate_options")
                    MandateOptions mandateOptions;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public MandateOptions getMandateOptions() {
                        return this.mandateOptions;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setMandateOptions(MandateOptions mandateOptions) {
                        this.mandateOptions = mandateOptions;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof SepaDebit)) {
                            return false;
                        }
                        SepaDebit other = (SepaDebit)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        MandateOptions this$mandateOptions = this.getMandateOptions();
                        MandateOptions other$mandateOptions = other.getMandateOptions();
                        if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof SepaDebit;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        MandateOptions $mandateOptions = this.getMandateOptions();
                        result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }

                    public static class MandateOptions
                    extends StripeObject {
                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof MandateOptions)) {
                                return false;
                            }
                            MandateOptions other = (MandateOptions)o;
                            return other.canEqual(this);
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof MandateOptions;
                        }

                        @Generated
                        public int hashCode() {
                            boolean result = true;
                            return 1;
                        }
                    }
                }

                public static class Sofort
                extends StripeObject {
                    @SerializedName(value="preferred_language")
                    String preferredLanguage;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getPreferredLanguage() {
                        return this.preferredLanguage;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setPreferredLanguage(String preferredLanguage) {
                        this.preferredLanguage = preferredLanguage;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Sofort)) {
                            return false;
                        }
                        Sofort other = (Sofort)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$preferredLanguage = this.getPreferredLanguage();
                        String other$preferredLanguage = other.getPreferredLanguage();
                        if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Sofort;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $preferredLanguage = this.getPreferredLanguage();
                        result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }

                public static class WechatPay
                extends StripeObject {
                    @SerializedName(value="app_id")
                    String appId;
                    @SerializedName(value="client")
                    String client;
                    @SerializedName(value="setup_future_usage")
                    String setupFutureUsage;

                    @Generated
                    public String getAppId() {
                        return this.appId;
                    }

                    @Generated
                    public String getClient() {
                        return this.client;
                    }

                    @Generated
                    public String getSetupFutureUsage() {
                        return this.setupFutureUsage;
                    }

                    @Generated
                    public void setAppId(String appId) {
                        this.appId = appId;
                    }

                    @Generated
                    public void setClient(String client) {
                        this.client = client;
                    }

                    @Generated
                    public void setSetupFutureUsage(String setupFutureUsage) {
                        this.setupFutureUsage = setupFutureUsage;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof WechatPay)) {
                            return false;
                        }
                        WechatPay other = (WechatPay)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$appId = this.getAppId();
                        String other$appId = other.getAppId();
                        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                            return false;
                        }
                        String this$client = this.getClient();
                        String other$client = other.getClient();
                        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
                            return false;
                        }
                        String this$setupFutureUsage = this.getSetupFutureUsage();
                        String other$setupFutureUsage = other.getSetupFutureUsage();
                        return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof WechatPay;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $appId = this.getAppId();
                        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
                        String $client = this.getClient();
                        result = result * 59 + ($client == null ? 43 : $client.hashCode());
                        String $setupFutureUsage = this.getSetupFutureUsage();
                        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                        return result;
                    }
                }
            }

            public static class TransferData
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="destination")
                ExpandableField<Account> destination;

                public String getDestination() {
                    return this.destination != null ? this.destination.getId() : null;
                }

                public void setDestination(String id) {
                    this.destination = ApiResource.setExpandableFieldId(id, this.destination);
                }

                public Account getDestinationObject() {
                    return this.destination != null ? this.destination.getExpanded() : null;
                }

                public void setDestinationObject(Account expandableObject) {
                    this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TransferData)) {
                        return false;
                    }
                    TransferData other = (TransferData)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    String this$destination = this.getDestination();
                    String other$destination = other.getDestination();
                    return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TransferData;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    String $destination = this.getDestination();
                    result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
                    return result;
                }
            }
        }
    }

    public static class ShippingCost
    extends StripeObject {
        @SerializedName(value="amount_subtotal")
        Long amountSubtotal;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="amount_total")
        Long amountTotal;
        @SerializedName(value="shipping_rate")
        ExpandableField<ShippingRate> shippingRate;
        @SerializedName(value="taxes")
        List<Tax> taxes;

        public String getShippingRate() {
            return this.shippingRate != null ? this.shippingRate.getId() : null;
        }

        public void setShippingRate(String id) {
            this.shippingRate = ApiResource.setExpandableFieldId(id, this.shippingRate);
        }

        public ShippingRate getShippingRateObject() {
            return this.shippingRate != null ? this.shippingRate.getExpanded() : null;
        }

        public void setShippingRateObject(ShippingRate expandableObject) {
            this.shippingRate = new ExpandableField<ShippingRate>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmountSubtotal() {
            return this.amountSubtotal;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public Long getAmountTotal() {
            return this.amountTotal;
        }

        @Generated
        public List<Tax> getTaxes() {
            return this.taxes;
        }

        @Generated
        public void setAmountSubtotal(Long amountSubtotal) {
            this.amountSubtotal = amountSubtotal;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setAmountTotal(Long amountTotal) {
            this.amountTotal = amountTotal;
        }

        @Generated
        public void setTaxes(List<Tax> taxes) {
            this.taxes = taxes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingCost)) {
                return false;
            }
            ShippingCost other = (ShippingCost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountSubtotal = this.getAmountSubtotal();
            Long other$amountSubtotal = other.getAmountSubtotal();
            if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            Long this$amountTotal = this.getAmountTotal();
            Long other$amountTotal = other.getAmountTotal();
            if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
                return false;
            }
            String this$shippingRate = this.getShippingRate();
            String other$shippingRate = other.getShippingRate();
            if (this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate)) {
                return false;
            }
            List<Tax> this$taxes = this.getTaxes();
            List<Tax> other$taxes = other.getTaxes();
            return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingCost;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountSubtotal = this.getAmountSubtotal();
            result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            Long $amountTotal = this.getAmountTotal();
            result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
            String $shippingRate = this.getShippingRate();
            result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
            List<Tax> $taxes = this.getTaxes();
            result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
            return result;
        }

        public static class Tax
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="rate")
            TaxRate rate;
            @SerializedName(value="taxability_reason")
            String taxabilityReason;
            @SerializedName(value="taxable_amount")
            Long taxableAmount;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public TaxRate getRate() {
                return this.rate;
            }

            @Generated
            public String getTaxabilityReason() {
                return this.taxabilityReason;
            }

            @Generated
            public Long getTaxableAmount() {
                return this.taxableAmount;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setRate(TaxRate rate) {
                this.rate = rate;
            }

            @Generated
            public void setTaxabilityReason(String taxabilityReason) {
                this.taxabilityReason = taxabilityReason;
            }

            @Generated
            public void setTaxableAmount(Long taxableAmount) {
                this.taxableAmount = taxableAmount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tax)) {
                    return false;
                }
                Tax other = (Tax)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                Long this$taxableAmount = this.getTaxableAmount();
                Long other$taxableAmount = other.getTaxableAmount();
                if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                    return false;
                }
                TaxRate this$rate = this.getRate();
                TaxRate other$rate = other.getRate();
                if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
                    return false;
                }
                String this$taxabilityReason = this.getTaxabilityReason();
                String other$taxabilityReason = other.getTaxabilityReason();
                return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tax;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                Long $taxableAmount = this.getTaxableAmount();
                result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                TaxRate $rate = this.getRate();
                result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                String $taxabilityReason = this.getTaxabilityReason();
                result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                return result;
            }
        }
    }

    public static class ShippingDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingDetails)) {
                return false;
            }
            ShippingDetails other = (ShippingDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }
    }

    public static class TaxDetails
    extends StripeObject {
        @SerializedName(value="tax_exempt")
        String taxExempt;
        @SerializedName(value="tax_ids")
        List<TaxId> taxIds;

        @Generated
        public String getTaxExempt() {
            return this.taxExempt;
        }

        @Generated
        public List<TaxId> getTaxIds() {
            return this.taxIds;
        }

        @Generated
        public void setTaxExempt(String taxExempt) {
            this.taxExempt = taxExempt;
        }

        @Generated
        public void setTaxIds(List<TaxId> taxIds) {
            this.taxIds = taxIds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxDetails)) {
                return false;
            }
            TaxDetails other = (TaxDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taxExempt = this.getTaxExempt();
            String other$taxExempt = other.getTaxExempt();
            if (this$taxExempt == null ? other$taxExempt != null : !this$taxExempt.equals(other$taxExempt)) {
                return false;
            }
            List<TaxId> this$taxIds = this.getTaxIds();
            List<TaxId> other$taxIds = other.getTaxIds();
            return !(this$taxIds == null ? other$taxIds != null : !((Object)this$taxIds).equals(other$taxIds));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taxExempt = this.getTaxExempt();
            result = result * 59 + ($taxExempt == null ? 43 : $taxExempt.hashCode());
            List<TaxId> $taxIds = this.getTaxIds();
            result = result * 59 + ($taxIds == null ? 43 : ((Object)$taxIds).hashCode());
            return result;
        }

        public static class TaxId
        extends StripeObject {
            @SerializedName(value="type")
            String type;
            @SerializedName(value="value")
            String value;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxId)) {
                    return false;
                }
                TaxId other = (TaxId)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxId;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class TotalDetails
    extends StripeObject {
        @SerializedName(value="amount_credit")
        Long amountCredit;
        @SerializedName(value="amount_discount")
        Long amountDiscount;
        @SerializedName(value="amount_shipping")
        Long amountShipping;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="breakdown")
        Breakdown breakdown;

        @Generated
        public Long getAmountCredit() {
            return this.amountCredit;
        }

        @Generated
        public Long getAmountDiscount() {
            return this.amountDiscount;
        }

        @Generated
        public Long getAmountShipping() {
            return this.amountShipping;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public Breakdown getBreakdown() {
            return this.breakdown;
        }

        @Generated
        public void setAmountCredit(Long amountCredit) {
            this.amountCredit = amountCredit;
        }

        @Generated
        public void setAmountDiscount(Long amountDiscount) {
            this.amountDiscount = amountDiscount;
        }

        @Generated
        public void setAmountShipping(Long amountShipping) {
            this.amountShipping = amountShipping;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setBreakdown(Breakdown breakdown) {
            this.breakdown = breakdown;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TotalDetails)) {
                return false;
            }
            TotalDetails other = (TotalDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountCredit = this.getAmountCredit();
            Long other$amountCredit = other.getAmountCredit();
            if (this$amountCredit == null ? other$amountCredit != null : !((Object)this$amountCredit).equals(other$amountCredit)) {
                return false;
            }
            Long this$amountDiscount = this.getAmountDiscount();
            Long other$amountDiscount = other.getAmountDiscount();
            if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                return false;
            }
            Long this$amountShipping = this.getAmountShipping();
            Long other$amountShipping = other.getAmountShipping();
            if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            Breakdown this$breakdown = this.getBreakdown();
            Breakdown other$breakdown = other.getBreakdown();
            return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TotalDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountCredit = this.getAmountCredit();
            result = result * 59 + ($amountCredit == null ? 43 : ((Object)$amountCredit).hashCode());
            Long $amountDiscount = this.getAmountDiscount();
            result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
            Long $amountShipping = this.getAmountShipping();
            result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            Breakdown $breakdown = this.getBreakdown();
            result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
            return result;
        }

        public static class Breakdown
        extends StripeObject {
            @SerializedName(value="discounts")
            List<Discount> discounts;
            @SerializedName(value="taxes")
            List<Tax> taxes;

            @Generated
            public List<Discount> getDiscounts() {
                return this.discounts;
            }

            @Generated
            public List<Tax> getTaxes() {
                return this.taxes;
            }

            @Generated
            public void setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
            }

            @Generated
            public void setTaxes(List<Tax> taxes) {
                this.taxes = taxes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Breakdown)) {
                    return false;
                }
                Breakdown other = (Breakdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Discount> this$discounts = this.getDiscounts();
                List<Discount> other$discounts = other.getDiscounts();
                if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                    return false;
                }
                List<Tax> this$taxes = this.getTaxes();
                List<Tax> other$taxes = other.getTaxes();
                return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Breakdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Discount> $discounts = this.getDiscounts();
                result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                List<Tax> $taxes = this.getTaxes();
                result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                return result;
            }

            public static class Tax
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="rate")
                TaxRate rate;
                @SerializedName(value="taxability_reason")
                String taxabilityReason;
                @SerializedName(value="taxable_amount")
                Long taxableAmount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public TaxRate getRate() {
                    return this.rate;
                }

                @Generated
                public String getTaxabilityReason() {
                    return this.taxabilityReason;
                }

                @Generated
                public Long getTaxableAmount() {
                    return this.taxableAmount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setRate(TaxRate rate) {
                    this.rate = rate;
                }

                @Generated
                public void setTaxabilityReason(String taxabilityReason) {
                    this.taxabilityReason = taxabilityReason;
                }

                @Generated
                public void setTaxableAmount(Long taxableAmount) {
                    this.taxableAmount = taxableAmount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Tax)) {
                        return false;
                    }
                    Tax other = (Tax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Long this$taxableAmount = this.getTaxableAmount();
                    Long other$taxableAmount = other.getTaxableAmount();
                    if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                        return false;
                    }
                    TaxRate this$rate = this.getRate();
                    TaxRate other$rate = other.getRate();
                    if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
                        return false;
                    }
                    String this$taxabilityReason = this.getTaxabilityReason();
                    String other$taxabilityReason = other.getTaxabilityReason();
                    return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Tax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Long $taxableAmount = this.getTaxableAmount();
                    result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                    TaxRate $rate = this.getRate();
                    result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                    String $taxabilityReason = this.getTaxabilityReason();
                    result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                    return result;
                }
            }

            public static class Discount
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="discount")
                com.stripe.model.Discount discount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public com.stripe.model.Discount getDiscount() {
                    return this.discount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setDiscount(com.stripe.model.Discount discount) {
                    this.discount = discount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Discount)) {
                        return false;
                    }
                    Discount other = (Discount)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    com.stripe.model.Discount this$discount = this.getDiscount();
                    com.stripe.model.Discount other$discount = other.getDiscount();
                    return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Discount;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    com.stripe.model.Discount $discount = this.getDiscount();
                    result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
                    return result;
                }
            }
        }
    }

    public static class Credit
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="gift_card")
        GiftCard giftCard;
        @SerializedName(value="ineligible_line_items")
        List<String> ineligibleLineItems;
        @SerializedName(value="type")
        String type;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public GiftCard getGiftCard() {
            return this.giftCard;
        }

        @Generated
        public List<String> getIneligibleLineItems() {
            return this.ineligibleLineItems;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setGiftCard(GiftCard giftCard) {
            this.giftCard = giftCard;
        }

        @Generated
        public void setIneligibleLineItems(List<String> ineligibleLineItems) {
            this.ineligibleLineItems = ineligibleLineItems;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credit)) {
                return false;
            }
            Credit other = (Credit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            GiftCard this$giftCard = this.getGiftCard();
            GiftCard other$giftCard = other.getGiftCard();
            if (this$giftCard == null ? other$giftCard != null : !((Object)this$giftCard).equals(other$giftCard)) {
                return false;
            }
            List<String> this$ineligibleLineItems = this.getIneligibleLineItems();
            List<String> other$ineligibleLineItems = other.getIneligibleLineItems();
            if (this$ineligibleLineItems == null ? other$ineligibleLineItems != null : !((Object)this$ineligibleLineItems).equals(other$ineligibleLineItems)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Credit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            GiftCard $giftCard = this.getGiftCard();
            result = result * 59 + ($giftCard == null ? 43 : ((Object)$giftCard).hashCode());
            List<String> $ineligibleLineItems = this.getIneligibleLineItems();
            result = result * 59 + ($ineligibleLineItems == null ? 43 : ((Object)$ineligibleLineItems).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class GiftCard
        extends StripeObject {
            @SerializedName(value="card")
            String card;

            @Generated
            public String getCard() {
                return this.card;
            }

            @Generated
            public void setCard(String card) {
                this.card = card;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GiftCard)) {
                    return false;
                }
                GiftCard other = (GiftCard)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$card = this.getCard();
                String other$card = other.getCard();
                return !(this$card == null ? other$card != null : !this$card.equals(other$card));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GiftCard;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $card = this.getCard();
                result = result * 59 + ($card == null ? 43 : $card.hashCode());
                return result;
            }
        }
    }
}

