/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.entitlements;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.entitlements.FeatureCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.entitlements.FeatureCreateParams;
import com.stripe.param.entitlements.FeatureListParams;
import com.stripe.param.entitlements.FeatureRetrieveParams;
import com.stripe.param.entitlements.FeatureUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Feature
extends ApiResource
implements HasId,
MetadataStore<Feature> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="lookup_key")
    String lookupKey;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;

    public static Feature create(Map<String, Object> params) throws StripeException {
        return Feature.create(params, (RequestOptions)null);
    }

    public static Feature create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Feature)Feature.getGlobalResponseGetter().request(request, (Type)((Object)Feature.class));
    }

    public static Feature create(FeatureCreateParams params) throws StripeException {
        return Feature.create(params, (RequestOptions)null);
    }

    public static Feature create(FeatureCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Feature)Feature.getGlobalResponseGetter().request(request, (Type)((Object)Feature.class));
    }

    public static FeatureCollection list(Map<String, Object> params) throws StripeException {
        return Feature.list(params, (RequestOptions)null);
    }

    public static FeatureCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (FeatureCollection)Feature.getGlobalResponseGetter().request(request, (Type)((Object)FeatureCollection.class));
    }

    public static FeatureCollection list(FeatureListParams params) throws StripeException {
        return Feature.list(params, (RequestOptions)null);
    }

    public static FeatureCollection list(FeatureListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (FeatureCollection)Feature.getGlobalResponseGetter().request(request, (Type)((Object)FeatureCollection.class));
    }

    public static Feature retrieve(String id) throws StripeException {
        return Feature.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Feature retrieve(String id, RequestOptions options) throws StripeException {
        return Feature.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Feature retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/entitlements/features/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Feature)Feature.getGlobalResponseGetter().request(request, (Type)((Object)Feature.class));
    }

    public static Feature retrieve(String id, FeatureRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/entitlements/features/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Feature)Feature.getGlobalResponseGetter().request(request, (Type)((Object)Feature.class));
    }

    public Feature update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Feature update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/entitlements/features/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Feature)this.getResponseGetter().request(request, (Type)((Object)Feature.class));
    }

    public Feature update(FeatureUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Feature update(FeatureUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/entitlements/features/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Feature)this.getResponseGetter().request(request, (Type)((Object)Feature.class));
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getLookupKey() {
        return this.lookupKey;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lookupKey = this.getLookupKey();
        String other$lookupKey = other.getLookupKey();
        if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Feature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lookupKey = this.getLookupKey();
        result = result * 59 + ($lookupKey == null ? 43 : $lookupKey.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

