/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.LineItem;
import com.stripe.model.QuotePhase;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.QuotePhaseListLineItemsParams;
import com.stripe.param.QuotePhaseRetrieveParams;
import java.lang.reflect.Type;

public final class QuotePhaseService
extends ApiService {
    public QuotePhaseService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public QuotePhase retrieve(String quotePhase, QuotePhaseRetrieveParams params) throws StripeException {
        return this.retrieve(quotePhase, params, null);
    }

    public QuotePhase retrieve(String quotePhase, RequestOptions options) throws StripeException {
        return this.retrieve(quotePhase, null, options);
    }

    public QuotePhase retrieve(String quotePhase) throws StripeException {
        return this.retrieve(quotePhase, null, null);
    }

    public QuotePhase retrieve(String quotePhase, QuotePhaseRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quote_phases/%s", ApiResource.urlEncodeId(quotePhase));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (QuotePhase)this.request(request, (Type)((Object)QuotePhase.class));
    }

    public StripeCollection<LineItem> listLineItems(String quotePhase, QuotePhaseListLineItemsParams params) throws StripeException {
        return this.listLineItems(quotePhase, params, null);
    }

    public StripeCollection<LineItem> listLineItems(String quotePhase, RequestOptions options) throws StripeException {
        return this.listLineItems(quotePhase, null, options);
    }

    public StripeCollection<LineItem> listLineItems(String quotePhase) throws StripeException {
        return this.listLineItems(quotePhase, null, null);
    }

    public StripeCollection<LineItem> listLineItems(String quotePhase, QuotePhaseListLineItemsParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quote_phases/%s/line_items", ApiResource.urlEncodeId(quotePhase));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<LineItem>>(){}.getType());
    }
}

