/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntent;
import com.stripe.model.RefundCollection;
import com.stripe.model.StripeObject;
import com.stripe.model.TransferReversal;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.RefundCancelParams;
import com.stripe.param.RefundCreateParams;
import com.stripe.param.RefundExpireParams;
import com.stripe.param.RefundListParams;
import com.stripe.param.RefundRetrieveParams;
import com.stripe.param.RefundUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Refund
extends ApiResource
implements MetadataStore<Refund>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="charge")
    ExpandableField<Charge> charge;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="destination_details")
    DestinationDetails destinationDetails;
    @SerializedName(value="failure_balance_transaction")
    ExpandableField<BalanceTransaction> failureBalanceTransaction;
    @SerializedName(value="failure_reason")
    String failureReason;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="instructions_email")
    String instructionsEmail;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_action")
    NextAction nextAction;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    @SerializedName(value="reason")
    String reason;
    @SerializedName(value="receipt_number")
    String receiptNumber;
    @SerializedName(value="source_transfer_reversal")
    ExpandableField<TransferReversal> sourceTransferReversal;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transfer_reversal")
    ExpandableField<TransferReversal> transferReversal;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String id) {
        this.charge = ApiResource.setExpandableFieldId(id, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge expandableObject) {
        this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getFailureBalanceTransaction() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getId() : null;
    }

    public void setFailureBalanceTransaction(String id) {
        this.failureBalanceTransaction = ApiResource.setExpandableFieldId(id, this.failureBalanceTransaction);
    }

    public BalanceTransaction getFailureBalanceTransactionObject() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getExpanded() : null;
    }

    public void setFailureBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.failureBalanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public String getSourceTransferReversal() {
        return this.sourceTransferReversal != null ? this.sourceTransferReversal.getId() : null;
    }

    public void setSourceTransferReversal(String id) {
        this.sourceTransferReversal = ApiResource.setExpandableFieldId(id, this.sourceTransferReversal);
    }

    public TransferReversal getSourceTransferReversalObject() {
        return this.sourceTransferReversal != null ? this.sourceTransferReversal.getExpanded() : null;
    }

    public void setSourceTransferReversalObject(TransferReversal expandableObject) {
        this.sourceTransferReversal = new ExpandableField<TransferReversal>(expandableObject.getId(), expandableObject);
    }

    public String getTransferReversal() {
        return this.transferReversal != null ? this.transferReversal.getId() : null;
    }

    public void setTransferReversal(String id) {
        this.transferReversal = ApiResource.setExpandableFieldId(id, this.transferReversal);
    }

    public TransferReversal getTransferReversalObject() {
        return this.transferReversal != null ? this.transferReversal.getExpanded() : null;
    }

    public void setTransferReversalObject(TransferReversal expandableObject) {
        this.transferReversal = new ExpandableField<TransferReversal>(expandableObject.getId(), expandableObject);
    }

    public Refund cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Refund cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public Refund cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Refund cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Refund)this.getResponseGetter().request(request, (Type)((Object)Refund.class));
    }

    public Refund cancel(RefundCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Refund cancel(RefundCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Refund)this.getResponseGetter().request(request, (Type)((Object)Refund.class));
    }

    public static Refund create(Map<String, Object> params) throws StripeException {
        return Refund.create(params, (RequestOptions)null);
    }

    public static Refund create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Refund)Refund.getGlobalResponseGetter().request(request, (Type)((Object)Refund.class));
    }

    public static Refund create(RefundCreateParams params) throws StripeException {
        return Refund.create(params, (RequestOptions)null);
    }

    public static Refund create(RefundCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Refund)Refund.getGlobalResponseGetter().request(request, (Type)((Object)Refund.class));
    }

    public static RefundCollection list(Map<String, Object> params) throws StripeException {
        return Refund.list(params, (RequestOptions)null);
    }

    public static RefundCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (RefundCollection)Refund.getGlobalResponseGetter().request(request, (Type)((Object)RefundCollection.class));
    }

    public static RefundCollection list(RefundListParams params) throws StripeException {
        return Refund.list(params, (RequestOptions)null);
    }

    public static RefundCollection list(RefundListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (RefundCollection)Refund.getGlobalResponseGetter().request(request, (Type)((Object)RefundCollection.class));
    }

    public static Refund retrieve(String refund) throws StripeException {
        return Refund.retrieve(refund, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Refund retrieve(String refund, RequestOptions options) throws StripeException {
        return Refund.retrieve(refund, (Map<String, Object>)null, options);
    }

    public static Refund retrieve(String refund, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(refund));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Refund)Refund.getGlobalResponseGetter().request(request, (Type)((Object)Refund.class));
    }

    public static Refund retrieve(String refund, RefundRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(refund));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Refund)Refund.getGlobalResponseGetter().request(request, (Type)((Object)Refund.class));
    }

    public Refund update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Refund update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Refund)this.getResponseGetter().request(request, (Type)((Object)Refund.class));
    }

    public Refund update(RefundUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Refund update(RefundUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Refund)this.getResponseGetter().request(request, (Type)((Object)Refund.class));
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.balanceTransaction, responseGetter);
        this.trySetResponseGetter(this.charge, responseGetter);
        this.trySetResponseGetter(this.destinationDetails, responseGetter);
        this.trySetResponseGetter(this.failureBalanceTransaction, responseGetter);
        this.trySetResponseGetter(this.nextAction, responseGetter);
        this.trySetResponseGetter(this.paymentIntent, responseGetter);
        this.trySetResponseGetter(this.sourceTransferReversal, responseGetter);
        this.trySetResponseGetter(this.transferReversal, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public DestinationDetails getDestinationDetails() {
        return this.destinationDetails;
    }

    @Generated
    public String getFailureReason() {
        return this.failureReason;
    }

    @Generated
    public String getInstructionsEmail() {
        return this.instructionsEmail;
    }

    @Generated
    public NextAction getNextAction() {
        return this.nextAction;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDestinationDetails(DestinationDetails destinationDetails) {
        this.destinationDetails = destinationDetails;
    }

    @Generated
    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInstructionsEmail(String instructionsEmail) {
        this.instructionsEmail = instructionsEmail;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextAction(NextAction nextAction) {
        this.nextAction = nextAction;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Refund)) {
            return false;
        }
        Refund other = (Refund)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        DestinationDetails this$destinationDetails = this.getDestinationDetails();
        DestinationDetails other$destinationDetails = other.getDestinationDetails();
        if (this$destinationDetails == null ? other$destinationDetails != null : !((Object)this$destinationDetails).equals(other$destinationDetails)) {
            return false;
        }
        String this$failureBalanceTransaction = this.getFailureBalanceTransaction();
        String other$failureBalanceTransaction = other.getFailureBalanceTransaction();
        if (this$failureBalanceTransaction == null ? other$failureBalanceTransaction != null : !this$failureBalanceTransaction.equals(other$failureBalanceTransaction)) {
            return false;
        }
        String this$failureReason = this.getFailureReason();
        String other$failureReason = other.getFailureReason();
        if (this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$instructionsEmail = this.getInstructionsEmail();
        String other$instructionsEmail = other.getInstructionsEmail();
        if (this$instructionsEmail == null ? other$instructionsEmail != null : !this$instructionsEmail.equals(other$instructionsEmail)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        NextAction this$nextAction = this.getNextAction();
        NextAction other$nextAction = other.getNextAction();
        if (this$nextAction == null ? other$nextAction != null : !((Object)this$nextAction).equals(other$nextAction)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        String this$sourceTransferReversal = this.getSourceTransferReversal();
        String other$sourceTransferReversal = other.getSourceTransferReversal();
        if (this$sourceTransferReversal == null ? other$sourceTransferReversal != null : !this$sourceTransferReversal.equals(other$sourceTransferReversal)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transferReversal = this.getTransferReversal();
        String other$transferReversal = other.getTransferReversal();
        return !(this$transferReversal == null ? other$transferReversal != null : !this$transferReversal.equals(other$transferReversal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Refund;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        DestinationDetails $destinationDetails = this.getDestinationDetails();
        result = result * 59 + ($destinationDetails == null ? 43 : ((Object)$destinationDetails).hashCode());
        String $failureBalanceTransaction = this.getFailureBalanceTransaction();
        result = result * 59 + ($failureBalanceTransaction == null ? 43 : $failureBalanceTransaction.hashCode());
        String $failureReason = this.getFailureReason();
        result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $instructionsEmail = this.getInstructionsEmail();
        result = result * 59 + ($instructionsEmail == null ? 43 : $instructionsEmail.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        NextAction $nextAction = this.getNextAction();
        result = result * 59 + ($nextAction == null ? 43 : ((Object)$nextAction).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        String $sourceTransferReversal = this.getSourceTransferReversal();
        result = result * 59 + ($sourceTransferReversal == null ? 43 : $sourceTransferReversal.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transferReversal = this.getTransferReversal();
        result = result * 59 + ($transferReversal == null ? 43 : $transferReversal.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TestHelpers {
        private final Refund resource;

        private TestHelpers(Refund resource) {
            this.resource = resource;
        }

        public Refund expire() throws StripeException {
            return this.expire((Map<String, Object>)null, (RequestOptions)null);
        }

        public Refund expire(RequestOptions options) throws StripeException {
            return this.expire((Map<String, Object>)null, options);
        }

        public Refund expire(Map<String, Object> params) throws StripeException {
            return this.expire(params, (RequestOptions)null);
        }

        public Refund expire(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/refunds/%s/expire", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
            return (Refund)this.resource.getResponseGetter().request(request, (Type)((Object)Refund.class));
        }

        public Refund expire(RefundExpireParams params) throws StripeException {
            return this.expire(params, (RequestOptions)null);
        }

        public Refund expire(RefundExpireParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/refunds/%s/expire", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
            return (Refund)this.resource.getResponseGetter().request(request, (Type)((Object)Refund.class));
        }
    }

    public static class DestinationDetails
    extends StripeObject {
        @SerializedName(value="affirm")
        Affirm affirm;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="amazon_pay")
        AmazonPay amazonPay;
        @SerializedName(value="au_bank_transfer")
        AuBankTransfer auBankTransfer;
        @SerializedName(value="blik")
        Blik blik;
        @SerializedName(value="br_bank_transfer")
        BrBankTransfer brBankTransfer;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="cashapp")
        Cashapp cashapp;
        @SerializedName(value="customer_cash_balance")
        CustomerCashBalance customerCashBalance;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="eu_bank_transfer")
        EuBankTransfer euBankTransfer;
        @SerializedName(value="gb_bank_transfer")
        GbBankTransfer gbBankTransfer;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="jp_bank_transfer")
        JpBankTransfer jpBankTransfer;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="multibanco")
        Multibanco multibanco;
        @SerializedName(value="mx_bank_transfer")
        MxBankTransfer mxBankTransfer;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="paynow")
        Paynow paynow;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="pix")
        Pix pix;
        @SerializedName(value="revolut")
        Revolut revolut;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="swish")
        Swish swish;
        @SerializedName(value="th_bank_transfer")
        ThBankTransfer thBankTransfer;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="us_bank_transfer")
        UsBankTransfer usBankTransfer;
        @SerializedName(value="wechat_pay")
        WechatPay wechatPay;
        @SerializedName(value="zip")
        Zip zip;

        @Generated
        public Affirm getAffirm() {
            return this.affirm;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AmazonPay getAmazonPay() {
            return this.amazonPay;
        }

        @Generated
        public AuBankTransfer getAuBankTransfer() {
            return this.auBankTransfer;
        }

        @Generated
        public Blik getBlik() {
            return this.blik;
        }

        @Generated
        public BrBankTransfer getBrBankTransfer() {
            return this.brBankTransfer;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public Cashapp getCashapp() {
            return this.cashapp;
        }

        @Generated
        public CustomerCashBalance getCustomerCashBalance() {
            return this.customerCashBalance;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public EuBankTransfer getEuBankTransfer() {
            return this.euBankTransfer;
        }

        @Generated
        public GbBankTransfer getGbBankTransfer() {
            return this.gbBankTransfer;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public JpBankTransfer getJpBankTransfer() {
            return this.jpBankTransfer;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Multibanco getMultibanco() {
            return this.multibanco;
        }

        @Generated
        public MxBankTransfer getMxBankTransfer() {
            return this.mxBankTransfer;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public Paynow getPaynow() {
            return this.paynow;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public Pix getPix() {
            return this.pix;
        }

        @Generated
        public Revolut getRevolut() {
            return this.revolut;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public Swish getSwish() {
            return this.swish;
        }

        @Generated
        public ThBankTransfer getThBankTransfer() {
            return this.thBankTransfer;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public UsBankTransfer getUsBankTransfer() {
            return this.usBankTransfer;
        }

        @Generated
        public WechatPay getWechatPay() {
            return this.wechatPay;
        }

        @Generated
        public Zip getZip() {
            return this.zip;
        }

        @Generated
        public void setAffirm(Affirm affirm) {
            this.affirm = affirm;
        }

        @Generated
        public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
            this.afterpayClearpay = afterpayClearpay;
        }

        @Generated
        public void setAlipay(Alipay alipay) {
            this.alipay = alipay;
        }

        @Generated
        public void setAmazonPay(AmazonPay amazonPay) {
            this.amazonPay = amazonPay;
        }

        @Generated
        public void setAuBankTransfer(AuBankTransfer auBankTransfer) {
            this.auBankTransfer = auBankTransfer;
        }

        @Generated
        public void setBlik(Blik blik) {
            this.blik = blik;
        }

        @Generated
        public void setBrBankTransfer(BrBankTransfer brBankTransfer) {
            this.brBankTransfer = brBankTransfer;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCashapp(Cashapp cashapp) {
            this.cashapp = cashapp;
        }

        @Generated
        public void setCustomerCashBalance(CustomerCashBalance customerCashBalance) {
            this.customerCashBalance = customerCashBalance;
        }

        @Generated
        public void setEps(Eps eps) {
            this.eps = eps;
        }

        @Generated
        public void setEuBankTransfer(EuBankTransfer euBankTransfer) {
            this.euBankTransfer = euBankTransfer;
        }

        @Generated
        public void setGbBankTransfer(GbBankTransfer gbBankTransfer) {
            this.gbBankTransfer = gbBankTransfer;
        }

        @Generated
        public void setGiropay(Giropay giropay) {
            this.giropay = giropay;
        }

        @Generated
        public void setGrabpay(Grabpay grabpay) {
            this.grabpay = grabpay;
        }

        @Generated
        public void setJpBankTransfer(JpBankTransfer jpBankTransfer) {
            this.jpBankTransfer = jpBankTransfer;
        }

        @Generated
        public void setKlarna(Klarna klarna) {
            this.klarna = klarna;
        }

        @Generated
        public void setMultibanco(Multibanco multibanco) {
            this.multibanco = multibanco;
        }

        @Generated
        public void setMxBankTransfer(MxBankTransfer mxBankTransfer) {
            this.mxBankTransfer = mxBankTransfer;
        }

        @Generated
        public void setP24(P24 p24) {
            this.p24 = p24;
        }

        @Generated
        public void setPaynow(Paynow paynow) {
            this.paynow = paynow;
        }

        @Generated
        public void setPaypal(Paypal paypal) {
            this.paypal = paypal;
        }

        @Generated
        public void setPix(Pix pix) {
            this.pix = pix;
        }

        @Generated
        public void setRevolut(Revolut revolut) {
            this.revolut = revolut;
        }

        @Generated
        public void setSofort(Sofort sofort) {
            this.sofort = sofort;
        }

        @Generated
        public void setSwish(Swish swish) {
            this.swish = swish;
        }

        @Generated
        public void setThBankTransfer(ThBankTransfer thBankTransfer) {
            this.thBankTransfer = thBankTransfer;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsBankTransfer(UsBankTransfer usBankTransfer) {
            this.usBankTransfer = usBankTransfer;
        }

        @Generated
        public void setWechatPay(WechatPay wechatPay) {
            this.wechatPay = wechatPay;
        }

        @Generated
        public void setZip(Zip zip) {
            this.zip = zip;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DestinationDetails)) {
                return false;
            }
            DestinationDetails other = (DestinationDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Affirm this$affirm = this.getAffirm();
            Affirm other$affirm = other.getAffirm();
            if (this$affirm == null ? other$affirm != null : !((Object)this$affirm).equals(other$affirm)) {
                return false;
            }
            AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
            AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
            if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
                return false;
            }
            Alipay this$alipay = this.getAlipay();
            Alipay other$alipay = other.getAlipay();
            if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
                return false;
            }
            AmazonPay this$amazonPay = this.getAmazonPay();
            AmazonPay other$amazonPay = other.getAmazonPay();
            if (this$amazonPay == null ? other$amazonPay != null : !((Object)this$amazonPay).equals(other$amazonPay)) {
                return false;
            }
            AuBankTransfer this$auBankTransfer = this.getAuBankTransfer();
            AuBankTransfer other$auBankTransfer = other.getAuBankTransfer();
            if (this$auBankTransfer == null ? other$auBankTransfer != null : !((Object)this$auBankTransfer).equals(other$auBankTransfer)) {
                return false;
            }
            Blik this$blik = this.getBlik();
            Blik other$blik = other.getBlik();
            if (this$blik == null ? other$blik != null : !((Object)this$blik).equals(other$blik)) {
                return false;
            }
            BrBankTransfer this$brBankTransfer = this.getBrBankTransfer();
            BrBankTransfer other$brBankTransfer = other.getBrBankTransfer();
            if (this$brBankTransfer == null ? other$brBankTransfer != null : !((Object)this$brBankTransfer).equals(other$brBankTransfer)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            Cashapp this$cashapp = this.getCashapp();
            Cashapp other$cashapp = other.getCashapp();
            if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
                return false;
            }
            CustomerCashBalance this$customerCashBalance = this.getCustomerCashBalance();
            CustomerCashBalance other$customerCashBalance = other.getCustomerCashBalance();
            if (this$customerCashBalance == null ? other$customerCashBalance != null : !((Object)this$customerCashBalance).equals(other$customerCashBalance)) {
                return false;
            }
            Eps this$eps = this.getEps();
            Eps other$eps = other.getEps();
            if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
                return false;
            }
            EuBankTransfer this$euBankTransfer = this.getEuBankTransfer();
            EuBankTransfer other$euBankTransfer = other.getEuBankTransfer();
            if (this$euBankTransfer == null ? other$euBankTransfer != null : !((Object)this$euBankTransfer).equals(other$euBankTransfer)) {
                return false;
            }
            GbBankTransfer this$gbBankTransfer = this.getGbBankTransfer();
            GbBankTransfer other$gbBankTransfer = other.getGbBankTransfer();
            if (this$gbBankTransfer == null ? other$gbBankTransfer != null : !((Object)this$gbBankTransfer).equals(other$gbBankTransfer)) {
                return false;
            }
            Giropay this$giropay = this.getGiropay();
            Giropay other$giropay = other.getGiropay();
            if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
                return false;
            }
            Grabpay this$grabpay = this.getGrabpay();
            Grabpay other$grabpay = other.getGrabpay();
            if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
                return false;
            }
            JpBankTransfer this$jpBankTransfer = this.getJpBankTransfer();
            JpBankTransfer other$jpBankTransfer = other.getJpBankTransfer();
            if (this$jpBankTransfer == null ? other$jpBankTransfer != null : !((Object)this$jpBankTransfer).equals(other$jpBankTransfer)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            Multibanco this$multibanco = this.getMultibanco();
            Multibanco other$multibanco = other.getMultibanco();
            if (this$multibanco == null ? other$multibanco != null : !((Object)this$multibanco).equals(other$multibanco)) {
                return false;
            }
            MxBankTransfer this$mxBankTransfer = this.getMxBankTransfer();
            MxBankTransfer other$mxBankTransfer = other.getMxBankTransfer();
            if (this$mxBankTransfer == null ? other$mxBankTransfer != null : !((Object)this$mxBankTransfer).equals(other$mxBankTransfer)) {
                return false;
            }
            P24 this$p24 = this.getP24();
            P24 other$p24 = other.getP24();
            if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
                return false;
            }
            Paynow this$paynow = this.getPaynow();
            Paynow other$paynow = other.getPaynow();
            if (this$paynow == null ? other$paynow != null : !((Object)this$paynow).equals(other$paynow)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                return false;
            }
            Pix this$pix = this.getPix();
            Pix other$pix = other.getPix();
            if (this$pix == null ? other$pix != null : !((Object)this$pix).equals(other$pix)) {
                return false;
            }
            Revolut this$revolut = this.getRevolut();
            Revolut other$revolut = other.getRevolut();
            if (this$revolut == null ? other$revolut != null : !((Object)this$revolut).equals(other$revolut)) {
                return false;
            }
            Sofort this$sofort = this.getSofort();
            Sofort other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                return false;
            }
            Swish this$swish = this.getSwish();
            Swish other$swish = other.getSwish();
            if (this$swish == null ? other$swish != null : !((Object)this$swish).equals(other$swish)) {
                return false;
            }
            ThBankTransfer this$thBankTransfer = this.getThBankTransfer();
            ThBankTransfer other$thBankTransfer = other.getThBankTransfer();
            if (this$thBankTransfer == null ? other$thBankTransfer != null : !((Object)this$thBankTransfer).equals(other$thBankTransfer)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankTransfer this$usBankTransfer = this.getUsBankTransfer();
            UsBankTransfer other$usBankTransfer = other.getUsBankTransfer();
            if (this$usBankTransfer == null ? other$usBankTransfer != null : !((Object)this$usBankTransfer).equals(other$usBankTransfer)) {
                return false;
            }
            WechatPay this$wechatPay = this.getWechatPay();
            WechatPay other$wechatPay = other.getWechatPay();
            if (this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay)) {
                return false;
            }
            Zip this$zip = this.getZip();
            Zip other$zip = other.getZip();
            return !(this$zip == null ? other$zip != null : !((Object)this$zip).equals(other$zip));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DestinationDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Affirm $affirm = this.getAffirm();
            result = result * 59 + ($affirm == null ? 43 : ((Object)$affirm).hashCode());
            AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
            result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
            Alipay $alipay = this.getAlipay();
            result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
            AmazonPay $amazonPay = this.getAmazonPay();
            result = result * 59 + ($amazonPay == null ? 43 : ((Object)$amazonPay).hashCode());
            AuBankTransfer $auBankTransfer = this.getAuBankTransfer();
            result = result * 59 + ($auBankTransfer == null ? 43 : ((Object)$auBankTransfer).hashCode());
            Blik $blik = this.getBlik();
            result = result * 59 + ($blik == null ? 43 : ((Object)$blik).hashCode());
            BrBankTransfer $brBankTransfer = this.getBrBankTransfer();
            result = result * 59 + ($brBankTransfer == null ? 43 : ((Object)$brBankTransfer).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            Cashapp $cashapp = this.getCashapp();
            result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
            CustomerCashBalance $customerCashBalance = this.getCustomerCashBalance();
            result = result * 59 + ($customerCashBalance == null ? 43 : ((Object)$customerCashBalance).hashCode());
            Eps $eps = this.getEps();
            result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
            EuBankTransfer $euBankTransfer = this.getEuBankTransfer();
            result = result * 59 + ($euBankTransfer == null ? 43 : ((Object)$euBankTransfer).hashCode());
            GbBankTransfer $gbBankTransfer = this.getGbBankTransfer();
            result = result * 59 + ($gbBankTransfer == null ? 43 : ((Object)$gbBankTransfer).hashCode());
            Giropay $giropay = this.getGiropay();
            result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
            Grabpay $grabpay = this.getGrabpay();
            result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
            JpBankTransfer $jpBankTransfer = this.getJpBankTransfer();
            result = result * 59 + ($jpBankTransfer == null ? 43 : ((Object)$jpBankTransfer).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            Multibanco $multibanco = this.getMultibanco();
            result = result * 59 + ($multibanco == null ? 43 : ((Object)$multibanco).hashCode());
            MxBankTransfer $mxBankTransfer = this.getMxBankTransfer();
            result = result * 59 + ($mxBankTransfer == null ? 43 : ((Object)$mxBankTransfer).hashCode());
            P24 $p24 = this.getP24();
            result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
            Paynow $paynow = this.getPaynow();
            result = result * 59 + ($paynow == null ? 43 : ((Object)$paynow).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            Pix $pix = this.getPix();
            result = result * 59 + ($pix == null ? 43 : ((Object)$pix).hashCode());
            Revolut $revolut = this.getRevolut();
            result = result * 59 + ($revolut == null ? 43 : ((Object)$revolut).hashCode());
            Sofort $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
            Swish $swish = this.getSwish();
            result = result * 59 + ($swish == null ? 43 : ((Object)$swish).hashCode());
            ThBankTransfer $thBankTransfer = this.getThBankTransfer();
            result = result * 59 + ($thBankTransfer == null ? 43 : ((Object)$thBankTransfer).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankTransfer $usBankTransfer = this.getUsBankTransfer();
            result = result * 59 + ($usBankTransfer == null ? 43 : ((Object)$usBankTransfer).hashCode());
            WechatPay $wechatPay = this.getWechatPay();
            result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
            Zip $zip = this.getZip();
            result = result * 59 + ($zip == null ? 43 : ((Object)$zip).hashCode());
            return result;
        }

        public static class Affirm
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Affirm)) {
                    return false;
                }
                Affirm other = (Affirm)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Affirm;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AfterpayClearpay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AfterpayClearpay)) {
                    return false;
                }
                AfterpayClearpay other = (AfterpayClearpay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AfterpayClearpay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Alipay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alipay)) {
                    return false;
                }
                Alipay other = (Alipay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alipay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AmazonPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AmazonPay)) {
                    return false;
                }
                AmazonPay other = (AmazonPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AmazonPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AuBankTransfer
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBankTransfer)) {
                    return false;
                }
                AuBankTransfer other = (AuBankTransfer)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBankTransfer;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Blik
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Blik)) {
                    return false;
                }
                Blik other = (Blik)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Blik;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class BrBankTransfer
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BrBankTransfer)) {
                    return false;
                }
                BrBankTransfer other = (BrBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BrBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;
            @SerializedName(value="reference_type")
            String referenceType;
            @SerializedName(value="type")
            String type;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public String getReferenceType() {
                return this.referenceType;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public void setReferenceType(String referenceType) {
                this.referenceType = referenceType;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                if (this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus)) {
                    return false;
                }
                String this$referenceType = this.getReferenceType();
                String other$referenceType = other.getReferenceType();
                if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                String $referenceType = this.getReferenceType();
                result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Cashapp
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cashapp)) {
                    return false;
                }
                Cashapp other = (Cashapp)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cashapp;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class CustomerCashBalance
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CustomerCashBalance)) {
                    return false;
                }
                CustomerCashBalance other = (CustomerCashBalance)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CustomerCashBalance;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Eps
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eps)) {
                    return false;
                }
                Eps other = (Eps)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eps;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class EuBankTransfer
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EuBankTransfer)) {
                    return false;
                }
                EuBankTransfer other = (EuBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof EuBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class GbBankTransfer
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GbBankTransfer)) {
                    return false;
                }
                GbBankTransfer other = (GbBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GbBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class Giropay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Giropay)) {
                    return false;
                }
                Giropay other = (Giropay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Giropay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Grabpay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Grabpay)) {
                    return false;
                }
                Grabpay other = (Grabpay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Grabpay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class JpBankTransfer
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JpBankTransfer)) {
                    return false;
                }
                JpBankTransfer other = (JpBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof JpBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class Klarna
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Multibanco
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Multibanco)) {
                    return false;
                }
                Multibanco other = (Multibanco)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Multibanco;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class MxBankTransfer
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MxBankTransfer)) {
                    return false;
                }
                MxBankTransfer other = (MxBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof MxBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class P24
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof P24)) {
                    return false;
                }
                P24 other = (P24)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof P24;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class Paynow
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paynow)) {
                    return false;
                }
                Paynow other = (Paynow)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paynow;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Paypal
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Pix
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pix)) {
                    return false;
                }
                Pix other = (Pix)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pix;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Revolut
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Revolut)) {
                    return false;
                }
                Revolut other = (Revolut)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Revolut;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Sofort
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Swish
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Swish)) {
                    return false;
                }
                Swish other = (Swish)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Swish;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class ThBankTransfer
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ThBankTransfer)) {
                    return false;
                }
                ThBankTransfer other = (ThBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ThBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class UsBankTransfer
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_status")
            String referenceStatus;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceStatus() {
                return this.referenceStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setReferenceStatus(String referenceStatus) {
                this.referenceStatus = referenceStatus;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankTransfer)) {
                    return false;
                }
                UsBankTransfer other = (UsBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceStatus = this.getReferenceStatus();
                String other$referenceStatus = other.getReferenceStatus();
                return !(this$referenceStatus == null ? other$referenceStatus != null : !this$referenceStatus.equals(other$referenceStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceStatus = this.getReferenceStatus();
                result = result * 59 + ($referenceStatus == null ? 43 : $referenceStatus.hashCode());
                return result;
            }
        }

        public static class WechatPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPay)) {
                    return false;
                }
                WechatPay other = (WechatPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Zip
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Zip)) {
                    return false;
                }
                Zip other = (Zip)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Zip;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }
    }

    public static class NextAction
    extends StripeObject {
        @SerializedName(value="display_details")
        DisplayDetails displayDetails;
        @SerializedName(value="type")
        String type;

        @Generated
        public DisplayDetails getDisplayDetails() {
            return this.displayDetails;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setDisplayDetails(DisplayDetails displayDetails) {
            this.displayDetails = displayDetails;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextAction)) {
                return false;
            }
            NextAction other = (NextAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DisplayDetails this$displayDetails = this.getDisplayDetails();
            DisplayDetails other$displayDetails = other.getDisplayDetails();
            if (this$displayDetails == null ? other$displayDetails != null : !((Object)this$displayDetails).equals(other$displayDetails)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DisplayDetails $displayDetails = this.getDisplayDetails();
            result = result * 59 + ($displayDetails == null ? 43 : ((Object)$displayDetails).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class DisplayDetails
        extends StripeObject {
            @SerializedName(value="email_sent")
            EmailSent emailSent;
            @SerializedName(value="expires_at")
            Long expiresAt;

            @Generated
            public EmailSent getEmailSent() {
                return this.emailSent;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public void setEmailSent(EmailSent emailSent) {
                this.emailSent = emailSent;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayDetails)) {
                    return false;
                }
                DisplayDetails other = (DisplayDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                EmailSent this$emailSent = this.getEmailSent();
                EmailSent other$emailSent = other.getEmailSent();
                return !(this$emailSent == null ? other$emailSent != null : !((Object)this$emailSent).equals(other$emailSent));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                EmailSent $emailSent = this.getEmailSent();
                result = result * 59 + ($emailSent == null ? 43 : ((Object)$emailSent).hashCode());
                return result;
            }

            public static class EmailSent
            extends StripeObject {
                @SerializedName(value="email_sent_at")
                Long emailSentAt;
                @SerializedName(value="email_sent_to")
                String emailSentTo;

                @Generated
                public Long getEmailSentAt() {
                    return this.emailSentAt;
                }

                @Generated
                public String getEmailSentTo() {
                    return this.emailSentTo;
                }

                @Generated
                public void setEmailSentAt(Long emailSentAt) {
                    this.emailSentAt = emailSentAt;
                }

                @Generated
                public void setEmailSentTo(String emailSentTo) {
                    this.emailSentTo = emailSentTo;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof EmailSent)) {
                        return false;
                    }
                    EmailSent other = (EmailSent)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$emailSentAt = this.getEmailSentAt();
                    Long other$emailSentAt = other.getEmailSentAt();
                    if (this$emailSentAt == null ? other$emailSentAt != null : !((Object)this$emailSentAt).equals(other$emailSentAt)) {
                        return false;
                    }
                    String this$emailSentTo = this.getEmailSentTo();
                    String other$emailSentTo = other.getEmailSentTo();
                    return !(this$emailSentTo == null ? other$emailSentTo != null : !this$emailSentTo.equals(other$emailSentTo));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof EmailSent;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $emailSentAt = this.getEmailSentAt();
                    result = result * 59 + ($emailSentAt == null ? 43 : ((Object)$emailSentAt).hashCode());
                    String $emailSentTo = this.getEmailSentTo();
                    result = result * 59 + ($emailSentTo == null ? 43 : $emailSentTo.hashCode());
                    return result;
                }
            }
        }
    }
}

