// File generated from our OpenAPI spec
package com.stripe.param.giftcards;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Getter;

@Getter
public class CardCreateParams extends ApiRequestParams {
  /**
   * The active state for the new gift card, defaults to false. The active state can be updated
   * after creation.
   */
  @SerializedName("active")
  Boolean active;

  /** Related objects which created this gift card. */
  @SerializedName("created_by")
  CreatedBy createdBy;

  /**
   * <strong>Required.</strong> Three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
   * Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;

  /** The initial amount to load onto the new gift card, defaults to 0. */
  @SerializedName("initial_amount")
  Long initialAmount;

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format. Individual keys can be unset by posting an empty value to them. All keys can
   * be unset by posting an empty value to {@code metadata}.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;

  private CardCreateParams(
      Boolean active,
      CreatedBy createdBy,
      String currency,
      List<String> expand,
      Map<String, Object> extraParams,
      Long initialAmount,
      Map<String, String> metadata) {
    this.active = active;
    this.createdBy = createdBy;
    this.currency = currency;
    this.expand = expand;
    this.extraParams = extraParams;
    this.initialAmount = initialAmount;
    this.metadata = metadata;
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean active;

    private CreatedBy createdBy;

    private String currency;

    private List<String> expand;

    private Map<String, Object> extraParams;

    private Long initialAmount;

    private Map<String, String> metadata;

    /** Finalize and obtain parameter instance from this builder. */
    public CardCreateParams build() {
      return new CardCreateParams(
          this.active,
          this.createdBy,
          this.currency,
          this.expand,
          this.extraParams,
          this.initialAmount,
          this.metadata);
    }

    /**
     * The active state for the new gift card, defaults to false. The active state can be updated
     * after creation.
     */
    public Builder setActive(Boolean active) {
      this.active = active;
      return this;
    }

    /** Related objects which created this gift card. */
    public Builder setCreatedBy(CardCreateParams.CreatedBy createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    /**
     * <strong>Required.</strong> Three-letter <a
     * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
     * Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
     */
    public Builder setCurrency(String currency) {
      this.currency = currency;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * CardCreateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * CardCreateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * CardCreateParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link CardCreateParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }

    /** The initial amount to load onto the new gift card, defaults to 0. */
    public Builder setInitialAmount(Long initialAmount) {
      this.initialAmount = initialAmount;
      return this;
    }

    /**
     * Add a key/value pair to `metadata` map. A map is initialized for the first `put/putAll` call,
     * and subsequent calls add additional key/value pairs to the original map. See {@link
     * CardCreateParams#metadata} for the field documentation.
     */
    public Builder putMetadata(String key, String value) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `metadata` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link CardCreateParams#metadata} for the field documentation.
     */
    public Builder putAllMetadata(Map<String, String> map) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.putAll(map);
      return this;
    }
  }

  @Getter
  public static class CreatedBy {
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;

    /** <strong>Required.</strong> The details for the payment that created this object. */
    @SerializedName("payment")
    Payment payment;

    /** <strong>Required.</strong> The type of event that created this object. */
    @SerializedName("type")
    Type type;

    private CreatedBy(Map<String, Object> extraParams, Payment payment, Type type) {
      this.extraParams = extraParams;
      this.payment = payment;
      this.type = type;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Builder {
      private Map<String, Object> extraParams;

      private Payment payment;

      private Type type;

      /** Finalize and obtain parameter instance from this builder. */
      public CardCreateParams.CreatedBy build() {
        return new CardCreateParams.CreatedBy(this.extraParams, this.payment, this.type);
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * CardCreateParams.CreatedBy#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link CardCreateParams.CreatedBy#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /** <strong>Required.</strong> The details for the payment that created this object. */
      public Builder setPayment(CardCreateParams.CreatedBy.Payment payment) {
        this.payment = payment;
        return this;
      }

      /** <strong>Required.</strong> The type of event that created this object. */
      public Builder setType(CardCreateParams.CreatedBy.Type type) {
        this.type = type;
        return this;
      }
    }

    @Getter
    public static class Payment {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      /** <strong>Required.</strong> The PaymentIntent used to collect payment for this object. */
      @SerializedName("payment_intent")
      String paymentIntent;

      private Payment(Map<String, Object> extraParams, String paymentIntent) {
        this.extraParams = extraParams;
        this.paymentIntent = paymentIntent;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static class Builder {
        private Map<String, Object> extraParams;

        private String paymentIntent;

        /** Finalize and obtain parameter instance from this builder. */
        public CardCreateParams.CreatedBy.Payment build() {
          return new CardCreateParams.CreatedBy.Payment(this.extraParams, this.paymentIntent);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link CardCreateParams.CreatedBy.Payment#extraParams} for the field
         * documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link CardCreateParams.CreatedBy.Payment#extraParams} for the field
         * documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        /** <strong>Required.</strong> The PaymentIntent used to collect payment for this object. */
        public Builder setPaymentIntent(String paymentIntent) {
          this.paymentIntent = paymentIntent;
          return this;
        }
      }
    }

    public enum Type implements ApiRequestParams.EnumParam {
      @SerializedName("payment")
      PAYMENT("payment");

      @Getter(onMethod_ = {@Override})
      private final String value;

      Type(String value) {
        this.value = value;
      }
    }
  }
}
