/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.StripeCollection;
import com.stripe.model.StripeSearchResult;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerCreateParams;
import com.stripe.param.CustomerListParams;
import com.stripe.param.CustomerRetrieveParams;
import com.stripe.param.CustomerSearchParams;
import com.stripe.param.CustomerUpdateParams;
import com.stripe.service.CustomerBalanceTransactionService;
import com.stripe.service.CustomerCashBalanceService;
import com.stripe.service.CustomerCashBalanceTransactionService;
import com.stripe.service.CustomerFundingInstructionsService;
import com.stripe.service.CustomerPaymentMethodService;
import com.stripe.service.CustomerPaymentSourceService;
import com.stripe.service.CustomerTaxIdService;
import java.lang.reflect.Type;

public final class CustomerService
extends ApiService {
    public CustomerService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Customer delete(String customer) throws StripeException {
        return this.delete(customer, null);
    }

    public Customer delete(String customer, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (Customer)this.request(request, (Type)((Object)Customer.class));
    }

    public Customer retrieve(String customer, CustomerRetrieveParams params) throws StripeException {
        return this.retrieve(customer, params, null);
    }

    public Customer retrieve(String customer, RequestOptions options) throws StripeException {
        return this.retrieve(customer, null, options);
    }

    public Customer retrieve(String customer) throws StripeException {
        return this.retrieve(customer, null, null);
    }

    public Customer retrieve(String customer, CustomerRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Customer)this.request(request, (Type)((Object)Customer.class));
    }

    public Customer update(String customer, CustomerUpdateParams params) throws StripeException {
        return this.update(customer, params, null);
    }

    public Customer update(String customer, RequestOptions options) throws StripeException {
        return this.update(customer, null, options);
    }

    public Customer update(String customer) throws StripeException {
        return this.update(customer, null, null);
    }

    public Customer update(String customer, CustomerUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Customer)this.request(request, (Type)((Object)Customer.class));
    }

    public Discount deleteDiscount(String customer) throws StripeException {
        return this.deleteDiscount(customer, null);
    }

    public Discount deleteDiscount(String customer, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/discount", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (Discount)this.request(request, (Type)((Object)Discount.class));
    }

    public StripeCollection<Customer> list(CustomerListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Customer> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Customer> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Customer> list(CustomerListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/customers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Customer>>(){}.getType());
    }

    public Customer create(CustomerCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Customer create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Customer create() throws StripeException {
        return this.create(null, null);
    }

    public Customer create(CustomerCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/customers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Customer)this.request(request, (Type)((Object)Customer.class));
    }

    public StripeSearchResult<Customer> search(CustomerSearchParams params) throws StripeException {
        return this.search(params, null);
    }

    public StripeSearchResult<Customer> search(CustomerSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/customers/search";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeSearchResult)this.request(request, new TypeToken<StripeSearchResult<Customer>>(){}.getType());
    }

    public CustomerBalanceTransactionService balanceTransactions() {
        return new CustomerBalanceTransactionService(this.getResponseGetter());
    }

    public CustomerCashBalanceService cashBalance() {
        return new CustomerCashBalanceService(this.getResponseGetter());
    }

    public CustomerCashBalanceTransactionService cashBalanceTransactions() {
        return new CustomerCashBalanceTransactionService(this.getResponseGetter());
    }

    public CustomerFundingInstructionsService fundingInstructions() {
        return new CustomerFundingInstructionsService(this.getResponseGetter());
    }

    public CustomerPaymentMethodService paymentMethods() {
        return new CustomerPaymentMethodService(this.getResponseGetter());
    }

    public CustomerPaymentSourceService paymentSources() {
        return new CustomerPaymentSourceService(this.getResponseGetter());
    }

    public CustomerTaxIdService taxIds() {
        return new CustomerTaxIdService(this.getResponseGetter());
    }
}

