/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.tax;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.tax.TransactionLineItem;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.tax.TransactionLineItemListParams;

public final class TransactionLineItemService
extends ApiService {
    public TransactionLineItemService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<TransactionLineItem> list(String transaction, TransactionLineItemListParams params) throws StripeException {
        return this.list(transaction, params, null);
    }

    public StripeCollection<TransactionLineItem> list(String transaction, RequestOptions options) throws StripeException {
        return this.list(transaction, null, options);
    }

    public StripeCollection<TransactionLineItem> list(String transaction) throws StripeException {
        return this.list(transaction, null, null);
    }

    public StripeCollection<TransactionLineItem> list(String transaction, TransactionLineItemListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/transactions/%s/line_items", ApiResource.urlEncodeId(transaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<TransactionLineItem>>(){}.getType());
    }
}

