/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.testhelpers.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.issuing.Transaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.TransactionCreateForceCaptureParams;
import com.stripe.param.issuing.TransactionCreateUnlinkedRefundParams;
import com.stripe.param.issuing.TransactionRefundParams;
import java.lang.reflect.Type;

public final class TransactionService
extends ApiService {
    public TransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Transaction refund(String transaction, TransactionRefundParams params) throws StripeException {
        return this.refund(transaction, params, null);
    }

    public Transaction refund(String transaction, RequestOptions options) throws StripeException {
        return this.refund(transaction, null, options);
    }

    public Transaction refund(String transaction) throws StripeException {
        return this.refund(transaction, null, null);
    }

    public Transaction refund(String transaction, TransactionRefundParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/transactions/%s/refund", ApiResource.urlEncodeId(transaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Transaction)this.request(request, (Type)((Object)Transaction.class));
    }

    public Transaction createForceCapture(TransactionCreateForceCaptureParams params) throws StripeException {
        return this.createForceCapture(params, null);
    }

    public Transaction createForceCapture(TransactionCreateForceCaptureParams params, RequestOptions options) throws StripeException {
        String path = "/v1/test_helpers/issuing/transactions/create_force_capture";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Transaction)this.request(request, (Type)((Object)Transaction.class));
    }

    public Transaction createUnlinkedRefund(TransactionCreateUnlinkedRefundParams params) throws StripeException {
        return this.createUnlinkedRefund(params, null);
    }

    public Transaction createUnlinkedRefund(TransactionCreateUnlinkedRefundParams params, RequestOptions options) throws StripeException {
        String path = "/v1/test_helpers/issuing/transactions/create_unlinked_refund";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Transaction)this.request(request, (Type)((Object)Transaction.class));
    }
}

