/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.CreditUnderwritingRecord;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CreditUnderwritingRecordCorrectParams;
import com.stripe.param.issuing.CreditUnderwritingRecordCreateFromApplicationParams;
import com.stripe.param.issuing.CreditUnderwritingRecordCreateFromProactiveReviewParams;
import com.stripe.param.issuing.CreditUnderwritingRecordListParams;
import com.stripe.param.issuing.CreditUnderwritingRecordReportDecisionParams;
import com.stripe.param.issuing.CreditUnderwritingRecordRetrieveParams;
import java.lang.reflect.Type;

public final class CreditUnderwritingRecordService
extends ApiService {
    public CreditUnderwritingRecordService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CreditUnderwritingRecord> list(CreditUnderwritingRecordListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<CreditUnderwritingRecord> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<CreditUnderwritingRecord> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<CreditUnderwritingRecord> list(CreditUnderwritingRecordListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/credit_underwriting_records";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<CreditUnderwritingRecord>>(){}.getType());
    }

    public CreditUnderwritingRecord retrieve(String creditUnderwritingRecord, CreditUnderwritingRecordRetrieveParams params) throws StripeException {
        return this.retrieve(creditUnderwritingRecord, params, null);
    }

    public CreditUnderwritingRecord retrieve(String creditUnderwritingRecord, RequestOptions options) throws StripeException {
        return this.retrieve(creditUnderwritingRecord, null, options);
    }

    public CreditUnderwritingRecord retrieve(String creditUnderwritingRecord) throws StripeException {
        return this.retrieve(creditUnderwritingRecord, null, null);
    }

    public CreditUnderwritingRecord retrieve(String creditUnderwritingRecord, CreditUnderwritingRecordRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/credit_underwriting_records/%s", ApiResource.urlEncodeId(creditUnderwritingRecord));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)this.request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public CreditUnderwritingRecord correct(String creditUnderwritingRecord, CreditUnderwritingRecordCorrectParams params) throws StripeException {
        return this.correct(creditUnderwritingRecord, params, null);
    }

    public CreditUnderwritingRecord correct(String creditUnderwritingRecord, RequestOptions options) throws StripeException {
        return this.correct(creditUnderwritingRecord, null, options);
    }

    public CreditUnderwritingRecord correct(String creditUnderwritingRecord) throws StripeException {
        return this.correct(creditUnderwritingRecord, null, null);
    }

    public CreditUnderwritingRecord correct(String creditUnderwritingRecord, CreditUnderwritingRecordCorrectParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/credit_underwriting_records/%s/correct", ApiResource.urlEncodeId(creditUnderwritingRecord));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)this.request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public CreditUnderwritingRecord reportDecision(String creditUnderwritingRecord, CreditUnderwritingRecordReportDecisionParams params) throws StripeException {
        return this.reportDecision(creditUnderwritingRecord, params, null);
    }

    public CreditUnderwritingRecord reportDecision(String creditUnderwritingRecord, CreditUnderwritingRecordReportDecisionParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/credit_underwriting_records/%s/report_decision", ApiResource.urlEncodeId(creditUnderwritingRecord));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)this.request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public CreditUnderwritingRecord createFromApplication(CreditUnderwritingRecordCreateFromApplicationParams params) throws StripeException {
        return this.createFromApplication(params, null);
    }

    public CreditUnderwritingRecord createFromApplication(CreditUnderwritingRecordCreateFromApplicationParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/credit_underwriting_records/create_from_application";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)this.request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }

    public CreditUnderwritingRecord createFromProactiveReview(CreditUnderwritingRecordCreateFromProactiveReviewParams params) throws StripeException {
        return this.createFromProactiveReview(params, null);
    }

    public CreditUnderwritingRecord createFromProactiveReview(CreditUnderwritingRecordCreateFromProactiveReviewParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/credit_underwriting_records/create_from_proactive_review";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CreditUnderwritingRecord)this.request(request, (Type)((Object)CreditUnderwritingRecord.class));
    }
}

