/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.entitlements;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.entitlements.Feature;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.entitlements.FeatureCreateParams;
import com.stripe.param.entitlements.FeatureListParams;
import com.stripe.param.entitlements.FeatureRetrieveParams;
import com.stripe.param.entitlements.FeatureUpdateParams;
import java.lang.reflect.Type;

public final class FeatureService
extends ApiService {
    public FeatureService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Feature> list(FeatureListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Feature> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Feature> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Feature> list(FeatureListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Feature>>(){}.getType());
    }

    public Feature create(FeatureCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Feature create(FeatureCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Feature)this.request(request, (Type)((Object)Feature.class));
    }

    public Feature retrieve(String id, FeatureRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Feature retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Feature retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Feature retrieve(String id, FeatureRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/entitlements/features/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Feature)this.request(request, (Type)((Object)Feature.class));
    }

    public Feature update(String id, FeatureUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public Feature update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public Feature update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public Feature update(String id, FeatureUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/entitlements/features/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Feature)this.request(request, (Type)((Object)Feature.class));
    }
}

