/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.billing.AlertCollection;
import com.stripe.model.billing.Meter;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.AlertActivateParams;
import com.stripe.param.billing.AlertArchiveParams;
import com.stripe.param.billing.AlertCreateParams;
import com.stripe.param.billing.AlertDeactivateParams;
import com.stripe.param.billing.AlertListParams;
import com.stripe.param.billing.AlertRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Alert
extends ApiResource
implements HasId {
    @SerializedName(value="alert_type")
    String alertType;
    @SerializedName(value="filter")
    Filter filter;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="title")
    String title;
    @SerializedName(value="usage_threshold_config")
    UsageThresholdConfig usageThresholdConfig;

    public Alert activate() throws StripeException {
        return this.activate((Map<String, Object>)null, (RequestOptions)null);
    }

    public Alert activate(RequestOptions options) throws StripeException {
        return this.activate((Map<String, Object>)null, options);
    }

    public Alert activate(Map<String, Object> params) throws StripeException {
        return this.activate(params, (RequestOptions)null);
    }

    public Alert activate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/activate", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert activate(AlertActivateParams params) throws StripeException {
        return this.activate(params, (RequestOptions)null);
    }

    public Alert activate(AlertActivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/activate", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert archive() throws StripeException {
        return this.archive((Map<String, Object>)null, (RequestOptions)null);
    }

    public Alert archive(RequestOptions options) throws StripeException {
        return this.archive((Map<String, Object>)null, options);
    }

    public Alert archive(Map<String, Object> params) throws StripeException {
        return this.archive(params, (RequestOptions)null);
    }

    public Alert archive(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/archive", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert archive(AlertArchiveParams params) throws StripeException {
        return this.archive(params, (RequestOptions)null);
    }

    public Alert archive(AlertArchiveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/archive", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public static Alert create(Map<String, Object> params) throws StripeException {
        return Alert.create(params, (RequestOptions)null);
    }

    public static Alert create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Alert)Alert.getGlobalResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public static Alert create(AlertCreateParams params) throws StripeException {
        return Alert.create(params, (RequestOptions)null);
    }

    public static Alert create(AlertCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)Alert.getGlobalResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert deactivate() throws StripeException {
        return this.deactivate((Map<String, Object>)null, (RequestOptions)null);
    }

    public Alert deactivate(RequestOptions options) throws StripeException {
        return this.deactivate((Map<String, Object>)null, options);
    }

    public Alert deactivate(Map<String, Object> params) throws StripeException {
        return this.deactivate(params, (RequestOptions)null);
    }

    public Alert deactivate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/deactivate", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert deactivate(AlertDeactivateParams params) throws StripeException {
        return this.deactivate(params, (RequestOptions)null);
    }

    public Alert deactivate(AlertDeactivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/deactivate", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public static AlertCollection list(Map<String, Object> params) throws StripeException {
        return Alert.list(params, (RequestOptions)null);
    }

    public static AlertCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (AlertCollection)Alert.getGlobalResponseGetter().request(request, (Type)((Object)AlertCollection.class));
    }

    public static AlertCollection list(AlertListParams params) throws StripeException {
        return Alert.list(params, (RequestOptions)null);
    }

    public static AlertCollection list(AlertListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (AlertCollection)Alert.getGlobalResponseGetter().request(request, (Type)((Object)AlertCollection.class));
    }

    public static Alert retrieve(String id) throws StripeException {
        return Alert.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Alert retrieve(String id, RequestOptions options) throws StripeException {
        return Alert.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Alert retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Alert)Alert.getGlobalResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public static Alert retrieve(String id, AlertRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)Alert.getGlobalResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.filter, responseGetter);
        this.trySetResponseGetter(this.usageThresholdConfig, responseGetter);
    }

    @Generated
    public String getAlertType() {
        return this.alertType;
    }

    @Generated
    public Filter getFilter() {
        return this.filter;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public UsageThresholdConfig getUsageThresholdConfig() {
        return this.usageThresholdConfig;
    }

    @Generated
    public void setAlertType(String alertType) {
        this.alertType = alertType;
    }

    @Generated
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setUsageThresholdConfig(UsageThresholdConfig usageThresholdConfig) {
        this.usageThresholdConfig = usageThresholdConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$alertType = this.getAlertType();
        String other$alertType = other.getAlertType();
        if (this$alertType == null ? other$alertType != null : !this$alertType.equals(other$alertType)) {
            return false;
        }
        Filter this$filter = this.getFilter();
        Filter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        UsageThresholdConfig this$usageThresholdConfig = this.getUsageThresholdConfig();
        UsageThresholdConfig other$usageThresholdConfig = other.getUsageThresholdConfig();
        return !(this$usageThresholdConfig == null ? other$usageThresholdConfig != null : !((Object)this$usageThresholdConfig).equals(other$usageThresholdConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Alert;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $alertType = this.getAlertType();
        result = result * 59 + ($alertType == null ? 43 : $alertType.hashCode());
        Filter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        UsageThresholdConfig $usageThresholdConfig = this.getUsageThresholdConfig();
        result = result * 59 + ($usageThresholdConfig == null ? 43 : ((Object)$usageThresholdConfig).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Filter
    extends StripeObject {
        @SerializedName(value="customer")
        ExpandableField<Customer> customer;

        public String getCustomer() {
            return this.customer != null ? this.customer.getId() : null;
        }

        public void setCustomer(String id) {
            this.customer = ApiResource.setExpandableFieldId(id, this.customer);
        }

        public Customer getCustomerObject() {
            return this.customer != null ? this.customer.getExpanded() : null;
        }

        public void setCustomerObject(Customer expandableObject) {
            this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customer = this.getCustomer();
            String other$customer = other.getCustomer();
            return !(this$customer == null ? other$customer != null : !this$customer.equals(other$customer));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Filter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customer = this.getCustomer();
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            return result;
        }
    }

    public static class UsageThresholdConfig
    extends StripeObject {
        @SerializedName(value="gte")
        Long gte;
        @SerializedName(value="meter")
        ExpandableField<Meter> meter;
        @SerializedName(value="recurrence")
        String recurrence;

        public String getMeter() {
            return this.meter != null ? this.meter.getId() : null;
        }

        public void setMeter(String id) {
            this.meter = ApiResource.setExpandableFieldId(id, this.meter);
        }

        public Meter getMeterObject() {
            return this.meter != null ? this.meter.getExpanded() : null;
        }

        public void setMeterObject(Meter expandableObject) {
            this.meter = new ExpandableField<Meter>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getGte() {
            return this.gte;
        }

        @Generated
        public String getRecurrence() {
            return this.recurrence;
        }

        @Generated
        public void setGte(Long gte) {
            this.gte = gte;
        }

        @Generated
        public void setRecurrence(String recurrence) {
            this.recurrence = recurrence;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsageThresholdConfig)) {
                return false;
            }
            UsageThresholdConfig other = (UsageThresholdConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$gte = this.getGte();
            Long other$gte = other.getGte();
            if (this$gte == null ? other$gte != null : !((Object)this$gte).equals(other$gte)) {
                return false;
            }
            String this$meter = this.getMeter();
            String other$meter = other.getMeter();
            if (this$meter == null ? other$meter != null : !this$meter.equals(other$meter)) {
                return false;
            }
            String this$recurrence = this.getRecurrence();
            String other$recurrence = other.getRecurrence();
            return !(this$recurrence == null ? other$recurrence != null : !this$recurrence.equals(other$recurrence));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UsageThresholdConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $gte = this.getGte();
            result = result * 59 + ($gte == null ? 43 : ((Object)$gte).hashCode());
            String $meter = this.getMeter();
            result = result * 59 + ($meter == null ? 43 : $meter.hashCode());
            String $recurrence = this.getRecurrence();
            result = result * 59 + ($recurrence == null ? 43 : $recurrence.hashCode());
            return result;
        }
    }
}

