/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.billing.Meter;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.MeterCreateParams;
import com.stripe.param.billing.MeterDeactivateParams;
import com.stripe.param.billing.MeterListParams;
import com.stripe.param.billing.MeterReactivateParams;
import com.stripe.param.billing.MeterRetrieveParams;
import com.stripe.param.billing.MeterUpdateParams;
import com.stripe.service.billing.MeterEventSummaryService;
import java.lang.reflect.Type;

public final class MeterService
extends ApiService {
    public MeterService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Meter> list(MeterListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Meter> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Meter> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Meter> list(MeterListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/meters";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Meter>>(){}.getType());
    }

    public Meter create(MeterCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Meter create(MeterCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/meters";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Meter)this.request(request, (Type)((Object)Meter.class));
    }

    public Meter retrieve(String id, MeterRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Meter retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Meter retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Meter retrieve(String id, MeterRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Meter)this.request(request, (Type)((Object)Meter.class));
    }

    public Meter update(String id, MeterUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public Meter update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public Meter update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public Meter update(String id, MeterUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Meter)this.request(request, (Type)((Object)Meter.class));
    }

    public Meter deactivate(String id, MeterDeactivateParams params) throws StripeException {
        return this.deactivate(id, params, null);
    }

    public Meter deactivate(String id, RequestOptions options) throws StripeException {
        return this.deactivate(id, null, options);
    }

    public Meter deactivate(String id) throws StripeException {
        return this.deactivate(id, null, null);
    }

    public Meter deactivate(String id, MeterDeactivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/deactivate", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Meter)this.request(request, (Type)((Object)Meter.class));
    }

    public Meter reactivate(String id, MeterReactivateParams params) throws StripeException {
        return this.reactivate(id, params, null);
    }

    public Meter reactivate(String id, RequestOptions options) throws StripeException {
        return this.reactivate(id, null, options);
    }

    public Meter reactivate(String id) throws StripeException {
        return this.reactivate(id, null, null);
    }

    public Meter reactivate(String id, MeterReactivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/reactivate", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Meter)this.request(request, (Type)((Object)Meter.class));
    }

    public MeterEventSummaryService eventSummaries() {
        return new MeterEventSummaryService(this.getResponseGetter());
    }
}

