/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.DisputeCollection;
import com.stripe.model.issuing.Transaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.DisputeCreateParams;
import com.stripe.param.issuing.DisputeListParams;
import com.stripe.param.issuing.DisputeRetrieveParams;
import com.stripe.param.issuing.DisputeSubmitParams;
import com.stripe.param.issuing.DisputeUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Dispute
extends ApiResource
implements MetadataStore<Dispute>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="balance_transactions")
    List<BalanceTransaction> balanceTransactions;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="evidence")
    Evidence evidence;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="loss_reason")
    String lossReason;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transaction")
    ExpandableField<Transaction> transaction;
    @SerializedName(value="treasury")
    Treasury treasury;

    public String getTransaction() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
        this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    public Transaction getTransactionObject() {
        return this.transaction != null ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
        this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    public static Dispute create(Map<String, Object> params) throws StripeException {
        return Dispute.create(params, (RequestOptions)null);
    }

    public static Dispute create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/disputes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Dispute)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public static Dispute create(DisputeCreateParams params) throws StripeException {
        return Dispute.create(params, (RequestOptions)null);
    }

    public static Dispute create(DisputeCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/disputes";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public static DisputeCollection list(Map<String, Object> params) throws StripeException {
        return Dispute.list(params, (RequestOptions)null);
    }

    public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/disputes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (DisputeCollection)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)DisputeCollection.class));
    }

    public static DisputeCollection list(DisputeListParams params) throws StripeException {
        return Dispute.list(params, (RequestOptions)null);
    }

    public static DisputeCollection list(DisputeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/disputes";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (DisputeCollection)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)DisputeCollection.class));
    }

    public static Dispute retrieve(String dispute) throws StripeException {
        return Dispute.retrieve(dispute, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Dispute retrieve(String dispute, RequestOptions options) throws StripeException {
        return Dispute.retrieve(dispute, (Map<String, Object>)null, options);
    }

    public static Dispute retrieve(String dispute, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Dispute)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public static Dispute retrieve(String dispute, DisputeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public Dispute submit() throws StripeException {
        return this.submit((Map<String, Object>)null, (RequestOptions)null);
    }

    public Dispute submit(RequestOptions options) throws StripeException {
        return this.submit((Map<String, Object>)null, options);
    }

    public Dispute submit(Map<String, Object> params) throws StripeException {
        return this.submit(params, (RequestOptions)null);
    }

    public Dispute submit(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/disputes/%s/submit", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Dispute)this.getResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public Dispute submit(DisputeSubmitParams params) throws StripeException {
        return this.submit(params, (RequestOptions)null);
    }

    public Dispute submit(DisputeSubmitParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/disputes/%s/submit", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)this.getResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public Dispute update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Dispute)this.getResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public Dispute update(DisputeUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Dispute update(DisputeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)this.getResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.evidence, responseGetter);
        this.trySetResponseGetter(this.transaction, responseGetter);
        this.trySetResponseGetter(this.treasury, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public List<BalanceTransaction> getBalanceTransactions() {
        return this.balanceTransactions;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Evidence getEvidence() {
        return this.evidence;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getLossReason() {
        return this.lossReason;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Treasury getTreasury() {
        return this.treasury;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setBalanceTransactions(List<BalanceTransaction> balanceTransactions) {
        this.balanceTransactions = balanceTransactions;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setEvidence(Evidence evidence) {
        this.evidence = evidence;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLossReason(String lossReason) {
        this.lossReason = lossReason;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTreasury(Treasury treasury) {
        this.treasury = treasury;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dispute)) {
            return false;
        }
        Dispute other = (Dispute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        List<BalanceTransaction> this$balanceTransactions = this.getBalanceTransactions();
        List<BalanceTransaction> other$balanceTransactions = other.getBalanceTransactions();
        if (this$balanceTransactions == null ? other$balanceTransactions != null : !((Object)this$balanceTransactions).equals(other$balanceTransactions)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Evidence this$evidence = this.getEvidence();
        Evidence other$evidence = other.getEvidence();
        if (this$evidence == null ? other$evidence != null : !((Object)this$evidence).equals(other$evidence)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lossReason = this.getLossReason();
        String other$lossReason = other.getLossReason();
        if (this$lossReason == null ? other$lossReason != null : !this$lossReason.equals(other$lossReason)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transaction = this.getTransaction();
        String other$transaction = other.getTransaction();
        if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) {
            return false;
        }
        Treasury this$treasury = this.getTreasury();
        Treasury other$treasury = other.getTreasury();
        return !(this$treasury == null ? other$treasury != null : !((Object)this$treasury).equals(other$treasury));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dispute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        List<BalanceTransaction> $balanceTransactions = this.getBalanceTransactions();
        result = result * 59 + ($balanceTransactions == null ? 43 : ((Object)$balanceTransactions).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Evidence $evidence = this.getEvidence();
        result = result * 59 + ($evidence == null ? 43 : ((Object)$evidence).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lossReason = this.getLossReason();
        result = result * 59 + ($lossReason == null ? 43 : $lossReason.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        Treasury $treasury = this.getTreasury();
        result = result * 59 + ($treasury == null ? 43 : ((Object)$treasury).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Evidence
    extends StripeObject {
        @SerializedName(value="canceled")
        Canceled canceled;
        @SerializedName(value="duplicate")
        Duplicate duplicate;
        @SerializedName(value="fraudulent")
        Fraudulent fraudulent;
        @SerializedName(value="merchandise_not_as_described")
        MerchandiseNotAsDescribed merchandiseNotAsDescribed;
        @SerializedName(value="no_valid_authorization")
        NoValidAuthorization noValidAuthorization;
        @SerializedName(value="not_received")
        NotReceived notReceived;
        @SerializedName(value="other")
        Other other;
        @SerializedName(value="reason")
        String reason;
        @SerializedName(value="service_not_as_described")
        ServiceNotAsDescribed serviceNotAsDescribed;

        @Generated
        public Canceled getCanceled() {
            return this.canceled;
        }

        @Generated
        public Duplicate getDuplicate() {
            return this.duplicate;
        }

        @Generated
        public Fraudulent getFraudulent() {
            return this.fraudulent;
        }

        @Generated
        public MerchandiseNotAsDescribed getMerchandiseNotAsDescribed() {
            return this.merchandiseNotAsDescribed;
        }

        @Generated
        public NoValidAuthorization getNoValidAuthorization() {
            return this.noValidAuthorization;
        }

        @Generated
        public NotReceived getNotReceived() {
            return this.notReceived;
        }

        @Generated
        public Other getOther() {
            return this.other;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public ServiceNotAsDescribed getServiceNotAsDescribed() {
            return this.serviceNotAsDescribed;
        }

        @Generated
        public void setCanceled(Canceled canceled) {
            this.canceled = canceled;
        }

        @Generated
        public void setDuplicate(Duplicate duplicate) {
            this.duplicate = duplicate;
        }

        @Generated
        public void setFraudulent(Fraudulent fraudulent) {
            this.fraudulent = fraudulent;
        }

        @Generated
        public void setMerchandiseNotAsDescribed(MerchandiseNotAsDescribed merchandiseNotAsDescribed) {
            this.merchandiseNotAsDescribed = merchandiseNotAsDescribed;
        }

        @Generated
        public void setNoValidAuthorization(NoValidAuthorization noValidAuthorization) {
            this.noValidAuthorization = noValidAuthorization;
        }

        @Generated
        public void setNotReceived(NotReceived notReceived) {
            this.notReceived = notReceived;
        }

        @Generated
        public void setOther(Other other) {
            this.other = other;
        }

        @Generated
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Generated
        public void setServiceNotAsDescribed(ServiceNotAsDescribed serviceNotAsDescribed) {
            this.serviceNotAsDescribed = serviceNotAsDescribed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Evidence)) {
                return false;
            }
            Evidence other = (Evidence)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Canceled this$canceled = this.getCanceled();
            Canceled other$canceled = other.getCanceled();
            if (this$canceled == null ? other$canceled != null : !((Object)this$canceled).equals(other$canceled)) {
                return false;
            }
            Duplicate this$duplicate = this.getDuplicate();
            Duplicate other$duplicate = other.getDuplicate();
            if (this$duplicate == null ? other$duplicate != null : !((Object)this$duplicate).equals(other$duplicate)) {
                return false;
            }
            Fraudulent this$fraudulent = this.getFraudulent();
            Fraudulent other$fraudulent = other.getFraudulent();
            if (this$fraudulent == null ? other$fraudulent != null : !((Object)this$fraudulent).equals(other$fraudulent)) {
                return false;
            }
            MerchandiseNotAsDescribed this$merchandiseNotAsDescribed = this.getMerchandiseNotAsDescribed();
            MerchandiseNotAsDescribed other$merchandiseNotAsDescribed = other.getMerchandiseNotAsDescribed();
            if (this$merchandiseNotAsDescribed == null ? other$merchandiseNotAsDescribed != null : !((Object)this$merchandiseNotAsDescribed).equals(other$merchandiseNotAsDescribed)) {
                return false;
            }
            NoValidAuthorization this$noValidAuthorization = this.getNoValidAuthorization();
            NoValidAuthorization other$noValidAuthorization = other.getNoValidAuthorization();
            if (this$noValidAuthorization == null ? other$noValidAuthorization != null : !((Object)this$noValidAuthorization).equals(other$noValidAuthorization)) {
                return false;
            }
            NotReceived this$notReceived = this.getNotReceived();
            NotReceived other$notReceived = other.getNotReceived();
            if (this$notReceived == null ? other$notReceived != null : !((Object)this$notReceived).equals(other$notReceived)) {
                return false;
            }
            Other this$other = this.getOther();
            Other other$other = other.getOther();
            if (this$other == null ? other$other != null : !((Object)this$other).equals(other$other)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            ServiceNotAsDescribed this$serviceNotAsDescribed = this.getServiceNotAsDescribed();
            ServiceNotAsDescribed other$serviceNotAsDescribed = other.getServiceNotAsDescribed();
            return !(this$serviceNotAsDescribed == null ? other$serviceNotAsDescribed != null : !((Object)this$serviceNotAsDescribed).equals(other$serviceNotAsDescribed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Evidence;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Canceled $canceled = this.getCanceled();
            result = result * 59 + ($canceled == null ? 43 : ((Object)$canceled).hashCode());
            Duplicate $duplicate = this.getDuplicate();
            result = result * 59 + ($duplicate == null ? 43 : ((Object)$duplicate).hashCode());
            Fraudulent $fraudulent = this.getFraudulent();
            result = result * 59 + ($fraudulent == null ? 43 : ((Object)$fraudulent).hashCode());
            MerchandiseNotAsDescribed $merchandiseNotAsDescribed = this.getMerchandiseNotAsDescribed();
            result = result * 59 + ($merchandiseNotAsDescribed == null ? 43 : ((Object)$merchandiseNotAsDescribed).hashCode());
            NoValidAuthorization $noValidAuthorization = this.getNoValidAuthorization();
            result = result * 59 + ($noValidAuthorization == null ? 43 : ((Object)$noValidAuthorization).hashCode());
            NotReceived $notReceived = this.getNotReceived();
            result = result * 59 + ($notReceived == null ? 43 : ((Object)$notReceived).hashCode());
            Other $other = this.getOther();
            result = result * 59 + ($other == null ? 43 : ((Object)$other).hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            ServiceNotAsDescribed $serviceNotAsDescribed = this.getServiceNotAsDescribed();
            result = result * 59 + ($serviceNotAsDescribed == null ? 43 : ((Object)$serviceNotAsDescribed).hashCode());
            return result;
        }

        public static class Canceled
        extends StripeObject {
            @SerializedName(value="additional_documentation")
            ExpandableField<File> additionalDocumentation;
            @SerializedName(value="canceled_at")
            Long canceledAt;
            @SerializedName(value="cancellation_policy_provided")
            Boolean cancellationPolicyProvided;
            @SerializedName(value="cancellation_reason")
            String cancellationReason;
            @SerializedName(value="expected_at")
            Long expectedAt;
            @SerializedName(value="explanation")
            String explanation;
            @SerializedName(value="product_description")
            String productDescription;
            @SerializedName(value="product_type")
            String productType;
            @SerializedName(value="return_status")
            String returnStatus;
            @SerializedName(value="returned_at")
            Long returnedAt;

            public String getAdditionalDocumentation() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getId() : null;
            }

            public void setAdditionalDocumentation(String id) {
                this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
            }

            public File getAdditionalDocumentationObject() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getExpanded() : null;
            }

            public void setAdditionalDocumentationObject(File expandableObject) {
                this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public Long getCanceledAt() {
                return this.canceledAt;
            }

            @Generated
            public Boolean getCancellationPolicyProvided() {
                return this.cancellationPolicyProvided;
            }

            @Generated
            public String getCancellationReason() {
                return this.cancellationReason;
            }

            @Generated
            public Long getExpectedAt() {
                return this.expectedAt;
            }

            @Generated
            public String getExplanation() {
                return this.explanation;
            }

            @Generated
            public String getProductDescription() {
                return this.productDescription;
            }

            @Generated
            public String getProductType() {
                return this.productType;
            }

            @Generated
            public String getReturnStatus() {
                return this.returnStatus;
            }

            @Generated
            public Long getReturnedAt() {
                return this.returnedAt;
            }

            @Generated
            public void setCanceledAt(Long canceledAt) {
                this.canceledAt = canceledAt;
            }

            @Generated
            public void setCancellationPolicyProvided(Boolean cancellationPolicyProvided) {
                this.cancellationPolicyProvided = cancellationPolicyProvided;
            }

            @Generated
            public void setCancellationReason(String cancellationReason) {
                this.cancellationReason = cancellationReason;
            }

            @Generated
            public void setExpectedAt(Long expectedAt) {
                this.expectedAt = expectedAt;
            }

            @Generated
            public void setExplanation(String explanation) {
                this.explanation = explanation;
            }

            @Generated
            public void setProductDescription(String productDescription) {
                this.productDescription = productDescription;
            }

            @Generated
            public void setProductType(String productType) {
                this.productType = productType;
            }

            @Generated
            public void setReturnStatus(String returnStatus) {
                this.returnStatus = returnStatus;
            }

            @Generated
            public void setReturnedAt(Long returnedAt) {
                this.returnedAt = returnedAt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Canceled)) {
                    return false;
                }
                Canceled other = (Canceled)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$canceledAt = this.getCanceledAt();
                Long other$canceledAt = other.getCanceledAt();
                if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
                    return false;
                }
                Boolean this$cancellationPolicyProvided = this.getCancellationPolicyProvided();
                Boolean other$cancellationPolicyProvided = other.getCancellationPolicyProvided();
                if (this$cancellationPolicyProvided == null ? other$cancellationPolicyProvided != null : !((Object)this$cancellationPolicyProvided).equals(other$cancellationPolicyProvided)) {
                    return false;
                }
                Long this$expectedAt = this.getExpectedAt();
                Long other$expectedAt = other.getExpectedAt();
                if (this$expectedAt == null ? other$expectedAt != null : !((Object)this$expectedAt).equals(other$expectedAt)) {
                    return false;
                }
                Long this$returnedAt = this.getReturnedAt();
                Long other$returnedAt = other.getReturnedAt();
                if (this$returnedAt == null ? other$returnedAt != null : !((Object)this$returnedAt).equals(other$returnedAt)) {
                    return false;
                }
                String this$additionalDocumentation = this.getAdditionalDocumentation();
                String other$additionalDocumentation = other.getAdditionalDocumentation();
                if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) {
                    return false;
                }
                String this$cancellationReason = this.getCancellationReason();
                String other$cancellationReason = other.getCancellationReason();
                if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
                    return false;
                }
                String this$explanation = this.getExplanation();
                String other$explanation = other.getExplanation();
                if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) {
                    return false;
                }
                String this$productDescription = this.getProductDescription();
                String other$productDescription = other.getProductDescription();
                if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                    return false;
                }
                String this$productType = this.getProductType();
                String other$productType = other.getProductType();
                if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) {
                    return false;
                }
                String this$returnStatus = this.getReturnStatus();
                String other$returnStatus = other.getReturnStatus();
                return !(this$returnStatus == null ? other$returnStatus != null : !this$returnStatus.equals(other$returnStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Canceled;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $canceledAt = this.getCanceledAt();
                result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
                Boolean $cancellationPolicyProvided = this.getCancellationPolicyProvided();
                result = result * 59 + ($cancellationPolicyProvided == null ? 43 : ((Object)$cancellationPolicyProvided).hashCode());
                Long $expectedAt = this.getExpectedAt();
                result = result * 59 + ($expectedAt == null ? 43 : ((Object)$expectedAt).hashCode());
                Long $returnedAt = this.getReturnedAt();
                result = result * 59 + ($returnedAt == null ? 43 : ((Object)$returnedAt).hashCode());
                String $additionalDocumentation = this.getAdditionalDocumentation();
                result = result * 59 + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
                String $cancellationReason = this.getCancellationReason();
                result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
                String $explanation = this.getExplanation();
                result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
                String $productDescription = this.getProductDescription();
                result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
                String $productType = this.getProductType();
                result = result * 59 + ($productType == null ? 43 : $productType.hashCode());
                String $returnStatus = this.getReturnStatus();
                result = result * 59 + ($returnStatus == null ? 43 : $returnStatus.hashCode());
                return result;
            }
        }

        public static class Duplicate
        extends StripeObject {
            @SerializedName(value="additional_documentation")
            ExpandableField<File> additionalDocumentation;
            @SerializedName(value="card_statement")
            ExpandableField<File> cardStatement;
            @SerializedName(value="cash_receipt")
            ExpandableField<File> cashReceipt;
            @SerializedName(value="check_image")
            ExpandableField<File> checkImage;
            @SerializedName(value="explanation")
            String explanation;
            @SerializedName(value="original_transaction")
            String originalTransaction;

            public String getAdditionalDocumentation() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getId() : null;
            }

            public void setAdditionalDocumentation(String id) {
                this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
            }

            public File getAdditionalDocumentationObject() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getExpanded() : null;
            }

            public void setAdditionalDocumentationObject(File expandableObject) {
                this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            public String getCardStatement() {
                return this.cardStatement != null ? this.cardStatement.getId() : null;
            }

            public void setCardStatement(String id) {
                this.cardStatement = ApiResource.setExpandableFieldId(id, this.cardStatement);
            }

            public File getCardStatementObject() {
                return this.cardStatement != null ? this.cardStatement.getExpanded() : null;
            }

            public void setCardStatementObject(File expandableObject) {
                this.cardStatement = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            public String getCashReceipt() {
                return this.cashReceipt != null ? this.cashReceipt.getId() : null;
            }

            public void setCashReceipt(String id) {
                this.cashReceipt = ApiResource.setExpandableFieldId(id, this.cashReceipt);
            }

            public File getCashReceiptObject() {
                return this.cashReceipt != null ? this.cashReceipt.getExpanded() : null;
            }

            public void setCashReceiptObject(File expandableObject) {
                this.cashReceipt = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            public String getCheckImage() {
                return this.checkImage != null ? this.checkImage.getId() : null;
            }

            public void setCheckImage(String id) {
                this.checkImage = ApiResource.setExpandableFieldId(id, this.checkImage);
            }

            public File getCheckImageObject() {
                return this.checkImage != null ? this.checkImage.getExpanded() : null;
            }

            public void setCheckImageObject(File expandableObject) {
                this.checkImage = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getExplanation() {
                return this.explanation;
            }

            @Generated
            public String getOriginalTransaction() {
                return this.originalTransaction;
            }

            @Generated
            public void setExplanation(String explanation) {
                this.explanation = explanation;
            }

            @Generated
            public void setOriginalTransaction(String originalTransaction) {
                this.originalTransaction = originalTransaction;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Duplicate)) {
                    return false;
                }
                Duplicate other = (Duplicate)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$additionalDocumentation = this.getAdditionalDocumentation();
                String other$additionalDocumentation = other.getAdditionalDocumentation();
                if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) {
                    return false;
                }
                String this$cardStatement = this.getCardStatement();
                String other$cardStatement = other.getCardStatement();
                if (this$cardStatement == null ? other$cardStatement != null : !this$cardStatement.equals(other$cardStatement)) {
                    return false;
                }
                String this$cashReceipt = this.getCashReceipt();
                String other$cashReceipt = other.getCashReceipt();
                if (this$cashReceipt == null ? other$cashReceipt != null : !this$cashReceipt.equals(other$cashReceipt)) {
                    return false;
                }
                String this$checkImage = this.getCheckImage();
                String other$checkImage = other.getCheckImage();
                if (this$checkImage == null ? other$checkImage != null : !this$checkImage.equals(other$checkImage)) {
                    return false;
                }
                String this$explanation = this.getExplanation();
                String other$explanation = other.getExplanation();
                if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) {
                    return false;
                }
                String this$originalTransaction = this.getOriginalTransaction();
                String other$originalTransaction = other.getOriginalTransaction();
                return !(this$originalTransaction == null ? other$originalTransaction != null : !this$originalTransaction.equals(other$originalTransaction));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Duplicate;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $additionalDocumentation = this.getAdditionalDocumentation();
                result = result * 59 + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
                String $cardStatement = this.getCardStatement();
                result = result * 59 + ($cardStatement == null ? 43 : $cardStatement.hashCode());
                String $cashReceipt = this.getCashReceipt();
                result = result * 59 + ($cashReceipt == null ? 43 : $cashReceipt.hashCode());
                String $checkImage = this.getCheckImage();
                result = result * 59 + ($checkImage == null ? 43 : $checkImage.hashCode());
                String $explanation = this.getExplanation();
                result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
                String $originalTransaction = this.getOriginalTransaction();
                result = result * 59 + ($originalTransaction == null ? 43 : $originalTransaction.hashCode());
                return result;
            }
        }

        public static class Fraudulent
        extends StripeObject {
            @SerializedName(value="additional_documentation")
            ExpandableField<File> additionalDocumentation;
            @SerializedName(value="explanation")
            String explanation;

            public String getAdditionalDocumentation() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getId() : null;
            }

            public void setAdditionalDocumentation(String id) {
                this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
            }

            public File getAdditionalDocumentationObject() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getExpanded() : null;
            }

            public void setAdditionalDocumentationObject(File expandableObject) {
                this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getExplanation() {
                return this.explanation;
            }

            @Generated
            public void setExplanation(String explanation) {
                this.explanation = explanation;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fraudulent)) {
                    return false;
                }
                Fraudulent other = (Fraudulent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$additionalDocumentation = this.getAdditionalDocumentation();
                String other$additionalDocumentation = other.getAdditionalDocumentation();
                if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) {
                    return false;
                }
                String this$explanation = this.getExplanation();
                String other$explanation = other.getExplanation();
                return !(this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fraudulent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $additionalDocumentation = this.getAdditionalDocumentation();
                result = result * 59 + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
                String $explanation = this.getExplanation();
                result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
                return result;
            }
        }

        public static class MerchandiseNotAsDescribed
        extends StripeObject {
            @SerializedName(value="additional_documentation")
            ExpandableField<File> additionalDocumentation;
            @SerializedName(value="explanation")
            String explanation;
            @SerializedName(value="received_at")
            Long receivedAt;
            @SerializedName(value="return_description")
            String returnDescription;
            @SerializedName(value="return_status")
            String returnStatus;
            @SerializedName(value="returned_at")
            Long returnedAt;

            public String getAdditionalDocumentation() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getId() : null;
            }

            public void setAdditionalDocumentation(String id) {
                this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
            }

            public File getAdditionalDocumentationObject() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getExpanded() : null;
            }

            public void setAdditionalDocumentationObject(File expandableObject) {
                this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getExplanation() {
                return this.explanation;
            }

            @Generated
            public Long getReceivedAt() {
                return this.receivedAt;
            }

            @Generated
            public String getReturnDescription() {
                return this.returnDescription;
            }

            @Generated
            public String getReturnStatus() {
                return this.returnStatus;
            }

            @Generated
            public Long getReturnedAt() {
                return this.returnedAt;
            }

            @Generated
            public void setExplanation(String explanation) {
                this.explanation = explanation;
            }

            @Generated
            public void setReceivedAt(Long receivedAt) {
                this.receivedAt = receivedAt;
            }

            @Generated
            public void setReturnDescription(String returnDescription) {
                this.returnDescription = returnDescription;
            }

            @Generated
            public void setReturnStatus(String returnStatus) {
                this.returnStatus = returnStatus;
            }

            @Generated
            public void setReturnedAt(Long returnedAt) {
                this.returnedAt = returnedAt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MerchandiseNotAsDescribed)) {
                    return false;
                }
                MerchandiseNotAsDescribed other = (MerchandiseNotAsDescribed)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$receivedAt = this.getReceivedAt();
                Long other$receivedAt = other.getReceivedAt();
                if (this$receivedAt == null ? other$receivedAt != null : !((Object)this$receivedAt).equals(other$receivedAt)) {
                    return false;
                }
                Long this$returnedAt = this.getReturnedAt();
                Long other$returnedAt = other.getReturnedAt();
                if (this$returnedAt == null ? other$returnedAt != null : !((Object)this$returnedAt).equals(other$returnedAt)) {
                    return false;
                }
                String this$additionalDocumentation = this.getAdditionalDocumentation();
                String other$additionalDocumentation = other.getAdditionalDocumentation();
                if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) {
                    return false;
                }
                String this$explanation = this.getExplanation();
                String other$explanation = other.getExplanation();
                if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) {
                    return false;
                }
                String this$returnDescription = this.getReturnDescription();
                String other$returnDescription = other.getReturnDescription();
                if (this$returnDescription == null ? other$returnDescription != null : !this$returnDescription.equals(other$returnDescription)) {
                    return false;
                }
                String this$returnStatus = this.getReturnStatus();
                String other$returnStatus = other.getReturnStatus();
                return !(this$returnStatus == null ? other$returnStatus != null : !this$returnStatus.equals(other$returnStatus));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof MerchandiseNotAsDescribed;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $receivedAt = this.getReceivedAt();
                result = result * 59 + ($receivedAt == null ? 43 : ((Object)$receivedAt).hashCode());
                Long $returnedAt = this.getReturnedAt();
                result = result * 59 + ($returnedAt == null ? 43 : ((Object)$returnedAt).hashCode());
                String $additionalDocumentation = this.getAdditionalDocumentation();
                result = result * 59 + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
                String $explanation = this.getExplanation();
                result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
                String $returnDescription = this.getReturnDescription();
                result = result * 59 + ($returnDescription == null ? 43 : $returnDescription.hashCode());
                String $returnStatus = this.getReturnStatus();
                result = result * 59 + ($returnStatus == null ? 43 : $returnStatus.hashCode());
                return result;
            }
        }

        public static class NoValidAuthorization
        extends StripeObject {
            @SerializedName(value="additional_documentation")
            ExpandableField<File> additionalDocumentation;
            @SerializedName(value="explanation")
            String explanation;

            public String getAdditionalDocumentation() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getId() : null;
            }

            public void setAdditionalDocumentation(String id) {
                this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
            }

            public File getAdditionalDocumentationObject() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getExpanded() : null;
            }

            public void setAdditionalDocumentationObject(File expandableObject) {
                this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getExplanation() {
                return this.explanation;
            }

            @Generated
            public void setExplanation(String explanation) {
                this.explanation = explanation;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NoValidAuthorization)) {
                    return false;
                }
                NoValidAuthorization other = (NoValidAuthorization)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$additionalDocumentation = this.getAdditionalDocumentation();
                String other$additionalDocumentation = other.getAdditionalDocumentation();
                if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) {
                    return false;
                }
                String this$explanation = this.getExplanation();
                String other$explanation = other.getExplanation();
                return !(this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NoValidAuthorization;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $additionalDocumentation = this.getAdditionalDocumentation();
                result = result * 59 + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
                String $explanation = this.getExplanation();
                result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
                return result;
            }
        }

        public static class NotReceived
        extends StripeObject {
            @SerializedName(value="additional_documentation")
            ExpandableField<File> additionalDocumentation;
            @SerializedName(value="expected_at")
            Long expectedAt;
            @SerializedName(value="explanation")
            String explanation;
            @SerializedName(value="product_description")
            String productDescription;
            @SerializedName(value="product_type")
            String productType;

            public String getAdditionalDocumentation() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getId() : null;
            }

            public void setAdditionalDocumentation(String id) {
                this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
            }

            public File getAdditionalDocumentationObject() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getExpanded() : null;
            }

            public void setAdditionalDocumentationObject(File expandableObject) {
                this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public Long getExpectedAt() {
                return this.expectedAt;
            }

            @Generated
            public String getExplanation() {
                return this.explanation;
            }

            @Generated
            public String getProductDescription() {
                return this.productDescription;
            }

            @Generated
            public String getProductType() {
                return this.productType;
            }

            @Generated
            public void setExpectedAt(Long expectedAt) {
                this.expectedAt = expectedAt;
            }

            @Generated
            public void setExplanation(String explanation) {
                this.explanation = explanation;
            }

            @Generated
            public void setProductDescription(String productDescription) {
                this.productDescription = productDescription;
            }

            @Generated
            public void setProductType(String productType) {
                this.productType = productType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NotReceived)) {
                    return false;
                }
                NotReceived other = (NotReceived)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expectedAt = this.getExpectedAt();
                Long other$expectedAt = other.getExpectedAt();
                if (this$expectedAt == null ? other$expectedAt != null : !((Object)this$expectedAt).equals(other$expectedAt)) {
                    return false;
                }
                String this$additionalDocumentation = this.getAdditionalDocumentation();
                String other$additionalDocumentation = other.getAdditionalDocumentation();
                if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) {
                    return false;
                }
                String this$explanation = this.getExplanation();
                String other$explanation = other.getExplanation();
                if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) {
                    return false;
                }
                String this$productDescription = this.getProductDescription();
                String other$productDescription = other.getProductDescription();
                if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                    return false;
                }
                String this$productType = this.getProductType();
                String other$productType = other.getProductType();
                return !(this$productType == null ? other$productType != null : !this$productType.equals(other$productType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NotReceived;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expectedAt = this.getExpectedAt();
                result = result * 59 + ($expectedAt == null ? 43 : ((Object)$expectedAt).hashCode());
                String $additionalDocumentation = this.getAdditionalDocumentation();
                result = result * 59 + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
                String $explanation = this.getExplanation();
                result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
                String $productDescription = this.getProductDescription();
                result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
                String $productType = this.getProductType();
                result = result * 59 + ($productType == null ? 43 : $productType.hashCode());
                return result;
            }
        }

        public static class Other
        extends StripeObject {
            @SerializedName(value="additional_documentation")
            ExpandableField<File> additionalDocumentation;
            @SerializedName(value="explanation")
            String explanation;
            @SerializedName(value="product_description")
            String productDescription;
            @SerializedName(value="product_type")
            String productType;

            public String getAdditionalDocumentation() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getId() : null;
            }

            public void setAdditionalDocumentation(String id) {
                this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
            }

            public File getAdditionalDocumentationObject() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getExpanded() : null;
            }

            public void setAdditionalDocumentationObject(File expandableObject) {
                this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getExplanation() {
                return this.explanation;
            }

            @Generated
            public String getProductDescription() {
                return this.productDescription;
            }

            @Generated
            public String getProductType() {
                return this.productType;
            }

            @Generated
            public void setExplanation(String explanation) {
                this.explanation = explanation;
            }

            @Generated
            public void setProductDescription(String productDescription) {
                this.productDescription = productDescription;
            }

            @Generated
            public void setProductType(String productType) {
                this.productType = productType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Other)) {
                    return false;
                }
                Other other = (Other)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$additionalDocumentation = this.getAdditionalDocumentation();
                String other$additionalDocumentation = other.getAdditionalDocumentation();
                if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) {
                    return false;
                }
                String this$explanation = this.getExplanation();
                String other$explanation = other.getExplanation();
                if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) {
                    return false;
                }
                String this$productDescription = this.getProductDescription();
                String other$productDescription = other.getProductDescription();
                if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                    return false;
                }
                String this$productType = this.getProductType();
                String other$productType = other.getProductType();
                return !(this$productType == null ? other$productType != null : !this$productType.equals(other$productType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Other;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $additionalDocumentation = this.getAdditionalDocumentation();
                result = result * 59 + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
                String $explanation = this.getExplanation();
                result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
                String $productDescription = this.getProductDescription();
                result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
                String $productType = this.getProductType();
                result = result * 59 + ($productType == null ? 43 : $productType.hashCode());
                return result;
            }
        }

        public static class ServiceNotAsDescribed
        extends StripeObject {
            @SerializedName(value="additional_documentation")
            ExpandableField<File> additionalDocumentation;
            @SerializedName(value="canceled_at")
            Long canceledAt;
            @SerializedName(value="cancellation_reason")
            String cancellationReason;
            @SerializedName(value="explanation")
            String explanation;
            @SerializedName(value="received_at")
            Long receivedAt;

            public String getAdditionalDocumentation() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getId() : null;
            }

            public void setAdditionalDocumentation(String id) {
                this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
            }

            public File getAdditionalDocumentationObject() {
                return this.additionalDocumentation != null ? this.additionalDocumentation.getExpanded() : null;
            }

            public void setAdditionalDocumentationObject(File expandableObject) {
                this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public Long getCanceledAt() {
                return this.canceledAt;
            }

            @Generated
            public String getCancellationReason() {
                return this.cancellationReason;
            }

            @Generated
            public String getExplanation() {
                return this.explanation;
            }

            @Generated
            public Long getReceivedAt() {
                return this.receivedAt;
            }

            @Generated
            public void setCanceledAt(Long canceledAt) {
                this.canceledAt = canceledAt;
            }

            @Generated
            public void setCancellationReason(String cancellationReason) {
                this.cancellationReason = cancellationReason;
            }

            @Generated
            public void setExplanation(String explanation) {
                this.explanation = explanation;
            }

            @Generated
            public void setReceivedAt(Long receivedAt) {
                this.receivedAt = receivedAt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceNotAsDescribed)) {
                    return false;
                }
                ServiceNotAsDescribed other = (ServiceNotAsDescribed)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$canceledAt = this.getCanceledAt();
                Long other$canceledAt = other.getCanceledAt();
                if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
                    return false;
                }
                Long this$receivedAt = this.getReceivedAt();
                Long other$receivedAt = other.getReceivedAt();
                if (this$receivedAt == null ? other$receivedAt != null : !((Object)this$receivedAt).equals(other$receivedAt)) {
                    return false;
                }
                String this$additionalDocumentation = this.getAdditionalDocumentation();
                String other$additionalDocumentation = other.getAdditionalDocumentation();
                if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) {
                    return false;
                }
                String this$cancellationReason = this.getCancellationReason();
                String other$cancellationReason = other.getCancellationReason();
                if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
                    return false;
                }
                String this$explanation = this.getExplanation();
                String other$explanation = other.getExplanation();
                return !(this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ServiceNotAsDescribed;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $canceledAt = this.getCanceledAt();
                result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
                Long $receivedAt = this.getReceivedAt();
                result = result * 59 + ($receivedAt == null ? 43 : ((Object)$receivedAt).hashCode());
                String $additionalDocumentation = this.getAdditionalDocumentation();
                result = result * 59 + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
                String $cancellationReason = this.getCancellationReason();
                result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
                String $explanation = this.getExplanation();
                result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
                return result;
            }
        }
    }

    public static class Treasury
    extends StripeObject {
        @SerializedName(value="debit_reversal")
        String debitReversal;
        @SerializedName(value="received_debit")
        String receivedDebit;

        @Generated
        public String getDebitReversal() {
            return this.debitReversal;
        }

        @Generated
        public String getReceivedDebit() {
            return this.receivedDebit;
        }

        @Generated
        public void setDebitReversal(String debitReversal) {
            this.debitReversal = debitReversal;
        }

        @Generated
        public void setReceivedDebit(String receivedDebit) {
            this.receivedDebit = receivedDebit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Treasury)) {
                return false;
            }
            Treasury other = (Treasury)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$debitReversal = this.getDebitReversal();
            String other$debitReversal = other.getDebitReversal();
            if (this$debitReversal == null ? other$debitReversal != null : !this$debitReversal.equals(other$debitReversal)) {
                return false;
            }
            String this$receivedDebit = this.getReceivedDebit();
            String other$receivedDebit = other.getReceivedDebit();
            return !(this$receivedDebit == null ? other$receivedDebit != null : !this$receivedDebit.equals(other$receivedDebit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Treasury;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $debitReversal = this.getDebitReversal();
            result = result * 59 + ($debitReversal == null ? 43 : $debitReversal.hashCode());
            String $receivedDebit = this.getReceivedDebit();
            result = result * 59 + ($receivedDebit == null ? 43 : $receivedDebit.hashCode());
            return result;
        }
    }
}

