/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.billing.Alert;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.AlertActivateParams;
import com.stripe.param.billing.AlertArchiveParams;
import com.stripe.param.billing.AlertCreateParams;
import com.stripe.param.billing.AlertDeactivateParams;
import com.stripe.param.billing.AlertListParams;
import com.stripe.param.billing.AlertRetrieveParams;
import java.lang.reflect.Type;

public final class AlertService
extends ApiService {
    public AlertService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Alert> list(AlertListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Alert> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Alert> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Alert> list(AlertListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Alert>>(){}.getType());
    }

    public Alert create(AlertCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Alert create(AlertCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)this.request(request, (Type)((Object)Alert.class));
    }

    public Alert retrieve(String id, AlertRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Alert retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Alert retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Alert retrieve(String id, AlertRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)this.request(request, (Type)((Object)Alert.class));
    }

    public Alert activate(String id, AlertActivateParams params) throws StripeException {
        return this.activate(id, params, null);
    }

    public Alert activate(String id, RequestOptions options) throws StripeException {
        return this.activate(id, null, options);
    }

    public Alert activate(String id) throws StripeException {
        return this.activate(id, null, null);
    }

    public Alert activate(String id, AlertActivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/activate", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)this.request(request, (Type)((Object)Alert.class));
    }

    public Alert archive(String id, AlertArchiveParams params) throws StripeException {
        return this.archive(id, params, null);
    }

    public Alert archive(String id, RequestOptions options) throws StripeException {
        return this.archive(id, null, options);
    }

    public Alert archive(String id) throws StripeException {
        return this.archive(id, null, null);
    }

    public Alert archive(String id, AlertArchiveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/archive", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)this.request(request, (Type)((Object)Alert.class));
    }

    public Alert deactivate(String id, AlertDeactivateParams params) throws StripeException {
        return this.deactivate(id, params, null);
    }

    public Alert deactivate(String id, RequestOptions options) throws StripeException {
        return this.deactivate(id, null, options);
    }

    public Alert deactivate(String id) throws StripeException {
        return this.deactivate(id, null, null);
    }

    public Alert deactivate(String id, AlertDeactivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/deactivate", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Alert)this.request(request, (Type)((Object)Alert.class));
    }
}

