/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.ExchangeRate;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ExchangeRateListParams;
import com.stripe.param.ExchangeRateRetrieveParams;
import java.lang.reflect.Type;

public final class ExchangeRateService
extends ApiService {
    public ExchangeRateService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<ExchangeRate> list(ExchangeRateListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<ExchangeRate> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<ExchangeRate> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<ExchangeRate> list(ExchangeRateListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/exchange_rates";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<ExchangeRate>>(){}.getType());
    }

    public ExchangeRate retrieve(String rateId, ExchangeRateRetrieveParams params) throws StripeException {
        return this.retrieve(rateId, params, null);
    }

    public ExchangeRate retrieve(String rateId, RequestOptions options) throws StripeException {
        return this.retrieve(rateId, null, options);
    }

    public ExchangeRate retrieve(String rateId) throws StripeException {
        return this.retrieve(rateId, null, null);
    }

    public ExchangeRate retrieve(String rateId, ExchangeRateRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/exchange_rates/%s", ApiResource.urlEncodeId(rateId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (ExchangeRate)this.request(request, (Type)((Object)ExchangeRate.class));
    }
}

