/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Quote;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.QuoteAcceptParams;
import com.stripe.param.QuoteCancelParams;
import com.stripe.param.QuoteCreateParams;
import com.stripe.param.QuoteFinalizeQuoteParams;
import com.stripe.param.QuoteListParams;
import com.stripe.param.QuotePdfParams;
import com.stripe.param.QuoteRetrieveParams;
import com.stripe.param.QuoteUpdateParams;
import com.stripe.service.QuoteComputedUpfrontLineItemsService;
import com.stripe.service.QuoteLineItemService;
import java.io.InputStream;
import java.lang.reflect.Type;

public final class QuoteService
extends ApiService {
    public QuoteService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Quote> list(QuoteListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Quote> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Quote> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Quote> list(QuoteListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/quotes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Quote>>(){}.getType());
    }

    public Quote create(QuoteCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Quote create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Quote create() throws StripeException {
        return this.create(null, null);
    }

    public Quote create(QuoteCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/quotes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Quote)this.request(request, (Type)((Object)Quote.class));
    }

    public Quote retrieve(String quote, QuoteRetrieveParams params) throws StripeException {
        return this.retrieve(quote, params, null);
    }

    public Quote retrieve(String quote, RequestOptions options) throws StripeException {
        return this.retrieve(quote, null, options);
    }

    public Quote retrieve(String quote) throws StripeException {
        return this.retrieve(quote, null, null);
    }

    public Quote retrieve(String quote, QuoteRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s", ApiResource.urlEncodeId(quote));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Quote)this.request(request, (Type)((Object)Quote.class));
    }

    public Quote update(String quote, QuoteUpdateParams params) throws StripeException {
        return this.update(quote, params, null);
    }

    public Quote update(String quote, RequestOptions options) throws StripeException {
        return this.update(quote, null, options);
    }

    public Quote update(String quote) throws StripeException {
        return this.update(quote, null, null);
    }

    public Quote update(String quote, QuoteUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s", ApiResource.urlEncodeId(quote));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Quote)this.request(request, (Type)((Object)Quote.class));
    }

    public Quote accept(String quote, QuoteAcceptParams params) throws StripeException {
        return this.accept(quote, params, null);
    }

    public Quote accept(String quote, RequestOptions options) throws StripeException {
        return this.accept(quote, null, options);
    }

    public Quote accept(String quote) throws StripeException {
        return this.accept(quote, null, null);
    }

    public Quote accept(String quote, QuoteAcceptParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/accept", ApiResource.urlEncodeId(quote));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Quote)this.request(request, (Type)((Object)Quote.class));
    }

    public Quote cancel(String quote, QuoteCancelParams params) throws StripeException {
        return this.cancel(quote, params, null);
    }

    public Quote cancel(String quote, RequestOptions options) throws StripeException {
        return this.cancel(quote, null, options);
    }

    public Quote cancel(String quote) throws StripeException {
        return this.cancel(quote, null, null);
    }

    public Quote cancel(String quote, QuoteCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/cancel", ApiResource.urlEncodeId(quote));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Quote)this.request(request, (Type)((Object)Quote.class));
    }

    public Quote finalizeQuote(String quote, QuoteFinalizeQuoteParams params) throws StripeException {
        return this.finalizeQuote(quote, params, null);
    }

    public Quote finalizeQuote(String quote, RequestOptions options) throws StripeException {
        return this.finalizeQuote(quote, null, options);
    }

    public Quote finalizeQuote(String quote) throws StripeException {
        return this.finalizeQuote(quote, null, null);
    }

    public Quote finalizeQuote(String quote, QuoteFinalizeQuoteParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/finalize", ApiResource.urlEncodeId(quote));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Quote)this.request(request, (Type)((Object)Quote.class));
    }

    public InputStream pdf(String quote, QuotePdfParams params) throws StripeException {
        return this.pdf(quote, params, null);
    }

    public InputStream pdf(String quote, RequestOptions options) throws StripeException {
        return this.pdf(quote, null, options);
    }

    public InputStream pdf(String quote) throws StripeException {
        return this.pdf(quote, null, null);
    }

    public InputStream pdf(String quote, QuotePdfParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/pdf", ApiResource.urlEncodeId(quote));
        ApiRequest request = new ApiRequest(BaseAddress.FILES, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return this.requestStream(request);
    }

    public QuoteComputedUpfrontLineItemsService computedUpfrontLineItems() {
        return new QuoteComputedUpfrontLineItemsService(this.getResponseGetter());
    }

    public QuoteLineItemService lineItems() {
        return new QuoteLineItemService(this.getResponseGetter());
    }
}

