/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.exception;

import com.google.gson.JsonObject;
import com.stripe.exception.TemporarySessionExpiredException;
import com.stripe.model.StripeError;
import com.stripe.net.StripeResponseGetter;
import lombok.Generated;

public abstract class StripeException
extends Exception {
    private static final long serialVersionUID = 2L;
    transient StripeError stripeError;
    private String code;
    private String requestId;
    private Integer statusCode;

    public void setStripeError(StripeError err) {
        this.stripeError = err;
    }

    protected StripeException(String message, String requestId, String code, Integer statusCode) {
        this(message, requestId, code, statusCode, null);
    }

    protected StripeException(String message, String requestId, String code, Integer statusCode, Throwable e) {
        super(message, e);
        this.code = code;
        this.requestId = requestId;
        this.statusCode = statusCode;
    }

    @Override
    public String getMessage() {
        String additionalInfo = "";
        if (this.code != null) {
            additionalInfo = additionalInfo + "; code: " + this.code;
        }
        if (this.requestId != null) {
            additionalInfo = additionalInfo + "; request-id: " + this.requestId;
        }
        if (this.getUserMessage() != null) {
            additionalInfo = additionalInfo + "; user-message: " + this.getUserMessage();
        }
        return super.getMessage() + additionalInfo;
    }

    public String getUserMessage() {
        if (this.getStripeError() != null) {
            return this.getStripeError().getUserMessage();
        }
        return null;
    }

    public static StripeException parseV2Exception(String type, JsonObject body, int statusCode, String requestId, StripeResponseGetter responseGetter) {
        switch (type) {
            case "temporary_session_expired": {
                return TemporarySessionExpiredException.parse(body, statusCode, requestId, responseGetter);
            }
        }
        return null;
    }

    @Generated
    public StripeError getStripeError() {
        return this.stripeError;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public Integer getStatusCode() {
        return this.statusCode;
    }
}

