/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.financialconnections;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.financialconnections.InstitutionCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.financialconnections.InstitutionListParams;
import com.stripe.param.financialconnections.InstitutionRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Institution
extends ApiResource
implements HasId {
    @SerializedName(value="features")
    Features features;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="routing_numbers")
    List<String> routingNumbers;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="url")
    String url;

    public static InstitutionCollection list(Map<String, Object> params) throws StripeException {
        return Institution.list(params, (RequestOptions)null);
    }

    public static InstitutionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/financial_connections/institutions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (InstitutionCollection)Institution.getGlobalResponseGetter().request(request, (Type)((Object)InstitutionCollection.class));
    }

    public static InstitutionCollection list(InstitutionListParams params) throws StripeException {
        return Institution.list(params, (RequestOptions)null);
    }

    public static InstitutionCollection list(InstitutionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/financial_connections/institutions";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (InstitutionCollection)Institution.getGlobalResponseGetter().request(request, (Type)((Object)InstitutionCollection.class));
    }

    public static Institution retrieve(String institution) throws StripeException {
        return Institution.retrieve(institution, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Institution retrieve(String institution, RequestOptions options) throws StripeException {
        return Institution.retrieve(institution, (Map<String, Object>)null, options);
    }

    public static Institution retrieve(String institution, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/institutions/%s", ApiResource.urlEncodeId(institution));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Institution)Institution.getGlobalResponseGetter().request(request, (Type)((Object)Institution.class));
    }

    public static Institution retrieve(String institution, InstitutionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/institutions/%s", ApiResource.urlEncodeId(institution));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Institution)Institution.getGlobalResponseGetter().request(request, (Type)((Object)Institution.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.features, responseGetter);
    }

    @Generated
    public Features getFeatures() {
        return this.features;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<String> getRoutingNumbers() {
        return this.routingNumbers;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setFeatures(Features features) {
        this.features = features;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setRoutingNumbers(List<String> routingNumbers) {
        this.routingNumbers = routingNumbers;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Institution)) {
            return false;
        }
        Institution other = (Institution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Features this$features = this.getFeatures();
        Features other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<String> this$routingNumbers = this.getRoutingNumbers();
        List<String> other$routingNumbers = other.getRoutingNumbers();
        if (this$routingNumbers == null ? other$routingNumbers != null : !((Object)this$routingNumbers).equals(other$routingNumbers)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Institution;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Features $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<String> $routingNumbers = this.getRoutingNumbers();
        result = result * 59 + ($routingNumbers == null ? 43 : ((Object)$routingNumbers).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Features
    extends StripeObject {
        @SerializedName(value="balances")
        Balances balances;
        @SerializedName(value="ownership")
        Ownership ownership;
        @SerializedName(value="payment_method")
        PaymentMethod paymentMethod;
        @SerializedName(value="transactions")
        Transactions transactions;

        @Generated
        public Balances getBalances() {
            return this.balances;
        }

        @Generated
        public Ownership getOwnership() {
            return this.ownership;
        }

        @Generated
        public PaymentMethod getPaymentMethod() {
            return this.paymentMethod;
        }

        @Generated
        public Transactions getTransactions() {
            return this.transactions;
        }

        @Generated
        public void setBalances(Balances balances) {
            this.balances = balances;
        }

        @Generated
        public void setOwnership(Ownership ownership) {
            this.ownership = ownership;
        }

        @Generated
        public void setPaymentMethod(PaymentMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
        }

        @Generated
        public void setTransactions(Transactions transactions) {
            this.transactions = transactions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Features)) {
                return false;
            }
            Features other = (Features)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Balances this$balances = this.getBalances();
            Balances other$balances = other.getBalances();
            if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
                return false;
            }
            Ownership this$ownership = this.getOwnership();
            Ownership other$ownership = other.getOwnership();
            if (this$ownership == null ? other$ownership != null : !((Object)this$ownership).equals(other$ownership)) {
                return false;
            }
            PaymentMethod this$paymentMethod = this.getPaymentMethod();
            PaymentMethod other$paymentMethod = other.getPaymentMethod();
            if (this$paymentMethod == null ? other$paymentMethod != null : !((Object)this$paymentMethod).equals(other$paymentMethod)) {
                return false;
            }
            Transactions this$transactions = this.getTransactions();
            Transactions other$transactions = other.getTransactions();
            return !(this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Features;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Balances $balances = this.getBalances();
            result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
            Ownership $ownership = this.getOwnership();
            result = result * 59 + ($ownership == null ? 43 : ((Object)$ownership).hashCode());
            PaymentMethod $paymentMethod = this.getPaymentMethod();
            result = result * 59 + ($paymentMethod == null ? 43 : ((Object)$paymentMethod).hashCode());
            Transactions $transactions = this.getTransactions();
            result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
            return result;
        }

        public static class Balances
        extends StripeObject {
            @SerializedName(value="supported")
            Boolean supported;

            @Generated
            public Boolean getSupported() {
                return this.supported;
            }

            @Generated
            public void setSupported(Boolean supported) {
                this.supported = supported;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Balances)) {
                    return false;
                }
                Balances other = (Balances)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$supported = this.getSupported();
                Boolean other$supported = other.getSupported();
                return !(this$supported == null ? other$supported != null : !((Object)this$supported).equals(other$supported));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Balances;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $supported = this.getSupported();
                result = result * 59 + ($supported == null ? 43 : ((Object)$supported).hashCode());
                return result;
            }
        }

        public static class Ownership
        extends StripeObject {
            @SerializedName(value="supported")
            Boolean supported;

            @Generated
            public Boolean getSupported() {
                return this.supported;
            }

            @Generated
            public void setSupported(Boolean supported) {
                this.supported = supported;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ownership)) {
                    return false;
                }
                Ownership other = (Ownership)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$supported = this.getSupported();
                Boolean other$supported = other.getSupported();
                return !(this$supported == null ? other$supported != null : !((Object)this$supported).equals(other$supported));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ownership;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $supported = this.getSupported();
                result = result * 59 + ($supported == null ? 43 : ((Object)$supported).hashCode());
                return result;
            }
        }

        public static class PaymentMethod
        extends StripeObject {
            @SerializedName(value="supported")
            Boolean supported;

            @Generated
            public Boolean getSupported() {
                return this.supported;
            }

            @Generated
            public void setSupported(Boolean supported) {
                this.supported = supported;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaymentMethod)) {
                    return false;
                }
                PaymentMethod other = (PaymentMethod)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$supported = this.getSupported();
                Boolean other$supported = other.getSupported();
                return !(this$supported == null ? other$supported != null : !((Object)this$supported).equals(other$supported));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaymentMethod;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $supported = this.getSupported();
                result = result * 59 + ($supported == null ? 43 : ((Object)$supported).hashCode());
                return result;
            }
        }

        public static class Transactions
        extends StripeObject {
            @SerializedName(value="supported")
            Boolean supported;

            @Generated
            public Boolean getSupported() {
                return this.supported;
            }

            @Generated
            public void setSupported(Boolean supported) {
                this.supported = supported;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Transactions)) {
                    return false;
                }
                Transactions other = (Transactions)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$supported = this.getSupported();
                Boolean other$supported = other.getSupported();
                return !(this$supported == null ? other$supported != null : !((Object)this$supported).equals(other$supported));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Transactions;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $supported = this.getSupported();
                result = result * 59 + ($supported == null ? 43 : ((Object)$supported).hashCode());
                return result;
            }
        }
    }
}

