/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.SubscriptionItem;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.SubscriptionItemCreateParams;
import com.stripe.param.SubscriptionItemDeleteParams;
import com.stripe.param.SubscriptionItemListParams;
import com.stripe.param.SubscriptionItemRetrieveParams;
import com.stripe.param.SubscriptionItemUpdateParams;
import com.stripe.service.SubscriptionItemUsageRecordService;
import com.stripe.service.SubscriptionItemUsageRecordSummaryService;
import java.lang.reflect.Type;

public final class SubscriptionItemService
extends ApiService {
    public SubscriptionItemService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public SubscriptionItem delete(String item, SubscriptionItemDeleteParams params) throws StripeException {
        return this.delete(item, params, null);
    }

    public SubscriptionItem delete(String item, RequestOptions options) throws StripeException {
        return this.delete(item, null, options);
    }

    public SubscriptionItem delete(String item) throws StripeException {
        return this.delete(item, null, null);
    }

    public SubscriptionItem delete(String item, SubscriptionItemDeleteParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(item));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionItem)this.request(request, (Type)((Object)SubscriptionItem.class));
    }

    public SubscriptionItem retrieve(String item, SubscriptionItemRetrieveParams params) throws StripeException {
        return this.retrieve(item, params, null);
    }

    public SubscriptionItem retrieve(String item, RequestOptions options) throws StripeException {
        return this.retrieve(item, null, options);
    }

    public SubscriptionItem retrieve(String item) throws StripeException {
        return this.retrieve(item, null, null);
    }

    public SubscriptionItem retrieve(String item, SubscriptionItemRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(item));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionItem)this.request(request, (Type)((Object)SubscriptionItem.class));
    }

    public SubscriptionItem update(String item, SubscriptionItemUpdateParams params) throws StripeException {
        return this.update(item, params, null);
    }

    public SubscriptionItem update(String item, RequestOptions options) throws StripeException {
        return this.update(item, null, options);
    }

    public SubscriptionItem update(String item) throws StripeException {
        return this.update(item, null, null);
    }

    public SubscriptionItem update(String item, SubscriptionItemUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(item));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionItem)this.request(request, (Type)((Object)SubscriptionItem.class));
    }

    public StripeCollection<SubscriptionItem> list(SubscriptionItemListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<SubscriptionItem> list(SubscriptionItemListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_items";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<SubscriptionItem>>(){}.getType());
    }

    public SubscriptionItem create(SubscriptionItemCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public SubscriptionItem create(SubscriptionItemCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_items";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionItem)this.request(request, (Type)((Object)SubscriptionItem.class));
    }

    public SubscriptionItemUsageRecordSummaryService usageRecordSummaries() {
        return new SubscriptionItemUsageRecordSummaryService(this.getResponseGetter());
    }

    public SubscriptionItemUsageRecordService usageRecords() {
        return new SubscriptionItemUsageRecordService(this.getResponseGetter());
    }
}

