/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.financialconnections;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.financialconnections.Institution;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.financialconnections.InstitutionListParams;
import com.stripe.param.financialconnections.InstitutionRetrieveParams;
import java.lang.reflect.Type;

public final class InstitutionService
extends ApiService {
    public InstitutionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Institution> list(InstitutionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Institution> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Institution> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Institution> list(InstitutionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/financial_connections/institutions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Institution>>(){}.getType());
    }

    public Institution retrieve(String institution, InstitutionRetrieveParams params) throws StripeException {
        return this.retrieve(institution, params, null);
    }

    public Institution retrieve(String institution, RequestOptions options) throws StripeException {
        return this.retrieve(institution, null, options);
    }

    public Institution retrieve(String institution) throws StripeException {
        return this.retrieve(institution, null, null);
    }

    public Institution retrieve(String institution, InstitutionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/institutions/%s", ApiResource.urlEncodeId(institution));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Institution)this.request(request, (Type)((Object)Institution.class));
    }
}

