/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.testhelpers.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.issuing.Authorization;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.AuthorizationCaptureParams;
import com.stripe.param.issuing.AuthorizationCreateParams;
import com.stripe.param.issuing.AuthorizationExpireParams;
import com.stripe.param.issuing.AuthorizationFinalizeAmountParams;
import com.stripe.param.issuing.AuthorizationIncrementParams;
import com.stripe.param.issuing.AuthorizationReverseParams;
import java.lang.reflect.Type;

public final class AuthorizationService
extends ApiService {
    public AuthorizationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Authorization create(AuthorizationCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Authorization create(AuthorizationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/test_helpers/issuing/authorizations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)this.request(request, (Type)((Object)Authorization.class));
    }

    public Authorization capture(String authorization, AuthorizationCaptureParams params) throws StripeException {
        return this.capture(authorization, params, null);
    }

    public Authorization capture(String authorization, RequestOptions options) throws StripeException {
        return this.capture(authorization, null, options);
    }

    public Authorization capture(String authorization) throws StripeException {
        return this.capture(authorization, null, null);
    }

    public Authorization capture(String authorization, AuthorizationCaptureParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/authorizations/%s/capture", ApiResource.urlEncodeId(authorization));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)this.request(request, (Type)((Object)Authorization.class));
    }

    public Authorization expire(String authorization, AuthorizationExpireParams params) throws StripeException {
        return this.expire(authorization, params, null);
    }

    public Authorization expire(String authorization, RequestOptions options) throws StripeException {
        return this.expire(authorization, null, options);
    }

    public Authorization expire(String authorization) throws StripeException {
        return this.expire(authorization, null, null);
    }

    public Authorization expire(String authorization, AuthorizationExpireParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/authorizations/%s/expire", ApiResource.urlEncodeId(authorization));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)this.request(request, (Type)((Object)Authorization.class));
    }

    public Authorization finalizeAmount(String authorization, AuthorizationFinalizeAmountParams params) throws StripeException {
        return this.finalizeAmount(authorization, params, null);
    }

    public Authorization finalizeAmount(String authorization, AuthorizationFinalizeAmountParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/authorizations/%s/finalize_amount", ApiResource.urlEncodeId(authorization));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)this.request(request, (Type)((Object)Authorization.class));
    }

    public Authorization increment(String authorization, AuthorizationIncrementParams params) throws StripeException {
        return this.increment(authorization, params, null);
    }

    public Authorization increment(String authorization, AuthorizationIncrementParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/authorizations/%s/increment", ApiResource.urlEncodeId(authorization));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)this.request(request, (Type)((Object)Authorization.class));
    }

    public Authorization reverse(String authorization, AuthorizationReverseParams params) throws StripeException {
        return this.reverse(authorization, params, null);
    }

    public Authorization reverse(String authorization, RequestOptions options) throws StripeException {
        return this.reverse(authorization, null, options);
    }

    public Authorization reverse(String authorization) throws StripeException {
        return this.reverse(authorization, null, null);
    }

    public Authorization reverse(String authorization, AuthorizationReverseParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/authorizations/%s/reverse", ApiResource.urlEncodeId(authorization));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)this.request(request, (Type)((Object)Authorization.class));
    }
}

