/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.net.Authenticator;
import com.stripe.net.BearerTokenAuthenticator;
import com.stripe.net.StripeResponseGetterOptions;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import lombok.Generated;

public class RequestOptions {
    private final Authenticator authenticator;
    private final String clientId;
    private final String stripeContext;
    private final String idempotencyKey;
    private final String stripeAccount;
    private final String baseUrl;
    private final String stripeVersion = "2024-12-18.acacia";
    private final String stripeVersionOverride;
    private final Integer connectTimeout;
    private final Integer readTimeout;
    private final Integer maxNetworkRetries;
    private final Proxy connectionProxy;
    private final PasswordAuthentication proxyCredential;

    public static RequestOptions getDefault() {
        return new RequestOptions(null, null, null, null, null, null, null, null, null, null, null, null);
    }

    protected RequestOptions(Authenticator authenticator, String clientId, String idempotencyKey, String stripeContext, String stripeAccount, String stripeVersionOverride, String baseUrl, Integer connectTimeout, Integer readTimeout, Integer maxNetworkRetries, Proxy connectionProxy, PasswordAuthentication proxyCredential) {
        this.authenticator = authenticator;
        this.clientId = clientId;
        this.idempotencyKey = idempotencyKey;
        this.stripeContext = stripeContext;
        this.stripeAccount = stripeAccount;
        this.stripeVersionOverride = stripeVersionOverride;
        this.baseUrl = baseUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxNetworkRetries = maxNetworkRetries;
        this.connectionProxy = connectionProxy;
        this.proxyCredential = proxyCredential;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public String getApiKey() {
        if (this.authenticator instanceof BearerTokenAuthenticator) {
            return ((BearerTokenAuthenticator)this.authenticator).getApiKey();
        }
        return null;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getStripeContext() {
        return this.stripeContext;
    }

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public String getStripeAccount() {
        return this.stripeAccount;
    }

    public String getStripeVersion() {
        return "2024-12-18.acacia";
    }

    public static String unsafeGetStripeVersionOverride(RequestOptions options) {
        return options.stripeVersionOverride;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public PasswordAuthentication getProxyCredential() {
        return this.proxyCredential;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    @Deprecated
    public RequestOptionsBuilder toBuilder() {
        return new RequestOptionsBuilder().setAuthenticator(this.authenticator).setStripeAccount(this.stripeAccount);
    }

    public RequestOptionsBuilder toBuilderFullCopy() {
        return RequestOptionsBuilder.unsafeSetStripeVersionOverride(new RequestOptionsBuilder().setAuthenticator(this.authenticator).setBaseUrl(this.baseUrl).setClientId(this.clientId).setIdempotencyKey(this.idempotencyKey).setStripeAccount(this.stripeAccount).setConnectTimeout(this.connectTimeout).setReadTimeout(this.readTimeout).setMaxNetworkRetries(this.maxNetworkRetries).setConnectionProxy(this.connectionProxy).setProxyCredential(this.proxyCredential), this.stripeVersionOverride);
    }

    protected static String normalizeApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        return apiKey.trim();
    }

    protected static String normalizeClientId(String clientId) {
        if (clientId == null) {
            return null;
        }
        String normalized = clientId.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty client_id specified!");
        }
        return normalized;
    }

    protected static String normalizeStripeVersion(String stripeVersion) {
        if (stripeVersion == null) {
            return null;
        }
        String normalized = stripeVersion.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Stripe version specified!");
        }
        return normalized;
    }

    protected static String normalizeBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            return null;
        }
        String normalized = baseUrl.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty baseUrl specified!");
        }
        return normalized;
    }

    protected static String normalizeIdempotencyKey(String idempotencyKey) {
        if (idempotencyKey == null) {
            return null;
        }
        String normalized = idempotencyKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Idempotency Key Specified!");
        }
        if (normalized.length() > 255) {
            throw new InvalidRequestOptionsException(String.format("Idempotency Key length was %d, which is larger than the 255 character maximum!", normalized.length()));
        }
        return normalized;
    }

    protected static String normalizeStripeContext(String stripContext) {
        if (stripContext == null) {
            return null;
        }
        String normalized = stripContext.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty stripe context specified!");
        }
        return normalized;
    }

    protected static String normalizeStripeAccount(String stripeAccount) {
        if (stripeAccount == null) {
            return null;
        }
        String normalized = stripeAccount.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty stripe account specified!");
        }
        return normalized;
    }

    static RequestOptions merge(StripeResponseGetterOptions clientOptions, RequestOptions options) {
        if (options == null) {
            return new RequestOptions(clientOptions.getAuthenticator(), clientOptions.getClientId(), null, clientOptions.getStripeContext(), null, null, null, clientOptions.getConnectTimeout(), clientOptions.getReadTimeout(), clientOptions.getMaxNetworkRetries(), clientOptions.getConnectionProxy(), clientOptions.getProxyCredential());
        }
        return new RequestOptions(options.getAuthenticator() != null ? options.getAuthenticator() : clientOptions.getAuthenticator(), options.getClientId() != null ? options.getClientId() : clientOptions.getClientId(), options.getIdempotencyKey(), options.getStripeContext() != null ? options.getStripeContext() : clientOptions.getStripeContext(), options.getStripeAccount(), RequestOptions.unsafeGetStripeVersionOverride(options), options.getBaseUrl(), options.getConnectTimeout() != null ? options.getConnectTimeout().intValue() : clientOptions.getConnectTimeout(), options.getReadTimeout() != null ? options.getReadTimeout().intValue() : clientOptions.getReadTimeout(), options.getMaxNetworkRetries() != null ? options.getMaxNetworkRetries().intValue() : clientOptions.getMaxNetworkRetries(), options.getConnectionProxy() != null ? options.getConnectionProxy() : clientOptions.getConnectionProxy(), options.getProxyCredential() != null ? options.getProxyCredential() : clientOptions.getProxyCredential());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestOptions)) {
            return false;
        }
        RequestOptions other = (RequestOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$connectTimeout = this.getConnectTimeout();
        Integer other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Integer this$readTimeout = this.getReadTimeout();
        Integer other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Integer this$maxNetworkRetries = this.getMaxNetworkRetries();
        Integer other$maxNetworkRetries = other.getMaxNetworkRetries();
        if (this$maxNetworkRetries == null ? other$maxNetworkRetries != null : !((Object)this$maxNetworkRetries).equals(other$maxNetworkRetries)) {
            return false;
        }
        Authenticator this$authenticator = this.getAuthenticator();
        Authenticator other$authenticator = other.getAuthenticator();
        if (this$authenticator == null ? other$authenticator != null : !this$authenticator.equals(other$authenticator)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$stripeContext = this.getStripeContext();
        String other$stripeContext = other.getStripeContext();
        if (this$stripeContext == null ? other$stripeContext != null : !this$stripeContext.equals(other$stripeContext)) {
            return false;
        }
        String this$idempotencyKey = this.getIdempotencyKey();
        String other$idempotencyKey = other.getIdempotencyKey();
        if (this$idempotencyKey == null ? other$idempotencyKey != null : !this$idempotencyKey.equals(other$idempotencyKey)) {
            return false;
        }
        String this$stripeAccount = this.getStripeAccount();
        String other$stripeAccount = other.getStripeAccount();
        if (this$stripeAccount == null ? other$stripeAccount != null : !this$stripeAccount.equals(other$stripeAccount)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$stripeVersion = this.getStripeVersion();
        String other$stripeVersion = other.getStripeVersion();
        if (this$stripeVersion == null ? other$stripeVersion != null : !this$stripeVersion.equals(other$stripeVersion)) {
            return false;
        }
        String this$stripeVersionOverride = this.stripeVersionOverride;
        String other$stripeVersionOverride = other.stripeVersionOverride;
        if (this$stripeVersionOverride == null ? other$stripeVersionOverride != null : !this$stripeVersionOverride.equals(other$stripeVersionOverride)) {
            return false;
        }
        Proxy this$connectionProxy = this.getConnectionProxy();
        Proxy other$connectionProxy = other.getConnectionProxy();
        if (this$connectionProxy == null ? other$connectionProxy != null : !((Object)this$connectionProxy).equals(other$connectionProxy)) {
            return false;
        }
        PasswordAuthentication this$proxyCredential = this.getProxyCredential();
        PasswordAuthentication other$proxyCredential = other.getProxyCredential();
        return !(this$proxyCredential == null ? other$proxyCredential != null : !this$proxyCredential.equals(other$proxyCredential));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Integer $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Integer $maxNetworkRetries = this.getMaxNetworkRetries();
        result = result * 59 + ($maxNetworkRetries == null ? 43 : ((Object)$maxNetworkRetries).hashCode());
        Authenticator $authenticator = this.getAuthenticator();
        result = result * 59 + ($authenticator == null ? 43 : $authenticator.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $stripeContext = this.getStripeContext();
        result = result * 59 + ($stripeContext == null ? 43 : $stripeContext.hashCode());
        String $idempotencyKey = this.getIdempotencyKey();
        result = result * 59 + ($idempotencyKey == null ? 43 : $idempotencyKey.hashCode());
        String $stripeAccount = this.getStripeAccount();
        result = result * 59 + ($stripeAccount == null ? 43 : $stripeAccount.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $stripeVersion = this.getStripeVersion();
        result = result * 59 + ($stripeVersion == null ? 43 : $stripeVersion.hashCode());
        String $stripeVersionOverride = this.stripeVersionOverride;
        result = result * 59 + ($stripeVersionOverride == null ? 43 : $stripeVersionOverride.hashCode());
        Proxy $connectionProxy = this.getConnectionProxy();
        result = result * 59 + ($connectionProxy == null ? 43 : ((Object)$connectionProxy).hashCode());
        PasswordAuthentication $proxyCredential = this.getProxyCredential();
        result = result * 59 + ($proxyCredential == null ? 43 : $proxyCredential.hashCode());
        return result;
    }

    public static class RequestOptionsBuilder {
        protected Authenticator authenticator;
        protected String clientId;
        protected String idempotencyKey;
        protected String stripeContext;
        protected String stripeAccount;
        protected String stripeVersionOverride;
        protected Integer connectTimeout;
        protected Integer readTimeout;
        protected Integer maxNetworkRetries;
        protected Proxy connectionProxy;
        protected PasswordAuthentication proxyCredential;
        protected String baseUrl;

        public Authenticator getAuthenticator() {
            return this.authenticator;
        }

        public RequestOptionsBuilder setAuthenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public String getApiKey() {
            if (this.authenticator instanceof BearerTokenAuthenticator) {
                return ((BearerTokenAuthenticator)this.authenticator).getApiKey();
            }
            return null;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.authenticator = apiKey == null ? null : new BearerTokenAuthenticator(RequestOptions.normalizeApiKey(apiKey));
            return this;
        }

        public RequestOptionsBuilder clearApiKey() {
            this.authenticator = null;
            return this;
        }

        public String getClientId() {
            return this.clientId;
        }

        public RequestOptionsBuilder setClientId(String clientId) {
            this.clientId = RequestOptions.normalizeClientId(clientId);
            return this;
        }

        public RequestOptionsBuilder clearClientId() {
            this.clientId = null;
            return this;
        }

        public String getStripeContext() {
            return this.stripeContext;
        }

        public RequestOptionsBuilder setStripeContext(String context) {
            this.stripeContext = context;
            return this;
        }

        public RequestOptionsBuilder clearStripeContext() {
            this.stripeContext = null;
            return this;
        }

        public RequestOptionsBuilder setIdempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        public RequestOptionsBuilder setConnectTimeout(Integer timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public RequestOptionsBuilder setReadTimeout(Integer timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public Integer getMaxNetworkRetries() {
            return this.maxNetworkRetries;
        }

        public RequestOptionsBuilder setMaxNetworkRetries(Integer maxNetworkRetries) {
            this.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        public Proxy getConnectionProxy() {
            return this.connectionProxy;
        }

        public RequestOptionsBuilder setConnectionProxy(Proxy connectionProxy) {
            this.connectionProxy = connectionProxy;
            return this;
        }

        public PasswordAuthentication getProxyCredential() {
            return this.proxyCredential;
        }

        public RequestOptionsBuilder setProxyCredential(PasswordAuthentication proxyCredential) {
            this.proxyCredential = proxyCredential;
            return this;
        }

        public RequestOptionsBuilder clearIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        public String getStripeAccount() {
            return this.stripeAccount;
        }

        public RequestOptionsBuilder setStripeAccount(String stripeAccount) {
            this.stripeAccount = stripeAccount;
            return this;
        }

        public RequestOptionsBuilder clearStripeAccount() {
            return this.setStripeAccount(null);
        }

        public static RequestOptionsBuilder unsafeSetStripeVersionOverride(RequestOptionsBuilder builder, String stripeVersionOverride) {
            builder.stripeVersionOverride = RequestOptions.normalizeStripeVersion(stripeVersionOverride);
            return builder;
        }

        public RequestOptionsBuilder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(this.authenticator, RequestOptions.normalizeClientId(this.clientId), RequestOptions.normalizeIdempotencyKey(this.idempotencyKey), this.stripeContext, RequestOptions.normalizeStripeAccount(this.stripeAccount), RequestOptions.normalizeStripeVersion(this.stripeVersionOverride), RequestOptions.normalizeBaseUrl(this.baseUrl), this.connectTimeout, this.readTimeout, this.maxNetworkRetries, this.connectionProxy, this.proxyCredential);
        }
    }

    public static class InvalidRequestOptionsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidRequestOptionsException(String message) {
            super(message);
        }
    }
}

