/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.Charge;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.SetupAttempt;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ConfirmationTokenCreateParams;
import com.stripe.param.ConfirmationTokenRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ConfirmationToken
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="mandate_data")
    MandateData mandateData;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_intent")
    String paymentIntent;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_preview")
    PaymentMethodPreview paymentMethodPreview;
    @SerializedName(value="return_url")
    String returnUrl;
    @SerializedName(value="setup_future_usage")
    String setupFutureUsage;
    @SerializedName(value="setup_intent")
    String setupIntent;
    @SerializedName(value="shipping")
    Shipping shipping;
    @SerializedName(value="use_stripe_sdk")
    Boolean useStripeSdk;

    public static ConfirmationToken retrieve(String confirmationToken) throws StripeException {
        return ConfirmationToken.retrieve(confirmationToken, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ConfirmationToken retrieve(String confirmationToken, RequestOptions options) throws StripeException {
        return ConfirmationToken.retrieve(confirmationToken, (Map<String, Object>)null, options);
    }

    public static ConfirmationToken retrieve(String confirmationToken, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/confirmation_tokens/%s", ApiResource.urlEncodeId(confirmationToken));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (ConfirmationToken)ConfirmationToken.getGlobalResponseGetter().request(request, (Type)((Object)ConfirmationToken.class));
    }

    public static ConfirmationToken retrieve(String confirmationToken, ConfirmationTokenRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/confirmation_tokens/%s", ApiResource.urlEncodeId(confirmationToken));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (ConfirmationToken)ConfirmationToken.getGlobalResponseGetter().request(request, (Type)((Object)ConfirmationToken.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.mandateData, responseGetter);
        this.trySetResponseGetter(this.paymentMethodOptions, responseGetter);
        this.trySetResponseGetter(this.paymentMethodPreview, responseGetter);
        this.trySetResponseGetter(this.shipping, responseGetter);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public MandateData getMandateData() {
        return this.mandateData;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPaymentIntent() {
        return this.paymentIntent;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public PaymentMethodPreview getPaymentMethodPreview() {
        return this.paymentMethodPreview;
    }

    @Generated
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Generated
    public String getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Generated
    public String getSetupIntent() {
        return this.setupIntent;
    }

    @Generated
    public Shipping getShipping() {
        return this.shipping;
    }

    @Generated
    public Boolean getUseStripeSdk() {
        return this.useStripeSdk;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMandateData(MandateData mandateData) {
        this.mandateData = mandateData;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentIntent(String paymentIntent) {
        this.paymentIntent = paymentIntent;
    }

    @Generated
    public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
    }

    @Generated
    public void setPaymentMethodPreview(PaymentMethodPreview paymentMethodPreview) {
        this.paymentMethodPreview = paymentMethodPreview;
    }

    @Generated
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Generated
    public void setSetupFutureUsage(String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
    }

    @Generated
    public void setSetupIntent(String setupIntent) {
        this.setupIntent = setupIntent;
    }

    @Generated
    public void setShipping(Shipping shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setUseStripeSdk(Boolean useStripeSdk) {
        this.useStripeSdk = useStripeSdk;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfirmationToken)) {
            return false;
        }
        ConfirmationToken other = (ConfirmationToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Boolean this$useStripeSdk = this.getUseStripeSdk();
        Boolean other$useStripeSdk = other.getUseStripeSdk();
        if (this$useStripeSdk == null ? other$useStripeSdk != null : !((Object)this$useStripeSdk).equals(other$useStripeSdk)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        MandateData this$mandateData = this.getMandateData();
        MandateData other$mandateData = other.getMandateData();
        if (this$mandateData == null ? other$mandateData != null : !((Object)this$mandateData).equals(other$mandateData)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        PaymentMethodPreview this$paymentMethodPreview = this.getPaymentMethodPreview();
        PaymentMethodPreview other$paymentMethodPreview = other.getPaymentMethodPreview();
        if (this$paymentMethodPreview == null ? other$paymentMethodPreview != null : !((Object)this$paymentMethodPreview).equals(other$paymentMethodPreview)) {
            return false;
        }
        String this$returnUrl = this.getReturnUrl();
        String other$returnUrl = other.getReturnUrl();
        if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
            return false;
        }
        String this$setupFutureUsage = this.getSetupFutureUsage();
        String other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
            return false;
        }
        String this$setupIntent = this.getSetupIntent();
        String other$setupIntent = other.getSetupIntent();
        if (this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent)) {
            return false;
        }
        Shipping this$shipping = this.getShipping();
        Shipping other$shipping = other.getShipping();
        return !(this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfirmationToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Boolean $useStripeSdk = this.getUseStripeSdk();
        result = result * 59 + ($useStripeSdk == null ? 43 : ((Object)$useStripeSdk).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        MandateData $mandateData = this.getMandateData();
        result = result * 59 + ($mandateData == null ? 43 : ((Object)$mandateData).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        PaymentMethodPreview $paymentMethodPreview = this.getPaymentMethodPreview();
        result = result * 59 + ($paymentMethodPreview == null ? 43 : ((Object)$paymentMethodPreview).hashCode());
        String $returnUrl = this.getReturnUrl();
        result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
        String $setupFutureUsage = this.getSetupFutureUsage();
        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        String $setupIntent = this.getSetupIntent();
        result = result * 59 + ($setupIntent == null ? 43 : $setupIntent.hashCode());
        Shipping $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class MandateData
    extends StripeObject {
        @SerializedName(value="customer_acceptance")
        CustomerAcceptance customerAcceptance;

        @Generated
        public CustomerAcceptance getCustomerAcceptance() {
            return this.customerAcceptance;
        }

        @Generated
        public void setCustomerAcceptance(CustomerAcceptance customerAcceptance) {
            this.customerAcceptance = customerAcceptance;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MandateData)) {
                return false;
            }
            MandateData other = (MandateData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CustomerAcceptance this$customerAcceptance = this.getCustomerAcceptance();
            CustomerAcceptance other$customerAcceptance = other.getCustomerAcceptance();
            return !(this$customerAcceptance == null ? other$customerAcceptance != null : !((Object)this$customerAcceptance).equals(other$customerAcceptance));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MandateData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CustomerAcceptance $customerAcceptance = this.getCustomerAcceptance();
            result = result * 59 + ($customerAcceptance == null ? 43 : ((Object)$customerAcceptance).hashCode());
            return result;
        }

        public static class CustomerAcceptance
        extends StripeObject {
            @SerializedName(value="online")
            Online online;
            @SerializedName(value="type")
            String type;

            @Generated
            public Online getOnline() {
                return this.online;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setOnline(Online online) {
                this.online = online;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CustomerAcceptance)) {
                    return false;
                }
                CustomerAcceptance other = (CustomerAcceptance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Online this$online = this.getOnline();
                Online other$online = other.getOnline();
                if (this$online == null ? other$online != null : !((Object)this$online).equals(other$online)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CustomerAcceptance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Online $online = this.getOnline();
                result = result * 59 + ($online == null ? 43 : ((Object)$online).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Online
            extends StripeObject {
                @SerializedName(value="ip_address")
                String ipAddress;
                @SerializedName(value="user_agent")
                String userAgent;

                @Generated
                public String getIpAddress() {
                    return this.ipAddress;
                }

                @Generated
                public String getUserAgent() {
                    return this.userAgent;
                }

                @Generated
                public void setIpAddress(String ipAddress) {
                    this.ipAddress = ipAddress;
                }

                @Generated
                public void setUserAgent(String userAgent) {
                    this.userAgent = userAgent;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Online)) {
                        return false;
                    }
                    Online other = (Online)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$ipAddress = this.getIpAddress();
                    String other$ipAddress = other.getIpAddress();
                    if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                        return false;
                    }
                    String this$userAgent = this.getUserAgent();
                    String other$userAgent = other.getUserAgent();
                    return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Online;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $ipAddress = this.getIpAddress();
                    result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
                    String $userAgent = this.getUserAgent();
                    result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
                    return result;
                }
            }
        }
    }

    public static class PaymentMethodOptions
    extends StripeObject {
        @SerializedName(value="card")
        Card card;

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            return !(this$card == null ? other$card != null : !((Object)this$card).equals(other$card));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            return result;
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="cvc_token")
            String cvcToken;

            @Generated
            public String getCvcToken() {
                return this.cvcToken;
            }

            @Generated
            public void setCvcToken(String cvcToken) {
                this.cvcToken = cvcToken;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$cvcToken = this.getCvcToken();
                String other$cvcToken = other.getCvcToken();
                return !(this$cvcToken == null ? other$cvcToken != null : !this$cvcToken.equals(other$cvcToken));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $cvcToken = this.getCvcToken();
                result = result * 59 + ($cvcToken == null ? 43 : $cvcToken.hashCode());
                return result;
            }
        }
    }

    public static class PaymentMethodPreview
    extends StripeObject {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="affirm")
        Affirm affirm;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="allow_redisplay")
        String allowRedisplay;
        @SerializedName(value="alma")
        Alma alma;
        @SerializedName(value="amazon_pay")
        AmazonPay amazonPay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="blik")
        Blik blik;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="card_present")
        CardPresent cardPresent;
        @SerializedName(value="cashapp")
        Cashapp cashapp;
        @SerializedName(value="customer")
        ExpandableField<Customer> customer;
        @SerializedName(value="customer_balance")
        CustomerBalance customerBalance;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="interac_present")
        InteracPresent interacPresent;
        @SerializedName(value="kakao_pay")
        KakaoPay kakaoPay;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="konbini")
        Konbini konbini;
        @SerializedName(value="kr_card")
        KrCard krCard;
        @SerializedName(value="link")
        Link link;
        @SerializedName(value="mobilepay")
        Mobilepay mobilepay;
        @SerializedName(value="multibanco")
        Multibanco multibanco;
        @SerializedName(value="naver_pay")
        NaverPay naverPay;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="pay_by_bank")
        PayByBank payByBank;
        @SerializedName(value="payco")
        Payco payco;
        @SerializedName(value="paynow")
        Paynow paynow;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="pix")
        Pix pix;
        @SerializedName(value="promptpay")
        Promptpay promptpay;
        @SerializedName(value="revolut_pay")
        RevolutPay revolutPay;
        @SerializedName(value="samsung_pay")
        SamsungPay samsungPay;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="swish")
        Swish swish;
        @SerializedName(value="twint")
        Twint twint;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;
        @SerializedName(value="wechat_pay")
        WechatPay wechatPay;
        @SerializedName(value="zip")
        Zip zip;

        public String getCustomer() {
            return this.customer != null ? this.customer.getId() : null;
        }

        public void setCustomer(String id) {
            this.customer = ApiResource.setExpandableFieldId(id, this.customer);
        }

        public Customer getCustomerObject() {
            return this.customer != null ? this.customer.getExpanded() : null;
        }

        public void setCustomerObject(Customer expandableObject) {
            this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Affirm getAffirm() {
            return this.affirm;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public String getAllowRedisplay() {
            return this.allowRedisplay;
        }

        @Generated
        public Alma getAlma() {
            return this.alma;
        }

        @Generated
        public AmazonPay getAmazonPay() {
            return this.amazonPay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public Blik getBlik() {
            return this.blik;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public CardPresent getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Cashapp getCashapp() {
            return this.cashapp;
        }

        @Generated
        public CustomerBalance getCustomerBalance() {
            return this.customerBalance;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public InteracPresent getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public KakaoPay getKakaoPay() {
            return this.kakaoPay;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Konbini getKonbini() {
            return this.konbini;
        }

        @Generated
        public KrCard getKrCard() {
            return this.krCard;
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public Mobilepay getMobilepay() {
            return this.mobilepay;
        }

        @Generated
        public Multibanco getMultibanco() {
            return this.multibanco;
        }

        @Generated
        public NaverPay getNaverPay() {
            return this.naverPay;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public PayByBank getPayByBank() {
            return this.payByBank;
        }

        @Generated
        public Payco getPayco() {
            return this.payco;
        }

        @Generated
        public Paynow getPaynow() {
            return this.paynow;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public Pix getPix() {
            return this.pix;
        }

        @Generated
        public Promptpay getPromptpay() {
            return this.promptpay;
        }

        @Generated
        public RevolutPay getRevolutPay() {
            return this.revolutPay;
        }

        @Generated
        public SamsungPay getSamsungPay() {
            return this.samsungPay;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public Swish getSwish() {
            return this.swish;
        }

        @Generated
        public Twint getTwint() {
            return this.twint;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public WechatPay getWechatPay() {
            return this.wechatPay;
        }

        @Generated
        public Zip getZip() {
            return this.zip;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setAffirm(Affirm affirm) {
            this.affirm = affirm;
        }

        @Generated
        public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
            this.afterpayClearpay = afterpayClearpay;
        }

        @Generated
        public void setAlipay(Alipay alipay) {
            this.alipay = alipay;
        }

        @Generated
        public void setAllowRedisplay(String allowRedisplay) {
            this.allowRedisplay = allowRedisplay;
        }

        @Generated
        public void setAlma(Alma alma) {
            this.alma = alma;
        }

        @Generated
        public void setAmazonPay(AmazonPay amazonPay) {
            this.amazonPay = amazonPay;
        }

        @Generated
        public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
            this.auBecsDebit = auBecsDebit;
        }

        @Generated
        public void setBacsDebit(BacsDebit bacsDebit) {
            this.bacsDebit = bacsDebit;
        }

        @Generated
        public void setBancontact(Bancontact bancontact) {
            this.bancontact = bancontact;
        }

        @Generated
        public void setBillingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
        }

        @Generated
        public void setBlik(Blik blik) {
            this.blik = blik;
        }

        @Generated
        public void setBoleto(Boleto boleto) {
            this.boleto = boleto;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCardPresent(CardPresent cardPresent) {
            this.cardPresent = cardPresent;
        }

        @Generated
        public void setCashapp(Cashapp cashapp) {
            this.cashapp = cashapp;
        }

        @Generated
        public void setCustomerBalance(CustomerBalance customerBalance) {
            this.customerBalance = customerBalance;
        }

        @Generated
        public void setEps(Eps eps) {
            this.eps = eps;
        }

        @Generated
        public void setFpx(Fpx fpx) {
            this.fpx = fpx;
        }

        @Generated
        public void setGiropay(Giropay giropay) {
            this.giropay = giropay;
        }

        @Generated
        public void setGrabpay(Grabpay grabpay) {
            this.grabpay = grabpay;
        }

        @Generated
        public void setIdeal(Ideal ideal) {
            this.ideal = ideal;
        }

        @Generated
        public void setInteracPresent(InteracPresent interacPresent) {
            this.interacPresent = interacPresent;
        }

        @Generated
        public void setKakaoPay(KakaoPay kakaoPay) {
            this.kakaoPay = kakaoPay;
        }

        @Generated
        public void setKlarna(Klarna klarna) {
            this.klarna = klarna;
        }

        @Generated
        public void setKonbini(Konbini konbini) {
            this.konbini = konbini;
        }

        @Generated
        public void setKrCard(KrCard krCard) {
            this.krCard = krCard;
        }

        @Generated
        public void setLink(Link link) {
            this.link = link;
        }

        @Generated
        public void setMobilepay(Mobilepay mobilepay) {
            this.mobilepay = mobilepay;
        }

        @Generated
        public void setMultibanco(Multibanco multibanco) {
            this.multibanco = multibanco;
        }

        @Generated
        public void setNaverPay(NaverPay naverPay) {
            this.naverPay = naverPay;
        }

        @Generated
        public void setOxxo(Oxxo oxxo) {
            this.oxxo = oxxo;
        }

        @Generated
        public void setP24(P24 p24) {
            this.p24 = p24;
        }

        @Generated
        public void setPayByBank(PayByBank payByBank) {
            this.payByBank = payByBank;
        }

        @Generated
        public void setPayco(Payco payco) {
            this.payco = payco;
        }

        @Generated
        public void setPaynow(Paynow paynow) {
            this.paynow = paynow;
        }

        @Generated
        public void setPaypal(Paypal paypal) {
            this.paypal = paypal;
        }

        @Generated
        public void setPix(Pix pix) {
            this.pix = pix;
        }

        @Generated
        public void setPromptpay(Promptpay promptpay) {
            this.promptpay = promptpay;
        }

        @Generated
        public void setRevolutPay(RevolutPay revolutPay) {
            this.revolutPay = revolutPay;
        }

        @Generated
        public void setSamsungPay(SamsungPay samsungPay) {
            this.samsungPay = samsungPay;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setSofort(Sofort sofort) {
            this.sofort = sofort;
        }

        @Generated
        public void setSwish(Swish swish) {
            this.swish = swish;
        }

        @Generated
        public void setTwint(Twint twint) {
            this.twint = twint;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public void setWechatPay(WechatPay wechatPay) {
            this.wechatPay = wechatPay;
        }

        @Generated
        public void setZip(Zip zip) {
            this.zip = zip;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodPreview)) {
                return false;
            }
            PaymentMethodPreview other = (PaymentMethodPreview)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            Affirm this$affirm = this.getAffirm();
            Affirm other$affirm = other.getAffirm();
            if (this$affirm == null ? other$affirm != null : !((Object)this$affirm).equals(other$affirm)) {
                return false;
            }
            AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
            AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
            if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
                return false;
            }
            Alipay this$alipay = this.getAlipay();
            Alipay other$alipay = other.getAlipay();
            if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
                return false;
            }
            String this$allowRedisplay = this.getAllowRedisplay();
            String other$allowRedisplay = other.getAllowRedisplay();
            if (this$allowRedisplay == null ? other$allowRedisplay != null : !this$allowRedisplay.equals(other$allowRedisplay)) {
                return false;
            }
            Alma this$alma = this.getAlma();
            Alma other$alma = other.getAlma();
            if (this$alma == null ? other$alma != null : !((Object)this$alma).equals(other$alma)) {
                return false;
            }
            AmazonPay this$amazonPay = this.getAmazonPay();
            AmazonPay other$amazonPay = other.getAmazonPay();
            if (this$amazonPay == null ? other$amazonPay != null : !((Object)this$amazonPay).equals(other$amazonPay)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Bancontact this$bancontact = this.getBancontact();
            Bancontact other$bancontact = other.getBancontact();
            if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                return false;
            }
            BillingDetails this$billingDetails = this.getBillingDetails();
            BillingDetails other$billingDetails = other.getBillingDetails();
            if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
                return false;
            }
            Blik this$blik = this.getBlik();
            Blik other$blik = other.getBlik();
            if (this$blik == null ? other$blik != null : !((Object)this$blik).equals(other$blik)) {
                return false;
            }
            Boleto this$boleto = this.getBoleto();
            Boleto other$boleto = other.getBoleto();
            if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            CardPresent this$cardPresent = this.getCardPresent();
            CardPresent other$cardPresent = other.getCardPresent();
            if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
                return false;
            }
            Cashapp this$cashapp = this.getCashapp();
            Cashapp other$cashapp = other.getCashapp();
            if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
                return false;
            }
            String this$customer = this.getCustomer();
            String other$customer = other.getCustomer();
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            CustomerBalance this$customerBalance = this.getCustomerBalance();
            CustomerBalance other$customerBalance = other.getCustomerBalance();
            if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
                return false;
            }
            Eps this$eps = this.getEps();
            Eps other$eps = other.getEps();
            if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
                return false;
            }
            Fpx this$fpx = this.getFpx();
            Fpx other$fpx = other.getFpx();
            if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
                return false;
            }
            Giropay this$giropay = this.getGiropay();
            Giropay other$giropay = other.getGiropay();
            if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
                return false;
            }
            Grabpay this$grabpay = this.getGrabpay();
            Grabpay other$grabpay = other.getGrabpay();
            if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
                return false;
            }
            Ideal this$ideal = this.getIdeal();
            Ideal other$ideal = other.getIdeal();
            if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
                return false;
            }
            InteracPresent this$interacPresent = this.getInteracPresent();
            InteracPresent other$interacPresent = other.getInteracPresent();
            if (this$interacPresent == null ? other$interacPresent != null : !((Object)this$interacPresent).equals(other$interacPresent)) {
                return false;
            }
            KakaoPay this$kakaoPay = this.getKakaoPay();
            KakaoPay other$kakaoPay = other.getKakaoPay();
            if (this$kakaoPay == null ? other$kakaoPay != null : !((Object)this$kakaoPay).equals(other$kakaoPay)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            Konbini this$konbini = this.getKonbini();
            Konbini other$konbini = other.getKonbini();
            if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
                return false;
            }
            KrCard this$krCard = this.getKrCard();
            KrCard other$krCard = other.getKrCard();
            if (this$krCard == null ? other$krCard != null : !((Object)this$krCard).equals(other$krCard)) {
                return false;
            }
            Link this$link = this.getLink();
            Link other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            Mobilepay this$mobilepay = this.getMobilepay();
            Mobilepay other$mobilepay = other.getMobilepay();
            if (this$mobilepay == null ? other$mobilepay != null : !((Object)this$mobilepay).equals(other$mobilepay)) {
                return false;
            }
            Multibanco this$multibanco = this.getMultibanco();
            Multibanco other$multibanco = other.getMultibanco();
            if (this$multibanco == null ? other$multibanco != null : !((Object)this$multibanco).equals(other$multibanco)) {
                return false;
            }
            NaverPay this$naverPay = this.getNaverPay();
            NaverPay other$naverPay = other.getNaverPay();
            if (this$naverPay == null ? other$naverPay != null : !((Object)this$naverPay).equals(other$naverPay)) {
                return false;
            }
            Oxxo this$oxxo = this.getOxxo();
            Oxxo other$oxxo = other.getOxxo();
            if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
                return false;
            }
            P24 this$p24 = this.getP24();
            P24 other$p24 = other.getP24();
            if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
                return false;
            }
            PayByBank this$payByBank = this.getPayByBank();
            PayByBank other$payByBank = other.getPayByBank();
            if (this$payByBank == null ? other$payByBank != null : !((Object)this$payByBank).equals(other$payByBank)) {
                return false;
            }
            Payco this$payco = this.getPayco();
            Payco other$payco = other.getPayco();
            if (this$payco == null ? other$payco != null : !((Object)this$payco).equals(other$payco)) {
                return false;
            }
            Paynow this$paynow = this.getPaynow();
            Paynow other$paynow = other.getPaynow();
            if (this$paynow == null ? other$paynow != null : !((Object)this$paynow).equals(other$paynow)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                return false;
            }
            Pix this$pix = this.getPix();
            Pix other$pix = other.getPix();
            if (this$pix == null ? other$pix != null : !((Object)this$pix).equals(other$pix)) {
                return false;
            }
            Promptpay this$promptpay = this.getPromptpay();
            Promptpay other$promptpay = other.getPromptpay();
            if (this$promptpay == null ? other$promptpay != null : !((Object)this$promptpay).equals(other$promptpay)) {
                return false;
            }
            RevolutPay this$revolutPay = this.getRevolutPay();
            RevolutPay other$revolutPay = other.getRevolutPay();
            if (this$revolutPay == null ? other$revolutPay != null : !((Object)this$revolutPay).equals(other$revolutPay)) {
                return false;
            }
            SamsungPay this$samsungPay = this.getSamsungPay();
            SamsungPay other$samsungPay = other.getSamsungPay();
            if (this$samsungPay == null ? other$samsungPay != null : !((Object)this$samsungPay).equals(other$samsungPay)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            Sofort this$sofort = this.getSofort();
            Sofort other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                return false;
            }
            Swish this$swish = this.getSwish();
            Swish other$swish = other.getSwish();
            if (this$swish == null ? other$swish != null : !((Object)this$swish).equals(other$swish)) {
                return false;
            }
            Twint this$twint = this.getTwint();
            Twint other$twint = other.getTwint();
            if (this$twint == null ? other$twint != null : !((Object)this$twint).equals(other$twint)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            if (this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount)) {
                return false;
            }
            WechatPay this$wechatPay = this.getWechatPay();
            WechatPay other$wechatPay = other.getWechatPay();
            if (this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay)) {
                return false;
            }
            Zip this$zip = this.getZip();
            Zip other$zip = other.getZip();
            return !(this$zip == null ? other$zip != null : !((Object)this$zip).equals(other$zip));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodPreview;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            Affirm $affirm = this.getAffirm();
            result = result * 59 + ($affirm == null ? 43 : ((Object)$affirm).hashCode());
            AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
            result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
            Alipay $alipay = this.getAlipay();
            result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
            String $allowRedisplay = this.getAllowRedisplay();
            result = result * 59 + ($allowRedisplay == null ? 43 : $allowRedisplay.hashCode());
            Alma $alma = this.getAlma();
            result = result * 59 + ($alma == null ? 43 : ((Object)$alma).hashCode());
            AmazonPay $amazonPay = this.getAmazonPay();
            result = result * 59 + ($amazonPay == null ? 43 : ((Object)$amazonPay).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Bancontact $bancontact = this.getBancontact();
            result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
            BillingDetails $billingDetails = this.getBillingDetails();
            result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
            Blik $blik = this.getBlik();
            result = result * 59 + ($blik == null ? 43 : ((Object)$blik).hashCode());
            Boleto $boleto = this.getBoleto();
            result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            CardPresent $cardPresent = this.getCardPresent();
            result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
            Cashapp $cashapp = this.getCashapp();
            result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
            String $customer = this.getCustomer();
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            CustomerBalance $customerBalance = this.getCustomerBalance();
            result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
            Eps $eps = this.getEps();
            result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
            Fpx $fpx = this.getFpx();
            result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
            Giropay $giropay = this.getGiropay();
            result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
            Grabpay $grabpay = this.getGrabpay();
            result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
            Ideal $ideal = this.getIdeal();
            result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
            InteracPresent $interacPresent = this.getInteracPresent();
            result = result * 59 + ($interacPresent == null ? 43 : ((Object)$interacPresent).hashCode());
            KakaoPay $kakaoPay = this.getKakaoPay();
            result = result * 59 + ($kakaoPay == null ? 43 : ((Object)$kakaoPay).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            Konbini $konbini = this.getKonbini();
            result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
            KrCard $krCard = this.getKrCard();
            result = result * 59 + ($krCard == null ? 43 : ((Object)$krCard).hashCode());
            Link $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            Mobilepay $mobilepay = this.getMobilepay();
            result = result * 59 + ($mobilepay == null ? 43 : ((Object)$mobilepay).hashCode());
            Multibanco $multibanco = this.getMultibanco();
            result = result * 59 + ($multibanco == null ? 43 : ((Object)$multibanco).hashCode());
            NaverPay $naverPay = this.getNaverPay();
            result = result * 59 + ($naverPay == null ? 43 : ((Object)$naverPay).hashCode());
            Oxxo $oxxo = this.getOxxo();
            result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
            P24 $p24 = this.getP24();
            result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
            PayByBank $payByBank = this.getPayByBank();
            result = result * 59 + ($payByBank == null ? 43 : ((Object)$payByBank).hashCode());
            Payco $payco = this.getPayco();
            result = result * 59 + ($payco == null ? 43 : ((Object)$payco).hashCode());
            Paynow $paynow = this.getPaynow();
            result = result * 59 + ($paynow == null ? 43 : ((Object)$paynow).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            Pix $pix = this.getPix();
            result = result * 59 + ($pix == null ? 43 : ((Object)$pix).hashCode());
            Promptpay $promptpay = this.getPromptpay();
            result = result * 59 + ($promptpay == null ? 43 : ((Object)$promptpay).hashCode());
            RevolutPay $revolutPay = this.getRevolutPay();
            result = result * 59 + ($revolutPay == null ? 43 : ((Object)$revolutPay).hashCode());
            SamsungPay $samsungPay = this.getSamsungPay();
            result = result * 59 + ($samsungPay == null ? 43 : ((Object)$samsungPay).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            Sofort $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
            Swish $swish = this.getSwish();
            result = result * 59 + ($swish == null ? 43 : ((Object)$swish).hashCode());
            Twint $twint = this.getTwint();
            result = result * 59 + ($twint == null ? 43 : ((Object)$twint).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            WechatPay $wechatPay = this.getWechatPay();
            result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
            Zip $zip = this.getZip();
            result = result * 59 + ($zip == null ? 43 : ((Object)$zip).hashCode());
            return result;
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="institution_number")
            String institutionNumber;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="transit_number")
            String transitNumber;

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getInstitutionNumber() {
                return this.institutionNumber;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getTransitNumber() {
                return this.transitNumber;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setInstitutionNumber(String institutionNumber) {
                this.institutionNumber = institutionNumber;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setTransitNumber(String transitNumber) {
                this.transitNumber = transitNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$institutionNumber = this.getInstitutionNumber();
                String other$institutionNumber = other.getInstitutionNumber();
                if (this$institutionNumber == null ? other$institutionNumber != null : !this$institutionNumber.equals(other$institutionNumber)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$transitNumber = this.getTransitNumber();
                String other$transitNumber = other.getTransitNumber();
                return !(this$transitNumber == null ? other$transitNumber != null : !this$transitNumber.equals(other$transitNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $institutionNumber = this.getInstitutionNumber();
                result = result * 59 + ($institutionNumber == null ? 43 : $institutionNumber.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $transitNumber = this.getTransitNumber();
                result = result * 59 + ($transitNumber == null ? 43 : $transitNumber.hashCode());
                return result;
            }
        }

        public static class Affirm
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Affirm)) {
                    return false;
                }
                Affirm other = (Affirm)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Affirm;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AfterpayClearpay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AfterpayClearpay)) {
                    return false;
                }
                AfterpayClearpay other = (AfterpayClearpay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AfterpayClearpay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Alipay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alipay)) {
                    return false;
                }
                Alipay other = (Alipay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alipay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Alma
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alma)) {
                    return false;
                }
                Alma other = (Alma)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alma;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AmazonPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AmazonPay)) {
                    return false;
                }
                AmazonPay other = (AmazonPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AmazonPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AuBecsDebit
        extends StripeObject {
            @SerializedName(value="bsb_number")
            String bsbNumber;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;

            @Generated
            public String getBsbNumber() {
                return this.bsbNumber;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public void setBsbNumber(String bsbNumber) {
                this.bsbNumber = bsbNumber;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBecsDebit)) {
                    return false;
                }
                AuBecsDebit other = (AuBecsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bsbNumber = this.getBsbNumber();
                String other$bsbNumber = other.getBsbNumber();
                if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBecsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bsbNumber = this.getBsbNumber();
                result = result * 59 + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                return result;
            }
        }

        public static class BacsDebit
        extends StripeObject {
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="sort_code")
            String sortCode;

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getSortCode() {
                return this.sortCode;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setSortCode(String sortCode) {
                this.sortCode = sortCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebit)) {
                    return false;
                }
                BacsDebit other = (BacsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$sortCode = this.getSortCode();
                String other$sortCode = other.getSortCode();
                return !(this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $sortCode = this.getSortCode();
                result = result * 59 + ($sortCode == null ? 43 : $sortCode.hashCode());
                return result;
            }
        }

        public static class Bancontact
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bancontact)) {
                    return false;
                }
                Bancontact other = (Bancontact)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bancontact;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class BillingDetails
        extends StripeObject {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="email")
            String email;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="phone")
            String phone;

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getEmail() {
                return this.email;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getPhone() {
                return this.phone;
            }

            @Generated
            public void setAddress(Address address) {
                this.address = address;
            }

            @Generated
            public void setEmail(String email) {
                this.email = email;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setPhone(String phone) {
                this.phone = phone;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingDetails)) {
                    return false;
                }
                BillingDetails other = (BillingDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                String this$email = this.getEmail();
                String other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$phone = this.getPhone();
                String other$phone = other.getPhone();
                return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                String $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $phone = this.getPhone();
                result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                return result;
            }
        }

        public static class Blik
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Blik)) {
                    return false;
                }
                Blik other = (Blik)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Blik;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Boleto
        extends StripeObject {
            @SerializedName(value="tax_id")
            String taxId;

            @Generated
            public String getTaxId() {
                return this.taxId;
            }

            @Generated
            public void setTaxId(String taxId) {
                this.taxId = taxId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Boleto)) {
                    return false;
                }
                Boleto other = (Boleto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$taxId = this.getTaxId();
                String other$taxId = other.getTaxId();
                return !(this$taxId == null ? other$taxId != null : !this$taxId.equals(other$taxId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Boleto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $taxId = this.getTaxId();
                result = result * 59 + ($taxId == null ? 43 : $taxId.hashCode());
                return result;
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="checks")
            Checks checks;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="display_brand")
            String displayBrand;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="generated_from")
            GeneratedFrom generatedFrom;
            @SerializedName(value="iin")
            String iin;
            @SerializedName(value="issuer")
            String issuer;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="networks")
            Networks networks;
            @SerializedName(value="regulated_status")
            String regulatedStatus;
            @SerializedName(value="three_d_secure_usage")
            ThreeDSecureUsage threeDSecureUsage;
            @SerializedName(value="wallet")
            Wallet wallet;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public Checks getChecks() {
                return this.checks;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public String getDisplayBrand() {
                return this.displayBrand;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public GeneratedFrom getGeneratedFrom() {
                return this.generatedFrom;
            }

            @Generated
            public String getIin() {
                return this.iin;
            }

            @Generated
            public String getIssuer() {
                return this.issuer;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public Networks getNetworks() {
                return this.networks;
            }

            @Generated
            public String getRegulatedStatus() {
                return this.regulatedStatus;
            }

            @Generated
            public ThreeDSecureUsage getThreeDSecureUsage() {
                return this.threeDSecureUsage;
            }

            @Generated
            public Wallet getWallet() {
                return this.wallet;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setChecks(Checks checks) {
                this.checks = checks;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setDisplayBrand(String displayBrand) {
                this.displayBrand = displayBrand;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setGeneratedFrom(GeneratedFrom generatedFrom) {
                this.generatedFrom = generatedFrom;
            }

            @Generated
            public void setIin(String iin) {
                this.iin = iin;
            }

            @Generated
            public void setIssuer(String issuer) {
                this.issuer = issuer;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetworks(Networks networks) {
                this.networks = networks;
            }

            @Generated
            public void setRegulatedStatus(String regulatedStatus) {
                this.regulatedStatus = regulatedStatus;
            }

            @Generated
            public void setThreeDSecureUsage(ThreeDSecureUsage threeDSecureUsage) {
                this.threeDSecureUsage = threeDSecureUsage;
            }

            @Generated
            public void setWallet(Wallet wallet) {
                this.wallet = wallet;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                Checks this$checks = this.getChecks();
                Checks other$checks = other.getChecks();
                if (this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$displayBrand = this.getDisplayBrand();
                String other$displayBrand = other.getDisplayBrand();
                if (this$displayBrand == null ? other$displayBrand != null : !this$displayBrand.equals(other$displayBrand)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                GeneratedFrom this$generatedFrom = this.getGeneratedFrom();
                GeneratedFrom other$generatedFrom = other.getGeneratedFrom();
                if (this$generatedFrom == null ? other$generatedFrom != null : !((Object)this$generatedFrom).equals(other$generatedFrom)) {
                    return false;
                }
                String this$iin = this.getIin();
                String other$iin = other.getIin();
                if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                    return false;
                }
                String this$issuer = this.getIssuer();
                String other$issuer = other.getIssuer();
                if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                Networks this$networks = this.getNetworks();
                Networks other$networks = other.getNetworks();
                if (this$networks == null ? other$networks != null : !((Object)this$networks).equals(other$networks)) {
                    return false;
                }
                String this$regulatedStatus = this.getRegulatedStatus();
                String other$regulatedStatus = other.getRegulatedStatus();
                if (this$regulatedStatus == null ? other$regulatedStatus != null : !this$regulatedStatus.equals(other$regulatedStatus)) {
                    return false;
                }
                ThreeDSecureUsage this$threeDSecureUsage = this.getThreeDSecureUsage();
                ThreeDSecureUsage other$threeDSecureUsage = other.getThreeDSecureUsage();
                if (this$threeDSecureUsage == null ? other$threeDSecureUsage != null : !((Object)this$threeDSecureUsage).equals(other$threeDSecureUsage)) {
                    return false;
                }
                Wallet this$wallet = this.getWallet();
                Wallet other$wallet = other.getWallet();
                return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                Checks $checks = this.getChecks();
                result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $displayBrand = this.getDisplayBrand();
                result = result * 59 + ($displayBrand == null ? 43 : $displayBrand.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                GeneratedFrom $generatedFrom = this.getGeneratedFrom();
                result = result * 59 + ($generatedFrom == null ? 43 : ((Object)$generatedFrom).hashCode());
                String $iin = this.getIin();
                result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
                String $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                Networks $networks = this.getNetworks();
                result = result * 59 + ($networks == null ? 43 : ((Object)$networks).hashCode());
                String $regulatedStatus = this.getRegulatedStatus();
                result = result * 59 + ($regulatedStatus == null ? 43 : $regulatedStatus.hashCode());
                ThreeDSecureUsage $threeDSecureUsage = this.getThreeDSecureUsage();
                result = result * 59 + ($threeDSecureUsage == null ? 43 : ((Object)$threeDSecureUsage).hashCode());
                Wallet $wallet = this.getWallet();
                result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
                return result;
            }

            public static class Checks
            extends StripeObject {
                @SerializedName(value="address_line1_check")
                String addressLine1Check;
                @SerializedName(value="address_postal_code_check")
                String addressPostalCodeCheck;
                @SerializedName(value="cvc_check")
                String cvcCheck;

                @Generated
                public String getAddressLine1Check() {
                    return this.addressLine1Check;
                }

                @Generated
                public String getAddressPostalCodeCheck() {
                    return this.addressPostalCodeCheck;
                }

                @Generated
                public String getCvcCheck() {
                    return this.cvcCheck;
                }

                @Generated
                public void setAddressLine1Check(String addressLine1Check) {
                    this.addressLine1Check = addressLine1Check;
                }

                @Generated
                public void setAddressPostalCodeCheck(String addressPostalCodeCheck) {
                    this.addressPostalCodeCheck = addressPostalCodeCheck;
                }

                @Generated
                public void setCvcCheck(String cvcCheck) {
                    this.cvcCheck = cvcCheck;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Checks)) {
                        return false;
                    }
                    Checks other = (Checks)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$addressLine1Check = this.getAddressLine1Check();
                    String other$addressLine1Check = other.getAddressLine1Check();
                    if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                        return false;
                    }
                    String this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                    String other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
                    if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) {
                        return false;
                    }
                    String this$cvcCheck = this.getCvcCheck();
                    String other$cvcCheck = other.getCvcCheck();
                    return !(this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Checks;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $addressLine1Check = this.getAddressLine1Check();
                    result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
                    String $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                    result = result * 59 + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
                    String $cvcCheck = this.getCvcCheck();
                    result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
                    return result;
                }
            }

            public static class GeneratedFrom
            extends StripeObject {
                @SerializedName(value="charge")
                String charge;
                @SerializedName(value="payment_method_details")
                PaymentMethodDetails paymentMethodDetails;
                @SerializedName(value="setup_attempt")
                ExpandableField<SetupAttempt> setupAttempt;

                public String getSetupAttempt() {
                    return this.setupAttempt != null ? this.setupAttempt.getId() : null;
                }

                public void setSetupAttempt(String id) {
                    this.setupAttempt = ApiResource.setExpandableFieldId(id, this.setupAttempt);
                }

                public SetupAttempt getSetupAttemptObject() {
                    return this.setupAttempt != null ? this.setupAttempt.getExpanded() : null;
                }

                public void setSetupAttemptObject(SetupAttempt expandableObject) {
                    this.setupAttempt = new ExpandableField<SetupAttempt>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public String getCharge() {
                    return this.charge;
                }

                @Generated
                public PaymentMethodDetails getPaymentMethodDetails() {
                    return this.paymentMethodDetails;
                }

                @Generated
                public void setCharge(String charge) {
                    this.charge = charge;
                }

                @Generated
                public void setPaymentMethodDetails(PaymentMethodDetails paymentMethodDetails) {
                    this.paymentMethodDetails = paymentMethodDetails;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof GeneratedFrom)) {
                        return false;
                    }
                    GeneratedFrom other = (GeneratedFrom)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$charge = this.getCharge();
                    String other$charge = other.getCharge();
                    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
                        return false;
                    }
                    PaymentMethodDetails this$paymentMethodDetails = this.getPaymentMethodDetails();
                    PaymentMethodDetails other$paymentMethodDetails = other.getPaymentMethodDetails();
                    if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !((Object)this$paymentMethodDetails).equals(other$paymentMethodDetails)) {
                        return false;
                    }
                    String this$setupAttempt = this.getSetupAttempt();
                    String other$setupAttempt = other.getSetupAttempt();
                    return !(this$setupAttempt == null ? other$setupAttempt != null : !this$setupAttempt.equals(other$setupAttempt));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof GeneratedFrom;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $charge = this.getCharge();
                    result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
                    PaymentMethodDetails $paymentMethodDetails = this.getPaymentMethodDetails();
                    result = result * 59 + ($paymentMethodDetails == null ? 43 : ((Object)$paymentMethodDetails).hashCode());
                    String $setupAttempt = this.getSetupAttempt();
                    result = result * 59 + ($setupAttempt == null ? 43 : $setupAttempt.hashCode());
                    return result;
                }

                public static class PaymentMethodDetails
                extends StripeObject {
                    @SerializedName(value="card_present")
                    CardPresent cardPresent;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public CardPresent getCardPresent() {
                        return this.cardPresent;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setCardPresent(CardPresent cardPresent) {
                        this.cardPresent = cardPresent;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof PaymentMethodDetails)) {
                            return false;
                        }
                        PaymentMethodDetails other = (PaymentMethodDetails)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        CardPresent this$cardPresent = this.getCardPresent();
                        CardPresent other$cardPresent = other.getCardPresent();
                        if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof PaymentMethodDetails;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        CardPresent $cardPresent = this.getCardPresent();
                        result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }

                    public static class CardPresent
                    extends StripeObject {
                        @SerializedName(value="amount_authorized")
                        Long amountAuthorized;
                        @SerializedName(value="brand")
                        String brand;
                        @SerializedName(value="brand_product")
                        String brandProduct;
                        @SerializedName(value="capture_before")
                        Long captureBefore;
                        @SerializedName(value="cardholder_name")
                        String cardholderName;
                        @SerializedName(value="country")
                        String country;
                        @SerializedName(value="description")
                        String description;
                        @SerializedName(value="emv_auth_data")
                        String emvAuthData;
                        @SerializedName(value="exp_month")
                        Long expMonth;
                        @SerializedName(value="exp_year")
                        Long expYear;
                        @SerializedName(value="fingerprint")
                        String fingerprint;
                        @SerializedName(value="funding")
                        String funding;
                        @SerializedName(value="generated_card")
                        String generatedCard;
                        @SerializedName(value="iin")
                        String iin;
                        @SerializedName(value="incremental_authorization_supported")
                        Boolean incrementalAuthorizationSupported;
                        @SerializedName(value="issuer")
                        String issuer;
                        @SerializedName(value="last4")
                        String last4;
                        @SerializedName(value="network")
                        String network;
                        @SerializedName(value="network_transaction_id")
                        String networkTransactionId;
                        @SerializedName(value="offline")
                        Offline offline;
                        @SerializedName(value="overcapture_supported")
                        Boolean overcaptureSupported;
                        @SerializedName(value="preferred_locales")
                        List<String> preferredLocales;
                        @SerializedName(value="read_method")
                        String readMethod;
                        @SerializedName(value="receipt")
                        Receipt receipt;
                        @SerializedName(value="wallet")
                        Wallet wallet;

                        @Generated
                        public Long getAmountAuthorized() {
                            return this.amountAuthorized;
                        }

                        @Generated
                        public String getBrand() {
                            return this.brand;
                        }

                        @Generated
                        public String getBrandProduct() {
                            return this.brandProduct;
                        }

                        @Generated
                        public Long getCaptureBefore() {
                            return this.captureBefore;
                        }

                        @Generated
                        public String getCardholderName() {
                            return this.cardholderName;
                        }

                        @Generated
                        public String getCountry() {
                            return this.country;
                        }

                        @Generated
                        public String getDescription() {
                            return this.description;
                        }

                        @Generated
                        public String getEmvAuthData() {
                            return this.emvAuthData;
                        }

                        @Generated
                        public Long getExpMonth() {
                            return this.expMonth;
                        }

                        @Generated
                        public Long getExpYear() {
                            return this.expYear;
                        }

                        @Generated
                        public String getFingerprint() {
                            return this.fingerprint;
                        }

                        @Generated
                        public String getFunding() {
                            return this.funding;
                        }

                        @Generated
                        public String getGeneratedCard() {
                            return this.generatedCard;
                        }

                        @Generated
                        public String getIin() {
                            return this.iin;
                        }

                        @Generated
                        public Boolean getIncrementalAuthorizationSupported() {
                            return this.incrementalAuthorizationSupported;
                        }

                        @Generated
                        public String getIssuer() {
                            return this.issuer;
                        }

                        @Generated
                        public String getLast4() {
                            return this.last4;
                        }

                        @Generated
                        public String getNetwork() {
                            return this.network;
                        }

                        @Generated
                        public String getNetworkTransactionId() {
                            return this.networkTransactionId;
                        }

                        @Generated
                        public Offline getOffline() {
                            return this.offline;
                        }

                        @Generated
                        public Boolean getOvercaptureSupported() {
                            return this.overcaptureSupported;
                        }

                        @Generated
                        public List<String> getPreferredLocales() {
                            return this.preferredLocales;
                        }

                        @Generated
                        public String getReadMethod() {
                            return this.readMethod;
                        }

                        @Generated
                        public Receipt getReceipt() {
                            return this.receipt;
                        }

                        @Generated
                        public Wallet getWallet() {
                            return this.wallet;
                        }

                        @Generated
                        public void setAmountAuthorized(Long amountAuthorized) {
                            this.amountAuthorized = amountAuthorized;
                        }

                        @Generated
                        public void setBrand(String brand) {
                            this.brand = brand;
                        }

                        @Generated
                        public void setBrandProduct(String brandProduct) {
                            this.brandProduct = brandProduct;
                        }

                        @Generated
                        public void setCaptureBefore(Long captureBefore) {
                            this.captureBefore = captureBefore;
                        }

                        @Generated
                        public void setCardholderName(String cardholderName) {
                            this.cardholderName = cardholderName;
                        }

                        @Generated
                        public void setCountry(String country) {
                            this.country = country;
                        }

                        @Generated
                        public void setDescription(String description) {
                            this.description = description;
                        }

                        @Generated
                        public void setEmvAuthData(String emvAuthData) {
                            this.emvAuthData = emvAuthData;
                        }

                        @Generated
                        public void setExpMonth(Long expMonth) {
                            this.expMonth = expMonth;
                        }

                        @Generated
                        public void setExpYear(Long expYear) {
                            this.expYear = expYear;
                        }

                        @Generated
                        public void setFingerprint(String fingerprint) {
                            this.fingerprint = fingerprint;
                        }

                        @Generated
                        public void setFunding(String funding) {
                            this.funding = funding;
                        }

                        @Generated
                        public void setGeneratedCard(String generatedCard) {
                            this.generatedCard = generatedCard;
                        }

                        @Generated
                        public void setIin(String iin) {
                            this.iin = iin;
                        }

                        @Generated
                        public void setIncrementalAuthorizationSupported(Boolean incrementalAuthorizationSupported) {
                            this.incrementalAuthorizationSupported = incrementalAuthorizationSupported;
                        }

                        @Generated
                        public void setIssuer(String issuer) {
                            this.issuer = issuer;
                        }

                        @Generated
                        public void setLast4(String last4) {
                            this.last4 = last4;
                        }

                        @Generated
                        public void setNetwork(String network) {
                            this.network = network;
                        }

                        @Generated
                        public void setNetworkTransactionId(String networkTransactionId) {
                            this.networkTransactionId = networkTransactionId;
                        }

                        @Generated
                        public void setOffline(Offline offline) {
                            this.offline = offline;
                        }

                        @Generated
                        public void setOvercaptureSupported(Boolean overcaptureSupported) {
                            this.overcaptureSupported = overcaptureSupported;
                        }

                        @Generated
                        public void setPreferredLocales(List<String> preferredLocales) {
                            this.preferredLocales = preferredLocales;
                        }

                        @Generated
                        public void setReadMethod(String readMethod) {
                            this.readMethod = readMethod;
                        }

                        @Generated
                        public void setReceipt(Receipt receipt) {
                            this.receipt = receipt;
                        }

                        @Generated
                        public void setWallet(Wallet wallet) {
                            this.wallet = wallet;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof CardPresent)) {
                                return false;
                            }
                            CardPresent other = (CardPresent)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Long this$amountAuthorized = this.getAmountAuthorized();
                            Long other$amountAuthorized = other.getAmountAuthorized();
                            if (this$amountAuthorized == null ? other$amountAuthorized != null : !((Object)this$amountAuthorized).equals(other$amountAuthorized)) {
                                return false;
                            }
                            Long this$captureBefore = this.getCaptureBefore();
                            Long other$captureBefore = other.getCaptureBefore();
                            if (this$captureBefore == null ? other$captureBefore != null : !((Object)this$captureBefore).equals(other$captureBefore)) {
                                return false;
                            }
                            Long this$expMonth = this.getExpMonth();
                            Long other$expMonth = other.getExpMonth();
                            if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                                return false;
                            }
                            Long this$expYear = this.getExpYear();
                            Long other$expYear = other.getExpYear();
                            if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                                return false;
                            }
                            Boolean this$incrementalAuthorizationSupported = this.getIncrementalAuthorizationSupported();
                            Boolean other$incrementalAuthorizationSupported = other.getIncrementalAuthorizationSupported();
                            if (this$incrementalAuthorizationSupported == null ? other$incrementalAuthorizationSupported != null : !((Object)this$incrementalAuthorizationSupported).equals(other$incrementalAuthorizationSupported)) {
                                return false;
                            }
                            Boolean this$overcaptureSupported = this.getOvercaptureSupported();
                            Boolean other$overcaptureSupported = other.getOvercaptureSupported();
                            if (this$overcaptureSupported == null ? other$overcaptureSupported != null : !((Object)this$overcaptureSupported).equals(other$overcaptureSupported)) {
                                return false;
                            }
                            String this$brand = this.getBrand();
                            String other$brand = other.getBrand();
                            if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                                return false;
                            }
                            String this$brandProduct = this.getBrandProduct();
                            String other$brandProduct = other.getBrandProduct();
                            if (this$brandProduct == null ? other$brandProduct != null : !this$brandProduct.equals(other$brandProduct)) {
                                return false;
                            }
                            String this$cardholderName = this.getCardholderName();
                            String other$cardholderName = other.getCardholderName();
                            if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) {
                                return false;
                            }
                            String this$country = this.getCountry();
                            String other$country = other.getCountry();
                            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                                return false;
                            }
                            String this$description = this.getDescription();
                            String other$description = other.getDescription();
                            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                                return false;
                            }
                            String this$emvAuthData = this.getEmvAuthData();
                            String other$emvAuthData = other.getEmvAuthData();
                            if (this$emvAuthData == null ? other$emvAuthData != null : !this$emvAuthData.equals(other$emvAuthData)) {
                                return false;
                            }
                            String this$fingerprint = this.getFingerprint();
                            String other$fingerprint = other.getFingerprint();
                            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                                return false;
                            }
                            String this$funding = this.getFunding();
                            String other$funding = other.getFunding();
                            if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                                return false;
                            }
                            String this$generatedCard = this.getGeneratedCard();
                            String other$generatedCard = other.getGeneratedCard();
                            if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) {
                                return false;
                            }
                            String this$iin = this.getIin();
                            String other$iin = other.getIin();
                            if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                                return false;
                            }
                            String this$issuer = this.getIssuer();
                            String other$issuer = other.getIssuer();
                            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                                return false;
                            }
                            String this$last4 = this.getLast4();
                            String other$last4 = other.getLast4();
                            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                                return false;
                            }
                            String this$network = this.getNetwork();
                            String other$network = other.getNetwork();
                            if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                                return false;
                            }
                            String this$networkTransactionId = this.getNetworkTransactionId();
                            String other$networkTransactionId = other.getNetworkTransactionId();
                            if (this$networkTransactionId == null ? other$networkTransactionId != null : !this$networkTransactionId.equals(other$networkTransactionId)) {
                                return false;
                            }
                            Offline this$offline = this.getOffline();
                            Offline other$offline = other.getOffline();
                            if (this$offline == null ? other$offline != null : !((Object)this$offline).equals(other$offline)) {
                                return false;
                            }
                            List<String> this$preferredLocales = this.getPreferredLocales();
                            List<String> other$preferredLocales = other.getPreferredLocales();
                            if (this$preferredLocales == null ? other$preferredLocales != null : !((Object)this$preferredLocales).equals(other$preferredLocales)) {
                                return false;
                            }
                            String this$readMethod = this.getReadMethod();
                            String other$readMethod = other.getReadMethod();
                            if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) {
                                return false;
                            }
                            Receipt this$receipt = this.getReceipt();
                            Receipt other$receipt = other.getReceipt();
                            if (this$receipt == null ? other$receipt != null : !((Object)this$receipt).equals(other$receipt)) {
                                return false;
                            }
                            Wallet this$wallet = this.getWallet();
                            Wallet other$wallet = other.getWallet();
                            return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof CardPresent;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Long $amountAuthorized = this.getAmountAuthorized();
                            result = result * 59 + ($amountAuthorized == null ? 43 : ((Object)$amountAuthorized).hashCode());
                            Long $captureBefore = this.getCaptureBefore();
                            result = result * 59 + ($captureBefore == null ? 43 : ((Object)$captureBefore).hashCode());
                            Long $expMonth = this.getExpMonth();
                            result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                            Long $expYear = this.getExpYear();
                            result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                            Boolean $incrementalAuthorizationSupported = this.getIncrementalAuthorizationSupported();
                            result = result * 59 + ($incrementalAuthorizationSupported == null ? 43 : ((Object)$incrementalAuthorizationSupported).hashCode());
                            Boolean $overcaptureSupported = this.getOvercaptureSupported();
                            result = result * 59 + ($overcaptureSupported == null ? 43 : ((Object)$overcaptureSupported).hashCode());
                            String $brand = this.getBrand();
                            result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                            String $brandProduct = this.getBrandProduct();
                            result = result * 59 + ($brandProduct == null ? 43 : $brandProduct.hashCode());
                            String $cardholderName = this.getCardholderName();
                            result = result * 59 + ($cardholderName == null ? 43 : $cardholderName.hashCode());
                            String $country = this.getCountry();
                            result = result * 59 + ($country == null ? 43 : $country.hashCode());
                            String $description = this.getDescription();
                            result = result * 59 + ($description == null ? 43 : $description.hashCode());
                            String $emvAuthData = this.getEmvAuthData();
                            result = result * 59 + ($emvAuthData == null ? 43 : $emvAuthData.hashCode());
                            String $fingerprint = this.getFingerprint();
                            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                            String $funding = this.getFunding();
                            result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                            String $generatedCard = this.getGeneratedCard();
                            result = result * 59 + ($generatedCard == null ? 43 : $generatedCard.hashCode());
                            String $iin = this.getIin();
                            result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
                            String $issuer = this.getIssuer();
                            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
                            String $last4 = this.getLast4();
                            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                            String $network = this.getNetwork();
                            result = result * 59 + ($network == null ? 43 : $network.hashCode());
                            String $networkTransactionId = this.getNetworkTransactionId();
                            result = result * 59 + ($networkTransactionId == null ? 43 : $networkTransactionId.hashCode());
                            Offline $offline = this.getOffline();
                            result = result * 59 + ($offline == null ? 43 : ((Object)$offline).hashCode());
                            List<String> $preferredLocales = this.getPreferredLocales();
                            result = result * 59 + ($preferredLocales == null ? 43 : ((Object)$preferredLocales).hashCode());
                            String $readMethod = this.getReadMethod();
                            result = result * 59 + ($readMethod == null ? 43 : $readMethod.hashCode());
                            Receipt $receipt = this.getReceipt();
                            result = result * 59 + ($receipt == null ? 43 : ((Object)$receipt).hashCode());
                            Wallet $wallet = this.getWallet();
                            result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
                            return result;
                        }

                        public static class Offline
                        extends StripeObject {
                            @SerializedName(value="stored_at")
                            Long storedAt;
                            @SerializedName(value="type")
                            String type;

                            @Generated
                            public Long getStoredAt() {
                                return this.storedAt;
                            }

                            @Generated
                            public String getType() {
                                return this.type;
                            }

                            @Generated
                            public void setStoredAt(Long storedAt) {
                                this.storedAt = storedAt;
                            }

                            @Generated
                            public void setType(String type) {
                                this.type = type;
                            }

                            @Generated
                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Offline)) {
                                    return false;
                                }
                                Offline other = (Offline)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                Long this$storedAt = this.getStoredAt();
                                Long other$storedAt = other.getStoredAt();
                                if (this$storedAt == null ? other$storedAt != null : !((Object)this$storedAt).equals(other$storedAt)) {
                                    return false;
                                }
                                String this$type = this.getType();
                                String other$type = other.getType();
                                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                            }

                            @Generated
                            protected boolean canEqual(Object other) {
                                return other instanceof Offline;
                            }

                            @Generated
                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                Long $storedAt = this.getStoredAt();
                                result = result * 59 + ($storedAt == null ? 43 : ((Object)$storedAt).hashCode());
                                String $type = this.getType();
                                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                                return result;
                            }
                        }

                        public static class Receipt
                        extends StripeObject {
                            @SerializedName(value="account_type")
                            String accountType;
                            @SerializedName(value="application_cryptogram")
                            String applicationCryptogram;
                            @SerializedName(value="application_preferred_name")
                            String applicationPreferredName;
                            @SerializedName(value="authorization_code")
                            String authorizationCode;
                            @SerializedName(value="authorization_response_code")
                            String authorizationResponseCode;
                            @SerializedName(value="cardholder_verification_method")
                            String cardholderVerificationMethod;
                            @SerializedName(value="dedicated_file_name")
                            String dedicatedFileName;
                            @SerializedName(value="terminal_verification_results")
                            String terminalVerificationResults;
                            @SerializedName(value="transaction_status_information")
                            String transactionStatusInformation;

                            @Generated
                            public String getAccountType() {
                                return this.accountType;
                            }

                            @Generated
                            public String getApplicationCryptogram() {
                                return this.applicationCryptogram;
                            }

                            @Generated
                            public String getApplicationPreferredName() {
                                return this.applicationPreferredName;
                            }

                            @Generated
                            public String getAuthorizationCode() {
                                return this.authorizationCode;
                            }

                            @Generated
                            public String getAuthorizationResponseCode() {
                                return this.authorizationResponseCode;
                            }

                            @Generated
                            public String getCardholderVerificationMethod() {
                                return this.cardholderVerificationMethod;
                            }

                            @Generated
                            public String getDedicatedFileName() {
                                return this.dedicatedFileName;
                            }

                            @Generated
                            public String getTerminalVerificationResults() {
                                return this.terminalVerificationResults;
                            }

                            @Generated
                            public String getTransactionStatusInformation() {
                                return this.transactionStatusInformation;
                            }

                            @Generated
                            public void setAccountType(String accountType) {
                                this.accountType = accountType;
                            }

                            @Generated
                            public void setApplicationCryptogram(String applicationCryptogram) {
                                this.applicationCryptogram = applicationCryptogram;
                            }

                            @Generated
                            public void setApplicationPreferredName(String applicationPreferredName) {
                                this.applicationPreferredName = applicationPreferredName;
                            }

                            @Generated
                            public void setAuthorizationCode(String authorizationCode) {
                                this.authorizationCode = authorizationCode;
                            }

                            @Generated
                            public void setAuthorizationResponseCode(String authorizationResponseCode) {
                                this.authorizationResponseCode = authorizationResponseCode;
                            }

                            @Generated
                            public void setCardholderVerificationMethod(String cardholderVerificationMethod) {
                                this.cardholderVerificationMethod = cardholderVerificationMethod;
                            }

                            @Generated
                            public void setDedicatedFileName(String dedicatedFileName) {
                                this.dedicatedFileName = dedicatedFileName;
                            }

                            @Generated
                            public void setTerminalVerificationResults(String terminalVerificationResults) {
                                this.terminalVerificationResults = terminalVerificationResults;
                            }

                            @Generated
                            public void setTransactionStatusInformation(String transactionStatusInformation) {
                                this.transactionStatusInformation = transactionStatusInformation;
                            }

                            @Generated
                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Receipt)) {
                                    return false;
                                }
                                Receipt other = (Receipt)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                String this$accountType = this.getAccountType();
                                String other$accountType = other.getAccountType();
                                if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                                    return false;
                                }
                                String this$applicationCryptogram = this.getApplicationCryptogram();
                                String other$applicationCryptogram = other.getApplicationCryptogram();
                                if (this$applicationCryptogram == null ? other$applicationCryptogram != null : !this$applicationCryptogram.equals(other$applicationCryptogram)) {
                                    return false;
                                }
                                String this$applicationPreferredName = this.getApplicationPreferredName();
                                String other$applicationPreferredName = other.getApplicationPreferredName();
                                if (this$applicationPreferredName == null ? other$applicationPreferredName != null : !this$applicationPreferredName.equals(other$applicationPreferredName)) {
                                    return false;
                                }
                                String this$authorizationCode = this.getAuthorizationCode();
                                String other$authorizationCode = other.getAuthorizationCode();
                                if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
                                    return false;
                                }
                                String this$authorizationResponseCode = this.getAuthorizationResponseCode();
                                String other$authorizationResponseCode = other.getAuthorizationResponseCode();
                                if (this$authorizationResponseCode == null ? other$authorizationResponseCode != null : !this$authorizationResponseCode.equals(other$authorizationResponseCode)) {
                                    return false;
                                }
                                String this$cardholderVerificationMethod = this.getCardholderVerificationMethod();
                                String other$cardholderVerificationMethod = other.getCardholderVerificationMethod();
                                if (this$cardholderVerificationMethod == null ? other$cardholderVerificationMethod != null : !this$cardholderVerificationMethod.equals(other$cardholderVerificationMethod)) {
                                    return false;
                                }
                                String this$dedicatedFileName = this.getDedicatedFileName();
                                String other$dedicatedFileName = other.getDedicatedFileName();
                                if (this$dedicatedFileName == null ? other$dedicatedFileName != null : !this$dedicatedFileName.equals(other$dedicatedFileName)) {
                                    return false;
                                }
                                String this$terminalVerificationResults = this.getTerminalVerificationResults();
                                String other$terminalVerificationResults = other.getTerminalVerificationResults();
                                if (this$terminalVerificationResults == null ? other$terminalVerificationResults != null : !this$terminalVerificationResults.equals(other$terminalVerificationResults)) {
                                    return false;
                                }
                                String this$transactionStatusInformation = this.getTransactionStatusInformation();
                                String other$transactionStatusInformation = other.getTransactionStatusInformation();
                                return !(this$transactionStatusInformation == null ? other$transactionStatusInformation != null : !this$transactionStatusInformation.equals(other$transactionStatusInformation));
                            }

                            @Generated
                            protected boolean canEqual(Object other) {
                                return other instanceof Receipt;
                            }

                            @Generated
                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                String $accountType = this.getAccountType();
                                result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                                String $applicationCryptogram = this.getApplicationCryptogram();
                                result = result * 59 + ($applicationCryptogram == null ? 43 : $applicationCryptogram.hashCode());
                                String $applicationPreferredName = this.getApplicationPreferredName();
                                result = result * 59 + ($applicationPreferredName == null ? 43 : $applicationPreferredName.hashCode());
                                String $authorizationCode = this.getAuthorizationCode();
                                result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
                                String $authorizationResponseCode = this.getAuthorizationResponseCode();
                                result = result * 59 + ($authorizationResponseCode == null ? 43 : $authorizationResponseCode.hashCode());
                                String $cardholderVerificationMethod = this.getCardholderVerificationMethod();
                                result = result * 59 + ($cardholderVerificationMethod == null ? 43 : $cardholderVerificationMethod.hashCode());
                                String $dedicatedFileName = this.getDedicatedFileName();
                                result = result * 59 + ($dedicatedFileName == null ? 43 : $dedicatedFileName.hashCode());
                                String $terminalVerificationResults = this.getTerminalVerificationResults();
                                result = result * 59 + ($terminalVerificationResults == null ? 43 : $terminalVerificationResults.hashCode());
                                String $transactionStatusInformation = this.getTransactionStatusInformation();
                                result = result * 59 + ($transactionStatusInformation == null ? 43 : $transactionStatusInformation.hashCode());
                                return result;
                            }
                        }

                        public static class Wallet
                        extends StripeObject {
                            @SerializedName(value="type")
                            String type;

                            @Generated
                            public String getType() {
                                return this.type;
                            }

                            @Generated
                            public void setType(String type) {
                                this.type = type;
                            }

                            @Generated
                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Wallet)) {
                                    return false;
                                }
                                Wallet other = (Wallet)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                String this$type = this.getType();
                                String other$type = other.getType();
                                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                            }

                            @Generated
                            protected boolean canEqual(Object other) {
                                return other instanceof Wallet;
                            }

                            @Generated
                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                String $type = this.getType();
                                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                                return result;
                            }
                        }
                    }
                }
            }

            public static class Networks
            extends StripeObject {
                @SerializedName(value="available")
                List<String> available;
                @SerializedName(value="preferred")
                String preferred;

                @Generated
                public List<String> getAvailable() {
                    return this.available;
                }

                @Generated
                public String getPreferred() {
                    return this.preferred;
                }

                @Generated
                public void setAvailable(List<String> available) {
                    this.available = available;
                }

                @Generated
                public void setPreferred(String preferred) {
                    this.preferred = preferred;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Networks)) {
                        return false;
                    }
                    Networks other = (Networks)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<String> this$available = this.getAvailable();
                    List<String> other$available = other.getAvailable();
                    if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                        return false;
                    }
                    String this$preferred = this.getPreferred();
                    String other$preferred = other.getPreferred();
                    return !(this$preferred == null ? other$preferred != null : !this$preferred.equals(other$preferred));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Networks;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<String> $available = this.getAvailable();
                    result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
                    String $preferred = this.getPreferred();
                    result = result * 59 + ($preferred == null ? 43 : $preferred.hashCode());
                    return result;
                }
            }

            public static class ThreeDSecureUsage
            extends StripeObject {
                @SerializedName(value="supported")
                Boolean supported;

                @Generated
                public Boolean getSupported() {
                    return this.supported;
                }

                @Generated
                public void setSupported(Boolean supported) {
                    this.supported = supported;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ThreeDSecureUsage)) {
                        return false;
                    }
                    ThreeDSecureUsage other = (ThreeDSecureUsage)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$supported = this.getSupported();
                    Boolean other$supported = other.getSupported();
                    return !(this$supported == null ? other$supported != null : !((Object)this$supported).equals(other$supported));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ThreeDSecureUsage;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $supported = this.getSupported();
                    result = result * 59 + ($supported == null ? 43 : ((Object)$supported).hashCode());
                    return result;
                }
            }

            public static class Wallet
            extends StripeObject {
                @SerializedName(value="amex_express_checkout")
                AmexExpressCheckout amexExpressCheckout;
                @SerializedName(value="apple_pay")
                ApplePay applePay;
                @SerializedName(value="dynamic_last4")
                String dynamicLast4;
                @SerializedName(value="google_pay")
                GooglePay googlePay;
                @SerializedName(value="link")
                Link link;
                @SerializedName(value="masterpass")
                Masterpass masterpass;
                @SerializedName(value="samsung_pay")
                SamsungPay samsungPay;
                @SerializedName(value="type")
                String type;
                @SerializedName(value="visa_checkout")
                VisaCheckout visaCheckout;

                @Generated
                public AmexExpressCheckout getAmexExpressCheckout() {
                    return this.amexExpressCheckout;
                }

                @Generated
                public ApplePay getApplePay() {
                    return this.applePay;
                }

                @Generated
                public String getDynamicLast4() {
                    return this.dynamicLast4;
                }

                @Generated
                public GooglePay getGooglePay() {
                    return this.googlePay;
                }

                @Generated
                public Link getLink() {
                    return this.link;
                }

                @Generated
                public Masterpass getMasterpass() {
                    return this.masterpass;
                }

                @Generated
                public SamsungPay getSamsungPay() {
                    return this.samsungPay;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public VisaCheckout getVisaCheckout() {
                    return this.visaCheckout;
                }

                @Generated
                public void setAmexExpressCheckout(AmexExpressCheckout amexExpressCheckout) {
                    this.amexExpressCheckout = amexExpressCheckout;
                }

                @Generated
                public void setApplePay(ApplePay applePay) {
                    this.applePay = applePay;
                }

                @Generated
                public void setDynamicLast4(String dynamicLast4) {
                    this.dynamicLast4 = dynamicLast4;
                }

                @Generated
                public void setGooglePay(GooglePay googlePay) {
                    this.googlePay = googlePay;
                }

                @Generated
                public void setLink(Link link) {
                    this.link = link;
                }

                @Generated
                public void setMasterpass(Masterpass masterpass) {
                    this.masterpass = masterpass;
                }

                @Generated
                public void setSamsungPay(SamsungPay samsungPay) {
                    this.samsungPay = samsungPay;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public void setVisaCheckout(VisaCheckout visaCheckout) {
                    this.visaCheckout = visaCheckout;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Wallet)) {
                        return false;
                    }
                    Wallet other = (Wallet)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    AmexExpressCheckout this$amexExpressCheckout = this.getAmexExpressCheckout();
                    AmexExpressCheckout other$amexExpressCheckout = other.getAmexExpressCheckout();
                    if (this$amexExpressCheckout == null ? other$amexExpressCheckout != null : !((Object)this$amexExpressCheckout).equals(other$amexExpressCheckout)) {
                        return false;
                    }
                    ApplePay this$applePay = this.getApplePay();
                    ApplePay other$applePay = other.getApplePay();
                    if (this$applePay == null ? other$applePay != null : !((Object)this$applePay).equals(other$applePay)) {
                        return false;
                    }
                    String this$dynamicLast4 = this.getDynamicLast4();
                    String other$dynamicLast4 = other.getDynamicLast4();
                    if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) {
                        return false;
                    }
                    GooglePay this$googlePay = this.getGooglePay();
                    GooglePay other$googlePay = other.getGooglePay();
                    if (this$googlePay == null ? other$googlePay != null : !((Object)this$googlePay).equals(other$googlePay)) {
                        return false;
                    }
                    Link this$link = this.getLink();
                    Link other$link = other.getLink();
                    if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                        return false;
                    }
                    Masterpass this$masterpass = this.getMasterpass();
                    Masterpass other$masterpass = other.getMasterpass();
                    if (this$masterpass == null ? other$masterpass != null : !((Object)this$masterpass).equals(other$masterpass)) {
                        return false;
                    }
                    SamsungPay this$samsungPay = this.getSamsungPay();
                    SamsungPay other$samsungPay = other.getSamsungPay();
                    if (this$samsungPay == null ? other$samsungPay != null : !((Object)this$samsungPay).equals(other$samsungPay)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                        return false;
                    }
                    VisaCheckout this$visaCheckout = this.getVisaCheckout();
                    VisaCheckout other$visaCheckout = other.getVisaCheckout();
                    return !(this$visaCheckout == null ? other$visaCheckout != null : !((Object)this$visaCheckout).equals(other$visaCheckout));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Wallet;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    AmexExpressCheckout $amexExpressCheckout = this.getAmexExpressCheckout();
                    result = result * 59 + ($amexExpressCheckout == null ? 43 : ((Object)$amexExpressCheckout).hashCode());
                    ApplePay $applePay = this.getApplePay();
                    result = result * 59 + ($applePay == null ? 43 : ((Object)$applePay).hashCode());
                    String $dynamicLast4 = this.getDynamicLast4();
                    result = result * 59 + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
                    GooglePay $googlePay = this.getGooglePay();
                    result = result * 59 + ($googlePay == null ? 43 : ((Object)$googlePay).hashCode());
                    Link $link = this.getLink();
                    result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
                    Masterpass $masterpass = this.getMasterpass();
                    result = result * 59 + ($masterpass == null ? 43 : ((Object)$masterpass).hashCode());
                    SamsungPay $samsungPay = this.getSamsungPay();
                    result = result * 59 + ($samsungPay == null ? 43 : ((Object)$samsungPay).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    VisaCheckout $visaCheckout = this.getVisaCheckout();
                    result = result * 59 + ($visaCheckout == null ? 43 : ((Object)$visaCheckout).hashCode());
                    return result;
                }

                public static class AmexExpressCheckout
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof AmexExpressCheckout)) {
                            return false;
                        }
                        AmexExpressCheckout other = (AmexExpressCheckout)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof AmexExpressCheckout;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }

                public static class ApplePay
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ApplePay)) {
                            return false;
                        }
                        ApplePay other = (ApplePay)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof ApplePay;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }

                public static class GooglePay
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof GooglePay)) {
                            return false;
                        }
                        GooglePay other = (GooglePay)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof GooglePay;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }

                public static class Link
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Link)) {
                            return false;
                        }
                        Link other = (Link)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Link;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }

                public static class Masterpass
                extends StripeObject {
                    @SerializedName(value="billing_address")
                    Address billingAddress;
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="shipping_address")
                    Address shippingAddress;

                    @Generated
                    public Address getBillingAddress() {
                        return this.billingAddress;
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public Address getShippingAddress() {
                        return this.shippingAddress;
                    }

                    @Generated
                    public void setBillingAddress(Address billingAddress) {
                        this.billingAddress = billingAddress;
                    }

                    @Generated
                    public void setEmail(String email) {
                        this.email = email;
                    }

                    @Generated
                    public void setName(String name) {
                        this.name = name;
                    }

                    @Generated
                    public void setShippingAddress(Address shippingAddress) {
                        this.shippingAddress = shippingAddress;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Masterpass)) {
                            return false;
                        }
                        Masterpass other = (Masterpass)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Address this$billingAddress = this.getBillingAddress();
                        Address other$billingAddress = other.getBillingAddress();
                        if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
                            return false;
                        }
                        String this$email = this.getEmail();
                        String other$email = other.getEmail();
                        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                            return false;
                        }
                        String this$name = this.getName();
                        String other$name = other.getName();
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        Address this$shippingAddress = this.getShippingAddress();
                        Address other$shippingAddress = other.getShippingAddress();
                        return !(this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Masterpass;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Address $billingAddress = this.getBillingAddress();
                        result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
                        String $email = this.getEmail();
                        result = result * 59 + ($email == null ? 43 : $email.hashCode());
                        String $name = this.getName();
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        Address $shippingAddress = this.getShippingAddress();
                        result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
                        return result;
                    }
                }

                public static class SamsungPay
                extends StripeObject {
                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof SamsungPay)) {
                            return false;
                        }
                        SamsungPay other = (SamsungPay)o;
                        return other.canEqual(this);
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof SamsungPay;
                    }

                    @Generated
                    public int hashCode() {
                        boolean result = true;
                        return 1;
                    }
                }

                public static class VisaCheckout
                extends StripeObject {
                    @SerializedName(value="billing_address")
                    Address billingAddress;
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="shipping_address")
                    Address shippingAddress;

                    @Generated
                    public Address getBillingAddress() {
                        return this.billingAddress;
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public Address getShippingAddress() {
                        return this.shippingAddress;
                    }

                    @Generated
                    public void setBillingAddress(Address billingAddress) {
                        this.billingAddress = billingAddress;
                    }

                    @Generated
                    public void setEmail(String email) {
                        this.email = email;
                    }

                    @Generated
                    public void setName(String name) {
                        this.name = name;
                    }

                    @Generated
                    public void setShippingAddress(Address shippingAddress) {
                        this.shippingAddress = shippingAddress;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof VisaCheckout)) {
                            return false;
                        }
                        VisaCheckout other = (VisaCheckout)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Address this$billingAddress = this.getBillingAddress();
                        Address other$billingAddress = other.getBillingAddress();
                        if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
                            return false;
                        }
                        String this$email = this.getEmail();
                        String other$email = other.getEmail();
                        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                            return false;
                        }
                        String this$name = this.getName();
                        String other$name = other.getName();
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        Address this$shippingAddress = this.getShippingAddress();
                        Address other$shippingAddress = other.getShippingAddress();
                        return !(this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof VisaCheckout;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Address $billingAddress = this.getBillingAddress();
                        result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
                        String $email = this.getEmail();
                        result = result * 59 + ($email == null ? 43 : $email.hashCode());
                        String $name = this.getName();
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        Address $shippingAddress = this.getShippingAddress();
                        result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
                        return result;
                    }
                }
            }
        }

        public static class CardPresent
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="brand_product")
            String brandProduct;
            @SerializedName(value="cardholder_name")
            String cardholderName;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="iin")
            String iin;
            @SerializedName(value="issuer")
            String issuer;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="networks")
            Networks networks;
            @SerializedName(value="offline")
            Offline offline;
            @SerializedName(value="preferred_locales")
            List<String> preferredLocales;
            @SerializedName(value="read_method")
            String readMethod;
            @SerializedName(value="wallet")
            Wallet wallet;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public String getBrandProduct() {
                return this.brandProduct;
            }

            @Generated
            public String getCardholderName() {
                return this.cardholderName;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public String getIin() {
                return this.iin;
            }

            @Generated
            public String getIssuer() {
                return this.issuer;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public Networks getNetworks() {
                return this.networks;
            }

            @Generated
            public Offline getOffline() {
                return this.offline;
            }

            @Generated
            public List<String> getPreferredLocales() {
                return this.preferredLocales;
            }

            @Generated
            public String getReadMethod() {
                return this.readMethod;
            }

            @Generated
            public Wallet getWallet() {
                return this.wallet;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setBrandProduct(String brandProduct) {
                this.brandProduct = brandProduct;
            }

            @Generated
            public void setCardholderName(String cardholderName) {
                this.cardholderName = cardholderName;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setIin(String iin) {
                this.iin = iin;
            }

            @Generated
            public void setIssuer(String issuer) {
                this.issuer = issuer;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetworks(Networks networks) {
                this.networks = networks;
            }

            @Generated
            public void setOffline(Offline offline) {
                this.offline = offline;
            }

            @Generated
            public void setPreferredLocales(List<String> preferredLocales) {
                this.preferredLocales = preferredLocales;
            }

            @Generated
            public void setReadMethod(String readMethod) {
                this.readMethod = readMethod;
            }

            @Generated
            public void setWallet(Wallet wallet) {
                this.wallet = wallet;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardPresent)) {
                    return false;
                }
                CardPresent other = (CardPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                String this$brandProduct = this.getBrandProduct();
                String other$brandProduct = other.getBrandProduct();
                if (this$brandProduct == null ? other$brandProduct != null : !this$brandProduct.equals(other$brandProduct)) {
                    return false;
                }
                String this$cardholderName = this.getCardholderName();
                String other$cardholderName = other.getCardholderName();
                if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                String this$iin = this.getIin();
                String other$iin = other.getIin();
                if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                    return false;
                }
                String this$issuer = this.getIssuer();
                String other$issuer = other.getIssuer();
                if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                Networks this$networks = this.getNetworks();
                Networks other$networks = other.getNetworks();
                if (this$networks == null ? other$networks != null : !((Object)this$networks).equals(other$networks)) {
                    return false;
                }
                Offline this$offline = this.getOffline();
                Offline other$offline = other.getOffline();
                if (this$offline == null ? other$offline != null : !((Object)this$offline).equals(other$offline)) {
                    return false;
                }
                List<String> this$preferredLocales = this.getPreferredLocales();
                List<String> other$preferredLocales = other.getPreferredLocales();
                if (this$preferredLocales == null ? other$preferredLocales != null : !((Object)this$preferredLocales).equals(other$preferredLocales)) {
                    return false;
                }
                String this$readMethod = this.getReadMethod();
                String other$readMethod = other.getReadMethod();
                if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) {
                    return false;
                }
                Wallet this$wallet = this.getWallet();
                Wallet other$wallet = other.getWallet();
                return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                String $brandProduct = this.getBrandProduct();
                result = result * 59 + ($brandProduct == null ? 43 : $brandProduct.hashCode());
                String $cardholderName = this.getCardholderName();
                result = result * 59 + ($cardholderName == null ? 43 : $cardholderName.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                String $iin = this.getIin();
                result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
                String $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                Networks $networks = this.getNetworks();
                result = result * 59 + ($networks == null ? 43 : ((Object)$networks).hashCode());
                Offline $offline = this.getOffline();
                result = result * 59 + ($offline == null ? 43 : ((Object)$offline).hashCode());
                List<String> $preferredLocales = this.getPreferredLocales();
                result = result * 59 + ($preferredLocales == null ? 43 : ((Object)$preferredLocales).hashCode());
                String $readMethod = this.getReadMethod();
                result = result * 59 + ($readMethod == null ? 43 : $readMethod.hashCode());
                Wallet $wallet = this.getWallet();
                result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
                return result;
            }

            public static class Networks
            extends StripeObject {
                @SerializedName(value="available")
                List<String> available;
                @SerializedName(value="preferred")
                String preferred;

                @Generated
                public List<String> getAvailable() {
                    return this.available;
                }

                @Generated
                public String getPreferred() {
                    return this.preferred;
                }

                @Generated
                public void setAvailable(List<String> available) {
                    this.available = available;
                }

                @Generated
                public void setPreferred(String preferred) {
                    this.preferred = preferred;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Networks)) {
                        return false;
                    }
                    Networks other = (Networks)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<String> this$available = this.getAvailable();
                    List<String> other$available = other.getAvailable();
                    if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                        return false;
                    }
                    String this$preferred = this.getPreferred();
                    String other$preferred = other.getPreferred();
                    return !(this$preferred == null ? other$preferred != null : !this$preferred.equals(other$preferred));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Networks;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<String> $available = this.getAvailable();
                    result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
                    String $preferred = this.getPreferred();
                    result = result * 59 + ($preferred == null ? 43 : $preferred.hashCode());
                    return result;
                }
            }

            public static class Offline
            extends StripeObject {
                @SerializedName(value="stored_at")
                Long storedAt;
                @SerializedName(value="type")
                String type;

                @Generated
                public Long getStoredAt() {
                    return this.storedAt;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setStoredAt(Long storedAt) {
                    this.storedAt = storedAt;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Offline)) {
                        return false;
                    }
                    Offline other = (Offline)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$storedAt = this.getStoredAt();
                    Long other$storedAt = other.getStoredAt();
                    if (this$storedAt == null ? other$storedAt != null : !((Object)this$storedAt).equals(other$storedAt)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Offline;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $storedAt = this.getStoredAt();
                    result = result * 59 + ($storedAt == null ? 43 : ((Object)$storedAt).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }

            public static class Wallet
            extends StripeObject {
                @SerializedName(value="type")
                String type;

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Wallet)) {
                        return false;
                    }
                    Wallet other = (Wallet)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Wallet;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class Cashapp
        extends StripeObject {
            @SerializedName(value="buyer_id")
            String buyerId;
            @SerializedName(value="cashtag")
            String cashtag;

            @Generated
            public String getBuyerId() {
                return this.buyerId;
            }

            @Generated
            public String getCashtag() {
                return this.cashtag;
            }

            @Generated
            public void setBuyerId(String buyerId) {
                this.buyerId = buyerId;
            }

            @Generated
            public void setCashtag(String cashtag) {
                this.cashtag = cashtag;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cashapp)) {
                    return false;
                }
                Cashapp other = (Cashapp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$buyerId = this.getBuyerId();
                String other$buyerId = other.getBuyerId();
                if (this$buyerId == null ? other$buyerId != null : !this$buyerId.equals(other$buyerId)) {
                    return false;
                }
                String this$cashtag = this.getCashtag();
                String other$cashtag = other.getCashtag();
                return !(this$cashtag == null ? other$cashtag != null : !this$cashtag.equals(other$cashtag));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cashapp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $buyerId = this.getBuyerId();
                result = result * 59 + ($buyerId == null ? 43 : $buyerId.hashCode());
                String $cashtag = this.getCashtag();
                result = result * 59 + ($cashtag == null ? 43 : $cashtag.hashCode());
                return result;
            }
        }

        public static class CustomerBalance
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CustomerBalance)) {
                    return false;
                }
                CustomerBalance other = (CustomerBalance)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CustomerBalance;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Eps
        extends StripeObject {
            @SerializedName(value="bank")
            String bank;

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eps)) {
                    return false;
                }
                Eps other = (Eps)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                return !(this$bank == null ? other$bank != null : !this$bank.equals(other$bank));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eps;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                return result;
            }
        }

        public static class Fpx
        extends StripeObject {
            @SerializedName(value="account_holder_type")
            String accountHolderType;
            @SerializedName(value="bank")
            String bank;

            @Generated
            public String getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public void setAccountHolderType(String accountHolderType) {
                this.accountHolderType = accountHolderType;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fpx)) {
                    return false;
                }
                Fpx other = (Fpx)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderType = this.getAccountHolderType();
                String other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                return !(this$bank == null ? other$bank != null : !this$bank.equals(other$bank));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fpx;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                return result;
            }
        }

        public static class Giropay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Giropay)) {
                    return false;
                }
                Giropay other = (Giropay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Giropay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Grabpay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Grabpay)) {
                    return false;
                }
                Grabpay other = (Grabpay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Grabpay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Ideal
        extends StripeObject {
            @SerializedName(value="bank")
            String bank;
            @SerializedName(value="bic")
            String bic;

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ideal)) {
                    return false;
                }
                Ideal other = (Ideal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                return !(this$bic == null ? other$bic != null : !this$bic.equals(other$bic));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ideal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                return result;
            }
        }

        public static class InteracPresent
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="cardholder_name")
            String cardholderName;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="iin")
            String iin;
            @SerializedName(value="issuer")
            String issuer;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="networks")
            Networks networks;
            @SerializedName(value="preferred_locales")
            List<String> preferredLocales;
            @SerializedName(value="read_method")
            String readMethod;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public String getCardholderName() {
                return this.cardholderName;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public String getIin() {
                return this.iin;
            }

            @Generated
            public String getIssuer() {
                return this.issuer;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public Networks getNetworks() {
                return this.networks;
            }

            @Generated
            public List<String> getPreferredLocales() {
                return this.preferredLocales;
            }

            @Generated
            public String getReadMethod() {
                return this.readMethod;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setCardholderName(String cardholderName) {
                this.cardholderName = cardholderName;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setIin(String iin) {
                this.iin = iin;
            }

            @Generated
            public void setIssuer(String issuer) {
                this.issuer = issuer;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetworks(Networks networks) {
                this.networks = networks;
            }

            @Generated
            public void setPreferredLocales(List<String> preferredLocales) {
                this.preferredLocales = preferredLocales;
            }

            @Generated
            public void setReadMethod(String readMethod) {
                this.readMethod = readMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InteracPresent)) {
                    return false;
                }
                InteracPresent other = (InteracPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                String this$cardholderName = this.getCardholderName();
                String other$cardholderName = other.getCardholderName();
                if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                String this$iin = this.getIin();
                String other$iin = other.getIin();
                if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                    return false;
                }
                String this$issuer = this.getIssuer();
                String other$issuer = other.getIssuer();
                if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                Networks this$networks = this.getNetworks();
                Networks other$networks = other.getNetworks();
                if (this$networks == null ? other$networks != null : !((Object)this$networks).equals(other$networks)) {
                    return false;
                }
                List<String> this$preferredLocales = this.getPreferredLocales();
                List<String> other$preferredLocales = other.getPreferredLocales();
                if (this$preferredLocales == null ? other$preferredLocales != null : !((Object)this$preferredLocales).equals(other$preferredLocales)) {
                    return false;
                }
                String this$readMethod = this.getReadMethod();
                String other$readMethod = other.getReadMethod();
                return !(this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InteracPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                String $cardholderName = this.getCardholderName();
                result = result * 59 + ($cardholderName == null ? 43 : $cardholderName.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                String $iin = this.getIin();
                result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
                String $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                Networks $networks = this.getNetworks();
                result = result * 59 + ($networks == null ? 43 : ((Object)$networks).hashCode());
                List<String> $preferredLocales = this.getPreferredLocales();
                result = result * 59 + ($preferredLocales == null ? 43 : ((Object)$preferredLocales).hashCode());
                String $readMethod = this.getReadMethod();
                result = result * 59 + ($readMethod == null ? 43 : $readMethod.hashCode());
                return result;
            }

            public static class Networks
            extends StripeObject {
                @SerializedName(value="available")
                List<String> available;
                @SerializedName(value="preferred")
                String preferred;

                @Generated
                public List<String> getAvailable() {
                    return this.available;
                }

                @Generated
                public String getPreferred() {
                    return this.preferred;
                }

                @Generated
                public void setAvailable(List<String> available) {
                    this.available = available;
                }

                @Generated
                public void setPreferred(String preferred) {
                    this.preferred = preferred;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Networks)) {
                        return false;
                    }
                    Networks other = (Networks)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<String> this$available = this.getAvailable();
                    List<String> other$available = other.getAvailable();
                    if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                        return false;
                    }
                    String this$preferred = this.getPreferred();
                    String other$preferred = other.getPreferred();
                    return !(this$preferred == null ? other$preferred != null : !this$preferred.equals(other$preferred));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Networks;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<String> $available = this.getAvailable();
                    result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
                    String $preferred = this.getPreferred();
                    result = result * 59 + ($preferred == null ? 43 : $preferred.hashCode());
                    return result;
                }
            }
        }

        public static class KakaoPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KakaoPay)) {
                    return false;
                }
                KakaoPay other = (KakaoPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KakaoPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Klarna
        extends StripeObject {
            @SerializedName(value="dob")
            Dob dob;

            @Generated
            public Dob getDob() {
                return this.dob;
            }

            @Generated
            public void setDob(Dob dob) {
                this.dob = dob;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Dob this$dob = this.getDob();
                Dob other$dob = other.getDob();
                return !(this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Dob $dob = this.getDob();
                result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
                return result;
            }

            public static class Dob
            extends StripeObject {
                @SerializedName(value="day")
                Long day;
                @SerializedName(value="month")
                Long month;
                @SerializedName(value="year")
                Long year;

                @Generated
                public Long getDay() {
                    return this.day;
                }

                @Generated
                public Long getMonth() {
                    return this.month;
                }

                @Generated
                public Long getYear() {
                    return this.year;
                }

                @Generated
                public void setDay(Long day) {
                    this.day = day;
                }

                @Generated
                public void setMonth(Long month) {
                    this.month = month;
                }

                @Generated
                public void setYear(Long year) {
                    this.year = year;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Dob)) {
                        return false;
                    }
                    Dob other = (Dob)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$day = this.getDay();
                    Long other$day = other.getDay();
                    if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                        return false;
                    }
                    Long this$month = this.getMonth();
                    Long other$month = other.getMonth();
                    if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                        return false;
                    }
                    Long this$year = this.getYear();
                    Long other$year = other.getYear();
                    return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Dob;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $day = this.getDay();
                    result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                    Long $month = this.getMonth();
                    result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                    Long $year = this.getYear();
                    result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                    return result;
                }
            }
        }

        public static class Konbini
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Konbini)) {
                    return false;
                }
                Konbini other = (Konbini)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Konbini;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class KrCard
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="last4")
            String last4;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KrCard)) {
                    return false;
                }
                KrCard other = (KrCard)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KrCard;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                return result;
            }
        }

        public static class Link
        extends StripeObject {
            @SerializedName(value="email")
            String email;
            @SerializedName(value="persistent_token")
            @Deprecated
            String persistentToken;

            @Generated
            public String getEmail() {
                return this.email;
            }

            @Deprecated
            @Generated
            public String getPersistentToken() {
                return this.persistentToken;
            }

            @Generated
            public void setEmail(String email) {
                this.email = email;
            }

            @Deprecated
            @Generated
            public void setPersistentToken(String persistentToken) {
                this.persistentToken = persistentToken;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Link)) {
                    return false;
                }
                Link other = (Link)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$email = this.getEmail();
                String other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                String this$persistentToken = this.getPersistentToken();
                String other$persistentToken = other.getPersistentToken();
                return !(this$persistentToken == null ? other$persistentToken != null : !this$persistentToken.equals(other$persistentToken));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Link;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                String $persistentToken = this.getPersistentToken();
                result = result * 59 + ($persistentToken == null ? 43 : $persistentToken.hashCode());
                return result;
            }
        }

        public static class Mobilepay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mobilepay)) {
                    return false;
                }
                Mobilepay other = (Mobilepay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mobilepay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Multibanco
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Multibanco)) {
                    return false;
                }
                Multibanco other = (Multibanco)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Multibanco;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class NaverPay
        extends StripeObject {
            @SerializedName(value="funding")
            String funding;

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NaverPay)) {
                    return false;
                }
                NaverPay other = (NaverPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                return !(this$funding == null ? other$funding != null : !this$funding.equals(other$funding));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NaverPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                return result;
            }
        }

        public static class Oxxo
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Oxxo)) {
                    return false;
                }
                Oxxo other = (Oxxo)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Oxxo;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class P24
        extends StripeObject {
            @SerializedName(value="bank")
            String bank;

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof P24)) {
                    return false;
                }
                P24 other = (P24)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                return !(this$bank == null ? other$bank != null : !this$bank.equals(other$bank));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof P24;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                return result;
            }
        }

        public static class PayByBank
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PayByBank)) {
                    return false;
                }
                PayByBank other = (PayByBank)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PayByBank;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Payco
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payco)) {
                    return false;
                }
                Payco other = (Payco)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payco;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Paynow
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paynow)) {
                    return false;
                }
                Paynow other = (Paynow)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paynow;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Paypal
        extends StripeObject {
            @SerializedName(value="country")
            String country;
            @SerializedName(value="payer_email")
            String payerEmail;
            @SerializedName(value="payer_id")
            String payerId;

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getPayerEmail() {
                return this.payerEmail;
            }

            @Generated
            public String getPayerId() {
                return this.payerId;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setPayerEmail(String payerEmail) {
                this.payerEmail = payerEmail;
            }

            @Generated
            public void setPayerId(String payerId) {
                this.payerId = payerId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$payerEmail = this.getPayerEmail();
                String other$payerEmail = other.getPayerEmail();
                if (this$payerEmail == null ? other$payerEmail != null : !this$payerEmail.equals(other$payerEmail)) {
                    return false;
                }
                String this$payerId = this.getPayerId();
                String other$payerId = other.getPayerId();
                return !(this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $payerEmail = this.getPayerEmail();
                result = result * 59 + ($payerEmail == null ? 43 : $payerEmail.hashCode());
                String $payerId = this.getPayerId();
                result = result * 59 + ($payerId == null ? 43 : $payerId.hashCode());
                return result;
            }
        }

        public static class Pix
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pix)) {
                    return false;
                }
                Pix other = (Pix)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pix;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Promptpay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Promptpay)) {
                    return false;
                }
                Promptpay other = (Promptpay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Promptpay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class RevolutPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RevolutPay)) {
                    return false;
                }
                RevolutPay other = (RevolutPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RevolutPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class SamsungPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SamsungPay)) {
                    return false;
                }
                SamsungPay other = (SamsungPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SamsungPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="branch_code")
            String branchCode;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="generated_from")
            GeneratedFrom generatedFrom;
            @SerializedName(value="last4")
            String last4;

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBranchCode() {
                return this.branchCode;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public GeneratedFrom getGeneratedFrom() {
                return this.generatedFrom;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBranchCode(String branchCode) {
                this.branchCode = branchCode;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setGeneratedFrom(GeneratedFrom generatedFrom) {
                this.generatedFrom = generatedFrom;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$branchCode = this.getBranchCode();
                String other$branchCode = other.getBranchCode();
                if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                GeneratedFrom this$generatedFrom = this.getGeneratedFrom();
                GeneratedFrom other$generatedFrom = other.getGeneratedFrom();
                if (this$generatedFrom == null ? other$generatedFrom != null : !((Object)this$generatedFrom).equals(other$generatedFrom)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $branchCode = this.getBranchCode();
                result = result * 59 + ($branchCode == null ? 43 : $branchCode.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                GeneratedFrom $generatedFrom = this.getGeneratedFrom();
                result = result * 59 + ($generatedFrom == null ? 43 : ((Object)$generatedFrom).hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                return result;
            }

            public static class GeneratedFrom
            extends StripeObject {
                @SerializedName(value="charge")
                ExpandableField<Charge> charge;
                @SerializedName(value="setup_attempt")
                ExpandableField<SetupAttempt> setupAttempt;

                public String getCharge() {
                    return this.charge != null ? this.charge.getId() : null;
                }

                public void setCharge(String id) {
                    this.charge = ApiResource.setExpandableFieldId(id, this.charge);
                }

                public Charge getChargeObject() {
                    return this.charge != null ? this.charge.getExpanded() : null;
                }

                public void setChargeObject(Charge expandableObject) {
                    this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
                }

                public String getSetupAttempt() {
                    return this.setupAttempt != null ? this.setupAttempt.getId() : null;
                }

                public void setSetupAttempt(String id) {
                    this.setupAttempt = ApiResource.setExpandableFieldId(id, this.setupAttempt);
                }

                public SetupAttempt getSetupAttemptObject() {
                    return this.setupAttempt != null ? this.setupAttempt.getExpanded() : null;
                }

                public void setSetupAttemptObject(SetupAttempt expandableObject) {
                    this.setupAttempt = new ExpandableField<SetupAttempt>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof GeneratedFrom)) {
                        return false;
                    }
                    GeneratedFrom other = (GeneratedFrom)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$charge = this.getCharge();
                    String other$charge = other.getCharge();
                    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
                        return false;
                    }
                    String this$setupAttempt = this.getSetupAttempt();
                    String other$setupAttempt = other.getSetupAttempt();
                    return !(this$setupAttempt == null ? other$setupAttempt != null : !this$setupAttempt.equals(other$setupAttempt));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof GeneratedFrom;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $charge = this.getCharge();
                    result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
                    String $setupAttempt = this.getSetupAttempt();
                    result = result * 59 + ($setupAttempt == null ? 43 : $setupAttempt.hashCode());
                    return result;
                }
            }
        }

        public static class Sofort
        extends StripeObject {
            @SerializedName(value="country")
            String country;

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                return !(this$country == null ? other$country != null : !this$country.equals(other$country));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                return result;
            }
        }

        public static class Swish
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Swish)) {
                    return false;
                }
                Swish other = (Swish)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Swish;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Twint
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Twint)) {
                    return false;
                }
                Twint other = (Twint)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Twint;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="account_holder_type")
            String accountHolderType;
            @SerializedName(value="account_type")
            String accountType;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="financial_connections_account")
            String financialConnectionsAccount;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="networks")
            Networks networks;
            @SerializedName(value="routing_number")
            String routingNumber;
            @SerializedName(value="status_details")
            StatusDetails statusDetails;

            @Generated
            public String getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getAccountType() {
                return this.accountType;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getFinancialConnectionsAccount() {
                return this.financialConnectionsAccount;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public Networks getNetworks() {
                return this.networks;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public StatusDetails getStatusDetails() {
                return this.statusDetails;
            }

            @Generated
            public void setAccountHolderType(String accountHolderType) {
                this.accountHolderType = accountHolderType;
            }

            @Generated
            public void setAccountType(String accountType) {
                this.accountType = accountType;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setFinancialConnectionsAccount(String financialConnectionsAccount) {
                this.financialConnectionsAccount = financialConnectionsAccount;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetworks(Networks networks) {
                this.networks = networks;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public void setStatusDetails(StatusDetails statusDetails) {
                this.statusDetails = statusDetails;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderType = this.getAccountHolderType();
                String other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$accountType = this.getAccountType();
                String other$accountType = other.getAccountType();
                if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$financialConnectionsAccount = this.getFinancialConnectionsAccount();
                String other$financialConnectionsAccount = other.getFinancialConnectionsAccount();
                if (this$financialConnectionsAccount == null ? other$financialConnectionsAccount != null : !this$financialConnectionsAccount.equals(other$financialConnectionsAccount)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                Networks this$networks = this.getNetworks();
                Networks other$networks = other.getNetworks();
                if (this$networks == null ? other$networks != null : !((Object)this$networks).equals(other$networks)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) {
                    return false;
                }
                StatusDetails this$statusDetails = this.getStatusDetails();
                StatusDetails other$statusDetails = other.getStatusDetails();
                return !(this$statusDetails == null ? other$statusDetails != null : !((Object)this$statusDetails).equals(other$statusDetails));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $accountType = this.getAccountType();
                result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $financialConnectionsAccount = this.getFinancialConnectionsAccount();
                result = result * 59 + ($financialConnectionsAccount == null ? 43 : $financialConnectionsAccount.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                Networks $networks = this.getNetworks();
                result = result * 59 + ($networks == null ? 43 : ((Object)$networks).hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                StatusDetails $statusDetails = this.getStatusDetails();
                result = result * 59 + ($statusDetails == null ? 43 : ((Object)$statusDetails).hashCode());
                return result;
            }

            public static class Networks
            extends StripeObject {
                @SerializedName(value="preferred")
                String preferred;
                @SerializedName(value="supported")
                List<String> supported;

                @Generated
                public String getPreferred() {
                    return this.preferred;
                }

                @Generated
                public List<String> getSupported() {
                    return this.supported;
                }

                @Generated
                public void setPreferred(String preferred) {
                    this.preferred = preferred;
                }

                @Generated
                public void setSupported(List<String> supported) {
                    this.supported = supported;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Networks)) {
                        return false;
                    }
                    Networks other = (Networks)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$preferred = this.getPreferred();
                    String other$preferred = other.getPreferred();
                    if (this$preferred == null ? other$preferred != null : !this$preferred.equals(other$preferred)) {
                        return false;
                    }
                    List<String> this$supported = this.getSupported();
                    List<String> other$supported = other.getSupported();
                    return !(this$supported == null ? other$supported != null : !((Object)this$supported).equals(other$supported));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Networks;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $preferred = this.getPreferred();
                    result = result * 59 + ($preferred == null ? 43 : $preferred.hashCode());
                    List<String> $supported = this.getSupported();
                    result = result * 59 + ($supported == null ? 43 : ((Object)$supported).hashCode());
                    return result;
                }
            }

            public static class StatusDetails
            extends StripeObject {
                @SerializedName(value="blocked")
                Blocked blocked;

                @Generated
                public Blocked getBlocked() {
                    return this.blocked;
                }

                @Generated
                public void setBlocked(Blocked blocked) {
                    this.blocked = blocked;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof StatusDetails)) {
                        return false;
                    }
                    StatusDetails other = (StatusDetails)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Blocked this$blocked = this.getBlocked();
                    Blocked other$blocked = other.getBlocked();
                    return !(this$blocked == null ? other$blocked != null : !((Object)this$blocked).equals(other$blocked));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof StatusDetails;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Blocked $blocked = this.getBlocked();
                    result = result * 59 + ($blocked == null ? 43 : ((Object)$blocked).hashCode());
                    return result;
                }

                public static class Blocked
                extends StripeObject {
                    @SerializedName(value="network_code")
                    String networkCode;
                    @SerializedName(value="reason")
                    String reason;

                    @Generated
                    public String getNetworkCode() {
                        return this.networkCode;
                    }

                    @Generated
                    public String getReason() {
                        return this.reason;
                    }

                    @Generated
                    public void setNetworkCode(String networkCode) {
                        this.networkCode = networkCode;
                    }

                    @Generated
                    public void setReason(String reason) {
                        this.reason = reason;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Blocked)) {
                            return false;
                        }
                        Blocked other = (Blocked)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$networkCode = this.getNetworkCode();
                        String other$networkCode = other.getNetworkCode();
                        if (this$networkCode == null ? other$networkCode != null : !this$networkCode.equals(other$networkCode)) {
                            return false;
                        }
                        String this$reason = this.getReason();
                        String other$reason = other.getReason();
                        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Blocked;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $networkCode = this.getNetworkCode();
                        result = result * 59 + ($networkCode == null ? 43 : $networkCode.hashCode());
                        String $reason = this.getReason();
                        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class WechatPay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPay)) {
                    return false;
                }
                WechatPay other = (WechatPay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Zip
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Zip)) {
                    return false;
                }
                Zip other = (Zip)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Zip;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }
    }

    public static class Shipping
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Shipping)) {
                return false;
            }
            Shipping other = (Shipping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Shipping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }
    }

    public static class TestHelpers {
        private TestHelpers() {
        }

        public static ConfirmationToken create(Map<String, Object> params) throws StripeException {
            return TestHelpers.create(params, (RequestOptions)null);
        }

        public static ConfirmationToken create(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = "/v1/test_helpers/confirmation_tokens";
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
            return (ConfirmationToken)ApiResource.getGlobalResponseGetter().request(request, (Type)((Object)ConfirmationToken.class));
        }

        public static ConfirmationToken create(ConfirmationTokenCreateParams params) throws StripeException {
            return TestHelpers.create(params, (RequestOptions)null);
        }

        public static ConfirmationToken create(ConfirmationTokenCreateParams params, RequestOptions options) throws StripeException {
            String path = "/v1/test_helpers/confirmation_tokens";
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
            return (ConfirmationToken)ApiResource.getGlobalResponseGetter().request(request, (Type)((Object)ConfirmationToken.class));
        }
    }
}

