/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentRecordReportPaymentAttemptCanceledParams;
import com.stripe.param.PaymentRecordReportPaymentAttemptFailedParams;
import com.stripe.param.PaymentRecordReportPaymentAttemptGuaranteedParams;
import com.stripe.param.PaymentRecordReportPaymentAttemptParams;
import com.stripe.param.PaymentRecordReportPaymentParams;
import com.stripe.param.PaymentRecordRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class PaymentRecord
extends ApiResource
implements HasId {
    @SerializedName(value="amount_canceled")
    AmountCanceled amountCanceled;
    @SerializedName(value="amount_failed")
    AmountFailed amountFailed;
    @SerializedName(value="amount_guaranteed")
    AmountGuaranteed amountGuaranteed;
    @SerializedName(value="amount_requested")
    AmountRequested amountRequested;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer_details")
    CustomerDetails customerDetails;
    @SerializedName(value="customer_presence")
    String customerPresence;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="latest_payment_attempt_record")
    String latestPaymentAttemptRecord;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_method_details")
    PaymentMethodDetails paymentMethodDetails;
    @SerializedName(value="payment_reference")
    String paymentReference;
    @SerializedName(value="shipping_details")
    ShippingDetails shippingDetails;

    public static PaymentRecord reportPayment(Map<String, Object> params) throws StripeException {
        return PaymentRecord.reportPayment(params, (RequestOptions)null);
    }

    public static PaymentRecord reportPayment(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_records/report_payment";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentRecord)PaymentRecord.getGlobalResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public static PaymentRecord reportPayment(PaymentRecordReportPaymentParams params) throws StripeException {
        return PaymentRecord.reportPayment(params, (RequestOptions)null);
    }

    public static PaymentRecord reportPayment(PaymentRecordReportPaymentParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_records/report_payment";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentRecord)PaymentRecord.getGlobalResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public PaymentRecord reportPaymentAttempt(Map<String, Object> params) throws StripeException {
        return this.reportPaymentAttempt(params, (RequestOptions)null);
    }

    public PaymentRecord reportPaymentAttempt(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s/report_payment_attempt", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentRecord)this.getResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public PaymentRecord reportPaymentAttempt(PaymentRecordReportPaymentAttemptParams params) throws StripeException {
        return this.reportPaymentAttempt(params, (RequestOptions)null);
    }

    public PaymentRecord reportPaymentAttempt(PaymentRecordReportPaymentAttemptParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s/report_payment_attempt", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentRecord)this.getResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public PaymentRecord reportPaymentAttemptCanceled(Map<String, Object> params) throws StripeException {
        return this.reportPaymentAttemptCanceled(params, (RequestOptions)null);
    }

    public PaymentRecord reportPaymentAttemptCanceled(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s/report_payment_attempt_canceled", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentRecord)this.getResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public PaymentRecord reportPaymentAttemptCanceled(PaymentRecordReportPaymentAttemptCanceledParams params) throws StripeException {
        return this.reportPaymentAttemptCanceled(params, (RequestOptions)null);
    }

    public PaymentRecord reportPaymentAttemptCanceled(PaymentRecordReportPaymentAttemptCanceledParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s/report_payment_attempt_canceled", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentRecord)this.getResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public PaymentRecord reportPaymentAttemptFailed(Map<String, Object> params) throws StripeException {
        return this.reportPaymentAttemptFailed(params, (RequestOptions)null);
    }

    public PaymentRecord reportPaymentAttemptFailed(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s/report_payment_attempt_failed", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentRecord)this.getResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public PaymentRecord reportPaymentAttemptFailed(PaymentRecordReportPaymentAttemptFailedParams params) throws StripeException {
        return this.reportPaymentAttemptFailed(params, (RequestOptions)null);
    }

    public PaymentRecord reportPaymentAttemptFailed(PaymentRecordReportPaymentAttemptFailedParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s/report_payment_attempt_failed", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentRecord)this.getResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public PaymentRecord reportPaymentAttemptGuaranteed(Map<String, Object> params) throws StripeException {
        return this.reportPaymentAttemptGuaranteed(params, (RequestOptions)null);
    }

    public PaymentRecord reportPaymentAttemptGuaranteed(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s/report_payment_attempt_guaranteed", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentRecord)this.getResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public PaymentRecord reportPaymentAttemptGuaranteed(PaymentRecordReportPaymentAttemptGuaranteedParams params) throws StripeException {
        return this.reportPaymentAttemptGuaranteed(params, (RequestOptions)null);
    }

    public PaymentRecord reportPaymentAttemptGuaranteed(PaymentRecordReportPaymentAttemptGuaranteedParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s/report_payment_attempt_guaranteed", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentRecord)this.getResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public static PaymentRecord retrieve(String id) throws StripeException {
        return PaymentRecord.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentRecord retrieve(String id, RequestOptions options) throws StripeException {
        return PaymentRecord.retrieve(id, (Map<String, Object>)null, options);
    }

    public static PaymentRecord retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentRecord)PaymentRecord.getGlobalResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    public static PaymentRecord retrieve(String id, PaymentRecordRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_records/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentRecord)PaymentRecord.getGlobalResponseGetter().request(request, (Type)((Object)PaymentRecord.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.amountCanceled, responseGetter);
        this.trySetResponseGetter(this.amountFailed, responseGetter);
        this.trySetResponseGetter(this.amountGuaranteed, responseGetter);
        this.trySetResponseGetter(this.amountRequested, responseGetter);
        this.trySetResponseGetter(this.customerDetails, responseGetter);
        this.trySetResponseGetter(this.paymentMethodDetails, responseGetter);
        this.trySetResponseGetter(this.shippingDetails, responseGetter);
    }

    @Generated
    public AmountCanceled getAmountCanceled() {
        return this.amountCanceled;
    }

    @Generated
    public AmountFailed getAmountFailed() {
        return this.amountFailed;
    }

    @Generated
    public AmountGuaranteed getAmountGuaranteed() {
        return this.amountGuaranteed;
    }

    @Generated
    public AmountRequested getAmountRequested() {
        return this.amountRequested;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public CustomerDetails getCustomerDetails() {
        return this.customerDetails;
    }

    @Generated
    public String getCustomerPresence() {
        return this.customerPresence;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getLatestPaymentAttemptRecord() {
        return this.latestPaymentAttemptRecord;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodDetails getPaymentMethodDetails() {
        return this.paymentMethodDetails;
    }

    @Generated
    public String getPaymentReference() {
        return this.paymentReference;
    }

    @Generated
    public ShippingDetails getShippingDetails() {
        return this.shippingDetails;
    }

    @Generated
    public void setAmountCanceled(AmountCanceled amountCanceled) {
        this.amountCanceled = amountCanceled;
    }

    @Generated
    public void setAmountFailed(AmountFailed amountFailed) {
        this.amountFailed = amountFailed;
    }

    @Generated
    public void setAmountGuaranteed(AmountGuaranteed amountGuaranteed) {
        this.amountGuaranteed = amountGuaranteed;
    }

    @Generated
    public void setAmountRequested(AmountRequested amountRequested) {
        this.amountRequested = amountRequested;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCustomerDetails(CustomerDetails customerDetails) {
        this.customerDetails = customerDetails;
    }

    @Generated
    public void setCustomerPresence(String customerPresence) {
        this.customerPresence = customerPresence;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLatestPaymentAttemptRecord(String latestPaymentAttemptRecord) {
        this.latestPaymentAttemptRecord = latestPaymentAttemptRecord;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodDetails(PaymentMethodDetails paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    @Generated
    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    @Generated
    public void setShippingDetails(ShippingDetails shippingDetails) {
        this.shippingDetails = shippingDetails;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentRecord)) {
            return false;
        }
        PaymentRecord other = (PaymentRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AmountCanceled this$amountCanceled = this.getAmountCanceled();
        AmountCanceled other$amountCanceled = other.getAmountCanceled();
        if (this$amountCanceled == null ? other$amountCanceled != null : !((Object)this$amountCanceled).equals(other$amountCanceled)) {
            return false;
        }
        AmountFailed this$amountFailed = this.getAmountFailed();
        AmountFailed other$amountFailed = other.getAmountFailed();
        if (this$amountFailed == null ? other$amountFailed != null : !((Object)this$amountFailed).equals(other$amountFailed)) {
            return false;
        }
        AmountGuaranteed this$amountGuaranteed = this.getAmountGuaranteed();
        AmountGuaranteed other$amountGuaranteed = other.getAmountGuaranteed();
        if (this$amountGuaranteed == null ? other$amountGuaranteed != null : !((Object)this$amountGuaranteed).equals(other$amountGuaranteed)) {
            return false;
        }
        AmountRequested this$amountRequested = this.getAmountRequested();
        AmountRequested other$amountRequested = other.getAmountRequested();
        if (this$amountRequested == null ? other$amountRequested != null : !((Object)this$amountRequested).equals(other$amountRequested)) {
            return false;
        }
        CustomerDetails this$customerDetails = this.getCustomerDetails();
        CustomerDetails other$customerDetails = other.getCustomerDetails();
        if (this$customerDetails == null ? other$customerDetails != null : !((Object)this$customerDetails).equals(other$customerDetails)) {
            return false;
        }
        String this$customerPresence = this.getCustomerPresence();
        String other$customerPresence = other.getCustomerPresence();
        if (this$customerPresence == null ? other$customerPresence != null : !this$customerPresence.equals(other$customerPresence)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$latestPaymentAttemptRecord = this.getLatestPaymentAttemptRecord();
        String other$latestPaymentAttemptRecord = other.getLatestPaymentAttemptRecord();
        if (this$latestPaymentAttemptRecord == null ? other$latestPaymentAttemptRecord != null : !this$latestPaymentAttemptRecord.equals(other$latestPaymentAttemptRecord)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        PaymentMethodDetails this$paymentMethodDetails = this.getPaymentMethodDetails();
        PaymentMethodDetails other$paymentMethodDetails = other.getPaymentMethodDetails();
        if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !((Object)this$paymentMethodDetails).equals(other$paymentMethodDetails)) {
            return false;
        }
        String this$paymentReference = this.getPaymentReference();
        String other$paymentReference = other.getPaymentReference();
        if (this$paymentReference == null ? other$paymentReference != null : !this$paymentReference.equals(other$paymentReference)) {
            return false;
        }
        ShippingDetails this$shippingDetails = this.getShippingDetails();
        ShippingDetails other$shippingDetails = other.getShippingDetails();
        return !(this$shippingDetails == null ? other$shippingDetails != null : !((Object)this$shippingDetails).equals(other$shippingDetails));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AmountCanceled $amountCanceled = this.getAmountCanceled();
        result = result * 59 + ($amountCanceled == null ? 43 : ((Object)$amountCanceled).hashCode());
        AmountFailed $amountFailed = this.getAmountFailed();
        result = result * 59 + ($amountFailed == null ? 43 : ((Object)$amountFailed).hashCode());
        AmountGuaranteed $amountGuaranteed = this.getAmountGuaranteed();
        result = result * 59 + ($amountGuaranteed == null ? 43 : ((Object)$amountGuaranteed).hashCode());
        AmountRequested $amountRequested = this.getAmountRequested();
        result = result * 59 + ($amountRequested == null ? 43 : ((Object)$amountRequested).hashCode());
        CustomerDetails $customerDetails = this.getCustomerDetails();
        result = result * 59 + ($customerDetails == null ? 43 : ((Object)$customerDetails).hashCode());
        String $customerPresence = this.getCustomerPresence();
        result = result * 59 + ($customerPresence == null ? 43 : $customerPresence.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $latestPaymentAttemptRecord = this.getLatestPaymentAttemptRecord();
        result = result * 59 + ($latestPaymentAttemptRecord == null ? 43 : $latestPaymentAttemptRecord.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        PaymentMethodDetails $paymentMethodDetails = this.getPaymentMethodDetails();
        result = result * 59 + ($paymentMethodDetails == null ? 43 : ((Object)$paymentMethodDetails).hashCode());
        String $paymentReference = this.getPaymentReference();
        result = result * 59 + ($paymentReference == null ? 43 : $paymentReference.hashCode());
        ShippingDetails $shippingDetails = this.getShippingDetails();
        result = result * 59 + ($shippingDetails == null ? 43 : ((Object)$shippingDetails).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class AmountCanceled
    extends StripeObject {
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="value")
        Long value;

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getValue() {
            return this.value;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setValue(Long value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountCanceled)) {
                return false;
            }
            AmountCanceled other = (AmountCanceled)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$value = this.getValue();
            Long other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountCanceled;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }

    public static class AmountFailed
    extends StripeObject {
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="value")
        Long value;

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getValue() {
            return this.value;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setValue(Long value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountFailed)) {
                return false;
            }
            AmountFailed other = (AmountFailed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$value = this.getValue();
            Long other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountFailed;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }

    public static class AmountGuaranteed
    extends StripeObject {
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="value")
        Long value;

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getValue() {
            return this.value;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setValue(Long value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountGuaranteed)) {
                return false;
            }
            AmountGuaranteed other = (AmountGuaranteed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$value = this.getValue();
            Long other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountGuaranteed;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }

    public static class AmountRequested
    extends StripeObject {
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="value")
        Long value;

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getValue() {
            return this.value;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setValue(Long value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountRequested)) {
                return false;
            }
            AmountRequested other = (AmountRequested)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$value = this.getValue();
            Long other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountRequested;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }

    public static class CustomerDetails
    extends StripeObject {
        @SerializedName(value="customer")
        String customer;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public String getCustomer() {
            return this.customer;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setCustomer(String customer) {
            this.customer = customer;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerDetails)) {
                return false;
            }
            CustomerDetails other = (CustomerDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customer = this.getCustomer();
            String other$customer = other.getCustomer();
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customer = this.getCustomer();
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }
    }

    public static class PaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="custom")
        Custom custom;
        @SerializedName(value="payment_method")
        String paymentMethod;
        @SerializedName(value="type")
        String type;

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public Custom getCustom() {
            return this.custom;
        }

        @Generated
        public String getPaymentMethod() {
            return this.paymentMethod;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setBillingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
        }

        @Generated
        public void setCustom(Custom custom) {
            this.custom = custom;
        }

        @Generated
        public void setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodDetails)) {
                return false;
            }
            PaymentMethodDetails other = (PaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BillingDetails this$billingDetails = this.getBillingDetails();
            BillingDetails other$billingDetails = other.getBillingDetails();
            if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
                return false;
            }
            Custom this$custom = this.getCustom();
            Custom other$custom = other.getCustom();
            if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
                return false;
            }
            String this$paymentMethod = this.getPaymentMethod();
            String other$paymentMethod = other.getPaymentMethod();
            if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BillingDetails $billingDetails = this.getBillingDetails();
            result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
            Custom $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
            String $paymentMethod = this.getPaymentMethod();
            result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class BillingDetails
        extends StripeObject {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="email")
            String email;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="phone")
            String phone;

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getEmail() {
                return this.email;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getPhone() {
                return this.phone;
            }

            @Generated
            public void setAddress(Address address) {
                this.address = address;
            }

            @Generated
            public void setEmail(String email) {
                this.email = email;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setPhone(String phone) {
                this.phone = phone;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingDetails)) {
                    return false;
                }
                BillingDetails other = (BillingDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                String this$email = this.getEmail();
                String other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$phone = this.getPhone();
                String other$phone = other.getPhone();
                return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                String $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $phone = this.getPhone();
                result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                return result;
            }

            public static class Address
            extends StripeObject {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                @Generated
                public void setCity(String city) {
                    this.city = city;
                }

                @Generated
                public void setCountry(String country) {
                    this.country = country;
                }

                @Generated
                public void setLine1(String line1) {
                    this.line1 = line1;
                }

                @Generated
                public void setLine2(String line2) {
                    this.line2 = line2;
                }

                @Generated
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                @Generated
                public void setState(String state) {
                    this.state = state;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Address)) {
                        return false;
                    }
                    Address other = (Address)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$city = this.getCity();
                    String other$city = other.getCity();
                    if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    String this$line1 = this.getLine1();
                    String other$line1 = other.getLine1();
                    if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                        return false;
                    }
                    String this$line2 = this.getLine2();
                    String other$line2 = other.getLine2();
                    if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                        return false;
                    }
                    String this$postalCode = this.getPostalCode();
                    String other$postalCode = other.getPostalCode();
                    if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                        return false;
                    }
                    String this$state = this.getState();
                    String other$state = other.getState();
                    return !(this$state == null ? other$state != null : !this$state.equals(other$state));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Address;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $city = this.getCity();
                    result = result * 59 + ($city == null ? 43 : $city.hashCode());
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    String $line1 = this.getLine1();
                    result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                    String $line2 = this.getLine2();
                    result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                    String $postalCode = this.getPostalCode();
                    result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                    String $state = this.getState();
                    result = result * 59 + ($state == null ? 43 : $state.hashCode());
                    return result;
                }
            }
        }

        public static class Custom
        extends StripeObject {
            @SerializedName(value="display_name")
            String displayName;
            @SerializedName(value="type")
            String type;

            @Generated
            public String getDisplayName() {
                return this.displayName;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setDisplayName(String displayName) {
                this.displayName = displayName;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Custom)) {
                    return false;
                }
                Custom other = (Custom)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$displayName = this.getDisplayName();
                String other$displayName = other.getDisplayName();
                if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Custom;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $displayName = this.getDisplayName();
                result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }
    }

    public static class ShippingDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingDetails)) {
                return false;
            }
            ShippingDetails other = (ShippingDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }

        public static class Address
        extends StripeObject {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public void setCity(String city) {
                this.city = city;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setLine1(String line1) {
                this.line1 = line1;
            }

            @Generated
            public void setLine2(String line2) {
                this.line2 = line2;
            }

            @Generated
            public void setPostalCode(String postalCode) {
                this.postalCode = postalCode;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Address)) {
                    return false;
                }
                Address other = (Address)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$city = this.getCity();
                String other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$line1 = this.getLine1();
                String other$line1 = other.getLine1();
                if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                    return false;
                }
                String this$line2 = this.getLine2();
                String other$line2 = other.getLine2();
                if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                    return false;
                }
                String this$postalCode = this.getPostalCode();
                String other$postalCode = other.getPostalCode();
                if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                return !(this$state == null ? other$state != null : !this$state.equals(other$state));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Address;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $line1 = this.getLine1();
                result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                String $line2 = this.getLine2();
                result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                String $postalCode = this.getPostalCode();
                result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                return result;
            }
        }
    }
}

