/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.BalanceSettingsRetrieveParams;
import com.stripe.param.BalanceSettingsUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class BalanceSettings
extends ApiResource {
    @SerializedName(value="debit_negative_balances")
    Boolean debitNegativeBalances;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payouts")
    Payouts payouts;
    @SerializedName(value="settlement_timing")
    SettlementTiming settlementTiming;

    public static BalanceSettings retrieve() throws StripeException {
        return BalanceSettings.retrieve((Map<String, Object>)null, (RequestOptions)null);
    }

    public static BalanceSettings retrieve(RequestOptions options) throws StripeException {
        return BalanceSettings.retrieve((Map<String, Object>)null, options);
    }

    public static BalanceSettings retrieve(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/balance_settings";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (BalanceSettings)BalanceSettings.getGlobalResponseGetter().request(request, (Type)((Object)BalanceSettings.class));
    }

    public static BalanceSettings retrieve(BalanceSettingsRetrieveParams params, RequestOptions options) throws StripeException {
        String path = "/v1/balance_settings";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (BalanceSettings)BalanceSettings.getGlobalResponseGetter().request(request, (Type)((Object)BalanceSettings.class));
    }

    public static BalanceSettings update(Map<String, Object> params) throws StripeException {
        return BalanceSettings.update(params, (RequestOptions)null);
    }

    public static BalanceSettings update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/balance_settings";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (BalanceSettings)BalanceSettings.getGlobalResponseGetter().request(request, (Type)((Object)BalanceSettings.class));
    }

    public static BalanceSettings update(BalanceSettingsUpdateParams params) throws StripeException {
        return BalanceSettings.update(params, (RequestOptions)null);
    }

    public static BalanceSettings update(BalanceSettingsUpdateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/balance_settings";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (BalanceSettings)BalanceSettings.getGlobalResponseGetter().request(request, (Type)((Object)BalanceSettings.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.payouts, responseGetter);
        this.trySetResponseGetter(this.settlementTiming, responseGetter);
    }

    @Generated
    public Boolean getDebitNegativeBalances() {
        return this.debitNegativeBalances;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Payouts getPayouts() {
        return this.payouts;
    }

    @Generated
    public SettlementTiming getSettlementTiming() {
        return this.settlementTiming;
    }

    @Generated
    public void setDebitNegativeBalances(Boolean debitNegativeBalances) {
        this.debitNegativeBalances = debitNegativeBalances;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPayouts(Payouts payouts) {
        this.payouts = payouts;
    }

    @Generated
    public void setSettlementTiming(SettlementTiming settlementTiming) {
        this.settlementTiming = settlementTiming;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BalanceSettings)) {
            return false;
        }
        BalanceSettings other = (BalanceSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$debitNegativeBalances = this.getDebitNegativeBalances();
        Boolean other$debitNegativeBalances = other.getDebitNegativeBalances();
        if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !((Object)this$debitNegativeBalances).equals(other$debitNegativeBalances)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Payouts this$payouts = this.getPayouts();
        Payouts other$payouts = other.getPayouts();
        if (this$payouts == null ? other$payouts != null : !((Object)this$payouts).equals(other$payouts)) {
            return false;
        }
        SettlementTiming this$settlementTiming = this.getSettlementTiming();
        SettlementTiming other$settlementTiming = other.getSettlementTiming();
        return !(this$settlementTiming == null ? other$settlementTiming != null : !((Object)this$settlementTiming).equals(other$settlementTiming));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BalanceSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $debitNegativeBalances = this.getDebitNegativeBalances();
        result = result * 59 + ($debitNegativeBalances == null ? 43 : ((Object)$debitNegativeBalances).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Payouts $payouts = this.getPayouts();
        result = result * 59 + ($payouts == null ? 43 : ((Object)$payouts).hashCode());
        SettlementTiming $settlementTiming = this.getSettlementTiming();
        result = result * 59 + ($settlementTiming == null ? 43 : ((Object)$settlementTiming).hashCode());
        return result;
    }

    public static class Payouts
    extends StripeObject {
        @SerializedName(value="schedule")
        Schedule schedule;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;
        @SerializedName(value="status")
        String status;

        @Generated
        public Schedule getSchedule() {
            return this.schedule;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setSchedule(Schedule schedule) {
            this.schedule = schedule;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payouts)) {
                return false;
            }
            Payouts other = (Payouts)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Schedule this$schedule = this.getSchedule();
            Schedule other$schedule = other.getSchedule();
            if (this$schedule == null ? other$schedule != null : !((Object)this$schedule).equals(other$schedule)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Payouts;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Schedule $schedule = this.getSchedule();
            result = result * 59 + ($schedule == null ? 43 : ((Object)$schedule).hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public static class Schedule
        extends StripeObject {
            @SerializedName(value="interval")
            String interval;
            @SerializedName(value="monthly_anchor")
            Long monthlyAnchor;
            @SerializedName(value="weekly_anchor")
            String weeklyAnchor;

            @Generated
            public String getInterval() {
                return this.interval;
            }

            @Generated
            public Long getMonthlyAnchor() {
                return this.monthlyAnchor;
            }

            @Generated
            public String getWeeklyAnchor() {
                return this.weeklyAnchor;
            }

            @Generated
            public void setInterval(String interval) {
                this.interval = interval;
            }

            @Generated
            public void setMonthlyAnchor(Long monthlyAnchor) {
                this.monthlyAnchor = monthlyAnchor;
            }

            @Generated
            public void setWeeklyAnchor(String weeklyAnchor) {
                this.weeklyAnchor = weeklyAnchor;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Schedule)) {
                    return false;
                }
                Schedule other = (Schedule)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$monthlyAnchor = this.getMonthlyAnchor();
                Long other$monthlyAnchor = other.getMonthlyAnchor();
                if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !((Object)this$monthlyAnchor).equals(other$monthlyAnchor)) {
                    return false;
                }
                String this$interval = this.getInterval();
                String other$interval = other.getInterval();
                if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                    return false;
                }
                String this$weeklyAnchor = this.getWeeklyAnchor();
                String other$weeklyAnchor = other.getWeeklyAnchor();
                return !(this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Schedule;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $monthlyAnchor = this.getMonthlyAnchor();
                result = result * 59 + ($monthlyAnchor == null ? 43 : ((Object)$monthlyAnchor).hashCode());
                String $interval = this.getInterval();
                result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                String $weeklyAnchor = this.getWeeklyAnchor();
                result = result * 59 + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
                return result;
            }
        }
    }

    public static class SettlementTiming
    extends StripeObject {
        @SerializedName(value="delay_days")
        Long delayDays;

        @Generated
        public Long getDelayDays() {
            return this.delayDays;
        }

        @Generated
        public void setDelayDays(Long delayDays) {
            this.delayDays = delayDays;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettlementTiming)) {
                return false;
            }
            SettlementTiming other = (SettlementTiming)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$delayDays = this.getDelayDays();
            Long other$delayDays = other.getDelayDays();
            return !(this$delayDays == null ? other$delayDays != null : !((Object)this$delayDays).equals(other$delayDays));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettlementTiming;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $delayDays = this.getDelayDays();
            result = result * 59 + ($delayDays == null ? 43 : ((Object)$delayDays).hashCode());
            return result;
        }
    }
}

