/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Mandate;
import com.stripe.model.PaymentAttemptRecordCollection;
import com.stripe.model.PaymentMethod;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentAttemptRecordListParams;
import com.stripe.param.PaymentAttemptRecordRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentAttemptRecord
extends ApiResource
implements HasId {
    @SerializedName(value="amount_canceled")
    AmountCanceled amountCanceled;
    @SerializedName(value="amount_failed")
    AmountFailed amountFailed;
    @SerializedName(value="amount_guaranteed")
    AmountGuaranteed amountGuaranteed;
    @SerializedName(value="amount_requested")
    AmountRequested amountRequested;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer_details")
    CustomerDetails customerDetails;
    @SerializedName(value="customer_presence")
    String customerPresence;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_method_details")
    PaymentMethodDetails paymentMethodDetails;
    @SerializedName(value="payment_record")
    String paymentRecord;
    @SerializedName(value="payment_reference")
    String paymentReference;
    @SerializedName(value="reported_by")
    String reportedBy;
    @SerializedName(value="shipping_details")
    ShippingDetails shippingDetails;

    public static PaymentAttemptRecordCollection list(Map<String, Object> params) throws StripeException {
        return PaymentAttemptRecord.list(params, (RequestOptions)null);
    }

    public static PaymentAttemptRecordCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_attempt_records";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentAttemptRecordCollection)PaymentAttemptRecord.getGlobalResponseGetter().request(request, (Type)((Object)PaymentAttemptRecordCollection.class));
    }

    public static PaymentAttemptRecordCollection list(PaymentAttemptRecordListParams params) throws StripeException {
        return PaymentAttemptRecord.list(params, (RequestOptions)null);
    }

    public static PaymentAttemptRecordCollection list(PaymentAttemptRecordListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_attempt_records";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentAttemptRecordCollection)PaymentAttemptRecord.getGlobalResponseGetter().request(request, (Type)((Object)PaymentAttemptRecordCollection.class));
    }

    public static PaymentAttemptRecord retrieve(String id) throws StripeException {
        return PaymentAttemptRecord.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentAttemptRecord retrieve(String id, RequestOptions options) throws StripeException {
        return PaymentAttemptRecord.retrieve(id, (Map<String, Object>)null, options);
    }

    public static PaymentAttemptRecord retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_attempt_records/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentAttemptRecord)PaymentAttemptRecord.getGlobalResponseGetter().request(request, (Type)((Object)PaymentAttemptRecord.class));
    }

    public static PaymentAttemptRecord retrieve(String id, PaymentAttemptRecordRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_attempt_records/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentAttemptRecord)PaymentAttemptRecord.getGlobalResponseGetter().request(request, (Type)((Object)PaymentAttemptRecord.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.amountCanceled, responseGetter);
        this.trySetResponseGetter(this.amountFailed, responseGetter);
        this.trySetResponseGetter(this.amountGuaranteed, responseGetter);
        this.trySetResponseGetter(this.amountRequested, responseGetter);
        this.trySetResponseGetter(this.customerDetails, responseGetter);
        this.trySetResponseGetter(this.paymentMethodDetails, responseGetter);
        this.trySetResponseGetter(this.shippingDetails, responseGetter);
    }

    @Generated
    public AmountCanceled getAmountCanceled() {
        return this.amountCanceled;
    }

    @Generated
    public AmountFailed getAmountFailed() {
        return this.amountFailed;
    }

    @Generated
    public AmountGuaranteed getAmountGuaranteed() {
        return this.amountGuaranteed;
    }

    @Generated
    public AmountRequested getAmountRequested() {
        return this.amountRequested;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public CustomerDetails getCustomerDetails() {
        return this.customerDetails;
    }

    @Generated
    public String getCustomerPresence() {
        return this.customerPresence;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodDetails getPaymentMethodDetails() {
        return this.paymentMethodDetails;
    }

    @Generated
    public String getPaymentRecord() {
        return this.paymentRecord;
    }

    @Generated
    public String getPaymentReference() {
        return this.paymentReference;
    }

    @Generated
    public String getReportedBy() {
        return this.reportedBy;
    }

    @Generated
    public ShippingDetails getShippingDetails() {
        return this.shippingDetails;
    }

    @Generated
    public void setAmountCanceled(AmountCanceled amountCanceled) {
        this.amountCanceled = amountCanceled;
    }

    @Generated
    public void setAmountFailed(AmountFailed amountFailed) {
        this.amountFailed = amountFailed;
    }

    @Generated
    public void setAmountGuaranteed(AmountGuaranteed amountGuaranteed) {
        this.amountGuaranteed = amountGuaranteed;
    }

    @Generated
    public void setAmountRequested(AmountRequested amountRequested) {
        this.amountRequested = amountRequested;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCustomerDetails(CustomerDetails customerDetails) {
        this.customerDetails = customerDetails;
    }

    @Generated
    public void setCustomerPresence(String customerPresence) {
        this.customerPresence = customerPresence;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodDetails(PaymentMethodDetails paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    @Generated
    public void setPaymentRecord(String paymentRecord) {
        this.paymentRecord = paymentRecord;
    }

    @Generated
    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    @Generated
    public void setReportedBy(String reportedBy) {
        this.reportedBy = reportedBy;
    }

    @Generated
    public void setShippingDetails(ShippingDetails shippingDetails) {
        this.shippingDetails = shippingDetails;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentAttemptRecord)) {
            return false;
        }
        PaymentAttemptRecord other = (PaymentAttemptRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AmountCanceled this$amountCanceled = this.getAmountCanceled();
        AmountCanceled other$amountCanceled = other.getAmountCanceled();
        if (this$amountCanceled == null ? other$amountCanceled != null : !((Object)this$amountCanceled).equals(other$amountCanceled)) {
            return false;
        }
        AmountFailed this$amountFailed = this.getAmountFailed();
        AmountFailed other$amountFailed = other.getAmountFailed();
        if (this$amountFailed == null ? other$amountFailed != null : !((Object)this$amountFailed).equals(other$amountFailed)) {
            return false;
        }
        AmountGuaranteed this$amountGuaranteed = this.getAmountGuaranteed();
        AmountGuaranteed other$amountGuaranteed = other.getAmountGuaranteed();
        if (this$amountGuaranteed == null ? other$amountGuaranteed != null : !((Object)this$amountGuaranteed).equals(other$amountGuaranteed)) {
            return false;
        }
        AmountRequested this$amountRequested = this.getAmountRequested();
        AmountRequested other$amountRequested = other.getAmountRequested();
        if (this$amountRequested == null ? other$amountRequested != null : !((Object)this$amountRequested).equals(other$amountRequested)) {
            return false;
        }
        CustomerDetails this$customerDetails = this.getCustomerDetails();
        CustomerDetails other$customerDetails = other.getCustomerDetails();
        if (this$customerDetails == null ? other$customerDetails != null : !((Object)this$customerDetails).equals(other$customerDetails)) {
            return false;
        }
        String this$customerPresence = this.getCustomerPresence();
        String other$customerPresence = other.getCustomerPresence();
        if (this$customerPresence == null ? other$customerPresence != null : !this$customerPresence.equals(other$customerPresence)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        PaymentMethodDetails this$paymentMethodDetails = this.getPaymentMethodDetails();
        PaymentMethodDetails other$paymentMethodDetails = other.getPaymentMethodDetails();
        if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !((Object)this$paymentMethodDetails).equals(other$paymentMethodDetails)) {
            return false;
        }
        String this$paymentRecord = this.getPaymentRecord();
        String other$paymentRecord = other.getPaymentRecord();
        if (this$paymentRecord == null ? other$paymentRecord != null : !this$paymentRecord.equals(other$paymentRecord)) {
            return false;
        }
        String this$paymentReference = this.getPaymentReference();
        String other$paymentReference = other.getPaymentReference();
        if (this$paymentReference == null ? other$paymentReference != null : !this$paymentReference.equals(other$paymentReference)) {
            return false;
        }
        String this$reportedBy = this.getReportedBy();
        String other$reportedBy = other.getReportedBy();
        if (this$reportedBy == null ? other$reportedBy != null : !this$reportedBy.equals(other$reportedBy)) {
            return false;
        }
        ShippingDetails this$shippingDetails = this.getShippingDetails();
        ShippingDetails other$shippingDetails = other.getShippingDetails();
        return !(this$shippingDetails == null ? other$shippingDetails != null : !((Object)this$shippingDetails).equals(other$shippingDetails));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentAttemptRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AmountCanceled $amountCanceled = this.getAmountCanceled();
        result = result * 59 + ($amountCanceled == null ? 43 : ((Object)$amountCanceled).hashCode());
        AmountFailed $amountFailed = this.getAmountFailed();
        result = result * 59 + ($amountFailed == null ? 43 : ((Object)$amountFailed).hashCode());
        AmountGuaranteed $amountGuaranteed = this.getAmountGuaranteed();
        result = result * 59 + ($amountGuaranteed == null ? 43 : ((Object)$amountGuaranteed).hashCode());
        AmountRequested $amountRequested = this.getAmountRequested();
        result = result * 59 + ($amountRequested == null ? 43 : ((Object)$amountRequested).hashCode());
        CustomerDetails $customerDetails = this.getCustomerDetails();
        result = result * 59 + ($customerDetails == null ? 43 : ((Object)$customerDetails).hashCode());
        String $customerPresence = this.getCustomerPresence();
        result = result * 59 + ($customerPresence == null ? 43 : $customerPresence.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        PaymentMethodDetails $paymentMethodDetails = this.getPaymentMethodDetails();
        result = result * 59 + ($paymentMethodDetails == null ? 43 : ((Object)$paymentMethodDetails).hashCode());
        String $paymentRecord = this.getPaymentRecord();
        result = result * 59 + ($paymentRecord == null ? 43 : $paymentRecord.hashCode());
        String $paymentReference = this.getPaymentReference();
        result = result * 59 + ($paymentReference == null ? 43 : $paymentReference.hashCode());
        String $reportedBy = this.getReportedBy();
        result = result * 59 + ($reportedBy == null ? 43 : $reportedBy.hashCode());
        ShippingDetails $shippingDetails = this.getShippingDetails();
        result = result * 59 + ($shippingDetails == null ? 43 : ((Object)$shippingDetails).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class AmountCanceled
    extends StripeObject {
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="value")
        Long value;

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getValue() {
            return this.value;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setValue(Long value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountCanceled)) {
                return false;
            }
            AmountCanceled other = (AmountCanceled)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$value = this.getValue();
            Long other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountCanceled;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }

    public static class AmountFailed
    extends StripeObject {
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="value")
        Long value;

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getValue() {
            return this.value;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setValue(Long value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountFailed)) {
                return false;
            }
            AmountFailed other = (AmountFailed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$value = this.getValue();
            Long other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountFailed;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }

    public static class AmountGuaranteed
    extends StripeObject {
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="value")
        Long value;

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getValue() {
            return this.value;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setValue(Long value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountGuaranteed)) {
                return false;
            }
            AmountGuaranteed other = (AmountGuaranteed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$value = this.getValue();
            Long other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountGuaranteed;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }

    public static class AmountRequested
    extends StripeObject {
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="value")
        Long value;

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getValue() {
            return this.value;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setValue(Long value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountRequested)) {
                return false;
            }
            AmountRequested other = (AmountRequested)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$value = this.getValue();
            Long other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountRequested;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }

    public static class CustomerDetails
    extends StripeObject {
        @SerializedName(value="customer")
        String customer;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public String getCustomer() {
            return this.customer;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setCustomer(String customer) {
            this.customer = customer;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerDetails)) {
                return false;
            }
            CustomerDetails other = (CustomerDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customer = this.getCustomer();
            String other$customer = other.getCustomer();
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customer = this.getCustomer();
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }
    }

    public static class PaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="ach_credit_transfer")
        AchCreditTransfer achCreditTransfer;
        @SerializedName(value="ach_debit")
        AchDebit achDebit;
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="affirm")
        Affirm affirm;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="alma")
        Alma alma;
        @SerializedName(value="amazon_pay")
        AmazonPay amazonPay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="billie")
        Billie billie;
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="blik")
        Blik blik;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="card_present")
        CardPresent cardPresent;
        @SerializedName(value="cashapp")
        Cashapp cashapp;
        @SerializedName(value="custom")
        Custom custom;
        @SerializedName(value="customer_balance")
        CustomerBalance customerBalance;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="gopay")
        Gopay gopay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="id_bank_transfer")
        IdBankTransfer idBankTransfer;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="interac_present")
        InteracPresent interacPresent;
        @SerializedName(value="kakao_pay")
        KakaoPay kakaoPay;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="konbini")
        Konbini konbini;
        @SerializedName(value="kr_card")
        KrCard krCard;
        @SerializedName(value="link")
        Link link;
        @SerializedName(value="mb_way")
        MbWay mbWay;
        @SerializedName(value="mobilepay")
        Mobilepay mobilepay;
        @SerializedName(value="multibanco")
        Multibanco multibanco;
        @SerializedName(value="naver_pay")
        NaverPay naverPay;
        @SerializedName(value="nz_bank_account")
        NzBankAccount nzBankAccount;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="pay_by_bank")
        PayByBank payByBank;
        @SerializedName(value="payco")
        Payco payco;
        @SerializedName(value="payment_method")
        String paymentMethod;
        @SerializedName(value="paynow")
        Paynow paynow;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="payto")
        Payto payto;
        @SerializedName(value="pix")
        Pix pix;
        @SerializedName(value="promptpay")
        Promptpay promptpay;
        @SerializedName(value="qris")
        Qris qris;
        @SerializedName(value="rechnung")
        Rechnung rechnung;
        @SerializedName(value="revolut_pay")
        RevolutPay revolutPay;
        @SerializedName(value="samsung_pay")
        SamsungPay samsungPay;
        @SerializedName(value="satispay")
        Satispay satispay;
        @SerializedName(value="sepa_credit_transfer")
        SepaCreditTransfer sepaCreditTransfer;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="shopeepay")
        Shopeepay shopeepay;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="stripe_account")
        StripeAccount stripeAccount;
        @SerializedName(value="stripe_balance")
        StripeBalance stripeBalance;
        @SerializedName(value="swish")
        Swish swish;
        @SerializedName(value="twint")
        Twint twint;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;
        @SerializedName(value="wechat")
        Wechat wechat;
        @SerializedName(value="wechat_pay")
        WechatPay wechatPay;
        @SerializedName(value="zip")
        Zip zip;

        @Generated
        public AchCreditTransfer getAchCreditTransfer() {
            return this.achCreditTransfer;
        }

        @Generated
        public AchDebit getAchDebit() {
            return this.achDebit;
        }

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Affirm getAffirm() {
            return this.affirm;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public Alma getAlma() {
            return this.alma;
        }

        @Generated
        public AmazonPay getAmazonPay() {
            return this.amazonPay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Billie getBillie() {
            return this.billie;
        }

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public Blik getBlik() {
            return this.blik;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public CardPresent getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Cashapp getCashapp() {
            return this.cashapp;
        }

        @Generated
        public Custom getCustom() {
            return this.custom;
        }

        @Generated
        public CustomerBalance getCustomerBalance() {
            return this.customerBalance;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Gopay getGopay() {
            return this.gopay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public IdBankTransfer getIdBankTransfer() {
            return this.idBankTransfer;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public InteracPresent getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public KakaoPay getKakaoPay() {
            return this.kakaoPay;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Konbini getKonbini() {
            return this.konbini;
        }

        @Generated
        public KrCard getKrCard() {
            return this.krCard;
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public MbWay getMbWay() {
            return this.mbWay;
        }

        @Generated
        public Mobilepay getMobilepay() {
            return this.mobilepay;
        }

        @Generated
        public Multibanco getMultibanco() {
            return this.multibanco;
        }

        @Generated
        public NaverPay getNaverPay() {
            return this.naverPay;
        }

        @Generated
        public NzBankAccount getNzBankAccount() {
            return this.nzBankAccount;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public PayByBank getPayByBank() {
            return this.payByBank;
        }

        @Generated
        public Payco getPayco() {
            return this.payco;
        }

        @Generated
        public String getPaymentMethod() {
            return this.paymentMethod;
        }

        @Generated
        public Paynow getPaynow() {
            return this.paynow;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public Payto getPayto() {
            return this.payto;
        }

        @Generated
        public Pix getPix() {
            return this.pix;
        }

        @Generated
        public Promptpay getPromptpay() {
            return this.promptpay;
        }

        @Generated
        public Qris getQris() {
            return this.qris;
        }

        @Generated
        public Rechnung getRechnung() {
            return this.rechnung;
        }

        @Generated
        public RevolutPay getRevolutPay() {
            return this.revolutPay;
        }

        @Generated
        public SamsungPay getSamsungPay() {
            return this.samsungPay;
        }

        @Generated
        public Satispay getSatispay() {
            return this.satispay;
        }

        @Generated
        public SepaCreditTransfer getSepaCreditTransfer() {
            return this.sepaCreditTransfer;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Shopeepay getShopeepay() {
            return this.shopeepay;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public StripeAccount getStripeAccount() {
            return this.stripeAccount;
        }

        @Generated
        public StripeBalance getStripeBalance() {
            return this.stripeBalance;
        }

        @Generated
        public Swish getSwish() {
            return this.swish;
        }

        @Generated
        public Twint getTwint() {
            return this.twint;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public Wechat getWechat() {
            return this.wechat;
        }

        @Generated
        public WechatPay getWechatPay() {
            return this.wechatPay;
        }

        @Generated
        public Zip getZip() {
            return this.zip;
        }

        @Generated
        public void setAchCreditTransfer(AchCreditTransfer achCreditTransfer) {
            this.achCreditTransfer = achCreditTransfer;
        }

        @Generated
        public void setAchDebit(AchDebit achDebit) {
            this.achDebit = achDebit;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setAffirm(Affirm affirm) {
            this.affirm = affirm;
        }

        @Generated
        public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
            this.afterpayClearpay = afterpayClearpay;
        }

        @Generated
        public void setAlipay(Alipay alipay) {
            this.alipay = alipay;
        }

        @Generated
        public void setAlma(Alma alma) {
            this.alma = alma;
        }

        @Generated
        public void setAmazonPay(AmazonPay amazonPay) {
            this.amazonPay = amazonPay;
        }

        @Generated
        public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
            this.auBecsDebit = auBecsDebit;
        }

        @Generated
        public void setBacsDebit(BacsDebit bacsDebit) {
            this.bacsDebit = bacsDebit;
        }

        @Generated
        public void setBancontact(Bancontact bancontact) {
            this.bancontact = bancontact;
        }

        @Generated
        public void setBillie(Billie billie) {
            this.billie = billie;
        }

        @Generated
        public void setBillingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
        }

        @Generated
        public void setBlik(Blik blik) {
            this.blik = blik;
        }

        @Generated
        public void setBoleto(Boleto boleto) {
            this.boleto = boleto;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCardPresent(CardPresent cardPresent) {
            this.cardPresent = cardPresent;
        }

        @Generated
        public void setCashapp(Cashapp cashapp) {
            this.cashapp = cashapp;
        }

        @Generated
        public void setCustom(Custom custom) {
            this.custom = custom;
        }

        @Generated
        public void setCustomerBalance(CustomerBalance customerBalance) {
            this.customerBalance = customerBalance;
        }

        @Generated
        public void setEps(Eps eps) {
            this.eps = eps;
        }

        @Generated
        public void setFpx(Fpx fpx) {
            this.fpx = fpx;
        }

        @Generated
        public void setGiropay(Giropay giropay) {
            this.giropay = giropay;
        }

        @Generated
        public void setGopay(Gopay gopay) {
            this.gopay = gopay;
        }

        @Generated
        public void setGrabpay(Grabpay grabpay) {
            this.grabpay = grabpay;
        }

        @Generated
        public void setIdBankTransfer(IdBankTransfer idBankTransfer) {
            this.idBankTransfer = idBankTransfer;
        }

        @Generated
        public void setIdeal(Ideal ideal) {
            this.ideal = ideal;
        }

        @Generated
        public void setInteracPresent(InteracPresent interacPresent) {
            this.interacPresent = interacPresent;
        }

        @Generated
        public void setKakaoPay(KakaoPay kakaoPay) {
            this.kakaoPay = kakaoPay;
        }

        @Generated
        public void setKlarna(Klarna klarna) {
            this.klarna = klarna;
        }

        @Generated
        public void setKonbini(Konbini konbini) {
            this.konbini = konbini;
        }

        @Generated
        public void setKrCard(KrCard krCard) {
            this.krCard = krCard;
        }

        @Generated
        public void setLink(Link link) {
            this.link = link;
        }

        @Generated
        public void setMbWay(MbWay mbWay) {
            this.mbWay = mbWay;
        }

        @Generated
        public void setMobilepay(Mobilepay mobilepay) {
            this.mobilepay = mobilepay;
        }

        @Generated
        public void setMultibanco(Multibanco multibanco) {
            this.multibanco = multibanco;
        }

        @Generated
        public void setNaverPay(NaverPay naverPay) {
            this.naverPay = naverPay;
        }

        @Generated
        public void setNzBankAccount(NzBankAccount nzBankAccount) {
            this.nzBankAccount = nzBankAccount;
        }

        @Generated
        public void setOxxo(Oxxo oxxo) {
            this.oxxo = oxxo;
        }

        @Generated
        public void setP24(P24 p24) {
            this.p24 = p24;
        }

        @Generated
        public void setPayByBank(PayByBank payByBank) {
            this.payByBank = payByBank;
        }

        @Generated
        public void setPayco(Payco payco) {
            this.payco = payco;
        }

        @Generated
        public void setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
        }

        @Generated
        public void setPaynow(Paynow paynow) {
            this.paynow = paynow;
        }

        @Generated
        public void setPaypal(Paypal paypal) {
            this.paypal = paypal;
        }

        @Generated
        public void setPayto(Payto payto) {
            this.payto = payto;
        }

        @Generated
        public void setPix(Pix pix) {
            this.pix = pix;
        }

        @Generated
        public void setPromptpay(Promptpay promptpay) {
            this.promptpay = promptpay;
        }

        @Generated
        public void setQris(Qris qris) {
            this.qris = qris;
        }

        @Generated
        public void setRechnung(Rechnung rechnung) {
            this.rechnung = rechnung;
        }

        @Generated
        public void setRevolutPay(RevolutPay revolutPay) {
            this.revolutPay = revolutPay;
        }

        @Generated
        public void setSamsungPay(SamsungPay samsungPay) {
            this.samsungPay = samsungPay;
        }

        @Generated
        public void setSatispay(Satispay satispay) {
            this.satispay = satispay;
        }

        @Generated
        public void setSepaCreditTransfer(SepaCreditTransfer sepaCreditTransfer) {
            this.sepaCreditTransfer = sepaCreditTransfer;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setShopeepay(Shopeepay shopeepay) {
            this.shopeepay = shopeepay;
        }

        @Generated
        public void setSofort(Sofort sofort) {
            this.sofort = sofort;
        }

        @Generated
        public void setStripeAccount(StripeAccount stripeAccount) {
            this.stripeAccount = stripeAccount;
        }

        @Generated
        public void setStripeBalance(StripeBalance stripeBalance) {
            this.stripeBalance = stripeBalance;
        }

        @Generated
        public void setSwish(Swish swish) {
            this.swish = swish;
        }

        @Generated
        public void setTwint(Twint twint) {
            this.twint = twint;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public void setWechat(Wechat wechat) {
            this.wechat = wechat;
        }

        @Generated
        public void setWechatPay(WechatPay wechatPay) {
            this.wechatPay = wechatPay;
        }

        @Generated
        public void setZip(Zip zip) {
            this.zip = zip;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodDetails)) {
                return false;
            }
            PaymentMethodDetails other = (PaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AchCreditTransfer this$achCreditTransfer = this.getAchCreditTransfer();
            AchCreditTransfer other$achCreditTransfer = other.getAchCreditTransfer();
            if (this$achCreditTransfer == null ? other$achCreditTransfer != null : !((Object)this$achCreditTransfer).equals(other$achCreditTransfer)) {
                return false;
            }
            AchDebit this$achDebit = this.getAchDebit();
            AchDebit other$achDebit = other.getAchDebit();
            if (this$achDebit == null ? other$achDebit != null : !((Object)this$achDebit).equals(other$achDebit)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            Affirm this$affirm = this.getAffirm();
            Affirm other$affirm = other.getAffirm();
            if (this$affirm == null ? other$affirm != null : !((Object)this$affirm).equals(other$affirm)) {
                return false;
            }
            AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
            AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
            if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
                return false;
            }
            Alipay this$alipay = this.getAlipay();
            Alipay other$alipay = other.getAlipay();
            if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
                return false;
            }
            Alma this$alma = this.getAlma();
            Alma other$alma = other.getAlma();
            if (this$alma == null ? other$alma != null : !((Object)this$alma).equals(other$alma)) {
                return false;
            }
            AmazonPay this$amazonPay = this.getAmazonPay();
            AmazonPay other$amazonPay = other.getAmazonPay();
            if (this$amazonPay == null ? other$amazonPay != null : !((Object)this$amazonPay).equals(other$amazonPay)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Bancontact this$bancontact = this.getBancontact();
            Bancontact other$bancontact = other.getBancontact();
            if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                return false;
            }
            Billie this$billie = this.getBillie();
            Billie other$billie = other.getBillie();
            if (this$billie == null ? other$billie != null : !((Object)this$billie).equals(other$billie)) {
                return false;
            }
            BillingDetails this$billingDetails = this.getBillingDetails();
            BillingDetails other$billingDetails = other.getBillingDetails();
            if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
                return false;
            }
            Blik this$blik = this.getBlik();
            Blik other$blik = other.getBlik();
            if (this$blik == null ? other$blik != null : !((Object)this$blik).equals(other$blik)) {
                return false;
            }
            Boleto this$boleto = this.getBoleto();
            Boleto other$boleto = other.getBoleto();
            if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            CardPresent this$cardPresent = this.getCardPresent();
            CardPresent other$cardPresent = other.getCardPresent();
            if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
                return false;
            }
            Cashapp this$cashapp = this.getCashapp();
            Cashapp other$cashapp = other.getCashapp();
            if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
                return false;
            }
            Custom this$custom = this.getCustom();
            Custom other$custom = other.getCustom();
            if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
                return false;
            }
            CustomerBalance this$customerBalance = this.getCustomerBalance();
            CustomerBalance other$customerBalance = other.getCustomerBalance();
            if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
                return false;
            }
            Eps this$eps = this.getEps();
            Eps other$eps = other.getEps();
            if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
                return false;
            }
            Fpx this$fpx = this.getFpx();
            Fpx other$fpx = other.getFpx();
            if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
                return false;
            }
            Giropay this$giropay = this.getGiropay();
            Giropay other$giropay = other.getGiropay();
            if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
                return false;
            }
            Gopay this$gopay = this.getGopay();
            Gopay other$gopay = other.getGopay();
            if (this$gopay == null ? other$gopay != null : !((Object)this$gopay).equals(other$gopay)) {
                return false;
            }
            Grabpay this$grabpay = this.getGrabpay();
            Grabpay other$grabpay = other.getGrabpay();
            if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
                return false;
            }
            IdBankTransfer this$idBankTransfer = this.getIdBankTransfer();
            IdBankTransfer other$idBankTransfer = other.getIdBankTransfer();
            if (this$idBankTransfer == null ? other$idBankTransfer != null : !((Object)this$idBankTransfer).equals(other$idBankTransfer)) {
                return false;
            }
            Ideal this$ideal = this.getIdeal();
            Ideal other$ideal = other.getIdeal();
            if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
                return false;
            }
            InteracPresent this$interacPresent = this.getInteracPresent();
            InteracPresent other$interacPresent = other.getInteracPresent();
            if (this$interacPresent == null ? other$interacPresent != null : !((Object)this$interacPresent).equals(other$interacPresent)) {
                return false;
            }
            KakaoPay this$kakaoPay = this.getKakaoPay();
            KakaoPay other$kakaoPay = other.getKakaoPay();
            if (this$kakaoPay == null ? other$kakaoPay != null : !((Object)this$kakaoPay).equals(other$kakaoPay)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            Konbini this$konbini = this.getKonbini();
            Konbini other$konbini = other.getKonbini();
            if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
                return false;
            }
            KrCard this$krCard = this.getKrCard();
            KrCard other$krCard = other.getKrCard();
            if (this$krCard == null ? other$krCard != null : !((Object)this$krCard).equals(other$krCard)) {
                return false;
            }
            Link this$link = this.getLink();
            Link other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            MbWay this$mbWay = this.getMbWay();
            MbWay other$mbWay = other.getMbWay();
            if (this$mbWay == null ? other$mbWay != null : !((Object)this$mbWay).equals(other$mbWay)) {
                return false;
            }
            Mobilepay this$mobilepay = this.getMobilepay();
            Mobilepay other$mobilepay = other.getMobilepay();
            if (this$mobilepay == null ? other$mobilepay != null : !((Object)this$mobilepay).equals(other$mobilepay)) {
                return false;
            }
            Multibanco this$multibanco = this.getMultibanco();
            Multibanco other$multibanco = other.getMultibanco();
            if (this$multibanco == null ? other$multibanco != null : !((Object)this$multibanco).equals(other$multibanco)) {
                return false;
            }
            NaverPay this$naverPay = this.getNaverPay();
            NaverPay other$naverPay = other.getNaverPay();
            if (this$naverPay == null ? other$naverPay != null : !((Object)this$naverPay).equals(other$naverPay)) {
                return false;
            }
            NzBankAccount this$nzBankAccount = this.getNzBankAccount();
            NzBankAccount other$nzBankAccount = other.getNzBankAccount();
            if (this$nzBankAccount == null ? other$nzBankAccount != null : !((Object)this$nzBankAccount).equals(other$nzBankAccount)) {
                return false;
            }
            Oxxo this$oxxo = this.getOxxo();
            Oxxo other$oxxo = other.getOxxo();
            if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
                return false;
            }
            P24 this$p24 = this.getP24();
            P24 other$p24 = other.getP24();
            if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
                return false;
            }
            PayByBank this$payByBank = this.getPayByBank();
            PayByBank other$payByBank = other.getPayByBank();
            if (this$payByBank == null ? other$payByBank != null : !((Object)this$payByBank).equals(other$payByBank)) {
                return false;
            }
            Payco this$payco = this.getPayco();
            Payco other$payco = other.getPayco();
            if (this$payco == null ? other$payco != null : !((Object)this$payco).equals(other$payco)) {
                return false;
            }
            String this$paymentMethod = this.getPaymentMethod();
            String other$paymentMethod = other.getPaymentMethod();
            if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
                return false;
            }
            Paynow this$paynow = this.getPaynow();
            Paynow other$paynow = other.getPaynow();
            if (this$paynow == null ? other$paynow != null : !((Object)this$paynow).equals(other$paynow)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                return false;
            }
            Payto this$payto = this.getPayto();
            Payto other$payto = other.getPayto();
            if (this$payto == null ? other$payto != null : !((Object)this$payto).equals(other$payto)) {
                return false;
            }
            Pix this$pix = this.getPix();
            Pix other$pix = other.getPix();
            if (this$pix == null ? other$pix != null : !((Object)this$pix).equals(other$pix)) {
                return false;
            }
            Promptpay this$promptpay = this.getPromptpay();
            Promptpay other$promptpay = other.getPromptpay();
            if (this$promptpay == null ? other$promptpay != null : !((Object)this$promptpay).equals(other$promptpay)) {
                return false;
            }
            Qris this$qris = this.getQris();
            Qris other$qris = other.getQris();
            if (this$qris == null ? other$qris != null : !((Object)this$qris).equals(other$qris)) {
                return false;
            }
            Rechnung this$rechnung = this.getRechnung();
            Rechnung other$rechnung = other.getRechnung();
            if (this$rechnung == null ? other$rechnung != null : !((Object)this$rechnung).equals(other$rechnung)) {
                return false;
            }
            RevolutPay this$revolutPay = this.getRevolutPay();
            RevolutPay other$revolutPay = other.getRevolutPay();
            if (this$revolutPay == null ? other$revolutPay != null : !((Object)this$revolutPay).equals(other$revolutPay)) {
                return false;
            }
            SamsungPay this$samsungPay = this.getSamsungPay();
            SamsungPay other$samsungPay = other.getSamsungPay();
            if (this$samsungPay == null ? other$samsungPay != null : !((Object)this$samsungPay).equals(other$samsungPay)) {
                return false;
            }
            Satispay this$satispay = this.getSatispay();
            Satispay other$satispay = other.getSatispay();
            if (this$satispay == null ? other$satispay != null : !((Object)this$satispay).equals(other$satispay)) {
                return false;
            }
            SepaCreditTransfer this$sepaCreditTransfer = this.getSepaCreditTransfer();
            SepaCreditTransfer other$sepaCreditTransfer = other.getSepaCreditTransfer();
            if (this$sepaCreditTransfer == null ? other$sepaCreditTransfer != null : !((Object)this$sepaCreditTransfer).equals(other$sepaCreditTransfer)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            Shopeepay this$shopeepay = this.getShopeepay();
            Shopeepay other$shopeepay = other.getShopeepay();
            if (this$shopeepay == null ? other$shopeepay != null : !((Object)this$shopeepay).equals(other$shopeepay)) {
                return false;
            }
            Sofort this$sofort = this.getSofort();
            Sofort other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                return false;
            }
            StripeAccount this$stripeAccount = this.getStripeAccount();
            StripeAccount other$stripeAccount = other.getStripeAccount();
            if (this$stripeAccount == null ? other$stripeAccount != null : !((Object)this$stripeAccount).equals(other$stripeAccount)) {
                return false;
            }
            StripeBalance this$stripeBalance = this.getStripeBalance();
            StripeBalance other$stripeBalance = other.getStripeBalance();
            if (this$stripeBalance == null ? other$stripeBalance != null : !((Object)this$stripeBalance).equals(other$stripeBalance)) {
                return false;
            }
            Swish this$swish = this.getSwish();
            Swish other$swish = other.getSwish();
            if (this$swish == null ? other$swish != null : !((Object)this$swish).equals(other$swish)) {
                return false;
            }
            Twint this$twint = this.getTwint();
            Twint other$twint = other.getTwint();
            if (this$twint == null ? other$twint != null : !((Object)this$twint).equals(other$twint)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            if (this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount)) {
                return false;
            }
            Wechat this$wechat = this.getWechat();
            Wechat other$wechat = other.getWechat();
            if (this$wechat == null ? other$wechat != null : !((Object)this$wechat).equals(other$wechat)) {
                return false;
            }
            WechatPay this$wechatPay = this.getWechatPay();
            WechatPay other$wechatPay = other.getWechatPay();
            if (this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay)) {
                return false;
            }
            Zip this$zip = this.getZip();
            Zip other$zip = other.getZip();
            return !(this$zip == null ? other$zip != null : !((Object)this$zip).equals(other$zip));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AchCreditTransfer $achCreditTransfer = this.getAchCreditTransfer();
            result = result * 59 + ($achCreditTransfer == null ? 43 : ((Object)$achCreditTransfer).hashCode());
            AchDebit $achDebit = this.getAchDebit();
            result = result * 59 + ($achDebit == null ? 43 : ((Object)$achDebit).hashCode());
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            Affirm $affirm = this.getAffirm();
            result = result * 59 + ($affirm == null ? 43 : ((Object)$affirm).hashCode());
            AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
            result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
            Alipay $alipay = this.getAlipay();
            result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
            Alma $alma = this.getAlma();
            result = result * 59 + ($alma == null ? 43 : ((Object)$alma).hashCode());
            AmazonPay $amazonPay = this.getAmazonPay();
            result = result * 59 + ($amazonPay == null ? 43 : ((Object)$amazonPay).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Bancontact $bancontact = this.getBancontact();
            result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
            Billie $billie = this.getBillie();
            result = result * 59 + ($billie == null ? 43 : ((Object)$billie).hashCode());
            BillingDetails $billingDetails = this.getBillingDetails();
            result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
            Blik $blik = this.getBlik();
            result = result * 59 + ($blik == null ? 43 : ((Object)$blik).hashCode());
            Boleto $boleto = this.getBoleto();
            result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            CardPresent $cardPresent = this.getCardPresent();
            result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
            Cashapp $cashapp = this.getCashapp();
            result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
            Custom $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
            CustomerBalance $customerBalance = this.getCustomerBalance();
            result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
            Eps $eps = this.getEps();
            result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
            Fpx $fpx = this.getFpx();
            result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
            Giropay $giropay = this.getGiropay();
            result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
            Gopay $gopay = this.getGopay();
            result = result * 59 + ($gopay == null ? 43 : ((Object)$gopay).hashCode());
            Grabpay $grabpay = this.getGrabpay();
            result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
            IdBankTransfer $idBankTransfer = this.getIdBankTransfer();
            result = result * 59 + ($idBankTransfer == null ? 43 : ((Object)$idBankTransfer).hashCode());
            Ideal $ideal = this.getIdeal();
            result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
            InteracPresent $interacPresent = this.getInteracPresent();
            result = result * 59 + ($interacPresent == null ? 43 : ((Object)$interacPresent).hashCode());
            KakaoPay $kakaoPay = this.getKakaoPay();
            result = result * 59 + ($kakaoPay == null ? 43 : ((Object)$kakaoPay).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            Konbini $konbini = this.getKonbini();
            result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
            KrCard $krCard = this.getKrCard();
            result = result * 59 + ($krCard == null ? 43 : ((Object)$krCard).hashCode());
            Link $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            MbWay $mbWay = this.getMbWay();
            result = result * 59 + ($mbWay == null ? 43 : ((Object)$mbWay).hashCode());
            Mobilepay $mobilepay = this.getMobilepay();
            result = result * 59 + ($mobilepay == null ? 43 : ((Object)$mobilepay).hashCode());
            Multibanco $multibanco = this.getMultibanco();
            result = result * 59 + ($multibanco == null ? 43 : ((Object)$multibanco).hashCode());
            NaverPay $naverPay = this.getNaverPay();
            result = result * 59 + ($naverPay == null ? 43 : ((Object)$naverPay).hashCode());
            NzBankAccount $nzBankAccount = this.getNzBankAccount();
            result = result * 59 + ($nzBankAccount == null ? 43 : ((Object)$nzBankAccount).hashCode());
            Oxxo $oxxo = this.getOxxo();
            result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
            P24 $p24 = this.getP24();
            result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
            PayByBank $payByBank = this.getPayByBank();
            result = result * 59 + ($payByBank == null ? 43 : ((Object)$payByBank).hashCode());
            Payco $payco = this.getPayco();
            result = result * 59 + ($payco == null ? 43 : ((Object)$payco).hashCode());
            String $paymentMethod = this.getPaymentMethod();
            result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
            Paynow $paynow = this.getPaynow();
            result = result * 59 + ($paynow == null ? 43 : ((Object)$paynow).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            Payto $payto = this.getPayto();
            result = result * 59 + ($payto == null ? 43 : ((Object)$payto).hashCode());
            Pix $pix = this.getPix();
            result = result * 59 + ($pix == null ? 43 : ((Object)$pix).hashCode());
            Promptpay $promptpay = this.getPromptpay();
            result = result * 59 + ($promptpay == null ? 43 : ((Object)$promptpay).hashCode());
            Qris $qris = this.getQris();
            result = result * 59 + ($qris == null ? 43 : ((Object)$qris).hashCode());
            Rechnung $rechnung = this.getRechnung();
            result = result * 59 + ($rechnung == null ? 43 : ((Object)$rechnung).hashCode());
            RevolutPay $revolutPay = this.getRevolutPay();
            result = result * 59 + ($revolutPay == null ? 43 : ((Object)$revolutPay).hashCode());
            SamsungPay $samsungPay = this.getSamsungPay();
            result = result * 59 + ($samsungPay == null ? 43 : ((Object)$samsungPay).hashCode());
            Satispay $satispay = this.getSatispay();
            result = result * 59 + ($satispay == null ? 43 : ((Object)$satispay).hashCode());
            SepaCreditTransfer $sepaCreditTransfer = this.getSepaCreditTransfer();
            result = result * 59 + ($sepaCreditTransfer == null ? 43 : ((Object)$sepaCreditTransfer).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            Shopeepay $shopeepay = this.getShopeepay();
            result = result * 59 + ($shopeepay == null ? 43 : ((Object)$shopeepay).hashCode());
            Sofort $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
            StripeAccount $stripeAccount = this.getStripeAccount();
            result = result * 59 + ($stripeAccount == null ? 43 : ((Object)$stripeAccount).hashCode());
            StripeBalance $stripeBalance = this.getStripeBalance();
            result = result * 59 + ($stripeBalance == null ? 43 : ((Object)$stripeBalance).hashCode());
            Swish $swish = this.getSwish();
            result = result * 59 + ($swish == null ? 43 : ((Object)$swish).hashCode());
            Twint $twint = this.getTwint();
            result = result * 59 + ($twint == null ? 43 : ((Object)$twint).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            Wechat $wechat = this.getWechat();
            result = result * 59 + ($wechat == null ? 43 : ((Object)$wechat).hashCode());
            WechatPay $wechatPay = this.getWechatPay();
            result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
            Zip $zip = this.getZip();
            result = result * 59 + ($zip == null ? 43 : ((Object)$zip).hashCode());
            return result;
        }

        public static class AchCreditTransfer
        extends StripeObject {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="routing_number")
            String routingNumber;
            @SerializedName(value="swift_code")
            String swiftCode;

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public String getSwiftCode() {
                return this.swiftCode;
            }

            @Generated
            public void setAccountNumber(String accountNumber) {
                this.accountNumber = accountNumber;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public void setSwiftCode(String swiftCode) {
                this.swiftCode = swiftCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AchCreditTransfer)) {
                    return false;
                }
                AchCreditTransfer other = (AchCreditTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) {
                    return false;
                }
                String this$swiftCode = this.getSwiftCode();
                String other$swiftCode = other.getSwiftCode();
                return !(this$swiftCode == null ? other$swiftCode != null : !this$swiftCode.equals(other$swiftCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AchCreditTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                String $swiftCode = this.getSwiftCode();
                result = result * 59 + ($swiftCode == null ? 43 : $swiftCode.hashCode());
                return result;
            }
        }

        public static class AchDebit
        extends StripeObject {
            @SerializedName(value="account_holder_type")
            String accountHolderType;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="routing_number")
            String routingNumber;

            @Generated
            public String getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public void setAccountHolderType(String accountHolderType) {
                this.accountHolderType = accountHolderType;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AchDebit)) {
                    return false;
                }
                AchDebit other = (AchDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderType = this.getAccountHolderType();
                String other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AchDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                return result;
            }
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="institution_number")
            String institutionNumber;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="mandate")
            String mandate;
            @SerializedName(value="transit_number")
            String transitNumber;

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getInstitutionNumber() {
                return this.institutionNumber;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getMandate() {
                return this.mandate;
            }

            @Generated
            public String getTransitNumber() {
                return this.transitNumber;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setInstitutionNumber(String institutionNumber) {
                this.institutionNumber = institutionNumber;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMandate(String mandate) {
                this.mandate = mandate;
            }

            @Generated
            public void setTransitNumber(String transitNumber) {
                this.transitNumber = transitNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$institutionNumber = this.getInstitutionNumber();
                String other$institutionNumber = other.getInstitutionNumber();
                if (this$institutionNumber == null ? other$institutionNumber != null : !this$institutionNumber.equals(other$institutionNumber)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$mandate = this.getMandate();
                String other$mandate = other.getMandate();
                if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) {
                    return false;
                }
                String this$transitNumber = this.getTransitNumber();
                String other$transitNumber = other.getTransitNumber();
                return !(this$transitNumber == null ? other$transitNumber != null : !this$transitNumber.equals(other$transitNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $institutionNumber = this.getInstitutionNumber();
                result = result * 59 + ($institutionNumber == null ? 43 : $institutionNumber.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $mandate = this.getMandate();
                result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
                String $transitNumber = this.getTransitNumber();
                result = result * 59 + ($transitNumber == null ? 43 : $transitNumber.hashCode());
                return result;
            }
        }

        public static class Affirm
        extends StripeObject {
            @SerializedName(value="location")
            String location;
            @SerializedName(value="reader")
            String reader;
            @SerializedName(value="transaction_id")
            String transactionId;

            @Generated
            public String getLocation() {
                return this.location;
            }

            @Generated
            public String getReader() {
                return this.reader;
            }

            @Generated
            public String getTransactionId() {
                return this.transactionId;
            }

            @Generated
            public void setLocation(String location) {
                this.location = location;
            }

            @Generated
            public void setReader(String reader) {
                this.reader = reader;
            }

            @Generated
            public void setTransactionId(String transactionId) {
                this.transactionId = transactionId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Affirm)) {
                    return false;
                }
                Affirm other = (Affirm)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$location = this.getLocation();
                String other$location = other.getLocation();
                if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                    return false;
                }
                String this$reader = this.getReader();
                String other$reader = other.getReader();
                if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
                    return false;
                }
                String this$transactionId = this.getTransactionId();
                String other$transactionId = other.getTransactionId();
                return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Affirm;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $location = this.getLocation();
                result = result * 59 + ($location == null ? 43 : $location.hashCode());
                String $reader = this.getReader();
                result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
                String $transactionId = this.getTransactionId();
                result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                return result;
            }
        }

        public static class AfterpayClearpay
        extends StripeObject {
            @SerializedName(value="order_id")
            String orderId;
            @SerializedName(value="reference")
            String reference;

            @Generated
            public String getOrderId() {
                return this.orderId;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public void setOrderId(String orderId) {
                this.orderId = orderId;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AfterpayClearpay)) {
                    return false;
                }
                AfterpayClearpay other = (AfterpayClearpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$orderId = this.getOrderId();
                String other$orderId = other.getOrderId();
                if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AfterpayClearpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $orderId = this.getOrderId();
                result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                return result;
            }
        }

        public static class Alipay
        extends StripeObject {
            @SerializedName(value="buyer_id")
            String buyerId;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="transaction_id")
            String transactionId;

            @Generated
            public String getBuyerId() {
                return this.buyerId;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getTransactionId() {
                return this.transactionId;
            }

            @Generated
            public void setBuyerId(String buyerId) {
                this.buyerId = buyerId;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setTransactionId(String transactionId) {
                this.transactionId = transactionId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alipay)) {
                    return false;
                }
                Alipay other = (Alipay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$buyerId = this.getBuyerId();
                String other$buyerId = other.getBuyerId();
                if (this$buyerId == null ? other$buyerId != null : !this$buyerId.equals(other$buyerId)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$transactionId = this.getTransactionId();
                String other$transactionId = other.getTransactionId();
                return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alipay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $buyerId = this.getBuyerId();
                result = result * 59 + ($buyerId == null ? 43 : $buyerId.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $transactionId = this.getTransactionId();
                result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                return result;
            }
        }

        public static class Alma
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alma)) {
                    return false;
                }
                Alma other = (Alma)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alma;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AmazonPay
        extends StripeObject {
            @SerializedName(value="funding")
            Funding funding;

            @Generated
            public Funding getFunding() {
                return this.funding;
            }

            @Generated
            public void setFunding(Funding funding) {
                this.funding = funding;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AmazonPay)) {
                    return false;
                }
                AmazonPay other = (AmazonPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Funding this$funding = this.getFunding();
                Funding other$funding = other.getFunding();
                return !(this$funding == null ? other$funding != null : !((Object)this$funding).equals(other$funding));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AmazonPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Funding $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : ((Object)$funding).hashCode());
                return result;
            }

            public static class Funding
            extends StripeObject {
                @SerializedName(value="card")
                Card card;
                @SerializedName(value="type")
                String type;

                @Generated
                public Card getCard() {
                    return this.card;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setCard(Card card) {
                    this.card = card;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Funding)) {
                        return false;
                    }
                    Funding other = (Funding)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Card this$card = this.getCard();
                    Card other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Funding;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Card $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class Card
                extends StripeObject {
                    @SerializedName(value="brand")
                    String brand;
                    @SerializedName(value="brand_product")
                    String brandProduct;
                    @SerializedName(value="country")
                    String country;
                    @SerializedName(value="exp_month")
                    Long expMonth;
                    @SerializedName(value="exp_year")
                    Long expYear;
                    @SerializedName(value="funding")
                    String funding;
                    @SerializedName(value="last4")
                    String last4;

                    @Generated
                    public String getBrand() {
                        return this.brand;
                    }

                    @Generated
                    public String getBrandProduct() {
                        return this.brandProduct;
                    }

                    @Generated
                    public String getCountry() {
                        return this.country;
                    }

                    @Generated
                    public Long getExpMonth() {
                        return this.expMonth;
                    }

                    @Generated
                    public Long getExpYear() {
                        return this.expYear;
                    }

                    @Generated
                    public String getFunding() {
                        return this.funding;
                    }

                    @Generated
                    public String getLast4() {
                        return this.last4;
                    }

                    @Generated
                    public void setBrand(String brand) {
                        this.brand = brand;
                    }

                    @Generated
                    public void setBrandProduct(String brandProduct) {
                        this.brandProduct = brandProduct;
                    }

                    @Generated
                    public void setCountry(String country) {
                        this.country = country;
                    }

                    @Generated
                    public void setExpMonth(Long expMonth) {
                        this.expMonth = expMonth;
                    }

                    @Generated
                    public void setExpYear(Long expYear) {
                        this.expYear = expYear;
                    }

                    @Generated
                    public void setFunding(String funding) {
                        this.funding = funding;
                    }

                    @Generated
                    public void setLast4(String last4) {
                        this.last4 = last4;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Card)) {
                            return false;
                        }
                        Card other = (Card)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$expMonth = this.getExpMonth();
                        Long other$expMonth = other.getExpMonth();
                        if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                            return false;
                        }
                        Long this$expYear = this.getExpYear();
                        Long other$expYear = other.getExpYear();
                        if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                            return false;
                        }
                        String this$brand = this.getBrand();
                        String other$brand = other.getBrand();
                        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                            return false;
                        }
                        String this$brandProduct = this.getBrandProduct();
                        String other$brandProduct = other.getBrandProduct();
                        if (this$brandProduct == null ? other$brandProduct != null : !this$brandProduct.equals(other$brandProduct)) {
                            return false;
                        }
                        String this$country = this.getCountry();
                        String other$country = other.getCountry();
                        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                            return false;
                        }
                        String this$funding = this.getFunding();
                        String other$funding = other.getFunding();
                        if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                            return false;
                        }
                        String this$last4 = this.getLast4();
                        String other$last4 = other.getLast4();
                        return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Card;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $expMonth = this.getExpMonth();
                        result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                        Long $expYear = this.getExpYear();
                        result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                        String $brand = this.getBrand();
                        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                        String $brandProduct = this.getBrandProduct();
                        result = result * 59 + ($brandProduct == null ? 43 : $brandProduct.hashCode());
                        String $country = this.getCountry();
                        result = result * 59 + ($country == null ? 43 : $country.hashCode());
                        String $funding = this.getFunding();
                        result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                        String $last4 = this.getLast4();
                        result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class AuBecsDebit
        extends StripeObject {
            @SerializedName(value="bsb_number")
            String bsbNumber;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="mandate")
            String mandate;

            @Generated
            public String getBsbNumber() {
                return this.bsbNumber;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getMandate() {
                return this.mandate;
            }

            @Generated
            public void setBsbNumber(String bsbNumber) {
                this.bsbNumber = bsbNumber;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMandate(String mandate) {
                this.mandate = mandate;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBecsDebit)) {
                    return false;
                }
                AuBecsDebit other = (AuBecsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bsbNumber = this.getBsbNumber();
                String other$bsbNumber = other.getBsbNumber();
                if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$mandate = this.getMandate();
                String other$mandate = other.getMandate();
                return !(this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBecsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bsbNumber = this.getBsbNumber();
                result = result * 59 + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $mandate = this.getMandate();
                result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
                return result;
            }
        }

        public static class BacsDebit
        extends StripeObject {
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="mandate")
            String mandate;
            @SerializedName(value="sort_code")
            String sortCode;

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getMandate() {
                return this.mandate;
            }

            @Generated
            public String getSortCode() {
                return this.sortCode;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMandate(String mandate) {
                this.mandate = mandate;
            }

            @Generated
            public void setSortCode(String sortCode) {
                this.sortCode = sortCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebit)) {
                    return false;
                }
                BacsDebit other = (BacsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$mandate = this.getMandate();
                String other$mandate = other.getMandate();
                if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) {
                    return false;
                }
                String this$sortCode = this.getSortCode();
                String other$sortCode = other.getSortCode();
                return !(this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $mandate = this.getMandate();
                result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
                String $sortCode = this.getSortCode();
                result = result * 59 + ($sortCode == null ? 43 : $sortCode.hashCode());
                return result;
            }
        }

        public static class Bancontact
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="generated_sepa_debit")
            ExpandableField<PaymentMethod> generatedSepaDebit;
            @SerializedName(value="generated_sepa_debit_mandate")
            ExpandableField<Mandate> generatedSepaDebitMandate;
            @SerializedName(value="iban_last4")
            String ibanLast4;
            @SerializedName(value="preferred_language")
            String preferredLanguage;
            @SerializedName(value="verified_name")
            String verifiedName;

            public String getGeneratedSepaDebit() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getId() : null;
            }

            public void setGeneratedSepaDebit(String id) {
                this.generatedSepaDebit = ApiResource.setExpandableFieldId(id, this.generatedSepaDebit);
            }

            public PaymentMethod getGeneratedSepaDebitObject() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getExpanded() : null;
            }

            public void setGeneratedSepaDebitObject(PaymentMethod expandableObject) {
                this.generatedSepaDebit = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
            }

            public String getGeneratedSepaDebitMandate() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getId() : null;
            }

            public void setGeneratedSepaDebitMandate(String id) {
                this.generatedSepaDebitMandate = ApiResource.setExpandableFieldId(id, this.generatedSepaDebitMandate);
            }

            public Mandate getGeneratedSepaDebitMandateObject() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getExpanded() : null;
            }

            public void setGeneratedSepaDebitMandateObject(Mandate expandableObject) {
                this.generatedSepaDebitMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getIbanLast4() {
                return this.ibanLast4;
            }

            @Generated
            public String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setIbanLast4(String ibanLast4) {
                this.ibanLast4 = ibanLast4;
            }

            @Generated
            public void setPreferredLanguage(String preferredLanguage) {
                this.preferredLanguage = preferredLanguage;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bancontact)) {
                    return false;
                }
                Bancontact other = (Bancontact)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$generatedSepaDebit = this.getGeneratedSepaDebit();
                String other$generatedSepaDebit = other.getGeneratedSepaDebit();
                if (this$generatedSepaDebit == null ? other$generatedSepaDebit != null : !this$generatedSepaDebit.equals(other$generatedSepaDebit)) {
                    return false;
                }
                String this$generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                String other$generatedSepaDebitMandate = other.getGeneratedSepaDebitMandate();
                if (this$generatedSepaDebitMandate == null ? other$generatedSepaDebitMandate != null : !this$generatedSepaDebitMandate.equals(other$generatedSepaDebitMandate)) {
                    return false;
                }
                String this$ibanLast4 = this.getIbanLast4();
                String other$ibanLast4 = other.getIbanLast4();
                if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                    return false;
                }
                String this$preferredLanguage = this.getPreferredLanguage();
                String other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bancontact;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $generatedSepaDebit = this.getGeneratedSepaDebit();
                result = result * 59 + ($generatedSepaDebit == null ? 43 : $generatedSepaDebit.hashCode());
                String $generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                result = result * 59 + ($generatedSepaDebitMandate == null ? 43 : $generatedSepaDebitMandate.hashCode());
                String $ibanLast4 = this.getIbanLast4();
                result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
                String $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class Billie
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Billie)) {
                    return false;
                }
                Billie other = (Billie)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Billie;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class BillingDetails
        extends StripeObject {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="email")
            String email;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="phone")
            String phone;

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getEmail() {
                return this.email;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getPhone() {
                return this.phone;
            }

            @Generated
            public void setAddress(Address address) {
                this.address = address;
            }

            @Generated
            public void setEmail(String email) {
                this.email = email;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setPhone(String phone) {
                this.phone = phone;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingDetails)) {
                    return false;
                }
                BillingDetails other = (BillingDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                String this$email = this.getEmail();
                String other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$phone = this.getPhone();
                String other$phone = other.getPhone();
                return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                String $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $phone = this.getPhone();
                result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                return result;
            }

            public static class Address
            extends StripeObject {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                @Generated
                public void setCity(String city) {
                    this.city = city;
                }

                @Generated
                public void setCountry(String country) {
                    this.country = country;
                }

                @Generated
                public void setLine1(String line1) {
                    this.line1 = line1;
                }

                @Generated
                public void setLine2(String line2) {
                    this.line2 = line2;
                }

                @Generated
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                @Generated
                public void setState(String state) {
                    this.state = state;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Address)) {
                        return false;
                    }
                    Address other = (Address)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$city = this.getCity();
                    String other$city = other.getCity();
                    if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    String this$line1 = this.getLine1();
                    String other$line1 = other.getLine1();
                    if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                        return false;
                    }
                    String this$line2 = this.getLine2();
                    String other$line2 = other.getLine2();
                    if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                        return false;
                    }
                    String this$postalCode = this.getPostalCode();
                    String other$postalCode = other.getPostalCode();
                    if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                        return false;
                    }
                    String this$state = this.getState();
                    String other$state = other.getState();
                    return !(this$state == null ? other$state != null : !this$state.equals(other$state));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Address;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $city = this.getCity();
                    result = result * 59 + ($city == null ? 43 : $city.hashCode());
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    String $line1 = this.getLine1();
                    result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                    String $line2 = this.getLine2();
                    result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                    String $postalCode = this.getPostalCode();
                    result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                    String $state = this.getState();
                    result = result * 59 + ($state == null ? 43 : $state.hashCode());
                    return result;
                }
            }
        }

        public static class Blik
        extends StripeObject {
            @SerializedName(value="buyer_id")
            String buyerId;

            @Generated
            public String getBuyerId() {
                return this.buyerId;
            }

            @Generated
            public void setBuyerId(String buyerId) {
                this.buyerId = buyerId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Blik)) {
                    return false;
                }
                Blik other = (Blik)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$buyerId = this.getBuyerId();
                String other$buyerId = other.getBuyerId();
                return !(this$buyerId == null ? other$buyerId != null : !this$buyerId.equals(other$buyerId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Blik;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $buyerId = this.getBuyerId();
                result = result * 59 + ($buyerId == null ? 43 : $buyerId.hashCode());
                return result;
            }
        }

        public static class Boleto
        extends StripeObject {
            @SerializedName(value="tax_id")
            String taxId;

            @Generated
            public String getTaxId() {
                return this.taxId;
            }

            @Generated
            public void setTaxId(String taxId) {
                this.taxId = taxId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Boleto)) {
                    return false;
                }
                Boleto other = (Boleto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$taxId = this.getTaxId();
                String other$taxId = other.getTaxId();
                return !(this$taxId == null ? other$taxId != null : !this$taxId.equals(other$taxId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Boleto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $taxId = this.getTaxId();
                result = result * 59 + ($taxId == null ? 43 : $taxId.hashCode());
                return result;
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="capture_before")
            Long captureBefore;
            @SerializedName(value="checks")
            Checks checks;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="moto")
            Boolean moto;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="network_token")
            NetworkToken networkToken;
            @SerializedName(value="network_transaction_id")
            String networkTransactionId;
            @SerializedName(value="three_d_secure")
            ThreeDSecure threeDSecure;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public Long getCaptureBefore() {
                return this.captureBefore;
            }

            @Generated
            public Checks getChecks() {
                return this.checks;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public Boolean getMoto() {
                return this.moto;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public NetworkToken getNetworkToken() {
                return this.networkToken;
            }

            @Generated
            public String getNetworkTransactionId() {
                return this.networkTransactionId;
            }

            @Generated
            public ThreeDSecure getThreeDSecure() {
                return this.threeDSecure;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setCaptureBefore(Long captureBefore) {
                this.captureBefore = captureBefore;
            }

            @Generated
            public void setChecks(Checks checks) {
                this.checks = checks;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMoto(Boolean moto) {
                this.moto = moto;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setNetworkToken(NetworkToken networkToken) {
                this.networkToken = networkToken;
            }

            @Generated
            public void setNetworkTransactionId(String networkTransactionId) {
                this.networkTransactionId = networkTransactionId;
            }

            @Generated
            public void setThreeDSecure(ThreeDSecure threeDSecure) {
                this.threeDSecure = threeDSecure;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$captureBefore = this.getCaptureBefore();
                Long other$captureBefore = other.getCaptureBefore();
                if (this$captureBefore == null ? other$captureBefore != null : !((Object)this$captureBefore).equals(other$captureBefore)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                Boolean this$moto = this.getMoto();
                Boolean other$moto = other.getMoto();
                if (this$moto == null ? other$moto != null : !((Object)this$moto).equals(other$moto)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                Checks this$checks = this.getChecks();
                Checks other$checks = other.getChecks();
                if (this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                NetworkToken this$networkToken = this.getNetworkToken();
                NetworkToken other$networkToken = other.getNetworkToken();
                if (this$networkToken == null ? other$networkToken != null : !((Object)this$networkToken).equals(other$networkToken)) {
                    return false;
                }
                String this$networkTransactionId = this.getNetworkTransactionId();
                String other$networkTransactionId = other.getNetworkTransactionId();
                if (this$networkTransactionId == null ? other$networkTransactionId != null : !this$networkTransactionId.equals(other$networkTransactionId)) {
                    return false;
                }
                ThreeDSecure this$threeDSecure = this.getThreeDSecure();
                ThreeDSecure other$threeDSecure = other.getThreeDSecure();
                return !(this$threeDSecure == null ? other$threeDSecure != null : !((Object)this$threeDSecure).equals(other$threeDSecure));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $captureBefore = this.getCaptureBefore();
                result = result * 59 + ($captureBefore == null ? 43 : ((Object)$captureBefore).hashCode());
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                Boolean $moto = this.getMoto();
                result = result * 59 + ($moto == null ? 43 : ((Object)$moto).hashCode());
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                Checks $checks = this.getChecks();
                result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                NetworkToken $networkToken = this.getNetworkToken();
                result = result * 59 + ($networkToken == null ? 43 : ((Object)$networkToken).hashCode());
                String $networkTransactionId = this.getNetworkTransactionId();
                result = result * 59 + ($networkTransactionId == null ? 43 : $networkTransactionId.hashCode());
                ThreeDSecure $threeDSecure = this.getThreeDSecure();
                result = result * 59 + ($threeDSecure == null ? 43 : ((Object)$threeDSecure).hashCode());
                return result;
            }

            public static class Checks
            extends StripeObject {
                @SerializedName(value="address_line1_check")
                String addressLine1Check;
                @SerializedName(value="address_postal_code_check")
                String addressPostalCodeCheck;
                @SerializedName(value="cvc_check")
                String cvcCheck;

                @Generated
                public String getAddressLine1Check() {
                    return this.addressLine1Check;
                }

                @Generated
                public String getAddressPostalCodeCheck() {
                    return this.addressPostalCodeCheck;
                }

                @Generated
                public String getCvcCheck() {
                    return this.cvcCheck;
                }

                @Generated
                public void setAddressLine1Check(String addressLine1Check) {
                    this.addressLine1Check = addressLine1Check;
                }

                @Generated
                public void setAddressPostalCodeCheck(String addressPostalCodeCheck) {
                    this.addressPostalCodeCheck = addressPostalCodeCheck;
                }

                @Generated
                public void setCvcCheck(String cvcCheck) {
                    this.cvcCheck = cvcCheck;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Checks)) {
                        return false;
                    }
                    Checks other = (Checks)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$addressLine1Check = this.getAddressLine1Check();
                    String other$addressLine1Check = other.getAddressLine1Check();
                    if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                        return false;
                    }
                    String this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                    String other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
                    if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) {
                        return false;
                    }
                    String this$cvcCheck = this.getCvcCheck();
                    String other$cvcCheck = other.getCvcCheck();
                    return !(this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Checks;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $addressLine1Check = this.getAddressLine1Check();
                    result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
                    String $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                    result = result * 59 + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
                    String $cvcCheck = this.getCvcCheck();
                    result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
                    return result;
                }
            }

            public static class NetworkToken
            extends StripeObject {
                @SerializedName(value="used")
                Boolean used;

                @Generated
                public Boolean getUsed() {
                    return this.used;
                }

                @Generated
                public void setUsed(Boolean used) {
                    this.used = used;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof NetworkToken)) {
                        return false;
                    }
                    NetworkToken other = (NetworkToken)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$used = this.getUsed();
                    Boolean other$used = other.getUsed();
                    return !(this$used == null ? other$used != null : !((Object)this$used).equals(other$used));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof NetworkToken;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $used = this.getUsed();
                    result = result * 59 + ($used == null ? 43 : ((Object)$used).hashCode());
                    return result;
                }
            }

            public static class ThreeDSecure
            extends StripeObject {
                @SerializedName(value="authentication_flow")
                String authenticationFlow;
                @SerializedName(value="result")
                String result;
                @SerializedName(value="result_reason")
                String resultReason;
                @SerializedName(value="version")
                String version;

                @Generated
                public String getAuthenticationFlow() {
                    return this.authenticationFlow;
                }

                @Generated
                public String getResult() {
                    return this.result;
                }

                @Generated
                public String getResultReason() {
                    return this.resultReason;
                }

                @Generated
                public String getVersion() {
                    return this.version;
                }

                @Generated
                public void setAuthenticationFlow(String authenticationFlow) {
                    this.authenticationFlow = authenticationFlow;
                }

                @Generated
                public void setResult(String result) {
                    this.result = result;
                }

                @Generated
                public void setResultReason(String resultReason) {
                    this.resultReason = resultReason;
                }

                @Generated
                public void setVersion(String version) {
                    this.version = version;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ThreeDSecure)) {
                        return false;
                    }
                    ThreeDSecure other = (ThreeDSecure)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$authenticationFlow = this.getAuthenticationFlow();
                    String other$authenticationFlow = other.getAuthenticationFlow();
                    if (this$authenticationFlow == null ? other$authenticationFlow != null : !this$authenticationFlow.equals(other$authenticationFlow)) {
                        return false;
                    }
                    String this$result = this.getResult();
                    String other$result = other.getResult();
                    if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                        return false;
                    }
                    String this$resultReason = this.getResultReason();
                    String other$resultReason = other.getResultReason();
                    if (this$resultReason == null ? other$resultReason != null : !this$resultReason.equals(other$resultReason)) {
                        return false;
                    }
                    String this$version = this.getVersion();
                    String other$version = other.getVersion();
                    return !(this$version == null ? other$version != null : !this$version.equals(other$version));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ThreeDSecure;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $authenticationFlow = this.getAuthenticationFlow();
                    result = result * 59 + ($authenticationFlow == null ? 43 : $authenticationFlow.hashCode());
                    String $result = this.getResult();
                    result = result * 59 + ($result == null ? 43 : $result.hashCode());
                    String $resultReason = this.getResultReason();
                    result = result * 59 + ($resultReason == null ? 43 : $resultReason.hashCode());
                    String $version = this.getVersion();
                    result = result * 59 + ($version == null ? 43 : $version.hashCode());
                    return result;
                }
            }
        }

        public static class CardPresent
        extends StripeObject {
            @SerializedName(value="amount_authorized")
            Long amountAuthorized;
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="brand_product")
            String brandProduct;
            @SerializedName(value="capture_before")
            Long captureBefore;
            @SerializedName(value="cardholder_name")
            String cardholderName;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="emv_auth_data")
            String emvAuthData;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="generated_card")
            String generatedCard;
            @SerializedName(value="iin")
            String iin;
            @SerializedName(value="incremental_authorization_supported")
            Boolean incrementalAuthorizationSupported;
            @SerializedName(value="issuer")
            String issuer;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="network_transaction_id")
            String networkTransactionId;
            @SerializedName(value="offline")
            Offline offline;
            @SerializedName(value="overcapture_supported")
            Boolean overcaptureSupported;
            @SerializedName(value="preferred_locales")
            List<String> preferredLocales;
            @SerializedName(value="read_method")
            String readMethod;
            @SerializedName(value="receipt")
            Receipt receipt;
            @SerializedName(value="wallet")
            Wallet wallet;

            @Generated
            public Long getAmountAuthorized() {
                return this.amountAuthorized;
            }

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public String getBrandProduct() {
                return this.brandProduct;
            }

            @Generated
            public Long getCaptureBefore() {
                return this.captureBefore;
            }

            @Generated
            public String getCardholderName() {
                return this.cardholderName;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public String getEmvAuthData() {
                return this.emvAuthData;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public String getGeneratedCard() {
                return this.generatedCard;
            }

            @Generated
            public String getIin() {
                return this.iin;
            }

            @Generated
            public Boolean getIncrementalAuthorizationSupported() {
                return this.incrementalAuthorizationSupported;
            }

            @Generated
            public String getIssuer() {
                return this.issuer;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public String getNetworkTransactionId() {
                return this.networkTransactionId;
            }

            @Generated
            public Offline getOffline() {
                return this.offline;
            }

            @Generated
            public Boolean getOvercaptureSupported() {
                return this.overcaptureSupported;
            }

            @Generated
            public List<String> getPreferredLocales() {
                return this.preferredLocales;
            }

            @Generated
            public String getReadMethod() {
                return this.readMethod;
            }

            @Generated
            public Receipt getReceipt() {
                return this.receipt;
            }

            @Generated
            public Wallet getWallet() {
                return this.wallet;
            }

            @Generated
            public void setAmountAuthorized(Long amountAuthorized) {
                this.amountAuthorized = amountAuthorized;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setBrandProduct(String brandProduct) {
                this.brandProduct = brandProduct;
            }

            @Generated
            public void setCaptureBefore(Long captureBefore) {
                this.captureBefore = captureBefore;
            }

            @Generated
            public void setCardholderName(String cardholderName) {
                this.cardholderName = cardholderName;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setEmvAuthData(String emvAuthData) {
                this.emvAuthData = emvAuthData;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setGeneratedCard(String generatedCard) {
                this.generatedCard = generatedCard;
            }

            @Generated
            public void setIin(String iin) {
                this.iin = iin;
            }

            @Generated
            public void setIncrementalAuthorizationSupported(Boolean incrementalAuthorizationSupported) {
                this.incrementalAuthorizationSupported = incrementalAuthorizationSupported;
            }

            @Generated
            public void setIssuer(String issuer) {
                this.issuer = issuer;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setNetworkTransactionId(String networkTransactionId) {
                this.networkTransactionId = networkTransactionId;
            }

            @Generated
            public void setOffline(Offline offline) {
                this.offline = offline;
            }

            @Generated
            public void setOvercaptureSupported(Boolean overcaptureSupported) {
                this.overcaptureSupported = overcaptureSupported;
            }

            @Generated
            public void setPreferredLocales(List<String> preferredLocales) {
                this.preferredLocales = preferredLocales;
            }

            @Generated
            public void setReadMethod(String readMethod) {
                this.readMethod = readMethod;
            }

            @Generated
            public void setReceipt(Receipt receipt) {
                this.receipt = receipt;
            }

            @Generated
            public void setWallet(Wallet wallet) {
                this.wallet = wallet;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardPresent)) {
                    return false;
                }
                CardPresent other = (CardPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amountAuthorized = this.getAmountAuthorized();
                Long other$amountAuthorized = other.getAmountAuthorized();
                if (this$amountAuthorized == null ? other$amountAuthorized != null : !((Object)this$amountAuthorized).equals(other$amountAuthorized)) {
                    return false;
                }
                Long this$captureBefore = this.getCaptureBefore();
                Long other$captureBefore = other.getCaptureBefore();
                if (this$captureBefore == null ? other$captureBefore != null : !((Object)this$captureBefore).equals(other$captureBefore)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                Boolean this$incrementalAuthorizationSupported = this.getIncrementalAuthorizationSupported();
                Boolean other$incrementalAuthorizationSupported = other.getIncrementalAuthorizationSupported();
                if (this$incrementalAuthorizationSupported == null ? other$incrementalAuthorizationSupported != null : !((Object)this$incrementalAuthorizationSupported).equals(other$incrementalAuthorizationSupported)) {
                    return false;
                }
                Boolean this$overcaptureSupported = this.getOvercaptureSupported();
                Boolean other$overcaptureSupported = other.getOvercaptureSupported();
                if (this$overcaptureSupported == null ? other$overcaptureSupported != null : !((Object)this$overcaptureSupported).equals(other$overcaptureSupported)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                String this$brandProduct = this.getBrandProduct();
                String other$brandProduct = other.getBrandProduct();
                if (this$brandProduct == null ? other$brandProduct != null : !this$brandProduct.equals(other$brandProduct)) {
                    return false;
                }
                String this$cardholderName = this.getCardholderName();
                String other$cardholderName = other.getCardholderName();
                if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$emvAuthData = this.getEmvAuthData();
                String other$emvAuthData = other.getEmvAuthData();
                if (this$emvAuthData == null ? other$emvAuthData != null : !this$emvAuthData.equals(other$emvAuthData)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                String this$generatedCard = this.getGeneratedCard();
                String other$generatedCard = other.getGeneratedCard();
                if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) {
                    return false;
                }
                String this$iin = this.getIin();
                String other$iin = other.getIin();
                if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                    return false;
                }
                String this$issuer = this.getIssuer();
                String other$issuer = other.getIssuer();
                if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                String this$networkTransactionId = this.getNetworkTransactionId();
                String other$networkTransactionId = other.getNetworkTransactionId();
                if (this$networkTransactionId == null ? other$networkTransactionId != null : !this$networkTransactionId.equals(other$networkTransactionId)) {
                    return false;
                }
                Offline this$offline = this.getOffline();
                Offline other$offline = other.getOffline();
                if (this$offline == null ? other$offline != null : !((Object)this$offline).equals(other$offline)) {
                    return false;
                }
                List<String> this$preferredLocales = this.getPreferredLocales();
                List<String> other$preferredLocales = other.getPreferredLocales();
                if (this$preferredLocales == null ? other$preferredLocales != null : !((Object)this$preferredLocales).equals(other$preferredLocales)) {
                    return false;
                }
                String this$readMethod = this.getReadMethod();
                String other$readMethod = other.getReadMethod();
                if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) {
                    return false;
                }
                Receipt this$receipt = this.getReceipt();
                Receipt other$receipt = other.getReceipt();
                if (this$receipt == null ? other$receipt != null : !((Object)this$receipt).equals(other$receipt)) {
                    return false;
                }
                Wallet this$wallet = this.getWallet();
                Wallet other$wallet = other.getWallet();
                return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amountAuthorized = this.getAmountAuthorized();
                result = result * 59 + ($amountAuthorized == null ? 43 : ((Object)$amountAuthorized).hashCode());
                Long $captureBefore = this.getCaptureBefore();
                result = result * 59 + ($captureBefore == null ? 43 : ((Object)$captureBefore).hashCode());
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                Boolean $incrementalAuthorizationSupported = this.getIncrementalAuthorizationSupported();
                result = result * 59 + ($incrementalAuthorizationSupported == null ? 43 : ((Object)$incrementalAuthorizationSupported).hashCode());
                Boolean $overcaptureSupported = this.getOvercaptureSupported();
                result = result * 59 + ($overcaptureSupported == null ? 43 : ((Object)$overcaptureSupported).hashCode());
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                String $brandProduct = this.getBrandProduct();
                result = result * 59 + ($brandProduct == null ? 43 : $brandProduct.hashCode());
                String $cardholderName = this.getCardholderName();
                result = result * 59 + ($cardholderName == null ? 43 : $cardholderName.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $emvAuthData = this.getEmvAuthData();
                result = result * 59 + ($emvAuthData == null ? 43 : $emvAuthData.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                String $generatedCard = this.getGeneratedCard();
                result = result * 59 + ($generatedCard == null ? 43 : $generatedCard.hashCode());
                String $iin = this.getIin();
                result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
                String $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                String $networkTransactionId = this.getNetworkTransactionId();
                result = result * 59 + ($networkTransactionId == null ? 43 : $networkTransactionId.hashCode());
                Offline $offline = this.getOffline();
                result = result * 59 + ($offline == null ? 43 : ((Object)$offline).hashCode());
                List<String> $preferredLocales = this.getPreferredLocales();
                result = result * 59 + ($preferredLocales == null ? 43 : ((Object)$preferredLocales).hashCode());
                String $readMethod = this.getReadMethod();
                result = result * 59 + ($readMethod == null ? 43 : $readMethod.hashCode());
                Receipt $receipt = this.getReceipt();
                result = result * 59 + ($receipt == null ? 43 : ((Object)$receipt).hashCode());
                Wallet $wallet = this.getWallet();
                result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
                return result;
            }

            public static class Offline
            extends StripeObject {
                @SerializedName(value="stored_at")
                Long storedAt;
                @SerializedName(value="type")
                String type;

                @Generated
                public Long getStoredAt() {
                    return this.storedAt;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setStoredAt(Long storedAt) {
                    this.storedAt = storedAt;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Offline)) {
                        return false;
                    }
                    Offline other = (Offline)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$storedAt = this.getStoredAt();
                    Long other$storedAt = other.getStoredAt();
                    if (this$storedAt == null ? other$storedAt != null : !((Object)this$storedAt).equals(other$storedAt)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Offline;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $storedAt = this.getStoredAt();
                    result = result * 59 + ($storedAt == null ? 43 : ((Object)$storedAt).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }

            public static class Receipt
            extends StripeObject {
                @SerializedName(value="account_type")
                String accountType;
                @SerializedName(value="application_cryptogram")
                String applicationCryptogram;
                @SerializedName(value="application_preferred_name")
                String applicationPreferredName;
                @SerializedName(value="authorization_code")
                String authorizationCode;
                @SerializedName(value="authorization_response_code")
                String authorizationResponseCode;
                @SerializedName(value="cardholder_verification_method")
                String cardholderVerificationMethod;
                @SerializedName(value="dedicated_file_name")
                String dedicatedFileName;
                @SerializedName(value="terminal_verification_results")
                String terminalVerificationResults;
                @SerializedName(value="transaction_status_information")
                String transactionStatusInformation;

                @Generated
                public String getAccountType() {
                    return this.accountType;
                }

                @Generated
                public String getApplicationCryptogram() {
                    return this.applicationCryptogram;
                }

                @Generated
                public String getApplicationPreferredName() {
                    return this.applicationPreferredName;
                }

                @Generated
                public String getAuthorizationCode() {
                    return this.authorizationCode;
                }

                @Generated
                public String getAuthorizationResponseCode() {
                    return this.authorizationResponseCode;
                }

                @Generated
                public String getCardholderVerificationMethod() {
                    return this.cardholderVerificationMethod;
                }

                @Generated
                public String getDedicatedFileName() {
                    return this.dedicatedFileName;
                }

                @Generated
                public String getTerminalVerificationResults() {
                    return this.terminalVerificationResults;
                }

                @Generated
                public String getTransactionStatusInformation() {
                    return this.transactionStatusInformation;
                }

                @Generated
                public void setAccountType(String accountType) {
                    this.accountType = accountType;
                }

                @Generated
                public void setApplicationCryptogram(String applicationCryptogram) {
                    this.applicationCryptogram = applicationCryptogram;
                }

                @Generated
                public void setApplicationPreferredName(String applicationPreferredName) {
                    this.applicationPreferredName = applicationPreferredName;
                }

                @Generated
                public void setAuthorizationCode(String authorizationCode) {
                    this.authorizationCode = authorizationCode;
                }

                @Generated
                public void setAuthorizationResponseCode(String authorizationResponseCode) {
                    this.authorizationResponseCode = authorizationResponseCode;
                }

                @Generated
                public void setCardholderVerificationMethod(String cardholderVerificationMethod) {
                    this.cardholderVerificationMethod = cardholderVerificationMethod;
                }

                @Generated
                public void setDedicatedFileName(String dedicatedFileName) {
                    this.dedicatedFileName = dedicatedFileName;
                }

                @Generated
                public void setTerminalVerificationResults(String terminalVerificationResults) {
                    this.terminalVerificationResults = terminalVerificationResults;
                }

                @Generated
                public void setTransactionStatusInformation(String transactionStatusInformation) {
                    this.transactionStatusInformation = transactionStatusInformation;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Receipt)) {
                        return false;
                    }
                    Receipt other = (Receipt)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$accountType = this.getAccountType();
                    String other$accountType = other.getAccountType();
                    if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                        return false;
                    }
                    String this$applicationCryptogram = this.getApplicationCryptogram();
                    String other$applicationCryptogram = other.getApplicationCryptogram();
                    if (this$applicationCryptogram == null ? other$applicationCryptogram != null : !this$applicationCryptogram.equals(other$applicationCryptogram)) {
                        return false;
                    }
                    String this$applicationPreferredName = this.getApplicationPreferredName();
                    String other$applicationPreferredName = other.getApplicationPreferredName();
                    if (this$applicationPreferredName == null ? other$applicationPreferredName != null : !this$applicationPreferredName.equals(other$applicationPreferredName)) {
                        return false;
                    }
                    String this$authorizationCode = this.getAuthorizationCode();
                    String other$authorizationCode = other.getAuthorizationCode();
                    if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
                        return false;
                    }
                    String this$authorizationResponseCode = this.getAuthorizationResponseCode();
                    String other$authorizationResponseCode = other.getAuthorizationResponseCode();
                    if (this$authorizationResponseCode == null ? other$authorizationResponseCode != null : !this$authorizationResponseCode.equals(other$authorizationResponseCode)) {
                        return false;
                    }
                    String this$cardholderVerificationMethod = this.getCardholderVerificationMethod();
                    String other$cardholderVerificationMethod = other.getCardholderVerificationMethod();
                    if (this$cardholderVerificationMethod == null ? other$cardholderVerificationMethod != null : !this$cardholderVerificationMethod.equals(other$cardholderVerificationMethod)) {
                        return false;
                    }
                    String this$dedicatedFileName = this.getDedicatedFileName();
                    String other$dedicatedFileName = other.getDedicatedFileName();
                    if (this$dedicatedFileName == null ? other$dedicatedFileName != null : !this$dedicatedFileName.equals(other$dedicatedFileName)) {
                        return false;
                    }
                    String this$terminalVerificationResults = this.getTerminalVerificationResults();
                    String other$terminalVerificationResults = other.getTerminalVerificationResults();
                    if (this$terminalVerificationResults == null ? other$terminalVerificationResults != null : !this$terminalVerificationResults.equals(other$terminalVerificationResults)) {
                        return false;
                    }
                    String this$transactionStatusInformation = this.getTransactionStatusInformation();
                    String other$transactionStatusInformation = other.getTransactionStatusInformation();
                    return !(this$transactionStatusInformation == null ? other$transactionStatusInformation != null : !this$transactionStatusInformation.equals(other$transactionStatusInformation));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Receipt;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $accountType = this.getAccountType();
                    result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                    String $applicationCryptogram = this.getApplicationCryptogram();
                    result = result * 59 + ($applicationCryptogram == null ? 43 : $applicationCryptogram.hashCode());
                    String $applicationPreferredName = this.getApplicationPreferredName();
                    result = result * 59 + ($applicationPreferredName == null ? 43 : $applicationPreferredName.hashCode());
                    String $authorizationCode = this.getAuthorizationCode();
                    result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
                    String $authorizationResponseCode = this.getAuthorizationResponseCode();
                    result = result * 59 + ($authorizationResponseCode == null ? 43 : $authorizationResponseCode.hashCode());
                    String $cardholderVerificationMethod = this.getCardholderVerificationMethod();
                    result = result * 59 + ($cardholderVerificationMethod == null ? 43 : $cardholderVerificationMethod.hashCode());
                    String $dedicatedFileName = this.getDedicatedFileName();
                    result = result * 59 + ($dedicatedFileName == null ? 43 : $dedicatedFileName.hashCode());
                    String $terminalVerificationResults = this.getTerminalVerificationResults();
                    result = result * 59 + ($terminalVerificationResults == null ? 43 : $terminalVerificationResults.hashCode());
                    String $transactionStatusInformation = this.getTransactionStatusInformation();
                    result = result * 59 + ($transactionStatusInformation == null ? 43 : $transactionStatusInformation.hashCode());
                    return result;
                }
            }

            public static class Wallet
            extends StripeObject {
                @SerializedName(value="type")
                String type;

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Wallet)) {
                        return false;
                    }
                    Wallet other = (Wallet)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Wallet;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class Cashapp
        extends StripeObject {
            @SerializedName(value="buyer_id")
            String buyerId;
            @SerializedName(value="cashtag")
            String cashtag;

            @Generated
            public String getBuyerId() {
                return this.buyerId;
            }

            @Generated
            public String getCashtag() {
                return this.cashtag;
            }

            @Generated
            public void setBuyerId(String buyerId) {
                this.buyerId = buyerId;
            }

            @Generated
            public void setCashtag(String cashtag) {
                this.cashtag = cashtag;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cashapp)) {
                    return false;
                }
                Cashapp other = (Cashapp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$buyerId = this.getBuyerId();
                String other$buyerId = other.getBuyerId();
                if (this$buyerId == null ? other$buyerId != null : !this$buyerId.equals(other$buyerId)) {
                    return false;
                }
                String this$cashtag = this.getCashtag();
                String other$cashtag = other.getCashtag();
                return !(this$cashtag == null ? other$cashtag != null : !this$cashtag.equals(other$cashtag));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cashapp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $buyerId = this.getBuyerId();
                result = result * 59 + ($buyerId == null ? 43 : $buyerId.hashCode());
                String $cashtag = this.getCashtag();
                result = result * 59 + ($cashtag == null ? 43 : $cashtag.hashCode());
                return result;
            }
        }

        public static class Custom
        extends StripeObject {
            @SerializedName(value="display_name")
            String displayName;
            @SerializedName(value="type")
            String type;

            @Generated
            public String getDisplayName() {
                return this.displayName;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setDisplayName(String displayName) {
                this.displayName = displayName;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Custom)) {
                    return false;
                }
                Custom other = (Custom)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$displayName = this.getDisplayName();
                String other$displayName = other.getDisplayName();
                if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Custom;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $displayName = this.getDisplayName();
                result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class CustomerBalance
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CustomerBalance)) {
                    return false;
                }
                CustomerBalance other = (CustomerBalance)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CustomerBalance;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Eps
        extends StripeObject {
            @SerializedName(value="bank")
            String bank;
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eps)) {
                    return false;
                }
                Eps other = (Eps)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eps;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class Fpx
        extends StripeObject {
            @SerializedName(value="account_holder_type")
            String accountHolderType;
            @SerializedName(value="bank")
            String bank;
            @SerializedName(value="transaction_id")
            String transactionId;

            @Generated
            public String getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public String getTransactionId() {
                return this.transactionId;
            }

            @Generated
            public void setAccountHolderType(String accountHolderType) {
                this.accountHolderType = accountHolderType;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public void setTransactionId(String transactionId) {
                this.transactionId = transactionId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fpx)) {
                    return false;
                }
                Fpx other = (Fpx)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderType = this.getAccountHolderType();
                String other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                String this$transactionId = this.getTransactionId();
                String other$transactionId = other.getTransactionId();
                return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fpx;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                String $transactionId = this.getTransactionId();
                result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                return result;
            }
        }

        public static class Giropay
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Giropay)) {
                    return false;
                }
                Giropay other = (Giropay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Giropay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class Gopay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gopay)) {
                    return false;
                }
                Gopay other = (Gopay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gopay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Grabpay
        extends StripeObject {
            @SerializedName(value="transaction_id")
            String transactionId;

            @Generated
            public String getTransactionId() {
                return this.transactionId;
            }

            @Generated
            public void setTransactionId(String transactionId) {
                this.transactionId = transactionId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Grabpay)) {
                    return false;
                }
                Grabpay other = (Grabpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$transactionId = this.getTransactionId();
                String other$transactionId = other.getTransactionId();
                return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Grabpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $transactionId = this.getTransactionId();
                result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                return result;
            }
        }

        public static class IdBankTransfer
        extends StripeObject {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="bank")
            String bank;
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="display_name")
            String displayName;

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getDisplayName() {
                return this.displayName;
            }

            @Generated
            public void setAccountNumber(String accountNumber) {
                this.accountNumber = accountNumber;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setDisplayName(String displayName) {
                this.displayName = displayName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdBankTransfer)) {
                    return false;
                }
                IdBankTransfer other = (IdBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$displayName = this.getDisplayName();
                String other$displayName = other.getDisplayName();
                return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IdBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $displayName = this.getDisplayName();
                result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                return result;
            }
        }

        public static class Ideal
        extends StripeObject {
            @SerializedName(value="bank")
            String bank;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="generated_sepa_debit")
            ExpandableField<PaymentMethod> generatedSepaDebit;
            @SerializedName(value="generated_sepa_debit_mandate")
            ExpandableField<Mandate> generatedSepaDebitMandate;
            @SerializedName(value="iban_last4")
            String ibanLast4;
            @SerializedName(value="verified_name")
            String verifiedName;

            public String getGeneratedSepaDebit() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getId() : null;
            }

            public void setGeneratedSepaDebit(String id) {
                this.generatedSepaDebit = ApiResource.setExpandableFieldId(id, this.generatedSepaDebit);
            }

            public PaymentMethod getGeneratedSepaDebitObject() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getExpanded() : null;
            }

            public void setGeneratedSepaDebitObject(PaymentMethod expandableObject) {
                this.generatedSepaDebit = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
            }

            public String getGeneratedSepaDebitMandate() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getId() : null;
            }

            public void setGeneratedSepaDebitMandate(String id) {
                this.generatedSepaDebitMandate = ApiResource.setExpandableFieldId(id, this.generatedSepaDebitMandate);
            }

            public Mandate getGeneratedSepaDebitMandateObject() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getExpanded() : null;
            }

            public void setGeneratedSepaDebitMandateObject(Mandate expandableObject) {
                this.generatedSepaDebitMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getIbanLast4() {
                return this.ibanLast4;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setIbanLast4(String ibanLast4) {
                this.ibanLast4 = ibanLast4;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ideal)) {
                    return false;
                }
                Ideal other = (Ideal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$generatedSepaDebit = this.getGeneratedSepaDebit();
                String other$generatedSepaDebit = other.getGeneratedSepaDebit();
                if (this$generatedSepaDebit == null ? other$generatedSepaDebit != null : !this$generatedSepaDebit.equals(other$generatedSepaDebit)) {
                    return false;
                }
                String this$generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                String other$generatedSepaDebitMandate = other.getGeneratedSepaDebitMandate();
                if (this$generatedSepaDebitMandate == null ? other$generatedSepaDebitMandate != null : !this$generatedSepaDebitMandate.equals(other$generatedSepaDebitMandate)) {
                    return false;
                }
                String this$ibanLast4 = this.getIbanLast4();
                String other$ibanLast4 = other.getIbanLast4();
                if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ideal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $generatedSepaDebit = this.getGeneratedSepaDebit();
                result = result * 59 + ($generatedSepaDebit == null ? 43 : $generatedSepaDebit.hashCode());
                String $generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                result = result * 59 + ($generatedSepaDebitMandate == null ? 43 : $generatedSepaDebitMandate.hashCode());
                String $ibanLast4 = this.getIbanLast4();
                result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class InteracPresent
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="cardholder_name")
            String cardholderName;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="emv_auth_data")
            String emvAuthData;
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="funding")
            String funding;
            @SerializedName(value="generated_card")
            String generatedCard;
            @SerializedName(value="iin")
            String iin;
            @SerializedName(value="issuer")
            String issuer;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="network_transaction_id")
            String networkTransactionId;
            @SerializedName(value="preferred_locales")
            List<String> preferredLocales;
            @SerializedName(value="read_method")
            String readMethod;
            @SerializedName(value="receipt")
            Receipt receipt;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public String getCardholderName() {
                return this.cardholderName;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public String getEmvAuthData() {
                return this.emvAuthData;
            }

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getFunding() {
                return this.funding;
            }

            @Generated
            public String getGeneratedCard() {
                return this.generatedCard;
            }

            @Generated
            public String getIin() {
                return this.iin;
            }

            @Generated
            public String getIssuer() {
                return this.issuer;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public String getNetworkTransactionId() {
                return this.networkTransactionId;
            }

            @Generated
            public List<String> getPreferredLocales() {
                return this.preferredLocales;
            }

            @Generated
            public String getReadMethod() {
                return this.readMethod;
            }

            @Generated
            public Receipt getReceipt() {
                return this.receipt;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setCardholderName(String cardholderName) {
                this.cardholderName = cardholderName;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setEmvAuthData(String emvAuthData) {
                this.emvAuthData = emvAuthData;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setFunding(String funding) {
                this.funding = funding;
            }

            @Generated
            public void setGeneratedCard(String generatedCard) {
                this.generatedCard = generatedCard;
            }

            @Generated
            public void setIin(String iin) {
                this.iin = iin;
            }

            @Generated
            public void setIssuer(String issuer) {
                this.issuer = issuer;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setNetworkTransactionId(String networkTransactionId) {
                this.networkTransactionId = networkTransactionId;
            }

            @Generated
            public void setPreferredLocales(List<String> preferredLocales) {
                this.preferredLocales = preferredLocales;
            }

            @Generated
            public void setReadMethod(String readMethod) {
                this.readMethod = readMethod;
            }

            @Generated
            public void setReceipt(Receipt receipt) {
                this.receipt = receipt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InteracPresent)) {
                    return false;
                }
                InteracPresent other = (InteracPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                String this$cardholderName = this.getCardholderName();
                String other$cardholderName = other.getCardholderName();
                if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$emvAuthData = this.getEmvAuthData();
                String other$emvAuthData = other.getEmvAuthData();
                if (this$emvAuthData == null ? other$emvAuthData != null : !this$emvAuthData.equals(other$emvAuthData)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$funding = this.getFunding();
                String other$funding = other.getFunding();
                if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                    return false;
                }
                String this$generatedCard = this.getGeneratedCard();
                String other$generatedCard = other.getGeneratedCard();
                if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) {
                    return false;
                }
                String this$iin = this.getIin();
                String other$iin = other.getIin();
                if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                    return false;
                }
                String this$issuer = this.getIssuer();
                String other$issuer = other.getIssuer();
                if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                String this$networkTransactionId = this.getNetworkTransactionId();
                String other$networkTransactionId = other.getNetworkTransactionId();
                if (this$networkTransactionId == null ? other$networkTransactionId != null : !this$networkTransactionId.equals(other$networkTransactionId)) {
                    return false;
                }
                List<String> this$preferredLocales = this.getPreferredLocales();
                List<String> other$preferredLocales = other.getPreferredLocales();
                if (this$preferredLocales == null ? other$preferredLocales != null : !((Object)this$preferredLocales).equals(other$preferredLocales)) {
                    return false;
                }
                String this$readMethod = this.getReadMethod();
                String other$readMethod = other.getReadMethod();
                if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) {
                    return false;
                }
                Receipt this$receipt = this.getReceipt();
                Receipt other$receipt = other.getReceipt();
                return !(this$receipt == null ? other$receipt != null : !((Object)this$receipt).equals(other$receipt));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InteracPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                String $cardholderName = this.getCardholderName();
                result = result * 59 + ($cardholderName == null ? 43 : $cardholderName.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $emvAuthData = this.getEmvAuthData();
                result = result * 59 + ($emvAuthData == null ? 43 : $emvAuthData.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                String $generatedCard = this.getGeneratedCard();
                result = result * 59 + ($generatedCard == null ? 43 : $generatedCard.hashCode());
                String $iin = this.getIin();
                result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
                String $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                String $networkTransactionId = this.getNetworkTransactionId();
                result = result * 59 + ($networkTransactionId == null ? 43 : $networkTransactionId.hashCode());
                List<String> $preferredLocales = this.getPreferredLocales();
                result = result * 59 + ($preferredLocales == null ? 43 : ((Object)$preferredLocales).hashCode());
                String $readMethod = this.getReadMethod();
                result = result * 59 + ($readMethod == null ? 43 : $readMethod.hashCode());
                Receipt $receipt = this.getReceipt();
                result = result * 59 + ($receipt == null ? 43 : ((Object)$receipt).hashCode());
                return result;
            }

            public static class Receipt
            extends StripeObject {
                @SerializedName(value="account_type")
                String accountType;
                @SerializedName(value="application_cryptogram")
                String applicationCryptogram;
                @SerializedName(value="application_preferred_name")
                String applicationPreferredName;
                @SerializedName(value="authorization_code")
                String authorizationCode;
                @SerializedName(value="authorization_response_code")
                String authorizationResponseCode;
                @SerializedName(value="cardholder_verification_method")
                String cardholderVerificationMethod;
                @SerializedName(value="dedicated_file_name")
                String dedicatedFileName;
                @SerializedName(value="terminal_verification_results")
                String terminalVerificationResults;
                @SerializedName(value="transaction_status_information")
                String transactionStatusInformation;

                @Generated
                public String getAccountType() {
                    return this.accountType;
                }

                @Generated
                public String getApplicationCryptogram() {
                    return this.applicationCryptogram;
                }

                @Generated
                public String getApplicationPreferredName() {
                    return this.applicationPreferredName;
                }

                @Generated
                public String getAuthorizationCode() {
                    return this.authorizationCode;
                }

                @Generated
                public String getAuthorizationResponseCode() {
                    return this.authorizationResponseCode;
                }

                @Generated
                public String getCardholderVerificationMethod() {
                    return this.cardholderVerificationMethod;
                }

                @Generated
                public String getDedicatedFileName() {
                    return this.dedicatedFileName;
                }

                @Generated
                public String getTerminalVerificationResults() {
                    return this.terminalVerificationResults;
                }

                @Generated
                public String getTransactionStatusInformation() {
                    return this.transactionStatusInformation;
                }

                @Generated
                public void setAccountType(String accountType) {
                    this.accountType = accountType;
                }

                @Generated
                public void setApplicationCryptogram(String applicationCryptogram) {
                    this.applicationCryptogram = applicationCryptogram;
                }

                @Generated
                public void setApplicationPreferredName(String applicationPreferredName) {
                    this.applicationPreferredName = applicationPreferredName;
                }

                @Generated
                public void setAuthorizationCode(String authorizationCode) {
                    this.authorizationCode = authorizationCode;
                }

                @Generated
                public void setAuthorizationResponseCode(String authorizationResponseCode) {
                    this.authorizationResponseCode = authorizationResponseCode;
                }

                @Generated
                public void setCardholderVerificationMethod(String cardholderVerificationMethod) {
                    this.cardholderVerificationMethod = cardholderVerificationMethod;
                }

                @Generated
                public void setDedicatedFileName(String dedicatedFileName) {
                    this.dedicatedFileName = dedicatedFileName;
                }

                @Generated
                public void setTerminalVerificationResults(String terminalVerificationResults) {
                    this.terminalVerificationResults = terminalVerificationResults;
                }

                @Generated
                public void setTransactionStatusInformation(String transactionStatusInformation) {
                    this.transactionStatusInformation = transactionStatusInformation;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Receipt)) {
                        return false;
                    }
                    Receipt other = (Receipt)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$accountType = this.getAccountType();
                    String other$accountType = other.getAccountType();
                    if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                        return false;
                    }
                    String this$applicationCryptogram = this.getApplicationCryptogram();
                    String other$applicationCryptogram = other.getApplicationCryptogram();
                    if (this$applicationCryptogram == null ? other$applicationCryptogram != null : !this$applicationCryptogram.equals(other$applicationCryptogram)) {
                        return false;
                    }
                    String this$applicationPreferredName = this.getApplicationPreferredName();
                    String other$applicationPreferredName = other.getApplicationPreferredName();
                    if (this$applicationPreferredName == null ? other$applicationPreferredName != null : !this$applicationPreferredName.equals(other$applicationPreferredName)) {
                        return false;
                    }
                    String this$authorizationCode = this.getAuthorizationCode();
                    String other$authorizationCode = other.getAuthorizationCode();
                    if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
                        return false;
                    }
                    String this$authorizationResponseCode = this.getAuthorizationResponseCode();
                    String other$authorizationResponseCode = other.getAuthorizationResponseCode();
                    if (this$authorizationResponseCode == null ? other$authorizationResponseCode != null : !this$authorizationResponseCode.equals(other$authorizationResponseCode)) {
                        return false;
                    }
                    String this$cardholderVerificationMethod = this.getCardholderVerificationMethod();
                    String other$cardholderVerificationMethod = other.getCardholderVerificationMethod();
                    if (this$cardholderVerificationMethod == null ? other$cardholderVerificationMethod != null : !this$cardholderVerificationMethod.equals(other$cardholderVerificationMethod)) {
                        return false;
                    }
                    String this$dedicatedFileName = this.getDedicatedFileName();
                    String other$dedicatedFileName = other.getDedicatedFileName();
                    if (this$dedicatedFileName == null ? other$dedicatedFileName != null : !this$dedicatedFileName.equals(other$dedicatedFileName)) {
                        return false;
                    }
                    String this$terminalVerificationResults = this.getTerminalVerificationResults();
                    String other$terminalVerificationResults = other.getTerminalVerificationResults();
                    if (this$terminalVerificationResults == null ? other$terminalVerificationResults != null : !this$terminalVerificationResults.equals(other$terminalVerificationResults)) {
                        return false;
                    }
                    String this$transactionStatusInformation = this.getTransactionStatusInformation();
                    String other$transactionStatusInformation = other.getTransactionStatusInformation();
                    return !(this$transactionStatusInformation == null ? other$transactionStatusInformation != null : !this$transactionStatusInformation.equals(other$transactionStatusInformation));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Receipt;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $accountType = this.getAccountType();
                    result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                    String $applicationCryptogram = this.getApplicationCryptogram();
                    result = result * 59 + ($applicationCryptogram == null ? 43 : $applicationCryptogram.hashCode());
                    String $applicationPreferredName = this.getApplicationPreferredName();
                    result = result * 59 + ($applicationPreferredName == null ? 43 : $applicationPreferredName.hashCode());
                    String $authorizationCode = this.getAuthorizationCode();
                    result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
                    String $authorizationResponseCode = this.getAuthorizationResponseCode();
                    result = result * 59 + ($authorizationResponseCode == null ? 43 : $authorizationResponseCode.hashCode());
                    String $cardholderVerificationMethod = this.getCardholderVerificationMethod();
                    result = result * 59 + ($cardholderVerificationMethod == null ? 43 : $cardholderVerificationMethod.hashCode());
                    String $dedicatedFileName = this.getDedicatedFileName();
                    result = result * 59 + ($dedicatedFileName == null ? 43 : $dedicatedFileName.hashCode());
                    String $terminalVerificationResults = this.getTerminalVerificationResults();
                    result = result * 59 + ($terminalVerificationResults == null ? 43 : $terminalVerificationResults.hashCode());
                    String $transactionStatusInformation = this.getTransactionStatusInformation();
                    result = result * 59 + ($transactionStatusInformation == null ? 43 : $transactionStatusInformation.hashCode());
                    return result;
                }
            }
        }

        public static class KakaoPay
        extends StripeObject {
            @SerializedName(value="buyer_id")
            String buyerId;

            @Generated
            public String getBuyerId() {
                return this.buyerId;
            }

            @Generated
            public void setBuyerId(String buyerId) {
                this.buyerId = buyerId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KakaoPay)) {
                    return false;
                }
                KakaoPay other = (KakaoPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$buyerId = this.getBuyerId();
                String other$buyerId = other.getBuyerId();
                return !(this$buyerId == null ? other$buyerId != null : !this$buyerId.equals(other$buyerId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KakaoPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $buyerId = this.getBuyerId();
                result = result * 59 + ($buyerId == null ? 43 : $buyerId.hashCode());
                return result;
            }
        }

        public static class Klarna
        extends StripeObject {
            @SerializedName(value="payer_details")
            PayerDetails payerDetails;
            @SerializedName(value="payment_method_category")
            String paymentMethodCategory;
            @SerializedName(value="preferred_locale")
            String preferredLocale;

            @Generated
            public PayerDetails getPayerDetails() {
                return this.payerDetails;
            }

            @Generated
            public String getPaymentMethodCategory() {
                return this.paymentMethodCategory;
            }

            @Generated
            public String getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public void setPayerDetails(PayerDetails payerDetails) {
                this.payerDetails = payerDetails;
            }

            @Generated
            public void setPaymentMethodCategory(String paymentMethodCategory) {
                this.paymentMethodCategory = paymentMethodCategory;
            }

            @Generated
            public void setPreferredLocale(String preferredLocale) {
                this.preferredLocale = preferredLocale;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                PayerDetails this$payerDetails = this.getPayerDetails();
                PayerDetails other$payerDetails = other.getPayerDetails();
                if (this$payerDetails == null ? other$payerDetails != null : !((Object)this$payerDetails).equals(other$payerDetails)) {
                    return false;
                }
                String this$paymentMethodCategory = this.getPaymentMethodCategory();
                String other$paymentMethodCategory = other.getPaymentMethodCategory();
                if (this$paymentMethodCategory == null ? other$paymentMethodCategory != null : !this$paymentMethodCategory.equals(other$paymentMethodCategory)) {
                    return false;
                }
                String this$preferredLocale = this.getPreferredLocale();
                String other$preferredLocale = other.getPreferredLocale();
                return !(this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                PayerDetails $payerDetails = this.getPayerDetails();
                result = result * 59 + ($payerDetails == null ? 43 : ((Object)$payerDetails).hashCode());
                String $paymentMethodCategory = this.getPaymentMethodCategory();
                result = result * 59 + ($paymentMethodCategory == null ? 43 : $paymentMethodCategory.hashCode());
                String $preferredLocale = this.getPreferredLocale();
                result = result * 59 + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
                return result;
            }

            public static class PayerDetails
            extends StripeObject {
                @SerializedName(value="address")
                Address address;

                @Generated
                public Address getAddress() {
                    return this.address;
                }

                @Generated
                public void setAddress(Address address) {
                    this.address = address;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PayerDetails)) {
                        return false;
                    }
                    PayerDetails other = (PayerDetails)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Address this$address = this.getAddress();
                    Address other$address = other.getAddress();
                    return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof PayerDetails;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Address $address = this.getAddress();
                    result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                    return result;
                }

                public static class Address
                extends StripeObject {
                    @SerializedName(value="country")
                    String country;

                    @Generated
                    public String getCountry() {
                        return this.country;
                    }

                    @Generated
                    public void setCountry(String country) {
                        this.country = country;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Address)) {
                            return false;
                        }
                        Address other = (Address)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$country = this.getCountry();
                        String other$country = other.getCountry();
                        return !(this$country == null ? other$country != null : !this$country.equals(other$country));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Address;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $country = this.getCountry();
                        result = result * 59 + ($country == null ? 43 : $country.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class Konbini
        extends StripeObject {
            @SerializedName(value="store")
            Store store;

            @Generated
            public Store getStore() {
                return this.store;
            }

            @Generated
            public void setStore(Store store) {
                this.store = store;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Konbini)) {
                    return false;
                }
                Konbini other = (Konbini)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Store this$store = this.getStore();
                Store other$store = other.getStore();
                return !(this$store == null ? other$store != null : !((Object)this$store).equals(other$store));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Konbini;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Store $store = this.getStore();
                result = result * 59 + ($store == null ? 43 : ((Object)$store).hashCode());
                return result;
            }

            public static class Store
            extends StripeObject {
                @SerializedName(value="chain")
                String chain;

                @Generated
                public String getChain() {
                    return this.chain;
                }

                @Generated
                public void setChain(String chain) {
                    this.chain = chain;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Store)) {
                        return false;
                    }
                    Store other = (Store)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$chain = this.getChain();
                    String other$chain = other.getChain();
                    return !(this$chain == null ? other$chain != null : !this$chain.equals(other$chain));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Store;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $chain = this.getChain();
                    result = result * 59 + ($chain == null ? 43 : $chain.hashCode());
                    return result;
                }
            }
        }

        public static class KrCard
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="buyer_id")
            String buyerId;
            @SerializedName(value="last4")
            String last4;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public String getBuyerId() {
                return this.buyerId;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setBuyerId(String buyerId) {
                this.buyerId = buyerId;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KrCard)) {
                    return false;
                }
                KrCard other = (KrCard)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                String this$buyerId = this.getBuyerId();
                String other$buyerId = other.getBuyerId();
                if (this$buyerId == null ? other$buyerId != null : !this$buyerId.equals(other$buyerId)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KrCard;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                String $buyerId = this.getBuyerId();
                result = result * 59 + ($buyerId == null ? 43 : $buyerId.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                return result;
            }
        }

        public static class Link
        extends StripeObject {
            @SerializedName(value="country")
            String country;

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Link)) {
                    return false;
                }
                Link other = (Link)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                return !(this$country == null ? other$country != null : !this$country.equals(other$country));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Link;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                return result;
            }
        }

        public static class MbWay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MbWay)) {
                    return false;
                }
                MbWay other = (MbWay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof MbWay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Mobilepay
        extends StripeObject {
            @SerializedName(value="card")
            Card card;

            @Generated
            public Card getCard() {
                return this.card;
            }

            @Generated
            public void setCard(Card card) {
                this.card = card;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mobilepay)) {
                    return false;
                }
                Mobilepay other = (Mobilepay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Card this$card = this.getCard();
                Card other$card = other.getCard();
                return !(this$card == null ? other$card != null : !((Object)this$card).equals(other$card));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mobilepay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Card $card = this.getCard();
                result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                return result;
            }

            public static class Card
            extends StripeObject {
                @SerializedName(value="brand")
                String brand;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="exp_month")
                Long expMonth;
                @SerializedName(value="exp_year")
                Long expYear;
                @SerializedName(value="last4")
                String last4;

                @Generated
                public String getBrand() {
                    return this.brand;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Long getExpMonth() {
                    return this.expMonth;
                }

                @Generated
                public Long getExpYear() {
                    return this.expYear;
                }

                @Generated
                public String getLast4() {
                    return this.last4;
                }

                @Generated
                public void setBrand(String brand) {
                    this.brand = brand;
                }

                @Generated
                public void setCountry(String country) {
                    this.country = country;
                }

                @Generated
                public void setExpMonth(Long expMonth) {
                    this.expMonth = expMonth;
                }

                @Generated
                public void setExpYear(Long expYear) {
                    this.expYear = expYear;
                }

                @Generated
                public void setLast4(String last4) {
                    this.last4 = last4;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Card)) {
                        return false;
                    }
                    Card other = (Card)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$expMonth = this.getExpMonth();
                    Long other$expMonth = other.getExpMonth();
                    if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                        return false;
                    }
                    Long this$expYear = this.getExpYear();
                    Long other$expYear = other.getExpYear();
                    if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                        return false;
                    }
                    String this$brand = this.getBrand();
                    String other$brand = other.getBrand();
                    if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    String this$last4 = this.getLast4();
                    String other$last4 = other.getLast4();
                    return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Card;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $expMonth = this.getExpMonth();
                    result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                    Long $expYear = this.getExpYear();
                    result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                    String $brand = this.getBrand();
                    result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    String $last4 = this.getLast4();
                    result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                    return result;
                }
            }
        }

        public static class Multibanco
        extends StripeObject {
            @SerializedName(value="entity")
            String entity;
            @SerializedName(value="reference")
            String reference;

            @Generated
            public String getEntity() {
                return this.entity;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public void setEntity(String entity) {
                this.entity = entity;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Multibanco)) {
                    return false;
                }
                Multibanco other = (Multibanco)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$entity = this.getEntity();
                String other$entity = other.getEntity();
                if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Multibanco;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $entity = this.getEntity();
                result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                return result;
            }
        }

        public static class NaverPay
        extends StripeObject {
            @SerializedName(value="buyer_id")
            String buyerId;

            @Generated
            public String getBuyerId() {
                return this.buyerId;
            }

            @Generated
            public void setBuyerId(String buyerId) {
                this.buyerId = buyerId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NaverPay)) {
                    return false;
                }
                NaverPay other = (NaverPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$buyerId = this.getBuyerId();
                String other$buyerId = other.getBuyerId();
                return !(this$buyerId == null ? other$buyerId != null : !this$buyerId.equals(other$buyerId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NaverPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $buyerId = this.getBuyerId();
                result = result * 59 + ($buyerId == null ? 43 : $buyerId.hashCode());
                return result;
            }
        }

        public static class NzBankAccount
        extends StripeObject {
            @SerializedName(value="account_holder_name")
            String accountHolderName;
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="branch_code")
            String branchCode;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="suffix")
            String suffix;

            @Generated
            public String getAccountHolderName() {
                return this.accountHolderName;
            }

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBranchCode() {
                return this.branchCode;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getSuffix() {
                return this.suffix;
            }

            @Generated
            public void setAccountHolderName(String accountHolderName) {
                this.accountHolderName = accountHolderName;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBranchCode(String branchCode) {
                this.branchCode = branchCode;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setSuffix(String suffix) {
                this.suffix = suffix;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NzBankAccount)) {
                    return false;
                }
                NzBankAccount other = (NzBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderName = this.getAccountHolderName();
                String other$accountHolderName = other.getAccountHolderName();
                if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$branchCode = this.getBranchCode();
                String other$branchCode = other.getBranchCode();
                if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$suffix = this.getSuffix();
                String other$suffix = other.getSuffix();
                return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NzBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderName = this.getAccountHolderName();
                result = result * 59 + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $branchCode = this.getBranchCode();
                result = result * 59 + ($branchCode == null ? 43 : $branchCode.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $suffix = this.getSuffix();
                result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
                return result;
            }
        }

        public static class Oxxo
        extends StripeObject {
            @SerializedName(value="number")
            String number;

            @Generated
            public String getNumber() {
                return this.number;
            }

            @Generated
            public void setNumber(String number) {
                this.number = number;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Oxxo)) {
                    return false;
                }
                Oxxo other = (Oxxo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$number = this.getNumber();
                String other$number = other.getNumber();
                return !(this$number == null ? other$number != null : !this$number.equals(other$number));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Oxxo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $number = this.getNumber();
                result = result * 59 + ($number == null ? 43 : $number.hashCode());
                return result;
            }
        }

        public static class P24
        extends StripeObject {
            @SerializedName(value="bank")
            String bank;
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getBank() {
                return this.bank;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBank(String bank) {
                this.bank = bank;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof P24)) {
                    return false;
                }
                P24 other = (P24)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bank = this.getBank();
                String other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof P24;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class PayByBank
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PayByBank)) {
                    return false;
                }
                PayByBank other = (PayByBank)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PayByBank;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Payco
        extends StripeObject {
            @SerializedName(value="buyer_id")
            String buyerId;

            @Generated
            public String getBuyerId() {
                return this.buyerId;
            }

            @Generated
            public void setBuyerId(String buyerId) {
                this.buyerId = buyerId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payco)) {
                    return false;
                }
                Payco other = (Payco)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$buyerId = this.getBuyerId();
                String other$buyerId = other.getBuyerId();
                return !(this$buyerId == null ? other$buyerId != null : !this$buyerId.equals(other$buyerId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payco;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $buyerId = this.getBuyerId();
                result = result * 59 + ($buyerId == null ? 43 : $buyerId.hashCode());
                return result;
            }
        }

        public static class Paynow
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paynow)) {
                    return false;
                }
                Paynow other = (Paynow)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paynow;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                return result;
            }
        }

        public static class Paypal
        extends StripeObject {
            @SerializedName(value="country")
            String country;
            @SerializedName(value="payer_email")
            String payerEmail;
            @SerializedName(value="payer_id")
            String payerId;
            @SerializedName(value="payer_name")
            String payerName;
            @SerializedName(value="seller_protection")
            SellerProtection sellerProtection;
            @SerializedName(value="shipping")
            Address shipping;
            @SerializedName(value="transaction_id")
            String transactionId;
            @SerializedName(value="verified_address")
            Address verifiedAddress;
            @SerializedName(value="verified_email")
            String verifiedEmail;
            @SerializedName(value="verified_name")
            String verifiedName;

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getPayerEmail() {
                return this.payerEmail;
            }

            @Generated
            public String getPayerId() {
                return this.payerId;
            }

            @Generated
            public String getPayerName() {
                return this.payerName;
            }

            @Generated
            public SellerProtection getSellerProtection() {
                return this.sellerProtection;
            }

            @Generated
            public Address getShipping() {
                return this.shipping;
            }

            @Generated
            public String getTransactionId() {
                return this.transactionId;
            }

            @Generated
            public Address getVerifiedAddress() {
                return this.verifiedAddress;
            }

            @Generated
            public String getVerifiedEmail() {
                return this.verifiedEmail;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setPayerEmail(String payerEmail) {
                this.payerEmail = payerEmail;
            }

            @Generated
            public void setPayerId(String payerId) {
                this.payerId = payerId;
            }

            @Generated
            public void setPayerName(String payerName) {
                this.payerName = payerName;
            }

            @Generated
            public void setSellerProtection(SellerProtection sellerProtection) {
                this.sellerProtection = sellerProtection;
            }

            @Generated
            public void setShipping(Address shipping) {
                this.shipping = shipping;
            }

            @Generated
            public void setTransactionId(String transactionId) {
                this.transactionId = transactionId;
            }

            @Generated
            public void setVerifiedAddress(Address verifiedAddress) {
                this.verifiedAddress = verifiedAddress;
            }

            @Generated
            public void setVerifiedEmail(String verifiedEmail) {
                this.verifiedEmail = verifiedEmail;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$payerEmail = this.getPayerEmail();
                String other$payerEmail = other.getPayerEmail();
                if (this$payerEmail == null ? other$payerEmail != null : !this$payerEmail.equals(other$payerEmail)) {
                    return false;
                }
                String this$payerId = this.getPayerId();
                String other$payerId = other.getPayerId();
                if (this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId)) {
                    return false;
                }
                String this$payerName = this.getPayerName();
                String other$payerName = other.getPayerName();
                if (this$payerName == null ? other$payerName != null : !this$payerName.equals(other$payerName)) {
                    return false;
                }
                SellerProtection this$sellerProtection = this.getSellerProtection();
                SellerProtection other$sellerProtection = other.getSellerProtection();
                if (this$sellerProtection == null ? other$sellerProtection != null : !((Object)this$sellerProtection).equals(other$sellerProtection)) {
                    return false;
                }
                Address this$shipping = this.getShipping();
                Address other$shipping = other.getShipping();
                if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
                    return false;
                }
                String this$transactionId = this.getTransactionId();
                String other$transactionId = other.getTransactionId();
                if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
                    return false;
                }
                Address this$verifiedAddress = this.getVerifiedAddress();
                Address other$verifiedAddress = other.getVerifiedAddress();
                if (this$verifiedAddress == null ? other$verifiedAddress != null : !((Object)this$verifiedAddress).equals(other$verifiedAddress)) {
                    return false;
                }
                String this$verifiedEmail = this.getVerifiedEmail();
                String other$verifiedEmail = other.getVerifiedEmail();
                if (this$verifiedEmail == null ? other$verifiedEmail != null : !this$verifiedEmail.equals(other$verifiedEmail)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $payerEmail = this.getPayerEmail();
                result = result * 59 + ($payerEmail == null ? 43 : $payerEmail.hashCode());
                String $payerId = this.getPayerId();
                result = result * 59 + ($payerId == null ? 43 : $payerId.hashCode());
                String $payerName = this.getPayerName();
                result = result * 59 + ($payerName == null ? 43 : $payerName.hashCode());
                SellerProtection $sellerProtection = this.getSellerProtection();
                result = result * 59 + ($sellerProtection == null ? 43 : ((Object)$sellerProtection).hashCode());
                Address $shipping = this.getShipping();
                result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
                String $transactionId = this.getTransactionId();
                result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                Address $verifiedAddress = this.getVerifiedAddress();
                result = result * 59 + ($verifiedAddress == null ? 43 : ((Object)$verifiedAddress).hashCode());
                String $verifiedEmail = this.getVerifiedEmail();
                result = result * 59 + ($verifiedEmail == null ? 43 : $verifiedEmail.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }

            public static class SellerProtection
            extends StripeObject {
                @SerializedName(value="dispute_categories")
                List<String> disputeCategories;
                @SerializedName(value="status")
                String status;

                @Generated
                public List<String> getDisputeCategories() {
                    return this.disputeCategories;
                }

                @Generated
                public String getStatus() {
                    return this.status;
                }

                @Generated
                public void setDisputeCategories(List<String> disputeCategories) {
                    this.disputeCategories = disputeCategories;
                }

                @Generated
                public void setStatus(String status) {
                    this.status = status;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SellerProtection)) {
                        return false;
                    }
                    SellerProtection other = (SellerProtection)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<String> this$disputeCategories = this.getDisputeCategories();
                    List<String> other$disputeCategories = other.getDisputeCategories();
                    if (this$disputeCategories == null ? other$disputeCategories != null : !((Object)this$disputeCategories).equals(other$disputeCategories)) {
                        return false;
                    }
                    String this$status = this.getStatus();
                    String other$status = other.getStatus();
                    return !(this$status == null ? other$status != null : !this$status.equals(other$status));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SellerProtection;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<String> $disputeCategories = this.getDisputeCategories();
                    result = result * 59 + ($disputeCategories == null ? 43 : ((Object)$disputeCategories).hashCode());
                    String $status = this.getStatus();
                    result = result * 59 + ($status == null ? 43 : $status.hashCode());
                    return result;
                }
            }
        }

        public static class Payto
        extends StripeObject {
            @SerializedName(value="bsb_number")
            String bsbNumber;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="mandate")
            String mandate;
            @SerializedName(value="pay_id")
            String payId;

            @Generated
            public String getBsbNumber() {
                return this.bsbNumber;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getMandate() {
                return this.mandate;
            }

            @Generated
            public String getPayId() {
                return this.payId;
            }

            @Generated
            public void setBsbNumber(String bsbNumber) {
                this.bsbNumber = bsbNumber;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMandate(String mandate) {
                this.mandate = mandate;
            }

            @Generated
            public void setPayId(String payId) {
                this.payId = payId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payto)) {
                    return false;
                }
                Payto other = (Payto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bsbNumber = this.getBsbNumber();
                String other$bsbNumber = other.getBsbNumber();
                if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$mandate = this.getMandate();
                String other$mandate = other.getMandate();
                if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) {
                    return false;
                }
                String this$payId = this.getPayId();
                String other$payId = other.getPayId();
                return !(this$payId == null ? other$payId != null : !this$payId.equals(other$payId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bsbNumber = this.getBsbNumber();
                result = result * 59 + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $mandate = this.getMandate();
                result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
                String $payId = this.getPayId();
                result = result * 59 + ($payId == null ? 43 : $payId.hashCode());
                return result;
            }
        }

        public static class Pix
        extends StripeObject {
            @SerializedName(value="bank_transaction_id")
            String bankTransactionId;

            @Generated
            public String getBankTransactionId() {
                return this.bankTransactionId;
            }

            @Generated
            public void setBankTransactionId(String bankTransactionId) {
                this.bankTransactionId = bankTransactionId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pix)) {
                    return false;
                }
                Pix other = (Pix)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankTransactionId = this.getBankTransactionId();
                String other$bankTransactionId = other.getBankTransactionId();
                return !(this$bankTransactionId == null ? other$bankTransactionId != null : !this$bankTransactionId.equals(other$bankTransactionId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pix;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankTransactionId = this.getBankTransactionId();
                result = result * 59 + ($bankTransactionId == null ? 43 : $bankTransactionId.hashCode());
                return result;
            }
        }

        public static class Promptpay
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Promptpay)) {
                    return false;
                }
                Promptpay other = (Promptpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Promptpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                return result;
            }
        }

        public static class Qris
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Qris)) {
                    return false;
                }
                Qris other = (Qris)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Qris;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Rechnung
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Rechnung)) {
                    return false;
                }
                Rechnung other = (Rechnung)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Rechnung;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class RevolutPay
        extends StripeObject {
            @SerializedName(value="funding")
            Funding funding;

            @Generated
            public Funding getFunding() {
                return this.funding;
            }

            @Generated
            public void setFunding(Funding funding) {
                this.funding = funding;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RevolutPay)) {
                    return false;
                }
                RevolutPay other = (RevolutPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Funding this$funding = this.getFunding();
                Funding other$funding = other.getFunding();
                return !(this$funding == null ? other$funding != null : !((Object)this$funding).equals(other$funding));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RevolutPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Funding $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : ((Object)$funding).hashCode());
                return result;
            }

            public static class Funding
            extends StripeObject {
                @SerializedName(value="card")
                Card card;
                @SerializedName(value="type")
                String type;

                @Generated
                public Card getCard() {
                    return this.card;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setCard(Card card) {
                    this.card = card;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Funding)) {
                        return false;
                    }
                    Funding other = (Funding)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Card this$card = this.getCard();
                    Card other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Funding;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Card $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class Card
                extends StripeObject {
                    @SerializedName(value="brand")
                    String brand;
                    @SerializedName(value="brand_product")
                    String brandProduct;
                    @SerializedName(value="country")
                    String country;
                    @SerializedName(value="exp_month")
                    Long expMonth;
                    @SerializedName(value="exp_year")
                    Long expYear;
                    @SerializedName(value="funding")
                    String funding;
                    @SerializedName(value="last4")
                    String last4;

                    @Generated
                    public String getBrand() {
                        return this.brand;
                    }

                    @Generated
                    public String getBrandProduct() {
                        return this.brandProduct;
                    }

                    @Generated
                    public String getCountry() {
                        return this.country;
                    }

                    @Generated
                    public Long getExpMonth() {
                        return this.expMonth;
                    }

                    @Generated
                    public Long getExpYear() {
                        return this.expYear;
                    }

                    @Generated
                    public String getFunding() {
                        return this.funding;
                    }

                    @Generated
                    public String getLast4() {
                        return this.last4;
                    }

                    @Generated
                    public void setBrand(String brand) {
                        this.brand = brand;
                    }

                    @Generated
                    public void setBrandProduct(String brandProduct) {
                        this.brandProduct = brandProduct;
                    }

                    @Generated
                    public void setCountry(String country) {
                        this.country = country;
                    }

                    @Generated
                    public void setExpMonth(Long expMonth) {
                        this.expMonth = expMonth;
                    }

                    @Generated
                    public void setExpYear(Long expYear) {
                        this.expYear = expYear;
                    }

                    @Generated
                    public void setFunding(String funding) {
                        this.funding = funding;
                    }

                    @Generated
                    public void setLast4(String last4) {
                        this.last4 = last4;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Card)) {
                            return false;
                        }
                        Card other = (Card)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$expMonth = this.getExpMonth();
                        Long other$expMonth = other.getExpMonth();
                        if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                            return false;
                        }
                        Long this$expYear = this.getExpYear();
                        Long other$expYear = other.getExpYear();
                        if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                            return false;
                        }
                        String this$brand = this.getBrand();
                        String other$brand = other.getBrand();
                        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                            return false;
                        }
                        String this$brandProduct = this.getBrandProduct();
                        String other$brandProduct = other.getBrandProduct();
                        if (this$brandProduct == null ? other$brandProduct != null : !this$brandProduct.equals(other$brandProduct)) {
                            return false;
                        }
                        String this$country = this.getCountry();
                        String other$country = other.getCountry();
                        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                            return false;
                        }
                        String this$funding = this.getFunding();
                        String other$funding = other.getFunding();
                        if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                            return false;
                        }
                        String this$last4 = this.getLast4();
                        String other$last4 = other.getLast4();
                        return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Card;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $expMonth = this.getExpMonth();
                        result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                        Long $expYear = this.getExpYear();
                        result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                        String $brand = this.getBrand();
                        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                        String $brandProduct = this.getBrandProduct();
                        result = result * 59 + ($brandProduct == null ? 43 : $brandProduct.hashCode());
                        String $country = this.getCountry();
                        result = result * 59 + ($country == null ? 43 : $country.hashCode());
                        String $funding = this.getFunding();
                        result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                        String $last4 = this.getLast4();
                        result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class SamsungPay
        extends StripeObject {
            @SerializedName(value="buyer_id")
            String buyerId;

            @Generated
            public String getBuyerId() {
                return this.buyerId;
            }

            @Generated
            public void setBuyerId(String buyerId) {
                this.buyerId = buyerId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SamsungPay)) {
                    return false;
                }
                SamsungPay other = (SamsungPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$buyerId = this.getBuyerId();
                String other$buyerId = other.getBuyerId();
                return !(this$buyerId == null ? other$buyerId != null : !this$buyerId.equals(other$buyerId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SamsungPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $buyerId = this.getBuyerId();
                result = result * 59 + ($buyerId == null ? 43 : $buyerId.hashCode());
                return result;
            }
        }

        public static class Satispay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Satispay)) {
                    return false;
                }
                Satispay other = (Satispay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Satispay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class SepaCreditTransfer
        extends StripeObject {
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="iban")
            String iban;

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getIban() {
                return this.iban;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setIban(String iban) {
                this.iban = iban;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaCreditTransfer)) {
                    return false;
                }
                SepaCreditTransfer other = (SepaCreditTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$iban = this.getIban();
                String other$iban = other.getIban();
                return !(this$iban == null ? other$iban != null : !this$iban.equals(other$iban));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaCreditTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $iban = this.getIban();
                result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
                return result;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="branch_code")
            String branchCode;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="mandate")
            String mandate;

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBranchCode() {
                return this.branchCode;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getMandate() {
                return this.mandate;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBranchCode(String branchCode) {
                this.branchCode = branchCode;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setMandate(String mandate) {
                this.mandate = mandate;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$branchCode = this.getBranchCode();
                String other$branchCode = other.getBranchCode();
                if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$mandate = this.getMandate();
                String other$mandate = other.getMandate();
                return !(this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $branchCode = this.getBranchCode();
                result = result * 59 + ($branchCode == null ? 43 : $branchCode.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $mandate = this.getMandate();
                result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
                return result;
            }
        }

        public static class Shopeepay
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Shopeepay)) {
                    return false;
                }
                Shopeepay other = (Shopeepay)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Shopeepay;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Sofort
        extends StripeObject {
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="bic")
            String bic;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="generated_sepa_debit")
            ExpandableField<PaymentMethod> generatedSepaDebit;
            @SerializedName(value="generated_sepa_debit_mandate")
            ExpandableField<Mandate> generatedSepaDebitMandate;
            @SerializedName(value="iban_last4")
            String ibanLast4;
            @SerializedName(value="preferred_language")
            String preferredLanguage;
            @SerializedName(value="verified_name")
            String verifiedName;

            public String getGeneratedSepaDebit() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getId() : null;
            }

            public void setGeneratedSepaDebit(String id) {
                this.generatedSepaDebit = ApiResource.setExpandableFieldId(id, this.generatedSepaDebit);
            }

            public PaymentMethod getGeneratedSepaDebitObject() {
                return this.generatedSepaDebit != null ? this.generatedSepaDebit.getExpanded() : null;
            }

            public void setGeneratedSepaDebitObject(PaymentMethod expandableObject) {
                this.generatedSepaDebit = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
            }

            public String getGeneratedSepaDebitMandate() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getId() : null;
            }

            public void setGeneratedSepaDebitMandate(String id) {
                this.generatedSepaDebitMandate = ApiResource.setExpandableFieldId(id, this.generatedSepaDebitMandate);
            }

            public Mandate getGeneratedSepaDebitMandateObject() {
                return this.generatedSepaDebitMandate != null ? this.generatedSepaDebitMandate.getExpanded() : null;
            }

            public void setGeneratedSepaDebitMandateObject(Mandate expandableObject) {
                this.generatedSepaDebitMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getBic() {
                return this.bic;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getIbanLast4() {
                return this.ibanLast4;
            }

            @Generated
            public String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public String getVerifiedName() {
                return this.verifiedName;
            }

            @Generated
            public void setBankCode(String bankCode) {
                this.bankCode = bankCode;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setBic(String bic) {
                this.bic = bic;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setIbanLast4(String ibanLast4) {
                this.ibanLast4 = ibanLast4;
            }

            @Generated
            public void setPreferredLanguage(String preferredLanguage) {
                this.preferredLanguage = preferredLanguage;
            }

            @Generated
            public void setVerifiedName(String verifiedName) {
                this.verifiedName = verifiedName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$bic = this.getBic();
                String other$bic = other.getBic();
                if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$generatedSepaDebit = this.getGeneratedSepaDebit();
                String other$generatedSepaDebit = other.getGeneratedSepaDebit();
                if (this$generatedSepaDebit == null ? other$generatedSepaDebit != null : !this$generatedSepaDebit.equals(other$generatedSepaDebit)) {
                    return false;
                }
                String this$generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                String other$generatedSepaDebitMandate = other.getGeneratedSepaDebitMandate();
                if (this$generatedSepaDebitMandate == null ? other$generatedSepaDebitMandate != null : !this$generatedSepaDebitMandate.equals(other$generatedSepaDebitMandate)) {
                    return false;
                }
                String this$ibanLast4 = this.getIbanLast4();
                String other$ibanLast4 = other.getIbanLast4();
                if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                    return false;
                }
                String this$preferredLanguage = this.getPreferredLanguage();
                String other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                String this$verifiedName = this.getVerifiedName();
                String other$verifiedName = other.getVerifiedName();
                return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $bic = this.getBic();
                result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $generatedSepaDebit = this.getGeneratedSepaDebit();
                result = result * 59 + ($generatedSepaDebit == null ? 43 : $generatedSepaDebit.hashCode());
                String $generatedSepaDebitMandate = this.getGeneratedSepaDebitMandate();
                result = result * 59 + ($generatedSepaDebitMandate == null ? 43 : $generatedSepaDebitMandate.hashCode());
                String $ibanLast4 = this.getIbanLast4();
                result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
                String $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                String $verifiedName = this.getVerifiedName();
                result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
                return result;
            }
        }

        public static class StripeAccount
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StripeAccount)) {
                    return false;
                }
                StripeAccount other = (StripeAccount)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StripeAccount;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class StripeBalance
        extends StripeObject {
            @SerializedName(value="account")
            String account;
            @SerializedName(value="source_type")
            String sourceType;

            @Generated
            public String getAccount() {
                return this.account;
            }

            @Generated
            public String getSourceType() {
                return this.sourceType;
            }

            @Generated
            public void setAccount(String account) {
                this.account = account;
            }

            @Generated
            public void setSourceType(String sourceType) {
                this.sourceType = sourceType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StripeBalance)) {
                    return false;
                }
                StripeBalance other = (StripeBalance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$account = this.getAccount();
                String other$account = other.getAccount();
                if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                    return false;
                }
                String this$sourceType = this.getSourceType();
                String other$sourceType = other.getSourceType();
                return !(this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StripeBalance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $account = this.getAccount();
                result = result * 59 + ($account == null ? 43 : $account.hashCode());
                String $sourceType = this.getSourceType();
                result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
                return result;
            }
        }

        public static class Swish
        extends StripeObject {
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="payment_reference")
            String paymentReference;
            @SerializedName(value="verified_phone_last4")
            String verifiedPhoneLast4;

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getPaymentReference() {
                return this.paymentReference;
            }

            @Generated
            public String getVerifiedPhoneLast4() {
                return this.verifiedPhoneLast4;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setPaymentReference(String paymentReference) {
                this.paymentReference = paymentReference;
            }

            @Generated
            public void setVerifiedPhoneLast4(String verifiedPhoneLast4) {
                this.verifiedPhoneLast4 = verifiedPhoneLast4;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Swish)) {
                    return false;
                }
                Swish other = (Swish)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$paymentReference = this.getPaymentReference();
                String other$paymentReference = other.getPaymentReference();
                if (this$paymentReference == null ? other$paymentReference != null : !this$paymentReference.equals(other$paymentReference)) {
                    return false;
                }
                String this$verifiedPhoneLast4 = this.getVerifiedPhoneLast4();
                String other$verifiedPhoneLast4 = other.getVerifiedPhoneLast4();
                return !(this$verifiedPhoneLast4 == null ? other$verifiedPhoneLast4 != null : !this$verifiedPhoneLast4.equals(other$verifiedPhoneLast4));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Swish;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $paymentReference = this.getPaymentReference();
                result = result * 59 + ($paymentReference == null ? 43 : $paymentReference.hashCode());
                String $verifiedPhoneLast4 = this.getVerifiedPhoneLast4();
                result = result * 59 + ($verifiedPhoneLast4 == null ? 43 : $verifiedPhoneLast4.hashCode());
                return result;
            }
        }

        public static class Twint
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Twint)) {
                    return false;
                }
                Twint other = (Twint)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Twint;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="account_holder_type")
            String accountHolderType;
            @SerializedName(value="account_type")
            String accountType;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="mandate")
            ExpandableField<Mandate> mandate;
            @SerializedName(value="payment_reference")
            String paymentReference;
            @SerializedName(value="routing_number")
            String routingNumber;

            public String getMandate() {
                return this.mandate != null ? this.mandate.getId() : null;
            }

            public void setMandate(String id) {
                this.mandate = ApiResource.setExpandableFieldId(id, this.mandate);
            }

            public Mandate getMandateObject() {
                return this.mandate != null ? this.mandate.getExpanded() : null;
            }

            public void setMandateObject(Mandate expandableObject) {
                this.mandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getAccountType() {
                return this.accountType;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getPaymentReference() {
                return this.paymentReference;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public void setAccountHolderType(String accountHolderType) {
                this.accountHolderType = accountHolderType;
            }

            @Generated
            public void setAccountType(String accountType) {
                this.accountType = accountType;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setPaymentReference(String paymentReference) {
                this.paymentReference = paymentReference;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderType = this.getAccountHolderType();
                String other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$accountType = this.getAccountType();
                String other$accountType = other.getAccountType();
                if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$mandate = this.getMandate();
                String other$mandate = other.getMandate();
                if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) {
                    return false;
                }
                String this$paymentReference = this.getPaymentReference();
                String other$paymentReference = other.getPaymentReference();
                if (this$paymentReference == null ? other$paymentReference != null : !this$paymentReference.equals(other$paymentReference)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $accountType = this.getAccountType();
                result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $mandate = this.getMandate();
                result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
                String $paymentReference = this.getPaymentReference();
                result = result * 59 + ($paymentReference == null ? 43 : $paymentReference.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                return result;
            }
        }

        public static class Wechat
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Wechat)) {
                    return false;
                }
                Wechat other = (Wechat)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Wechat;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class WechatPay
        extends StripeObject {
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="location")
            String location;
            @SerializedName(value="reader")
            String reader;
            @SerializedName(value="transaction_id")
            String transactionId;

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLocation() {
                return this.location;
            }

            @Generated
            public String getReader() {
                return this.reader;
            }

            @Generated
            public String getTransactionId() {
                return this.transactionId;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLocation(String location) {
                this.location = location;
            }

            @Generated
            public void setReader(String reader) {
                this.reader = reader;
            }

            @Generated
            public void setTransactionId(String transactionId) {
                this.transactionId = transactionId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPay)) {
                    return false;
                }
                WechatPay other = (WechatPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$location = this.getLocation();
                String other$location = other.getLocation();
                if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                    return false;
                }
                String this$reader = this.getReader();
                String other$reader = other.getReader();
                if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
                    return false;
                }
                String this$transactionId = this.getTransactionId();
                String other$transactionId = other.getTransactionId();
                return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $location = this.getLocation();
                result = result * 59 + ($location == null ? 43 : $location.hashCode());
                String $reader = this.getReader();
                result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
                String $transactionId = this.getTransactionId();
                result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                return result;
            }
        }

        public static class Zip
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Zip)) {
                    return false;
                }
                Zip other = (Zip)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Zip;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }
    }

    public static class ShippingDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingDetails)) {
                return false;
            }
            ShippingDetails other = (ShippingDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }

        public static class Address
        extends StripeObject {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public void setCity(String city) {
                this.city = city;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setLine1(String line1) {
                this.line1 = line1;
            }

            @Generated
            public void setLine2(String line2) {
                this.line2 = line2;
            }

            @Generated
            public void setPostalCode(String postalCode) {
                this.postalCode = postalCode;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Address)) {
                    return false;
                }
                Address other = (Address)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$city = this.getCity();
                String other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$line1 = this.getLine1();
                String other$line1 = other.getLine1();
                if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                    return false;
                }
                String this$line2 = this.getLine2();
                String other$line2 = other.getLine2();
                if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                    return false;
                }
                String this$postalCode = this.getPostalCode();
                String other$postalCode = other.getPostalCode();
                if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                return !(this$state == null ? other$state != null : !this$state.equals(other$state));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Address;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $line1 = this.getLine1();
                result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                String $line2 = this.getLine2();
                result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                String $postalCode = this.getPostalCode();
                result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                return result;
            }
        }
    }
}

